/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceSourceControlAConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the Windows or Linux Web App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#app_id AppServiceSourceControlA#app_id}
    */
    readonly appId: string;
    /**
    * The branch name to use for deployments.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#branch AppServiceSourceControlA#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#id AppServiceSourceControlA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The URL for the repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#repo_url AppServiceSourceControlA#repo_url}
    */
    readonly repoUrl?: string;
    /**
    * Should the Deployment Rollback be enabled? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#rollback_enabled AppServiceSourceControlA#rollback_enabled}
    */
    readonly rollbackEnabled?: boolean | cdktf.IResolvable;
    /**
    * Should the App use local Git configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#use_local_git AppServiceSourceControlA#use_local_git}
    */
    readonly useLocalGit?: boolean | cdktf.IResolvable;
    /**
    * Should code be deployed manually. Set to `false` to enable continuous integration, such as webhooks into online repos such as GitHub. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#use_manual_integration AppServiceSourceControlA#use_manual_integration}
    */
    readonly useManualIntegration?: boolean | cdktf.IResolvable;
    /**
    * The repository specified is Mercurial. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#use_mercurial AppServiceSourceControlA#use_mercurial}
    */
    readonly useMercurial?: boolean | cdktf.IResolvable;
    /**
    * github_action_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#github_action_configuration AppServiceSourceControlA#github_action_configuration}
    */
    readonly githubActionConfiguration?: AppServiceSourceControlGithubActionConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#timeouts AppServiceSourceControlA#timeouts}
    */
    readonly timeouts?: AppServiceSourceControlTimeouts;
}
export interface AppServiceSourceControlGithubActionConfigurationCodeConfiguration {
    /**
    * The value to use for the Runtime Stack in the workflow file content for code base apps.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#runtime_stack AppServiceSourceControlA#runtime_stack}
    */
    readonly runtimeStack: string;
    /**
    * The value to use for the Runtime Version in the workflow file content for code base apps.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#runtime_version AppServiceSourceControlA#runtime_version}
    */
    readonly runtimeVersion: string;
}
export declare function appServiceSourceControlGithubActionConfigurationCodeConfigurationToTerraform(struct?: AppServiceSourceControlGithubActionConfigurationCodeConfigurationOutputReference | AppServiceSourceControlGithubActionConfigurationCodeConfiguration): any;
export declare function appServiceSourceControlGithubActionConfigurationCodeConfigurationToHclTerraform(struct?: AppServiceSourceControlGithubActionConfigurationCodeConfigurationOutputReference | AppServiceSourceControlGithubActionConfigurationCodeConfiguration): any;
export declare class AppServiceSourceControlGithubActionConfigurationCodeConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlGithubActionConfigurationCodeConfiguration | undefined;
    set internalValue(value: AppServiceSourceControlGithubActionConfigurationCodeConfiguration | undefined);
    private _runtimeStack?;
    get runtimeStack(): string;
    set runtimeStack(value: string);
    get runtimeStackInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    get runtimeVersionInput(): string | undefined;
}
export interface AppServiceSourceControlGithubActionConfigurationContainerConfiguration {
    /**
    * The image name for the build.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#image_name AppServiceSourceControlA#image_name}
    */
    readonly imageName: string;
    /**
    * The password used to upload the image to the container registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#registry_password AppServiceSourceControlA#registry_password}
    */
    readonly registryPassword?: string;
    /**
    * The server URL for the container registry where the build will be hosted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#registry_url AppServiceSourceControlA#registry_url}
    */
    readonly registryUrl: string;
    /**
    * The username used to upload the image to the container registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#registry_username AppServiceSourceControlA#registry_username}
    */
    readonly registryUsername?: string;
}
export declare function appServiceSourceControlGithubActionConfigurationContainerConfigurationToTerraform(struct?: AppServiceSourceControlGithubActionConfigurationContainerConfigurationOutputReference | AppServiceSourceControlGithubActionConfigurationContainerConfiguration): any;
export declare function appServiceSourceControlGithubActionConfigurationContainerConfigurationToHclTerraform(struct?: AppServiceSourceControlGithubActionConfigurationContainerConfigurationOutputReference | AppServiceSourceControlGithubActionConfigurationContainerConfiguration): any;
export declare class AppServiceSourceControlGithubActionConfigurationContainerConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlGithubActionConfigurationContainerConfiguration | undefined;
    set internalValue(value: AppServiceSourceControlGithubActionConfigurationContainerConfiguration | undefined);
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    private _registryPassword?;
    get registryPassword(): string;
    set registryPassword(value: string);
    resetRegistryPassword(): void;
    get registryPasswordInput(): string | undefined;
    private _registryUrl?;
    get registryUrl(): string;
    set registryUrl(value: string);
    get registryUrlInput(): string | undefined;
    private _registryUsername?;
    get registryUsername(): string;
    set registryUsername(value: string);
    resetRegistryUsername(): void;
    get registryUsernameInput(): string | undefined;
}
export interface AppServiceSourceControlGithubActionConfiguration {
    /**
    * Should the service generate the GitHub Action Workflow file. Defaults to `true`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#generate_workflow_file AppServiceSourceControlA#generate_workflow_file}
    */
    readonly generateWorkflowFile?: boolean | cdktf.IResolvable;
    /**
    * code_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#code_configuration AppServiceSourceControlA#code_configuration}
    */
    readonly codeConfiguration?: AppServiceSourceControlGithubActionConfigurationCodeConfiguration;
    /**
    * container_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#container_configuration AppServiceSourceControlA#container_configuration}
    */
    readonly containerConfiguration?: AppServiceSourceControlGithubActionConfigurationContainerConfiguration;
}
export declare function appServiceSourceControlGithubActionConfigurationToTerraform(struct?: AppServiceSourceControlGithubActionConfigurationOutputReference | AppServiceSourceControlGithubActionConfiguration): any;
export declare function appServiceSourceControlGithubActionConfigurationToHclTerraform(struct?: AppServiceSourceControlGithubActionConfigurationOutputReference | AppServiceSourceControlGithubActionConfiguration): any;
export declare class AppServiceSourceControlGithubActionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlGithubActionConfiguration | undefined;
    set internalValue(value: AppServiceSourceControlGithubActionConfiguration | undefined);
    private _generateWorkflowFile?;
    get generateWorkflowFile(): boolean | cdktf.IResolvable;
    set generateWorkflowFile(value: boolean | cdktf.IResolvable);
    resetGenerateWorkflowFile(): void;
    get generateWorkflowFileInput(): boolean | cdktf.IResolvable | undefined;
    get linuxAction(): cdktf.IResolvable;
    private _codeConfiguration;
    get codeConfiguration(): AppServiceSourceControlGithubActionConfigurationCodeConfigurationOutputReference;
    putCodeConfiguration(value: AppServiceSourceControlGithubActionConfigurationCodeConfiguration): void;
    resetCodeConfiguration(): void;
    get codeConfigurationInput(): AppServiceSourceControlGithubActionConfigurationCodeConfiguration | undefined;
    private _containerConfiguration;
    get containerConfiguration(): AppServiceSourceControlGithubActionConfigurationContainerConfigurationOutputReference;
    putContainerConfiguration(value: AppServiceSourceControlGithubActionConfigurationContainerConfiguration): void;
    resetContainerConfiguration(): void;
    get containerConfigurationInput(): AppServiceSourceControlGithubActionConfigurationContainerConfiguration | undefined;
}
export interface AppServiceSourceControlTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#create AppServiceSourceControlA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#delete AppServiceSourceControlA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#read AppServiceSourceControlA#read}
    */
    readonly read?: string;
}
export declare function appServiceSourceControlTimeoutsToTerraform(struct?: AppServiceSourceControlTimeouts | cdktf.IResolvable): any;
export declare function appServiceSourceControlTimeoutsToHclTerraform(struct?: AppServiceSourceControlTimeouts | cdktf.IResolvable): any;
export declare class AppServiceSourceControlTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSourceControlTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control azurerm_app_service_source_control}
*/
export declare class AppServiceSourceControlA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_source_control";
    /**
    * Generates CDKTF code for importing a AppServiceSourceControlA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceSourceControlA to import
    * @param importFromId The id of the existing AppServiceSourceControlA that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceSourceControlA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/app_service_source_control azurerm_app_service_source_control} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceSourceControlAConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceSourceControlAConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _repoUrl?;
    get repoUrl(): string;
    set repoUrl(value: string);
    resetRepoUrl(): void;
    get repoUrlInput(): string | undefined;
    private _rollbackEnabled?;
    get rollbackEnabled(): boolean | cdktf.IResolvable;
    set rollbackEnabled(value: boolean | cdktf.IResolvable);
    resetRollbackEnabled(): void;
    get rollbackEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get scmType(): string;
    private _useLocalGit?;
    get useLocalGit(): boolean | cdktf.IResolvable;
    set useLocalGit(value: boolean | cdktf.IResolvable);
    resetUseLocalGit(): void;
    get useLocalGitInput(): boolean | cdktf.IResolvable | undefined;
    private _useManualIntegration?;
    get useManualIntegration(): boolean | cdktf.IResolvable;
    set useManualIntegration(value: boolean | cdktf.IResolvable);
    resetUseManualIntegration(): void;
    get useManualIntegrationInput(): boolean | cdktf.IResolvable | undefined;
    private _useMercurial?;
    get useMercurial(): boolean | cdktf.IResolvable;
    set useMercurial(value: boolean | cdktf.IResolvable);
    resetUseMercurial(): void;
    get useMercurialInput(): boolean | cdktf.IResolvable | undefined;
    get usesGithubAction(): cdktf.IResolvable;
    private _githubActionConfiguration;
    get githubActionConfiguration(): AppServiceSourceControlGithubActionConfigurationOutputReference;
    putGithubActionConfiguration(value: AppServiceSourceControlGithubActionConfiguration): void;
    resetGithubActionConfiguration(): void;
    get githubActionConfigurationInput(): AppServiceSourceControlGithubActionConfiguration | undefined;
    private _timeouts;
    get timeouts(): AppServiceSourceControlTimeoutsOutputReference;
    putTimeouts(value: AppServiceSourceControlTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceSourceControlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
