/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomanageConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#automation_account_enabled AutomanageConfiguration#automation_account_enabled}
    */
    readonly automationAccountEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#boot_diagnostics_enabled AutomanageConfiguration#boot_diagnostics_enabled}
    */
    readonly bootDiagnosticsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#defender_for_cloud_enabled AutomanageConfiguration#defender_for_cloud_enabled}
    */
    readonly defenderForCloudEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#guest_configuration_enabled AutomanageConfiguration#guest_configuration_enabled}
    */
    readonly guestConfigurationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#id AutomanageConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#location AutomanageConfiguration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#log_analytics_enabled AutomanageConfiguration#log_analytics_enabled}
    */
    readonly logAnalyticsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#name AutomanageConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#resource_group_name AutomanageConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#status_change_alert_enabled AutomanageConfiguration#status_change_alert_enabled}
    */
    readonly statusChangeAlertEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#tags AutomanageConfiguration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * antimalware block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#antimalware AutomanageConfiguration#antimalware}
    */
    readonly antimalware?: AutomanageConfigurationAntimalware;
    /**
    * azure_security_baseline block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#azure_security_baseline AutomanageConfiguration#azure_security_baseline}
    */
    readonly azureSecurityBaseline?: AutomanageConfigurationAzureSecurityBaseline;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#backup AutomanageConfiguration#backup}
    */
    readonly backup?: AutomanageConfigurationBackup;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#timeouts AutomanageConfiguration#timeouts}
    */
    readonly timeouts?: AutomanageConfigurationTimeouts;
}
export interface AutomanageConfigurationAntimalwareExclusions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#extensions AutomanageConfiguration#extensions}
    */
    readonly extensions?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#paths AutomanageConfiguration#paths}
    */
    readonly paths?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#processes AutomanageConfiguration#processes}
    */
    readonly processes?: string;
}
export declare function automanageConfigurationAntimalwareExclusionsToTerraform(struct?: AutomanageConfigurationAntimalwareExclusionsOutputReference | AutomanageConfigurationAntimalwareExclusions): any;
export declare function automanageConfigurationAntimalwareExclusionsToHclTerraform(struct?: AutomanageConfigurationAntimalwareExclusionsOutputReference | AutomanageConfigurationAntimalwareExclusions): any;
export declare class AutomanageConfigurationAntimalwareExclusionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationAntimalwareExclusions | undefined;
    set internalValue(value: AutomanageConfigurationAntimalwareExclusions | undefined);
    private _extensions?;
    get extensions(): string;
    set extensions(value: string);
    resetExtensions(): void;
    get extensionsInput(): string | undefined;
    private _paths?;
    get paths(): string;
    set paths(value: string);
    resetPaths(): void;
    get pathsInput(): string | undefined;
    private _processes?;
    get processes(): string;
    set processes(value: string);
    resetProcesses(): void;
    get processesInput(): string | undefined;
}
export interface AutomanageConfigurationAntimalware {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#real_time_protection_enabled AutomanageConfiguration#real_time_protection_enabled}
    */
    readonly realTimeProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#scheduled_scan_day AutomanageConfiguration#scheduled_scan_day}
    */
    readonly scheduledScanDay?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#scheduled_scan_enabled AutomanageConfiguration#scheduled_scan_enabled}
    */
    readonly scheduledScanEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#scheduled_scan_time_in_minutes AutomanageConfiguration#scheduled_scan_time_in_minutes}
    */
    readonly scheduledScanTimeInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#scheduled_scan_type AutomanageConfiguration#scheduled_scan_type}
    */
    readonly scheduledScanType?: string;
    /**
    * exclusions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#exclusions AutomanageConfiguration#exclusions}
    */
    readonly exclusions?: AutomanageConfigurationAntimalwareExclusions;
}
export declare function automanageConfigurationAntimalwareToTerraform(struct?: AutomanageConfigurationAntimalwareOutputReference | AutomanageConfigurationAntimalware): any;
export declare function automanageConfigurationAntimalwareToHclTerraform(struct?: AutomanageConfigurationAntimalwareOutputReference | AutomanageConfigurationAntimalware): any;
export declare class AutomanageConfigurationAntimalwareOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationAntimalware | undefined;
    set internalValue(value: AutomanageConfigurationAntimalware | undefined);
    private _realTimeProtectionEnabled?;
    get realTimeProtectionEnabled(): boolean | cdktf.IResolvable;
    set realTimeProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetRealTimeProtectionEnabled(): void;
    get realTimeProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scheduledScanDay?;
    get scheduledScanDay(): number;
    set scheduledScanDay(value: number);
    resetScheduledScanDay(): void;
    get scheduledScanDayInput(): number | undefined;
    private _scheduledScanEnabled?;
    get scheduledScanEnabled(): boolean | cdktf.IResolvable;
    set scheduledScanEnabled(value: boolean | cdktf.IResolvable);
    resetScheduledScanEnabled(): void;
    get scheduledScanEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scheduledScanTimeInMinutes?;
    get scheduledScanTimeInMinutes(): number;
    set scheduledScanTimeInMinutes(value: number);
    resetScheduledScanTimeInMinutes(): void;
    get scheduledScanTimeInMinutesInput(): number | undefined;
    private _scheduledScanType?;
    get scheduledScanType(): string;
    set scheduledScanType(value: string);
    resetScheduledScanType(): void;
    get scheduledScanTypeInput(): string | undefined;
    private _exclusions;
    get exclusions(): AutomanageConfigurationAntimalwareExclusionsOutputReference;
    putExclusions(value: AutomanageConfigurationAntimalwareExclusions): void;
    resetExclusions(): void;
    get exclusionsInput(): AutomanageConfigurationAntimalwareExclusions | undefined;
}
export interface AutomanageConfigurationAzureSecurityBaseline {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#assignment_type AutomanageConfiguration#assignment_type}
    */
    readonly assignmentType?: string;
}
export declare function automanageConfigurationAzureSecurityBaselineToTerraform(struct?: AutomanageConfigurationAzureSecurityBaselineOutputReference | AutomanageConfigurationAzureSecurityBaseline): any;
export declare function automanageConfigurationAzureSecurityBaselineToHclTerraform(struct?: AutomanageConfigurationAzureSecurityBaselineOutputReference | AutomanageConfigurationAzureSecurityBaseline): any;
export declare class AutomanageConfigurationAzureSecurityBaselineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationAzureSecurityBaseline | undefined;
    set internalValue(value: AutomanageConfigurationAzureSecurityBaseline | undefined);
    private _assignmentType?;
    get assignmentType(): string;
    set assignmentType(value: string);
    resetAssignmentType(): void;
    get assignmentTypeInput(): string | undefined;
}
export interface AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDuration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#count AutomanageConfiguration#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#duration_type AutomanageConfiguration#duration_type}
    */
    readonly durationType?: string;
}
export declare function automanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDurationToTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDurationOutputReference | AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDuration): any;
export declare function automanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDurationToHclTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDurationOutputReference | AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDuration): any;
export declare class AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDuration | undefined;
    set internalValue(value: AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDuration | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _durationType?;
    get durationType(): string;
    set durationType(value: string);
    resetDurationType(): void;
    get durationTypeInput(): string | undefined;
}
export interface AutomanageConfigurationBackupRetentionPolicyDailySchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#retention_times AutomanageConfiguration#retention_times}
    */
    readonly retentionTimes?: string[];
    /**
    * retention_duration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#retention_duration AutomanageConfiguration#retention_duration}
    */
    readonly retentionDuration?: AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDuration;
}
export declare function automanageConfigurationBackupRetentionPolicyDailyScheduleToTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyDailyScheduleOutputReference | AutomanageConfigurationBackupRetentionPolicyDailySchedule): any;
export declare function automanageConfigurationBackupRetentionPolicyDailyScheduleToHclTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyDailyScheduleOutputReference | AutomanageConfigurationBackupRetentionPolicyDailySchedule): any;
export declare class AutomanageConfigurationBackupRetentionPolicyDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationBackupRetentionPolicyDailySchedule | undefined;
    set internalValue(value: AutomanageConfigurationBackupRetentionPolicyDailySchedule | undefined);
    private _retentionTimes?;
    get retentionTimes(): string[];
    set retentionTimes(value: string[]);
    resetRetentionTimes(): void;
    get retentionTimesInput(): string[] | undefined;
    private _retentionDuration;
    get retentionDuration(): AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDurationOutputReference;
    putRetentionDuration(value: AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDuration): void;
    resetRetentionDuration(): void;
    get retentionDurationInput(): AutomanageConfigurationBackupRetentionPolicyDailyScheduleRetentionDuration | undefined;
}
export interface AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDuration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#count AutomanageConfiguration#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#duration_type AutomanageConfiguration#duration_type}
    */
    readonly durationType?: string;
}
export declare function automanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDurationToTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDurationOutputReference | AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDuration): any;
export declare function automanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDurationToHclTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDurationOutputReference | AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDuration): any;
export declare class AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDuration | undefined;
    set internalValue(value: AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDuration | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _durationType?;
    get durationType(): string;
    set durationType(value: string);
    resetDurationType(): void;
    get durationTypeInput(): string | undefined;
}
export interface AutomanageConfigurationBackupRetentionPolicyWeeklySchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#retention_times AutomanageConfiguration#retention_times}
    */
    readonly retentionTimes?: string[];
    /**
    * retention_duration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#retention_duration AutomanageConfiguration#retention_duration}
    */
    readonly retentionDuration?: AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDuration;
}
export declare function automanageConfigurationBackupRetentionPolicyWeeklyScheduleToTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleOutputReference | AutomanageConfigurationBackupRetentionPolicyWeeklySchedule): any;
export declare function automanageConfigurationBackupRetentionPolicyWeeklyScheduleToHclTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleOutputReference | AutomanageConfigurationBackupRetentionPolicyWeeklySchedule): any;
export declare class AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationBackupRetentionPolicyWeeklySchedule | undefined;
    set internalValue(value: AutomanageConfigurationBackupRetentionPolicyWeeklySchedule | undefined);
    private _retentionTimes?;
    get retentionTimes(): string[];
    set retentionTimes(value: string[]);
    resetRetentionTimes(): void;
    get retentionTimesInput(): string[] | undefined;
    private _retentionDuration;
    get retentionDuration(): AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDurationOutputReference;
    putRetentionDuration(value: AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDuration): void;
    resetRetentionDuration(): void;
    get retentionDurationInput(): AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleRetentionDuration | undefined;
}
export interface AutomanageConfigurationBackupRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#retention_policy_type AutomanageConfiguration#retention_policy_type}
    */
    readonly retentionPolicyType?: string;
    /**
    * daily_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#daily_schedule AutomanageConfiguration#daily_schedule}
    */
    readonly dailySchedule?: AutomanageConfigurationBackupRetentionPolicyDailySchedule;
    /**
    * weekly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#weekly_schedule AutomanageConfiguration#weekly_schedule}
    */
    readonly weeklySchedule?: AutomanageConfigurationBackupRetentionPolicyWeeklySchedule;
}
export declare function automanageConfigurationBackupRetentionPolicyToTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyOutputReference | AutomanageConfigurationBackupRetentionPolicy): any;
export declare function automanageConfigurationBackupRetentionPolicyToHclTerraform(struct?: AutomanageConfigurationBackupRetentionPolicyOutputReference | AutomanageConfigurationBackupRetentionPolicy): any;
export declare class AutomanageConfigurationBackupRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationBackupRetentionPolicy | undefined;
    set internalValue(value: AutomanageConfigurationBackupRetentionPolicy | undefined);
    private _retentionPolicyType?;
    get retentionPolicyType(): string;
    set retentionPolicyType(value: string);
    resetRetentionPolicyType(): void;
    get retentionPolicyTypeInput(): string | undefined;
    private _dailySchedule;
    get dailySchedule(): AutomanageConfigurationBackupRetentionPolicyDailyScheduleOutputReference;
    putDailySchedule(value: AutomanageConfigurationBackupRetentionPolicyDailySchedule): void;
    resetDailySchedule(): void;
    get dailyScheduleInput(): AutomanageConfigurationBackupRetentionPolicyDailySchedule | undefined;
    private _weeklySchedule;
    get weeklySchedule(): AutomanageConfigurationBackupRetentionPolicyWeeklyScheduleOutputReference;
    putWeeklySchedule(value: AutomanageConfigurationBackupRetentionPolicyWeeklySchedule): void;
    resetWeeklySchedule(): void;
    get weeklyScheduleInput(): AutomanageConfigurationBackupRetentionPolicyWeeklySchedule | undefined;
}
export interface AutomanageConfigurationBackupSchedulePolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#schedule_policy_type AutomanageConfiguration#schedule_policy_type}
    */
    readonly schedulePolicyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#schedule_run_days AutomanageConfiguration#schedule_run_days}
    */
    readonly scheduleRunDays?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#schedule_run_frequency AutomanageConfiguration#schedule_run_frequency}
    */
    readonly scheduleRunFrequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#schedule_run_times AutomanageConfiguration#schedule_run_times}
    */
    readonly scheduleRunTimes?: string[];
}
export declare function automanageConfigurationBackupSchedulePolicyToTerraform(struct?: AutomanageConfigurationBackupSchedulePolicyOutputReference | AutomanageConfigurationBackupSchedulePolicy): any;
export declare function automanageConfigurationBackupSchedulePolicyToHclTerraform(struct?: AutomanageConfigurationBackupSchedulePolicyOutputReference | AutomanageConfigurationBackupSchedulePolicy): any;
export declare class AutomanageConfigurationBackupSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationBackupSchedulePolicy | undefined;
    set internalValue(value: AutomanageConfigurationBackupSchedulePolicy | undefined);
    private _schedulePolicyType?;
    get schedulePolicyType(): string;
    set schedulePolicyType(value: string);
    resetSchedulePolicyType(): void;
    get schedulePolicyTypeInput(): string | undefined;
    private _scheduleRunDays?;
    get scheduleRunDays(): string[];
    set scheduleRunDays(value: string[]);
    resetScheduleRunDays(): void;
    get scheduleRunDaysInput(): string[] | undefined;
    private _scheduleRunFrequency?;
    get scheduleRunFrequency(): string;
    set scheduleRunFrequency(value: string);
    resetScheduleRunFrequency(): void;
    get scheduleRunFrequencyInput(): string | undefined;
    private _scheduleRunTimes?;
    get scheduleRunTimes(): string[];
    set scheduleRunTimes(value: string[]);
    resetScheduleRunTimes(): void;
    get scheduleRunTimesInput(): string[] | undefined;
}
export interface AutomanageConfigurationBackup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#instant_rp_retention_range_in_days AutomanageConfiguration#instant_rp_retention_range_in_days}
    */
    readonly instantRpRetentionRangeInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#policy_name AutomanageConfiguration#policy_name}
    */
    readonly policyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#time_zone AutomanageConfiguration#time_zone}
    */
    readonly timeZone?: string;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#retention_policy AutomanageConfiguration#retention_policy}
    */
    readonly retentionPolicy?: AutomanageConfigurationBackupRetentionPolicy;
    /**
    * schedule_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#schedule_policy AutomanageConfiguration#schedule_policy}
    */
    readonly schedulePolicy?: AutomanageConfigurationBackupSchedulePolicy;
}
export declare function automanageConfigurationBackupToTerraform(struct?: AutomanageConfigurationBackupOutputReference | AutomanageConfigurationBackup): any;
export declare function automanageConfigurationBackupToHclTerraform(struct?: AutomanageConfigurationBackupOutputReference | AutomanageConfigurationBackup): any;
export declare class AutomanageConfigurationBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationBackup | undefined;
    set internalValue(value: AutomanageConfigurationBackup | undefined);
    private _instantRpRetentionRangeInDays?;
    get instantRpRetentionRangeInDays(): number;
    set instantRpRetentionRangeInDays(value: number);
    resetInstantRpRetentionRangeInDays(): void;
    get instantRpRetentionRangeInDaysInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _retentionPolicy;
    get retentionPolicy(): AutomanageConfigurationBackupRetentionPolicyOutputReference;
    putRetentionPolicy(value: AutomanageConfigurationBackupRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): AutomanageConfigurationBackupRetentionPolicy | undefined;
    private _schedulePolicy;
    get schedulePolicy(): AutomanageConfigurationBackupSchedulePolicyOutputReference;
    putSchedulePolicy(value: AutomanageConfigurationBackupSchedulePolicy): void;
    resetSchedulePolicy(): void;
    get schedulePolicyInput(): AutomanageConfigurationBackupSchedulePolicy | undefined;
}
export interface AutomanageConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#create AutomanageConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#delete AutomanageConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#read AutomanageConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#update AutomanageConfiguration#update}
    */
    readonly update?: string;
}
export declare function automanageConfigurationTimeoutsToTerraform(struct?: AutomanageConfigurationTimeouts | cdktf.IResolvable): any;
export declare function automanageConfigurationTimeoutsToHclTerraform(struct?: AutomanageConfigurationTimeouts | cdktf.IResolvable): any;
export declare class AutomanageConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomanageConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomanageConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration azurerm_automanage_configuration}
*/
export declare class AutomanageConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automanage_configuration";
    /**
    * Generates CDKTF code for importing a AutomanageConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomanageConfiguration to import
    * @param importFromId The id of the existing AutomanageConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomanageConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automanage_configuration azurerm_automanage_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomanageConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: AutomanageConfigurationConfig);
    private _automationAccountEnabled?;
    get automationAccountEnabled(): boolean | cdktf.IResolvable;
    set automationAccountEnabled(value: boolean | cdktf.IResolvable);
    resetAutomationAccountEnabled(): void;
    get automationAccountEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _bootDiagnosticsEnabled?;
    get bootDiagnosticsEnabled(): boolean | cdktf.IResolvable;
    set bootDiagnosticsEnabled(value: boolean | cdktf.IResolvable);
    resetBootDiagnosticsEnabled(): void;
    get bootDiagnosticsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _defenderForCloudEnabled?;
    get defenderForCloudEnabled(): boolean | cdktf.IResolvable;
    set defenderForCloudEnabled(value: boolean | cdktf.IResolvable);
    resetDefenderForCloudEnabled(): void;
    get defenderForCloudEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _guestConfigurationEnabled?;
    get guestConfigurationEnabled(): boolean | cdktf.IResolvable;
    set guestConfigurationEnabled(value: boolean | cdktf.IResolvable);
    resetGuestConfigurationEnabled(): void;
    get guestConfigurationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _logAnalyticsEnabled?;
    get logAnalyticsEnabled(): boolean | cdktf.IResolvable;
    set logAnalyticsEnabled(value: boolean | cdktf.IResolvable);
    resetLogAnalyticsEnabled(): void;
    get logAnalyticsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _statusChangeAlertEnabled?;
    get statusChangeAlertEnabled(): boolean | cdktf.IResolvable;
    set statusChangeAlertEnabled(value: boolean | cdktf.IResolvable);
    resetStatusChangeAlertEnabled(): void;
    get statusChangeAlertEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _antimalware;
    get antimalware(): AutomanageConfigurationAntimalwareOutputReference;
    putAntimalware(value: AutomanageConfigurationAntimalware): void;
    resetAntimalware(): void;
    get antimalwareInput(): AutomanageConfigurationAntimalware | undefined;
    private _azureSecurityBaseline;
    get azureSecurityBaseline(): AutomanageConfigurationAzureSecurityBaselineOutputReference;
    putAzureSecurityBaseline(value: AutomanageConfigurationAzureSecurityBaseline): void;
    resetAzureSecurityBaseline(): void;
    get azureSecurityBaselineInput(): AutomanageConfigurationAzureSecurityBaseline | undefined;
    private _backup;
    get backup(): AutomanageConfigurationBackupOutputReference;
    putBackup(value: AutomanageConfigurationBackup): void;
    resetBackup(): void;
    get backupInput(): AutomanageConfigurationBackup | undefined;
    private _timeouts;
    get timeouts(): AutomanageConfigurationTimeoutsOutputReference;
    putTimeouts(value: AutomanageConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomanageConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
