/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationConnectionTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#automation_account_name AutomationConnectionType#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#id AutomationConnectionType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#is_global AutomationConnectionType#is_global}
    */
    readonly isGlobal?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#name AutomationConnectionType#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#resource_group_name AutomationConnectionType#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * field block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#field AutomationConnectionType#field}
    */
    readonly field: AutomationConnectionTypeField[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#timeouts AutomationConnectionType#timeouts}
    */
    readonly timeouts?: AutomationConnectionTypeTimeouts;
}
export interface AutomationConnectionTypeField {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#is_encrypted AutomationConnectionType#is_encrypted}
    */
    readonly isEncrypted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#is_optional AutomationConnectionType#is_optional}
    */
    readonly isOptional?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#name AutomationConnectionType#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#type AutomationConnectionType#type}
    */
    readonly type: string;
}
export declare function automationConnectionTypeFieldToTerraform(struct?: AutomationConnectionTypeField | cdktf.IResolvable): any;
export declare function automationConnectionTypeFieldToHclTerraform(struct?: AutomationConnectionTypeField | cdktf.IResolvable): any;
export declare class AutomationConnectionTypeFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutomationConnectionTypeField | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationConnectionTypeField | cdktf.IResolvable | undefined);
    private _isEncrypted?;
    get isEncrypted(): boolean | cdktf.IResolvable;
    set isEncrypted(value: boolean | cdktf.IResolvable);
    resetIsEncrypted(): void;
    get isEncryptedInput(): boolean | cdktf.IResolvable | undefined;
    private _isOptional?;
    get isOptional(): boolean | cdktf.IResolvable;
    set isOptional(value: boolean | cdktf.IResolvable);
    resetIsOptional(): void;
    get isOptionalInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class AutomationConnectionTypeFieldList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AutomationConnectionTypeField[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutomationConnectionTypeFieldOutputReference;
}
export interface AutomationConnectionTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#create AutomationConnectionType#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#delete AutomationConnectionType#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#read AutomationConnectionType#read}
    */
    readonly read?: string;
}
export declare function automationConnectionTypeTimeoutsToTerraform(struct?: AutomationConnectionTypeTimeouts | cdktf.IResolvable): any;
export declare function automationConnectionTypeTimeoutsToHclTerraform(struct?: AutomationConnectionTypeTimeouts | cdktf.IResolvable): any;
export declare class AutomationConnectionTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationConnectionTypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationConnectionTypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type azurerm_automation_connection_type}
*/
export declare class AutomationConnectionType extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_connection_type";
    /**
    * Generates CDKTF code for importing a AutomationConnectionType resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationConnectionType to import
    * @param importFromId The id of the existing AutomationConnectionType that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationConnectionType to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_connection_type azurerm_automation_connection_type} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationConnectionTypeConfig
    */
    constructor(scope: Construct, id: string, config: AutomationConnectionTypeConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isGlobal?;
    get isGlobal(): boolean | cdktf.IResolvable;
    set isGlobal(value: boolean | cdktf.IResolvable);
    resetIsGlobal(): void;
    get isGlobalInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _field;
    get field(): AutomationConnectionTypeFieldList;
    putField(value: AutomationConnectionTypeField[] | cdktf.IResolvable): void;
    get fieldInput(): cdktf.IResolvable | AutomationConnectionTypeField[] | undefined;
    private _timeouts;
    get timeouts(): AutomationConnectionTypeTimeoutsOutputReference;
    putTimeouts(value: AutomationConnectionTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationConnectionTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
