/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#automation_account_name AutomationSchedule#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#description AutomationSchedule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#expiry_time AutomationSchedule#expiry_time}
    */
    readonly expiryTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#frequency AutomationSchedule#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#id AutomationSchedule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#interval AutomationSchedule#interval}
    */
    readonly interval?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#month_days AutomationSchedule#month_days}
    */
    readonly monthDays?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#name AutomationSchedule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#resource_group_name AutomationSchedule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#start_time AutomationSchedule#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#timezone AutomationSchedule#timezone}
    */
    readonly timezone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#week_days AutomationSchedule#week_days}
    */
    readonly weekDays?: string[];
    /**
    * monthly_occurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#monthly_occurrence AutomationSchedule#monthly_occurrence}
    */
    readonly monthlyOccurrence?: AutomationScheduleMonthlyOccurrence;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#timeouts AutomationSchedule#timeouts}
    */
    readonly timeouts?: AutomationScheduleTimeouts;
}
export interface AutomationScheduleMonthlyOccurrence {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#day AutomationSchedule#day}
    */
    readonly day: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#occurrence AutomationSchedule#occurrence}
    */
    readonly occurrence: number;
}
export declare function automationScheduleMonthlyOccurrenceToTerraform(struct?: AutomationScheduleMonthlyOccurrenceOutputReference | AutomationScheduleMonthlyOccurrence): any;
export declare function automationScheduleMonthlyOccurrenceToHclTerraform(struct?: AutomationScheduleMonthlyOccurrenceOutputReference | AutomationScheduleMonthlyOccurrence): any;
export declare class AutomationScheduleMonthlyOccurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationScheduleMonthlyOccurrence | undefined;
    set internalValue(value: AutomationScheduleMonthlyOccurrence | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    get dayInput(): string | undefined;
    private _occurrence?;
    get occurrence(): number;
    set occurrence(value: number);
    get occurrenceInput(): number | undefined;
}
export interface AutomationScheduleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#create AutomationSchedule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#delete AutomationSchedule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#read AutomationSchedule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#update AutomationSchedule#update}
    */
    readonly update?: string;
}
export declare function automationScheduleTimeoutsToTerraform(struct?: AutomationScheduleTimeouts | cdktf.IResolvable): any;
export declare function automationScheduleTimeoutsToHclTerraform(struct?: AutomationScheduleTimeouts | cdktf.IResolvable): any;
export declare class AutomationScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationScheduleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationScheduleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule azurerm_automation_schedule}
*/
export declare class AutomationSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_schedule";
    /**
    * Generates CDKTF code for importing a AutomationSchedule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationSchedule to import
    * @param importFromId The id of the existing AutomationSchedule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationSchedule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_schedule azurerm_automation_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationScheduleConfig
    */
    constructor(scope: Construct, id: string, config: AutomationScheduleConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expiryTime?;
    get expiryTime(): string;
    set expiryTime(value: string);
    resetExpiryTime(): void;
    get expiryTimeInput(): string | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _monthDays?;
    get monthDays(): number[];
    set monthDays(value: number[]);
    resetMonthDays(): void;
    get monthDaysInput(): number[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _weekDays?;
    get weekDays(): string[];
    set weekDays(value: string[]);
    resetWeekDays(): void;
    get weekDaysInput(): string[] | undefined;
    private _monthlyOccurrence;
    get monthlyOccurrence(): AutomationScheduleMonthlyOccurrenceOutputReference;
    putMonthlyOccurrence(value: AutomationScheduleMonthlyOccurrence): void;
    resetMonthlyOccurrence(): void;
    get monthlyOccurrenceInput(): AutomationScheduleMonthlyOccurrence | undefined;
    private _timeouts;
    get timeouts(): AutomationScheduleTimeoutsOutputReference;
    putTimeouts(value: AutomationScheduleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationScheduleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
