/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationSoftwareUpdateConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#automation_account_id AutomationSoftwareUpdateConfiguration#automation_account_id}
    */
    readonly automationAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#duration AutomationSoftwareUpdateConfiguration#duration}
    */
    readonly duration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#id AutomationSoftwareUpdateConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#name AutomationSoftwareUpdateConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#non_azure_computer_names AutomationSoftwareUpdateConfiguration#non_azure_computer_names}
    */
    readonly nonAzureComputerNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#operating_system AutomationSoftwareUpdateConfiguration#operating_system}
    */
    readonly operatingSystem?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#virtual_machine_ids AutomationSoftwareUpdateConfiguration#virtual_machine_ids}
    */
    readonly virtualMachineIds?: string[];
    /**
    * linux block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#linux AutomationSoftwareUpdateConfiguration#linux}
    */
    readonly linux?: AutomationSoftwareUpdateConfigurationLinux;
    /**
    * post_task block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#post_task AutomationSoftwareUpdateConfiguration#post_task}
    */
    readonly postTask?: AutomationSoftwareUpdateConfigurationPostTask;
    /**
    * pre_task block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#pre_task AutomationSoftwareUpdateConfiguration#pre_task}
    */
    readonly preTask?: AutomationSoftwareUpdateConfigurationPreTask;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#schedule AutomationSoftwareUpdateConfiguration#schedule}
    */
    readonly schedule: AutomationSoftwareUpdateConfigurationSchedule;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#target AutomationSoftwareUpdateConfiguration#target}
    */
    readonly target?: AutomationSoftwareUpdateConfigurationTarget;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#timeouts AutomationSoftwareUpdateConfiguration#timeouts}
    */
    readonly timeouts?: AutomationSoftwareUpdateConfigurationTimeouts;
    /**
    * windows block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#windows AutomationSoftwareUpdateConfiguration#windows}
    */
    readonly windows?: AutomationSoftwareUpdateConfigurationWindows;
}
export interface AutomationSoftwareUpdateConfigurationLinux {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#classification_included AutomationSoftwareUpdateConfiguration#classification_included}
    */
    readonly classificationIncluded?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#classifications_included AutomationSoftwareUpdateConfiguration#classifications_included}
    */
    readonly classificationsIncluded?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#excluded_packages AutomationSoftwareUpdateConfiguration#excluded_packages}
    */
    readonly excludedPackages?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#included_packages AutomationSoftwareUpdateConfiguration#included_packages}
    */
    readonly includedPackages?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#reboot AutomationSoftwareUpdateConfiguration#reboot}
    */
    readonly reboot?: string;
}
export declare function automationSoftwareUpdateConfigurationLinuxToTerraform(struct?: AutomationSoftwareUpdateConfigurationLinuxOutputReference | AutomationSoftwareUpdateConfigurationLinux): any;
export declare function automationSoftwareUpdateConfigurationLinuxToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationLinuxOutputReference | AutomationSoftwareUpdateConfigurationLinux): any;
export declare class AutomationSoftwareUpdateConfigurationLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSoftwareUpdateConfigurationLinux | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationLinux | undefined);
    private _classificationIncluded?;
    get classificationIncluded(): string;
    set classificationIncluded(value: string);
    resetClassificationIncluded(): void;
    get classificationIncludedInput(): string | undefined;
    private _classificationsIncluded?;
    get classificationsIncluded(): string[];
    set classificationsIncluded(value: string[]);
    resetClassificationsIncluded(): void;
    get classificationsIncludedInput(): string[] | undefined;
    private _excludedPackages?;
    get excludedPackages(): string[];
    set excludedPackages(value: string[]);
    resetExcludedPackages(): void;
    get excludedPackagesInput(): string[] | undefined;
    private _includedPackages?;
    get includedPackages(): string[];
    set includedPackages(value: string[]);
    resetIncludedPackages(): void;
    get includedPackagesInput(): string[] | undefined;
    private _reboot?;
    get reboot(): string;
    set reboot(value: string);
    resetReboot(): void;
    get rebootInput(): string | undefined;
}
export interface AutomationSoftwareUpdateConfigurationPostTask {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#parameters AutomationSoftwareUpdateConfiguration#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#source AutomationSoftwareUpdateConfiguration#source}
    */
    readonly source?: string;
}
export declare function automationSoftwareUpdateConfigurationPostTaskToTerraform(struct?: AutomationSoftwareUpdateConfigurationPostTaskOutputReference | AutomationSoftwareUpdateConfigurationPostTask): any;
export declare function automationSoftwareUpdateConfigurationPostTaskToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationPostTaskOutputReference | AutomationSoftwareUpdateConfigurationPostTask): any;
export declare class AutomationSoftwareUpdateConfigurationPostTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSoftwareUpdateConfigurationPostTask | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationPostTask | undefined);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface AutomationSoftwareUpdateConfigurationPreTask {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#parameters AutomationSoftwareUpdateConfiguration#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#source AutomationSoftwareUpdateConfiguration#source}
    */
    readonly source?: string;
}
export declare function automationSoftwareUpdateConfigurationPreTaskToTerraform(struct?: AutomationSoftwareUpdateConfigurationPreTaskOutputReference | AutomationSoftwareUpdateConfigurationPreTask): any;
export declare function automationSoftwareUpdateConfigurationPreTaskToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationPreTaskOutputReference | AutomationSoftwareUpdateConfigurationPreTask): any;
export declare class AutomationSoftwareUpdateConfigurationPreTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSoftwareUpdateConfigurationPreTask | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationPreTask | undefined);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export interface AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrence {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#day AutomationSoftwareUpdateConfiguration#day}
    */
    readonly day: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#occurrence AutomationSoftwareUpdateConfiguration#occurrence}
    */
    readonly occurrence: number;
}
export declare function automationSoftwareUpdateConfigurationScheduleMonthlyOccurrenceToTerraform(struct?: AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrenceOutputReference | AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrence): any;
export declare function automationSoftwareUpdateConfigurationScheduleMonthlyOccurrenceToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrenceOutputReference | AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrence): any;
export declare class AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrence | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrence | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    get dayInput(): string | undefined;
    private _occurrence?;
    get occurrence(): number;
    set occurrence(value: number);
    get occurrenceInput(): number | undefined;
}
export interface AutomationSoftwareUpdateConfigurationSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#advanced_month_days AutomationSoftwareUpdateConfiguration#advanced_month_days}
    */
    readonly advancedMonthDays?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#advanced_week_days AutomationSoftwareUpdateConfiguration#advanced_week_days}
    */
    readonly advancedWeekDays?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#description AutomationSoftwareUpdateConfiguration#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#expiry_time AutomationSoftwareUpdateConfiguration#expiry_time}
    */
    readonly expiryTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#expiry_time_offset_minutes AutomationSoftwareUpdateConfiguration#expiry_time_offset_minutes}
    */
    readonly expiryTimeOffsetMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#frequency AutomationSoftwareUpdateConfiguration#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#interval AutomationSoftwareUpdateConfiguration#interval}
    */
    readonly interval?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#is_enabled AutomationSoftwareUpdateConfiguration#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#next_run AutomationSoftwareUpdateConfiguration#next_run}
    */
    readonly nextRun?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#next_run_offset_minutes AutomationSoftwareUpdateConfiguration#next_run_offset_minutes}
    */
    readonly nextRunOffsetMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#start_time AutomationSoftwareUpdateConfiguration#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#start_time_offset_minutes AutomationSoftwareUpdateConfiguration#start_time_offset_minutes}
    */
    readonly startTimeOffsetMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#time_zone AutomationSoftwareUpdateConfiguration#time_zone}
    */
    readonly timeZone?: string;
    /**
    * monthly_occurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#monthly_occurrence AutomationSoftwareUpdateConfiguration#monthly_occurrence}
    */
    readonly monthlyOccurrence?: AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrence;
}
export declare function automationSoftwareUpdateConfigurationScheduleToTerraform(struct?: AutomationSoftwareUpdateConfigurationScheduleOutputReference | AutomationSoftwareUpdateConfigurationSchedule): any;
export declare function automationSoftwareUpdateConfigurationScheduleToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationScheduleOutputReference | AutomationSoftwareUpdateConfigurationSchedule): any;
export declare class AutomationSoftwareUpdateConfigurationScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSoftwareUpdateConfigurationSchedule | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationSchedule | undefined);
    private _advancedMonthDays?;
    get advancedMonthDays(): number[];
    set advancedMonthDays(value: number[]);
    resetAdvancedMonthDays(): void;
    get advancedMonthDaysInput(): number[] | undefined;
    private _advancedWeekDays?;
    get advancedWeekDays(): string[];
    set advancedWeekDays(value: string[]);
    resetAdvancedWeekDays(): void;
    get advancedWeekDaysInput(): string[] | undefined;
    get creationTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expiryTime?;
    get expiryTime(): string;
    set expiryTime(value: string);
    resetExpiryTime(): void;
    get expiryTimeInput(): string | undefined;
    private _expiryTimeOffsetMinutes?;
    get expiryTimeOffsetMinutes(): number;
    set expiryTimeOffsetMinutes(value: number);
    resetExpiryTimeOffsetMinutes(): void;
    get expiryTimeOffsetMinutesInput(): number | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get lastModifiedTime(): string;
    private _nextRun?;
    get nextRun(): string;
    set nextRun(value: string);
    resetNextRun(): void;
    get nextRunInput(): string | undefined;
    private _nextRunOffsetMinutes?;
    get nextRunOffsetMinutes(): number;
    set nextRunOffsetMinutes(value: number);
    resetNextRunOffsetMinutes(): void;
    get nextRunOffsetMinutesInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _startTimeOffsetMinutes?;
    get startTimeOffsetMinutes(): number;
    set startTimeOffsetMinutes(value: number);
    resetStartTimeOffsetMinutes(): void;
    get startTimeOffsetMinutesInput(): number | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _monthlyOccurrence;
    get monthlyOccurrence(): AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrenceOutputReference;
    putMonthlyOccurrence(value: AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrence): void;
    resetMonthlyOccurrence(): void;
    get monthlyOccurrenceInput(): AutomationSoftwareUpdateConfigurationScheduleMonthlyOccurrence | undefined;
}
export interface AutomationSoftwareUpdateConfigurationTargetAzureQueryTags {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#tag AutomationSoftwareUpdateConfiguration#tag}
    */
    readonly tag: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#values AutomationSoftwareUpdateConfiguration#values}
    */
    readonly values: string[];
}
export declare function automationSoftwareUpdateConfigurationTargetAzureQueryTagsToTerraform(struct?: AutomationSoftwareUpdateConfigurationTargetAzureQueryTags | cdktf.IResolvable): any;
export declare function automationSoftwareUpdateConfigurationTargetAzureQueryTagsToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationTargetAzureQueryTags | cdktf.IResolvable): any;
export declare class AutomationSoftwareUpdateConfigurationTargetAzureQueryTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutomationSoftwareUpdateConfigurationTargetAzureQueryTags | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationTargetAzureQueryTags | cdktf.IResolvable | undefined);
    private _tag?;
    get tag(): string;
    set tag(value: string);
    get tagInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class AutomationSoftwareUpdateConfigurationTargetAzureQueryTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AutomationSoftwareUpdateConfigurationTargetAzureQueryTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutomationSoftwareUpdateConfigurationTargetAzureQueryTagsOutputReference;
}
export interface AutomationSoftwareUpdateConfigurationTargetAzureQuery {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#locations AutomationSoftwareUpdateConfiguration#locations}
    */
    readonly locations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#scope AutomationSoftwareUpdateConfiguration#scope}
    */
    readonly scope?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#tag_filter AutomationSoftwareUpdateConfiguration#tag_filter}
    */
    readonly tagFilter?: string;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#tags AutomationSoftwareUpdateConfiguration#tags}
    */
    readonly tags?: AutomationSoftwareUpdateConfigurationTargetAzureQueryTags[] | cdktf.IResolvable;
}
export declare function automationSoftwareUpdateConfigurationTargetAzureQueryToTerraform(struct?: AutomationSoftwareUpdateConfigurationTargetAzureQuery | cdktf.IResolvable): any;
export declare function automationSoftwareUpdateConfigurationTargetAzureQueryToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationTargetAzureQuery | cdktf.IResolvable): any;
export declare class AutomationSoftwareUpdateConfigurationTargetAzureQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutomationSoftwareUpdateConfigurationTargetAzureQuery | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationTargetAzureQuery | cdktf.IResolvable | undefined);
    private _locations?;
    get locations(): string[];
    set locations(value: string[]);
    resetLocations(): void;
    get locationsInput(): string[] | undefined;
    private _scope?;
    get scope(): string[];
    set scope(value: string[]);
    resetScope(): void;
    get scopeInput(): string[] | undefined;
    private _tagFilter?;
    get tagFilter(): string;
    set tagFilter(value: string);
    resetTagFilter(): void;
    get tagFilterInput(): string | undefined;
    private _tags;
    get tags(): AutomationSoftwareUpdateConfigurationTargetAzureQueryTagsList;
    putTags(value: AutomationSoftwareUpdateConfigurationTargetAzureQueryTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | AutomationSoftwareUpdateConfigurationTargetAzureQueryTags[] | undefined;
}
export declare class AutomationSoftwareUpdateConfigurationTargetAzureQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AutomationSoftwareUpdateConfigurationTargetAzureQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutomationSoftwareUpdateConfigurationTargetAzureQueryOutputReference;
}
export interface AutomationSoftwareUpdateConfigurationTargetNonAzureQuery {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#function_alias AutomationSoftwareUpdateConfiguration#function_alias}
    */
    readonly functionAlias?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#workspace_id AutomationSoftwareUpdateConfiguration#workspace_id}
    */
    readonly workspaceId?: string;
}
export declare function automationSoftwareUpdateConfigurationTargetNonAzureQueryToTerraform(struct?: AutomationSoftwareUpdateConfigurationTargetNonAzureQuery | cdktf.IResolvable): any;
export declare function automationSoftwareUpdateConfigurationTargetNonAzureQueryToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationTargetNonAzureQuery | cdktf.IResolvable): any;
export declare class AutomationSoftwareUpdateConfigurationTargetNonAzureQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutomationSoftwareUpdateConfigurationTargetNonAzureQuery | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationTargetNonAzureQuery | cdktf.IResolvable | undefined);
    private _functionAlias?;
    get functionAlias(): string;
    set functionAlias(value: string);
    resetFunctionAlias(): void;
    get functionAliasInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    resetWorkspaceId(): void;
    get workspaceIdInput(): string | undefined;
}
export declare class AutomationSoftwareUpdateConfigurationTargetNonAzureQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AutomationSoftwareUpdateConfigurationTargetNonAzureQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutomationSoftwareUpdateConfigurationTargetNonAzureQueryOutputReference;
}
export interface AutomationSoftwareUpdateConfigurationTarget {
    /**
    * azure_query block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#azure_query AutomationSoftwareUpdateConfiguration#azure_query}
    */
    readonly azureQuery?: AutomationSoftwareUpdateConfigurationTargetAzureQuery[] | cdktf.IResolvable;
    /**
    * non_azure_query block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#non_azure_query AutomationSoftwareUpdateConfiguration#non_azure_query}
    */
    readonly nonAzureQuery?: AutomationSoftwareUpdateConfigurationTargetNonAzureQuery[] | cdktf.IResolvable;
}
export declare function automationSoftwareUpdateConfigurationTargetToTerraform(struct?: AutomationSoftwareUpdateConfigurationTargetOutputReference | AutomationSoftwareUpdateConfigurationTarget): any;
export declare function automationSoftwareUpdateConfigurationTargetToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationTargetOutputReference | AutomationSoftwareUpdateConfigurationTarget): any;
export declare class AutomationSoftwareUpdateConfigurationTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSoftwareUpdateConfigurationTarget | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationTarget | undefined);
    private _azureQuery;
    get azureQuery(): AutomationSoftwareUpdateConfigurationTargetAzureQueryList;
    putAzureQuery(value: AutomationSoftwareUpdateConfigurationTargetAzureQuery[] | cdktf.IResolvable): void;
    resetAzureQuery(): void;
    get azureQueryInput(): cdktf.IResolvable | AutomationSoftwareUpdateConfigurationTargetAzureQuery[] | undefined;
    private _nonAzureQuery;
    get nonAzureQuery(): AutomationSoftwareUpdateConfigurationTargetNonAzureQueryList;
    putNonAzureQuery(value: AutomationSoftwareUpdateConfigurationTargetNonAzureQuery[] | cdktf.IResolvable): void;
    resetNonAzureQuery(): void;
    get nonAzureQueryInput(): cdktf.IResolvable | AutomationSoftwareUpdateConfigurationTargetNonAzureQuery[] | undefined;
}
export interface AutomationSoftwareUpdateConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#create AutomationSoftwareUpdateConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#delete AutomationSoftwareUpdateConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#read AutomationSoftwareUpdateConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#update AutomationSoftwareUpdateConfiguration#update}
    */
    readonly update?: string;
}
export declare function automationSoftwareUpdateConfigurationTimeoutsToTerraform(struct?: AutomationSoftwareUpdateConfigurationTimeouts | cdktf.IResolvable): any;
export declare function automationSoftwareUpdateConfigurationTimeoutsToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationTimeouts | cdktf.IResolvable): any;
export declare class AutomationSoftwareUpdateConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSoftwareUpdateConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface AutomationSoftwareUpdateConfigurationWindows {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#classification_included AutomationSoftwareUpdateConfiguration#classification_included}
    */
    readonly classificationIncluded?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#classifications_included AutomationSoftwareUpdateConfiguration#classifications_included}
    */
    readonly classificationsIncluded?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#excluded_knowledge_base_numbers AutomationSoftwareUpdateConfiguration#excluded_knowledge_base_numbers}
    */
    readonly excludedKnowledgeBaseNumbers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#included_knowledge_base_numbers AutomationSoftwareUpdateConfiguration#included_knowledge_base_numbers}
    */
    readonly includedKnowledgeBaseNumbers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#reboot AutomationSoftwareUpdateConfiguration#reboot}
    */
    readonly reboot?: string;
}
export declare function automationSoftwareUpdateConfigurationWindowsToTerraform(struct?: AutomationSoftwareUpdateConfigurationWindowsOutputReference | AutomationSoftwareUpdateConfigurationWindows): any;
export declare function automationSoftwareUpdateConfigurationWindowsToHclTerraform(struct?: AutomationSoftwareUpdateConfigurationWindowsOutputReference | AutomationSoftwareUpdateConfigurationWindows): any;
export declare class AutomationSoftwareUpdateConfigurationWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSoftwareUpdateConfigurationWindows | undefined;
    set internalValue(value: AutomationSoftwareUpdateConfigurationWindows | undefined);
    private _classificationIncluded?;
    get classificationIncluded(): string;
    set classificationIncluded(value: string);
    resetClassificationIncluded(): void;
    get classificationIncludedInput(): string | undefined;
    private _classificationsIncluded?;
    get classificationsIncluded(): string[];
    set classificationsIncluded(value: string[]);
    resetClassificationsIncluded(): void;
    get classificationsIncludedInput(): string[] | undefined;
    private _excludedKnowledgeBaseNumbers?;
    get excludedKnowledgeBaseNumbers(): string[];
    set excludedKnowledgeBaseNumbers(value: string[]);
    resetExcludedKnowledgeBaseNumbers(): void;
    get excludedKnowledgeBaseNumbersInput(): string[] | undefined;
    private _includedKnowledgeBaseNumbers?;
    get includedKnowledgeBaseNumbers(): string[];
    set includedKnowledgeBaseNumbers(value: string[]);
    resetIncludedKnowledgeBaseNumbers(): void;
    get includedKnowledgeBaseNumbersInput(): string[] | undefined;
    private _reboot?;
    get reboot(): string;
    set reboot(value: string);
    resetReboot(): void;
    get rebootInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration azurerm_automation_software_update_configuration}
*/
export declare class AutomationSoftwareUpdateConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_software_update_configuration";
    /**
    * Generates CDKTF code for importing a AutomationSoftwareUpdateConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationSoftwareUpdateConfiguration to import
    * @param importFromId The id of the existing AutomationSoftwareUpdateConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationSoftwareUpdateConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/automation_software_update_configuration azurerm_automation_software_update_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationSoftwareUpdateConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: AutomationSoftwareUpdateConfigurationConfig);
    private _automationAccountId?;
    get automationAccountId(): string;
    set automationAccountId(value: string);
    get automationAccountIdInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
    get errorCode(): string;
    get errorMeesage(): string;
    get errorMessage(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nonAzureComputerNames?;
    get nonAzureComputerNames(): string[];
    set nonAzureComputerNames(value: string[]);
    resetNonAzureComputerNames(): void;
    get nonAzureComputerNamesInput(): string[] | undefined;
    private _operatingSystem?;
    get operatingSystem(): string;
    set operatingSystem(value: string);
    resetOperatingSystem(): void;
    get operatingSystemInput(): string | undefined;
    private _virtualMachineIds?;
    get virtualMachineIds(): string[];
    set virtualMachineIds(value: string[]);
    resetVirtualMachineIds(): void;
    get virtualMachineIdsInput(): string[] | undefined;
    private _linux;
    get linux(): AutomationSoftwareUpdateConfigurationLinuxOutputReference;
    putLinux(value: AutomationSoftwareUpdateConfigurationLinux): void;
    resetLinux(): void;
    get linuxInput(): AutomationSoftwareUpdateConfigurationLinux | undefined;
    private _postTask;
    get postTask(): AutomationSoftwareUpdateConfigurationPostTaskOutputReference;
    putPostTask(value: AutomationSoftwareUpdateConfigurationPostTask): void;
    resetPostTask(): void;
    get postTaskInput(): AutomationSoftwareUpdateConfigurationPostTask | undefined;
    private _preTask;
    get preTask(): AutomationSoftwareUpdateConfigurationPreTaskOutputReference;
    putPreTask(value: AutomationSoftwareUpdateConfigurationPreTask): void;
    resetPreTask(): void;
    get preTaskInput(): AutomationSoftwareUpdateConfigurationPreTask | undefined;
    private _schedule;
    get schedule(): AutomationSoftwareUpdateConfigurationScheduleOutputReference;
    putSchedule(value: AutomationSoftwareUpdateConfigurationSchedule): void;
    get scheduleInput(): AutomationSoftwareUpdateConfigurationSchedule | undefined;
    private _target;
    get target(): AutomationSoftwareUpdateConfigurationTargetOutputReference;
    putTarget(value: AutomationSoftwareUpdateConfigurationTarget): void;
    resetTarget(): void;
    get targetInput(): AutomationSoftwareUpdateConfigurationTarget | undefined;
    private _timeouts;
    get timeouts(): AutomationSoftwareUpdateConfigurationTimeoutsOutputReference;
    putTimeouts(value: AutomationSoftwareUpdateConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationSoftwareUpdateConfigurationTimeouts | undefined;
    private _windows;
    get windows(): AutomationSoftwareUpdateConfigurationWindowsOutputReference;
    putWindows(value: AutomationSoftwareUpdateConfigurationWindows): void;
    resetWindows(): void;
    get windowsInput(): AutomationSoftwareUpdateConfigurationWindows | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
