/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ChaosStudioTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#id ChaosStudioTarget#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#location ChaosStudioTarget#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#target_resource_id ChaosStudioTarget#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#target_type ChaosStudioTarget#target_type}
    */
    readonly targetType: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#timeouts ChaosStudioTarget#timeouts}
    */
    readonly timeouts?: ChaosStudioTargetTimeouts;
}
export interface ChaosStudioTargetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#create ChaosStudioTarget#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#delete ChaosStudioTarget#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#read ChaosStudioTarget#read}
    */
    readonly read?: string;
}
export declare function chaosStudioTargetTimeoutsToTerraform(struct?: ChaosStudioTargetTimeouts | cdktf.IResolvable): any;
export declare function chaosStudioTargetTimeoutsToHclTerraform(struct?: ChaosStudioTargetTimeouts | cdktf.IResolvable): any;
export declare class ChaosStudioTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ChaosStudioTargetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ChaosStudioTargetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target azurerm_chaos_studio_target}
*/
export declare class ChaosStudioTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_chaos_studio_target";
    /**
    * Generates CDKTF code for importing a ChaosStudioTarget resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ChaosStudioTarget to import
    * @param importFromId The id of the existing ChaosStudioTarget that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ChaosStudioTarget to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/chaos_studio_target azurerm_chaos_studio_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ChaosStudioTargetConfig
    */
    constructor(scope: Construct, id: string, config: ChaosStudioTargetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _targetType?;
    get targetType(): string;
    set targetType(value: string);
    get targetTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): ChaosStudioTargetTimeoutsOutputReference;
    putTimeouts(value: ChaosStudioTargetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ChaosStudioTargetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
