/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#admin_enabled ContainerRegistry#admin_enabled}
    */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#anonymous_pull_enabled ContainerRegistry#anonymous_pull_enabled}
    */
    readonly anonymousPullEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#data_endpoint_enabled ContainerRegistry#data_endpoint_enabled}
    */
    readonly dataEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#encryption ContainerRegistry#encryption}
    */
    readonly encryption?: ContainerRegistryEncryption[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#export_policy_enabled ContainerRegistry#export_policy_enabled}
    */
    readonly exportPolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#id ContainerRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#location ContainerRegistry#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#name ContainerRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#network_rule_bypass_option ContainerRegistry#network_rule_bypass_option}
    */
    readonly networkRuleBypassOption?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#network_rule_set ContainerRegistry#network_rule_set}
    */
    readonly networkRuleSet?: ContainerRegistryNetworkRuleSet[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#public_network_access_enabled ContainerRegistry#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#quarantine_policy_enabled ContainerRegistry#quarantine_policy_enabled}
    */
    readonly quarantinePolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#resource_group_name ContainerRegistry#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#retention_policy ContainerRegistry#retention_policy}
    */
    readonly retentionPolicy?: ContainerRegistryRetentionPolicy[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#sku ContainerRegistry#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#tags ContainerRegistry#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#trust_policy ContainerRegistry#trust_policy}
    */
    readonly trustPolicy?: ContainerRegistryTrustPolicy[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#zone_redundancy_enabled ContainerRegistry#zone_redundancy_enabled}
    */
    readonly zoneRedundancyEnabled?: boolean | cdktf.IResolvable;
    /**
    * georeplications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#georeplications ContainerRegistry#georeplications}
    */
    readonly georeplications?: ContainerRegistryGeoreplications[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#identity ContainerRegistry#identity}
    */
    readonly identity?: ContainerRegistryIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#timeouts ContainerRegistry#timeouts}
    */
    readonly timeouts?: ContainerRegistryTimeouts;
}
export interface ContainerRegistryEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#enabled ContainerRegistry#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#identity_client_id ContainerRegistry#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#key_vault_key_id ContainerRegistry#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
}
export declare function containerRegistryEncryptionToTerraform(struct?: ContainerRegistryEncryption | cdktf.IResolvable): any;
export declare function containerRegistryEncryptionToHclTerraform(struct?: ContainerRegistryEncryption | cdktf.IResolvable): any;
export declare class ContainerRegistryEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerRegistryEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryEncryption | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _identityClientId?;
    get identityClientId(): string;
    set identityClientId(value: string);
    resetIdentityClientId(): void;
    get identityClientIdInput(): string | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
}
export declare class ContainerRegistryEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerRegistryEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerRegistryEncryptionOutputReference;
}
export interface ContainerRegistryNetworkRuleSetIpRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#action ContainerRegistry#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#ip_range ContainerRegistry#ip_range}
    */
    readonly ipRange?: string;
}
export declare function containerRegistryNetworkRuleSetIpRuleToTerraform(struct?: ContainerRegistryNetworkRuleSetIpRule | cdktf.IResolvable): any;
export declare function containerRegistryNetworkRuleSetIpRuleToHclTerraform(struct?: ContainerRegistryNetworkRuleSetIpRule | cdktf.IResolvable): any;
export declare class ContainerRegistryNetworkRuleSetIpRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerRegistryNetworkRuleSetIpRule | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryNetworkRuleSetIpRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _ipRange?;
    get ipRange(): string;
    set ipRange(value: string);
    resetIpRange(): void;
    get ipRangeInput(): string | undefined;
}
export declare class ContainerRegistryNetworkRuleSetIpRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerRegistryNetworkRuleSetIpRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerRegistryNetworkRuleSetIpRuleOutputReference;
}
export interface ContainerRegistryNetworkRuleSetVirtualNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#action ContainerRegistry#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#subnet_id ContainerRegistry#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function containerRegistryNetworkRuleSetVirtualNetworkToTerraform(struct?: ContainerRegistryNetworkRuleSetVirtualNetwork | cdktf.IResolvable): any;
export declare function containerRegistryNetworkRuleSetVirtualNetworkToHclTerraform(struct?: ContainerRegistryNetworkRuleSetVirtualNetwork | cdktf.IResolvable): any;
export declare class ContainerRegistryNetworkRuleSetVirtualNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerRegistryNetworkRuleSetVirtualNetwork | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryNetworkRuleSetVirtualNetwork | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export declare class ContainerRegistryNetworkRuleSetVirtualNetworkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerRegistryNetworkRuleSetVirtualNetwork[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerRegistryNetworkRuleSetVirtualNetworkOutputReference;
}
export interface ContainerRegistryNetworkRuleSet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#default_action ContainerRegistry#default_action}
    */
    readonly defaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#ip_rule ContainerRegistry#ip_rule}
    */
    readonly ipRule?: ContainerRegistryNetworkRuleSetIpRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#virtual_network ContainerRegistry#virtual_network}
    */
    readonly virtualNetwork?: ContainerRegistryNetworkRuleSetVirtualNetwork[] | cdktf.IResolvable;
}
export declare function containerRegistryNetworkRuleSetToTerraform(struct?: ContainerRegistryNetworkRuleSet | cdktf.IResolvable): any;
export declare function containerRegistryNetworkRuleSetToHclTerraform(struct?: ContainerRegistryNetworkRuleSet | cdktf.IResolvable): any;
export declare class ContainerRegistryNetworkRuleSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerRegistryNetworkRuleSet | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryNetworkRuleSet | cdktf.IResolvable | undefined);
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    resetDefaultAction(): void;
    get defaultActionInput(): string | undefined;
    private _ipRule;
    get ipRule(): ContainerRegistryNetworkRuleSetIpRuleList;
    putIpRule(value: ContainerRegistryNetworkRuleSetIpRule[] | cdktf.IResolvable): void;
    resetIpRule(): void;
    get ipRuleInput(): cdktf.IResolvable | ContainerRegistryNetworkRuleSetIpRule[] | undefined;
    private _virtualNetwork;
    get virtualNetwork(): ContainerRegistryNetworkRuleSetVirtualNetworkList;
    putVirtualNetwork(value: ContainerRegistryNetworkRuleSetVirtualNetwork[] | cdktf.IResolvable): void;
    resetVirtualNetwork(): void;
    get virtualNetworkInput(): cdktf.IResolvable | ContainerRegistryNetworkRuleSetVirtualNetwork[] | undefined;
}
export declare class ContainerRegistryNetworkRuleSetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerRegistryNetworkRuleSet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerRegistryNetworkRuleSetOutputReference;
}
export interface ContainerRegistryRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#days ContainerRegistry#days}
    */
    readonly days?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#enabled ContainerRegistry#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryRetentionPolicyToTerraform(struct?: ContainerRegistryRetentionPolicy | cdktf.IResolvable): any;
export declare function containerRegistryRetentionPolicyToHclTerraform(struct?: ContainerRegistryRetentionPolicy | cdktf.IResolvable): any;
export declare class ContainerRegistryRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerRegistryRetentionPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryRetentionPolicy | cdktf.IResolvable | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ContainerRegistryRetentionPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerRegistryRetentionPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerRegistryRetentionPolicyOutputReference;
}
export interface ContainerRegistryTrustPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#enabled ContainerRegistry#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryTrustPolicyToTerraform(struct?: ContainerRegistryTrustPolicy | cdktf.IResolvable): any;
export declare function containerRegistryTrustPolicyToHclTerraform(struct?: ContainerRegistryTrustPolicy | cdktf.IResolvable): any;
export declare class ContainerRegistryTrustPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerRegistryTrustPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryTrustPolicy | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ContainerRegistryTrustPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerRegistryTrustPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerRegistryTrustPolicyOutputReference;
}
export interface ContainerRegistryGeoreplications {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#location ContainerRegistry#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#regional_endpoint_enabled ContainerRegistry#regional_endpoint_enabled}
    */
    readonly regionalEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#tags ContainerRegistry#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#zone_redundancy_enabled ContainerRegistry#zone_redundancy_enabled}
    */
    readonly zoneRedundancyEnabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryGeoreplicationsToTerraform(struct?: ContainerRegistryGeoreplications | cdktf.IResolvable): any;
export declare function containerRegistryGeoreplicationsToHclTerraform(struct?: ContainerRegistryGeoreplications | cdktf.IResolvable): any;
export declare class ContainerRegistryGeoreplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerRegistryGeoreplications | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryGeoreplications | cdktf.IResolvable | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _regionalEndpointEnabled?;
    get regionalEndpointEnabled(): boolean | cdktf.IResolvable;
    set regionalEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetRegionalEndpointEnabled(): void;
    get regionalEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneRedundancyEnabled?;
    get zoneRedundancyEnabled(): boolean | cdktf.IResolvable;
    set zoneRedundancyEnabled(value: boolean | cdktf.IResolvable);
    resetZoneRedundancyEnabled(): void;
    get zoneRedundancyEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ContainerRegistryGeoreplicationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerRegistryGeoreplications[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerRegistryGeoreplicationsOutputReference;
}
export interface ContainerRegistryIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#identity_ids ContainerRegistry#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#type ContainerRegistry#type}
    */
    readonly type: string;
}
export declare function containerRegistryIdentityToTerraform(struct?: ContainerRegistryIdentityOutputReference | ContainerRegistryIdentity): any;
export declare function containerRegistryIdentityToHclTerraform(struct?: ContainerRegistryIdentityOutputReference | ContainerRegistryIdentity): any;
export declare class ContainerRegistryIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryIdentity | undefined;
    set internalValue(value: ContainerRegistryIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ContainerRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#create ContainerRegistry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#delete ContainerRegistry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#read ContainerRegistry#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#update ContainerRegistry#update}
    */
    readonly update?: string;
}
export declare function containerRegistryTimeoutsToTerraform(struct?: ContainerRegistryTimeouts | cdktf.IResolvable): any;
export declare function containerRegistryTimeoutsToHclTerraform(struct?: ContainerRegistryTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry azurerm_container_registry}
*/
export declare class ContainerRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_registry";
    /**
    * Generates CDKTF code for importing a ContainerRegistry resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerRegistry to import
    * @param importFromId The id of the existing ContainerRegistry that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerRegistry to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/container_registry azurerm_container_registry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryConfig);
    private _adminEnabled?;
    get adminEnabled(): boolean | cdktf.IResolvable;
    set adminEnabled(value: boolean | cdktf.IResolvable);
    resetAdminEnabled(): void;
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get adminPassword(): string;
    get adminUsername(): string;
    private _anonymousPullEnabled?;
    get anonymousPullEnabled(): boolean | cdktf.IResolvable;
    set anonymousPullEnabled(value: boolean | cdktf.IResolvable);
    resetAnonymousPullEnabled(): void;
    get anonymousPullEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEndpointEnabled?;
    get dataEndpointEnabled(): boolean | cdktf.IResolvable;
    set dataEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetDataEndpointEnabled(): void;
    get dataEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encryption;
    get encryption(): ContainerRegistryEncryptionList;
    putEncryption(value: ContainerRegistryEncryption[] | cdktf.IResolvable): void;
    resetEncryption(): void;
    get encryptionInput(): cdktf.IResolvable | ContainerRegistryEncryption[] | undefined;
    private _exportPolicyEnabled?;
    get exportPolicyEnabled(): boolean | cdktf.IResolvable;
    set exportPolicyEnabled(value: boolean | cdktf.IResolvable);
    resetExportPolicyEnabled(): void;
    get exportPolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get loginServer(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkRuleBypassOption?;
    get networkRuleBypassOption(): string;
    set networkRuleBypassOption(value: string);
    resetNetworkRuleBypassOption(): void;
    get networkRuleBypassOptionInput(): string | undefined;
    private _networkRuleSet;
    get networkRuleSet(): ContainerRegistryNetworkRuleSetList;
    putNetworkRuleSet(value: ContainerRegistryNetworkRuleSet[] | cdktf.IResolvable): void;
    resetNetworkRuleSet(): void;
    get networkRuleSetInput(): cdktf.IResolvable | ContainerRegistryNetworkRuleSet[] | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _quarantinePolicyEnabled?;
    get quarantinePolicyEnabled(): boolean | cdktf.IResolvable;
    set quarantinePolicyEnabled(value: boolean | cdktf.IResolvable);
    resetQuarantinePolicyEnabled(): void;
    get quarantinePolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retentionPolicy;
    get retentionPolicy(): ContainerRegistryRetentionPolicyList;
    putRetentionPolicy(value: ContainerRegistryRetentionPolicy[] | cdktf.IResolvable): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): cdktf.IResolvable | ContainerRegistryRetentionPolicy[] | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _trustPolicy;
    get trustPolicy(): ContainerRegistryTrustPolicyList;
    putTrustPolicy(value: ContainerRegistryTrustPolicy[] | cdktf.IResolvable): void;
    resetTrustPolicy(): void;
    get trustPolicyInput(): cdktf.IResolvable | ContainerRegistryTrustPolicy[] | undefined;
    private _zoneRedundancyEnabled?;
    get zoneRedundancyEnabled(): boolean | cdktf.IResolvable;
    set zoneRedundancyEnabled(value: boolean | cdktf.IResolvable);
    resetZoneRedundancyEnabled(): void;
    get zoneRedundancyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _georeplications;
    get georeplications(): ContainerRegistryGeoreplicationsList;
    putGeoreplications(value: ContainerRegistryGeoreplications[] | cdktf.IResolvable): void;
    resetGeoreplications(): void;
    get georeplicationsInput(): cdktf.IResolvable | ContainerRegistryGeoreplications[] | undefined;
    private _identity;
    get identity(): ContainerRegistryIdentityOutputReference;
    putIdentity(value: ContainerRegistryIdentity): void;
    resetIdentity(): void;
    get identityInput(): ContainerRegistryIdentity | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
