/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementApiConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api#api_management_name DataAzurermApiManagementApi#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api#id DataAzurermApiManagementApi#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api#name DataAzurermApiManagementApi#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api#resource_group_name DataAzurermApiManagementApi#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api#revision DataAzurermApiManagementApi#revision}
    */
    readonly revision: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api#timeouts DataAzurermApiManagementApi#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementApiTimeouts;
}
export interface DataAzurermApiManagementApiSubscriptionKeyParameterNames {
}
export declare function dataAzurermApiManagementApiSubscriptionKeyParameterNamesToTerraform(struct?: DataAzurermApiManagementApiSubscriptionKeyParameterNames): any;
export declare function dataAzurermApiManagementApiSubscriptionKeyParameterNamesToHclTerraform(struct?: DataAzurermApiManagementApiSubscriptionKeyParameterNames): any;
export declare class DataAzurermApiManagementApiSubscriptionKeyParameterNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementApiSubscriptionKeyParameterNames | undefined;
    set internalValue(value: DataAzurermApiManagementApiSubscriptionKeyParameterNames | undefined);
    get header(): string;
    get query(): string;
}
export declare class DataAzurermApiManagementApiSubscriptionKeyParameterNamesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementApiSubscriptionKeyParameterNamesOutputReference;
}
export interface DataAzurermApiManagementApiTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api#read DataAzurermApiManagementApi#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementApiTimeoutsToTerraform(struct?: DataAzurermApiManagementApiTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermApiManagementApiTimeoutsToHclTerraform(struct?: DataAzurermApiManagementApiTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementApiTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApiManagementApiTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermApiManagementApiTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api azurerm_api_management_api}
*/
export declare class DataAzurermApiManagementApi extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_api_management_api";
    /**
    * Generates CDKTF code for importing a DataAzurermApiManagementApi resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermApiManagementApi to import
    * @param importFromId The id of the existing DataAzurermApiManagementApi that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermApiManagementApi to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/api_management_api azurerm_api_management_api} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementApiConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementApiConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    get description(): string;
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isCurrent(): cdktf.IResolvable;
    get isOnline(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get path(): string;
    get protocols(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    get revisionInput(): string | undefined;
    get serviceUrl(): string;
    get soapPassThrough(): cdktf.IResolvable;
    private _subscriptionKeyParameterNames;
    get subscriptionKeyParameterNames(): DataAzurermApiManagementApiSubscriptionKeyParameterNamesList;
    get subscriptionRequired(): cdktf.IResolvable;
    get version(): string;
    get versionSetId(): string;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementApiTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementApiTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermApiManagementApiTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
