/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCosmosdbSqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database#account_name DataAzurermCosmosdbSqlDatabase#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database#id DataAzurermCosmosdbSqlDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database#name DataAzurermCosmosdbSqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database#resource_group_name DataAzurermCosmosdbSqlDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database#timeouts DataAzurermCosmosdbSqlDatabase#timeouts}
    */
    readonly timeouts?: DataAzurermCosmosdbSqlDatabaseTimeouts;
}
export interface DataAzurermCosmosdbSqlDatabaseAutoscaleSettings {
}
export declare function dataAzurermCosmosdbSqlDatabaseAutoscaleSettingsToTerraform(struct?: DataAzurermCosmosdbSqlDatabaseAutoscaleSettings): any;
export declare function dataAzurermCosmosdbSqlDatabaseAutoscaleSettingsToHclTerraform(struct?: DataAzurermCosmosdbSqlDatabaseAutoscaleSettings): any;
export declare class DataAzurermCosmosdbSqlDatabaseAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCosmosdbSqlDatabaseAutoscaleSettings | undefined;
    set internalValue(value: DataAzurermCosmosdbSqlDatabaseAutoscaleSettings | undefined);
    get maxThroughput(): number;
}
export declare class DataAzurermCosmosdbSqlDatabaseAutoscaleSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCosmosdbSqlDatabaseAutoscaleSettingsOutputReference;
}
export interface DataAzurermCosmosdbSqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database#read DataAzurermCosmosdbSqlDatabase#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbSqlDatabaseTimeoutsToTerraform(struct?: DataAzurermCosmosdbSqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermCosmosdbSqlDatabaseTimeoutsToHclTerraform(struct?: DataAzurermCosmosdbSqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCosmosdbSqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermCosmosdbSqlDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermCosmosdbSqlDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database azurerm_cosmosdb_sql_database}
*/
export declare class DataAzurermCosmosdbSqlDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_cosmosdb_sql_database";
    /**
    * Generates CDKTF code for importing a DataAzurermCosmosdbSqlDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermCosmosdbSqlDatabase to import
    * @param importFromId The id of the existing DataAzurermCosmosdbSqlDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermCosmosdbSqlDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/cosmosdb_sql_database azurerm_cosmosdb_sql_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCosmosdbSqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbSqlDatabaseConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _autoscaleSettings;
    get autoscaleSettings(): DataAzurermCosmosdbSqlDatabaseAutoscaleSettingsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get throughput(): number;
    private _timeouts;
    get timeouts(): DataAzurermCosmosdbSqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCosmosdbSqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermCosmosdbSqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
