/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermExpressRouteCircuitConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/express_route_circuit#id DataAzurermExpressRouteCircuit#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/express_route_circuit#name DataAzurermExpressRouteCircuit#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/express_route_circuit#resource_group_name DataAzurermExpressRouteCircuit#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/express_route_circuit#timeouts DataAzurermExpressRouteCircuit#timeouts}
    */
    readonly timeouts?: DataAzurermExpressRouteCircuitTimeouts;
}
export interface DataAzurermExpressRouteCircuitPeerings {
}
export declare function dataAzurermExpressRouteCircuitPeeringsToTerraform(struct?: DataAzurermExpressRouteCircuitPeerings): any;
export declare function dataAzurermExpressRouteCircuitPeeringsToHclTerraform(struct?: DataAzurermExpressRouteCircuitPeerings): any;
export declare class DataAzurermExpressRouteCircuitPeeringsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermExpressRouteCircuitPeerings | undefined;
    set internalValue(value: DataAzurermExpressRouteCircuitPeerings | undefined);
    get azureAsn(): number;
    get peerAsn(): number;
    get peeringType(): string;
    get primaryPeerAddressPrefix(): string;
    get secondaryPeerAddressPrefix(): string;
    get sharedKey(): string;
    get vlanId(): number;
}
export declare class DataAzurermExpressRouteCircuitPeeringsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermExpressRouteCircuitPeeringsOutputReference;
}
export interface DataAzurermExpressRouteCircuitServiceProviderProperties {
}
export declare function dataAzurermExpressRouteCircuitServiceProviderPropertiesToTerraform(struct?: DataAzurermExpressRouteCircuitServiceProviderProperties): any;
export declare function dataAzurermExpressRouteCircuitServiceProviderPropertiesToHclTerraform(struct?: DataAzurermExpressRouteCircuitServiceProviderProperties): any;
export declare class DataAzurermExpressRouteCircuitServiceProviderPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermExpressRouteCircuitServiceProviderProperties | undefined;
    set internalValue(value: DataAzurermExpressRouteCircuitServiceProviderProperties | undefined);
    get bandwidthInMbps(): number;
    get peeringLocation(): string;
    get serviceProviderName(): string;
}
export declare class DataAzurermExpressRouteCircuitServiceProviderPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermExpressRouteCircuitServiceProviderPropertiesOutputReference;
}
export interface DataAzurermExpressRouteCircuitSku {
}
export declare function dataAzurermExpressRouteCircuitSkuToTerraform(struct?: DataAzurermExpressRouteCircuitSku): any;
export declare function dataAzurermExpressRouteCircuitSkuToHclTerraform(struct?: DataAzurermExpressRouteCircuitSku): any;
export declare class DataAzurermExpressRouteCircuitSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermExpressRouteCircuitSku | undefined;
    set internalValue(value: DataAzurermExpressRouteCircuitSku | undefined);
    get family(): string;
    get tier(): string;
}
export declare class DataAzurermExpressRouteCircuitSkuList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermExpressRouteCircuitSkuOutputReference;
}
export interface DataAzurermExpressRouteCircuitTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/express_route_circuit#read DataAzurermExpressRouteCircuit#read}
    */
    readonly read?: string;
}
export declare function dataAzurermExpressRouteCircuitTimeoutsToTerraform(struct?: DataAzurermExpressRouteCircuitTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermExpressRouteCircuitTimeoutsToHclTerraform(struct?: DataAzurermExpressRouteCircuitTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermExpressRouteCircuitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermExpressRouteCircuitTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermExpressRouteCircuitTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/express_route_circuit azurerm_express_route_circuit}
*/
export declare class DataAzurermExpressRouteCircuit extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_express_route_circuit";
    /**
    * Generates CDKTF code for importing a DataAzurermExpressRouteCircuit resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermExpressRouteCircuit to import
    * @param importFromId The id of the existing DataAzurermExpressRouteCircuit that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/express_route_circuit#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermExpressRouteCircuit to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/express_route_circuit azurerm_express_route_circuit} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermExpressRouteCircuitConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermExpressRouteCircuitConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerings;
    get peerings(): DataAzurermExpressRouteCircuitPeeringsList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceKey(): string;
    private _serviceProviderProperties;
    get serviceProviderProperties(): DataAzurermExpressRouteCircuitServiceProviderPropertiesList;
    get serviceProviderProvisioningState(): string;
    private _sku;
    get sku(): DataAzurermExpressRouteCircuitSkuList;
    private _timeouts;
    get timeouts(): DataAzurermExpressRouteCircuitTimeoutsOutputReference;
    putTimeouts(value: DataAzurermExpressRouteCircuitTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermExpressRouteCircuitTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
