/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRedisCacheConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/redis_cache#id DataAzurermRedisCache#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/redis_cache#name DataAzurermRedisCache#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/redis_cache#resource_group_name DataAzurermRedisCache#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/redis_cache#timeouts DataAzurermRedisCache#timeouts}
    */
    readonly timeouts?: DataAzurermRedisCacheTimeouts;
}
export interface DataAzurermRedisCachePatchSchedule {
}
export declare function dataAzurermRedisCachePatchScheduleToTerraform(struct?: DataAzurermRedisCachePatchSchedule): any;
export declare function dataAzurermRedisCachePatchScheduleToHclTerraform(struct?: DataAzurermRedisCachePatchSchedule): any;
export declare class DataAzurermRedisCachePatchScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRedisCachePatchSchedule | undefined;
    set internalValue(value: DataAzurermRedisCachePatchSchedule | undefined);
    get dayOfWeek(): string;
    get maintenanceWindow(): string;
    get startHourUtc(): number;
}
export declare class DataAzurermRedisCachePatchScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRedisCachePatchScheduleOutputReference;
}
export interface DataAzurermRedisCacheRedisConfiguration {
}
export declare function dataAzurermRedisCacheRedisConfigurationToTerraform(struct?: DataAzurermRedisCacheRedisConfiguration): any;
export declare function dataAzurermRedisCacheRedisConfigurationToHclTerraform(struct?: DataAzurermRedisCacheRedisConfiguration): any;
export declare class DataAzurermRedisCacheRedisConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRedisCacheRedisConfiguration | undefined;
    set internalValue(value: DataAzurermRedisCacheRedisConfiguration | undefined);
    get activeDirectoryAuthenticationEnabled(): cdktf.IResolvable;
    get aofBackupEnabled(): cdktf.IResolvable;
    get aofStorageConnectionString0(): string;
    get aofStorageConnectionString1(): string;
    get dataPersistenceAuthenticationMethod(): string;
    get enableAuthentication(): cdktf.IResolvable;
    get maxclients(): number;
    get maxfragmentationmemoryReserved(): number;
    get maxmemoryDelta(): number;
    get maxmemoryPolicy(): string;
    get maxmemoryReserved(): number;
    get notifyKeyspaceEvents(): string;
    get rdbBackupEnabled(): cdktf.IResolvable;
    get rdbBackupFrequency(): number;
    get rdbBackupMaxSnapshotCount(): number;
    get rdbStorageConnectionString(): string;
    get storageAccountSubscriptionId(): string;
}
export declare class DataAzurermRedisCacheRedisConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRedisCacheRedisConfigurationOutputReference;
}
export interface DataAzurermRedisCacheTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/redis_cache#read DataAzurermRedisCache#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRedisCacheTimeoutsToTerraform(struct?: DataAzurermRedisCacheTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermRedisCacheTimeoutsToHclTerraform(struct?: DataAzurermRedisCacheTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRedisCacheTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermRedisCacheTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermRedisCacheTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/redis_cache azurerm_redis_cache}
*/
export declare class DataAzurermRedisCache extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_redis_cache";
    /**
    * Generates CDKTF code for importing a DataAzurermRedisCache resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermRedisCache to import
    * @param importFromId The id of the existing DataAzurermRedisCache that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/redis_cache#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermRedisCache to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/redis_cache azurerm_redis_cache} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRedisCacheConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermRedisCacheConfig);
    get capacity(): number;
    get enableNonSslPort(): cdktf.IResolvable;
    get family(): string;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    get minimumTlsVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _patchSchedule;
    get patchSchedule(): DataAzurermRedisCachePatchScheduleList;
    get port(): number;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    get privateStaticIpAddress(): string;
    private _redisConfiguration;
    get redisConfiguration(): DataAzurermRedisCacheRedisConfigurationList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    get shardCount(): number;
    get skuName(): string;
    get sslPort(): number;
    get subnetId(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermRedisCacheTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRedisCacheTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermRedisCacheTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
