/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualDesktopHostPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/virtual_desktop_host_pool#id DataAzurermVirtualDesktopHostPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/virtual_desktop_host_pool#name DataAzurermVirtualDesktopHostPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/virtual_desktop_host_pool#resource_group_name DataAzurermVirtualDesktopHostPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/virtual_desktop_host_pool#timeouts DataAzurermVirtualDesktopHostPool#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualDesktopHostPoolTimeouts;
}
export interface DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesSchedule {
}
export declare function dataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesScheduleToTerraform(struct?: DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesSchedule): any;
export declare function dataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesScheduleToHclTerraform(struct?: DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesSchedule): any;
export declare class DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesSchedule | undefined;
    set internalValue(value: DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesSchedule | undefined);
    get dayOfWeek(): string;
    get hourOfDay(): number;
}
export declare class DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesScheduleOutputReference;
}
export interface DataAzurermVirtualDesktopHostPoolScheduledAgentUpdates {
}
export declare function dataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesToTerraform(struct?: DataAzurermVirtualDesktopHostPoolScheduledAgentUpdates): any;
export declare function dataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesToHclTerraform(struct?: DataAzurermVirtualDesktopHostPoolScheduledAgentUpdates): any;
export declare class DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualDesktopHostPoolScheduledAgentUpdates | undefined;
    set internalValue(value: DataAzurermVirtualDesktopHostPoolScheduledAgentUpdates | undefined);
    get enabled(): cdktf.IResolvable;
    private _schedule;
    get schedule(): DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesScheduleList;
    get timezone(): string;
    get useSessionHostTimezone(): cdktf.IResolvable;
}
export declare class DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesOutputReference;
}
export interface DataAzurermVirtualDesktopHostPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/virtual_desktop_host_pool#read DataAzurermVirtualDesktopHostPool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualDesktopHostPoolTimeoutsToTerraform(struct?: DataAzurermVirtualDesktopHostPoolTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermVirtualDesktopHostPoolTimeoutsToHclTerraform(struct?: DataAzurermVirtualDesktopHostPoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualDesktopHostPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualDesktopHostPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualDesktopHostPoolTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/virtual_desktop_host_pool azurerm_virtual_desktop_host_pool}
*/
export declare class DataAzurermVirtualDesktopHostPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_desktop_host_pool";
    /**
    * Generates CDKTF code for importing a DataAzurermVirtualDesktopHostPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermVirtualDesktopHostPool to import
    * @param importFromId The id of the existing DataAzurermVirtualDesktopHostPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/virtual_desktop_host_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermVirtualDesktopHostPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/data-sources/virtual_desktop_host_pool azurerm_virtual_desktop_host_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualDesktopHostPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualDesktopHostPoolConfig);
    get customRdpProperties(): string;
    get description(): string;
    get friendlyName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get loadBalancerType(): string;
    get location(): string;
    get maximumSessionsAllowed(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get personalDesktopAssignmentType(): string;
    get preferredAppGroupType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scheduledAgentUpdates;
    get scheduledAgentUpdates(): DataAzurermVirtualDesktopHostPoolScheduledAgentUpdatesList;
    get startVmOnConnect(): cdktf.IResolvable;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
    get validateEnvironment(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermVirtualDesktopHostPoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualDesktopHostPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualDesktopHostPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
