/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventgridTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#id EventgridTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#inbound_ip_rule EventgridTopic#inbound_ip_rule}
    */
    readonly inboundIpRule?: EventgridTopicInboundIpRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#input_schema EventgridTopic#input_schema}
    */
    readonly inputSchema?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#local_auth_enabled EventgridTopic#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#location EventgridTopic#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#name EventgridTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#public_network_access_enabled EventgridTopic#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#resource_group_name EventgridTopic#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#tags EventgridTopic#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#identity EventgridTopic#identity}
    */
    readonly identity?: EventgridTopicIdentity;
    /**
    * input_mapping_default_values block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#input_mapping_default_values EventgridTopic#input_mapping_default_values}
    */
    readonly inputMappingDefaultValues?: EventgridTopicInputMappingDefaultValues;
    /**
    * input_mapping_fields block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#input_mapping_fields EventgridTopic#input_mapping_fields}
    */
    readonly inputMappingFields?: EventgridTopicInputMappingFields;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#timeouts EventgridTopic#timeouts}
    */
    readonly timeouts?: EventgridTopicTimeouts;
}
export interface EventgridTopicInboundIpRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#action EventgridTopic#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#ip_mask EventgridTopic#ip_mask}
    */
    readonly ipMask?: string;
}
export declare function eventgridTopicInboundIpRuleToTerraform(struct?: EventgridTopicInboundIpRule | cdktf.IResolvable): any;
export declare function eventgridTopicInboundIpRuleToHclTerraform(struct?: EventgridTopicInboundIpRule | cdktf.IResolvable): any;
export declare class EventgridTopicInboundIpRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventgridTopicInboundIpRule | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridTopicInboundIpRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _ipMask?;
    get ipMask(): string;
    set ipMask(value: string);
    resetIpMask(): void;
    get ipMaskInput(): string | undefined;
}
export declare class EventgridTopicInboundIpRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventgridTopicInboundIpRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventgridTopicInboundIpRuleOutputReference;
}
export interface EventgridTopicIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#identity_ids EventgridTopic#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#type EventgridTopic#type}
    */
    readonly type: string;
}
export declare function eventgridTopicIdentityToTerraform(struct?: EventgridTopicIdentityOutputReference | EventgridTopicIdentity): any;
export declare function eventgridTopicIdentityToHclTerraform(struct?: EventgridTopicIdentityOutputReference | EventgridTopicIdentity): any;
export declare class EventgridTopicIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridTopicIdentity | undefined;
    set internalValue(value: EventgridTopicIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface EventgridTopicInputMappingDefaultValues {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#data_version EventgridTopic#data_version}
    */
    readonly dataVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#event_type EventgridTopic#event_type}
    */
    readonly eventType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#subject EventgridTopic#subject}
    */
    readonly subject?: string;
}
export declare function eventgridTopicInputMappingDefaultValuesToTerraform(struct?: EventgridTopicInputMappingDefaultValuesOutputReference | EventgridTopicInputMappingDefaultValues): any;
export declare function eventgridTopicInputMappingDefaultValuesToHclTerraform(struct?: EventgridTopicInputMappingDefaultValuesOutputReference | EventgridTopicInputMappingDefaultValues): any;
export declare class EventgridTopicInputMappingDefaultValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridTopicInputMappingDefaultValues | undefined;
    set internalValue(value: EventgridTopicInputMappingDefaultValues | undefined);
    private _dataVersion?;
    get dataVersion(): string;
    set dataVersion(value: string);
    resetDataVersion(): void;
    get dataVersionInput(): string | undefined;
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    resetEventType(): void;
    get eventTypeInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
}
export interface EventgridTopicInputMappingFields {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#data_version EventgridTopic#data_version}
    */
    readonly dataVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#event_time EventgridTopic#event_time}
    */
    readonly eventTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#event_type EventgridTopic#event_type}
    */
    readonly eventType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#id EventgridTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#subject EventgridTopic#subject}
    */
    readonly subject?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#topic EventgridTopic#topic}
    */
    readonly topic?: string;
}
export declare function eventgridTopicInputMappingFieldsToTerraform(struct?: EventgridTopicInputMappingFieldsOutputReference | EventgridTopicInputMappingFields): any;
export declare function eventgridTopicInputMappingFieldsToHclTerraform(struct?: EventgridTopicInputMappingFieldsOutputReference | EventgridTopicInputMappingFields): any;
export declare class EventgridTopicInputMappingFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridTopicInputMappingFields | undefined;
    set internalValue(value: EventgridTopicInputMappingFields | undefined);
    private _dataVersion?;
    get dataVersion(): string;
    set dataVersion(value: string);
    resetDataVersion(): void;
    get dataVersionInput(): string | undefined;
    private _eventTime?;
    get eventTime(): string;
    set eventTime(value: string);
    resetEventTime(): void;
    get eventTimeInput(): string | undefined;
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    resetEventType(): void;
    get eventTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    resetTopic(): void;
    get topicInput(): string | undefined;
}
export interface EventgridTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#create EventgridTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#delete EventgridTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#read EventgridTopic#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#update EventgridTopic#update}
    */
    readonly update?: string;
}
export declare function eventgridTopicTimeoutsToTerraform(struct?: EventgridTopicTimeouts | cdktf.IResolvable): any;
export declare function eventgridTopicTimeoutsToHclTerraform(struct?: EventgridTopicTimeouts | cdktf.IResolvable): any;
export declare class EventgridTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridTopicTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridTopicTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic azurerm_eventgrid_topic}
*/
export declare class EventgridTopic extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventgrid_topic";
    /**
    * Generates CDKTF code for importing a EventgridTopic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventgridTopic to import
    * @param importFromId The id of the existing EventgridTopic that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventgridTopic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/eventgrid_topic azurerm_eventgrid_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventgridTopicConfig
    */
    constructor(scope: Construct, id: string, config: EventgridTopicConfig);
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inboundIpRule;
    get inboundIpRule(): EventgridTopicInboundIpRuleList;
    putInboundIpRule(value: EventgridTopicInboundIpRule[] | cdktf.IResolvable): void;
    resetInboundIpRule(): void;
    get inboundIpRuleInput(): cdktf.IResolvable | EventgridTopicInboundIpRule[] | undefined;
    private _inputSchema?;
    get inputSchema(): string;
    set inputSchema(value: string);
    resetInputSchema(): void;
    get inputSchemaInput(): string | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): EventgridTopicIdentityOutputReference;
    putIdentity(value: EventgridTopicIdentity): void;
    resetIdentity(): void;
    get identityInput(): EventgridTopicIdentity | undefined;
    private _inputMappingDefaultValues;
    get inputMappingDefaultValues(): EventgridTopicInputMappingDefaultValuesOutputReference;
    putInputMappingDefaultValues(value: EventgridTopicInputMappingDefaultValues): void;
    resetInputMappingDefaultValues(): void;
    get inputMappingDefaultValuesInput(): EventgridTopicInputMappingDefaultValues | undefined;
    private _inputMappingFields;
    get inputMappingFields(): EventgridTopicInputMappingFieldsOutputReference;
    putInputMappingFields(value: EventgridTopicInputMappingFields): void;
    resetInputMappingFields(): void;
    get inputMappingFieldsInput(): EventgridTopicInputMappingFields | undefined;
    private _timeouts;
    get timeouts(): EventgridTopicTimeoutsOutputReference;
    putTimeouts(value: EventgridTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventgridTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
