/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FrontdoorCustomHttpsConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#custom_https_provisioning_enabled FrontdoorCustomHttpsConfiguration#custom_https_provisioning_enabled}
    */
    readonly customHttpsProvisioningEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#frontend_endpoint_id FrontdoorCustomHttpsConfiguration#frontend_endpoint_id}
    */
    readonly frontendEndpointId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#id FrontdoorCustomHttpsConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * custom_https_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#custom_https_configuration FrontdoorCustomHttpsConfiguration#custom_https_configuration}
    */
    readonly customHttpsConfiguration?: FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#timeouts FrontdoorCustomHttpsConfiguration#timeouts}
    */
    readonly timeouts?: FrontdoorCustomHttpsConfigurationTimeouts;
}
export interface FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#azure_key_vault_certificate_secret_name FrontdoorCustomHttpsConfiguration#azure_key_vault_certificate_secret_name}
    */
    readonly azureKeyVaultCertificateSecretName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#azure_key_vault_certificate_secret_version FrontdoorCustomHttpsConfiguration#azure_key_vault_certificate_secret_version}
    */
    readonly azureKeyVaultCertificateSecretVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#azure_key_vault_certificate_vault_id FrontdoorCustomHttpsConfiguration#azure_key_vault_certificate_vault_id}
    */
    readonly azureKeyVaultCertificateVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#certificate_source FrontdoorCustomHttpsConfiguration#certificate_source}
    */
    readonly certificateSource?: string;
}
export declare function frontdoorCustomHttpsConfigurationCustomHttpsConfigurationToTerraform(struct?: FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference | FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration): any;
export declare function frontdoorCustomHttpsConfigurationCustomHttpsConfigurationToHclTerraform(struct?: FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference | FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration): any;
export declare class FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration | undefined;
    set internalValue(value: FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration | undefined);
    private _azureKeyVaultCertificateSecretName?;
    get azureKeyVaultCertificateSecretName(): string;
    set azureKeyVaultCertificateSecretName(value: string);
    resetAzureKeyVaultCertificateSecretName(): void;
    get azureKeyVaultCertificateSecretNameInput(): string | undefined;
    private _azureKeyVaultCertificateSecretVersion?;
    get azureKeyVaultCertificateSecretVersion(): string;
    set azureKeyVaultCertificateSecretVersion(value: string);
    resetAzureKeyVaultCertificateSecretVersion(): void;
    get azureKeyVaultCertificateSecretVersionInput(): string | undefined;
    private _azureKeyVaultCertificateVaultId?;
    get azureKeyVaultCertificateVaultId(): string;
    set azureKeyVaultCertificateVaultId(value: string);
    resetAzureKeyVaultCertificateVaultId(): void;
    get azureKeyVaultCertificateVaultIdInput(): string | undefined;
    private _certificateSource?;
    get certificateSource(): string;
    set certificateSource(value: string);
    resetCertificateSource(): void;
    get certificateSourceInput(): string | undefined;
    get minimumTlsVersion(): string;
    get provisioningState(): string;
    get provisioningSubstate(): string;
}
export interface FrontdoorCustomHttpsConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#create FrontdoorCustomHttpsConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#delete FrontdoorCustomHttpsConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#read FrontdoorCustomHttpsConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#update FrontdoorCustomHttpsConfiguration#update}
    */
    readonly update?: string;
}
export declare function frontdoorCustomHttpsConfigurationTimeoutsToTerraform(struct?: FrontdoorCustomHttpsConfigurationTimeouts | cdktf.IResolvable): any;
export declare function frontdoorCustomHttpsConfigurationTimeoutsToHclTerraform(struct?: FrontdoorCustomHttpsConfigurationTimeouts | cdktf.IResolvable): any;
export declare class FrontdoorCustomHttpsConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorCustomHttpsConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorCustomHttpsConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration azurerm_frontdoor_custom_https_configuration}
*/
export declare class FrontdoorCustomHttpsConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_frontdoor_custom_https_configuration";
    /**
    * Generates CDKTF code for importing a FrontdoorCustomHttpsConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FrontdoorCustomHttpsConfiguration to import
    * @param importFromId The id of the existing FrontdoorCustomHttpsConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FrontdoorCustomHttpsConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/frontdoor_custom_https_configuration azurerm_frontdoor_custom_https_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FrontdoorCustomHttpsConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: FrontdoorCustomHttpsConfigurationConfig);
    private _customHttpsProvisioningEnabled?;
    get customHttpsProvisioningEnabled(): boolean | cdktf.IResolvable;
    set customHttpsProvisioningEnabled(value: boolean | cdktf.IResolvable);
    get customHttpsProvisioningEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frontendEndpointId?;
    get frontendEndpointId(): string;
    set frontendEndpointId(value: string);
    get frontendEndpointIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _customHttpsConfiguration;
    get customHttpsConfiguration(): FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference;
    putCustomHttpsConfiguration(value: FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration): void;
    resetCustomHttpsConfiguration(): void;
    get customHttpsConfigurationInput(): FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration | undefined;
    private _timeouts;
    get timeouts(): FrontdoorCustomHttpsConfigurationTimeoutsOutputReference;
    putTimeouts(value: FrontdoorCustomHttpsConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FrontdoorCustomHttpsConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
