/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HdinsightHbaseClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#cluster_version HdinsightHbaseCluster#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#id HdinsightHbaseCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#location HdinsightHbaseCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#name HdinsightHbaseCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#resource_group_name HdinsightHbaseCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#tags HdinsightHbaseCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#tier HdinsightHbaseCluster#tier}
    */
    readonly tier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#tls_min_version HdinsightHbaseCluster#tls_min_version}
    */
    readonly tlsMinVersion?: string;
    /**
    * component_version block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#component_version HdinsightHbaseCluster#component_version}
    */
    readonly componentVersion: HdinsightHbaseClusterComponentVersion;
    /**
    * compute_isolation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#compute_isolation HdinsightHbaseCluster#compute_isolation}
    */
    readonly computeIsolation?: HdinsightHbaseClusterComputeIsolation;
    /**
    * disk_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#disk_encryption HdinsightHbaseCluster#disk_encryption}
    */
    readonly diskEncryption?: HdinsightHbaseClusterDiskEncryption[] | cdktf.IResolvable;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#extension HdinsightHbaseCluster#extension}
    */
    readonly extension?: HdinsightHbaseClusterExtension;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#gateway HdinsightHbaseCluster#gateway}
    */
    readonly gateway: HdinsightHbaseClusterGateway;
    /**
    * metastores block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#metastores HdinsightHbaseCluster#metastores}
    */
    readonly metastores?: HdinsightHbaseClusterMetastores;
    /**
    * monitor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#monitor HdinsightHbaseCluster#monitor}
    */
    readonly monitor?: HdinsightHbaseClusterMonitor;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#network HdinsightHbaseCluster#network}
    */
    readonly network?: HdinsightHbaseClusterNetwork;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#roles HdinsightHbaseCluster#roles}
    */
    readonly roles: HdinsightHbaseClusterRoles;
    /**
    * security_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#security_profile HdinsightHbaseCluster#security_profile}
    */
    readonly securityProfile?: HdinsightHbaseClusterSecurityProfile;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#storage_account HdinsightHbaseCluster#storage_account}
    */
    readonly storageAccount?: HdinsightHbaseClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * storage_account_gen2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#storage_account_gen2 HdinsightHbaseCluster#storage_account_gen2}
    */
    readonly storageAccountGen2?: HdinsightHbaseClusterStorageAccountGen2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#timeouts HdinsightHbaseCluster#timeouts}
    */
    readonly timeouts?: HdinsightHbaseClusterTimeouts;
}
export interface HdinsightHbaseClusterComponentVersion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#hbase HdinsightHbaseCluster#hbase}
    */
    readonly hbase: string;
}
export declare function hdinsightHbaseClusterComponentVersionToTerraform(struct?: HdinsightHbaseClusterComponentVersionOutputReference | HdinsightHbaseClusterComponentVersion): any;
export declare function hdinsightHbaseClusterComponentVersionToHclTerraform(struct?: HdinsightHbaseClusterComponentVersionOutputReference | HdinsightHbaseClusterComponentVersion): any;
export declare class HdinsightHbaseClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterComponentVersion | undefined;
    set internalValue(value: HdinsightHbaseClusterComponentVersion | undefined);
    private _hbase?;
    get hbase(): string;
    set hbase(value: string);
    get hbaseInput(): string | undefined;
}
export interface HdinsightHbaseClusterComputeIsolation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#compute_isolation_enabled HdinsightHbaseCluster#compute_isolation_enabled}
    */
    readonly computeIsolationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#host_sku HdinsightHbaseCluster#host_sku}
    */
    readonly hostSku?: string;
}
export declare function hdinsightHbaseClusterComputeIsolationToTerraform(struct?: HdinsightHbaseClusterComputeIsolationOutputReference | HdinsightHbaseClusterComputeIsolation): any;
export declare function hdinsightHbaseClusterComputeIsolationToHclTerraform(struct?: HdinsightHbaseClusterComputeIsolationOutputReference | HdinsightHbaseClusterComputeIsolation): any;
export declare class HdinsightHbaseClusterComputeIsolationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterComputeIsolation | undefined;
    set internalValue(value: HdinsightHbaseClusterComputeIsolation | undefined);
    private _computeIsolationEnabled?;
    get computeIsolationEnabled(): boolean | cdktf.IResolvable;
    set computeIsolationEnabled(value: boolean | cdktf.IResolvable);
    resetComputeIsolationEnabled(): void;
    get computeIsolationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostSku?;
    get hostSku(): string;
    set hostSku(value: string);
    resetHostSku(): void;
    get hostSkuInput(): string | undefined;
}
export interface HdinsightHbaseClusterDiskEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#encryption_algorithm HdinsightHbaseCluster#encryption_algorithm}
    */
    readonly encryptionAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#encryption_at_host_enabled HdinsightHbaseCluster#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#key_vault_key_id HdinsightHbaseCluster#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#key_vault_managed_identity_id HdinsightHbaseCluster#key_vault_managed_identity_id}
    */
    readonly keyVaultManagedIdentityId?: string;
}
export declare function hdinsightHbaseClusterDiskEncryptionToTerraform(struct?: HdinsightHbaseClusterDiskEncryption | cdktf.IResolvable): any;
export declare function hdinsightHbaseClusterDiskEncryptionToHclTerraform(struct?: HdinsightHbaseClusterDiskEncryption | cdktf.IResolvable): any;
export declare class HdinsightHbaseClusterDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHbaseClusterDiskEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHbaseClusterDiskEncryption | cdktf.IResolvable | undefined);
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    resetEncryptionAlgorithm(): void;
    get encryptionAlgorithmInput(): string | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
    private _keyVaultManagedIdentityId?;
    get keyVaultManagedIdentityId(): string;
    set keyVaultManagedIdentityId(value: string);
    resetKeyVaultManagedIdentityId(): void;
    get keyVaultManagedIdentityIdInput(): string | undefined;
}
export declare class HdinsightHbaseClusterDiskEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHbaseClusterDiskEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHbaseClusterDiskEncryptionOutputReference;
}
export interface HdinsightHbaseClusterExtension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#log_analytics_workspace_id HdinsightHbaseCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#primary_key HdinsightHbaseCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightHbaseClusterExtensionToTerraform(struct?: HdinsightHbaseClusterExtensionOutputReference | HdinsightHbaseClusterExtension): any;
export declare function hdinsightHbaseClusterExtensionToHclTerraform(struct?: HdinsightHbaseClusterExtensionOutputReference | HdinsightHbaseClusterExtension): any;
export declare class HdinsightHbaseClusterExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterExtension | undefined;
    set internalValue(value: HdinsightHbaseClusterExtension | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightHbaseClusterGateway {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#password HdinsightHbaseCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#username HdinsightHbaseCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightHbaseClusterGatewayToTerraform(struct?: HdinsightHbaseClusterGatewayOutputReference | HdinsightHbaseClusterGateway): any;
export declare function hdinsightHbaseClusterGatewayToHclTerraform(struct?: HdinsightHbaseClusterGatewayOutputReference | HdinsightHbaseClusterGateway): any;
export declare class HdinsightHbaseClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterGateway | undefined;
    set internalValue(value: HdinsightHbaseClusterGateway | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightHbaseClusterMetastoresAmbari {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#database_name HdinsightHbaseCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#password HdinsightHbaseCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#server HdinsightHbaseCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#username HdinsightHbaseCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightHbaseClusterMetastoresAmbariToTerraform(struct?: HdinsightHbaseClusterMetastoresAmbariOutputReference | HdinsightHbaseClusterMetastoresAmbari): any;
export declare function hdinsightHbaseClusterMetastoresAmbariToHclTerraform(struct?: HdinsightHbaseClusterMetastoresAmbariOutputReference | HdinsightHbaseClusterMetastoresAmbari): any;
export declare class HdinsightHbaseClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterMetastoresAmbari | undefined;
    set internalValue(value: HdinsightHbaseClusterMetastoresAmbari | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightHbaseClusterMetastoresHive {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#database_name HdinsightHbaseCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#password HdinsightHbaseCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#server HdinsightHbaseCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#username HdinsightHbaseCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightHbaseClusterMetastoresHiveToTerraform(struct?: HdinsightHbaseClusterMetastoresHiveOutputReference | HdinsightHbaseClusterMetastoresHive): any;
export declare function hdinsightHbaseClusterMetastoresHiveToHclTerraform(struct?: HdinsightHbaseClusterMetastoresHiveOutputReference | HdinsightHbaseClusterMetastoresHive): any;
export declare class HdinsightHbaseClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterMetastoresHive | undefined;
    set internalValue(value: HdinsightHbaseClusterMetastoresHive | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightHbaseClusterMetastoresOozie {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#database_name HdinsightHbaseCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#password HdinsightHbaseCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#server HdinsightHbaseCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#username HdinsightHbaseCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightHbaseClusterMetastoresOozieToTerraform(struct?: HdinsightHbaseClusterMetastoresOozieOutputReference | HdinsightHbaseClusterMetastoresOozie): any;
export declare function hdinsightHbaseClusterMetastoresOozieToHclTerraform(struct?: HdinsightHbaseClusterMetastoresOozieOutputReference | HdinsightHbaseClusterMetastoresOozie): any;
export declare class HdinsightHbaseClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterMetastoresOozie | undefined;
    set internalValue(value: HdinsightHbaseClusterMetastoresOozie | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightHbaseClusterMetastores {
    /**
    * ambari block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#ambari HdinsightHbaseCluster#ambari}
    */
    readonly ambari?: HdinsightHbaseClusterMetastoresAmbari;
    /**
    * hive block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#hive HdinsightHbaseCluster#hive}
    */
    readonly hive?: HdinsightHbaseClusterMetastoresHive;
    /**
    * oozie block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#oozie HdinsightHbaseCluster#oozie}
    */
    readonly oozie?: HdinsightHbaseClusterMetastoresOozie;
}
export declare function hdinsightHbaseClusterMetastoresToTerraform(struct?: HdinsightHbaseClusterMetastoresOutputReference | HdinsightHbaseClusterMetastores): any;
export declare function hdinsightHbaseClusterMetastoresToHclTerraform(struct?: HdinsightHbaseClusterMetastoresOutputReference | HdinsightHbaseClusterMetastores): any;
export declare class HdinsightHbaseClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterMetastores | undefined;
    set internalValue(value: HdinsightHbaseClusterMetastores | undefined);
    private _ambari;
    get ambari(): HdinsightHbaseClusterMetastoresAmbariOutputReference;
    putAmbari(value: HdinsightHbaseClusterMetastoresAmbari): void;
    resetAmbari(): void;
    get ambariInput(): HdinsightHbaseClusterMetastoresAmbari | undefined;
    private _hive;
    get hive(): HdinsightHbaseClusterMetastoresHiveOutputReference;
    putHive(value: HdinsightHbaseClusterMetastoresHive): void;
    resetHive(): void;
    get hiveInput(): HdinsightHbaseClusterMetastoresHive | undefined;
    private _oozie;
    get oozie(): HdinsightHbaseClusterMetastoresOozieOutputReference;
    putOozie(value: HdinsightHbaseClusterMetastoresOozie): void;
    resetOozie(): void;
    get oozieInput(): HdinsightHbaseClusterMetastoresOozie | undefined;
}
export interface HdinsightHbaseClusterMonitor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#log_analytics_workspace_id HdinsightHbaseCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#primary_key HdinsightHbaseCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightHbaseClusterMonitorToTerraform(struct?: HdinsightHbaseClusterMonitorOutputReference | HdinsightHbaseClusterMonitor): any;
export declare function hdinsightHbaseClusterMonitorToHclTerraform(struct?: HdinsightHbaseClusterMonitorOutputReference | HdinsightHbaseClusterMonitor): any;
export declare class HdinsightHbaseClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterMonitor | undefined;
    set internalValue(value: HdinsightHbaseClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightHbaseClusterNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#connection_direction HdinsightHbaseCluster#connection_direction}
    */
    readonly connectionDirection?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#private_link_enabled HdinsightHbaseCluster#private_link_enabled}
    */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
}
export declare function hdinsightHbaseClusterNetworkToTerraform(struct?: HdinsightHbaseClusterNetworkOutputReference | HdinsightHbaseClusterNetwork): any;
export declare function hdinsightHbaseClusterNetworkToHclTerraform(struct?: HdinsightHbaseClusterNetworkOutputReference | HdinsightHbaseClusterNetwork): any;
export declare class HdinsightHbaseClusterNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterNetwork | undefined;
    set internalValue(value: HdinsightHbaseClusterNetwork | undefined);
    private _connectionDirection?;
    get connectionDirection(): string;
    set connectionDirection(value: string);
    resetConnectionDirection(): void;
    get connectionDirectionInput(): string | undefined;
    private _privateLinkEnabled?;
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateLinkEnabled(): void;
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface HdinsightHbaseClusterRolesHeadNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#name HdinsightHbaseCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#parameters HdinsightHbaseCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#uri HdinsightHbaseCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightHbaseClusterRolesHeadNodeScriptActionsToTerraform(struct?: HdinsightHbaseClusterRolesHeadNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightHbaseClusterRolesHeadNodeScriptActionsToHclTerraform(struct?: HdinsightHbaseClusterRolesHeadNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightHbaseClusterRolesHeadNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHbaseClusterRolesHeadNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesHeadNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightHbaseClusterRolesHeadNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHbaseClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHbaseClusterRolesHeadNodeScriptActionsOutputReference;
}
export interface HdinsightHbaseClusterRolesHeadNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#password HdinsightHbaseCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#ssh_keys HdinsightHbaseCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#subnet_id HdinsightHbaseCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#username HdinsightHbaseCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#virtual_network_id HdinsightHbaseCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#vm_size HdinsightHbaseCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#script_actions HdinsightHbaseCluster#script_actions}
    */
    readonly scriptActions?: HdinsightHbaseClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightHbaseClusterRolesHeadNodeToTerraform(struct?: HdinsightHbaseClusterRolesHeadNodeOutputReference | HdinsightHbaseClusterRolesHeadNode): any;
export declare function hdinsightHbaseClusterRolesHeadNodeToHclTerraform(struct?: HdinsightHbaseClusterRolesHeadNodeOutputReference | HdinsightHbaseClusterRolesHeadNode): any;
export declare class HdinsightHbaseClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterRolesHeadNode | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesHeadNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightHbaseClusterRolesHeadNodeScriptActionsList;
    putScriptActions(value: HdinsightHbaseClusterRolesHeadNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightHbaseClusterRolesHeadNodeScriptActions[] | undefined;
}
export interface HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#days HdinsightHbaseCluster#days}
    */
    readonly days: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#target_instance_count HdinsightHbaseCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#time HdinsightHbaseCluster#time}
    */
    readonly time: string;
}
export declare function hdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable): any;
export declare function hdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToHclTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable): any;
export declare class HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable | undefined);
    private _days?;
    get days(): string[];
    set days(value: string[]);
    get daysInput(): string[] | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export declare class HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceScheduleOutputReference;
}
export interface HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#timezone HdinsightHbaseCluster#timezone}
    */
    readonly timezone: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#schedule HdinsightHbaseCluster#schedule}
    */
    readonly schedule: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
}
export declare function hdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceToTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrence): any;
export declare function hdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceToHclTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrence): any;
export declare class HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrence | undefined);
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    get timezoneInput(): string | undefined;
    private _schedule;
    get schedule(): HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceScheduleList;
    putSchedule(value: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable): void;
    get scheduleInput(): cdktf.IResolvable | HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | undefined;
}
export interface HdinsightHbaseClusterRolesWorkerNodeAutoscale {
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#recurrence HdinsightHbaseCluster#recurrence}
    */
    readonly recurrence?: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrence;
}
export declare function hdinsightHbaseClusterRolesWorkerNodeAutoscaleToTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightHbaseClusterRolesWorkerNodeAutoscale): any;
export declare function hdinsightHbaseClusterRolesWorkerNodeAutoscaleToHclTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightHbaseClusterRolesWorkerNodeAutoscale): any;
export declare class HdinsightHbaseClusterRolesWorkerNodeAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterRolesWorkerNodeAutoscale | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesWorkerNodeAutoscale | undefined);
    private _recurrence;
    get recurrence(): HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference;
    putRecurrence(value: HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): HdinsightHbaseClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
}
export interface HdinsightHbaseClusterRolesWorkerNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#name HdinsightHbaseCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#parameters HdinsightHbaseCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#uri HdinsightHbaseCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightHbaseClusterRolesWorkerNodeScriptActionsToTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightHbaseClusterRolesWorkerNodeScriptActionsToHclTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightHbaseClusterRolesWorkerNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHbaseClusterRolesWorkerNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesWorkerNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightHbaseClusterRolesWorkerNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHbaseClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHbaseClusterRolesWorkerNodeScriptActionsOutputReference;
}
export interface HdinsightHbaseClusterRolesWorkerNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#password HdinsightHbaseCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#ssh_keys HdinsightHbaseCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#subnet_id HdinsightHbaseCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#target_instance_count HdinsightHbaseCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#username HdinsightHbaseCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#virtual_network_id HdinsightHbaseCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#vm_size HdinsightHbaseCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#autoscale HdinsightHbaseCluster#autoscale}
    */
    readonly autoscale?: HdinsightHbaseClusterRolesWorkerNodeAutoscale;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#script_actions HdinsightHbaseCluster#script_actions}
    */
    readonly scriptActions?: HdinsightHbaseClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightHbaseClusterRolesWorkerNodeToTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeOutputReference | HdinsightHbaseClusterRolesWorkerNode): any;
export declare function hdinsightHbaseClusterRolesWorkerNodeToHclTerraform(struct?: HdinsightHbaseClusterRolesWorkerNodeOutputReference | HdinsightHbaseClusterRolesWorkerNode): any;
export declare class HdinsightHbaseClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterRolesWorkerNode | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesWorkerNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _autoscale;
    get autoscale(): HdinsightHbaseClusterRolesWorkerNodeAutoscaleOutputReference;
    putAutoscale(value: HdinsightHbaseClusterRolesWorkerNodeAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): HdinsightHbaseClusterRolesWorkerNodeAutoscale | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightHbaseClusterRolesWorkerNodeScriptActionsList;
    putScriptActions(value: HdinsightHbaseClusterRolesWorkerNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightHbaseClusterRolesWorkerNodeScriptActions[] | undefined;
}
export interface HdinsightHbaseClusterRolesZookeeperNodeScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#name HdinsightHbaseCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#parameters HdinsightHbaseCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#uri HdinsightHbaseCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightHbaseClusterRolesZookeeperNodeScriptActionsToTerraform(struct?: HdinsightHbaseClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable): any;
export declare function hdinsightHbaseClusterRolesZookeeperNodeScriptActionsToHclTerraform(struct?: HdinsightHbaseClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable): any;
export declare class HdinsightHbaseClusterRolesZookeeperNodeScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHbaseClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesZookeeperNodeScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightHbaseClusterRolesZookeeperNodeScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHbaseClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHbaseClusterRolesZookeeperNodeScriptActionsOutputReference;
}
export interface HdinsightHbaseClusterRolesZookeeperNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#password HdinsightHbaseCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#ssh_keys HdinsightHbaseCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#subnet_id HdinsightHbaseCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#username HdinsightHbaseCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#virtual_network_id HdinsightHbaseCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#vm_size HdinsightHbaseCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * script_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#script_actions HdinsightHbaseCluster#script_actions}
    */
    readonly scriptActions?: HdinsightHbaseClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightHbaseClusterRolesZookeeperNodeToTerraform(struct?: HdinsightHbaseClusterRolesZookeeperNodeOutputReference | HdinsightHbaseClusterRolesZookeeperNode): any;
export declare function hdinsightHbaseClusterRolesZookeeperNodeToHclTerraform(struct?: HdinsightHbaseClusterRolesZookeeperNodeOutputReference | HdinsightHbaseClusterRolesZookeeperNode): any;
export declare class HdinsightHbaseClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterRolesZookeeperNode | undefined;
    set internalValue(value: HdinsightHbaseClusterRolesZookeeperNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _scriptActions;
    get scriptActions(): HdinsightHbaseClusterRolesZookeeperNodeScriptActionsList;
    putScriptActions(value: HdinsightHbaseClusterRolesZookeeperNodeScriptActions[] | cdktf.IResolvable): void;
    resetScriptActions(): void;
    get scriptActionsInput(): cdktf.IResolvable | HdinsightHbaseClusterRolesZookeeperNodeScriptActions[] | undefined;
}
export interface HdinsightHbaseClusterRoles {
    /**
    * head_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#head_node HdinsightHbaseCluster#head_node}
    */
    readonly headNode: HdinsightHbaseClusterRolesHeadNode;
    /**
    * worker_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#worker_node HdinsightHbaseCluster#worker_node}
    */
    readonly workerNode: HdinsightHbaseClusterRolesWorkerNode;
    /**
    * zookeeper_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#zookeeper_node HdinsightHbaseCluster#zookeeper_node}
    */
    readonly zookeeperNode: HdinsightHbaseClusterRolesZookeeperNode;
}
export declare function hdinsightHbaseClusterRolesToTerraform(struct?: HdinsightHbaseClusterRolesOutputReference | HdinsightHbaseClusterRoles): any;
export declare function hdinsightHbaseClusterRolesToHclTerraform(struct?: HdinsightHbaseClusterRolesOutputReference | HdinsightHbaseClusterRoles): any;
export declare class HdinsightHbaseClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterRoles | undefined;
    set internalValue(value: HdinsightHbaseClusterRoles | undefined);
    private _headNode;
    get headNode(): HdinsightHbaseClusterRolesHeadNodeOutputReference;
    putHeadNode(value: HdinsightHbaseClusterRolesHeadNode): void;
    get headNodeInput(): HdinsightHbaseClusterRolesHeadNode | undefined;
    private _workerNode;
    get workerNode(): HdinsightHbaseClusterRolesWorkerNodeOutputReference;
    putWorkerNode(value: HdinsightHbaseClusterRolesWorkerNode): void;
    get workerNodeInput(): HdinsightHbaseClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    get zookeeperNode(): HdinsightHbaseClusterRolesZookeeperNodeOutputReference;
    putZookeeperNode(value: HdinsightHbaseClusterRolesZookeeperNode): void;
    get zookeeperNodeInput(): HdinsightHbaseClusterRolesZookeeperNode | undefined;
}
export interface HdinsightHbaseClusterSecurityProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#aadds_resource_id HdinsightHbaseCluster#aadds_resource_id}
    */
    readonly aaddsResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#cluster_users_group_dns HdinsightHbaseCluster#cluster_users_group_dns}
    */
    readonly clusterUsersGroupDns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#domain_name HdinsightHbaseCluster#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#domain_user_password HdinsightHbaseCluster#domain_user_password}
    */
    readonly domainUserPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#domain_username HdinsightHbaseCluster#domain_username}
    */
    readonly domainUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#ldaps_urls HdinsightHbaseCluster#ldaps_urls}
    */
    readonly ldapsUrls: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#msi_resource_id HdinsightHbaseCluster#msi_resource_id}
    */
    readonly msiResourceId: string;
}
export declare function hdinsightHbaseClusterSecurityProfileToTerraform(struct?: HdinsightHbaseClusterSecurityProfileOutputReference | HdinsightHbaseClusterSecurityProfile): any;
export declare function hdinsightHbaseClusterSecurityProfileToHclTerraform(struct?: HdinsightHbaseClusterSecurityProfileOutputReference | HdinsightHbaseClusterSecurityProfile): any;
export declare class HdinsightHbaseClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterSecurityProfile | undefined;
    set internalValue(value: HdinsightHbaseClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    get aaddsResourceId(): string;
    set aaddsResourceId(value: string);
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    get clusterUsersGroupDns(): string[];
    set clusterUsersGroupDns(value: string[]);
    resetClusterUsersGroupDns(): void;
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    get domainUserPassword(): string;
    set domainUserPassword(value: string);
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    get domainUsername(): string;
    set domainUsername(value: string);
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    get ldapsUrls(): string[];
    set ldapsUrls(value: string[]);
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    get msiResourceId(): string;
    set msiResourceId(value: string);
    get msiResourceIdInput(): string | undefined;
}
export interface HdinsightHbaseClusterStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#is_default HdinsightHbaseCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#storage_account_key HdinsightHbaseCluster#storage_account_key}
    */
    readonly storageAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#storage_container_id HdinsightHbaseCluster#storage_container_id}
    */
    readonly storageContainerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#storage_resource_id HdinsightHbaseCluster#storage_resource_id}
    */
    readonly storageResourceId?: string;
}
export declare function hdinsightHbaseClusterStorageAccountToTerraform(struct?: HdinsightHbaseClusterStorageAccount | cdktf.IResolvable): any;
export declare function hdinsightHbaseClusterStorageAccountToHclTerraform(struct?: HdinsightHbaseClusterStorageAccount | cdktf.IResolvable): any;
export declare class HdinsightHbaseClusterStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHbaseClusterStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHbaseClusterStorageAccount | cdktf.IResolvable | undefined);
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    get storageAccountKeyInput(): string | undefined;
    private _storageContainerId?;
    get storageContainerId(): string;
    set storageContainerId(value: string);
    get storageContainerIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    resetStorageResourceId(): void;
    get storageResourceIdInput(): string | undefined;
}
export declare class HdinsightHbaseClusterStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHbaseClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHbaseClusterStorageAccountOutputReference;
}
export interface HdinsightHbaseClusterStorageAccountGen2 {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#filesystem_id HdinsightHbaseCluster#filesystem_id}
    */
    readonly filesystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#is_default HdinsightHbaseCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#managed_identity_resource_id HdinsightHbaseCluster#managed_identity_resource_id}
    */
    readonly managedIdentityResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#storage_resource_id HdinsightHbaseCluster#storage_resource_id}
    */
    readonly storageResourceId: string;
}
export declare function hdinsightHbaseClusterStorageAccountGen2ToTerraform(struct?: HdinsightHbaseClusterStorageAccountGen2OutputReference | HdinsightHbaseClusterStorageAccountGen2): any;
export declare function hdinsightHbaseClusterStorageAccountGen2ToHclTerraform(struct?: HdinsightHbaseClusterStorageAccountGen2OutputReference | HdinsightHbaseClusterStorageAccountGen2): any;
export declare class HdinsightHbaseClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterStorageAccountGen2 | undefined;
    set internalValue(value: HdinsightHbaseClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    get filesystemId(): string;
    set filesystemId(value: string);
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    get managedIdentityResourceId(): string;
    set managedIdentityResourceId(value: string);
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    get storageResourceIdInput(): string | undefined;
}
export interface HdinsightHbaseClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#create HdinsightHbaseCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#delete HdinsightHbaseCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#read HdinsightHbaseCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#update HdinsightHbaseCluster#update}
    */
    readonly update?: string;
}
export declare function hdinsightHbaseClusterTimeoutsToTerraform(struct?: HdinsightHbaseClusterTimeouts | cdktf.IResolvable): any;
export declare function hdinsightHbaseClusterTimeoutsToHclTerraform(struct?: HdinsightHbaseClusterTimeouts | cdktf.IResolvable): any;
export declare class HdinsightHbaseClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHbaseClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHbaseClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster azurerm_hdinsight_hbase_cluster}
*/
export declare class HdinsightHbaseCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_hdinsight_hbase_cluster";
    /**
    * Generates CDKTF code for importing a HdinsightHbaseCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HdinsightHbaseCluster to import
    * @param importFromId The id of the existing HdinsightHbaseCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HdinsightHbaseCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/hdinsight_hbase_cluster azurerm_hdinsight_hbase_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HdinsightHbaseClusterConfig
    */
    constructor(scope: Construct, id: string, config: HdinsightHbaseClusterConfig);
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    get httpsEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sshEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    get tlsMinVersion(): string;
    set tlsMinVersion(value: string);
    resetTlsMinVersion(): void;
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    get componentVersion(): HdinsightHbaseClusterComponentVersionOutputReference;
    putComponentVersion(value: HdinsightHbaseClusterComponentVersion): void;
    get componentVersionInput(): HdinsightHbaseClusterComponentVersion | undefined;
    private _computeIsolation;
    get computeIsolation(): HdinsightHbaseClusterComputeIsolationOutputReference;
    putComputeIsolation(value: HdinsightHbaseClusterComputeIsolation): void;
    resetComputeIsolation(): void;
    get computeIsolationInput(): HdinsightHbaseClusterComputeIsolation | undefined;
    private _diskEncryption;
    get diskEncryption(): HdinsightHbaseClusterDiskEncryptionList;
    putDiskEncryption(value: HdinsightHbaseClusterDiskEncryption[] | cdktf.IResolvable): void;
    resetDiskEncryption(): void;
    get diskEncryptionInput(): cdktf.IResolvable | HdinsightHbaseClusterDiskEncryption[] | undefined;
    private _extension;
    get extension(): HdinsightHbaseClusterExtensionOutputReference;
    putExtension(value: HdinsightHbaseClusterExtension): void;
    resetExtension(): void;
    get extensionInput(): HdinsightHbaseClusterExtension | undefined;
    private _gateway;
    get gateway(): HdinsightHbaseClusterGatewayOutputReference;
    putGateway(value: HdinsightHbaseClusterGateway): void;
    get gatewayInput(): HdinsightHbaseClusterGateway | undefined;
    private _metastores;
    get metastores(): HdinsightHbaseClusterMetastoresOutputReference;
    putMetastores(value: HdinsightHbaseClusterMetastores): void;
    resetMetastores(): void;
    get metastoresInput(): HdinsightHbaseClusterMetastores | undefined;
    private _monitor;
    get monitor(): HdinsightHbaseClusterMonitorOutputReference;
    putMonitor(value: HdinsightHbaseClusterMonitor): void;
    resetMonitor(): void;
    get monitorInput(): HdinsightHbaseClusterMonitor | undefined;
    private _network;
    get network(): HdinsightHbaseClusterNetworkOutputReference;
    putNetwork(value: HdinsightHbaseClusterNetwork): void;
    resetNetwork(): void;
    get networkInput(): HdinsightHbaseClusterNetwork | undefined;
    private _roles;
    get roles(): HdinsightHbaseClusterRolesOutputReference;
    putRoles(value: HdinsightHbaseClusterRoles): void;
    get rolesInput(): HdinsightHbaseClusterRoles | undefined;
    private _securityProfile;
    get securityProfile(): HdinsightHbaseClusterSecurityProfileOutputReference;
    putSecurityProfile(value: HdinsightHbaseClusterSecurityProfile): void;
    resetSecurityProfile(): void;
    get securityProfileInput(): HdinsightHbaseClusterSecurityProfile | undefined;
    private _storageAccount;
    get storageAccount(): HdinsightHbaseClusterStorageAccountList;
    putStorageAccount(value: HdinsightHbaseClusterStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | HdinsightHbaseClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    get storageAccountGen2(): HdinsightHbaseClusterStorageAccountGen2OutputReference;
    putStorageAccountGen2(value: HdinsightHbaseClusterStorageAccountGen2): void;
    resetStorageAccountGen2(): void;
    get storageAccountGen2Input(): HdinsightHbaseClusterStorageAccountGen2 | undefined;
    private _timeouts;
    get timeouts(): HdinsightHbaseClusterTimeoutsOutputReference;
    putTimeouts(value: HdinsightHbaseClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HdinsightHbaseClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
