/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IotcentralApplicationNetworkRuleSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#apply_to_device IotcentralApplicationNetworkRuleSet#apply_to_device}
    */
    readonly applyToDevice?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#default_action IotcentralApplicationNetworkRuleSet#default_action}
    */
    readonly defaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#id IotcentralApplicationNetworkRuleSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#iotcentral_application_id IotcentralApplicationNetworkRuleSet#iotcentral_application_id}
    */
    readonly iotcentralApplicationId: string;
    /**
    * ip_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#ip_rule IotcentralApplicationNetworkRuleSet#ip_rule}
    */
    readonly ipRule?: IotcentralApplicationNetworkRuleSetIpRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#timeouts IotcentralApplicationNetworkRuleSet#timeouts}
    */
    readonly timeouts?: IotcentralApplicationNetworkRuleSetTimeouts;
}
export interface IotcentralApplicationNetworkRuleSetIpRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#ip_mask IotcentralApplicationNetworkRuleSet#ip_mask}
    */
    readonly ipMask: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#name IotcentralApplicationNetworkRuleSet#name}
    */
    readonly name: string;
}
export declare function iotcentralApplicationNetworkRuleSetIpRuleToTerraform(struct?: IotcentralApplicationNetworkRuleSetIpRule | cdktf.IResolvable): any;
export declare function iotcentralApplicationNetworkRuleSetIpRuleToHclTerraform(struct?: IotcentralApplicationNetworkRuleSetIpRule | cdktf.IResolvable): any;
export declare class IotcentralApplicationNetworkRuleSetIpRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IotcentralApplicationNetworkRuleSetIpRule | cdktf.IResolvable | undefined;
    set internalValue(value: IotcentralApplicationNetworkRuleSetIpRule | cdktf.IResolvable | undefined);
    private _ipMask?;
    get ipMask(): string;
    set ipMask(value: string);
    get ipMaskInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class IotcentralApplicationNetworkRuleSetIpRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IotcentralApplicationNetworkRuleSetIpRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IotcentralApplicationNetworkRuleSetIpRuleOutputReference;
}
export interface IotcentralApplicationNetworkRuleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#create IotcentralApplicationNetworkRuleSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#delete IotcentralApplicationNetworkRuleSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#read IotcentralApplicationNetworkRuleSet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#update IotcentralApplicationNetworkRuleSet#update}
    */
    readonly update?: string;
}
export declare function iotcentralApplicationNetworkRuleSetTimeoutsToTerraform(struct?: IotcentralApplicationNetworkRuleSetTimeouts | cdktf.IResolvable): any;
export declare function iotcentralApplicationNetworkRuleSetTimeoutsToHclTerraform(struct?: IotcentralApplicationNetworkRuleSetTimeouts | cdktf.IResolvable): any;
export declare class IotcentralApplicationNetworkRuleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotcentralApplicationNetworkRuleSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IotcentralApplicationNetworkRuleSetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set azurerm_iotcentral_application_network_rule_set}
*/
export declare class IotcentralApplicationNetworkRuleSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iotcentral_application_network_rule_set";
    /**
    * Generates CDKTF code for importing a IotcentralApplicationNetworkRuleSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the IotcentralApplicationNetworkRuleSet to import
    * @param importFromId The id of the existing IotcentralApplicationNetworkRuleSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the IotcentralApplicationNetworkRuleSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/iotcentral_application_network_rule_set azurerm_iotcentral_application_network_rule_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotcentralApplicationNetworkRuleSetConfig
    */
    constructor(scope: Construct, id: string, config: IotcentralApplicationNetworkRuleSetConfig);
    private _applyToDevice?;
    get applyToDevice(): boolean | cdktf.IResolvable;
    set applyToDevice(value: boolean | cdktf.IResolvable);
    resetApplyToDevice(): void;
    get applyToDeviceInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    resetDefaultAction(): void;
    get defaultActionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iotcentralApplicationId?;
    get iotcentralApplicationId(): string;
    set iotcentralApplicationId(value: string);
    get iotcentralApplicationIdInput(): string | undefined;
    private _ipRule;
    get ipRule(): IotcentralApplicationNetworkRuleSetIpRuleList;
    putIpRule(value: IotcentralApplicationNetworkRuleSetIpRule[] | cdktf.IResolvable): void;
    resetIpRule(): void;
    get ipRuleInput(): cdktf.IResolvable | IotcentralApplicationNetworkRuleSetIpRule[] | undefined;
    private _timeouts;
    get timeouts(): IotcentralApplicationNetworkRuleSetTimeoutsOutputReference;
    putTimeouts(value: IotcentralApplicationNetworkRuleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IotcentralApplicationNetworkRuleSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
