/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesFleetUpdateRunConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#fleet_update_strategy_id KubernetesFleetUpdateRun#fleet_update_strategy_id}
    */
    readonly fleetUpdateStrategyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#id KubernetesFleetUpdateRun#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#kubernetes_fleet_manager_id KubernetesFleetUpdateRun#kubernetes_fleet_manager_id}
    */
    readonly kubernetesFleetManagerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#name KubernetesFleetUpdateRun#name}
    */
    readonly name: string;
    /**
    * managed_cluster_update block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#managed_cluster_update KubernetesFleetUpdateRun#managed_cluster_update}
    */
    readonly managedClusterUpdate: KubernetesFleetUpdateRunManagedClusterUpdate;
    /**
    * stage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#stage KubernetesFleetUpdateRun#stage}
    */
    readonly stage?: KubernetesFleetUpdateRunStage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#timeouts KubernetesFleetUpdateRun#timeouts}
    */
    readonly timeouts?: KubernetesFleetUpdateRunTimeouts;
}
export interface KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelection {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#type KubernetesFleetUpdateRun#type}
    */
    readonly type: string;
}
export declare function kubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelectionToTerraform(struct?: KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelectionOutputReference | KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelection): any;
export declare function kubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelectionToHclTerraform(struct?: KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelectionOutputReference | KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelection): any;
export declare class KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelection | undefined;
    set internalValue(value: KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelection | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface KubernetesFleetUpdateRunManagedClusterUpdateUpgrade {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#kubernetes_version KubernetesFleetUpdateRun#kubernetes_version}
    */
    readonly kubernetesVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#type KubernetesFleetUpdateRun#type}
    */
    readonly type: string;
}
export declare function kubernetesFleetUpdateRunManagedClusterUpdateUpgradeToTerraform(struct?: KubernetesFleetUpdateRunManagedClusterUpdateUpgradeOutputReference | KubernetesFleetUpdateRunManagedClusterUpdateUpgrade): any;
export declare function kubernetesFleetUpdateRunManagedClusterUpdateUpgradeToHclTerraform(struct?: KubernetesFleetUpdateRunManagedClusterUpdateUpgradeOutputReference | KubernetesFleetUpdateRunManagedClusterUpdateUpgrade): any;
export declare class KubernetesFleetUpdateRunManagedClusterUpdateUpgradeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFleetUpdateRunManagedClusterUpdateUpgrade | undefined;
    set internalValue(value: KubernetesFleetUpdateRunManagedClusterUpdateUpgrade | undefined);
    private _kubernetesVersion?;
    get kubernetesVersion(): string;
    set kubernetesVersion(value: string);
    resetKubernetesVersion(): void;
    get kubernetesVersionInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface KubernetesFleetUpdateRunManagedClusterUpdate {
    /**
    * node_image_selection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#node_image_selection KubernetesFleetUpdateRun#node_image_selection}
    */
    readonly nodeImageSelection?: KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelection;
    /**
    * upgrade block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#upgrade KubernetesFleetUpdateRun#upgrade}
    */
    readonly upgrade: KubernetesFleetUpdateRunManagedClusterUpdateUpgrade;
}
export declare function kubernetesFleetUpdateRunManagedClusterUpdateToTerraform(struct?: KubernetesFleetUpdateRunManagedClusterUpdateOutputReference | KubernetesFleetUpdateRunManagedClusterUpdate): any;
export declare function kubernetesFleetUpdateRunManagedClusterUpdateToHclTerraform(struct?: KubernetesFleetUpdateRunManagedClusterUpdateOutputReference | KubernetesFleetUpdateRunManagedClusterUpdate): any;
export declare class KubernetesFleetUpdateRunManagedClusterUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFleetUpdateRunManagedClusterUpdate | undefined;
    set internalValue(value: KubernetesFleetUpdateRunManagedClusterUpdate | undefined);
    private _nodeImageSelection;
    get nodeImageSelection(): KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelectionOutputReference;
    putNodeImageSelection(value: KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelection): void;
    resetNodeImageSelection(): void;
    get nodeImageSelectionInput(): KubernetesFleetUpdateRunManagedClusterUpdateNodeImageSelection | undefined;
    private _upgrade;
    get upgrade(): KubernetesFleetUpdateRunManagedClusterUpdateUpgradeOutputReference;
    putUpgrade(value: KubernetesFleetUpdateRunManagedClusterUpdateUpgrade): void;
    get upgradeInput(): KubernetesFleetUpdateRunManagedClusterUpdateUpgrade | undefined;
}
export interface KubernetesFleetUpdateRunStageGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#name KubernetesFleetUpdateRun#name}
    */
    readonly name: string;
}
export declare function kubernetesFleetUpdateRunStageGroupToTerraform(struct?: KubernetesFleetUpdateRunStageGroup | cdktf.IResolvable): any;
export declare function kubernetesFleetUpdateRunStageGroupToHclTerraform(struct?: KubernetesFleetUpdateRunStageGroup | cdktf.IResolvable): any;
export declare class KubernetesFleetUpdateRunStageGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesFleetUpdateRunStageGroup | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFleetUpdateRunStageGroup | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class KubernetesFleetUpdateRunStageGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesFleetUpdateRunStageGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesFleetUpdateRunStageGroupOutputReference;
}
export interface KubernetesFleetUpdateRunStage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#after_stage_wait_in_seconds KubernetesFleetUpdateRun#after_stage_wait_in_seconds}
    */
    readonly afterStageWaitInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#name KubernetesFleetUpdateRun#name}
    */
    readonly name: string;
    /**
    * group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#group KubernetesFleetUpdateRun#group}
    */
    readonly group: KubernetesFleetUpdateRunStageGroup[] | cdktf.IResolvable;
}
export declare function kubernetesFleetUpdateRunStageToTerraform(struct?: KubernetesFleetUpdateRunStage | cdktf.IResolvable): any;
export declare function kubernetesFleetUpdateRunStageToHclTerraform(struct?: KubernetesFleetUpdateRunStage | cdktf.IResolvable): any;
export declare class KubernetesFleetUpdateRunStageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesFleetUpdateRunStage | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFleetUpdateRunStage | cdktf.IResolvable | undefined);
    private _afterStageWaitInSeconds?;
    get afterStageWaitInSeconds(): number;
    set afterStageWaitInSeconds(value: number);
    resetAfterStageWaitInSeconds(): void;
    get afterStageWaitInSecondsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _group;
    get group(): KubernetesFleetUpdateRunStageGroupList;
    putGroup(value: KubernetesFleetUpdateRunStageGroup[] | cdktf.IResolvable): void;
    get groupInput(): cdktf.IResolvable | KubernetesFleetUpdateRunStageGroup[] | undefined;
}
export declare class KubernetesFleetUpdateRunStageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesFleetUpdateRunStage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesFleetUpdateRunStageOutputReference;
}
export interface KubernetesFleetUpdateRunTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#create KubernetesFleetUpdateRun#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#delete KubernetesFleetUpdateRun#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#read KubernetesFleetUpdateRun#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#update KubernetesFleetUpdateRun#update}
    */
    readonly update?: string;
}
export declare function kubernetesFleetUpdateRunTimeoutsToTerraform(struct?: KubernetesFleetUpdateRunTimeouts | cdktf.IResolvable): any;
export declare function kubernetesFleetUpdateRunTimeoutsToHclTerraform(struct?: KubernetesFleetUpdateRunTimeouts | cdktf.IResolvable): any;
export declare class KubernetesFleetUpdateRunTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFleetUpdateRunTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFleetUpdateRunTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run azurerm_kubernetes_fleet_update_run}
*/
export declare class KubernetesFleetUpdateRun extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kubernetes_fleet_update_run";
    /**
    * Generates CDKTF code for importing a KubernetesFleetUpdateRun resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesFleetUpdateRun to import
    * @param importFromId The id of the existing KubernetesFleetUpdateRun that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesFleetUpdateRun to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/kubernetes_fleet_update_run azurerm_kubernetes_fleet_update_run} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesFleetUpdateRunConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesFleetUpdateRunConfig);
    private _fleetUpdateStrategyId?;
    get fleetUpdateStrategyId(): string;
    set fleetUpdateStrategyId(value: string);
    resetFleetUpdateStrategyId(): void;
    get fleetUpdateStrategyIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesFleetManagerId?;
    get kubernetesFleetManagerId(): string;
    set kubernetesFleetManagerId(value: string);
    get kubernetesFleetManagerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _managedClusterUpdate;
    get managedClusterUpdate(): KubernetesFleetUpdateRunManagedClusterUpdateOutputReference;
    putManagedClusterUpdate(value: KubernetesFleetUpdateRunManagedClusterUpdate): void;
    get managedClusterUpdateInput(): KubernetesFleetUpdateRunManagedClusterUpdate | undefined;
    private _stage;
    get stage(): KubernetesFleetUpdateRunStageList;
    putStage(value: KubernetesFleetUpdateRunStage[] | cdktf.IResolvable): void;
    resetStage(): void;
    get stageInput(): cdktf.IResolvable | KubernetesFleetUpdateRunStage[] | undefined;
    private _timeouts;
    get timeouts(): KubernetesFleetUpdateRunTimeoutsOutputReference;
    putTimeouts(value: KubernetesFleetUpdateRunTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesFleetUpdateRunTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
