/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbBackendAddressPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#id LbBackendAddressPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#loadbalancer_id LbBackendAddressPool#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#name LbBackendAddressPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#virtual_network_id LbBackendAddressPool#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#timeouts LbBackendAddressPool#timeouts}
    */
    readonly timeouts?: LbBackendAddressPoolTimeouts;
    /**
    * tunnel_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#tunnel_interface LbBackendAddressPool#tunnel_interface}
    */
    readonly tunnelInterface?: LbBackendAddressPoolTunnelInterface[] | cdktf.IResolvable;
}
export interface LbBackendAddressPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#create LbBackendAddressPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#delete LbBackendAddressPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#read LbBackendAddressPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#update LbBackendAddressPool#update}
    */
    readonly update?: string;
}
export declare function lbBackendAddressPoolTimeoutsToTerraform(struct?: LbBackendAddressPoolTimeouts | cdktf.IResolvable): any;
export declare function lbBackendAddressPoolTimeoutsToHclTerraform(struct?: LbBackendAddressPoolTimeouts | cdktf.IResolvable): any;
export declare class LbBackendAddressPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbBackendAddressPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LbBackendAddressPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface LbBackendAddressPoolTunnelInterface {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#identifier LbBackendAddressPool#identifier}
    */
    readonly identifier: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#port LbBackendAddressPool#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#protocol LbBackendAddressPool#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#type LbBackendAddressPool#type}
    */
    readonly type: string;
}
export declare function lbBackendAddressPoolTunnelInterfaceToTerraform(struct?: LbBackendAddressPoolTunnelInterface | cdktf.IResolvable): any;
export declare function lbBackendAddressPoolTunnelInterfaceToHclTerraform(struct?: LbBackendAddressPoolTunnelInterface | cdktf.IResolvable): any;
export declare class LbBackendAddressPoolTunnelInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LbBackendAddressPoolTunnelInterface | cdktf.IResolvable | undefined;
    set internalValue(value: LbBackendAddressPoolTunnelInterface | cdktf.IResolvable | undefined);
    private _identifier?;
    get identifier(): number;
    set identifier(value: number);
    get identifierInput(): number | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class LbBackendAddressPoolTunnelInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LbBackendAddressPoolTunnelInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LbBackendAddressPoolTunnelInterfaceOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool azurerm_lb_backend_address_pool}
*/
export declare class LbBackendAddressPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lb_backend_address_pool";
    /**
    * Generates CDKTF code for importing a LbBackendAddressPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LbBackendAddressPool to import
    * @param importFromId The id of the existing LbBackendAddressPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LbBackendAddressPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/lb_backend_address_pool azurerm_lb_backend_address_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbBackendAddressPoolConfig
    */
    constructor(scope: Construct, id: string, config: LbBackendAddressPoolConfig);
    get backendIpConfigurations(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get inboundNatRules(): string[];
    get loadBalancingRules(): string[];
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundRules(): string[];
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): LbBackendAddressPoolTimeoutsOutputReference;
    putTimeouts(value: LbBackendAddressPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LbBackendAddressPoolTimeouts | undefined;
    private _tunnelInterface;
    get tunnelInterface(): LbBackendAddressPoolTunnelInterfaceList;
    putTunnelInterface(value: LbBackendAddressPoolTunnelInterface[] | cdktf.IResolvable): void;
    resetTunnelInterface(): void;
    get tunnelInterfaceInput(): cdktf.IResolvable | LbBackendAddressPoolTunnelInterface[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
