/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogzTagRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#id LogzTagRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#logz_monitor_id LogzTagRule#logz_monitor_id}
    */
    readonly logzMonitorId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#send_aad_logs LogzTagRule#send_aad_logs}
    */
    readonly sendAadLogs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#send_activity_logs LogzTagRule#send_activity_logs}
    */
    readonly sendActivityLogs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#send_subscription_logs LogzTagRule#send_subscription_logs}
    */
    readonly sendSubscriptionLogs?: boolean | cdktf.IResolvable;
    /**
    * tag_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#tag_filter LogzTagRule#tag_filter}
    */
    readonly tagFilter?: LogzTagRuleTagFilter[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#timeouts LogzTagRule#timeouts}
    */
    readonly timeouts?: LogzTagRuleTimeouts;
}
export interface LogzTagRuleTagFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#action LogzTagRule#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#name LogzTagRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#value LogzTagRule#value}
    */
    readonly value?: string;
}
export declare function logzTagRuleTagFilterToTerraform(struct?: LogzTagRuleTagFilter | cdktf.IResolvable): any;
export declare function logzTagRuleTagFilterToHclTerraform(struct?: LogzTagRuleTagFilter | cdktf.IResolvable): any;
export declare class LogzTagRuleTagFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogzTagRuleTagFilter | cdktf.IResolvable | undefined;
    set internalValue(value: LogzTagRuleTagFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class LogzTagRuleTagFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogzTagRuleTagFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogzTagRuleTagFilterOutputReference;
}
export interface LogzTagRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#create LogzTagRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#delete LogzTagRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#read LogzTagRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#update LogzTagRule#update}
    */
    readonly update?: string;
}
export declare function logzTagRuleTimeoutsToTerraform(struct?: LogzTagRuleTimeouts | cdktf.IResolvable): any;
export declare function logzTagRuleTimeoutsToHclTerraform(struct?: LogzTagRuleTimeouts | cdktf.IResolvable): any;
export declare class LogzTagRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogzTagRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogzTagRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule azurerm_logz_tag_rule}
*/
export declare class LogzTagRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logz_tag_rule";
    /**
    * Generates CDKTF code for importing a LogzTagRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LogzTagRule to import
    * @param importFromId The id of the existing LogzTagRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LogzTagRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/logz_tag_rule azurerm_logz_tag_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogzTagRuleConfig
    */
    constructor(scope: Construct, id: string, config: LogzTagRuleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logzMonitorId?;
    get logzMonitorId(): string;
    set logzMonitorId(value: string);
    get logzMonitorIdInput(): string | undefined;
    private _sendAadLogs?;
    get sendAadLogs(): boolean | cdktf.IResolvable;
    set sendAadLogs(value: boolean | cdktf.IResolvable);
    resetSendAadLogs(): void;
    get sendAadLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _sendActivityLogs?;
    get sendActivityLogs(): boolean | cdktf.IResolvable;
    set sendActivityLogs(value: boolean | cdktf.IResolvable);
    resetSendActivityLogs(): void;
    get sendActivityLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _sendSubscriptionLogs?;
    get sendSubscriptionLogs(): boolean | cdktf.IResolvable;
    set sendSubscriptionLogs(value: boolean | cdktf.IResolvable);
    resetSendSubscriptionLogs(): void;
    get sendSubscriptionLogsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagFilter;
    get tagFilter(): LogzTagRuleTagFilterList;
    putTagFilter(value: LogzTagRuleTagFilter[] | cdktf.IResolvable): void;
    resetTagFilter(): void;
    get tagFilterInput(): cdktf.IResolvable | LogzTagRuleTagFilter[] | undefined;
    private _timeouts;
    get timeouts(): LogzTagRuleTimeoutsOutputReference;
    putTimeouts(value: LogzTagRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogzTagRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
