/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MachineLearningComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#authorization_type MachineLearningComputeInstance#authorization_type}
    */
    readonly authorizationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#description MachineLearningComputeInstance#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#id MachineLearningComputeInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#local_auth_enabled MachineLearningComputeInstance#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#location MachineLearningComputeInstance#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#machine_learning_workspace_id MachineLearningComputeInstance#machine_learning_workspace_id}
    */
    readonly machineLearningWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#name MachineLearningComputeInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#node_public_ip_enabled MachineLearningComputeInstance#node_public_ip_enabled}
    */
    readonly nodePublicIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#subnet_resource_id MachineLearningComputeInstance#subnet_resource_id}
    */
    readonly subnetResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#tags MachineLearningComputeInstance#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#virtual_machine_size MachineLearningComputeInstance#virtual_machine_size}
    */
    readonly virtualMachineSize: string;
    /**
    * assign_to_user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#assign_to_user MachineLearningComputeInstance#assign_to_user}
    */
    readonly assignToUser?: MachineLearningComputeInstanceAssignToUser;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#identity MachineLearningComputeInstance#identity}
    */
    readonly identity?: MachineLearningComputeInstanceIdentity;
    /**
    * ssh block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#ssh MachineLearningComputeInstance#ssh}
    */
    readonly ssh?: MachineLearningComputeInstanceSsh;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#timeouts MachineLearningComputeInstance#timeouts}
    */
    readonly timeouts?: MachineLearningComputeInstanceTimeouts;
}
export interface MachineLearningComputeInstanceAssignToUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#object_id MachineLearningComputeInstance#object_id}
    */
    readonly objectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#tenant_id MachineLearningComputeInstance#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function machineLearningComputeInstanceAssignToUserToTerraform(struct?: MachineLearningComputeInstanceAssignToUserOutputReference | MachineLearningComputeInstanceAssignToUser): any;
export declare function machineLearningComputeInstanceAssignToUserToHclTerraform(struct?: MachineLearningComputeInstanceAssignToUserOutputReference | MachineLearningComputeInstanceAssignToUser): any;
export declare class MachineLearningComputeInstanceAssignToUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningComputeInstanceAssignToUser | undefined;
    set internalValue(value: MachineLearningComputeInstanceAssignToUser | undefined);
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface MachineLearningComputeInstanceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#identity_ids MachineLearningComputeInstance#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#type MachineLearningComputeInstance#type}
    */
    readonly type: string;
}
export declare function machineLearningComputeInstanceIdentityToTerraform(struct?: MachineLearningComputeInstanceIdentityOutputReference | MachineLearningComputeInstanceIdentity): any;
export declare function machineLearningComputeInstanceIdentityToHclTerraform(struct?: MachineLearningComputeInstanceIdentityOutputReference | MachineLearningComputeInstanceIdentity): any;
export declare class MachineLearningComputeInstanceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningComputeInstanceIdentity | undefined;
    set internalValue(value: MachineLearningComputeInstanceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MachineLearningComputeInstanceSsh {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#public_key MachineLearningComputeInstance#public_key}
    */
    readonly publicKey: string;
}
export declare function machineLearningComputeInstanceSshToTerraform(struct?: MachineLearningComputeInstanceSshOutputReference | MachineLearningComputeInstanceSsh): any;
export declare function machineLearningComputeInstanceSshToHclTerraform(struct?: MachineLearningComputeInstanceSshOutputReference | MachineLearningComputeInstanceSsh): any;
export declare class MachineLearningComputeInstanceSshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningComputeInstanceSsh | undefined;
    set internalValue(value: MachineLearningComputeInstanceSsh | undefined);
    get port(): number;
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    get publicKeyInput(): string | undefined;
    get username(): string;
}
export interface MachineLearningComputeInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#create MachineLearningComputeInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#delete MachineLearningComputeInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#read MachineLearningComputeInstance#read}
    */
    readonly read?: string;
}
export declare function machineLearningComputeInstanceTimeoutsToTerraform(struct?: MachineLearningComputeInstanceTimeouts | cdktf.IResolvable): any;
export declare function machineLearningComputeInstanceTimeoutsToHclTerraform(struct?: MachineLearningComputeInstanceTimeouts | cdktf.IResolvable): any;
export declare class MachineLearningComputeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningComputeInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MachineLearningComputeInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance azurerm_machine_learning_compute_instance}
*/
export declare class MachineLearningComputeInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_machine_learning_compute_instance";
    /**
    * Generates CDKTF code for importing a MachineLearningComputeInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MachineLearningComputeInstance to import
    * @param importFromId The id of the existing MachineLearningComputeInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MachineLearningComputeInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/machine_learning_compute_instance azurerm_machine_learning_compute_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MachineLearningComputeInstanceConfig
    */
    constructor(scope: Construct, id: string, config: MachineLearningComputeInstanceConfig);
    private _authorizationType?;
    get authorizationType(): string;
    set authorizationType(value: string);
    resetAuthorizationType(): void;
    get authorizationTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _machineLearningWorkspaceId?;
    get machineLearningWorkspaceId(): string;
    set machineLearningWorkspaceId(value: string);
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodePublicIpEnabled?;
    get nodePublicIpEnabled(): boolean | cdktf.IResolvable;
    set nodePublicIpEnabled(value: boolean | cdktf.IResolvable);
    resetNodePublicIpEnabled(): void;
    get nodePublicIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetResourceId?;
    get subnetResourceId(): string;
    set subnetResourceId(value: string);
    resetSubnetResourceId(): void;
    get subnetResourceIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualMachineSize?;
    get virtualMachineSize(): string;
    set virtualMachineSize(value: string);
    get virtualMachineSizeInput(): string | undefined;
    private _assignToUser;
    get assignToUser(): MachineLearningComputeInstanceAssignToUserOutputReference;
    putAssignToUser(value: MachineLearningComputeInstanceAssignToUser): void;
    resetAssignToUser(): void;
    get assignToUserInput(): MachineLearningComputeInstanceAssignToUser | undefined;
    private _identity;
    get identity(): MachineLearningComputeInstanceIdentityOutputReference;
    putIdentity(value: MachineLearningComputeInstanceIdentity): void;
    resetIdentity(): void;
    get identityInput(): MachineLearningComputeInstanceIdentity | undefined;
    private _ssh;
    get ssh(): MachineLearningComputeInstanceSshOutputReference;
    putSsh(value: MachineLearningComputeInstanceSsh): void;
    resetSsh(): void;
    get sshInput(): MachineLearningComputeInstanceSsh | undefined;
    private _timeouts;
    get timeouts(): MachineLearningComputeInstanceTimeoutsOutputReference;
    putTimeouts(value: MachineLearningComputeInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MachineLearningComputeInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
