/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaStreamingLocatorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#alternative_media_id MediaStreamingLocator#alternative_media_id}
    */
    readonly alternativeMediaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#asset_name MediaStreamingLocator#asset_name}
    */
    readonly assetName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#default_content_key_policy_name MediaStreamingLocator#default_content_key_policy_name}
    */
    readonly defaultContentKeyPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#end_time MediaStreamingLocator#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#filter_names MediaStreamingLocator#filter_names}
    */
    readonly filterNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#id MediaStreamingLocator#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#media_services_account_name MediaStreamingLocator#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#name MediaStreamingLocator#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#resource_group_name MediaStreamingLocator#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#start_time MediaStreamingLocator#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#streaming_locator_id MediaStreamingLocator#streaming_locator_id}
    */
    readonly streamingLocatorId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#streaming_policy_name MediaStreamingLocator#streaming_policy_name}
    */
    readonly streamingPolicyName: string;
    /**
    * content_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#content_key MediaStreamingLocator#content_key}
    */
    readonly contentKey?: MediaStreamingLocatorContentKey[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#timeouts MediaStreamingLocator#timeouts}
    */
    readonly timeouts?: MediaStreamingLocatorTimeouts;
}
export interface MediaStreamingLocatorContentKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#content_key_id MediaStreamingLocator#content_key_id}
    */
    readonly contentKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#label_reference_in_streaming_policy MediaStreamingLocator#label_reference_in_streaming_policy}
    */
    readonly labelReferenceInStreamingPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#policy_name MediaStreamingLocator#policy_name}
    */
    readonly policyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#type MediaStreamingLocator#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#value MediaStreamingLocator#value}
    */
    readonly value?: string;
}
export declare function mediaStreamingLocatorContentKeyToTerraform(struct?: MediaStreamingLocatorContentKey | cdktf.IResolvable): any;
export declare function mediaStreamingLocatorContentKeyToHclTerraform(struct?: MediaStreamingLocatorContentKey | cdktf.IResolvable): any;
export declare class MediaStreamingLocatorContentKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingLocatorContentKey | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingLocatorContentKey | cdktf.IResolvable | undefined);
    private _contentKeyId?;
    get contentKeyId(): string;
    set contentKeyId(value: string);
    resetContentKeyId(): void;
    get contentKeyIdInput(): string | undefined;
    private _labelReferenceInStreamingPolicy?;
    get labelReferenceInStreamingPolicy(): string;
    set labelReferenceInStreamingPolicy(value: string);
    resetLabelReferenceInStreamingPolicy(): void;
    get labelReferenceInStreamingPolicyInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class MediaStreamingLocatorContentKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaStreamingLocatorContentKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingLocatorContentKeyOutputReference;
}
export interface MediaStreamingLocatorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#create MediaStreamingLocator#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#delete MediaStreamingLocator#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#read MediaStreamingLocator#read}
    */
    readonly read?: string;
}
export declare function mediaStreamingLocatorTimeoutsToTerraform(struct?: MediaStreamingLocatorTimeouts | cdktf.IResolvable): any;
export declare function mediaStreamingLocatorTimeoutsToHclTerraform(struct?: MediaStreamingLocatorTimeouts | cdktf.IResolvable): any;
export declare class MediaStreamingLocatorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingLocatorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingLocatorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator azurerm_media_streaming_locator}
*/
export declare class MediaStreamingLocator extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_streaming_locator";
    /**
    * Generates CDKTF code for importing a MediaStreamingLocator resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MediaStreamingLocator to import
    * @param importFromId The id of the existing MediaStreamingLocator that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MediaStreamingLocator to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/media_streaming_locator azurerm_media_streaming_locator} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaStreamingLocatorConfig
    */
    constructor(scope: Construct, id: string, config: MediaStreamingLocatorConfig);
    private _alternativeMediaId?;
    get alternativeMediaId(): string;
    set alternativeMediaId(value: string);
    resetAlternativeMediaId(): void;
    get alternativeMediaIdInput(): string | undefined;
    private _assetName?;
    get assetName(): string;
    set assetName(value: string);
    get assetNameInput(): string | undefined;
    private _defaultContentKeyPolicyName?;
    get defaultContentKeyPolicyName(): string;
    set defaultContentKeyPolicyName(value: string);
    resetDefaultContentKeyPolicyName(): void;
    get defaultContentKeyPolicyNameInput(): string | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _filterNames?;
    get filterNames(): string[];
    set filterNames(value: string[]);
    resetFilterNames(): void;
    get filterNamesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _streamingLocatorId?;
    get streamingLocatorId(): string;
    set streamingLocatorId(value: string);
    resetStreamingLocatorId(): void;
    get streamingLocatorIdInput(): string | undefined;
    private _streamingPolicyName?;
    get streamingPolicyName(): string;
    set streamingPolicyName(value: string);
    get streamingPolicyNameInput(): string | undefined;
    private _contentKey;
    get contentKey(): MediaStreamingLocatorContentKeyList;
    putContentKey(value: MediaStreamingLocatorContentKey[] | cdktf.IResolvable): void;
    resetContentKey(): void;
    get contentKeyInput(): cdktf.IResolvable | MediaStreamingLocatorContentKey[] | undefined;
    private _timeouts;
    get timeouts(): MediaStreamingLocatorTimeoutsOutputReference;
    putTimeouts(value: MediaStreamingLocatorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaStreamingLocatorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
