/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MobileNetworkSimConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#authentication_key MobileNetworkSim#authentication_key}
    */
    readonly authenticationKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#device_type MobileNetworkSim#device_type}
    */
    readonly deviceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#id MobileNetworkSim#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#integrated_circuit_card_identifier MobileNetworkSim#integrated_circuit_card_identifier}
    */
    readonly integratedCircuitCardIdentifier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#international_mobile_subscriber_identity MobileNetworkSim#international_mobile_subscriber_identity}
    */
    readonly internationalMobileSubscriberIdentity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#mobile_network_sim_group_id MobileNetworkSim#mobile_network_sim_group_id}
    */
    readonly mobileNetworkSimGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#name MobileNetworkSim#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#operator_key_code MobileNetworkSim#operator_key_code}
    */
    readonly operatorKeyCode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#sim_policy_id MobileNetworkSim#sim_policy_id}
    */
    readonly simPolicyId?: string;
    /**
    * static_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#static_ip_configuration MobileNetworkSim#static_ip_configuration}
    */
    readonly staticIpConfiguration?: MobileNetworkSimStaticIpConfiguration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#timeouts MobileNetworkSim#timeouts}
    */
    readonly timeouts?: MobileNetworkSimTimeouts;
}
export interface MobileNetworkSimStaticIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#attached_data_network_id MobileNetworkSim#attached_data_network_id}
    */
    readonly attachedDataNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#slice_id MobileNetworkSim#slice_id}
    */
    readonly sliceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#static_ipv4_address MobileNetworkSim#static_ipv4_address}
    */
    readonly staticIpv4Address?: string;
}
export declare function mobileNetworkSimStaticIpConfigurationToTerraform(struct?: MobileNetworkSimStaticIpConfiguration | cdktf.IResolvable): any;
export declare function mobileNetworkSimStaticIpConfigurationToHclTerraform(struct?: MobileNetworkSimStaticIpConfiguration | cdktf.IResolvable): any;
export declare class MobileNetworkSimStaticIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MobileNetworkSimStaticIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkSimStaticIpConfiguration | cdktf.IResolvable | undefined);
    private _attachedDataNetworkId?;
    get attachedDataNetworkId(): string;
    set attachedDataNetworkId(value: string);
    get attachedDataNetworkIdInput(): string | undefined;
    private _sliceId?;
    get sliceId(): string;
    set sliceId(value: string);
    get sliceIdInput(): string | undefined;
    private _staticIpv4Address?;
    get staticIpv4Address(): string;
    set staticIpv4Address(value: string);
    resetStaticIpv4Address(): void;
    get staticIpv4AddressInput(): string | undefined;
}
export declare class MobileNetworkSimStaticIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MobileNetworkSimStaticIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MobileNetworkSimStaticIpConfigurationOutputReference;
}
export interface MobileNetworkSimTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#create MobileNetworkSim#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#delete MobileNetworkSim#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#read MobileNetworkSim#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#update MobileNetworkSim#update}
    */
    readonly update?: string;
}
export declare function mobileNetworkSimTimeoutsToTerraform(struct?: MobileNetworkSimTimeouts | cdktf.IResolvable): any;
export declare function mobileNetworkSimTimeoutsToHclTerraform(struct?: MobileNetworkSimTimeouts | cdktf.IResolvable): any;
export declare class MobileNetworkSimTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkSimTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkSimTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim azurerm_mobile_network_sim}
*/
export declare class MobileNetworkSim extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mobile_network_sim";
    /**
    * Generates CDKTF code for importing a MobileNetworkSim resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MobileNetworkSim to import
    * @param importFromId The id of the existing MobileNetworkSim that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MobileNetworkSim to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/mobile_network_sim azurerm_mobile_network_sim} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MobileNetworkSimConfig
    */
    constructor(scope: Construct, id: string, config: MobileNetworkSimConfig);
    private _authenticationKey?;
    get authenticationKey(): string;
    set authenticationKey(value: string);
    get authenticationKeyInput(): string | undefined;
    private _deviceType?;
    get deviceType(): string;
    set deviceType(value: string);
    resetDeviceType(): void;
    get deviceTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integratedCircuitCardIdentifier?;
    get integratedCircuitCardIdentifier(): string;
    set integratedCircuitCardIdentifier(value: string);
    get integratedCircuitCardIdentifierInput(): string | undefined;
    private _internationalMobileSubscriberIdentity?;
    get internationalMobileSubscriberIdentity(): string;
    set internationalMobileSubscriberIdentity(value: string);
    get internationalMobileSubscriberIdentityInput(): string | undefined;
    private _mobileNetworkSimGroupId?;
    get mobileNetworkSimGroupId(): string;
    set mobileNetworkSimGroupId(value: string);
    get mobileNetworkSimGroupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operatorKeyCode?;
    get operatorKeyCode(): string;
    set operatorKeyCode(value: string);
    get operatorKeyCodeInput(): string | undefined;
    private _simPolicyId?;
    get simPolicyId(): string;
    set simPolicyId(value: string);
    resetSimPolicyId(): void;
    get simPolicyIdInput(): string | undefined;
    get simState(): string;
    get vendorKeyFingerprint(): string;
    get vendorName(): string;
    private _staticIpConfiguration;
    get staticIpConfiguration(): MobileNetworkSimStaticIpConfigurationList;
    putStaticIpConfiguration(value: MobileNetworkSimStaticIpConfiguration[] | cdktf.IResolvable): void;
    resetStaticIpConfiguration(): void;
    get staticIpConfigurationInput(): cdktf.IResolvable | MobileNetworkSimStaticIpConfiguration[] | undefined;
    private _timeouts;
    get timeouts(): MobileNetworkSimTimeoutsOutputReference;
    putTimeouts(value: MobileNetworkSimTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MobileNetworkSimTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
