/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NewRelicMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#account_creation_source NewRelicMonitor#account_creation_source}
    */
    readonly accountCreationSource?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#account_id NewRelicMonitor#account_id}
    */
    readonly accountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#id NewRelicMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#ingestion_key NewRelicMonitor#ingestion_key}
    */
    readonly ingestionKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#location NewRelicMonitor#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#name NewRelicMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#org_creation_source NewRelicMonitor#org_creation_source}
    */
    readonly orgCreationSource?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#organization_id NewRelicMonitor#organization_id}
    */
    readonly organizationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#resource_group_name NewRelicMonitor#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#user_id NewRelicMonitor#user_id}
    */
    readonly userId?: string;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#plan NewRelicMonitor#plan}
    */
    readonly plan: NewRelicMonitorPlan;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#timeouts NewRelicMonitor#timeouts}
    */
    readonly timeouts?: NewRelicMonitorTimeouts;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#user NewRelicMonitor#user}
    */
    readonly user: NewRelicMonitorUser;
}
export interface NewRelicMonitorPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#billing_cycle NewRelicMonitor#billing_cycle}
    */
    readonly billingCycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#effective_date NewRelicMonitor#effective_date}
    */
    readonly effectiveDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#plan_id NewRelicMonitor#plan_id}
    */
    readonly planId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#usage_type NewRelicMonitor#usage_type}
    */
    readonly usageType?: string;
}
export declare function newRelicMonitorPlanToTerraform(struct?: NewRelicMonitorPlanOutputReference | NewRelicMonitorPlan): any;
export declare function newRelicMonitorPlanToHclTerraform(struct?: NewRelicMonitorPlanOutputReference | NewRelicMonitorPlan): any;
export declare class NewRelicMonitorPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NewRelicMonitorPlan | undefined;
    set internalValue(value: NewRelicMonitorPlan | undefined);
    private _billingCycle?;
    get billingCycle(): string;
    set billingCycle(value: string);
    resetBillingCycle(): void;
    get billingCycleInput(): string | undefined;
    private _effectiveDate?;
    get effectiveDate(): string;
    set effectiveDate(value: string);
    get effectiveDateInput(): string | undefined;
    private _planId?;
    get planId(): string;
    set planId(value: string);
    resetPlanId(): void;
    get planIdInput(): string | undefined;
    private _usageType?;
    get usageType(): string;
    set usageType(value: string);
    resetUsageType(): void;
    get usageTypeInput(): string | undefined;
}
export interface NewRelicMonitorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#create NewRelicMonitor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#delete NewRelicMonitor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#read NewRelicMonitor#read}
    */
    readonly read?: string;
}
export declare function newRelicMonitorTimeoutsToTerraform(struct?: NewRelicMonitorTimeouts | cdktf.IResolvable): any;
export declare function newRelicMonitorTimeoutsToHclTerraform(struct?: NewRelicMonitorTimeouts | cdktf.IResolvable): any;
export declare class NewRelicMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NewRelicMonitorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NewRelicMonitorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
export interface NewRelicMonitorUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#email NewRelicMonitor#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#first_name NewRelicMonitor#first_name}
    */
    readonly firstName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#last_name NewRelicMonitor#last_name}
    */
    readonly lastName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#phone_number NewRelicMonitor#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function newRelicMonitorUserToTerraform(struct?: NewRelicMonitorUserOutputReference | NewRelicMonitorUser): any;
export declare function newRelicMonitorUserToHclTerraform(struct?: NewRelicMonitorUserOutputReference | NewRelicMonitorUser): any;
export declare class NewRelicMonitorUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NewRelicMonitorUser | undefined;
    set internalValue(value: NewRelicMonitorUser | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    get firstNameInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    get lastNameInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor azurerm_new_relic_monitor}
*/
export declare class NewRelicMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_new_relic_monitor";
    /**
    * Generates CDKTF code for importing a NewRelicMonitor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NewRelicMonitor to import
    * @param importFromId The id of the existing NewRelicMonitor that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NewRelicMonitor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/new_relic_monitor azurerm_new_relic_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NewRelicMonitorConfig
    */
    constructor(scope: Construct, id: string, config: NewRelicMonitorConfig);
    private _accountCreationSource?;
    get accountCreationSource(): string;
    set accountCreationSource(value: string);
    resetAccountCreationSource(): void;
    get accountCreationSourceInput(): string | undefined;
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    resetAccountId(): void;
    get accountIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingestionKey?;
    get ingestionKey(): string;
    set ingestionKey(value: string);
    resetIngestionKey(): void;
    get ingestionKeyInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgCreationSource?;
    get orgCreationSource(): string;
    set orgCreationSource(value: string);
    resetOrgCreationSource(): void;
    get orgCreationSourceInput(): string | undefined;
    private _organizationId?;
    get organizationId(): string;
    set organizationId(value: string);
    resetOrganizationId(): void;
    get organizationIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _plan;
    get plan(): NewRelicMonitorPlanOutputReference;
    putPlan(value: NewRelicMonitorPlan): void;
    get planInput(): NewRelicMonitorPlan | undefined;
    private _timeouts;
    get timeouts(): NewRelicMonitorTimeoutsOutputReference;
    putTimeouts(value: NewRelicMonitorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NewRelicMonitorTimeouts | undefined;
    private _user;
    get user(): NewRelicMonitorUserOutputReference;
    putUser(value: NewRelicMonitorUser): void;
    get userInput(): NewRelicMonitorUser | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
