"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzurermProvider = exports.azurermProviderFeaturesToHclTerraform = exports.azurermProviderFeaturesToTerraform = exports.azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform = exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = exports.azurermProviderFeaturesVirtualMachineToHclTerraform = exports.azurermProviderFeaturesVirtualMachineToTerraform = exports.azurermProviderFeaturesTemplateDeploymentToHclTerraform = exports.azurermProviderFeaturesTemplateDeploymentToTerraform = exports.azurermProviderFeaturesSubscriptionToHclTerraform = exports.azurermProviderFeaturesSubscriptionToTerraform = exports.azurermProviderFeaturesResourceGroupToHclTerraform = exports.azurermProviderFeaturesResourceGroupToTerraform = exports.azurermProviderFeaturesPostgresqlFlexibleServerToHclTerraform = exports.azurermProviderFeaturesPostgresqlFlexibleServerToTerraform = exports.azurermProviderFeaturesManagedDiskToHclTerraform = exports.azurermProviderFeaturesManagedDiskToTerraform = exports.azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform = exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = exports.azurermProviderFeaturesKeyVaultToHclTerraform = exports.azurermProviderFeaturesKeyVaultToTerraform = exports.azurermProviderFeaturesCognitiveAccountToHclTerraform = exports.azurermProviderFeaturesCognitiveAccountToTerraform = exports.azurermProviderFeaturesApplicationInsightsToHclTerraform = exports.azurermProviderFeaturesApplicationInsightsToTerraform = exports.azurermProviderFeaturesAppConfigurationToHclTerraform = exports.azurermProviderFeaturesAppConfigurationToTerraform = exports.azurermProviderFeaturesApiManagementToHclTerraform = exports.azurermProviderFeaturesApiManagementToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function azurermProviderFeaturesApiManagementToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        recover_soft_deleted: cdktf.booleanToTerraform(struct.recoverSoftDeleted),
    };
}
exports.azurermProviderFeaturesApiManagementToTerraform = azurermProviderFeaturesApiManagementToTerraform;
function azurermProviderFeaturesApiManagementToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        purge_soft_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeleted),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesApiManagementToHclTerraform = azurermProviderFeaturesApiManagementToHclTerraform;
function azurermProviderFeaturesAppConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        recover_soft_deleted: cdktf.booleanToTerraform(struct.recoverSoftDeleted),
    };
}
exports.azurermProviderFeaturesAppConfigurationToTerraform = azurermProviderFeaturesAppConfigurationToTerraform;
function azurermProviderFeaturesAppConfigurationToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        purge_soft_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeleted),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesAppConfigurationToHclTerraform = azurermProviderFeaturesAppConfigurationToHclTerraform;
function azurermProviderFeaturesApplicationInsightsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disable_generated_rule: cdktf.booleanToTerraform(struct.disableGeneratedRule),
    };
}
exports.azurermProviderFeaturesApplicationInsightsToTerraform = azurermProviderFeaturesApplicationInsightsToTerraform;
function azurermProviderFeaturesApplicationInsightsToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        disable_generated_rule: {
            value: cdktf.booleanToHclTerraform(struct.disableGeneratedRule),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesApplicationInsightsToHclTerraform = azurermProviderFeaturesApplicationInsightsToHclTerraform;
function azurermProviderFeaturesCognitiveAccountToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesCognitiveAccountToTerraform = azurermProviderFeaturesCognitiveAccountToTerraform;
function azurermProviderFeaturesCognitiveAccountToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        purge_soft_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesCognitiveAccountToHclTerraform = azurermProviderFeaturesCognitiveAccountToHclTerraform;
function azurermProviderFeaturesKeyVaultToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        purge_soft_deleted_certificates_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedCertificatesOnDestroy),
        purge_soft_deleted_hardware_security_modules_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedHardwareSecurityModulesOnDestroy),
        purge_soft_deleted_keys_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedKeysOnDestroy),
        purge_soft_deleted_secrets_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedSecretsOnDestroy),
        recover_soft_deleted_certificates: cdktf.booleanToTerraform(struct.recoverSoftDeletedCertificates),
        recover_soft_deleted_key_vaults: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeyVaults),
        recover_soft_deleted_keys: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeys),
        recover_soft_deleted_secrets: cdktf.booleanToTerraform(struct.recoverSoftDeletedSecrets),
    };
}
exports.azurermProviderFeaturesKeyVaultToTerraform = azurermProviderFeaturesKeyVaultToTerraform;
function azurermProviderFeaturesKeyVaultToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        purge_soft_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        purge_soft_deleted_certificates_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeletedCertificatesOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        purge_soft_deleted_hardware_security_modules_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeletedHardwareSecurityModulesOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        purge_soft_deleted_keys_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeletedKeysOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        purge_soft_deleted_secrets_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.purgeSoftDeletedSecretsOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted_certificates: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeletedCertificates),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted_key_vaults: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeletedKeyVaults),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted_keys: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeletedKeys),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        recover_soft_deleted_secrets: {
            value: cdktf.booleanToHclTerraform(struct.recoverSoftDeletedSecrets),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesKeyVaultToHclTerraform = azurermProviderFeaturesKeyVaultToHclTerraform;
function azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        permanently_delete_on_destroy: cdktf.booleanToTerraform(struct.permanentlyDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform;
function azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        permanently_delete_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.permanentlyDeleteOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform = azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform;
function azurermProviderFeaturesManagedDiskToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        expand_without_downtime: cdktf.booleanToTerraform(struct.expandWithoutDowntime),
    };
}
exports.azurermProviderFeaturesManagedDiskToTerraform = azurermProviderFeaturesManagedDiskToTerraform;
function azurermProviderFeaturesManagedDiskToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        expand_without_downtime: {
            value: cdktf.booleanToHclTerraform(struct.expandWithoutDowntime),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesManagedDiskToHclTerraform = azurermProviderFeaturesManagedDiskToHclTerraform;
function azurermProviderFeaturesPostgresqlFlexibleServerToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        restart_server_on_configuration_value_change: cdktf.booleanToTerraform(struct.restartServerOnConfigurationValueChange),
    };
}
exports.azurermProviderFeaturesPostgresqlFlexibleServerToTerraform = azurermProviderFeaturesPostgresqlFlexibleServerToTerraform;
function azurermProviderFeaturesPostgresqlFlexibleServerToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        restart_server_on_configuration_value_change: {
            value: cdktf.booleanToHclTerraform(struct.restartServerOnConfigurationValueChange),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesPostgresqlFlexibleServerToHclTerraform = azurermProviderFeaturesPostgresqlFlexibleServerToHclTerraform;
function azurermProviderFeaturesResourceGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        prevent_deletion_if_contains_resources: cdktf.booleanToTerraform(struct.preventDeletionIfContainsResources),
    };
}
exports.azurermProviderFeaturesResourceGroupToTerraform = azurermProviderFeaturesResourceGroupToTerraform;
function azurermProviderFeaturesResourceGroupToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        prevent_deletion_if_contains_resources: {
            value: cdktf.booleanToHclTerraform(struct.preventDeletionIfContainsResources),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesResourceGroupToHclTerraform = azurermProviderFeaturesResourceGroupToHclTerraform;
function azurermProviderFeaturesSubscriptionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        prevent_cancellation_on_destroy: cdktf.booleanToTerraform(struct.preventCancellationOnDestroy),
    };
}
exports.azurermProviderFeaturesSubscriptionToTerraform = azurermProviderFeaturesSubscriptionToTerraform;
function azurermProviderFeaturesSubscriptionToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        prevent_cancellation_on_destroy: {
            value: cdktf.booleanToHclTerraform(struct.preventCancellationOnDestroy),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesSubscriptionToHclTerraform = azurermProviderFeaturesSubscriptionToHclTerraform;
function azurermProviderFeaturesTemplateDeploymentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_nested_items_during_deletion: cdktf.booleanToTerraform(struct.deleteNestedItemsDuringDeletion),
    };
}
exports.azurermProviderFeaturesTemplateDeploymentToTerraform = azurermProviderFeaturesTemplateDeploymentToTerraform;
function azurermProviderFeaturesTemplateDeploymentToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        delete_nested_items_during_deletion: {
            value: cdktf.booleanToHclTerraform(struct.deleteNestedItemsDuringDeletion),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesTemplateDeploymentToHclTerraform = azurermProviderFeaturesTemplateDeploymentToHclTerraform;
function azurermProviderFeaturesVirtualMachineToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_os_disk_on_deletion: cdktf.booleanToTerraform(struct.deleteOsDiskOnDeletion),
        graceful_shutdown: cdktf.booleanToTerraform(struct.gracefulShutdown),
        skip_shutdown_and_force_delete: cdktf.booleanToTerraform(struct.skipShutdownAndForceDelete),
    };
}
exports.azurermProviderFeaturesVirtualMachineToTerraform = azurermProviderFeaturesVirtualMachineToTerraform;
function azurermProviderFeaturesVirtualMachineToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        delete_os_disk_on_deletion: {
            value: cdktf.booleanToHclTerraform(struct.deleteOsDiskOnDeletion),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        graceful_shutdown: {
            value: cdktf.booleanToHclTerraform(struct.gracefulShutdown),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        skip_shutdown_and_force_delete: {
            value: cdktf.booleanToHclTerraform(struct.skipShutdownAndForceDelete),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesVirtualMachineToHclTerraform = azurermProviderFeaturesVirtualMachineToHclTerraform;
function azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        force_delete: cdktf.booleanToTerraform(struct.forceDelete),
        reimage_on_manual_upgrade: cdktf.booleanToTerraform(struct.reimageOnManualUpgrade),
        roll_instances_when_required: cdktf.booleanToTerraform(struct.rollInstancesWhenRequired),
        scale_to_zero_before_deletion: cdktf.booleanToTerraform(struct.scaleToZeroBeforeDeletion),
    };
}
exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = azurermProviderFeaturesVirtualMachineScaleSetToTerraform;
function azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        force_delete: {
            value: cdktf.booleanToHclTerraform(struct.forceDelete),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        reimage_on_manual_upgrade: {
            value: cdktf.booleanToHclTerraform(struct.reimageOnManualUpgrade),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        roll_instances_when_required: {
            value: cdktf.booleanToHclTerraform(struct.rollInstancesWhenRequired),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
        scale_to_zero_before_deletion: {
            value: cdktf.booleanToHclTerraform(struct.scaleToZeroBeforeDeletion),
            isBlock: false,
            type: "simple",
            storageClassType: "boolean",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform = azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform;
function azurermProviderFeaturesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        api_management: azurermProviderFeaturesApiManagementToTerraform(struct.apiManagement),
        app_configuration: azurermProviderFeaturesAppConfigurationToTerraform(struct.appConfiguration),
        application_insights: azurermProviderFeaturesApplicationInsightsToTerraform(struct.applicationInsights),
        cognitive_account: azurermProviderFeaturesCognitiveAccountToTerraform(struct.cognitiveAccount),
        key_vault: azurermProviderFeaturesKeyVaultToTerraform(struct.keyVault),
        log_analytics_workspace: azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct.logAnalyticsWorkspace),
        managed_disk: azurermProviderFeaturesManagedDiskToTerraform(struct.managedDisk),
        postgresql_flexible_server: azurermProviderFeaturesPostgresqlFlexibleServerToTerraform(struct.postgresqlFlexibleServer),
        resource_group: azurermProviderFeaturesResourceGroupToTerraform(struct.resourceGroup),
        subscription: azurermProviderFeaturesSubscriptionToTerraform(struct.subscription),
        template_deployment: azurermProviderFeaturesTemplateDeploymentToTerraform(struct.templateDeployment),
        virtual_machine: azurermProviderFeaturesVirtualMachineToTerraform(struct.virtualMachine),
        virtual_machine_scale_set: azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct.virtualMachineScaleSet),
    };
}
exports.azurermProviderFeaturesToTerraform = azurermProviderFeaturesToTerraform;
function azurermProviderFeaturesToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        api_management: {
            value: azurermProviderFeaturesApiManagementToHclTerraform(struct.apiManagement),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesApiManagementList",
        },
        app_configuration: {
            value: azurermProviderFeaturesAppConfigurationToHclTerraform(struct.appConfiguration),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesAppConfigurationList",
        },
        application_insights: {
            value: azurermProviderFeaturesApplicationInsightsToHclTerraform(struct.applicationInsights),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesApplicationInsightsList",
        },
        cognitive_account: {
            value: azurermProviderFeaturesCognitiveAccountToHclTerraform(struct.cognitiveAccount),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesCognitiveAccountList",
        },
        key_vault: {
            value: azurermProviderFeaturesKeyVaultToHclTerraform(struct.keyVault),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesKeyVaultList",
        },
        log_analytics_workspace: {
            value: azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform(struct.logAnalyticsWorkspace),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesLogAnalyticsWorkspaceList",
        },
        managed_disk: {
            value: azurermProviderFeaturesManagedDiskToHclTerraform(struct.managedDisk),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesManagedDiskList",
        },
        postgresql_flexible_server: {
            value: azurermProviderFeaturesPostgresqlFlexibleServerToHclTerraform(struct.postgresqlFlexibleServer),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesPostgresqlFlexibleServerList",
        },
        resource_group: {
            value: azurermProviderFeaturesResourceGroupToHclTerraform(struct.resourceGroup),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesResourceGroupList",
        },
        subscription: {
            value: azurermProviderFeaturesSubscriptionToHclTerraform(struct.subscription),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesSubscriptionList",
        },
        template_deployment: {
            value: azurermProviderFeaturesTemplateDeploymentToHclTerraform(struct.templateDeployment),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesTemplateDeploymentList",
        },
        virtual_machine: {
            value: azurermProviderFeaturesVirtualMachineToHclTerraform(struct.virtualMachine),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesVirtualMachineList",
        },
        virtual_machine_scale_set: {
            value: azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform(struct.virtualMachineScaleSet),
            isBlock: true,
            type: "list",
            storageClassType: "AzurermProviderFeaturesVirtualMachineScaleSetList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.azurermProviderFeaturesToHclTerraform = azurermProviderFeaturesToHclTerraform;
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs azurerm}
*/
class AzurermProvider extends cdktf.TerraformProvider {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a AzurermProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AzurermProvider to import
    * @param importFromId The id of the existing AzurermProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AzurermProvider to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "azurerm", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs azurerm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzurermProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.95.0',
                providerVersionConstraint: '~> 3.10'
            },
            terraformProviderSource: 'azurerm'
        });
        this._auxiliaryTenantIds = config.auxiliaryTenantIds;
        this._clientCertificate = config.clientCertificate;
        this._clientCertificatePassword = config.clientCertificatePassword;
        this._clientCertificatePath = config.clientCertificatePath;
        this._clientId = config.clientId;
        this._clientIdFilePath = config.clientIdFilePath;
        this._clientSecret = config.clientSecret;
        this._clientSecretFilePath = config.clientSecretFilePath;
        this._disableCorrelationRequestId = config.disableCorrelationRequestId;
        this._disableTerraformPartnerId = config.disableTerraformPartnerId;
        this._environment = config.environment;
        this._metadataHost = config.metadataHost;
        this._msiEndpoint = config.msiEndpoint;
        this._oidcRequestToken = config.oidcRequestToken;
        this._oidcRequestUrl = config.oidcRequestUrl;
        this._oidcToken = config.oidcToken;
        this._oidcTokenFilePath = config.oidcTokenFilePath;
        this._partnerId = config.partnerId;
        this._skipProviderRegistration = config.skipProviderRegistration;
        this._storageUseAzuread = config.storageUseAzuread;
        this._subscriptionId = config.subscriptionId;
        this._tenantId = config.tenantId;
        this._useAksWorkloadIdentity = config.useAksWorkloadIdentity;
        this._useCli = config.useCli;
        this._useMsi = config.useMsi;
        this._useOidc = config.useOidc;
        this._alias = config.alias;
        this._features = config.features;
    }
    get auxiliaryTenantIds() {
        return this._auxiliaryTenantIds;
    }
    set auxiliaryTenantIds(value) {
        this._auxiliaryTenantIds = value;
    }
    resetAuxiliaryTenantIds() {
        this._auxiliaryTenantIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auxiliaryTenantIdsInput() {
        return this._auxiliaryTenantIds;
    }
    get clientCertificate() {
        return this._clientCertificate;
    }
    set clientCertificate(value) {
        this._clientCertificate = value;
    }
    resetClientCertificate() {
        this._clientCertificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificateInput() {
        return this._clientCertificate;
    }
    get clientCertificatePassword() {
        return this._clientCertificatePassword;
    }
    set clientCertificatePassword(value) {
        this._clientCertificatePassword = value;
    }
    resetClientCertificatePassword() {
        this._clientCertificatePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePasswordInput() {
        return this._clientCertificatePassword;
    }
    get clientCertificatePath() {
        return this._clientCertificatePath;
    }
    set clientCertificatePath(value) {
        this._clientCertificatePath = value;
    }
    resetClientCertificatePath() {
        this._clientCertificatePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePathInput() {
        return this._clientCertificatePath;
    }
    get clientId() {
        return this._clientId;
    }
    set clientId(value) {
        this._clientId = value;
    }
    resetClientId() {
        this._clientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdInput() {
        return this._clientId;
    }
    get clientIdFilePath() {
        return this._clientIdFilePath;
    }
    set clientIdFilePath(value) {
        this._clientIdFilePath = value;
    }
    resetClientIdFilePath() {
        this._clientIdFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdFilePathInput() {
        return this._clientIdFilePath;
    }
    get clientSecret() {
        return this._clientSecret;
    }
    set clientSecret(value) {
        this._clientSecret = value;
    }
    resetClientSecret() {
        this._clientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSecretInput() {
        return this._clientSecret;
    }
    get clientSecretFilePath() {
        return this._clientSecretFilePath;
    }
    set clientSecretFilePath(value) {
        this._clientSecretFilePath = value;
    }
    resetClientSecretFilePath() {
        this._clientSecretFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSecretFilePathInput() {
        return this._clientSecretFilePath;
    }
    get disableCorrelationRequestId() {
        return this._disableCorrelationRequestId;
    }
    set disableCorrelationRequestId(value) {
        this._disableCorrelationRequestId = value;
    }
    resetDisableCorrelationRequestId() {
        this._disableCorrelationRequestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableCorrelationRequestIdInput() {
        return this._disableCorrelationRequestId;
    }
    get disableTerraformPartnerId() {
        return this._disableTerraformPartnerId;
    }
    set disableTerraformPartnerId(value) {
        this._disableTerraformPartnerId = value;
    }
    resetDisableTerraformPartnerId() {
        this._disableTerraformPartnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableTerraformPartnerIdInput() {
        return this._disableTerraformPartnerId;
    }
    get environment() {
        return this._environment;
    }
    set environment(value) {
        this._environment = value;
    }
    resetEnvironment() {
        this._environment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentInput() {
        return this._environment;
    }
    get metadataHost() {
        return this._metadataHost;
    }
    set metadataHost(value) {
        this._metadataHost = value;
    }
    resetMetadataHost() {
        this._metadataHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metadataHostInput() {
        return this._metadataHost;
    }
    get msiEndpoint() {
        return this._msiEndpoint;
    }
    set msiEndpoint(value) {
        this._msiEndpoint = value;
    }
    resetMsiEndpoint() {
        this._msiEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get msiEndpointInput() {
        return this._msiEndpoint;
    }
    get oidcRequestToken() {
        return this._oidcRequestToken;
    }
    set oidcRequestToken(value) {
        this._oidcRequestToken = value;
    }
    resetOidcRequestToken() {
        this._oidcRequestToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestTokenInput() {
        return this._oidcRequestToken;
    }
    get oidcRequestUrl() {
        return this._oidcRequestUrl;
    }
    set oidcRequestUrl(value) {
        this._oidcRequestUrl = value;
    }
    resetOidcRequestUrl() {
        this._oidcRequestUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestUrlInput() {
        return this._oidcRequestUrl;
    }
    get oidcToken() {
        return this._oidcToken;
    }
    set oidcToken(value) {
        this._oidcToken = value;
    }
    resetOidcToken() {
        this._oidcToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenInput() {
        return this._oidcToken;
    }
    get oidcTokenFilePath() {
        return this._oidcTokenFilePath;
    }
    set oidcTokenFilePath(value) {
        this._oidcTokenFilePath = value;
    }
    resetOidcTokenFilePath() {
        this._oidcTokenFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenFilePathInput() {
        return this._oidcTokenFilePath;
    }
    get partnerId() {
        return this._partnerId;
    }
    set partnerId(value) {
        this._partnerId = value;
    }
    resetPartnerId() {
        this._partnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get partnerIdInput() {
        return this._partnerId;
    }
    get skipProviderRegistration() {
        return this._skipProviderRegistration;
    }
    set skipProviderRegistration(value) {
        this._skipProviderRegistration = value;
    }
    resetSkipProviderRegistration() {
        this._skipProviderRegistration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipProviderRegistrationInput() {
        return this._skipProviderRegistration;
    }
    get storageUseAzuread() {
        return this._storageUseAzuread;
    }
    set storageUseAzuread(value) {
        this._storageUseAzuread = value;
    }
    resetStorageUseAzuread() {
        this._storageUseAzuread = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageUseAzureadInput() {
        return this._storageUseAzuread;
    }
    get subscriptionId() {
        return this._subscriptionId;
    }
    set subscriptionId(value) {
        this._subscriptionId = value;
    }
    resetSubscriptionId() {
        this._subscriptionId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subscriptionIdInput() {
        return this._subscriptionId;
    }
    get tenantId() {
        return this._tenantId;
    }
    set tenantId(value) {
        this._tenantId = value;
    }
    resetTenantId() {
        this._tenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tenantIdInput() {
        return this._tenantId;
    }
    get useAksWorkloadIdentity() {
        return this._useAksWorkloadIdentity;
    }
    set useAksWorkloadIdentity(value) {
        this._useAksWorkloadIdentity = value;
    }
    resetUseAksWorkloadIdentity() {
        this._useAksWorkloadIdentity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useAksWorkloadIdentityInput() {
        return this._useAksWorkloadIdentity;
    }
    get useCli() {
        return this._useCli;
    }
    set useCli(value) {
        this._useCli = value;
    }
    resetUseCli() {
        this._useCli = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCliInput() {
        return this._useCli;
    }
    get useMsi() {
        return this._useMsi;
    }
    set useMsi(value) {
        this._useMsi = value;
    }
    resetUseMsi() {
        this._useMsi = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useMsiInput() {
        return this._useMsi;
    }
    get useOidc() {
        return this._useOidc;
    }
    set useOidc(value) {
        this._useOidc = value;
    }
    resetUseOidc() {
        this._useOidc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useOidcInput() {
        return this._useOidc;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get features() {
        return this._features;
    }
    set features(value) {
        this._features = value;
    }
    // Temporarily expose input value. Use with caution.
    get featuresInput() {
        return this._features;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auxiliary_tenant_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._auxiliaryTenantIds),
            client_certificate: cdktf.stringToTerraform(this._clientCertificate),
            client_certificate_password: cdktf.stringToTerraform(this._clientCertificatePassword),
            client_certificate_path: cdktf.stringToTerraform(this._clientCertificatePath),
            client_id: cdktf.stringToTerraform(this._clientId),
            client_id_file_path: cdktf.stringToTerraform(this._clientIdFilePath),
            client_secret: cdktf.stringToTerraform(this._clientSecret),
            client_secret_file_path: cdktf.stringToTerraform(this._clientSecretFilePath),
            disable_correlation_request_id: cdktf.booleanToTerraform(this._disableCorrelationRequestId),
            disable_terraform_partner_id: cdktf.booleanToTerraform(this._disableTerraformPartnerId),
            environment: cdktf.stringToTerraform(this._environment),
            metadata_host: cdktf.stringToTerraform(this._metadataHost),
            msi_endpoint: cdktf.stringToTerraform(this._msiEndpoint),
            oidc_request_token: cdktf.stringToTerraform(this._oidcRequestToken),
            oidc_request_url: cdktf.stringToTerraform(this._oidcRequestUrl),
            oidc_token: cdktf.stringToTerraform(this._oidcToken),
            oidc_token_file_path: cdktf.stringToTerraform(this._oidcTokenFilePath),
            partner_id: cdktf.stringToTerraform(this._partnerId),
            skip_provider_registration: cdktf.booleanToTerraform(this._skipProviderRegistration),
            storage_use_azuread: cdktf.booleanToTerraform(this._storageUseAzuread),
            subscription_id: cdktf.stringToTerraform(this._subscriptionId),
            tenant_id: cdktf.stringToTerraform(this._tenantId),
            use_aks_workload_identity: cdktf.booleanToTerraform(this._useAksWorkloadIdentity),
            use_cli: cdktf.booleanToTerraform(this._useCli),
            use_msi: cdktf.booleanToTerraform(this._useMsi),
            use_oidc: cdktf.booleanToTerraform(this._useOidc),
            alias: cdktf.stringToTerraform(this._alias),
            features: azurermProviderFeaturesToTerraform(this._features),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            auxiliary_tenant_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._auxiliaryTenantIds),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            client_certificate: {
                value: cdktf.stringToHclTerraform(this._clientCertificate),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_certificate_password: {
                value: cdktf.stringToHclTerraform(this._clientCertificatePassword),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_certificate_path: {
                value: cdktf.stringToHclTerraform(this._clientCertificatePath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_id: {
                value: cdktf.stringToHclTerraform(this._clientId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_id_file_path: {
                value: cdktf.stringToHclTerraform(this._clientIdFilePath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_secret: {
                value: cdktf.stringToHclTerraform(this._clientSecret),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_secret_file_path: {
                value: cdktf.stringToHclTerraform(this._clientSecretFilePath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            disable_correlation_request_id: {
                value: cdktf.booleanToHclTerraform(this._disableCorrelationRequestId),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            disable_terraform_partner_id: {
                value: cdktf.booleanToHclTerraform(this._disableTerraformPartnerId),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            environment: {
                value: cdktf.stringToHclTerraform(this._environment),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            metadata_host: {
                value: cdktf.stringToHclTerraform(this._metadataHost),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            msi_endpoint: {
                value: cdktf.stringToHclTerraform(this._msiEndpoint),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oidc_request_token: {
                value: cdktf.stringToHclTerraform(this._oidcRequestToken),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oidc_request_url: {
                value: cdktf.stringToHclTerraform(this._oidcRequestUrl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oidc_token: {
                value: cdktf.stringToHclTerraform(this._oidcToken),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            oidc_token_file_path: {
                value: cdktf.stringToHclTerraform(this._oidcTokenFilePath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            partner_id: {
                value: cdktf.stringToHclTerraform(this._partnerId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            skip_provider_registration: {
                value: cdktf.booleanToHclTerraform(this._skipProviderRegistration),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            storage_use_azuread: {
                value: cdktf.booleanToHclTerraform(this._storageUseAzuread),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            subscription_id: {
                value: cdktf.stringToHclTerraform(this._subscriptionId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            tenant_id: {
                value: cdktf.stringToHclTerraform(this._tenantId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            use_aks_workload_identity: {
                value: cdktf.booleanToHclTerraform(this._useAksWorkloadIdentity),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            use_cli: {
                value: cdktf.booleanToHclTerraform(this._useCli),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            use_msi: {
                value: cdktf.booleanToHclTerraform(this._useMsi),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            use_oidc: {
                value: cdktf.booleanToHclTerraform(this._useOidc),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            alias: {
                value: cdktf.stringToHclTerraform(this._alias),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            features: {
                value: azurermProviderFeaturesToHclTerraform(this._features),
                isBlock: true,
                type: "list",
                storageClassType: "AzurermProviderFeaturesList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.AzurermProvider = AzurermProvider;
_a = JSII_RTTI_SYMBOL_1;
AzurermProvider[_a] = { fqn: "@cdktf/provider-azurerm.provider.AzurermProvider", version: "12.9.0" };
// =================
// STATIC PROPERTIES
// =================
AzurermProvider.tfResourceType = "azurerm";
//# sourceMappingURL=data:application/json;base64,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