/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RedisCacheConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#capacity RedisCache#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#enable_non_ssl_port RedisCache#enable_non_ssl_port}
    */
    readonly enableNonSslPort?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#family RedisCache#family}
    */
    readonly family: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#id RedisCache#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#location RedisCache#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#minimum_tls_version RedisCache#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#name RedisCache#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#private_static_ip_address RedisCache#private_static_ip_address}
    */
    readonly privateStaticIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#public_network_access_enabled RedisCache#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#redis_version RedisCache#redis_version}
    */
    readonly redisVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#replicas_per_master RedisCache#replicas_per_master}
    */
    readonly replicasPerMaster?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#replicas_per_primary RedisCache#replicas_per_primary}
    */
    readonly replicasPerPrimary?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#resource_group_name RedisCache#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#shard_count RedisCache#shard_count}
    */
    readonly shardCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#sku_name RedisCache#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#subnet_id RedisCache#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#tags RedisCache#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#tenant_settings RedisCache#tenant_settings}
    */
    readonly tenantSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#zones RedisCache#zones}
    */
    readonly zones?: string[];
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#identity RedisCache#identity}
    */
    readonly identity?: RedisCacheIdentity;
    /**
    * patch_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#patch_schedule RedisCache#patch_schedule}
    */
    readonly patchSchedule?: RedisCachePatchSchedule[] | cdktf.IResolvable;
    /**
    * redis_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#redis_configuration RedisCache#redis_configuration}
    */
    readonly redisConfiguration?: RedisCacheRedisConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#timeouts RedisCache#timeouts}
    */
    readonly timeouts?: RedisCacheTimeouts;
}
export interface RedisCacheIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#identity_ids RedisCache#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#type RedisCache#type}
    */
    readonly type: string;
}
export declare function redisCacheIdentityToTerraform(struct?: RedisCacheIdentityOutputReference | RedisCacheIdentity): any;
export declare function redisCacheIdentityToHclTerraform(struct?: RedisCacheIdentityOutputReference | RedisCacheIdentity): any;
export declare class RedisCacheIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisCacheIdentity | undefined;
    set internalValue(value: RedisCacheIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface RedisCachePatchSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#day_of_week RedisCache#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#maintenance_window RedisCache#maintenance_window}
    */
    readonly maintenanceWindow?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#start_hour_utc RedisCache#start_hour_utc}
    */
    readonly startHourUtc?: number;
}
export declare function redisCachePatchScheduleToTerraform(struct?: RedisCachePatchSchedule | cdktf.IResolvable): any;
export declare function redisCachePatchScheduleToHclTerraform(struct?: RedisCachePatchSchedule | cdktf.IResolvable): any;
export declare class RedisCachePatchScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RedisCachePatchSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: RedisCachePatchSchedule | cdktf.IResolvable | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _maintenanceWindow?;
    get maintenanceWindow(): string;
    set maintenanceWindow(value: string);
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): string | undefined;
    private _startHourUtc?;
    get startHourUtc(): number;
    set startHourUtc(value: number);
    resetStartHourUtc(): void;
    get startHourUtcInput(): number | undefined;
}
export declare class RedisCachePatchScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RedisCachePatchSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RedisCachePatchScheduleOutputReference;
}
export interface RedisCacheRedisConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#active_directory_authentication_enabled RedisCache#active_directory_authentication_enabled}
    */
    readonly activeDirectoryAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#aof_backup_enabled RedisCache#aof_backup_enabled}
    */
    readonly aofBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#aof_storage_connection_string_0 RedisCache#aof_storage_connection_string_0}
    */
    readonly aofStorageConnectionString0?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#aof_storage_connection_string_1 RedisCache#aof_storage_connection_string_1}
    */
    readonly aofStorageConnectionString1?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#data_persistence_authentication_method RedisCache#data_persistence_authentication_method}
    */
    readonly dataPersistenceAuthenticationMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#enable_authentication RedisCache#enable_authentication}
    */
    readonly enableAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#maxfragmentationmemory_reserved RedisCache#maxfragmentationmemory_reserved}
    */
    readonly maxfragmentationmemoryReserved?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#maxmemory_delta RedisCache#maxmemory_delta}
    */
    readonly maxmemoryDelta?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#maxmemory_policy RedisCache#maxmemory_policy}
    */
    readonly maxmemoryPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#maxmemory_reserved RedisCache#maxmemory_reserved}
    */
    readonly maxmemoryReserved?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#notify_keyspace_events RedisCache#notify_keyspace_events}
    */
    readonly notifyKeyspaceEvents?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#rdb_backup_enabled RedisCache#rdb_backup_enabled}
    */
    readonly rdbBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#rdb_backup_frequency RedisCache#rdb_backup_frequency}
    */
    readonly rdbBackupFrequency?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#rdb_backup_max_snapshot_count RedisCache#rdb_backup_max_snapshot_count}
    */
    readonly rdbBackupMaxSnapshotCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#rdb_storage_connection_string RedisCache#rdb_storage_connection_string}
    */
    readonly rdbStorageConnectionString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#storage_account_subscription_id RedisCache#storage_account_subscription_id}
    */
    readonly storageAccountSubscriptionId?: string;
}
export declare function redisCacheRedisConfigurationToTerraform(struct?: RedisCacheRedisConfigurationOutputReference | RedisCacheRedisConfiguration): any;
export declare function redisCacheRedisConfigurationToHclTerraform(struct?: RedisCacheRedisConfigurationOutputReference | RedisCacheRedisConfiguration): any;
export declare class RedisCacheRedisConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisCacheRedisConfiguration | undefined;
    set internalValue(value: RedisCacheRedisConfiguration | undefined);
    private _activeDirectoryAuthenticationEnabled?;
    get activeDirectoryAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set activeDirectoryAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetActiveDirectoryAuthenticationEnabled(): void;
    get activeDirectoryAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _aofBackupEnabled?;
    get aofBackupEnabled(): boolean | cdktf.IResolvable;
    set aofBackupEnabled(value: boolean | cdktf.IResolvable);
    resetAofBackupEnabled(): void;
    get aofBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _aofStorageConnectionString0?;
    get aofStorageConnectionString0(): string;
    set aofStorageConnectionString0(value: string);
    resetAofStorageConnectionString0(): void;
    get aofStorageConnectionString0Input(): string | undefined;
    private _aofStorageConnectionString1?;
    get aofStorageConnectionString1(): string;
    set aofStorageConnectionString1(value: string);
    resetAofStorageConnectionString1(): void;
    get aofStorageConnectionString1Input(): string | undefined;
    private _dataPersistenceAuthenticationMethod?;
    get dataPersistenceAuthenticationMethod(): string;
    set dataPersistenceAuthenticationMethod(value: string);
    resetDataPersistenceAuthenticationMethod(): void;
    get dataPersistenceAuthenticationMethodInput(): string | undefined;
    private _enableAuthentication?;
    get enableAuthentication(): boolean | cdktf.IResolvable;
    set enableAuthentication(value: boolean | cdktf.IResolvable);
    resetEnableAuthentication(): void;
    get enableAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    get maxclients(): number;
    private _maxfragmentationmemoryReserved?;
    get maxfragmentationmemoryReserved(): number;
    set maxfragmentationmemoryReserved(value: number);
    resetMaxfragmentationmemoryReserved(): void;
    get maxfragmentationmemoryReservedInput(): number | undefined;
    private _maxmemoryDelta?;
    get maxmemoryDelta(): number;
    set maxmemoryDelta(value: number);
    resetMaxmemoryDelta(): void;
    get maxmemoryDeltaInput(): number | undefined;
    private _maxmemoryPolicy?;
    get maxmemoryPolicy(): string;
    set maxmemoryPolicy(value: string);
    resetMaxmemoryPolicy(): void;
    get maxmemoryPolicyInput(): string | undefined;
    private _maxmemoryReserved?;
    get maxmemoryReserved(): number;
    set maxmemoryReserved(value: number);
    resetMaxmemoryReserved(): void;
    get maxmemoryReservedInput(): number | undefined;
    private _notifyKeyspaceEvents?;
    get notifyKeyspaceEvents(): string;
    set notifyKeyspaceEvents(value: string);
    resetNotifyKeyspaceEvents(): void;
    get notifyKeyspaceEventsInput(): string | undefined;
    private _rdbBackupEnabled?;
    get rdbBackupEnabled(): boolean | cdktf.IResolvable;
    set rdbBackupEnabled(value: boolean | cdktf.IResolvable);
    resetRdbBackupEnabled(): void;
    get rdbBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _rdbBackupFrequency?;
    get rdbBackupFrequency(): number;
    set rdbBackupFrequency(value: number);
    resetRdbBackupFrequency(): void;
    get rdbBackupFrequencyInput(): number | undefined;
    private _rdbBackupMaxSnapshotCount?;
    get rdbBackupMaxSnapshotCount(): number;
    set rdbBackupMaxSnapshotCount(value: number);
    resetRdbBackupMaxSnapshotCount(): void;
    get rdbBackupMaxSnapshotCountInput(): number | undefined;
    private _rdbStorageConnectionString?;
    get rdbStorageConnectionString(): string;
    set rdbStorageConnectionString(value: string);
    resetRdbStorageConnectionString(): void;
    get rdbStorageConnectionStringInput(): string | undefined;
    private _storageAccountSubscriptionId?;
    get storageAccountSubscriptionId(): string;
    set storageAccountSubscriptionId(value: string);
    resetStorageAccountSubscriptionId(): void;
    get storageAccountSubscriptionIdInput(): string | undefined;
}
export interface RedisCacheTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#create RedisCache#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#delete RedisCache#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#read RedisCache#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#update RedisCache#update}
    */
    readonly update?: string;
}
export declare function redisCacheTimeoutsToTerraform(struct?: RedisCacheTimeouts | cdktf.IResolvable): any;
export declare function redisCacheTimeoutsToHclTerraform(struct?: RedisCacheTimeouts | cdktf.IResolvable): any;
export declare class RedisCacheTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisCacheTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RedisCacheTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache azurerm_redis_cache}
*/
export declare class RedisCache extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_redis_cache";
    /**
    * Generates CDKTF code for importing a RedisCache resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RedisCache to import
    * @param importFromId The id of the existing RedisCache that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RedisCache to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/redis_cache azurerm_redis_cache} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RedisCacheConfig
    */
    constructor(scope: Construct, id: string, config: RedisCacheConfig);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    private _enableNonSslPort?;
    get enableNonSslPort(): boolean | cdktf.IResolvable;
    set enableNonSslPort(value: boolean | cdktf.IResolvable);
    resetEnableNonSslPort(): void;
    get enableNonSslPortInput(): boolean | cdktf.IResolvable | undefined;
    private _family?;
    get family(): string;
    set family(value: string);
    get familyInput(): string | undefined;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get port(): number;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    private _privateStaticIpAddress?;
    get privateStaticIpAddress(): string;
    set privateStaticIpAddress(value: string);
    resetPrivateStaticIpAddress(): void;
    get privateStaticIpAddressInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _redisVersion?;
    get redisVersion(): string;
    set redisVersion(value: string);
    resetRedisVersion(): void;
    get redisVersionInput(): string | undefined;
    private _replicasPerMaster?;
    get replicasPerMaster(): number;
    set replicasPerMaster(value: number);
    resetReplicasPerMaster(): void;
    get replicasPerMasterInput(): number | undefined;
    private _replicasPerPrimary?;
    get replicasPerPrimary(): number;
    set replicasPerPrimary(value: number);
    resetReplicasPerPrimary(): void;
    get replicasPerPrimaryInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    private _shardCount?;
    get shardCount(): number;
    set shardCount(value: number);
    resetShardCount(): void;
    get shardCountInput(): number | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    get sslPort(): number;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantSettings?;
    get tenantSettings(): {
        [key: string]: string;
    };
    set tenantSettings(value: {
        [key: string]: string;
    });
    resetTenantSettings(): void;
    get tenantSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _identity;
    get identity(): RedisCacheIdentityOutputReference;
    putIdentity(value: RedisCacheIdentity): void;
    resetIdentity(): void;
    get identityInput(): RedisCacheIdentity | undefined;
    private _patchSchedule;
    get patchSchedule(): RedisCachePatchScheduleList;
    putPatchSchedule(value: RedisCachePatchSchedule[] | cdktf.IResolvable): void;
    resetPatchSchedule(): void;
    get patchScheduleInput(): cdktf.IResolvable | RedisCachePatchSchedule[] | undefined;
    private _redisConfiguration;
    get redisConfiguration(): RedisCacheRedisConfigurationOutputReference;
    putRedisConfiguration(value: RedisCacheRedisConfiguration): void;
    resetRedisConfiguration(): void;
    get redisConfigurationInput(): RedisCacheRedisConfiguration | undefined;
    private _timeouts;
    get timeouts(): RedisCacheTimeoutsOutputReference;
    putTimeouts(value: RedisCacheTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RedisCacheTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
