/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceDeploymentScriptAzurePowerShellConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#cleanup_preference ResourceDeploymentScriptAzurePowerShell#cleanup_preference}
    */
    readonly cleanupPreference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#command_line ResourceDeploymentScriptAzurePowerShell#command_line}
    */
    readonly commandLine?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#force_update_tag ResourceDeploymentScriptAzurePowerShell#force_update_tag}
    */
    readonly forceUpdateTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#id ResourceDeploymentScriptAzurePowerShell#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#location ResourceDeploymentScriptAzurePowerShell#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#name ResourceDeploymentScriptAzurePowerShell#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#primary_script_uri ResourceDeploymentScriptAzurePowerShell#primary_script_uri}
    */
    readonly primaryScriptUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#resource_group_name ResourceDeploymentScriptAzurePowerShell#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#retention_interval ResourceDeploymentScriptAzurePowerShell#retention_interval}
    */
    readonly retentionInterval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#script_content ResourceDeploymentScriptAzurePowerShell#script_content}
    */
    readonly scriptContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#supporting_script_uris ResourceDeploymentScriptAzurePowerShell#supporting_script_uris}
    */
    readonly supportingScriptUris?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#tags ResourceDeploymentScriptAzurePowerShell#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#timeout ResourceDeploymentScriptAzurePowerShell#timeout}
    */
    readonly timeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#version ResourceDeploymentScriptAzurePowerShell#version}
    */
    readonly version: string;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#container ResourceDeploymentScriptAzurePowerShell#container}
    */
    readonly container?: ResourceDeploymentScriptAzurePowerShellContainer;
    /**
    * environment_variable block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#environment_variable ResourceDeploymentScriptAzurePowerShell#environment_variable}
    */
    readonly environmentVariable?: ResourceDeploymentScriptAzurePowerShellEnvironmentVariable[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#identity ResourceDeploymentScriptAzurePowerShell#identity}
    */
    readonly identity?: ResourceDeploymentScriptAzurePowerShellIdentity;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#storage_account ResourceDeploymentScriptAzurePowerShell#storage_account}
    */
    readonly storageAccount?: ResourceDeploymentScriptAzurePowerShellStorageAccount;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#timeouts ResourceDeploymentScriptAzurePowerShell#timeouts}
    */
    readonly timeouts?: ResourceDeploymentScriptAzurePowerShellTimeouts;
}
export interface ResourceDeploymentScriptAzurePowerShellContainer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#container_group_name ResourceDeploymentScriptAzurePowerShell#container_group_name}
    */
    readonly containerGroupName?: string;
}
export declare function resourceDeploymentScriptAzurePowerShellContainerToTerraform(struct?: ResourceDeploymentScriptAzurePowerShellContainerOutputReference | ResourceDeploymentScriptAzurePowerShellContainer): any;
export declare function resourceDeploymentScriptAzurePowerShellContainerToHclTerraform(struct?: ResourceDeploymentScriptAzurePowerShellContainerOutputReference | ResourceDeploymentScriptAzurePowerShellContainer): any;
export declare class ResourceDeploymentScriptAzurePowerShellContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceDeploymentScriptAzurePowerShellContainer | undefined;
    set internalValue(value: ResourceDeploymentScriptAzurePowerShellContainer | undefined);
    private _containerGroupName?;
    get containerGroupName(): string;
    set containerGroupName(value: string);
    resetContainerGroupName(): void;
    get containerGroupNameInput(): string | undefined;
}
export interface ResourceDeploymentScriptAzurePowerShellEnvironmentVariable {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#name ResourceDeploymentScriptAzurePowerShell#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#secure_value ResourceDeploymentScriptAzurePowerShell#secure_value}
    */
    readonly secureValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#value ResourceDeploymentScriptAzurePowerShell#value}
    */
    readonly value?: string;
}
export declare function resourceDeploymentScriptAzurePowerShellEnvironmentVariableToTerraform(struct?: ResourceDeploymentScriptAzurePowerShellEnvironmentVariable | cdktf.IResolvable): any;
export declare function resourceDeploymentScriptAzurePowerShellEnvironmentVariableToHclTerraform(struct?: ResourceDeploymentScriptAzurePowerShellEnvironmentVariable | cdktf.IResolvable): any;
export declare class ResourceDeploymentScriptAzurePowerShellEnvironmentVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceDeploymentScriptAzurePowerShellEnvironmentVariable | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceDeploymentScriptAzurePowerShellEnvironmentVariable | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secureValue?;
    get secureValue(): string;
    set secureValue(value: string);
    resetSecureValue(): void;
    get secureValueInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ResourceDeploymentScriptAzurePowerShellEnvironmentVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceDeploymentScriptAzurePowerShellEnvironmentVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceDeploymentScriptAzurePowerShellEnvironmentVariableOutputReference;
}
export interface ResourceDeploymentScriptAzurePowerShellIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#identity_ids ResourceDeploymentScriptAzurePowerShell#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#type ResourceDeploymentScriptAzurePowerShell#type}
    */
    readonly type: string;
}
export declare function resourceDeploymentScriptAzurePowerShellIdentityToTerraform(struct?: ResourceDeploymentScriptAzurePowerShellIdentityOutputReference | ResourceDeploymentScriptAzurePowerShellIdentity): any;
export declare function resourceDeploymentScriptAzurePowerShellIdentityToHclTerraform(struct?: ResourceDeploymentScriptAzurePowerShellIdentityOutputReference | ResourceDeploymentScriptAzurePowerShellIdentity): any;
export declare class ResourceDeploymentScriptAzurePowerShellIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceDeploymentScriptAzurePowerShellIdentity | undefined;
    set internalValue(value: ResourceDeploymentScriptAzurePowerShellIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ResourceDeploymentScriptAzurePowerShellStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#key ResourceDeploymentScriptAzurePowerShell#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#name ResourceDeploymentScriptAzurePowerShell#name}
    */
    readonly name: string;
}
export declare function resourceDeploymentScriptAzurePowerShellStorageAccountToTerraform(struct?: ResourceDeploymentScriptAzurePowerShellStorageAccountOutputReference | ResourceDeploymentScriptAzurePowerShellStorageAccount): any;
export declare function resourceDeploymentScriptAzurePowerShellStorageAccountToHclTerraform(struct?: ResourceDeploymentScriptAzurePowerShellStorageAccountOutputReference | ResourceDeploymentScriptAzurePowerShellStorageAccount): any;
export declare class ResourceDeploymentScriptAzurePowerShellStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceDeploymentScriptAzurePowerShellStorageAccount | undefined;
    set internalValue(value: ResourceDeploymentScriptAzurePowerShellStorageAccount | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface ResourceDeploymentScriptAzurePowerShellTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#create ResourceDeploymentScriptAzurePowerShell#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#delete ResourceDeploymentScriptAzurePowerShell#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#read ResourceDeploymentScriptAzurePowerShell#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#update ResourceDeploymentScriptAzurePowerShell#update}
    */
    readonly update?: string;
}
export declare function resourceDeploymentScriptAzurePowerShellTimeoutsToTerraform(struct?: ResourceDeploymentScriptAzurePowerShellTimeouts | cdktf.IResolvable): any;
export declare function resourceDeploymentScriptAzurePowerShellTimeoutsToHclTerraform(struct?: ResourceDeploymentScriptAzurePowerShellTimeouts | cdktf.IResolvable): any;
export declare class ResourceDeploymentScriptAzurePowerShellTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceDeploymentScriptAzurePowerShellTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceDeploymentScriptAzurePowerShellTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell azurerm_resource_deployment_script_azure_power_shell}
*/
export declare class ResourceDeploymentScriptAzurePowerShell extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_deployment_script_azure_power_shell";
    /**
    * Generates CDKTF code for importing a ResourceDeploymentScriptAzurePowerShell resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceDeploymentScriptAzurePowerShell to import
    * @param importFromId The id of the existing ResourceDeploymentScriptAzurePowerShell that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceDeploymentScriptAzurePowerShell to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/resource_deployment_script_azure_power_shell azurerm_resource_deployment_script_azure_power_shell} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceDeploymentScriptAzurePowerShellConfig
    */
    constructor(scope: Construct, id: string, config: ResourceDeploymentScriptAzurePowerShellConfig);
    private _cleanupPreference?;
    get cleanupPreference(): string;
    set cleanupPreference(value: string);
    resetCleanupPreference(): void;
    get cleanupPreferenceInput(): string | undefined;
    private _commandLine?;
    get commandLine(): string;
    set commandLine(value: string);
    resetCommandLine(): void;
    get commandLineInput(): string | undefined;
    private _forceUpdateTag?;
    get forceUpdateTag(): string;
    set forceUpdateTag(value: string);
    resetForceUpdateTag(): void;
    get forceUpdateTagInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputs(): string;
    private _primaryScriptUri?;
    get primaryScriptUri(): string;
    set primaryScriptUri(value: string);
    resetPrimaryScriptUri(): void;
    get primaryScriptUriInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retentionInterval?;
    get retentionInterval(): string;
    set retentionInterval(value: string);
    get retentionIntervalInput(): string | undefined;
    private _scriptContent?;
    get scriptContent(): string;
    set scriptContent(value: string);
    resetScriptContent(): void;
    get scriptContentInput(): string | undefined;
    private _supportingScriptUris?;
    get supportingScriptUris(): string[];
    set supportingScriptUris(value: string[]);
    resetSupportingScriptUris(): void;
    get supportingScriptUrisInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _container;
    get container(): ResourceDeploymentScriptAzurePowerShellContainerOutputReference;
    putContainer(value: ResourceDeploymentScriptAzurePowerShellContainer): void;
    resetContainer(): void;
    get containerInput(): ResourceDeploymentScriptAzurePowerShellContainer | undefined;
    private _environmentVariable;
    get environmentVariable(): ResourceDeploymentScriptAzurePowerShellEnvironmentVariableList;
    putEnvironmentVariable(value: ResourceDeploymentScriptAzurePowerShellEnvironmentVariable[] | cdktf.IResolvable): void;
    resetEnvironmentVariable(): void;
    get environmentVariableInput(): cdktf.IResolvable | ResourceDeploymentScriptAzurePowerShellEnvironmentVariable[] | undefined;
    private _identity;
    get identity(): ResourceDeploymentScriptAzurePowerShellIdentityOutputReference;
    putIdentity(value: ResourceDeploymentScriptAzurePowerShellIdentity): void;
    resetIdentity(): void;
    get identityInput(): ResourceDeploymentScriptAzurePowerShellIdentity | undefined;
    private _storageAccount;
    get storageAccount(): ResourceDeploymentScriptAzurePowerShellStorageAccountOutputReference;
    putStorageAccount(value: ResourceDeploymentScriptAzurePowerShellStorageAccount): void;
    resetStorageAccount(): void;
    get storageAccountInput(): ResourceDeploymentScriptAzurePowerShellStorageAccount | undefined;
    private _timeouts;
    get timeouts(): ResourceDeploymentScriptAzurePowerShellTimeoutsOutputReference;
    putTimeouts(value: ResourceDeploymentScriptAzurePowerShellTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceDeploymentScriptAzurePowerShellTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
