/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SiteRecoveryProtectionContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#id SiteRecoveryProtectionContainer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#name SiteRecoveryProtectionContainer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#recovery_fabric_name SiteRecoveryProtectionContainer#recovery_fabric_name}
    */
    readonly recoveryFabricName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#recovery_vault_name SiteRecoveryProtectionContainer#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#resource_group_name SiteRecoveryProtectionContainer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#timeouts SiteRecoveryProtectionContainer#timeouts}
    */
    readonly timeouts?: SiteRecoveryProtectionContainerTimeouts;
}
export interface SiteRecoveryProtectionContainerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#create SiteRecoveryProtectionContainer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#delete SiteRecoveryProtectionContainer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#read SiteRecoveryProtectionContainer#read}
    */
    readonly read?: string;
}
export declare function siteRecoveryProtectionContainerTimeoutsToTerraform(struct?: SiteRecoveryProtectionContainerTimeouts | cdktf.IResolvable): any;
export declare function siteRecoveryProtectionContainerTimeoutsToHclTerraform(struct?: SiteRecoveryProtectionContainerTimeouts | cdktf.IResolvable): any;
export declare class SiteRecoveryProtectionContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SiteRecoveryProtectionContainerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryProtectionContainerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container azurerm_site_recovery_protection_container}
*/
export declare class SiteRecoveryProtectionContainer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_site_recovery_protection_container";
    /**
    * Generates CDKTF code for importing a SiteRecoveryProtectionContainer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SiteRecoveryProtectionContainer to import
    * @param importFromId The id of the existing SiteRecoveryProtectionContainer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SiteRecoveryProtectionContainer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/site_recovery_protection_container azurerm_site_recovery_protection_container} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SiteRecoveryProtectionContainerConfig
    */
    constructor(scope: Construct, id: string, config: SiteRecoveryProtectionContainerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryFabricName?;
    get recoveryFabricName(): string;
    set recoveryFabricName(value: string);
    get recoveryFabricNameInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): SiteRecoveryProtectionContainerTimeoutsOutputReference;
    putTimeouts(value: SiteRecoveryProtectionContainerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SiteRecoveryProtectionContainerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
