/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#application_performance_monitoring_ids SpringCloudGateway#application_performance_monitoring_ids}
    */
    readonly applicationPerformanceMonitoringIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#application_performance_monitoring_types SpringCloudGateway#application_performance_monitoring_types}
    */
    readonly applicationPerformanceMonitoringTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#environment_variables SpringCloudGateway#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#https_only SpringCloudGateway#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#id SpringCloudGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#instance_count SpringCloudGateway#instance_count}
    */
    readonly instanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#name SpringCloudGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#public_network_access_enabled SpringCloudGateway#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#sensitive_environment_variables SpringCloudGateway#sensitive_environment_variables}
    */
    readonly sensitiveEnvironmentVariables?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#spring_cloud_service_id SpringCloudGateway#spring_cloud_service_id}
    */
    readonly springCloudServiceId: string;
    /**
    * api_metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#api_metadata SpringCloudGateway#api_metadata}
    */
    readonly apiMetadata?: SpringCloudGatewayApiMetadata;
    /**
    * client_authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#client_authorization SpringCloudGateway#client_authorization}
    */
    readonly clientAuthorization?: SpringCloudGatewayClientAuthorization;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#cors SpringCloudGateway#cors}
    */
    readonly cors?: SpringCloudGatewayCors;
    /**
    * local_response_cache_per_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#local_response_cache_per_instance SpringCloudGateway#local_response_cache_per_instance}
    */
    readonly localResponseCachePerInstance?: SpringCloudGatewayLocalResponseCachePerInstance;
    /**
    * local_response_cache_per_route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#local_response_cache_per_route SpringCloudGateway#local_response_cache_per_route}
    */
    readonly localResponseCachePerRoute?: SpringCloudGatewayLocalResponseCachePerRoute;
    /**
    * quota block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#quota SpringCloudGateway#quota}
    */
    readonly quota?: SpringCloudGatewayQuota;
    /**
    * sso block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#sso SpringCloudGateway#sso}
    */
    readonly sso?: SpringCloudGatewaySso;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#timeouts SpringCloudGateway#timeouts}
    */
    readonly timeouts?: SpringCloudGatewayTimeouts;
}
export interface SpringCloudGatewayApiMetadata {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#description SpringCloudGateway#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#documentation_url SpringCloudGateway#documentation_url}
    */
    readonly documentationUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#server_url SpringCloudGateway#server_url}
    */
    readonly serverUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#title SpringCloudGateway#title}
    */
    readonly title?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#version SpringCloudGateway#version}
    */
    readonly version?: string;
}
export declare function springCloudGatewayApiMetadataToTerraform(struct?: SpringCloudGatewayApiMetadataOutputReference | SpringCloudGatewayApiMetadata): any;
export declare function springCloudGatewayApiMetadataToHclTerraform(struct?: SpringCloudGatewayApiMetadataOutputReference | SpringCloudGatewayApiMetadata): any;
export declare class SpringCloudGatewayApiMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayApiMetadata | undefined;
    set internalValue(value: SpringCloudGatewayApiMetadata | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _documentationUrl?;
    get documentationUrl(): string;
    set documentationUrl(value: string);
    resetDocumentationUrl(): void;
    get documentationUrlInput(): string | undefined;
    private _serverUrl?;
    get serverUrl(): string;
    set serverUrl(value: string);
    resetServerUrl(): void;
    get serverUrlInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface SpringCloudGatewayClientAuthorization {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#certificate_ids SpringCloudGateway#certificate_ids}
    */
    readonly certificateIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#verification_enabled SpringCloudGateway#verification_enabled}
    */
    readonly verificationEnabled?: boolean | cdktf.IResolvable;
}
export declare function springCloudGatewayClientAuthorizationToTerraform(struct?: SpringCloudGatewayClientAuthorizationOutputReference | SpringCloudGatewayClientAuthorization): any;
export declare function springCloudGatewayClientAuthorizationToHclTerraform(struct?: SpringCloudGatewayClientAuthorizationOutputReference | SpringCloudGatewayClientAuthorization): any;
export declare class SpringCloudGatewayClientAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayClientAuthorization | undefined;
    set internalValue(value: SpringCloudGatewayClientAuthorization | undefined);
    private _certificateIds?;
    get certificateIds(): string[];
    set certificateIds(value: string[]);
    resetCertificateIds(): void;
    get certificateIdsInput(): string[] | undefined;
    private _verificationEnabled?;
    get verificationEnabled(): boolean | cdktf.IResolvable;
    set verificationEnabled(value: boolean | cdktf.IResolvable);
    resetVerificationEnabled(): void;
    get verificationEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SpringCloudGatewayCors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#allowed_headers SpringCloudGateway#allowed_headers}
    */
    readonly allowedHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#allowed_methods SpringCloudGateway#allowed_methods}
    */
    readonly allowedMethods?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#allowed_origin_patterns SpringCloudGateway#allowed_origin_patterns}
    */
    readonly allowedOriginPatterns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#allowed_origins SpringCloudGateway#allowed_origins}
    */
    readonly allowedOrigins?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#credentials_allowed SpringCloudGateway#credentials_allowed}
    */
    readonly credentialsAllowed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#exposed_headers SpringCloudGateway#exposed_headers}
    */
    readonly exposedHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#max_age_seconds SpringCloudGateway#max_age_seconds}
    */
    readonly maxAgeSeconds?: number;
}
export declare function springCloudGatewayCorsToTerraform(struct?: SpringCloudGatewayCorsOutputReference | SpringCloudGatewayCors): any;
export declare function springCloudGatewayCorsToHclTerraform(struct?: SpringCloudGatewayCorsOutputReference | SpringCloudGatewayCors): any;
export declare class SpringCloudGatewayCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayCors | undefined;
    set internalValue(value: SpringCloudGatewayCors | undefined);
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    resetAllowedHeaders(): void;
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    resetAllowedMethods(): void;
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOriginPatterns?;
    get allowedOriginPatterns(): string[];
    set allowedOriginPatterns(value: string[]);
    resetAllowedOriginPatterns(): void;
    get allowedOriginPatternsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    resetAllowedOrigins(): void;
    get allowedOriginsInput(): string[] | undefined;
    private _credentialsAllowed?;
    get credentialsAllowed(): boolean | cdktf.IResolvable;
    set credentialsAllowed(value: boolean | cdktf.IResolvable);
    resetCredentialsAllowed(): void;
    get credentialsAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _exposedHeaders?;
    get exposedHeaders(): string[];
    set exposedHeaders(value: string[]);
    resetExposedHeaders(): void;
    get exposedHeadersInput(): string[] | undefined;
    private _maxAgeSeconds?;
    get maxAgeSeconds(): number;
    set maxAgeSeconds(value: number);
    resetMaxAgeSeconds(): void;
    get maxAgeSecondsInput(): number | undefined;
}
export interface SpringCloudGatewayLocalResponseCachePerInstance {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#size SpringCloudGateway#size}
    */
    readonly size?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#time_to_live SpringCloudGateway#time_to_live}
    */
    readonly timeToLive?: string;
}
export declare function springCloudGatewayLocalResponseCachePerInstanceToTerraform(struct?: SpringCloudGatewayLocalResponseCachePerInstanceOutputReference | SpringCloudGatewayLocalResponseCachePerInstance): any;
export declare function springCloudGatewayLocalResponseCachePerInstanceToHclTerraform(struct?: SpringCloudGatewayLocalResponseCachePerInstanceOutputReference | SpringCloudGatewayLocalResponseCachePerInstance): any;
export declare class SpringCloudGatewayLocalResponseCachePerInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayLocalResponseCachePerInstance | undefined;
    set internalValue(value: SpringCloudGatewayLocalResponseCachePerInstance | undefined);
    private _size?;
    get size(): string;
    set size(value: string);
    resetSize(): void;
    get sizeInput(): string | undefined;
    private _timeToLive?;
    get timeToLive(): string;
    set timeToLive(value: string);
    resetTimeToLive(): void;
    get timeToLiveInput(): string | undefined;
}
export interface SpringCloudGatewayLocalResponseCachePerRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#size SpringCloudGateway#size}
    */
    readonly size?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#time_to_live SpringCloudGateway#time_to_live}
    */
    readonly timeToLive?: string;
}
export declare function springCloudGatewayLocalResponseCachePerRouteToTerraform(struct?: SpringCloudGatewayLocalResponseCachePerRouteOutputReference | SpringCloudGatewayLocalResponseCachePerRoute): any;
export declare function springCloudGatewayLocalResponseCachePerRouteToHclTerraform(struct?: SpringCloudGatewayLocalResponseCachePerRouteOutputReference | SpringCloudGatewayLocalResponseCachePerRoute): any;
export declare class SpringCloudGatewayLocalResponseCachePerRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayLocalResponseCachePerRoute | undefined;
    set internalValue(value: SpringCloudGatewayLocalResponseCachePerRoute | undefined);
    private _size?;
    get size(): string;
    set size(value: string);
    resetSize(): void;
    get sizeInput(): string | undefined;
    private _timeToLive?;
    get timeToLive(): string;
    set timeToLive(value: string);
    resetTimeToLive(): void;
    get timeToLiveInput(): string | undefined;
}
export interface SpringCloudGatewayQuota {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#cpu SpringCloudGateway#cpu}
    */
    readonly cpu?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#memory SpringCloudGateway#memory}
    */
    readonly memory?: string;
}
export declare function springCloudGatewayQuotaToTerraform(struct?: SpringCloudGatewayQuotaOutputReference | SpringCloudGatewayQuota): any;
export declare function springCloudGatewayQuotaToHclTerraform(struct?: SpringCloudGatewayQuotaOutputReference | SpringCloudGatewayQuota): any;
export declare class SpringCloudGatewayQuotaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayQuota | undefined;
    set internalValue(value: SpringCloudGatewayQuota | undefined);
    private _cpu?;
    get cpu(): string;
    set cpu(value: string);
    resetCpu(): void;
    get cpuInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface SpringCloudGatewaySso {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#client_id SpringCloudGateway#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#client_secret SpringCloudGateway#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#issuer_uri SpringCloudGateway#issuer_uri}
    */
    readonly issuerUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#scope SpringCloudGateway#scope}
    */
    readonly scope?: string[];
}
export declare function springCloudGatewaySsoToTerraform(struct?: SpringCloudGatewaySsoOutputReference | SpringCloudGatewaySso): any;
export declare function springCloudGatewaySsoToHclTerraform(struct?: SpringCloudGatewaySsoOutputReference | SpringCloudGatewaySso): any;
export declare class SpringCloudGatewaySsoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewaySso | undefined;
    set internalValue(value: SpringCloudGatewaySso | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _issuerUri?;
    get issuerUri(): string;
    set issuerUri(value: string);
    resetIssuerUri(): void;
    get issuerUriInput(): string | undefined;
    private _scope?;
    get scope(): string[];
    set scope(value: string[]);
    resetScope(): void;
    get scopeInput(): string[] | undefined;
}
export interface SpringCloudGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#create SpringCloudGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#delete SpringCloudGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#read SpringCloudGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#update SpringCloudGateway#update}
    */
    readonly update?: string;
}
export declare function springCloudGatewayTimeoutsToTerraform(struct?: SpringCloudGatewayTimeouts | cdktf.IResolvable): any;
export declare function springCloudGatewayTimeoutsToHclTerraform(struct?: SpringCloudGatewayTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway azurerm_spring_cloud_gateway}
*/
export declare class SpringCloudGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_gateway";
    /**
    * Generates CDKTF code for importing a SpringCloudGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudGateway to import
    * @param importFromId The id of the existing SpringCloudGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/spring_cloud_gateway azurerm_spring_cloud_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudGatewayConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudGatewayConfig);
    private _applicationPerformanceMonitoringIds?;
    get applicationPerformanceMonitoringIds(): string[];
    set applicationPerformanceMonitoringIds(value: string[]);
    resetApplicationPerformanceMonitoringIds(): void;
    get applicationPerformanceMonitoringIdsInput(): string[] | undefined;
    private _applicationPerformanceMonitoringTypes?;
    get applicationPerformanceMonitoringTypes(): string[];
    set applicationPerformanceMonitoringTypes(value: string[]);
    resetApplicationPerformanceMonitoringTypes(): void;
    get applicationPerformanceMonitoringTypesInput(): string[] | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceCount?;
    get instanceCount(): number;
    set instanceCount(value: number);
    resetInstanceCount(): void;
    get instanceCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sensitiveEnvironmentVariables?;
    get sensitiveEnvironmentVariables(): {
        [key: string]: string;
    };
    set sensitiveEnvironmentVariables(value: {
        [key: string]: string;
    });
    resetSensitiveEnvironmentVariables(): void;
    get sensitiveEnvironmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _springCloudServiceId?;
    get springCloudServiceId(): string;
    set springCloudServiceId(value: string);
    get springCloudServiceIdInput(): string | undefined;
    get url(): string;
    private _apiMetadata;
    get apiMetadata(): SpringCloudGatewayApiMetadataOutputReference;
    putApiMetadata(value: SpringCloudGatewayApiMetadata): void;
    resetApiMetadata(): void;
    get apiMetadataInput(): SpringCloudGatewayApiMetadata | undefined;
    private _clientAuthorization;
    get clientAuthorization(): SpringCloudGatewayClientAuthorizationOutputReference;
    putClientAuthorization(value: SpringCloudGatewayClientAuthorization): void;
    resetClientAuthorization(): void;
    get clientAuthorizationInput(): SpringCloudGatewayClientAuthorization | undefined;
    private _cors;
    get cors(): SpringCloudGatewayCorsOutputReference;
    putCors(value: SpringCloudGatewayCors): void;
    resetCors(): void;
    get corsInput(): SpringCloudGatewayCors | undefined;
    private _localResponseCachePerInstance;
    get localResponseCachePerInstance(): SpringCloudGatewayLocalResponseCachePerInstanceOutputReference;
    putLocalResponseCachePerInstance(value: SpringCloudGatewayLocalResponseCachePerInstance): void;
    resetLocalResponseCachePerInstance(): void;
    get localResponseCachePerInstanceInput(): SpringCloudGatewayLocalResponseCachePerInstance | undefined;
    private _localResponseCachePerRoute;
    get localResponseCachePerRoute(): SpringCloudGatewayLocalResponseCachePerRouteOutputReference;
    putLocalResponseCachePerRoute(value: SpringCloudGatewayLocalResponseCachePerRoute): void;
    resetLocalResponseCachePerRoute(): void;
    get localResponseCachePerRouteInput(): SpringCloudGatewayLocalResponseCachePerRoute | undefined;
    private _quota;
    get quota(): SpringCloudGatewayQuotaOutputReference;
    putQuota(value: SpringCloudGatewayQuota): void;
    resetQuota(): void;
    get quotaInput(): SpringCloudGatewayQuota | undefined;
    private _sso;
    get sso(): SpringCloudGatewaySsoOutputReference;
    putSso(value: SpringCloudGatewaySso): void;
    resetSso(): void;
    get ssoInput(): SpringCloudGatewaySso | undefined;
    private _timeouts;
    get timeouts(): SpringCloudGatewayTimeoutsOutputReference;
    putTimeouts(value: SpringCloudGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
