/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageMoverProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#description StorageMoverProject#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#id StorageMoverProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#name StorageMoverProject#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#storage_mover_id StorageMoverProject#storage_mover_id}
    */
    readonly storageMoverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#timeouts StorageMoverProject#timeouts}
    */
    readonly timeouts?: StorageMoverProjectTimeouts;
}
export interface StorageMoverProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#create StorageMoverProject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#delete StorageMoverProject#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#read StorageMoverProject#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#update StorageMoverProject#update}
    */
    readonly update?: string;
}
export declare function storageMoverProjectTimeoutsToTerraform(struct?: StorageMoverProjectTimeouts | cdktf.IResolvable): any;
export declare function storageMoverProjectTimeoutsToHclTerraform(struct?: StorageMoverProjectTimeouts | cdktf.IResolvable): any;
export declare class StorageMoverProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageMoverProjectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageMoverProjectTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project azurerm_storage_mover_project}
*/
export declare class StorageMoverProject extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_mover_project";
    /**
    * Generates CDKTF code for importing a StorageMoverProject resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageMoverProject to import
    * @param importFromId The id of the existing StorageMoverProject that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageMoverProject to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/storage_mover_project azurerm_storage_mover_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageMoverProjectConfig
    */
    constructor(scope: Construct, id: string, config: StorageMoverProjectConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageMoverId?;
    get storageMoverId(): string;
    set storageMoverId(value: string);
    get storageMoverIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageMoverProjectTimeoutsOutputReference;
    putTimeouts(value: StorageMoverProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageMoverProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
