/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VoiceServicesCommunicationsGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#api_bridge VoiceServicesCommunicationsGateway#api_bridge}
    */
    readonly apiBridge?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#auto_generated_domain_name_label_scope VoiceServicesCommunicationsGateway#auto_generated_domain_name_label_scope}
    */
    readonly autoGeneratedDomainNameLabelScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#codecs VoiceServicesCommunicationsGateway#codecs}
    */
    readonly codecs: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#connectivity VoiceServicesCommunicationsGateway#connectivity}
    */
    readonly connectivity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#e911_type VoiceServicesCommunicationsGateway#e911_type}
    */
    readonly e911Type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#emergency_dial_strings VoiceServicesCommunicationsGateway#emergency_dial_strings}
    */
    readonly emergencyDialStrings?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#id VoiceServicesCommunicationsGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#location VoiceServicesCommunicationsGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#microsoft_teams_voicemail_pilot_number VoiceServicesCommunicationsGateway#microsoft_teams_voicemail_pilot_number}
    */
    readonly microsoftTeamsVoicemailPilotNumber?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#name VoiceServicesCommunicationsGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#on_prem_mcp_enabled VoiceServicesCommunicationsGateway#on_prem_mcp_enabled}
    */
    readonly onPremMcpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#platforms VoiceServicesCommunicationsGateway#platforms}
    */
    readonly platforms: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#resource_group_name VoiceServicesCommunicationsGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#tags VoiceServicesCommunicationsGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * service_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#service_location VoiceServicesCommunicationsGateway#service_location}
    */
    readonly serviceLocation: VoiceServicesCommunicationsGatewayServiceLocation[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#timeouts VoiceServicesCommunicationsGateway#timeouts}
    */
    readonly timeouts?: VoiceServicesCommunicationsGatewayTimeouts;
}
export interface VoiceServicesCommunicationsGatewayServiceLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#allowed_media_source_address_prefixes VoiceServicesCommunicationsGateway#allowed_media_source_address_prefixes}
    */
    readonly allowedMediaSourceAddressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#allowed_signaling_source_address_prefixes VoiceServicesCommunicationsGateway#allowed_signaling_source_address_prefixes}
    */
    readonly allowedSignalingSourceAddressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#esrp_addresses VoiceServicesCommunicationsGateway#esrp_addresses}
    */
    readonly esrpAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#location VoiceServicesCommunicationsGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#operator_addresses VoiceServicesCommunicationsGateway#operator_addresses}
    */
    readonly operatorAddresses: string[];
}
export declare function voiceServicesCommunicationsGatewayServiceLocationToTerraform(struct?: VoiceServicesCommunicationsGatewayServiceLocation | cdktf.IResolvable): any;
export declare function voiceServicesCommunicationsGatewayServiceLocationToHclTerraform(struct?: VoiceServicesCommunicationsGatewayServiceLocation | cdktf.IResolvable): any;
export declare class VoiceServicesCommunicationsGatewayServiceLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VoiceServicesCommunicationsGatewayServiceLocation | cdktf.IResolvable | undefined;
    set internalValue(value: VoiceServicesCommunicationsGatewayServiceLocation | cdktf.IResolvable | undefined);
    private _allowedMediaSourceAddressPrefixes?;
    get allowedMediaSourceAddressPrefixes(): string[];
    set allowedMediaSourceAddressPrefixes(value: string[]);
    resetAllowedMediaSourceAddressPrefixes(): void;
    get allowedMediaSourceAddressPrefixesInput(): string[] | undefined;
    private _allowedSignalingSourceAddressPrefixes?;
    get allowedSignalingSourceAddressPrefixes(): string[];
    set allowedSignalingSourceAddressPrefixes(value: string[]);
    resetAllowedSignalingSourceAddressPrefixes(): void;
    get allowedSignalingSourceAddressPrefixesInput(): string[] | undefined;
    private _esrpAddresses?;
    get esrpAddresses(): string[];
    set esrpAddresses(value: string[]);
    resetEsrpAddresses(): void;
    get esrpAddressesInput(): string[] | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _operatorAddresses?;
    get operatorAddresses(): string[];
    set operatorAddresses(value: string[]);
    get operatorAddressesInput(): string[] | undefined;
}
export declare class VoiceServicesCommunicationsGatewayServiceLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VoiceServicesCommunicationsGatewayServiceLocation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VoiceServicesCommunicationsGatewayServiceLocationOutputReference;
}
export interface VoiceServicesCommunicationsGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#create VoiceServicesCommunicationsGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#delete VoiceServicesCommunicationsGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#read VoiceServicesCommunicationsGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#update VoiceServicesCommunicationsGateway#update}
    */
    readonly update?: string;
}
export declare function voiceServicesCommunicationsGatewayTimeoutsToTerraform(struct?: VoiceServicesCommunicationsGatewayTimeouts | cdktf.IResolvable): any;
export declare function voiceServicesCommunicationsGatewayTimeoutsToHclTerraform(struct?: VoiceServicesCommunicationsGatewayTimeouts | cdktf.IResolvable): any;
export declare class VoiceServicesCommunicationsGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VoiceServicesCommunicationsGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VoiceServicesCommunicationsGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway azurerm_voice_services_communications_gateway}
*/
export declare class VoiceServicesCommunicationsGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_voice_services_communications_gateway";
    /**
    * Generates CDKTF code for importing a VoiceServicesCommunicationsGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VoiceServicesCommunicationsGateway to import
    * @param importFromId The id of the existing VoiceServicesCommunicationsGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VoiceServicesCommunicationsGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/voice_services_communications_gateway azurerm_voice_services_communications_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VoiceServicesCommunicationsGatewayConfig
    */
    constructor(scope: Construct, id: string, config: VoiceServicesCommunicationsGatewayConfig);
    private _apiBridge?;
    get apiBridge(): string;
    set apiBridge(value: string);
    resetApiBridge(): void;
    get apiBridgeInput(): string | undefined;
    private _autoGeneratedDomainNameLabelScope?;
    get autoGeneratedDomainNameLabelScope(): string;
    set autoGeneratedDomainNameLabelScope(value: string);
    resetAutoGeneratedDomainNameLabelScope(): void;
    get autoGeneratedDomainNameLabelScopeInput(): string | undefined;
    private _codecs?;
    get codecs(): string;
    set codecs(value: string);
    get codecsInput(): string | undefined;
    private _connectivity?;
    get connectivity(): string;
    set connectivity(value: string);
    get connectivityInput(): string | undefined;
    private _e911Type?;
    get e911Type(): string;
    set e911Type(value: string);
    get e911TypeInput(): string | undefined;
    private _emergencyDialStrings?;
    get emergencyDialStrings(): string[];
    set emergencyDialStrings(value: string[]);
    resetEmergencyDialStrings(): void;
    get emergencyDialStringsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _microsoftTeamsVoicemailPilotNumber?;
    get microsoftTeamsVoicemailPilotNumber(): string;
    set microsoftTeamsVoicemailPilotNumber(value: string);
    resetMicrosoftTeamsVoicemailPilotNumber(): void;
    get microsoftTeamsVoicemailPilotNumberInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _onPremMcpEnabled?;
    get onPremMcpEnabled(): boolean | cdktf.IResolvable;
    set onPremMcpEnabled(value: boolean | cdktf.IResolvable);
    resetOnPremMcpEnabled(): void;
    get onPremMcpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _platforms?;
    get platforms(): string[];
    set platforms(value: string[]);
    get platformsInput(): string[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _serviceLocation;
    get serviceLocation(): VoiceServicesCommunicationsGatewayServiceLocationList;
    putServiceLocation(value: VoiceServicesCommunicationsGatewayServiceLocation[] | cdktf.IResolvable): void;
    get serviceLocationInput(): cdktf.IResolvable | VoiceServicesCommunicationsGatewayServiceLocation[] | undefined;
    private _timeouts;
    get timeouts(): VoiceServicesCommunicationsGatewayTimeoutsOutputReference;
    putTimeouts(value: VoiceServicesCommunicationsGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VoiceServicesCommunicationsGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
