# Generated by Django 4.2.7 on 2023-11-13 08:07

import aldryn_apphooks_config.fields
import app_data.fields
import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangocms_text.fields
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("filer", "0017_image__transparent"),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Author",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="First name"
                    ),
                ),
                (
                    "last_name",
                    models.CharField(max_length=255, verbose_name="Last name"),
                ),
            ],
            options={
                "unique_together": {("first_name", "last_name")},
            },
        ),
        migrations.CreateModel(
            name="Bookstore",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Bookstore name.",
                        max_length=255,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CatalogBooksConfig",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("type", models.CharField(max_length=100, verbose_name="Type")),
                (
                    "namespace",
                    models.CharField(
                        default=None,
                        max_length=100,
                        unique=True,
                        verbose_name="Instance namespace",
                    ),
                ),
                (
                    "app_data",
                    app_data.fields.AppDataField(default="{}", editable=False),
                ),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                (
                    "list_group_by",
                    models.PositiveIntegerField(
                        default=5,
                        help_text='Number of items for group "Load more".',
                        verbose_name="List Group size",
                    ),
                ),
                (
                    "tiles_group_by",
                    models.PositiveIntegerField(
                        default=9,
                        help_text='Number of items for group "Load more".',
                        verbose_name="Tiles Group size",
                    ),
                ),
                (
                    "list_paginate_by",
                    models.PositiveIntegerField(
                        default=50,
                        help_text="Total number of items on the page.",
                        verbose_name="List Paginate size",
                    ),
                ),
                (
                    "tiles_paginate_by",
                    models.PositiveIntegerField(
                        default=50,
                        help_text="Total number of items on the page.",
                        verbose_name="Tiles Paginate size",
                    ),
                ),
                (
                    "list_thumbnail_width",
                    models.PositiveIntegerField(
                        default=196, verbose_name="List Thumbnail Width"
                    ),
                ),
                (
                    "list_thumbnail_height",
                    models.PositiveIntegerField(
                        default=261, verbose_name="List Thumbnail Height"
                    ),
                ),
                (
                    "tiles_thumbnail_width",
                    models.PositiveIntegerField(
                        default=306, verbose_name="Tiles Thumbnail Width"
                    ),
                ),
                (
                    "tiles_thumbnail_height",
                    models.PositiveIntegerField(
                        default=408, verbose_name="Tiles Thumbnail Height"
                    ),
                ),
                (
                    "detail_thumbnail_width",
                    models.PositiveIntegerField(
                        default=319, verbose_name="Detail Thumbnail Width"
                    ),
                ),
                (
                    "detail_thumbnail_height",
                    models.PositiveIntegerField(
                        default=453, verbose_name="Detail Thumbnail Height"
                    ),
                ),
                (
                    "list_css",
                    models.SlugField(
                        blank=True,
                        help_text="Set extra css class. E.g. display-button-more.",
                        max_length=255,
                        null=True,
                        verbose_name="List CSS Class",
                    ),
                ),
                (
                    "tiles_css",
                    models.SlugField(
                        blank=True,
                        help_text="Set extra css class. E.g. display-button-more.",
                        max_length=255,
                        null=True,
                        verbose_name="Tiles CSS Class",
                    ),
                ),
                (
                    "detail_css",
                    models.SlugField(
                        blank=True,
                        help_text="Set extra css class.",
                        max_length=255,
                        null=True,
                        verbose_name="Detail CSS Class",
                    ),
                ),
            ],
            options={
                "verbose_name": "Configuration",
                "verbose_name_plural": "Configurations",
            },
        ),
        migrations.CreateModel(
            name="Category",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=255, unique=True, verbose_name="Name"),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="Slug for css class.",
                        max_length=255,
                        unique=True,
                        verbose_name="Slug",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Categories",
            },
        ),
        migrations.CreateModel(
            name="StorePage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="URL to the page with book.",
                        unique=True,
                        verbose_name="URL",
                    ),
                ),
                (
                    "bookstore",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="catalog_books.bookstore",
                        verbose_name="Bookstore",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="License",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="Name")),
                (
                    "version",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="Version"
                    ),
                ),
                (
                    "description",
                    djangocms_text.fields.HTMLField(
                        default="", verbose_name="Description"
                    ),
                ),
                (
                    "icon",
                    filer.fields.image.FilerImageField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.FILER_IMAGE_MODEL,
                        verbose_name="Icon",
                    ),
                ),
            ],
            options={
                "unique_together": {("name", "version")},
            },
        ),
        migrations.CreateModel(
            name="Book",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="Name")),
                (
                    "description",
                    djangocms_text.fields.HTMLField(
                        default="", verbose_name="Description"
                    ),
                ),
                (
                    "highlight",
                    models.BooleanField(
                        default=False,
                        help_text='Highlighted e.g. by the name "New".',
                        verbose_name="Highlight",
                    ),
                ),
                (
                    "hide",
                    models.BooleanField(
                        default=False, help_text="Hide this entry.", verbose_name="Hide"
                    ),
                ),
                (
                    "issue",
                    models.DateField(
                        default=datetime.datetime.today, verbose_name="Issue"
                    ),
                ),
                (
                    "authors_and_team",
                    models.BooleanField(
                        default=False,
                        help_text="Authors and collective",
                        verbose_name="and team",
                    ),
                ),
                (
                    "app_config",
                    aldryn_apphooks_config.fields.AppHookConfigField(
                        help_text="When selecting a value, the form is reloaded to get the updated default",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="catalog_books.catalogbooksconfig",
                    ),
                ),
                (
                    "authors",
                    models.ManyToManyField(
                        blank=True, to="catalog_books.author", verbose_name="Authors"
                    ),
                ),
                (
                    "category",
                    models.ManyToManyField(
                        blank=True, to="catalog_books.category", verbose_name="Category"
                    ),
                ),
                (
                    "ebooks",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Book files in different formats.",
                        related_name="files",
                        to="filer.file",
                        verbose_name="E-Books files",
                    ),
                ),
                (
                    "license",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="catalog_books.license",
                        verbose_name="License",
                    ),
                ),
                (
                    "preview",
                    filer.fields.image.FilerImageField(
                        blank=True,
                        help_text="e.g. Book cover.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="preview",
                        to=settings.FILER_IMAGE_MODEL,
                        verbose_name="Preview",
                    ),
                ),
                (
                    "stores",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Page of the bookstore selling this book.",
                        related_name="store_pages",
                        to="catalog_books.storepage",
                        verbose_name="Bookstores",
                    ),
                ),
            ],
        ),
    ]
