import * as iam from 'aws-cdk-lib/aws-iam';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { LambdaInvoke } from 'aws-cdk-lib/aws-stepfunctions-tasks';
import { Construct } from 'constructs';
/**
 * Verifies that a validation pattern is supported for a service integration
 *
 */
export declare function validatePatternSupported(integrationPattern: sfn.IntegrationPattern, supportedPatterns: sfn.IntegrationPattern[]): void;
export declare enum TextractFeatures {
    FORMS = "FORMS",
    TABLES = "TABLES",
    QUERIES = "QUERIES"
}
export declare function integrationResourceArn(service: string, api: string, integrationPattern?: sfn.IntegrationPattern): string;
/**
 * Properties for StartExecution
 */
export interface TextractStepFunctionsStartExecutionProps extends sfn.TaskStateBaseProps {
    /** The prefix to use for the output files */
    readonly s3OutputPrefix: string;
    /** The prefix to use for the temporary output files (e. g. output from async process before stiching together) */
    readonly s3TempOutputPrefix: string;
    /** The prefix to use for the output files */
    readonly s3OutputBucket: string;
    /** default classification, if a specific document types e. g. ID documents or expenses or invoices should be processed vs generic */
    readonly defaultClassification?: string;
    /** Log Level for all Lambda functions */
    readonly lambdaLogLevel?: string;
    /**not implemented yet */
    readonly maxTPSStartDocumentTextAPICalls?: number;
    /**not implemented yet */
    readonly maxTPSDocumentTextAPICalls?: number;
    /**not implemented yet */
    readonly maxTPSStartAnalyzeDocumentAPICalls?: number;
    /**not implemented yet */
    readonly maxTPSAnalyzeDocumentAPICalls?: number;
    /**not implemented yet */
    readonly maxTPSAnalyzeID?: number;
    /**not implemented yet */
    readonly maxTPSAnalyzeExpense?: number;
    /**not implemented yet */
    readonly maxNumberOpenJobs?: number;
    /**not implemented yet */
    readonly maxConcurrencyTableName?: string;
    /** not implemented yet */
    readonly enableMonitoring?: boolean;
    /** not implemented yet */
    readonly enableDashboard?: boolean;
    /** not implemented yet */
    readonly customFunction?: LambdaInvoke;
    /** taskToken table for async processing */
    readonly taskTokenTable?: string;
    /** taskToken table for async processing */
    readonly concurrencyTableName?: string;
    /** timeout for getting the results */
    readonly workflowTimeoutDurationInMinutes?: number;
    /**
         * The JSON input for the execution, same as that of StartExecution.
         *
         * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
         *
         * @default - The state input (JSON path '$')
         */
    readonly input?: sfn.TaskInput;
    /**
         * The name of the execution, same as that of StartExecution.
         *
         * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
         *
         * @default - None
         */
    readonly name?: string;
    /**
         * Pass the execution ID from the context object to the execution input.
         * This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
         *
         * If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.
         *
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid
         *
         * @default - false
         */
    readonly associateWithParent?: boolean;
}
/**
 * A Step Functions Task to call Textract. Requires
 *
 * It supports three service integration patterns: REQUEST_RESPONSE, RUN_JOB, and WAIT_FOR_TASK_TOKEN.
 */
export declare class TextractStepFunctionsStartExecution extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    stateMachine: sfn.StateMachine;
    constructor(scope: Construct, id: string, props: TextractStepFunctionsStartExecutionProps);
    /**
         * @internal
         */
    protected _renderTask(): any;
    /**
         * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
         *
         * the scoped access policy should be generated accordingly.
         *
         * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
         */
    private createScopedAccessPolicy;
}
