"""
Data format (XML, JSON, YAML) specific code review checklist.
"""

CHECKLIST = """
## 数据格式 (XML, JSON, YAML) 代码审查检查清单

### 通用数据格式检查
- [ ] 文件格式是否有效且符合规范
- [ ] 是否使用了一致的缩进和格式
- [ ] 数据结构是否合理清晰
- [ ] 字段命名是否一致且有意义
- [ ] 是否避免了重复数据
- [ ] 是否避免了过度嵌套
- [ ] 是否有适当的注释 (如格式允许)
- [ ] 敏感信息是否妥善处理 (避免硬编码凭证)

### JSON 特定检查
- [ ] JSON 是否符合语法规范 (引号、逗号等)
- [ ] 是否遵循命名约定 (通常为 camelCase)
- [ ] 是否使用了适当的数据类型
- [ ] 是否避免了重复的键名
- [ ] 是否使用了 JSON Schema 进行验证
- [ ] 较大的 JSON 文件是否考虑了性能影响
- [ ] 是否考虑了国际化和字符编码问题
- [ ] 数组索引是否从0开始 (与其他语言一致)

### XML 特定检查
- [ ] XML 是否有合法的文档声明
- [ ] 命名空间是否使用得当
- [ ] 标签是否正确闭合
- [ ] 元素名称是否一致且有意义
- [ ] 属性是否使用得当
- [ ] 是否提供了 XML Schema 或 DTD
- [ ] 是否使用了适当的转义字符
- [ ] 元素和属性选择是否合理 (何时使用元素vs属性)

### YAML 特定检查
- [ ] 缩进是否一致 (通常为2空格)
- [ ] 是否正确使用了锚点和别名
- [ ] 多行字符串格式是否正确 (|, >, 折叠等)
- [ ] 是否避免了使用制表符
- [ ] 列表格式是否一致
- [ ] 是否避免了过度使用复杂的 YAML 特性
- [ ] 布尔值表示是否一致 (true/false 或 yes/no)
- [ ] 是否考虑了解析性能问题

### 配置文件特定检查
- [ ] 配置项是否组织得当
- [ ] 是否提供了默认值
- [ ] 是否有文档说明配置项的用途
- [ ] 敏感配置是否适当保护
- [ ] 环境特定配置是否分离
- [ ] 是否避免了过深的嵌套结构
- [ ] 是否有版本控制策略

### API 定义特定检查 (如 OpenAPI/Swagger)
- [ ] API 路径是否符合 RESTful 设计原则
- [ ] 数据模型是否定义清晰
- [ ] 响应和请求格式是否一致
- [ ] 是否包含了错误处理信息
- [ ] 是否提供了足够的文档说明
- [ ] 版本控制策略是否合理
- [ ] 安全方案是否定义得当

### 数据交换和互操作性
- [ ] 是否考虑了向前/向后兼容性
- [ ] 是否支持扩展 (extensibility)
- [ ] 日期和时间格式是否标准化 (如 ISO 8601)
- [ ] 数字格式是否一致 (精度、科学记数法等)
- [ ] 语言和国际化是否得到支持
- [ ] 数据大小是否在合理范围内
- [ ] 是否考虑了不同系统的互操作性

### 安全性
- [ ] 是否避免了注入漏洞
- [ ] 是否对外部输入进行验证
- [ ] 敏感数据是否适当加密或掩码
- [ ] 是否避免了过度暴露内部数据结构
- [ ] 序列化/反序列化是否安全
- [ ] 是否避免了使用有风险的格式特性
""" 