"""
Infrastructure as Code (Docker, Terraform) specific code review checklist.
"""

CHECKLIST = """
## 基础设施即代码 (Docker, Terraform) 代码审查检查清单

### Docker 通用检查
- [ ] Dockerfile 是否遵循最佳实践
- [ ] 是否使用了适当的基础镜像
- [ ] 是否最小化了镜像层数
- [ ] 是否按照依赖稳定性顺序组织指令
- [ ] 是否移除了不必要的依赖和文件
- [ ] 是否避免安装调试工具和开发依赖
- [ ] 镜像标签是否明确 (避免使用 `latest`)
- [ ] 是否使用了多阶段构建减小镜像大小
- [ ] 是否设置了适当的工作目录 (WORKDIR)

### Docker 安全检查
- [ ] 是否以非 root 用户运行容器
- [ ] 是否限制了容器资源 (CPU, 内存)
- [ ] 是否避免了将敏感信息硬编码到镜像中
- [ ] 是否使用了安全扫描工具检查漏洞
- [ ] 是否设置了适当的文件和目录权限
- [ ] 是否避免了使用特权模式
- [ ] 是否移除了不必要的包和工具
- [ ] 是否在构建时验证下载的软件包

### Docker 优化检查
- [ ] 是否使用了 .dockerignore 文件
- [ ] 是否合并了相关命令减少层数
- [ ] 是否使用了缓存优化构建时间
- [ ] 是否优化了镜像大小
- [ ] 是否避免了不必要的环境变量
- [ ] 是否使用了合适的指令进行健康检查
- [ ] 是否为应用设置了适当的启动命令
- [ ] 构建参数和环境变量是否使用恰当

### Docker Compose 检查
- [ ] 服务配置是否合理
- [ ] 网络配置是否安全且高效
- [ ] 卷挂载是否正确
- [ ] 环境变量是否适当管理
- [ ] 依赖关系是否明确定义
- [ ] 资源限制是否设置
- [ ] 是否使用了版本控制
- [ ] 是否有适当的重启策略

### Terraform 通用检查
- [ ] 代码结构是否模块化和可重用
- [ ] 是否遵循 Terraform 目录结构最佳实践
- [ ] 变量和输出是否有明确的说明文档
- [ ] 资源名称是否一致且有意义
- [ ] 是否避免了硬编码值 (使用变量)
- [ ] 是否明确指定了 provider 版本
- [ ] 是否使用了远程状态存储和锁定
- [ ] 是否遵循命名约定

### Terraform 安全检查
- [ ] 敏感信息是否使用 Terraform 加密存储
- [ ] 是否限制了资源的权限和访问范围
- [ ] 网络安全组/防火墙规则是否遵循最小特权原则
- [ ] 是否启用了资源日志和监控
- [ ] 访问密钥和证书是否安全管理
- [ ] 是否使用循环依赖及其影响
- [ ] 是否正确使用了 IAM 策略和角色
- [ ] 是否考虑了数据加密（传输中和静态）

### Terraform 性能和优化
- [ ] 资源依赖关系是否明确定义
- [ ] 是否避免了创建不必要的资源
- [ ] 是否使用了条件表达式优化资源创建
- [ ] 是否使用了本地值减少重复
- [ ] 是否合理使用了数据源
- [ ] 是否使用 count 或 for_each 简化资源创建
- [ ] 是否优化了资源的创建顺序
- [ ] 是否考虑了高可用性和灾难恢复

### 基础设施即代码 (IaC) 最佳实践
- [ ] 是否实现了基础设施版本控制
- [ ] 是否有适当的变更管理流程
- [ ] 代码是否通过自动化测试
- [ ] 是否创建了可重复的环境
- [ ] 是否使用了不可变基础设施原则
- [ ] 是否考虑了扩展性需求
- [ ] 是否有足够的文档
- [ ] 是否考虑了成本优化

### 云服务提供商特定检查
- [ ] 是否遵循了云服务提供商的最佳实践
- [ ] 资源命名是否符合组织规范
- [ ] 是否设置了适当的资源标签
- [ ] 是否考虑了区域/可用区策略
- [ ] 是否有适当的备份和恢复策略
- [ ] 是否优化了资源成本
- [ ] 是否考虑了服务限制和配额
- [ ] 是否正确配置了自动扩展
""" 