"""
HTML/CSS specific code review checklist.
"""

CHECKLIST = """
## HTML/CSS 代码审查检查清单

### HTML 结构和语义
- [ ] 是否使用了正确的 HTML5 文档类型声明 (<!DOCTYPE html>)
- [ ] 是否使用了语义化标签 (header, nav, main, section, article, footer 等)
- [ ] 文档结构是否清晰且符合逻辑
- [ ] 标题层级 (h1-h6) 是否正确使用且有层次性
- [ ] 是否正确使用列表元素 (ul, ol, dl) 来组织列表内容
- [ ] 链接是否有描述性文本 (避免使用 "点击这里" 之类的文本)
- [ ] 图片是否有适当的 alt 属性
- [ ] 表单元素是否有关联的 label 标签

### HTML 最佳实践
- [ ] 是否使用 UTF-8 字符编码
- [ ] 是否正确设置了视口元标签 (meta viewport)
- [ ] 是否使用了适当的 SEO 元标签
- [ ] ID 是否唯一
- [ ] 类名是否有意义且符合命名约定
- [ ] 是否避免使用内联样式
- [ ] 是否有适当的注释说明复杂结构
- [ ] 是否避免了过度的标签嵌套

### CSS 组织和架构
- [ ] 是否使用了 CSS 方法论 (如 BEM, OOCSS, SMACSS)
- [ ] 选择器是否有效且明确
- [ ] 是否避免过于具体的选择器 (避免过度的嵌套选择器)
- [ ] 是否有清晰的组件/模块化结构
- [ ] 样式规则是否按照逻辑分组和排序
- [ ] 类命名约定是否一致
- [ ] 是否使用 CSS 变量管理主题和重复值
- [ ] 是否使用适当的注释分隔不同的样式部分

### CSS 最佳实践
- [ ] 是否使用了 CSS 重置或归一化 (Normalize.css)
- [ ] 是否使用响应式设计 (媒体查询)
- [ ] 是否使用了合适的单位 (rem/em 用于字体大小, 百分比或 vw/vh 用于响应式布局)
- [ ] 是否设置了合理的盒模型 (box-sizing: border-box)
- [ ] 是否避免使用 !important
- [ ] 是否使用了 flexbox 或 grid 进行布局
- [ ] 颜色和字体是否一致
- [ ] z-index 管理是否合理

### 性能优化
- [ ] 是否避免了不必要的标签嵌套和冗余元素
- [ ] CSS 选择器是否简洁高效
- [ ] 是否避免使用复杂的选择器
- [ ] 是否使用了适当的图片格式和优化
- [ ] 是否为大型网站考虑使用 CSS 分片/代码分割
- [ ] 是否使用了合适的资源延迟加载策略
- [ ] 是否最小化了重绘和回流
- [ ] 是否优化了关键渲染路径

### 可访问性 (A11Y)
- [ ] 颜色对比度是否符合 WCAG 标准
- [ ] 是否正确使用了 ARIA 属性
- [ ] 交互元素是否能够通过键盘访问
- [ ] 是否有适当的焦点状态样式
- [ ] 文本是否可调整大小
- [ ] 动画是否可控制或禁用 (prefers-reduced-motion)
- [ ] 表单错误是否清晰且易于理解
- [ ] 是否通过了可访问性测试和验证

### 跨浏览器兼容性
- [ ] 是否测试了主要浏览器兼容性
- [ ] 是否使用了适当的浏览器前缀
- [ ] 是否避免使用尚未广泛支持的特性
- [ ] 是否有适当的回退方案
- [ ] 是否使用了适当的 polyfills
- [ ] 样式和布局是否在不同设备上保持一致
- [ ] 字体渲染是否考虑了跨平台差异
- [ ] 是否解决了已知的浏览器特定问题

### CSS 预处理器 (如适用)
- [ ] 是否合理使用了变量
- [ ] 是否合理使用了混合 (mixins)
- [ ] 嵌套规则是否控制在合理深度
- [ ] 是否使用了 partials/imports 来组织代码
- [ ] 是否避免了生成过度复杂的 CSS
- [ ] 函数和操作符是否使用得当
- [ ] 扩展/继承是否使用得当
- [ ] 是否避免了重复的代码

### 文档和注释
- [ ] 复杂的 HTML 结构是否有注释
- [ ] 是否有足够的 CSS 注释
- [ ] 是否有设计系统/组件文档
- [ ] 是否记录了浏览器特定的解决方案和黑客技巧
- [ ] 是否记录了颜色系统、排版和网格系统
- [ ] 是否有清晰的 README 或风格指南
- [ ] CSS 变量是否有适当的命名和注释
- [ ] 不明显的布局决策是否有解释
""" 