
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import extend_opview_class as _ods_extend_opview_class, segmented_accessor as _ods_segmented_accessor, equally_sized_accessor as _ods_equally_sized_accessor, get_default_loc_context as _ods_get_default_loc_context, get_op_result_or_value as _get_op_result_or_value, get_op_results_or_values as _get_op_results_or_values
_ods_ir = _ods_cext.ir

try:
  from . import _vector_ops_ext as _ods_ext_module
except ImportError:
  _ods_ext_module = None

import builtins


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "vector"
  pass


@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class VectorScaleOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.vscale"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class BitCastOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class BroadcastOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.broadcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(vector)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def vector(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CompressStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.compressstore"

  _ODS_REGIONS = (0, True)

  def __init__(self, base, indices, mask, valueToStore, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(valueToStore))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def valueToStore(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ConstantMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.constant_mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, mask_dim_sizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["mask_dim_sizes"] = (mask_dim_sizes if (
    issubclass(type(mask_dim_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(mask_dim_sizes, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def mask_dim_sizes(self):
    return self.operation.attributes["mask_dim_sizes"]

  @mask_dim_sizes.setter
  def mask_dim_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mask_dim_sizes"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ContractionOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.contract"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, acc, indexing_maps, iterator_types, *, kind=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["indexing_maps"] = (indexing_maps if (
    issubclass(type(indexing_maps), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(indexing_maps, context=_ods_context))
    attributes["iterator_types"] = (iterator_types if (
    issubclass(type(iterator_types), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Vector_IteratorTypeArrayAttr')) else
      _ods_ir.AttrBuilder.get('Vector_IteratorTypeArrayAttr')(iterator_types, context=_ods_context))
    if kind is not None: attributes["kind"] = (kind if (
        issubclass(type(kind), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
          _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def acc(self):
    return self.operation.operands[2]

  @builtins.property
  def indexing_maps(self):
    return self.operation.attributes["indexing_maps"]

  @indexing_maps.setter
  def indexing_maps(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["indexing_maps"] = value

  @builtins.property
  def iterator_types(self):
    return self.operation.attributes["iterator_types"]

  @iterator_types.setter
  def iterator_types(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["iterator_types"] = value

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CreateMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.create_mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ExpandLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.expandload"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, mask, pass_thru, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(pass_thru))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def pass_thru(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ExtractElementOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.extractelement"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, *, position=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    if position is not None: operands.append(_get_op_result_or_value(position))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def position(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, dynamic_position, static_position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.extend(_get_op_results_or_values(dynamic_position))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_position"] = (static_position if (
    issubclass(type(static_position), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_position, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def dynamic_position(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def static_position(self):
    return self.operation.attributes["static_position"]

  @static_position.setter
  def static_position(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_position"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ExtractStridedSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.extract_strided_slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, vector, offsets, sizes, strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["offsets"] = (offsets if (
    issubclass(type(offsets), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(offsets, context=_ods_context))
    attributes["sizes"] = (sizes if (
    issubclass(type(sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(sizes, context=_ods_context))
    attributes["strides"] = (strides if (
    issubclass(type(strides), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(strides, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def offsets(self):
    return self.operation.attributes["offsets"]

  @offsets.setter
  def offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["offsets"] = value

  @builtins.property
  def sizes(self):
    return self.operation.attributes["sizes"]

  @sizes.setter
  def sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sizes"] = value

  @builtins.property
  def strides(self):
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class FMAOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.fma"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, acc, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def acc(self):
    return self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class FlatTransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.flat_transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, matrix, rows, columns, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(matrix))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rows"] = (rows if (
    issubclass(type(rows), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rows, context=_ods_context))
    attributes["columns"] = (columns if (
    issubclass(type(columns), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(columns, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def matrix(self):
    return self.operation.operands[0]

  @builtins.property
  def rows(self):
    return self.operation.attributes["rows"]

  @rows.setter
  def rows(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rows"] = value

  @builtins.property
  def columns(self):
    return self.operation.attributes["columns"]

  @columns.setter
  def columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["columns"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class GatherOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, index_vec, mask, pass_thru, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(index_vec))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(pass_thru))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def index_vec(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def pass_thru(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class InsertElementOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.insertelement"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, *, position=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    if position is not None: operands.append(_get_op_result_or_value(position))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def position(self):
    return None if len(self.operation.operands) < 3 else self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class InsertOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.insert"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, dynamic_position, static_position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    operands.extend(_get_op_results_or_values(dynamic_position))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_position"] = (static_position if (
    issubclass(type(static_position), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_position, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def dynamic_position(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def static_position(self):
    return self.operation.attributes["static_position"]

  @static_position.setter
  def static_position(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_position"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class InsertStridedSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.insert_strided_slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, offsets, strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["offsets"] = (offsets if (
    issubclass(type(offsets), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(offsets, context=_ods_context))
    attributes["strides"] = (strides if (
    issubclass(type(strides), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(strides, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def offsets(self):
    return self.operation.attributes["offsets"]

  @offsets.setter
  def offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["offsets"] = value

  @builtins.property
  def strides(self):
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MaskOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.mask"

  _ODS_REGIONS = (1, True)

  @builtins.property
  def mask(self):
    return self.operation.operands[0]

  @builtins.property
  def passthru(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def maskRegion(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MaskedLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.maskedload"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, mask, pass_thru, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(pass_thru))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def pass_thru(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MaskedStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.maskedstore"

  _ODS_REGIONS = (0, True)

  def __init__(self, base, indices, mask, valueToStore, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(valueToStore))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def valueToStore(self):
    _ods_variadic_group_length = len(self.operation.operands) - 4 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.matrix_multiply"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, lhs_rows, lhs_columns, rhs_columns, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["lhs_rows"] = (lhs_rows if (
    issubclass(type(lhs_rows), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(lhs_rows, context=_ods_context))
    attributes["lhs_columns"] = (lhs_columns if (
    issubclass(type(lhs_columns), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(lhs_columns, context=_ods_context))
    attributes["rhs_columns"] = (rhs_columns if (
    issubclass(type(rhs_columns), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rhs_columns, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def lhs_rows(self):
    return self.operation.attributes["lhs_rows"]

  @lhs_rows.setter
  def lhs_rows(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lhs_rows"] = value

  @builtins.property
  def lhs_columns(self):
    return self.operation.attributes["lhs_columns"]

  @lhs_columns.setter
  def lhs_columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lhs_columns"] = value

  @builtins.property
  def rhs_columns(self):
    return self.operation.attributes["rhs_columns"]

  @rhs_columns.setter
  def rhs_columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rhs_columns"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MultiDimReductionOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.multi_reduction"

  _ODS_REGIONS = (0, True)

  def __init__(self, kind, source, acc, reduction_dims, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    issubclass(type(kind), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
      _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    attributes["reduction_dims"] = (reduction_dims if (
    issubclass(type(reduction_dims), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(reduction_dims, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def acc(self):
    return self.operation.operands[1]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def reduction_dims(self):
    return self.operation.attributes["reduction_dims"]

  @reduction_dims.setter
  def reduction_dims(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reduction_dims"] = value

  @builtins.property
  def dest(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class OuterProductOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.outerproduct"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, acc=None, kind=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    if acc is not None: operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    if kind is not None: attributes["kind"] = (kind if (
        issubclass(type(kind), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
          _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def acc(self):
    return None if len(self.operation.operands) < 3 else self.operation.operands[2]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class PrintOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.print"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, source=None, punctuation=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if source is not None: operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    if punctuation is not None: attributes["punctuation"] = (punctuation if (
        issubclass(type(punctuation), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Vector_PrintPunctuation')) else
          _ods_ir.AttrBuilder.get('Vector_PrintPunctuation')(punctuation, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def punctuation(self):
    return self.operation.attributes["punctuation"]

  @punctuation.setter
  def punctuation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["punctuation"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReductionOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.reduction"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, kind, vector, *, acc=None, fastmath=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    if acc is not None: operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    issubclass(type(kind), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
      _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        issubclass(type(fastmath), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    results.append(dest)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def acc(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def fastmath(self):
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def dest(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.reshape"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, vector, input_shape, output_shape, fixed_vector_sizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.append(_get_op_results_or_values(input_shape))
    operands.append(_get_op_results_or_values(output_shape))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["fixed_vector_sizes"] = (fixed_vector_sizes if (
    issubclass(type(fixed_vector_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(fixed_vector_sizes, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def input_shape(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def output_shape(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def fixed_vector_sizes(self):
    return self.operation.attributes["fixed_vector_sizes"]

  @fixed_vector_sizes.setter
  def fixed_vector_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fixed_vector_sizes"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ScalableExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.scalable.extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, source, pos, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pos"] = (pos if (
    issubclass(type(pos), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(pos, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def pos(self):
    return self.operation.attributes["pos"]

  @pos.setter
  def pos(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pos"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ScalableInsertOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.scalable.insert"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, pos, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pos"] = (pos if (
    issubclass(type(pos), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(pos, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def pos(self):
    return self.operation.attributes["pos"]

  @pos.setter
  def pos(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pos"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ScanOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.scan"

  _ODS_REGIONS = (0, True)

  def __init__(self, kind, source, initial_value, reduction_dim, inclusive, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(initial_value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    issubclass(type(kind), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Vector_CombiningKindAttr')) else
      _ods_ir.AttrBuilder.get('Vector_CombiningKindAttr')(kind, context=_ods_context))
    attributes["reduction_dim"] = (reduction_dim if (
    issubclass(type(reduction_dim), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(reduction_dim, context=_ods_context))
    attributes["inclusive"] = (inclusive if (
    issubclass(type(inclusive), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(inclusive, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def initial_value(self):
    return self.operation.operands[1]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def reduction_dim(self):
    return self.operation.attributes["reduction_dim"]

  @reduction_dim.setter
  def reduction_dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reduction_dim"] = value

  @builtins.property
  def inclusive(self):
    return self.operation.attributes["inclusive"]

  @inclusive.setter
  def inclusive(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["inclusive"] = value

  @builtins.property
  def dest(self):
    return self.operation.results[0]

  @builtins.property
  def accumulated_value(self):
    return self.operation.results[1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ScatterOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.scatter"

  _ODS_REGIONS = (0, True)

  def __init__(self, base, indices, index_vec, mask, valueToStore, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(index_vec))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(valueToStore))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def index_vec(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def mask(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[3 + _ods_variadic_group_length - 1]

  @builtins.property
  def valueToStore(self):
    _ods_variadic_group_length = len(self.operation.operands) - 5 + 1
    return self.operation.operands[4 + _ods_variadic_group_length - 1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ShapeCastOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.shape_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ShuffleOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.shuffle"

  _ODS_REGIONS = (0, True)

  def __init__(self, v1, v2, mask, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(v1))
    operands.append(_get_op_result_or_value(v2))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["mask"] = (mask if (
    issubclass(type(mask), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(mask, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def v1(self):
    return self.operation.operands[0]

  @builtins.property
  def v2(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.attributes["mask"]

  @mask.setter
  def mask(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mask"] = value

  @builtins.property
  def vector(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SplatOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.splat"

  _ODS_REGIONS = (0, True)

  def __init__(self, aggregate, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(aggregate)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def aggregate(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(valueToStore))
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def valueToStore(self):
    return self.operation.operands[0]

  @builtins.property
  def base(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TransferReadOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.transfer_read"

  _ODS_OPERAND_SEGMENTS = [1,-1,1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, source, indices, permutation_map, padding, *, mask=None, in_bounds=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(padding))
    operands.append(_get_op_result_or_value(mask) if mask is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation_map"] = (permutation_map if (
    issubclass(type(permutation_map), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AffineMapAttr')) else
      _ods_ir.AttrBuilder.get('AffineMapAttr')(permutation_map, context=_ods_context))
    if in_bounds is not None: attributes["in_bounds"] = (in_bounds if (
        issubclass(type(in_bounds), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('BoolArrayAttr')(in_bounds, context=_ods_context))
    results.append(vector)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def indices(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def padding(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def mask(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def permutation_map(self):
    return self.operation.attributes["permutation_map"]

  @permutation_map.setter
  def permutation_map(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation_map"] = value

  @builtins.property
  def in_bounds(self):
    if "in_bounds" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_bounds"]

  @in_bounds.setter
  def in_bounds(self, value):
    if value is not None:
      self.operation.attributes["in_bounds"] = value
    elif "in_bounds" in self.operation.attributes:
      del self.operation.attributes["in_bounds"]

  @in_bounds.deleter
  def in_bounds(self):
    del self.operation.attributes["in_bounds"]

  @builtins.property
  def vector(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TransferWriteOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.transfer_write"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, vector, source, indices, permutation_map, *, mask=None, in_bounds=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask) if mask is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation_map"] = (permutation_map if (
    issubclass(type(permutation_map), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AffineMapAttr')) else
      _ods_ir.AttrBuilder.get('AffineMapAttr')(permutation_map, context=_ods_context))
    if in_bounds is not None: attributes["in_bounds"] = (in_bounds if (
        issubclass(type(in_bounds), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolArrayAttr')) else
          _ods_ir.AttrBuilder.get('BoolArrayAttr')(in_bounds, context=_ods_context))
    if result is not None: results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def indices(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def mask(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def permutation_map(self):
    return self.operation.attributes["permutation_map"]

  @permutation_map.setter
  def permutation_map(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation_map"] = value

  @builtins.property
  def in_bounds(self):
    if "in_bounds" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_bounds"]

  @in_bounds.setter
  def in_bounds(self, value):
    if value is not None:
      self.operation.attributes["in_bounds"] = value
    elif "in_bounds" in self.operation.attributes:
      del self.operation.attributes["in_bounds"]

  @in_bounds.deleter
  def in_bounds(self):
    del self.operation.attributes["in_bounds"]

  @builtins.property
  def result(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, vector, transp, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["transp"] = (transp if (
    issubclass(type(transp), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64ArrayAttr')(transp, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def transp(self):
    return self.operation.attributes["transp"]

  @transp.setter
  def transp(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["transp"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TypeCastOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.type_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, memref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(memref))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class WarpExecuteOnLane0Op(_ods_ir.OpView):
  OPERATION_NAME = "vector.warp_execute_on_lane_0"

  _ODS_REGIONS = (1, True)

  @builtins.property
  def laneid(self):
    return self.operation.operands[0]

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def warp_size(self):
    return self.operation.attributes["warp_size"]

  @warp_size.setter
  def warp_size(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["warp_size"] = value

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def warpRegion(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "vector.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]
