# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.bad_request_error import BadRequestError
from ...errors.conflict_error import ConflictError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.api_error_response import ApiErrorResponse
from ...types.batch_response import BatchResponse
from ...types.boolean_string import BooleanString
from ...types.business import Business
from ...types.business_user_event import BusinessUserEvent
from ...types.consumer_user_event import ConsumerUserEvent
from ...types.transaction import Transaction
from ...types.transaction_event import TransactionEvent
from ...types.user import User

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BatchClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def verify_transaction(
        self,
        *,
        validate_origin_user_id: typing.Optional[BooleanString] = None,
        validate_destination_user_id: typing.Optional[BooleanString] = None,
        batch_id: typing.Optional[str] = OMIT,
        data: typing.List[Transaction],
    ) -> BatchResponse:
        """
        Parameters:
            - validate_origin_user_id: typing.Optional[BooleanString]. Boolean string whether Flagright should validate if provided originUserId exist. True by default

            - validate_destination_user_id: typing.Optional[BooleanString]. Boolean string whether Flagright should validate if provided destinationUserId exist. True by default

            - batch_id: typing.Optional[str].

            - data: typing.List[Transaction].
        ---
        from flagright import Transaction, TransactionType
        from flagright.client import Flagright

        client = Flagright(
            api_key="YOUR_API_KEY",
        )
        client.batch.verify_transaction(
            data=[
                Transaction(
                    type=TransactionType.DEPOSIT,
                    transaction_id="transactionId",
                    timestamp=1.1,
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/transactions"),
            params=remove_none_from_dict(
                {
                    "validateOriginUserId": validate_origin_user_id,
                    "validateDestinationUserId": validate_destination_user_id,
                }
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_transaction_events(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[TransactionEvent]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[TransactionEvent].
        ---
        from flagright import TransactionEvent, TransactionState
        from flagright.client import Flagright

        client = Flagright(
            api_key="YOUR_API_KEY",
        )
        client.batch.create_transaction_events(
            data=[
                TransactionEvent(
                    transaction_state=TransactionState.CREATED,
                    timestamp=1.1,
                    transaction_id="transactionId",
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/events/transaction"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 409:
            raise ConflictError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_consumer_users(self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[User]) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[User].
        ---
        from flagright import User
        from flagright.client import Flagright

        client = Flagright(
            api_key="YOUR_API_KEY",
        )
        client.batch.create_consumer_users(
            data=[
                User(
                    user_id="userId",
                    created_timestamp=1.1,
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/consumer/users"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_business_users(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[Business]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[Business].
        ---
        from flagright import Business, CompanyGeneralDetails, LegalEntity
        from flagright.client import Flagright

        client = Flagright(
            api_key="YOUR_API_KEY",
        )
        client.batch.create_business_users(
            data=[
                Business(
                    user_id="userId",
                    created_timestamp=1.1,
                    legal_entity=LegalEntity(
                        company_general_details=CompanyGeneralDetails(
                            legal_name="Ozkan Hazelnut Export JSC",
                            business_industry=["Farming"],
                            main_products_services_sold=["Hazelnut"],
                        ),
                    ),
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/business/users"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_consumer_user_events(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[ConsumerUserEvent]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[ConsumerUserEvent].
        ---
        from flagright import ConsumerUserEvent
        from flagright.client import Flagright

        client = Flagright(
            api_key="YOUR_API_KEY",
        )
        client.batch.create_consumer_user_events(
            data=[
                ConsumerUserEvent(
                    timestamp=1.1,
                    user_id="userId",
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/events/consumer/user"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_business_user_events(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[BusinessUserEvent]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[BusinessUserEvent].
        ---
        from flagright import BusinessUserEvent
        from flagright.client import Flagright

        client = Flagright(
            api_key="YOUR_API_KEY",
        )
        client.batch.create_business_user_events(
            data=[
                BusinessUserEvent(
                    timestamp=1.1,
                    user_id="userId",
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/events/business/user"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncBatchClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def verify_transaction(
        self,
        *,
        validate_origin_user_id: typing.Optional[BooleanString] = None,
        validate_destination_user_id: typing.Optional[BooleanString] = None,
        batch_id: typing.Optional[str] = OMIT,
        data: typing.List[Transaction],
    ) -> BatchResponse:
        """
        Parameters:
            - validate_origin_user_id: typing.Optional[BooleanString]. Boolean string whether Flagright should validate if provided originUserId exist. True by default

            - validate_destination_user_id: typing.Optional[BooleanString]. Boolean string whether Flagright should validate if provided destinationUserId exist. True by default

            - batch_id: typing.Optional[str].

            - data: typing.List[Transaction].
        ---
        from flagright import Transaction, TransactionType
        from flagright.client import AsyncFlagright

        client = AsyncFlagright(
            api_key="YOUR_API_KEY",
        )
        await client.batch.verify_transaction(
            data=[
                Transaction(
                    type=TransactionType.DEPOSIT,
                    transaction_id="transactionId",
                    timestamp=1.1,
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/transactions"),
            params=remove_none_from_dict(
                {
                    "validateOriginUserId": validate_origin_user_id,
                    "validateDestinationUserId": validate_destination_user_id,
                }
            ),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_transaction_events(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[TransactionEvent]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[TransactionEvent].
        ---
        from flagright import TransactionEvent, TransactionState
        from flagright.client import AsyncFlagright

        client = AsyncFlagright(
            api_key="YOUR_API_KEY",
        )
        await client.batch.create_transaction_events(
            data=[
                TransactionEvent(
                    transaction_state=TransactionState.CREATED,
                    timestamp=1.1,
                    transaction_id="transactionId",
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/events/transaction"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 409:
            raise ConflictError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_consumer_users(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[User]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[User].
        ---
        from flagright import User
        from flagright.client import AsyncFlagright

        client = AsyncFlagright(
            api_key="YOUR_API_KEY",
        )
        await client.batch.create_consumer_users(
            data=[
                User(
                    user_id="userId",
                    created_timestamp=1.1,
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/consumer/users"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_business_users(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[Business]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[Business].
        ---
        from flagright import Business, CompanyGeneralDetails, LegalEntity
        from flagright.client import AsyncFlagright

        client = AsyncFlagright(
            api_key="YOUR_API_KEY",
        )
        await client.batch.create_business_users(
            data=[
                Business(
                    user_id="userId",
                    created_timestamp=1.1,
                    legal_entity=LegalEntity(
                        company_general_details=CompanyGeneralDetails(
                            legal_name="Ozkan Hazelnut Export JSC",
                            business_industry=["Farming"],
                            main_products_services_sold=["Hazelnut"],
                        ),
                    ),
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/business/users"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_consumer_user_events(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[ConsumerUserEvent]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[ConsumerUserEvent].
        ---
        from flagright import ConsumerUserEvent
        from flagright.client import AsyncFlagright

        client = AsyncFlagright(
            api_key="YOUR_API_KEY",
        )
        await client.batch.create_consumer_user_events(
            data=[
                ConsumerUserEvent(
                    timestamp=1.1,
                    user_id="userId",
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/events/consumer/user"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_business_user_events(
        self, *, batch_id: typing.Optional[str] = OMIT, data: typing.List[BusinessUserEvent]
    ) -> BatchResponse:
        """
        Parameters:
            - batch_id: typing.Optional[str].

            - data: typing.List[BusinessUserEvent].
        ---
        from flagright import BusinessUserEvent
        from flagright.client import AsyncFlagright

        client = AsyncFlagright(
            api_key="YOUR_API_KEY",
        )
        await client.batch.create_business_user_events(
            data=[
                BusinessUserEvent(
                    timestamp=1.1,
                    user_id="userId",
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"data": data}
        if batch_id is not OMIT:
            _request["batchId"] = batch_id
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "batch/events/business/user"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BatchResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 429:
            raise TooManyRequestsError(pydantic.parse_obj_as(ApiErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
