# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .address import Address
from .amount import Amount
from .email_id import EmailId
from .tag import Tag

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AchDetails(pydantic.BaseModel):
    """
    Model for ACH payment method
    """

    routing_number: typing.Optional[str] = pydantic.Field(
        alias="routingNumber", description="Routing number of the bank"
    )
    account_number: typing.Optional[str] = pydantic.Field(
        alias="accountNumber", description="Bank account number of the individual"
    )
    account_balance: typing.Optional[Amount] = pydantic.Field(alias="accountBalance")
    bank_name: typing.Optional[str] = pydantic.Field(alias="bankName", description="Name of the bank")
    name: typing.Optional[str] = pydantic.Field(description="Name of the account holder")
    bank_address: typing.Optional[Address] = pydantic.Field(alias="bankAddress")
    beneficiary_name: typing.Optional[str] = pydantic.Field(
        alias="beneficiaryName", description="Beneficiary name of the account"
    )
    email_id: typing.Optional[EmailId] = pydantic.Field(alias="emailId")
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
