# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .business_user_segment import BusinessUserSegment
from .tag import Tag
from .user_registration_status import UserRegistrationStatus

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CompanyGeneralDetails(pydantic.BaseModel):
    """
    Model for business user company general details
    """

    legal_name: typing.Optional[str] = pydantic.Field(alias="legalName", description="Legal name of the company")
    business_industry: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="businessIndustry", description="The industry in which the business operates for a business customer"
    )
    main_products_services_sold: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="mainProductsServicesSold", description="The key products and services provided by the company"
    )
    user_segment: typing.Optional[BusinessUserSegment] = pydantic.Field(
        alias="userSegment", description="Segmentation of the business user"
    )
    user_registration_status: typing.Optional[UserRegistrationStatus] = pydantic.Field(alias="userRegistrationStatus")
    alias: typing.Optional[typing.List[str]] = pydantic.Field(description="Alias names of the business entity")
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
