# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .company_financial_details import CompanyFinancialDetails
from .company_general_details import CompanyGeneralDetails
from .company_registration_details import CompanyRegistrationDetails
from .contact_details import ContactDetails
from .source_of_funds import SourceOfFunds

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class LegalEntity(pydantic.BaseModel):
    """
    Model for business user legal entity details
    """

    company_general_details: CompanyGeneralDetails = pydantic.Field(alias="companyGeneralDetails")
    company_financial_details: typing.Optional[CompanyFinancialDetails] = pydantic.Field(
        alias="companyFinancialDetails"
    )
    company_registration_details: typing.Optional[CompanyRegistrationDetails] = pydantic.Field(
        alias="companyRegistrationDetails"
    )
    reason_for_account_opening: typing.Optional[typing.List[str]] = pydantic.Field(alias="reasonForAccountOpening")
    source_of_funds: typing.Optional[typing.List[SourceOfFunds]] = pydantic.Field(alias="sourceOfFunds")
    contact_details: typing.Optional[ContactDetails] = pydantic.Field(alias="contactDetails")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
