# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .file_info import FileInfo

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PersonAttachment(pydantic.BaseModel):
    """
    PersonAttachment model generalizes User's uploaded attachments
    """

    id: typing.Optional[str]
    comment: typing.Optional[str] = pydantic.Field(description="User's comment on the attached file.")
    files: typing.List[FileInfo]
    user_id: str = pydantic.Field(alias="userId")
    created_at: typing.Optional[float] = pydantic.Field(alias="createdAt")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
