import random
import time
from enos.core.MqttClient import MqttClient
from enos.core.internal.Profile import Profile
from enos.core.message.IResponseCallback import IResponseCallback
from enos.message.upstream.integration.IntAttributePostRequest import IntAttributePostRequest
from enos.message.upstream.integration.IntEventPostRequest import IntEventPostRequest
from enos.message.upstream.integration.IntMeaturepointPostRequest import IntMeaturepointPostRequest
from enos.sample.SampleHelper import SampleHelper


class ResponseCallback(IResponseCallback):

    def on_response(self, response):
        print('[async] receive {} successfully, code: {}'.format(response.get_class(), str(response.get_code())))
        if not response.is_success():
            print('[async] error message: {}'.format(response.get_message()))

    def on_failure(self, exception):
        print('[async] publish failed, exception: {}'.format(exception))


def int_measure_point_post():
    int_measure_points_request = IntMeaturepointPostRequest.builder() \
        .add_meaturepoint(SampleHelper.GW_DEVICE_KEY, int(time.time() * 1000), {'wwww0001': random.randint(100, 200)}) \
        .build()

    int_measure_points_response = client.publish(int_measure_points_request)
    if int_measure_points_response.is_success():
        print('[sync] receive {} successfully, code: {}'.format(int_measure_points_response.get_class(),
                                                                str(int_measure_points_response.get_code())))

    client.publish(int_measure_points_request, ResponseCallback())


def int_event_post():
    int_event_request = IntEventPostRequest.builder() \
        .add_event(SampleHelper.GW_DEVICE_KEY, int(time.time() * 1000), "highTemp", SampleHelper.EVENT_DICT) \
        .build()

    int_event_response = client.publish(int_event_request)
    if int_event_response.is_success():
        print('[sync] receive {} successfully, code: {}'.format(int_event_response.get_class(),
                                                                str(int_event_response.get_code())))

    client.publish(int_event_request, ResponseCallback())


def int_attribute_post():
    int_attribute_request = IntAttributePostRequest.builder() \
        .add_attribute(SampleHelper.GW_DEVICE_KEY, 'aaaa43141', random.randint(1, 100)) \
        .add_attribute(SampleHelper.GW_DEVICE_KEY, 'string_measure', 'enos') \
        .build()

    int_attribute_response = client.publish(int_attribute_request)
    if int_attribute_response.is_success():
        print('[sync] receive {} successfully, code: {}'.format(int_attribute_response.get_class(),
                                                                str(int_attribute_response.get_code())))

    client.publish(int_attribute_request, ResponseCallback())


if __name__ == "__main__":

    integration_profile = Profile.create_instance(SampleHelper.get_message_integration_login())

    client = MqttClient(profile=integration_profile)
    client.get_profile().set_auto_reconnect(True)
    client.setup_basic_logger('INFO')
    client.connect()

    while True:
        int_measure_point_post()
        int_event_post()
        int_attribute_post()

        time.sleep(10)
