import logging

from enos.core.MqttClient import MqttClient
from enos.core.message.IResponseCallback import IResponseCallback
from enos.message.downstream.tsl.MeasurepointSetCommand import MeasurepointSetCommand
from enos.message.downstream.tsl.MeasurepointSetReply import MeasurepointSetReply
from enos.message.upstream.status.SubDeviceLoginRequest import SubDeviceLoginRequest
import random
import time

# mqtt broker url
from enos.message.upstream.topo.SubDeviceInfo import SubDeviceInfo
from enos.message.upstream.topo.TopoAddRequest import TopoAddRequest
from enos.message.upstream.topo.TopoDeleteRequest import TopoDeleteRequest
from enos.message.upstream.topo.TopoGetRequest import TopoGetRequest
from enos.message.upstream.tsl.MeasurepointPostRequest import MeasurepointPostRequest

enos_mqtt_url_tcp = "tcp://xxx:11883"  # for tcp connection
enos_mqtt_url_ssl = "ssl://xxx:18883"  # for ssl connection

# gateway parameters
gateway_product_key = "gateway_product_key"
gateway_product_secret = 'gateway_product_secret'
gateway_device_key = "gateway_device_key"
gateway_device_secret = "gateway_device_secret"

# sub-device parameters
sub_product_key = 'sub_product_key'
sub_device_key = "sub_device_key"
sub_device_secret = "sub_device_secret"

# these file are generated by get_cert.py via EnOS cert tool, for tls connection
ca_file = 'edge_ca.pem'
key_file = 'edge.key'
cer_file = 'edge.pem'
key_file_password = 'PRIVATE_KEY_PASSWORD'


def on_connect():
    """ Called when the connection to the server is completed."""
    print('connect success')
    login_sub_device()  # login the sub-device if exists sub-device


def on_disconnect():
    """ Called when the client connection lost."""
    print('connect lost')


def on_connect_failed():
    """ Called when the client connect failed"""
    print('connect failed...')


def command_handler(arrived_message, arg_list):
    """ message callback, handle the received downstream message and implement your logic

    :param arrived_message: the arrived msg instance , it may instanceof class <BaseCommand> or <BaseResponse>
    :param arg_list: the topic args extract from the arrived topic , including productKey , deviceKey ,etc
    :return: the msg you want to reply to the cloud , if you do NOT want send msg , just return None
    """
    print('receive measurepoint set command, params: {}'.format(arrived_message.get_params()))

    print('product key = {}, device key= {}'.format(arg_list[0], arg_list[1]))

    return MeasurepointSetReply().builder().set_code(200).set_message('measurepoints set success').build()


def on_response(response):
    print('[async] measurepoint post response code: {}'.format(str(response.get_code())))
    if not response.is_success():
        print('[async] error message: {}'.format(response.get_message()))


def on_failure(exception):
    print('[async] publish failed, exception: {}'.format(exception))


# post measure points data via MQTT
def post_measure_points():
    measure_point_request = MeasurepointPostRequest.builder() \
        .add_measurepoint('measurepoint', random.randint(100, 200)) \
        .set_timestamp(int(time.time())) \
        .build()

    measure_point_response = client.publish(measure_point_request)
    if measure_point_response:
        print('[sync] measurepoint post response code: {}'.format(measure_point_response.get_code()))


def post_measure_points_async():
    measure_point_request = MeasurepointPostRequest.builder() \
        .add_measurepoint('measurepoint', random.randint(100, 200)) \
        .set_timestamp(int(time.time())) \
        .build()

    # publish async with callback
    response_callback = IResponseCallback()
    response_callback.on_response = on_response
    response_callback.on_failure = on_failure
    client.publish(measure_point_request, response_callback)


def get_topo():
    topo_get_request = TopoGetRequest.builder().build()
    topo_get_response = client.publish(topo_get_request)
    if topo_get_response:
        print('topo get response: code: %s' % topo_get_response.get_code())


def add_topo():
    topo_add_request = TopoAddRequest.builder().addSubDevice(
        SubDeviceInfo(sub_product_key, sub_device_key, sub_device_secret)).build()
    topo_add_response = client.publish(topo_add_request)
    if topo_add_response:
        print('topo add response: code: %s' % topo_add_response.get_code())
        print('topo add response: message: %s' % topo_add_response.get_message())


def delete_topo():
    topo_del_request = TopoDeleteRequest.builder().addSubDevice(sub_product_key, sub_device_key).build()
    topo_del_response = client.publish(topo_del_request)
    if topo_del_response:
        print('topo delete response: %s' % topo_del_response.get_code())


def login_sub_device():
    login_request = SubDeviceLoginRequest.builder().set_sub_device_info(sub_product_key, sub_device_key,
                                                                        sub_device_secret).build()
    login_response = client.publish(login_request)
    if login_response:
        print('sub device login response: code: %s' % login_response.get_code())


if __name__ == "__main__":
    client = MqttClient(enos_mqtt_url_ssl, gateway_product_key, gateway_device_key, gateway_device_secret)

    # if connection interrupted, the client can automatically reconnect
    client.get_profile().set_auto_reconnect(True)

    # set the certificate files for bi-directional certification
    client.get_profile().set_ssl_context(ca_file, cer_file, key_file, key_file_password)

    # set basic logger level
    client.setup_basic_logger(logging.INFO)

    # register connection callback
    client.on_connect = on_connect
    client.on_disconnect = on_disconnect
    client.on_connected_failed = on_connect_failed

    # register a msg handler to handle the downstream measurepoint set command
    client.register_arrived_message_handler(MeasurepointSetCommand.get_class(), command_handler)

    # connect in sync and check connection state
    client.connect()

    get_topo()  # get topo of gateway

    # add_topo()  # add the device to the gateway as sub-device

    while True:
        # publish measure points data
        post_measure_points()
        post_measure_points_async()
        time.sleep(5)
