Github Actions status:
[![Test and coverage](https://github.com/saullocastro/compmech/actions/workflows/pytest_and_coverage.yml/badge.svg)](https://github.com/saullocastro/compmech/actions/workflows/pytest_and_coverage.yml)
[![Release](https://github.com/saullocastro/compmech/actions/workflows/auto_release.yml/badge.svg)](https://github.com/saullocastro/compmech/actions/workflows/auto_release.yml)
[![Documentation](https://github.com/saullocastro/compmech/actions/workflows/auto_doc.yml/badge.svg)](https://github.com/saullocastro/compmech/actions/workflows/auto_doc.yml)
[![Deploy](https://github.com/saullocastro/compmech/actions/workflows/pythonpublish.yml/badge.svg)](https://github.com/saullocastro/compmech/actions/workflows/pythonpublish.yml)

Coverage status:
[![codecov](https://codecov.io/gh/saullocastro/compmech/branch/master/graph/badge.svg?token=12LJVZAYTL)](https://codecov.io/gh/saullocastro/compmech)


Computational Mechanics (compmech)
==================================

Semi-analytical models for thin-walled structures.

The models herein presented are described in detail in the following
publications:

Castro SPG, Mittelstedt C, Monteiro FAC, Arbelo MA, Ziegmann G, Degenhardt R.
Linear buckling predictions of unstiffened laminated composite cylinders and
cones under various loading and boundary conditions using semi-analytical
models. Composite Structures, Vol. 118, Pages 303-315, December 2014.
https://doi.org/10.1016/j.compstruct.2014.07.037

Castro SGP, Mittelstedt C, Monteiro FAC, Arbelo MA, Degenhardt R, Ziegmann G. A
semi-analytical approach for linear and non-linear analysis of unstiffened
laminated composite cylinders and cones under axial, torsion and pressure
loads. Thin-Walled Structures, Vol. 90, Pages 61-73, May, 2015.
https://doi.org/10.1016/j.tws.2015.01.002

Castro SGP, Mittelstedt C, Monteiro FAC, Degenhardt R, Ziegmann G. Evaluation
of non-linear buckling loads of geometrically imperfect composite cylinders and
cones with the Ritz method. Composite Structures, Vol. 122, Pages 284-299,
April, 2015. https://doi.org/10.1016/j.compstruct.2014.11.050

Castro SGP, Donadon MV. Assembly of Semi-Analytical models to Address Linear
Buckling and Vibration of Stiffened Composite Panels with Debonding Defect.
Composite Structures, Vol. 160, Pages 232–247, January, 2017.
https://doi.org/10.1016/j.compstruct.2016.10.026


Documentation
-------------

The documentation is available on: http://saullocastro.github.io/compmech/


Requirements
------------
- numpy
- scipy
- matplotlib
- (for building only) Cython and a C compiler


License
-------
Distrubuted under the 3-Clause BSD license
(https://raw.github.com/saullocastro/composites/master/LICENSE).

Contact: S.G.P.Castro@tudelft.nl
