# see Abaqus Scripting User's Reference Manual Section 28.45.1
#laminaProp = ( e11, e22, nu12, g12, g13, g23, tempref ) for LAMINA
#laminaProp = ( e, nu, tempref ) for ISOTROPIC
"""
This database is a group of three dictionaries defines as following:

- ``laminaprops``: the material properties for an orthotropic lamina
- ``allowables``: the allowables for an orthotropic lamina
- ``ccs``: the geometric, stacking sequence and material data for a conical /
  cylindrical structure

One could import these dictionaries doing::

    from compmech.conecyl.conecylDB import laminaprops, allowables, ccs


"""
laminaprops = {
            'mat_huehne_2008':
                (125.774e3, 10.03e3, 0.271, 5.555e3, 5.555e3, 3.4e3, 273.15),
            'degenhardt_2010_IM78552_cocomat':
                (142.5e3, 8.7e3, 0.28, 5.1e3, 5.1e3, 5.1e3, 273.15),
            'degenhardt_2010_IM78552_isa':
                (157.4e3, 8.6e3, 0.28, 5.3e3, 5.3e3, 5.3e3, 273.15),
            'degenhardt_2010_IM78552_posicoss':
                (146.5e3, 9.7e3, 0.31, 6.1e3, 6.1e3, 6.1e3, 273.15),
            'M40J/977-2':
                (142.5e3, 8.7e3, 0.28, 5.1e3, 5.1e3, 5.1e3, 273.15),
            'geier_1991':
                (124.446e3, 8.771e3, 0.319, 2.802e3, 2.802e3, 2.802e3, 273.15),
            'geier_1997':
                (123.55e3, 8.708e3, 0.319, 5.695e3, 5.695e3, 3.4e3, 273.15),
            'geier_2002':
                (123.55e3, 8.708e3, 0.319, 5.695e3, 5.695e3, 5.695e3, 273.15),
            'meyer_piening_2001':
                (123.55e3, 8.7079e3, 0.31946, 5.695e3, 5.695e3, 5.695e3, 273.15),
            'chung_2001':
                (206.842719e3, 5.17107e3, 0.3, 1.9822435e3, 1.9822435e3, 1.9822435e3, 273.15),
            'chung_2001_e10':
                (206.842719e3, 206.842719e3, 0.3, 79.28971e3, 79.28971e3, 79.28971e3, 273.15),
            'shadmehri_2012':
                (210.2901e3, 5.2572525e3, 0.25, 3.1542515e3, 2.62862625e3, 2.62862625e3, 273.15),
            'hilburger_2014_AlLi':
                (71.e3, 71.e3, 0.3),
            'li_and_lin_2010_table_2':
                (149.66e3, 9.93e3, 0.28, 4.48e3, 4.48e3, 4.48e3, 273.15),
            'li_and_lin_2010_table_4':
                (45.6e3, 16.2e3, 0.278, 5.83e3, 5.83e3, 5.78e3, 273.15),
            }
#allowables = (s11t, s11c, s22t, s22c, s12, s13)
allowables = {
    'degenhardt_2010_IM78552_cocomat': (1741.,-855. ,29.,-283.,98.,90.),
    'degenhardt_2010_IM78552_isa'    : (2440.,-1332.,42.,-269.,129.,129.),
            }

# NOTE - stack is from inwards to outwards
ccs = {
    'huehne_2002_z26': {
        'r1': (250.+2*0.125),
        'H': 510.,
        'numel_r': 180,
        'elem_type': 'S4R',
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'stack': [+24,-24,+41,-41],
        'axial_displ': 1.,
        'ploads': [1, 2, 3, 4, 5, 10],
        },
    'huehne_2002_z27': {
        'r1': (250.+2*0.125),
        'H': 510.,
        'numel_r': 180,
        'elem_type': 'S4R',
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'stack': [+75,-75,+75,-75],
        'axial_displ': 1.,
        'ploads': [1, 2, 3, 4, 5, 10],
        },
    'huehne_2002_z14': {
        'r1': (250.+3*0.125),
        'H': 510.,
        'numel_r': 180,
        'elem_type': 'S4R',
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'stack': [+51,-51,90,90,+40,-40],
        'axial_displ': 1.,
        'ploads': [1, 2, 3, 4, 5, 10,20,30],
        },
    'huehne_2002_z22': {
        'r1': (250.+3*0.125),
        'H': 510.,
        'numel_r': 180,
        'elem_type': 'S4R',
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'stack': [+49,-49,+36,-36,0.,0.],
        'axial_displ': 1.,
        'ploads': [1, 2, 3, 4, 5, 10,20,30],
        },
    'huehne_2002_z23': {
        'r1': (250.+5*0.125),
        'H': 510.,
        'numel_r': 180,
        'elem_type': 'S4R',
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'stack': [+60,-60,0,0,+68,-68,+52,-52,+37,-37],
        'axial_displ': 1.,
        'ploads': [1, 10, 20, 30, 40, 50, 70, 90],
        },
    # laminate minimum of classical buckling load
    'huehne_2002_z24': {
        'r1': (250.+5*0.125),
        'H': 510.,
        'numel_r': 180,
        'elem_type': 'S4R',
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'stack': [-51., 51., -45., 45., -37., 37., -19., 19., 0., 0.],
        'axial_displ': 1.,
        'ploads': [1, 10, 20, 30, 40, 50, 70, 90],
        },
    # laminate maximum of classical buckling load
    'huehne_2002_z30': {
        'r1': (250.+5*0.125),
        'H': 510.,
        'numel_r': 180,
        'elem_type': 'S4R',
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'stack': [30., -30., 90., 90., 22., -22., 38., -38., 53., -53. ],
        'axial_displ': 1.,
        'ploads': [1, 10, 20, 30, 40, 50, 70, 90],
        },
    # laminate far from minimum and maximum classical buckling load
    'huehne_2002_z33': {
        'r1': (250.+5*0.125),
        'H': 510.,
        'numel_r': 180,
        'elem_type':'S4R',
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'stack': [0, 0, 19, -19, 37, -37, 45, -45, 51, -51],
        'axial_displ': 1.,
        'ploads': [1, 10, 20, 30, 40, 50, 70, 90],
        },
    'huehne_2008_z07': {
        'r1': 250.,
        'H': 510.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.125,
        'laminapropKey': 'mat_huehne_2008',
        'stack': [24., -24., 41., -41.],
        'axial_displ': 1.,
        'reflimitdisp': 0.24,
        'reflimitload': 16200.,
        'ploads': [1., 2., 3., 4., 5., 10.],
        },
    'degenhardt_2010_z15': {
        'imp_ms': 'degenhardt_2010_z15',
        'imp_thick': 'degenhardt_2010_z15',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.11575,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z17': {
        'imp_ms': 'degenhardt_2010_z17',
        'imp_thick': 'degenhardt_2010_z17',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.11525,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z18': {
        'imp_ms': 'degenhardt_2010_z18',
        'imp_thick': 'degenhardt_2010_z18',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.1195,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z20': {
        'imp_ms': 'degenhardt_2010_z20',
        'imp_thick': 'degenhardt_2010_z20',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.12225,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z21': {
        'imp_ms': 'degenhardt_2010_z21',
        'imp_thick': 'degenhardt_2010_z21',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.12125,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z22': {
        'imp_ms': 'degenhardt_2010_z22',
        'imp_thick': 'degenhardt_2010_z22',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.1215,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z23': {
        'imp_ms': 'degenhardt_2010_z23',
        'imp_thick': 'degenhardt_2010_z23',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.1195,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z24': {
        'imp_ms': 'degenhardt_2010_z24',
        'imp_thick': 'degenhardt_2010_z24',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.12375,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z25': {
        'imp_ms': 'degenhardt_2010_z25',
        'imp_thick': 'degenhardt_2010_z25',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.117,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'degenhardt_2010_z26': {
        'imp_ms': 'degenhardt_2010_z26',
        'imp_thick': 'degenhardt_2010_z26',
        'r1': 250.,
        'H': 500.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.1195,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [24,-24,41,-41],
        'axial_displ': 1.,
        'ploads': [1,2,3,4,5,10],
        },
    'zimmermann_1992_z32': {
        'r1': 250.,
        'H': 510.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [-51,51,-45,45,-37,37,-19,19,0,0],
        'axial_displ': 1.,
        'ploads': [1., 20., 30., 35., 50., 75],
        },
    'zimmermann_1992_z33': {
        'imp_ms': 'zimmermann_1992_z33',
        'r1': 250.,
        'H': 510.,
        'elem_type':'S4R',
        'numel_r': 240,
        'plyt':0.125,
        'laminapropKey': 'geier_2002',
        'allowablesKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [0,0,19,-19,37,-37,45,-45,51,-51],
        'axial_displ': 1.,
        'ploads': [1, 10, 20, 30, 40, 46.5, 70, 90],
        },
    'geier_1991_z11': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'geier_1991',
        'stack': [60, -60, 0, 0, 68, -68, 52, -52, 37, -37],
        },
    'geier_1991_z12': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'geier_1991',
        'stack': [51, -51, 45, -45, 37, -37, 19, -19, 0, 0],
        },
    'geier_1991_z14': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'geier_1991',
        'stack': [51, -51, 90, 90, 40, -40],
        },
    'geier_1991_z17': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'geier_1991',
        'stack': [30, -30, 90, 90, 22, -22, 38, -38, 53, -53],
        },
    'geier_1991_z18': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'geier_1991',
        'stack': [-37, 37, -52, 52, -68, 68, 0, 0, -60, 60],
        },
    'geier_1991_z21': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'geier_1991',
        'stack': [39, -39, 0, 0, 50, -50],
        },
    'geier_1991_z22': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'geier_1991',
        'stack': [49, -49, 36, -36, 0, 0],
        },
    'meyer_piening_2001_z11': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'meyer_piening_2001',
        'stack': [60, -60, 0, 0, 68, -68, 52, -52, 37, -37],
        },
    'meyer_piening_2001_z12': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'meyer_piening_2001',
        'stack': [51, -51, 45, -45, 37, -37, 19, -19, 0, 0],
        },
    'meyer_piening_2001_z17': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'meyer_piening_2001',
        'stack': [30, -30, 90, 90, 22, -22, 38, -38, 53, -53],
        },
    'meyer_piening_2001_z18': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'meyer_piening_2001',
        'stack': [-37, 37, -52, 52, -68, 68, 0, 0, -60, 60],
        },
    'meyer_piening_2001_z28': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'meyer_piening_2001',
        'stack': [38, -38, 68, -68, 90, 90, 8, -8, 53, -53],
        },
    'meyer_piening_2001_z33': {
        'elem_type':'S8R5',
        'numel_r': 140,
        'r1': 250.,
        'H': 510.,
        'plyt':0.125,
        'laminapropKey': 'meyer_piening_2001',
        'stack': [0, 0, 19, -19, 37, -37, 45, -45, 51, -51],
        },
    'chung_2001_fig5.25': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 30,
        'r2': 25.4 + 0.254/2,
        'L': 25.4,
        'plyt': 0.254,
        'laminapropKey': 'chung_2001',
        'stack': [0],
        },
    'chung_2001_fig5.26': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 30,
        'r2': 25.4 + 0.254/2,
        'L': 25.4,
        'plyt': 0.254,
        'laminapropKey': 'chung_2001',
        'stack': [0],
        },
    'chung_2001_e10': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 0,
        'r2': 25.4 + 0.254/2,
        'L': 25.4,
        'plyt': 0.254,
        'laminapropKey': 'chung_2001_e10',
        'stack': [0],
        },
    'shadmehri_2012_fig3': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 10,
        'r1': 254.,
        'H': 25.4,
        'plyt': 2.54/2,
        'laminapropKey': 'shadmehri_2012',
        'stack': [+45, -45],
        },
    'desicos_2014_z36': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'r1': 400.376,
        'H': 800.,
        'plyt':0.125,
        'laminapropKey': 'degenhardt_2010_IM78552_isa',
        'stack': [34, -34, 0, 0, 53, -53],
        'ploads': [1., 2., 3., 5., 10., 15., 20., 25.],
        },
    'desicos_2014_c01': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 35.,
        'r1': 400.,
        'H': 300.,
        'plyt':0.125,
        'laminapropKey': 'degenhardt_2010_IM78552_isa',
        'stack': [30, 0, -30, -30, 0, 30],
        },
    'desicos_2014_c02': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 35.,
        'r1': 400.,
        'H': 300.,
        'plyt':0.125,
        'laminapropKey': 'degenhardt_2010_IM78552_isa',
        'stack': [30, -30, 0, 0, 30, -30],
        },
    'desicos_2014_c03': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 35.,
        'r1': 400.,
        'H': 300.,
        'plyt':0.125,
        'laminapropKey': 'degenhardt_2010_IM78552_isa',
        'stack': [-30, 30, 0, 0, -30, 30],
        },
    'castro_2014_c01': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 30.,
        'r1': 400.,
        'H': 200.,
        'plyt':0.125,
        'laminapropKey': 'geier_1997',
        'stack': [+60, -60],
        },
    'castro_2014_c02': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 45.,
        'r1': 400.,
        'H': 200.,
        'plyt':0.125,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [30, -30, -60, 60, 0, 60, -60, -30, 30],
        },
    'castro_2014_c14': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 35.,
        'r1': 400.,
        'H': 300.,
        'plyt': 0.125,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [0, 0, 60, -60, 45, -45],
        },
    'castro_2014_c26': {
        'elem_type': 'S8R5',
        'numel_r': 140,
        'alphadeg': 35.,
        'r1': 400.,
        'H': 300.,
        'plyt': 0.125,
        'laminapropKey': 'degenhardt_2010_IM78552_cocomat',
        'stack': [45, 0, -45, -45, 0, 45],
        },
    'hilburger_2014_c1': {
        'elem_type': 'S4R5',
        'numel_r': 426,
        'r1': 406.4 + 0.8128/2,
        'H': 1219.2,
        'plyt': 0.8128,
        'laminapropKey': 'hilburger_2014_AlLi',
        'stack': [0],
        },
    }

ccs['desicos_2014_z37'] = ccs['desicos_2014_z36']
