#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Sep  5 16:04:48 2024 by generateDS.py version 2.43.3.
# Python 3.10.12 (main, Jul 29 2024, 16:56:48) [GCC 11.4.0]
#
# Command line options:
#   ('-o', 'it_ext.py')
#
# Command line arguments:
#   schema/it_ext/CDA.xsd
#
# Command line:
#   ../../../../generateds/generateDS.py -o "it_ext.py" schema/it_ext/CDA.xsd
#
# Current working directory (os.getcwd()):
#   cda
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_
from typing import List as List_


Validate_simpletypes_ = True
SaveElementTreeNode = True
SaveNodeDict = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str
node_dict = dict()


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            value = ('%.15f' % float(input_data)).rstrip('0')
            if value.endswith('.'):
                value += '0'
            return value
    
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            input_data = input_data.strip()
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if instring is None:
                result = ""
            elif isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    s1 = s1.replace('\n', '&#10;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Start enum classes
#
class AcknowledgementCondition(str, Enum):
    AL='AL'
    ER='ER'
    NE='NE'


class AcknowledgementDetailType(str, Enum):
    E='E'
    I='I'
    W='W'


class AcknowledgementType(str, Enum):
    AA='AA'
    AE='AE'
    AR='AR'
    CA='CA'
    CE='CE'
    CR='CR'


class ActClass(str, Enum):
    ACCM='ACCM'
    ACCT='ACCT'
    ACSN='ACSN'
    ACT='ACT'
    ACTN='ACTN'
    ADJUD='ADJUD'
    AEXPOS='AEXPOS'
    ALRT='ALRT'
    BATTERY='BATTERY'
    CACT='CACT'
    CASE='CASE'
    CATEGORY='CATEGORY'
    CDALVLONE='CDALVLONE'
    CLNTRL='CLNTRL'
    CLUSTER='CLUSTER'
    CNOD='CNOD'
    CNTRCT='CNTRCT'
    COMPOSITION='COMPOSITION'
    CONC='CONC'
    COND='COND'
    CONS='CONS'
    CONTAINER='CONTAINER'
    CONTREG='CONTREG'
    COV='COV'
    CTTEVENT='CTTEVENT'
    DETPOL='DETPOL'
    DGIMG='DGIMG'
    DIET='DIET'
    DISPACT='DISPACT'
    DOC='DOC'
    DOCBODY='DOCBODY'
    DOCCLIN='DOCCLIN'
    DOCSECT='DOCSECT'
    EHR='EHR'
    ENC='ENC'
    EXP='EXP'
    EXPOS='EXPOS'
    EXTRACT='EXTRACT'
    FCNTRCT='FCNTRCT'
    FOLDER='FOLDER'
    GEN='GEN'
    GROUPER='GROUPER'
    INC='INC'
    INFO='INFO'
    INFRM='INFRM'
    INVE='INVE'
    INVSTG='INVSTG'
    JURISPOL='JURISPOL'
    LIST='LIST'
    LLD='LLD'
    LOC='LOC'
    MPROT='MPROT'
    OBS='OBS'
    OBSCOR='OBSCOR'
    OBSSER='OBSSER'
    ORGPOL='ORGPOL'
    OUTB='OUTB'
    PCPR='PCPR'
    PHN='PHN'
    POL='POL'
    POLICY='POLICY'
    POS='POS'
    POSACC='POSACC'
    POSCOORD='POSCOORD'
    PRN='PRN'
    PROC='PROC'
    REG='REG'
    REV='REV'
    RLD='RLD'
    ROIBND='ROIBND'
    ROIOVL='ROIOVL'
    RTRD='RTRD'
    SBADM='SBADM'
    SBEXT='SBEXT'
    SCOPOL='SCOPOL'
    SEQ='SEQ'
    SEQVAR='SEQVAR'
    SFWL='SFWL'
    SIT='SIT'
    SPCOBS='SPCOBS'
    SPCTRT='SPCTRT'
    SPECCOLLECT='SPECCOLLECT'
    SPLY='SPLY'
    STC='STC'
    STDPOL='STDPOL'
    STN='STN'
    STORE='STORE'
    SUBST='SUBST'
    SUP='SUP'
    TEXPOS='TEXPOS'
    TOPIC='TOPIC'
    TRD='TRD'
    TRFR='TRFR'
    TRNS='TRNS'
    VERIF='VERIF'
    XACT='XACT'


class ActClassAccession(str, Enum):
    ACSN='ACSN'


class ActClassAccommodation(str, Enum):
    ACCM='ACCM'


class ActClassAccount(str, Enum):
    ACCT='ACCT'


class ActClassAcquisitionExposure(str, Enum):
    AEXPOS='AEXPOS'


class ActClassAction(str, Enum):
    ACTN='ACTN'


class ActClassBattery(str, Enum):
    BATTERY='BATTERY'


class ActClassBioSequence(str, Enum):
    SEQ='SEQ'


class ActClassBioSequenceVariation(str, Enum):
    SEQVAR='SEQVAR'


class ActClassBoundedRoi(str, Enum):
    ROIBND='ROIBND'


class ActClassCareProvision(str, Enum):
    PCPR='PCPR'
    ENC='ENC'


class ActClassCategory(str, Enum):
    CATEGORY='CATEGORY'


class ActClassCdaLevelOneClinicalDocument(str, Enum):
    CDALVLONE='CDALVLONE'


class ActClassClinicalDocument(str, Enum):
    DOCCLIN='DOCCLIN'
    CDALVLONE='CDALVLONE'


class ActClassClinicalTrial(str, Enum):
    CLNTRL='CLNTRL'


class ActClassClinicalTrialTimepointEvent(str, Enum):
    CTTEVENT='CTTEVENT'


class ActClassCluster(str, Enum):
    CLUSTER='CLUSTER'


class ActClassCompositeOrder(str, Enum):
    GROUPER='GROUPER'
    CLUSTER='CLUSTER'
    OBS='OBS'
    ROIBND='ROIBND'
    ROIOVL='ROIOVL'
    LLD='LLD'
    PRN='PRN'
    RLD='RLD'
    SFWL='SFWL'
    SIT='SIT'
    STN='STN'
    SUP='SUP'
    RTRD='RTRD'
    TRD='TRD'
    ALRT='ALRT'
    BATTERY='BATTERY'
    CLNTRL='CLNTRL'
    CNOD='CNOD'
    CONC='CONC'
    COND='COND'
    CASE='CASE'
    OUTB='OUTB'
    DGIMG='DGIMG'
    GEN='GEN'
    DETPOL='DETPOL'
    EXP='EXP'
    LOC='LOC'
    PHN='PHN'
    POL='POL'
    SEQ='SEQ'
    SEQVAR='SEQVAR'
    INVSTG='INVSTG'
    OBSSER='OBSSER'
    OBSCOR='OBSCOR'
    POS='POS'
    POSACC='POSACC'
    POSCOORD='POSCOORD'
    SPCOBS='SPCOBS'
    VERIF='VERIF'
    PROC='PROC'
    SBADM='SBADM'
    SBEXT='SBEXT'
    SPECCOLLECT='SPECCOLLECT'
    SPLY='SPLY'
    DIET='DIET'


class ActClassComposition(str, Enum):
    COMPOSITION='COMPOSITION'
    DOC='DOC'
    DOCCLIN='DOCCLIN'
    CDALVLONE='CDALVLONE'


class ActClassConcern(str, Enum):
    CONC='CONC'


class ActClassCondition(str, Enum):
    COND='COND'
    CASE='CASE'
    OUTB='OUTB'


class ActClassConditionNode(str, Enum):
    CNOD='CNOD'


class ActClassConsent(str, Enum):
    CONS='CONS'


class ActClassContainer(str, Enum):
    CONTAINER='CONTAINER'
    CATEGORY='CATEGORY'
    DOCBODY='DOCBODY'
    DOCSECT='DOCSECT'
    TOPIC='TOPIC'


class ActClassContainerRegistration(str, Enum):
    CONTREG='CONTREG'


class ActClassContract(str, Enum):
    CNTRCT='CNTRCT'
    FCNTRCT='FCNTRCT'
    COV='COV'


class ActClassControlAct(str, Enum):
    CACT='CACT'
    ACTN='ACTN'
    INFO='INFO'
    STC='STC'


class ActClassCorrelatedObservationSequences(str, Enum):
    OBSCOR='OBSCOR'


class ActClassCoverage(str, Enum):
    COV='COV'


class ActClassDetectedIssue(str, Enum):
    ALRT='ALRT'


class ActClassDeterminantPeptide(str, Enum):
    DETPOL='DETPOL'


class ActClassDiagnosticImage(str, Enum):
    DGIMG='DGIMG'


class ActClassDiet(str, Enum):
    DIET='DIET'


class ActClassDisciplinaryAction(str, Enum):
    DISPACT='DISPACT'


class ActClassDocument(str, Enum):
    DOC='DOC'
    DOCCLIN='DOCCLIN'
    CDALVLONE='CDALVLONE'


class ActClassDocumentBody(str, Enum):
    DOCBODY='DOCBODY'


class ActClassDocumentSection(str, Enum):
    DOCSECT='DOCSECT'


class ActClassElectronicHealthRecord(str, Enum):
    EHR='EHR'


class ActClassEncounter(str, Enum):
    ENC='ENC'


class ActClassExposure(str, Enum):
    EXPOS='EXPOS'
    AEXPOS='AEXPOS'
    TEXPOS='TEXPOS'


class ActClassExpressionLevel(str, Enum):
    EXP='EXP'


class ActClassExtract(str, Enum):
    EXTRACT='EXTRACT'
    EHR='EHR'


class ActClassFinancialAdjudication(str, Enum):
    ADJUD='ADJUD'


class ActClassFinancialContract(str, Enum):
    FCNTRCT='FCNTRCT'
    COV='COV'


class ActClassFinancialTransaction(str, Enum):
    XACT='XACT'


class ActClassFolder(str, Enum):
    FOLDER='FOLDER'


class ActClassGenomicObservation(str, Enum):
    GEN='GEN'
    DETPOL='DETPOL'
    EXP='EXP'
    LOC='LOC'
    PHN='PHN'
    POL='POL'
    SEQ='SEQ'
    SEQVAR='SEQVAR'


class ActClassGrouper(str, Enum):
    GROUPER='GROUPER'
    CLUSTER='CLUSTER'


class ActClassIncident(str, Enum):
    INC='INC'


class ActClassInform(str, Enum):
    INFRM='INFRM'


class ActClassInformation(str, Enum):
    INFO='INFO'


class ActClassInvestigation(str, Enum):
    INVSTG='INVSTG'


class ActClassInvoiceElement(str, Enum):
    INVE='INVE'


class ActClassJurisdictionalPolicy(str, Enum):
    JURISPOL='JURISPOL'


class ActClassLeftLateralDecubitus(str, Enum):
    LLD='LLD'


class ActClassLocus(str, Enum):
    LOC='LOC'


class ActClassMonitoringProgram(str, Enum):
    MPROT='MPROT'


class ActClassObservation(str, Enum):
    OBS='OBS'
    ROIBND='ROIBND'
    ROIOVL='ROIOVL'
    LLD='LLD'
    PRN='PRN'
    RLD='RLD'
    SFWL='SFWL'
    SIT='SIT'
    STN='STN'
    SUP='SUP'
    RTRD='RTRD'
    TRD='TRD'
    ALRT='ALRT'
    BATTERY='BATTERY'
    CLNTRL='CLNTRL'
    CNOD='CNOD'
    CONC='CONC'
    COND='COND'
    CASE='CASE'
    OUTB='OUTB'
    DGIMG='DGIMG'
    GEN='GEN'
    DETPOL='DETPOL'
    EXP='EXP'
    LOC='LOC'
    PHN='PHN'
    POL='POL'
    SEQ='SEQ'
    SEQVAR='SEQVAR'
    INVSTG='INVSTG'
    OBSSER='OBSSER'
    OBSCOR='OBSCOR'
    POS='POS'
    POSACC='POSACC'
    POSCOORD='POSCOORD'
    SPCOBS='SPCOBS'
    VERIF='VERIF'


class ActClassObservationSeries(str, Enum):
    OBSSER='OBSSER'
    OBSCOR='OBSCOR'


class ActClassOrganizationalPolicy(str, Enum):
    ORGPOL='ORGPOL'


class ActClassOutbreak(str, Enum):
    OUTB='OUTB'


class ActClassOverlayRoi(str, Enum):
    ROIOVL='ROIOVL'


class ActClassPhenotype(str, Enum):
    PHN='PHN'


class ActClassPolicy(str, Enum):
    POLICY='POLICY'
    JURISPOL='JURISPOL'
    ORGPOL='ORGPOL'
    SCOPOL='SCOPOL'
    STDPOL='STDPOL'


class ActClassPolypeptide(str, Enum):
    POL='POL'


class ActClassPosition(str, Enum):
    POS='POS'
    POSACC='POSACC'
    POSCOORD='POSCOORD'


class ActClassPositionAccuracy(str, Enum):
    POSACC='POSACC'


class ActClassPositionCoordinate(str, Enum):
    POSCOORD='POSCOORD'


class ActClassProcedure(str, Enum):
    PROC='PROC'
    SBADM='SBADM'
    SBEXT='SBEXT'
    SPECCOLLECT='SPECCOLLECT'


class ActClassProcessStep(str, Enum):
    ACSN='ACSN'
    CONTREG='CONTREG'
    OBS='OBS'
    ROIBND='ROIBND'
    ROIOVL='ROIOVL'
    LLD='LLD'
    PRN='PRN'
    RLD='RLD'
    SFWL='SFWL'
    SIT='SIT'
    STN='STN'
    SUP='SUP'
    RTRD='RTRD'
    TRD='TRD'
    ALRT='ALRT'
    BATTERY='BATTERY'
    CLNTRL='CLNTRL'
    CNOD='CNOD'
    CONC='CONC'
    COND='COND'
    CASE='CASE'
    OUTB='OUTB'
    DGIMG='DGIMG'
    GEN='GEN'
    DETPOL='DETPOL'
    EXP='EXP'
    LOC='LOC'
    PHN='PHN'
    POL='POL'
    SEQ='SEQ'
    SEQVAR='SEQVAR'
    INVSTG='INVSTG'
    OBSSER='OBSSER'
    OBSCOR='OBSCOR'
    POS='POS'
    POSACC='POSACC'
    POSCOORD='POSCOORD'
    SPCOBS='SPCOBS'
    VERIF='VERIF'
    PROC='PROC'
    SBADM='SBADM'
    SBEXT='SBEXT'
    SPECCOLLECT='SPECCOLLECT'
    SPCTRT='SPCTRT'
    SPECCOLLECT_1='SPECCOLLECT'
    STORE='STORE'
    TRNS='TRNS'


class ActClassProne(str, Enum):
    PRN='PRN'


class ActClassPublicHealthCase(str, Enum):
    CASE='CASE'
    OUTB='OUTB'


class ActClassROI(str, Enum):
    ROIBND='ROIBND'
    ROIOVL='ROIOVL'


class ActClassRecordOrganizer(str, Enum):
    COMPOSITION='COMPOSITION'
    DOC='DOC'
    DOCCLIN='DOCCLIN'
    CDALVLONE='CDALVLONE'
    CONTAINER='CONTAINER'
    CATEGORY='CATEGORY'
    DOCBODY='DOCBODY'
    DOCSECT='DOCSECT'
    TOPIC='TOPIC'
    EXTRACT='EXTRACT'
    EHR='EHR'
    FOLDER='FOLDER'
    GROUPER='GROUPER'
    CLUSTER='CLUSTER'


class ActClassRegistration(str, Enum):
    REG='REG'


class ActClassReverseTrendelenburg(str, Enum):
    RTRD='RTRD'


class ActClassReview(str, Enum):
    REV='REV'


class ActClassRightLateralDecubitus(str, Enum):
    RLD='RLD'


class ActClassRoot(str, Enum):
    ACT='ACT'
    COMPOSITION='COMPOSITION'
    DOC='DOC'
    DOCCLIN='DOCCLIN'
    CDALVLONE='CDALVLONE'
    CONTAINER='CONTAINER'
    CATEGORY='CATEGORY'
    DOCBODY='DOCBODY'
    DOCSECT='DOCSECT'
    TOPIC='TOPIC'
    EXTRACT='EXTRACT'
    EHR='EHR'
    FOLDER='FOLDER'
    GROUPER='GROUPER'
    CLUSTER='CLUSTER'
    ACCM='ACCM'
    ACCT='ACCT'
    ACSN='ACSN'
    ADJUD='ADJUD'
    CACT='CACT'
    ACTN='ACTN'
    INFO='INFO'
    STC='STC'
    CNTRCT='CNTRCT'
    FCNTRCT='FCNTRCT'
    COV='COV'
    CONS='CONS'
    CONTREG='CONTREG'
    CTTEVENT='CTTEVENT'
    DISPACT='DISPACT'
    EXPOS='EXPOS'
    AEXPOS='AEXPOS'
    TEXPOS='TEXPOS'
    INC='INC'
    INFRM='INFRM'
    INVE='INVE'
    LIST='LIST'
    MPROT='MPROT'
    OBS='OBS'
    ROIBND='ROIBND'
    ROIOVL='ROIOVL'
    LLD='LLD'
    PRN='PRN'
    RLD='RLD'
    SFWL='SFWL'
    SIT='SIT'
    STN='STN'
    SUP='SUP'
    RTRD='RTRD'
    TRD='TRD'
    ALRT='ALRT'
    BATTERY='BATTERY'
    CLNTRL='CLNTRL'
    CNOD='CNOD'
    CONC='CONC'
    COND='COND'
    CASE='CASE'
    OUTB='OUTB'
    DGIMG='DGIMG'
    GEN='GEN'
    DETPOL='DETPOL'
    EXP='EXP'
    LOC='LOC'
    PHN='PHN'
    POL='POL'
    SEQ='SEQ'
    SEQVAR='SEQVAR'
    INVSTG='INVSTG'
    OBSSER='OBSSER'
    OBSCOR='OBSCOR'
    POS='POS'
    POSACC='POSACC'
    POSCOORD='POSCOORD'
    SPCOBS='SPCOBS'
    VERIF='VERIF'
    PCPR='PCPR'
    ENC='ENC'
    POLICY='POLICY'
    JURISPOL='JURISPOL'
    ORGPOL='ORGPOL'
    SCOPOL='SCOPOL'
    STDPOL='STDPOL'
    PROC='PROC'
    SBADM='SBADM'
    SBEXT='SBEXT'
    SPECCOLLECT='SPECCOLLECT'
    REG='REG'
    REV='REV'
    SPCTRT='SPCTRT'
    SPLY='SPLY'
    DIET='DIET'
    STORE='STORE'
    SUBST='SUBST'
    TRFR='TRFR'
    TRNS='TRNS'
    XACT='XACT'


class ActClassScopeOfPracticePolicy(str, Enum):
    SCOPOL='SCOPOL'


class ActClassSemiFowlers(str, Enum):
    SFWL='SFWL'


class ActClassSitting(str, Enum):
    SIT='SIT'


class ActClassSpecimenCollection(str, Enum):
    SPECCOLLECT='SPECCOLLECT'


class ActClassSpecimenObservation(str, Enum):
    SPCOBS='SPCOBS'


class ActClassSpecimenTreatment(str, Enum):
    SPCTRT='SPCTRT'


class ActClassStandardOfPracticePolicy(str, Enum):
    STDPOL='STDPOL'


class ActClassStanding(str, Enum):
    STN='STN'


class ActClassStateTransitionControl(str, Enum):
    STC='STC'


class ActClassSubjectBodyPosition(str, Enum):
    LLD='LLD'
    PRN='PRN'
    RLD='RLD'
    SFWL='SFWL'
    SIT='SIT'
    STN='STN'
    SUP='SUP'
    RTRD='RTRD'
    TRD='TRD'


class ActClassSubjectPhysicalPosition(str, Enum):
    LLD='LLD'
    PRN='PRN'
    RLD='RLD'
    SFWL='SFWL'
    SIT='SIT'
    STN='STN'
    SUP='SUP'
    RTRD='RTRD'
    TRD='TRD'


class ActClassSubstanceAdministration(str, Enum):
    SBADM='SBADM'


class ActClassSubstanceExtraction(str, Enum):
    SBEXT='SBEXT'
    SPECCOLLECT='SPECCOLLECT'


class ActClassSubstitution(str, Enum):
    SUBST='SUBST'


class ActClassSupine(str, Enum):
    SUP='SUP'
    RTRD='RTRD'
    TRD='TRD'


class ActClassSupply(str, Enum):
    SPLY='SPLY'
    DIET='DIET'


class ActClassTopic(str, Enum):
    TOPIC='TOPIC'


class ActClassTransfer(str, Enum):
    TRFR='TRFR'


class ActClassTransmissionExposure(str, Enum):
    TEXPOS='TEXPOS'


class ActClassTransportation(str, Enum):
    TRNS='TRNS'


class ActClassTrendelenburg(str, Enum):
    TRD='TRD'


class ActClassVerification(str, Enum):
    VERIF='VERIF'


class ActClassWorkingList(str, Enum):
    LIST='LIST'


class ActMood(str, Enum):
    APT='APT'
    ARQ='ARQ'
    CRT='CRT'
    DEF='DEF'
    EVN='EVN'
    EVNCRT='EVN.CRT'
    EXPEC='EXPEC'
    GOL='GOL'
    INT='INT'
    OPT='OPT'
    PERM='PERM'
    PERMRQ='PERMRQ'
    PRMS='PRMS'
    PRP='PRP'
    RMD='RMD'
    RQO='RQO'
    RSK='RSK'
    SLOT='SLOT'


class ActMoodActRequest(str, Enum):
    ARQ='ARQ'
    PERMRQ='PERMRQ'
    RQO='RQO'


class ActMoodAppointment(str, Enum):
    APT='APT'


class ActMoodAppointmentRequest(str, Enum):
    ARQ='ARQ'


class ActMoodCompletionTrack(str, Enum):
    DEF='DEF'
    PERM='PERM'
    SLOT='SLOT'
    EVN='EVN'
    INT='INT'
    ARQ='ARQ'
    PERMRQ='PERMRQ'
    RQO='RQO'
    PRP='PRP'
    RMD='RMD'
    PRMS='PRMS'
    APT='APT'


class ActMoodCriterion(str, Enum):
    CRT='CRT'
    EVNCRT='EVN.CRT'


class ActMoodDefinition(str, Enum):
    DEF='DEF'


class ActMoodDesire(str, Enum):
    ARQ='ARQ'
    PERMRQ='PERMRQ'
    RQO='RQO'
    PRP='PRP'
    RMD='RMD'


class ActMoodEventCriterion(str, Enum):
    EVNCRT='EVN.CRT'


class ActMoodEventOccurrence(str, Enum):
    EVN='EVN'


class ActMoodExpectation(str, Enum):
    EXPEC='EXPEC'
    GOL='GOL'
    RSK='RSK'


class ActMoodGoal(str, Enum):
    GOL='GOL'


class ActMoodIntent(str, Enum):
    INT='INT'
    ARQ='ARQ'
    PERMRQ='PERMRQ'
    RQO='RQO'
    PRP='PRP'
    RMD='RMD'
    PRMS='PRMS'
    APT='APT'


class ActMoodOption(str, Enum):
    OPT='OPT'


class ActMoodPermission(str, Enum):
    PERM='PERM'


class ActMoodPermissionRequest(str, Enum):
    PERMRQ='PERMRQ'


class ActMoodPotential(str, Enum):
    DEF='DEF'
    PERM='PERM'
    SLOT='SLOT'


class ActMoodPredicate(str, Enum):
    CRT='CRT'
    EVNCRT='EVN.CRT'
    EXPEC='EXPEC'
    GOL='GOL'
    RSK='RSK'
    OPT='OPT'


class ActMoodPromise(str, Enum):
    PRMS='PRMS'
    APT='APT'


class ActMoodProposal(str, Enum):
    PRP='PRP'
    RMD='RMD'


class ActMoodRecommendation(str, Enum):
    RMD='RMD'


class ActMoodRequest(str, Enum):
    RQO='RQO'


class ActMoodResourceSlot(str, Enum):
    SLOT='SLOT'


class ActMoodRisk(str, Enum):
    RSK='RSK'


class ActRelationshipAccounting(str, Enum):
    CHRG='CHRG'
    COST='COST'
    CHRG_1='CHRG'
    COST_1='COST'
    CREDIT='CREDIT'
    DEBIT='DEBIT'
    CREDIT_1='CREDIT'
    DEBIT_1='DEBIT'


class ActRelationshipAdjunctCurativeIndication(str, Enum):
    CUREADJ='CURE.ADJ'


class ActRelationshipAdjunctMitigation(str, Enum):
    MTGTADJ='MTGT.ADJ'


class ActRelationshipArrival(str, Enum):
    ARR='ARR'


class ActRelationshipAssignsName(str, Enum):
    NAME='NAME'


class ActRelationshipAuthorizedBy(str, Enum):
    AUTH='AUTH'


class ActRelationshipBlocks(str, Enum):
    BLOCK='BLOCK'


class ActRelationshipCheckpoint(str, Enum):
    B='B'
    E='E'
    S='S'
    T='T'
    X='X'


class ActRelationshipCheckpointBeginning(str, Enum):
    B='B'


class ActRelationshipCheckpointEnd(str, Enum):
    E='E'


class ActRelationshipCheckpointEntry(str, Enum):
    S='S'


class ActRelationshipCheckpointExit(str, Enum):
    X='X'


class ActRelationshipCheckpointThrough(str, Enum):
    T='T'


class ActRelationshipConcurrentWith(str, Enum):
    CONCURRENT='CONCURRENT'


class ActRelationshipConditional(str, Enum):
    CIND='CIND'
    PRCN='PRCN'
    RSON='RSON'
    BLOCK='BLOCK'
    CURE='CURE'
    CUREADJ='CURE.ADJ'
    DIAG='DIAG'
    MITGT='MITGT'
    RCVY='RCVY'
    MTGTADJ='MTGT.ADJ'
    SYMP='SYMP'
    TRIG='TRIG'


class ActRelationshipCostTracking(str, Enum):
    CHRG='CHRG'
    COST='COST'


class ActRelationshipCoveredBy(str, Enum):
    COVBY='COVBY'


class ActRelationshipCurativeIndication(str, Enum):
    CURE='CURE'


class ActRelationshipDeparture(str, Enum):
    DEP='DEP'


class ActRelationshipDiagnosis(str, Enum):
    DIAG='DIAG'


class ActRelationshipDocuments(str, Enum):
    DOC='DOC'


class ActRelationshipDuring(str, Enum):
    DURING='DURING'


class ActRelationshipEndsAfterEndOf(str, Enum):
    EAE='EAE'


class ActRelationshipEndsAfterStartOf(str, Enum):
    EAS='EAS'
    EDU='EDU'


class ActRelationshipEndsBeforeStartOf(str, Enum):
    EBS='EBS'


class ActRelationshipEndsConcurrentWith(str, Enum):
    ECW='ECW'
    CONCURRENT='CONCURRENT'


class ActRelationshipEndsDuring(str, Enum):
    EDU='EDU'


class ActRelationshipEpisodelink(str, Enum):
    ELNK='ELNK'


class ActRelationshipEvaluatesGoal(str, Enum):
    GEVL='GEVL'


class ActRelationshipExacerbatredBy(str, Enum):
    EXACBY='EXACBY'


class ActRelationshipExcerpt(str, Enum):
    XCRPT='XCRPT'
    VRXCRPT='VRXCRPT'


class ActRelationshipExcerptVerbatim(str, Enum):
    VRXCRPT='VRXCRPT'


class ActRelationshipFulfills(str, Enum):
    FLFS='FLFS'
    OCCR='OCCR'
    OREF='OREF'
    SCH='SCH'


class ActRelationshipHasBaseline(str, Enum):
    BSLN='BSLN'


class ActRelationshipHasBoundedSupport(str, Enum):
    SPRTBND='SPRTBND'


class ActRelationshipHasCharge(str, Enum):
    CHRG='CHRG'


class ActRelationshipHasComponent(str, Enum):
    COMP='COMP'
    ARR='ARR'
    CTRLV='CTRLV'
    DEP='DEP'


class ActRelationshipHasContinuingObjective(str, Enum):
    OBJC='OBJC'


class ActRelationshipHasContra_indication(str, Enum):
    CIND='CIND'


class ActRelationshipHasControlVariable(str, Enum):
    CTRLV='CTRLV'


class ActRelationshipHasCost(str, Enum):
    COST='COST'


class ActRelationshipHasCredit(str, Enum):
    CREDIT='CREDIT'


class ActRelationshipHasDebit(str, Enum):
    DEBIT='DEBIT'


class ActRelationshipHasExplanation(str, Enum):
    EXPL='EXPL'


class ActRelationshipHasFinalObjective(str, Enum):
    OBJF='OBJF'


class ActRelationshipHasGeneralization(str, Enum):
    GEN='GEN'


class ActRelationshipHasGoal(str, Enum):
    GOAL='GOAL'


class ActRelationshipHasOption(str, Enum):
    OPTN='OPTN'


class ActRelationshipHasPre_condition(str, Enum):
    PRCN='PRCN'


class ActRelationshipHasPreviousInstance(str, Enum):
    PREV='PREV'


class ActRelationshipHasReferenceValues(str, Enum):
    REFV='REFV'


class ActRelationshipHasRisk(str, Enum):
    RISK='RISK'


class ActRelationshipHasSubject(str, Enum):
    SUBJ='SUBJ'


class ActRelationshipHasSupport(str, Enum):
    SPRT='SPRT'
    SPRTBND='SPRTBND'


class ActRelationshipHasTrigger(str, Enum):
    TRIG='TRIG'


class ActRelationshipICSRInvestigation(str, Enum):
    RPLC='RPLC'
    SEQL='SEQL'
    SPRT='SPRT'


class ActRelationshipInstantiatesMaster(str, Enum):
    INST='INST'


class ActRelationshipIsAppendage(str, Enum):
    APND='APND'


class ActRelationshipIsDerivedFrom(str, Enum):
    DRIV='DRIV'


class ActRelationshipIsEtiologyFor(str, Enum):
    CAUS='CAUS'


class ActRelationshipIsManifestationOf(str, Enum):
    MFST='MFST'


class ActRelationshipItemsLocated(str, Enum):
    ITEMSLOC='ITEMSLOC'


class ActRelationshipJoin(str, Enum):
    D='D'
    K='K'
    W='W'
    X='X'


class ActRelationshipJoinDetached(str, Enum):
    D='D'


class ActRelationshipJoinExclusiveWait(str, Enum):
    X='X'


class ActRelationshipJoinKill(str, Enum):
    K='K'


class ActRelationshipJoinWait(str, Enum):
    W='W'


class ActRelationshipLimitedBy(str, Enum):
    LIMIT='LIMIT'


class ActRelationshipMatchesTrigger(str, Enum):
    MTCH='MTCH'


class ActRelationshipMitigates(str, Enum):
    MITGT='MITGT'
    RCVY='RCVY'


class ActRelationshipModifies(str, Enum):
    MOD='MOD'


class ActRelationshipObjective(str, Enum):
    OBJC='OBJC'
    OBJF='OBJF'


class ActRelationshipOccurrence(str, Enum):
    OCCR='OCCR'


class ActRelationshipOutcome(str, Enum):
    OUTC='OUTC'
    OBJC='OBJC'
    OBJF='OBJF'
    GOAL='GOAL'
    RISK='RISK'


class ActRelationshipOverlapsWith(str, Enum):
    OVERLAP='OVERLAP'


class ActRelationshipPertains(str, Enum):
    PERT='PERT'
    EAE='EAE'
    EAS='EAS'
    EDU='EDU'
    EBS='EBS'
    ECW='ECW'
    CONCURRENT='CONCURRENT'
    EAE_1='EAE'
    EAS_1='EAS'
    EDU_1='EDU'
    EBS_1='EBS'
    ECW_1='ECW'
    CONCURRENT_1='CONCURRENT'
    SAE='SAE'
    SAS='SAS'
    SDU='SDU'
    SBS='SBS'
    SCW='SCW'
    CONCURRENT_2='CONCURRENT'
    SAE_1='SAE'
    SAS_1='SAS'
    SDU_1='SDU'
    SBS_1='SBS'
    SCW_1='SCW'
    CONCURRENT_3='CONCURRENT'
    DURING='DURING'
    DURING_1='DURING'
    OVERLAP='OVERLAP'
    OVERLAP_1='OVERLAP'
    EAE_2='EAE'
    EAS_2='EAS'
    EDU_2='EDU'
    EBS_2='EBS'
    ECW_2='ECW'
    CONCURRENT_4='CONCURRENT'
    EAE_3='EAE'
    EAS_3='EAS'
    EDU_3='EDU'
    EBS_3='EBS'
    ECW_3='ECW'
    CONCURRENT_5='CONCURRENT'
    SAE_2='SAE'
    SAS_2='SAS'
    SDU_2='SDU'
    SBS_2='SBS'
    SCW_2='SCW'
    CONCURRENT_6='CONCURRENT'
    SAE_3='SAE'
    SAS_3='SAS'
    SDU_3='SDU'
    SBS_3='SBS'
    SCW_3='SCW'
    CONCURRENT_7='CONCURRENT'
    DURING_2='DURING'
    DURING_3='DURING'
    OVERLAP_2='OVERLAP'
    OVERLAP_3='OVERLAP'
    CHRG='CHRG'
    COST='COST'
    CHRG_1='CHRG'
    COST_1='COST'
    CREDIT='CREDIT'
    DEBIT='DEBIT'
    CREDIT_1='CREDIT'
    DEBIT_1='DEBIT'
    CHRG_2='CHRG'
    COST_2='COST'
    CHRG_3='CHRG'
    COST_3='COST'
    CREDIT_2='CREDIT'
    DEBIT_2='DEBIT'
    CREDIT_3='CREDIT'
    DEBIT_3='DEBIT'
    AUTH='AUTH'
    CAUS='CAUS'
    COVBY='COVBY'
    DRIV='DRIV'
    ELNK='ELNK'
    EVID='EVID'
    EXACBY='EXACBY'
    EXPL='EXPL'
    ITEMSLOC='ITEMSLOC'
    LIMIT='LIMIT'
    META='META'
    MFST='MFST'
    NAME='NAME'
    PREV='PREV'
    REFR='REFR'
    USE='USE'
    REFV='REFV'
    RELVBY='RELVBY'
    SPRT='SPRT'
    SPRTBND='SPRTBND'
    SUBJ='SUBJ'
    SUMM='SUMM'


class ActRelationshipPosting(str, Enum):
    CREDIT='CREDIT'
    DEBIT='DEBIT'


class ActRelationshipProvidesEvidenceFor(str, Enum):
    EVID='EVID'


class ActRelationshipRe_challenge(str, Enum):
    RCHAL='RCHAL'


class ActRelationshipReason(str, Enum):
    RSON='RSON'
    BLOCK='BLOCK'
    CURE='CURE'
    CUREADJ='CURE.ADJ'
    DIAG='DIAG'
    MITGT='MITGT'
    RCVY='RCVY'
    MTGTADJ='MTGT.ADJ'
    SYMP='SYMP'


class ActRelationshipRecovery(str, Enum):
    RCVY='RCVY'


class ActRelationshipReferencesOrder(str, Enum):
    OREF='OREF'


class ActRelationshipRefersTo(str, Enum):
    REFR='REFR'
    USE='USE'


class ActRelationshipRelievedBy(str, Enum):
    RELVBY='RELVBY'


class ActRelationshipReplaces(str, Enum):
    RPLC='RPLC'


class ActRelationshipReverses(str, Enum):
    REV='REV'


class ActRelationshipSchedulesRequest(str, Enum):
    SCH='SCH'


class ActRelationshipSequel(str, Enum):
    SEQL='SEQL'
    APND='APND'
    BSLN='BSLN'
    COMPLY='COMPLY'
    DOC='DOC'
    FLFS='FLFS'
    OCCR='OCCR'
    OREF='OREF'
    SCH='SCH'
    GEN='GEN'
    GEVL='GEVL'
    INST='INST'
    MOD='MOD'
    MTCH='MTCH'
    OPTN='OPTN'
    RCHAL='RCHAL'
    REV='REV'
    RPLC='RPLC'
    SUCC='SUCC'
    UPDT='UPDT'
    XCRPT='XCRPT'
    VRXCRPT='VRXCRPT'
    XFRM='XFRM'


class ActRelationshipSplit(str, Enum):
    E_1='E1'
    EW='EW'
    I_1='I1'
    IW='IW'


class ActRelationshipSplitExclusiveTryOnce(str, Enum):
    E_1='E1'


class ActRelationshipSplitExclusiveWait(str, Enum):
    EW='EW'


class ActRelationshipSplitInclusiveTryOnce(str, Enum):
    I_1='I1'


class ActRelationshipSplitInclusiveWait(str, Enum):
    IW='IW'


class ActRelationshipStartsAfterEndOf(str, Enum):
    SAE='SAE'


class ActRelationshipStartsAfterStartOf(str, Enum):
    SAS='SAS'
    SDU='SDU'


class ActRelationshipStartsBeforeStartOf(str, Enum):
    SBS='SBS'


class ActRelationshipStartsConcurrentWith(str, Enum):
    SCW='SCW'
    CONCURRENT='CONCURRENT'


class ActRelationshipStartsDuring(str, Enum):
    SDU='SDU'


class ActRelationshipSucceeds(str, Enum):
    SUCC='SUCC'


class ActRelationshipSummarizedBy(str, Enum):
    SUMM='SUMM'


class ActRelationshipSymptomaticRelief(str, Enum):
    SYMP='SYMP'


class ActRelationshipTemporallyPertains(str, Enum):
    EAE='EAE'
    EAS='EAS'
    EDU='EDU'
    EBS='EBS'
    ECW='ECW'
    CONCURRENT='CONCURRENT'
    EAE_1='EAE'
    EAS_1='EAS'
    EDU_1='EDU'
    EBS_1='EBS'
    ECW_1='ECW'
    CONCURRENT_1='CONCURRENT'
    SAE='SAE'
    SAS='SAS'
    SDU='SDU'
    SBS='SBS'
    SCW='SCW'
    CONCURRENT_2='CONCURRENT'
    SAE_1='SAE'
    SAS_1='SAS'
    SDU_1='SDU'
    SBS_1='SBS'
    SCW_1='SCW'
    CONCURRENT_3='CONCURRENT'
    DURING='DURING'
    DURING_1='DURING'
    OVERLAP='OVERLAP'
    OVERLAP_1='OVERLAP'


class ActRelationshipTemporallyPertainsEnd(str, Enum):
    EAE='EAE'
    EAS='EAS'
    EDU='EDU'
    EBS='EBS'
    ECW='ECW'
    CONCURRENT='CONCURRENT'


class ActRelationshipTemporallyPertainsStart(str, Enum):
    SAE='SAE'
    SAS='SAS'
    SDU='SDU'
    SBS='SBS'
    SCW='SCW'
    CONCURRENT='CONCURRENT'


class ActRelationshipTransformation(str, Enum):
    XFRM='XFRM'


class ActRelationshipType(str, Enum):
    APND='APND'
    ARR='ARR'
    AUTH='AUTH'
    BLOCK='BLOCK'
    BSLN='BSLN'
    CAUS='CAUS'
    CHRG='CHRG'
    CIND='CIND'
    COMP='COMP'
    COMPLY='COMPLY'
    CONCURRENT='CONCURRENT'
    COST='COST'
    COVBY='COVBY'
    CREDIT='CREDIT'
    CTRLV='CTRLV'
    CURE='CURE'
    CUREADJ='CURE.ADJ'
    DEBIT='DEBIT'
    DEP='DEP'
    DIAG='DIAG'
    DOC='DOC'
    DRIV='DRIV'
    DURING='DURING'
    EAE='EAE'
    EAS='EAS'
    EBS='EBS'
    ECW='ECW'
    EDU='EDU'
    ELNK='ELNK'
    EVID='EVID'
    EXACBY='EXACBY'
    EXPL='EXPL'
    FLFS='FLFS'
    GEN='GEN'
    GEVL='GEVL'
    GOAL='GOAL'
    INST='INST'
    ITEMSLOC='ITEMSLOC'
    LIMIT='LIMIT'
    META='META'
    MFST='MFST'
    MITGT='MITGT'
    MOD='MOD'
    MTCH='MTCH'
    MTGTADJ='MTGT.ADJ'
    NAME='NAME'
    OBJC='OBJC'
    OBJF='OBJF'
    OCCR='OCCR'
    OPTN='OPTN'
    OREF='OREF'
    OUTC='OUTC'
    OVERLAP='OVERLAP'
    PERT='PERT'
    PRCN='PRCN'
    PREV='PREV'
    RCHAL='RCHAL'
    RCVY='RCVY'
    REFR='REFR'
    REFV='REFV'
    RELVBY='RELVBY'
    REV='REV'
    RISK='RISK'
    RPLC='RPLC'
    RSON='RSON'
    SAE='SAE'
    SAS='SAS'
    SBS='SBS'
    SCH='SCH'
    SCW='SCW'
    SDU='SDU'
    SEQL='SEQL'
    SPRT='SPRT'
    SPRTBND='SPRTBND'
    SUBJ='SUBJ'
    SUCC='SUCC'
    SUMM='SUMM'
    SYMP='SYMP'
    TRIG='TRIG'
    UPDT='UPDT'
    USE='USE'
    VRXCRPT='VRXCRPT'
    XCRPT='XCRPT'
    XFRM='XFRM'


class ActRelationshipUpdate(str, Enum):
    COMPLY='COMPLY'


class ActRelationshipUpdatesCondition(str, Enum):
    UPDT='UPDT'


class ActRelationshipUses(str, Enum):
    USE='USE'


class ActStatus(str, Enum):
    ABORTED='aborted'
    ACTIVE='active'
    CANCELLED='cancelled'
    COMPLETED='completed'
    HELD='held'
    NEW='new'
    NORMAL='normal'
    NULLIFIED='nullified'
    OBSOLETE='obsolete'
    SUSPENDED='suspended'


class ActStatusAborted(str, Enum):
    ABORTED='aborted'


class ActStatusAbortedCancelledCompleted(str, Enum):
    ABORTED='aborted'
    CANCELLED='cancelled'
    COMPLETED='completed'


class ActStatusActive(str, Enum):
    ACTIVE='active'


class ActStatusCancelled(str, Enum):
    CANCELLED='cancelled'


class ActStatusCompleted(str, Enum):
    COMPLETED='completed'


class ActStatusHeld(str, Enum):
    HELD='held'


class ActStatusNew(str, Enum):
    NEW='new'


class ActStatusNormal(str, Enum):
    NORMAL='normal'
    ABORTED='aborted'
    ACTIVE='active'
    CANCELLED='cancelled'
    COMPLETED='completed'
    HELD='held'
    NEW='new'
    SUSPENDED='suspended'


class ActStatusNullified(str, Enum):
    NULLIFIED='nullified'


class ActStatusObsolete(str, Enum):
    OBSOLETE='obsolete'


class ActStatusSuspended(str, Enum):
    SUSPENDED='suspended'


class AdditionalLocator(str, Enum):
    ADL='ADL'


class AddressLine(str, Enum):
    AL='AL'
    DAL='DAL'
    SAL='SAL'


class AddressPartType(str, Enum):
    ADL='ADL'
    AL='AL'
    BNN='BNN'
    BNR='BNR'
    BNS='BNS'
    CAR='CAR'
    CEN='CEN'
    CNT='CNT'
    CPA='CPA'
    CTY='CTY'
    DAL='DAL'
    DEL='DEL'
    DINST='DINST'
    DINSTA='DINSTA'
    DINSTQ='DINSTQ'
    DIR='DIR'
    DMOD='DMOD'
    DMODID='DMODID'
    INT='INT'
    POB='POB'
    PRE='PRE'
    SAL='SAL'
    STA='STA'
    STB='STB'
    STR='STR'
    STTYP='STTYP'
    UNID='UNID'
    UNIT='UNIT'
    ZIP='ZIP'


class AddressRepresentationUse(str, Enum):
    ABC='ABC'
    IDE='IDE'
    SYL='SYL'


class AddressUse(str, Enum):
    AS='AS'
    BAD='BAD'
    CONF='CONF'
    DIR='DIR'
    EC='EC'
    H='H'
    HP='HP'
    HV='HV'
    MC='MC'
    PG='PG'
    PHYS='PHYS'
    PST='PST'
    PUB='PUB'
    TMP='TMP'
    WP='WP'


class ApplicationMediaType(str, Enum):
    APPLICATIONDICOM='application/dicom'
    APPLICATIONMSWORD='application/msword'
    APPLICATIONPDF='application/pdf'


class AskedButUnknown(str, Enum):
    ASKU='ASKU'
    NAV='NAV'


class AudioMediaType(str, Enum):
    AUDIOBASIC='audio/basic'
    AUDIOK_32_ADPCM='audio/k32adpcm'
    AUDIOMPEG='audio/mpeg'


class BinaryDataEncoding(str, Enum):
    B_64='B64'
    TXT='TXT'


class BuildingNumber(str, Enum):
    BNR='BNR'


class CalendarCycle(str, Enum):
    CD='CD'
    CH='CH'
    CM='CM'
    CN='CN'
    CS='CS'
    CW='CW'
    CY='CY'
    D='D'
    DM='DM'
    DW='DW'
    DY='DY'
    H='H'
    HD='HD'
    J='J'
    M='M'
    MY='MY'
    N='N'
    NH='NH'
    S='S'
    SN='SN'
    W='W'
    WY='WY'
    Y='Y'


class CalendarCycleOneLetter(str, Enum):
    CW='CW'
    W='W'
    CY='CY'
    Y='Y'
    D='D'
    DM='DM'
    DW='DW'
    J='J'
    H='H'
    HD='HD'
    M='M'
    MY='MY'
    N='N'
    NH='NH'
    S='S'
    SN='SN'
    D_1='D'
    H_1='H'
    J_1='J'
    M_1='M'
    N_1='N'
    S_1='S'
    W_1='W'
    Y_1='Y'


class CalendarCycleTwoLetter(str, Enum):
    CW='CW'
    W='W'
    CY='CY'
    Y='Y'
    D='D'
    DM='DM'
    DW='DW'
    J='J'
    H='H'
    HD='HD'
    M='M'
    MY='MY'
    N='N'
    NH='NH'
    S='S'
    SN='SN'
    CD='CD'
    CH='CH'
    CM='CM'
    CN='CN'
    CS='CS'
    DY='DY'
    WY='WY'
    CD_1='CD'
    CH_1='CH'
    CM_1='CM'
    CN_1='CN'
    CS_1='CS'
    CW_1='CW'
    CY_1='CY'
    DM_1='DM'
    DW_1='DW'
    DY_1='DY'
    HD_1='HD'
    MY_1='MY'
    NH_1='NH'
    SN_1='SN'
    WY_1='WY'


class ClassNullFlavor(str, Enum):
    ASKU='ASKU'
    MSK='MSK'
    NA='NA'
    NASK='NASK'
    NAV='NAV'
    NI='NI'
    UNK='UNK'


class CodingRationale(str, Enum):
    O='O'
    P='P'
    R='R'


class CommunicationFunctionType(str, Enum):
    RCV='RCV'
    RSP='RSP'
    SND='SND'


class CompressionAlgorithm(str, Enum):
    DF='DF'
    GZ='GZ'
    Z='Z'
    ZL='ZL'


class ContactRoleType(str, Enum):
    ECON='ECON'
    NOK='NOK'
    BILL='BILL'
    ORG='ORG'
    PAYOR='PAYOR'


class ContextControl(str, Enum):
    AN='AN'
    AP='AP'
    ON='ON'
    OP='OP'


class ContextControlAdditive(str, Enum):
    AN='AN'
    AP='AP'


class ContextControlAdditiveNon_propagating(str, Enum):
    AN='AN'


class ContextControlAdditivePropagating(str, Enum):
    AP='AP'


class ContextControlNonPropagating(str, Enum):
    AN='AN'
    ON='ON'


class ContextControlOverriding(str, Enum):
    ON='ON'
    OP='OP'


class ContextControlOverridingNon_propagating(str, Enum):
    ON='ON'


class ContextControlOverridingPropagating(str, Enum):
    OP='OP'


class ContextControlPropagating(str, Enum):
    AP='AP'
    OP='OP'


class DeliveryAddressLine(str, Enum):
    DAL='DAL'


class EntityClass(str, Enum):
    ANM='ANM'
    CER='CER'
    CHEM='CHEM'
    CITY='CITY'
    CONT='CONT'
    COUNTRY='COUNTRY'
    COUNTY='COUNTY'
    DEV='DEV'
    ENT='ENT'
    FOOD='FOOD'
    HCE='HCE'
    HOLD='HOLD'
    LIV='LIV'
    MAT='MAT'
    MIC='MIC'
    MMAT='MMAT'
    MODDV='MODDV'
    NAT='NAT'
    NLIV='NLIV'
    ORG='ORG'
    PLC='PLC'
    PLNT='PLNT'
    PROVINCE='PROVINCE'
    PSN='PSN'
    PUB='PUB'
    RGRP='RGRP'
    STATE='STATE'


class EntityClassAnimal(str, Enum):
    ANM='ANM'


class EntityClassCertificateRepresentation(str, Enum):
    CER='CER'


class EntityClassChemicalSubstance(str, Enum):
    CHEM='CHEM'


class EntityClassCityOrTown(str, Enum):
    CITY='CITY'


class EntityClassContainer(str, Enum):
    CONT='CONT'
    HOLD='HOLD'


class EntityClassCountry(str, Enum):
    COUNTRY='COUNTRY'


class EntityClassCountyOrParish(str, Enum):
    COUNTY='COUNTY'


class EntityClassDevice(str, Enum):
    DEV='DEV'
    CER='CER'
    MODDV='MODDV'


class EntityClassFood(str, Enum):
    FOOD='FOOD'


class EntityClassGroup(str, Enum):
    RGRP='RGRP'


class EntityClassHealthChartEntity(str, Enum):
    HCE='HCE'


class EntityClassHolder(str, Enum):
    HOLD='HOLD'


class EntityClassImagingModality(str, Enum):
    MODDV='MODDV'


class EntityClassLivingSubject(str, Enum):
    LIV='LIV'
    NLIV='NLIV'
    ANM='ANM'
    MIC='MIC'
    PLNT='PLNT'
    PSN='PSN'


class EntityClassManufacturedMaterial(str, Enum):
    MMAT='MMAT'
    CONT='CONT'
    HOLD='HOLD'
    DEV='DEV'
    CER='CER'
    MODDV='MODDV'


class EntityClassMaterial(str, Enum):
    MAT='MAT'
    CHEM='CHEM'
    FOOD='FOOD'
    MMAT='MMAT'
    CONT='CONT'
    HOLD='HOLD'
    DEV='DEV'
    CER='CER'
    MODDV='MODDV'


class EntityClassMicroorganism(str, Enum):
    MIC='MIC'


class EntityClassNation(str, Enum):
    NAT='NAT'


class EntityClassNonPersonLivingSubject(str, Enum):
    NLIV='NLIV'
    ANM='ANM'
    MIC='MIC'
    PLNT='PLNT'


class EntityClassOrganization(str, Enum):
    ORG='ORG'
    PUB='PUB'
    STATE='STATE'
    NAT='NAT'


class EntityClassPerson(str, Enum):
    PSN='PSN'


class EntityClassPlace(str, Enum):
    PLC='PLC'
    CITY='CITY'
    COUNTRY='COUNTRY'
    COUNTY='COUNTY'
    PROVINCE='PROVINCE'


class EntityClassPlant(str, Enum):
    PLNT='PLNT'


class EntityClassPublicInstitution(str, Enum):
    PUB='PUB'


class EntityClassRoot(str, Enum):
    ENT='ENT'
    HCE='HCE'
    LIV='LIV'
    NLIV='NLIV'
    ANM='ANM'
    MIC='MIC'
    PLNT='PLNT'
    PSN='PSN'
    MAT='MAT'
    CHEM='CHEM'
    FOOD='FOOD'
    MMAT='MMAT'
    CONT='CONT'
    HOLD='HOLD'
    DEV='DEV'
    CER='CER'
    MODDV='MODDV'
    ORG='ORG'
    PUB='PUB'
    STATE='STATE'
    NAT='NAT'
    PLC='PLC'
    CITY='CITY'
    COUNTRY='COUNTRY'
    COUNTY='COUNTY'
    PROVINCE='PROVINCE'
    RGRP='RGRP'


class EntityClassState(str, Enum):
    STATE='STATE'
    NAT='NAT'


class EntityClassStateOrProvince(str, Enum):
    PROVINCE='PROVINCE'


class EntityDeterminer(str, Enum):
    INSTANCE='INSTANCE'
    KIND='KIND'
    QUANTIFIED_KIND='QUANTIFIED_KIND'


class EntityDeterminerDescribedQuantified(str, Enum):
    QUANTIFIED_KIND='QUANTIFIED_KIND'


class EntityDeterminerDetermined(str, Enum):
    KIND='KIND'
    QUANTIFIED_KIND='QUANTIFIED_KIND'


class EntityDeterminerSpecific(str, Enum):
    INSTANCE='INSTANCE'


class EntityNamePartQualifier(str, Enum):
    AC='AC'
    AD='AD'
    BR='BR'
    CL='CL'
    CON='CON'
    DEV='DEV'
    FRM='FRM'
    IN='IN'
    INV='INV'
    LS='LS'
    NB='NB'
    PR='PR'
    SCI='SCI'
    SP='SP'
    STR='STR'
    TITLE='TITLE'
    TMK='TMK'
    USE='USE'
    VV='VV'


class EntityNamePartQualifierR2(str, Enum):
    AC='AC'
    AD='AD'
    BR='BR'
    CL='CL'
    CON='CON'
    DEV='DEV'
    FRM='FRM'
    HOM='HOM'
    IN='IN'
    INV='INV'
    LS='LS'
    MID='MID'
    NB='NB'
    PFX='PFX'
    PR='PR'
    SCI='SCI'
    SFX='SFX'
    SP='SP'
    STR='STR'
    TMK='TMK'
    USE='USE'


class EntityNamePartType(str, Enum):
    DEL='DEL'
    FAM='FAM'
    GIV='GIV'
    PFX='PFX'
    SFX='SFX'


class EntityNamePartTypeR2(str, Enum):
    DEL='DEL'
    FAM='FAM'
    GIV='GIV'
    TITLE='TITLE'


class EntityNameUse(str, Enum):
    A='A'
    ABC='ABC'
    ASGN='ASGN'
    C='C'
    I='I'
    IDE='IDE'
    L='L'
    OR='OR'
    P='P'
    PHON='PHON'
    R='R'
    SNDX='SNDX'
    SRCH='SRCH'
    SYL='SYL'


class EntityNameUseR2(str, Enum):
    A='A'
    ABC='ABC'
    ANON='ANON'
    ASSUMED='Assumed'
    DN='DN'
    I='I'
    IDE='IDE'
    M='M'
    N='N'
    NAME_REPRESENTATION_USE='NameRepresentationUse'
    OLD='OLD'
    OR='OR'
    P='P'
    PHON='PHON'
    R='R'
    SRCH='SRCH'
    SYL='SYL'
    T='T'


class EntityStatus(str, Enum):
    ACTIVE='active'
    INACTIVE='inactive'
    NORMAL='normal'
    NULLIFIED='nullified'


class EntityStatusActive(str, Enum):
    ACTIVE='active'


class EntityStatusInactive(str, Enum):
    INACTIVE='inactive'


class EntityStatusNormal(str, Enum):
    NORMAL='normal'
    ACTIVE='active'
    INACTIVE='inactive'


class EntityStatusNullified(str, Enum):
    NULLIFIED='nullified'


class GeneralAddressUse(str, Enum):
    BAD='BAD'
    CONF='CONF'
    H='H'
    HP='HP'
    HV='HV'
    TMP='TMP'
    WP='WP'
    DIR='DIR'
    PUB='PUB'


class HL7CalendarCycle(str, Enum):
    CD='CD'
    CH='CH'
    CM='CM'
    CN='CN'
    CS='CS'
    CW='CW'
    CY='CY'
    DM='DM'
    DW='DW'
    DY='DY'
    HD='HD'
    MY='MY'
    NH='NH'
    SN='SN'
    WY='WY'


class HL7ITSVersionCode(str, Enum):
    XMLV_1_PR_1='XMLV1PR1'


class HL7SearchUse(str, Enum):
    SRCH='SRCH'
    PHON='PHON'
    SNDX='SNDX'


class HL7StandardVersionCode(str, Enum):
    BALLOT_2008_JAN='Ballot2008Jan'
    BALLOT_2008_MAY='Ballot2008May'
    BALLOT_2008_SEP='Ballot2008Sep'
    BALLOT_2009_JAN='Ballot2009Jan'
    BALLOT_2009_MAY='Ballot2009May'
    BALLOT_2009_SEP='Ballot2009Sep'
    V_3_2003_12='V3-2003-12'
    V_3_2005_N='V3-2005N'
    V_3_2006_N='V3-2006N'
    V_3_2007_N='V3-2007N'
    V_3_PR_1='V3PR1'


class HL7UpdateMode(str, Enum):
    A='A'
    AR='AR'
    D='D'
    K='K'
    N='N'
    R='R'
    REF='REF'
    U='U'


class HomeAddress(str, Enum):
    H='H'
    HP='HP'
    HV='HV'


class IdentifierReliability(str, Enum):
    ISS='ISS'
    UNV='UNV'
    VER='VER'


class IdentifierScope(str, Enum):
    BUSN='BUSN'
    OBJ='OBJ'
    VER='VER'
    VW='VW'


class ImageMediaType(str, Enum):
    IMAGEG_3_FAX='image/g3fax'
    IMAGEGIF='image/gif'
    IMAGEJPEG='image/jpeg'
    IMAGEPNG='image/png'
    IMAGETIFF='image/tiff'


class IntegrityCheckAlgorithm(str, Enum):
    SHA_1='SHA-1'
    SHA_256='SHA-256'


class ManagedParticipationStatus(str, Enum):
    ACTIVE='active'
    CANCELLED='cancelled'
    COMPLETED='completed'
    NORMAL='normal'
    NULLIFIED='nullified'
    PENDING='pending'


class ManagedParticipationStatusActive(str, Enum):
    ACTIVE='active'


class ManagedParticipationStatusCancelled(str, Enum):
    CANCELLED='cancelled'


class ManagedParticipationStatusCompleted(str, Enum):
    COMPLETED='completed'


class ManagedParticipationStatusNormal(str, Enum):
    NORMAL='normal'
    ACTIVE='active'
    CANCELLED='cancelled'
    COMPLETED='completed'
    PENDING='pending'


class ManagedParticipationStatusNullified(str, Enum):
    NULLIFIED='nullified'


class ManagedParticipationStatusPending(str, Enum):
    PENDING='pending'


class MediaType(str, Enum):
    APPLICATION='application'
    APPLICATIONDICOM='application/dicom'
    APPLICATIONMSWORD='application/msword'
    APPLICATIONPDF='application/pdf'
    AUDIO='audio'
    AUDIOBASIC='audio/basic'
    AUDIOK_32_ADPCM='audio/k32adpcm'
    AUDIOMPEG='audio/mpeg'
    IMAGE='image'
    IMAGEG_3_FAX='image/g3fax'
    IMAGEGIF='image/gif'
    IMAGEJPEG='image/jpeg'
    IMAGEPNG='image/png'
    IMAGETIFF='image/tiff'
    MODEL='model'
    MODELVRML='model/vrml'
    MULTIPART='multipart'
    MULTIPARTXHL_7CDALEVELONE='multipart/x-hl7-cda-level-one'
    TEXT='text'
    TEXTHTML='text/html'
    TEXTPLAIN='text/plain'
    TEXTRTF='text/rtf'
    TEXTSGML='text/sgml'
    TEXTXHL_7FT='text/x-hl7-ft'
    TEXTXHL_7TEXTXML='text/x-hl7-text+xml'
    TEXTXML='text/xml'
    VIDEO='video'
    VIDEOMPEG='video/mpeg'
    VIDEOXAVI='video/x-avi'


class MessageWaitingPriority(str, Enum):
    H='H'
    L='L'
    M='M'


class ModelMediaType(str, Enum):
    MODELVRML='model/vrml'


class ModifyIndicator(str, Enum):
    M='M'
    N='N'


class MultipartMediaType(str, Enum):
    MULTIPARTXHL_7CDALEVELONE='multipart/x-hl7-cda-level-one'


class NameLegalUse(str, Enum):
    L='L'
    OR='OR'


class NoInformation(str, Enum):
    NI='NI'
    INV='INV'
    DER='DER'
    OTH='OTH'
    NINF='NINF'
    PINF='PINF'
    UNC='UNC'
    MSK='MSK'
    NA='NA'
    UNK='UNK'
    ASKU='ASKU'
    NAV='NAV'
    NASK='NASK'
    QS='QS'
    TRC='TRC'


class NullFlavor(str, Enum):
    ASKU='ASKU'
    DER='DER'
    INV='INV'
    MSK='MSK'
    NA='NA'
    NASK='NASK'
    NAV='NAV'
    NI='NI'
    NINF='NINF'
    OTH='OTH'
    PINF='PINF'
    QS='QS'
    TRC='TRC'
    UNC='UNC'
    UNK='UNK'


class OrganizationNamePartQualifier(str, Enum):
    AC='AC'
    AD='AD'
    BR='BR'
    CL='CL'
    IN='IN'
    LS='LS'
    NB='NB'
    PR='PR'
    SP='SP'
    TITLE='TITLE'
    VV='VV'


class OrganizationNameUse(str, Enum):
    ABC='ABC'
    IDE='IDE'
    SYL='SYL'


class Other(str, Enum):
    OTH='OTH'
    NINF='NINF'
    PINF='PINF'


class ParticipationAdmitter(str, Enum):
    ADM='ADM'


class ParticipationAnalyte(str, Enum):
    ALY='ALY'


class ParticipationAncillary(str, Enum):
    ADM='ADM'
    ATND='ATND'
    CALLBCK='CALLBCK'
    CON='CON'
    DIS='DIS'
    ESC='ESC'
    REF='REF'


class ParticipationAttender(str, Enum):
    ATND='ATND'


class ParticipationAuthenticator(str, Enum):
    AUTHEN='AUTHEN'


class ParticipationAuthorOriginator(str, Enum):
    AUT='AUT'


class ParticipationBaby(str, Enum):
    BBY='BBY'


class ParticipationBeneficiary(str, Enum):
    BEN='BEN'


class ParticipationCallbackContact(str, Enum):
    CALLBCK='CALLBCK'


class ParticipationCatalyst(str, Enum):
    CAT='CAT'


class ParticipationCausativeAgent(str, Enum):
    CAGNT='CAGNT'


class ParticipationConsultant(str, Enum):
    CON='CON'


class ParticipationConsumable(str, Enum):
    CSM='CSM'


class ParticipationCoverageTarget(str, Enum):
    COV='COV'


class ParticipationCustodian(str, Enum):
    CST='CST'


class ParticipationDataEntryPerson(str, Enum):
    ENT='ENT'


class ParticipationDestination(str, Enum):
    DST='DST'


class ParticipationDischarger(str, Enum):
    DIS='DIS'


class ParticipationDistributor(str, Enum):
    DIST='DIST'


class ParticipationDonor(str, Enum):
    DON='DON'


class ParticipationEntryLocation(str, Enum):
    ELOC='ELOC'


class ParticipationEscort(str, Enum):
    ESC='ESC'


class ParticipationExposureagent(str, Enum):
    EXPAGNT='EXPAGNT'


class ParticipationExposureparticipation(str, Enum):
    EXPART='EXPART'
    EXPTRGT='EXPTRGT'
    EXSRC='EXSRC'


class ParticipationExposuresource(str, Enum):
    EXSRC='EXSRC'


class ParticipationExposuretarget(str, Enum):
    EXPTRGT='EXPTRGT'


class ParticipationGuarantorParty(str, Enum):
    GUAR='GUAR'


class ParticipationHolder(str, Enum):
    HLD='HLD'


class ParticipationIndirectTarget(str, Enum):
    IND='IND'
    BEN='BEN'
    CAGNT='CAGNT'
    COV='COV'
    GUAR='GUAR'
    HLD='HLD'
    RCT='RCT'
    RCV='RCV'


class ParticipationInformant(str, Enum):
    INF='INF'


class ParticipationInformationGenerator(str, Enum):
    AUT='AUT'
    INF='INF'
    TRANS='TRANS'
    ENT='ENT'
    WIT='WIT'


class ParticipationInformationRecipient(str, Enum):
    IRCP='IRCP'
    NOT='NOT'
    PRCP='PRCP'
    REFB='REFB'
    REFT='REFT'
    TRC='TRC'


class ParticipationInformationTranscriber(str, Enum):
    TRANS='TRANS'
    ENT='ENT'


class ParticipationLegalAuthenticator(str, Enum):
    LA='LA'


class ParticipationNon_reuseableDevice(str, Enum):
    NRD='NRD'


class ParticipationOrigin(str, Enum):
    ORG='ORG'


class ParticipationParticipation(str, Enum):
    PART='PART'
    ADM='ADM'
    ATND='ATND'
    CALLBCK='CALLBCK'
    CON='CON'
    DIS='DIS'
    ESC='ESC'
    REF='REF'
    AUT='AUT'
    INF='INF'
    TRANS='TRANS'
    ENT='ENT'
    WIT='WIT'
    CST='CST'
    DIR='DIR'
    ALY='ALY'
    BBY='BBY'
    CAT='CAT'
    CSM='CSM'
    DEV='DEV'
    NRD='NRD'
    RDV='RDV'
    DON='DON'
    EXPAGNT='EXPAGNT'
    EXPART='EXPART'
    EXPTRGT='EXPTRGT'
    EXSRC='EXSRC'
    PRD='PRD'
    SBJ='SBJ'
    SPC='SPC'
    IND='IND'
    BEN='BEN'
    CAGNT='CAGNT'
    COV='COV'
    GUAR='GUAR'
    HLD='HLD'
    RCT='RCT'
    RCV='RCV'
    IRCP='IRCP'
    NOT='NOT'
    PRCP='PRCP'
    REFB='REFB'
    REFT='REFT'
    TRC='TRC'
    LOC='LOC'
    DST='DST'
    ELOC='ELOC'
    ORG='ORG'
    RML='RML'
    VIA='VIA'
    PRF='PRF'
    DIST='DIST'
    PPRF='PPRF'
    SPRF='SPRF'
    RESP='RESP'
    VRF='VRF'
    AUTHEN='AUTHEN'
    LA='LA'


class ParticipationPhysicalPerformer(str, Enum):
    PRF='PRF'
    DIST='DIST'
    PPRF='PPRF'
    SPRF='SPRF'


class ParticipationPrimaryInformationRecipient(str, Enum):
    PRCP='PRCP'


class ParticipationPrimaryPerformer(str, Enum):
    PPRF='PPRF'


class ParticipationProduct(str, Enum):
    PRD='PRD'


class ParticipationReceiver(str, Enum):
    RCV='RCV'


class ParticipationRecordTarget(str, Enum):
    RCT='RCT'


class ParticipationReferredBy(str, Enum):
    REFB='REFB'


class ParticipationReferredTo(str, Enum):
    REFT='REFT'


class ParticipationReferrer(str, Enum):
    REF='REF'


class ParticipationRemote(str, Enum):
    RML='RML'


class ParticipationResponsibleParty(str, Enum):
    RESP='RESP'


class ParticipationReusableDevice(str, Enum):
    RDV='RDV'


class ParticipationSecondaryPerformer(str, Enum):
    SPRF='SPRF'


class ParticipationSpecimen(str, Enum):
    SPC='SPC'


class ParticipationTargetDevice(str, Enum):
    DEV='DEV'
    NRD='NRD'
    RDV='RDV'


class ParticipationTargetDirect(str, Enum):
    DIR='DIR'
    ALY='ALY'
    BBY='BBY'
    CAT='CAT'
    CSM='CSM'
    DEV='DEV'
    NRD='NRD'
    RDV='RDV'
    DON='DON'
    EXPAGNT='EXPAGNT'
    EXPART='EXPART'
    EXPTRGT='EXPTRGT'
    EXSRC='EXSRC'
    PRD='PRD'
    SBJ='SBJ'
    SPC='SPC'


class ParticipationTargetLocation(str, Enum):
    LOC='LOC'
    DST='DST'
    ELOC='ELOC'
    ORG='ORG'
    RML='RML'
    VIA='VIA'


class ParticipationTargetSubject(str, Enum):
    SBJ='SBJ'
    SPC='SPC'


class ParticipationTracker(str, Enum):
    TRC='TRC'


class ParticipationType(str, Enum):
    ADM='ADM'
    ALY='ALY'
    ATND='ATND'
    AUT='AUT'
    AUTHEN='AUTHEN'
    BBY='BBY'
    BEN='BEN'
    CAGNT='CAGNT'
    CALLBCK='CALLBCK'
    CAT='CAT'
    CON='CON'
    COV='COV'
    CSM='CSM'
    CST='CST'
    DEV='DEV'
    DIR='DIR'
    DIS='DIS'
    DIST='DIST'
    DON='DON'
    DST='DST'
    ELOC='ELOC'
    ENT='ENT'
    ESC='ESC'
    EXPAGNT='EXPAGNT'
    EXPART='EXPART'
    EXPTRGT='EXPTRGT'
    EXSRC='EXSRC'
    GUAR='GUAR'
    HLD='HLD'
    IND='IND'
    INF='INF'
    IRCP='IRCP'
    LA='LA'
    LOC='LOC'
    NOT='NOT'
    NRD='NRD'
    ORG='ORG'
    PART='PART'
    PPRF='PPRF'
    PRCP='PRCP'
    PRD='PRD'
    PRF='PRF'
    RCT='RCT'
    RCV='RCV'
    RDV='RDV'
    REF='REF'
    REFB='REFB'
    REFT='REFT'
    RESP='RESP'
    RML='RML'
    SBJ='SBJ'
    SPC='SPC'
    SPRF='SPRF'
    TRANS='TRANS'
    TRC='TRC'
    VIA='VIA'
    VRF='VRF'
    WIT='WIT'


class ParticipationUgentNotificationContact(str, Enum):
    NOT='NOT'


class ParticipationVerifier(str, Enum):
    VRF='VRF'
    AUTHEN='AUTHEN'
    LA='LA'


class ParticipationVia(str, Enum):
    VIA='VIA'


class ParticipationWitness(str, Enum):
    WIT='WIT'


class PersonNameUse(str, Enum):
    ABC='ABC'
    IDE='IDE'
    SYL='SYL'


class PostalAddressUse(str, Enum):
    BAD='BAD'
    CONF='CONF'
    DIR='DIR'
    H='H'
    HP='HP'
    HV='HV'
    PHYS='PHYS'
    PST='PST'
    PUB='PUB'
    TMP='TMP'
    WP='WP'


class ProbabilityDistributionType(str, Enum):
    B='B'
    E='E'
    F='F'
    G='G'
    LN='LN'
    N='N'
    T='T'
    U='U'
    X_2='X2'


class ProcessingID(str, Enum):
    D='D'
    P='P'
    T='T'


class ProcessingMode(str, Enum):
    A='A'
    I='I'
    R='R'
    T='T'


class QueryPriority(str, Enum):
    D='D'
    I='I'


class QueryRequestLimit(str, Enum):
    RD='RD'


class QueryResponse(str, Enum):
    AE='AE'
    NF='NF'
    OK='OK'
    QE='QE'


class QueryStatusCode(str, Enum):
    ABORTED='aborted'
    DELIVERED_RESPONSE='deliveredResponse'
    EXECUTING='executing'
    NEW='new'
    WAIT_CONTINUED_QUERY_RESPONSE='waitContinuedQueryResponse'


class ReactionParticipant(str, Enum):
    CAT='CAT'
    CSM='CSM'
    PRD='PRD'


class RelationalOperator(str, Enum):
    CT='CT'
    EQ='EQ'
    GE='GE'
    GN='GN'
    GT='GT'
    LE='LE'
    LT='LT'
    NE='NE'


class RelationshipConjunction(str, Enum):
    AND='AND'
    OR='OR'
    XOR='XOR'


class ResponseLevel(str, Enum):
    C='C'
    D='D'
    E='E'
    F='F'
    N='N'
    R='R'
    X='X'


class ResponseModality(str, Enum):
    B='B'
    R='R'
    T='T'


class RoleClass(str, Enum):
    ACCESS='ACCESS'
    ACTI='ACTI'
    ACTIB='ACTIB'
    ACTIM='ACTIM'
    ACTIR='ACTIR'
    ACTM='ACTM'
    ADJV='ADJV'
    ADJY='ADJY'
    ADMM='ADMM'
    ADTV='ADTV'
    AFFL='AFFL'
    AGNT='AGNT'
    ALQT='ALQT'
    ASSIGNED='ASSIGNED'
    BASE='BASE'
    BIRTHPL='BIRTHPL'
    BOND='BOND'
    CAREGIVER='CAREGIVER'
    CASEBJ='CASEBJ'
    CHILD='CHILD'
    CIT='CIT'
    CLAIM='CLAIM'
    COLR='COLR'
    COMPAR='COMPAR'
    CON='CON'
    CONC='CONC'
    CONT='CONT'
    CONY='CONY'
    COVPTY='COVPTY'
    CRED='CRED'
    CRINV='CRINV'
    CRSPNSR='CRSPNSR'
    DEATHPLC='DEATHPLC'
    DEPEN='DEPEN'
    DSDLOC='DSDLOC'
    DST='DST'
    ECON='ECON'
    EMP='EMP'
    EQUIV='EQUIV'
    EXPAGTCAR='EXPAGTCAR'
    EXPR='EXPR'
    EXPVECTOR='EXPVECTOR'
    FLVR='FLVR'
    FOMITE='FOMITE'
    GEN='GEN'
    GRIC='GRIC'
    GUAR='GUAR'
    GUARD='GUARD'
    HLD='HLD'
    HLTHCHRT='HLTHCHRT'
    IACT='IACT'
    IDENT='IDENT'
    INDIV='INDIV'
    INGR='INGR'
    INST='INST'
    INVSBJ='INVSBJ'
    ISDLOC='ISDLOC'
    ISLT='ISLT'
    LIC='LIC'
    LOCE='LOCE'
    MANU='MANU'
    MBR='MBR'
    MECH='MECH'
    MIL='MIL'
    MNT='MNT'
    NAMED='NAMED'
    NOK='NOK'
    NOT='NOT'
    NURPRAC='NURPRAC'
    NURS='NURS'
    OWN='OWN'
    PA='PA'
    PART='PART'
    PAT='PAT'
    PAYEE='PAYEE'
    PAYOR='PAYOR'
    PHYS='PHYS'
    POLHOLD='POLHOLD'
    PROG='PROG'
    PROV='PROV'
    PRS='PRS'
    PRSV='PRSV'
    QUAL='QUAL'
    RESBJ='RESBJ'
    RET='RET'
    RGPR='RGPR'
    ROL='ROL'
    SAME='SAME'
    SDLOC='SDLOC'
    SGNOFF='SGNOFF'
    SPEC='SPEC'
    SPNSR='SPNSR'
    STBL='STBL'
    STD='STD'
    STOR='STOR'
    SUBS='SUBS'
    SUBSCR='SUBSCR'
    SUBY='SUBY'
    TERR='TERR'
    THER='THER'
    UNDWRT='UNDWRT'
    USED='USED'
    WRTE='WRTE'


class RoleClassAccess(str, Enum):
    ACCESS='ACCESS'


class RoleClassActiveIngredient(str, Enum):
    ACTI='ACTI'
    ACTIB='ACTIB'
    ACTIM='ACTIM'
    ACTIR='ACTIR'


class RoleClassActiveIngredientBasis(str, Enum):
    ACTIB='ACTIB'


class RoleClassActiveIngredientMoietyBasis(str, Enum):
    ACTIM='ACTIM'


class RoleClassActiveIngredientReferenceBasis(str, Enum):
    ACTIR='ACTIR'


class RoleClassActiveMoiety(str, Enum):
    ACTM='ACTM'


class RoleClassAdditive(str, Enum):
    ADTV='ADTV'


class RoleClassAdjacency(str, Enum):
    ADJY='ADJY'
    CONC='CONC'
    BOND='BOND'
    CONY='CONY'


class RoleClassAdjuvant(str, Enum):
    ADJV='ADJV'


class RoleClassAdministerableMaterial(str, Enum):
    ADMM='ADMM'


class RoleClassAffiliate(str, Enum):
    AFFL='AFFL'


class RoleClassAgent(str, Enum):
    AGNT='AGNT'
    ASSIGNED='ASSIGNED'
    COMPAR='COMPAR'
    SGNOFF='SGNOFF'
    CON='CON'
    ECON='ECON'
    NOK='NOK'
    GUARD='GUARD'


class RoleClassAliquot(str, Enum):
    ALQT='ALQT'


class RoleClassAssignedEntity(str, Enum):
    ASSIGNED='ASSIGNED'
    COMPAR='COMPAR'
    CON='CON'
    ECON='ECON'
    NOK='NOK'
    SGNOFF='SGNOFF'


class RoleClassAssociative(str, Enum):
    AFFL='AFFL'
    AGNT='AGNT'
    ASSIGNED='ASSIGNED'
    COMPAR='COMPAR'
    SGNOFF='SGNOFF'
    CON='CON'
    ECON='ECON'
    NOK='NOK'
    GUARD='GUARD'
    CIT='CIT'
    COVPTY='COVPTY'
    CLAIM='CLAIM'
    NAMED='NAMED'
    DEPEN='DEPEN'
    INDIV='INDIV'
    SUBSCR='SUBSCR'
    PROG='PROG'
    CRINV='CRINV'
    CRSPNSR='CRSPNSR'
    EMP='EMP'
    MIL='MIL'
    GUAR='GUAR'
    INVSBJ='INVSBJ'
    CASEBJ='CASEBJ'
    RESBJ='RESBJ'
    LIC='LIC'
    NOT='NOT'
    PROV='PROV'
    PAT='PAT'
    PAYEE='PAYEE'
    PAYOR='PAYOR'
    POLHOLD='POLHOLD'
    QUAL='QUAL'
    SPNSR='SPNSR'
    STD='STD'
    UNDWRT='UNDWRT'
    CAREGIVER='CAREGIVER'
    PRS='PRS'
    ACCESS='ACCESS'
    ADJY='ADJY'
    CONC='CONC'
    BOND='BOND'
    CONY='CONY'
    ADMM='ADMM'
    BIRTHPL='BIRTHPL'
    DEATHPLC='DEATHPLC'
    DST='DST'
    RET='RET'
    EXPR='EXPR'
    HLD='HLD'
    HLTHCHRT='HLTHCHRT'
    IDENT='IDENT'
    MANU='MANU'
    THER='THER'
    MNT='MNT'
    OWN='OWN'
    RGPR='RGPR'
    SDLOC='SDLOC'
    DSDLOC='DSDLOC'
    ISDLOC='ISDLOC'
    TERR='TERR'
    USED='USED'
    WRTE='WRTE'


class RoleClassBase(str, Enum):
    BASE='BASE'


class RoleClassBirthplace(str, Enum):
    BIRTHPL='BIRTHPL'


class RoleClassCaregiver(str, Enum):
    CAREGIVER='CAREGIVER'


class RoleClassCaseSubject(str, Enum):
    CASEBJ='CASEBJ'


class RoleClassChild(str, Enum):
    CHILD='CHILD'


class RoleClassCitizen(str, Enum):
    CIT='CIT'


class RoleClassClaimant(str, Enum):
    CLAIM='CLAIM'


class RoleClassClinicalResearchInvestigator(str, Enum):
    CRINV='CRINV'


class RoleClassClinicalResearchSponsor(str, Enum):
    CRSPNSR='CRSPNSR'


class RoleClassColorAdditive(str, Enum):
    COLR='COLR'


class RoleClassCommissioningParty(str, Enum):
    COMPAR='COMPAR'


class RoleClassConnection(str, Enum):
    CONC='CONC'
    BOND='BOND'
    CONY='CONY'


class RoleClassContact(str, Enum):
    CON='CON'
    ECON='ECON'
    NOK='NOK'


class RoleClassContactCode(str, Enum):
    ECON='ECON'
    NOK='NOK'


class RoleClassContent(str, Enum):
    CONT='CONT'


class RoleClassContinuity(str, Enum):
    CONY='CONY'


class RoleClassCoverageSponsor(str, Enum):
    SPNSR='SPNSR'


class RoleClassCoveredParty(str, Enum):
    COVPTY='COVPTY'
    CLAIM='CLAIM'
    NAMED='NAMED'
    DEPEN='DEPEN'
    INDIV='INDIV'
    SUBSCR='SUBSCR'
    PROG='PROG'


class RoleClassCredentialedEntity(str, Enum):
    CRED='CRED'


class RoleClassDedicatedServiceDeliveryLocation(str, Enum):
    DSDLOC='DSDLOC'


class RoleClassDependent(str, Enum):
    DEPEN='DEPEN'


class RoleClassDistributedMaterial(str, Enum):
    DST='DST'
    RET='RET'


class RoleClassEmergencyContact(str, Enum):
    ECON='ECON'


class RoleClassEmployee(str, Enum):
    EMP='EMP'
    MIL='MIL'


class RoleClassEquivalentEntity(str, Enum):
    EQUIV='EQUIV'
    SAME='SAME'
    SUBY='SUBY'


class RoleClassExposedEntity(str, Enum):
    EXPR='EXPR'


class RoleClassExposureAgentCarrier(str, Enum):
    EXPAGTCAR='EXPAGTCAR'
    EXPVECTOR='EXPVECTOR'
    FOMITE='FOMITE'


class RoleClassExposureVector(str, Enum):
    EXPVECTOR='EXPVECTOR'


class RoleClassFlavorAdditive(str, Enum):
    FLVR='FLVR'


class RoleClassFomite(str, Enum):
    FOMITE='FOMITE'


class RoleClassGuarantor(str, Enum):
    GUAR='GUAR'


class RoleClassGuardian(str, Enum):
    GUARD='GUARD'


class RoleClassHasGeneric(str, Enum):
    GRIC='GRIC'


class RoleClassHealthChart(str, Enum):
    HLTHCHRT='HLTHCHRT'


class RoleClassHealthcareProvider(str, Enum):
    PROV='PROV'


class RoleClassHeldEntity(str, Enum):
    HLD='HLD'


class RoleClassICSRInvestigationSubject(str, Enum):
    CASEBJ='CASEBJ'
    INVSBJ='INVSBJ'
    PAT='PAT'
    RESBJ='RESBJ'


class RoleClassIdentifiedEntity(str, Enum):
    IDENT='IDENT'


class RoleClassInactiveIngredient(str, Enum):
    IACT='IACT'
    COLR='COLR'
    FLVR='FLVR'
    PRSV='PRSV'
    STBL='STBL'


class RoleClassIncidentalServiceDeliveryLocation(str, Enum):
    ISDLOC='ISDLOC'


class RoleClassIndividual(str, Enum):
    INDIV='INDIV'


class RoleClassIngredientEntity(str, Enum):
    INGR='INGR'
    ACTI='ACTI'
    ACTIB='ACTIB'
    ACTIM='ACTIM'
    ACTIR='ACTIR'
    ADJV='ADJV'
    ADTV='ADTV'
    BASE='BASE'
    IACT='IACT'
    COLR='COLR'
    FLVR='FLVR'
    PRSV='PRSV'
    STBL='STBL'
    MECH='MECH'


class RoleClassInstance(str, Enum):
    INST='INST'


class RoleClassInvestigationSubject(str, Enum):
    INVSBJ='INVSBJ'
    CASEBJ='CASEBJ'
    RESBJ='RESBJ'


class RoleClassInvoicePayor(str, Enum):
    PAYOR='PAYOR'


class RoleClassIsSpeciesEntity(str, Enum):
    GEN='GEN'
    GRIC='GRIC'


class RoleClassIsolate(str, Enum):
    ISLT='ISLT'


class RoleClassLicensedEntity(str, Enum):
    LIC='LIC'
    NOT='NOT'
    PROV='PROV'


class RoleClassLocatedEntity(str, Enum):
    LOCE='LOCE'
    STOR='STOR'


class RoleClassMaintainedEntity(str, Enum):
    MNT='MNT'


class RoleClassManagedEntity(str, Enum):
    ACCESS='ACCESS'
    HLD='HLD'
    MNT='MNT'
    OWN='OWN'


class RoleClassManufacturedProduct(str, Enum):
    MANU='MANU'
    THER='THER'


class RoleClassMechanicalIngredient(str, Enum):
    MECH='MECH'


class RoleClassMember(str, Enum):
    MBR='MBR'


class RoleClassMilitaryPerson(str, Enum):
    MIL='MIL'


class RoleClassMolecularBond(str, Enum):
    BOND='BOND'


class RoleClassMolecularFeatures(str, Enum):
    BOND='BOND'
    PART='PART'


class RoleClassMolecularPart(str, Enum):
    ACTM='ACTM'
    PART='PART'


class RoleClassMutualRelationship(str, Enum):
    AFFL='AFFL'
    AGNT='AGNT'
    ASSIGNED='ASSIGNED'
    COMPAR='COMPAR'
    SGNOFF='SGNOFF'
    CON='CON'
    ECON='ECON'
    NOK='NOK'
    GUARD='GUARD'
    CIT='CIT'
    COVPTY='COVPTY'
    CLAIM='CLAIM'
    NAMED='NAMED'
    DEPEN='DEPEN'
    INDIV='INDIV'
    SUBSCR='SUBSCR'
    PROG='PROG'
    CRINV='CRINV'
    CRSPNSR='CRSPNSR'
    EMP='EMP'
    MIL='MIL'
    GUAR='GUAR'
    INVSBJ='INVSBJ'
    CASEBJ='CASEBJ'
    RESBJ='RESBJ'
    LIC='LIC'
    NOT='NOT'
    PROV='PROV'
    PAT='PAT'
    PAYEE='PAYEE'
    PAYOR='PAYOR'
    POLHOLD='POLHOLD'
    QUAL='QUAL'
    SPNSR='SPNSR'
    STD='STD'
    UNDWRT='UNDWRT'
    CAREGIVER='CAREGIVER'
    PRS='PRS'


class RoleClassNamedInsured(str, Enum):
    NAMED='NAMED'
    DEPEN='DEPEN'
    INDIV='INDIV'
    SUBSCR='SUBSCR'


class RoleClassNextOfKin(str, Enum):
    NOK='NOK'


class RoleClassNotaryPublic(str, Enum):
    NOT='NOT'


class RoleClassNurse(str, Enum):
    NURS='NURS'


class RoleClassNursePractitioner(str, Enum):
    NURPRAC='NURPRAC'


class RoleClassOntological(str, Enum):
    EQUIV='EQUIV'
    SAME='SAME'
    SUBY='SUBY'
    GEN='GEN'
    GRIC='GRIC'
    INST='INST'
    SUBS='SUBS'


class RoleClassOwnedEntity(str, Enum):
    OWN='OWN'


class RoleClassPart(str, Enum):
    PART='PART'
    ACTM='ACTM'


class RoleClassPartitive(str, Enum):
    CONT='CONT'
    EXPAGTCAR='EXPAGTCAR'
    EXPVECTOR='EXPVECTOR'
    FOMITE='FOMITE'
    INGR='INGR'
    ACTI='ACTI'
    ACTIB='ACTIB'
    ACTIM='ACTIM'
    ACTIR='ACTIR'
    ADJV='ADJV'
    ADTV='ADTV'
    BASE='BASE'
    IACT='IACT'
    COLR='COLR'
    FLVR='FLVR'
    PRSV='PRSV'
    STBL='STBL'
    MECH='MECH'
    LOCE='LOCE'
    STOR='STOR'
    MBR='MBR'
    PART='PART'
    ACTM='ACTM'
    SPEC='SPEC'
    ALQT='ALQT'
    ISLT='ISLT'


class RoleClassPassive(str, Enum):
    ACCESS='ACCESS'
    ADJY='ADJY'
    CONC='CONC'
    BOND='BOND'
    CONY='CONY'
    ADMM='ADMM'
    BIRTHPL='BIRTHPL'
    DEATHPLC='DEATHPLC'
    DST='DST'
    RET='RET'
    EXPR='EXPR'
    HLD='HLD'
    HLTHCHRT='HLTHCHRT'
    IDENT='IDENT'
    MANU='MANU'
    THER='THER'
    MNT='MNT'
    OWN='OWN'
    RGPR='RGPR'
    SDLOC='SDLOC'
    DSDLOC='DSDLOC'
    ISDLOC='ISDLOC'
    TERR='TERR'
    USED='USED'
    WRTE='WRTE'


class RoleClassPatient(str, Enum):
    PAT='PAT'


class RoleClassPayee(str, Enum):
    PAYEE='PAYEE'


class RoleClassPersonalRelationship(str, Enum):
    PRS='PRS'


class RoleClassPhysician(str, Enum):
    PHYS='PHYS'


class RoleClassPhysicianAssistant(str, Enum):
    PA='PA'


class RoleClassPlaceOfDeath(str, Enum):
    DEATHPLC='DEATHPLC'


class RoleClassPolicyHolder(str, Enum):
    POLHOLD='POLHOLD'


class RoleClassPreservative(str, Enum):
    PRSV='PRSV'


class RoleClassProductRelated(str, Enum):
    DST='DST'
    MANU='MANU'
    RET='RET'
    RGPR='RGPR'
    THER='THER'
    WRTE='WRTE'


class RoleClassProgramEligible(str, Enum):
    PROG='PROG'


class RoleClassQualifiedEntity(str, Enum):
    QUAL='QUAL'


class RoleClassRegulatedProduct(str, Enum):
    RGPR='RGPR'


class RoleClassRelationshipFormal(str, Enum):
    AFFL='AFFL'
    AGNT='AGNT'
    ASSIGNED='ASSIGNED'
    COMPAR='COMPAR'
    SGNOFF='SGNOFF'
    CON='CON'
    ECON='ECON'
    NOK='NOK'
    GUARD='GUARD'
    CIT='CIT'
    COVPTY='COVPTY'
    CLAIM='CLAIM'
    NAMED='NAMED'
    DEPEN='DEPEN'
    INDIV='INDIV'
    SUBSCR='SUBSCR'
    PROG='PROG'
    CRINV='CRINV'
    CRSPNSR='CRSPNSR'
    EMP='EMP'
    MIL='MIL'
    GUAR='GUAR'
    INVSBJ='INVSBJ'
    CASEBJ='CASEBJ'
    RESBJ='RESBJ'
    LIC='LIC'
    NOT='NOT'
    PROV='PROV'
    PAT='PAT'
    PAYEE='PAYEE'
    PAYOR='PAYOR'
    POLHOLD='POLHOLD'
    QUAL='QUAL'
    SPNSR='SPNSR'
    STD='STD'
    UNDWRT='UNDWRT'


class RoleClassResearchSubject(str, Enum):
    RESBJ='RESBJ'


class RoleClassRetailedMaterial(str, Enum):
    RET='RET'


class RoleClassRoot(str, Enum):
    ROL='ROL'
    AFFL='AFFL'
    AGNT='AGNT'
    ASSIGNED='ASSIGNED'
    COMPAR='COMPAR'
    SGNOFF='SGNOFF'
    CON='CON'
    ECON='ECON'
    NOK='NOK'
    GUARD='GUARD'
    CIT='CIT'
    COVPTY='COVPTY'
    CLAIM='CLAIM'
    NAMED='NAMED'
    DEPEN='DEPEN'
    INDIV='INDIV'
    SUBSCR='SUBSCR'
    PROG='PROG'
    CRINV='CRINV'
    CRSPNSR='CRSPNSR'
    EMP='EMP'
    MIL='MIL'
    GUAR='GUAR'
    INVSBJ='INVSBJ'
    CASEBJ='CASEBJ'
    RESBJ='RESBJ'
    LIC='LIC'
    NOT='NOT'
    PROV='PROV'
    PAT='PAT'
    PAYEE='PAYEE'
    PAYOR='PAYOR'
    POLHOLD='POLHOLD'
    QUAL='QUAL'
    SPNSR='SPNSR'
    STD='STD'
    UNDWRT='UNDWRT'
    CAREGIVER='CAREGIVER'
    PRS='PRS'
    ACCESS='ACCESS'
    ADJY='ADJY'
    CONC='CONC'
    BOND='BOND'
    CONY='CONY'
    ADMM='ADMM'
    BIRTHPL='BIRTHPL'
    DEATHPLC='DEATHPLC'
    DST='DST'
    RET='RET'
    EXPR='EXPR'
    HLD='HLD'
    HLTHCHRT='HLTHCHRT'
    IDENT='IDENT'
    MANU='MANU'
    THER='THER'
    MNT='MNT'
    OWN='OWN'
    RGPR='RGPR'
    SDLOC='SDLOC'
    DSDLOC='DSDLOC'
    ISDLOC='ISDLOC'
    TERR='TERR'
    USED='USED'
    WRTE='WRTE'
    EQUIV='EQUIV'
    SAME='SAME'
    SUBY='SUBY'
    GEN='GEN'
    GRIC='GRIC'
    INST='INST'
    SUBS='SUBS'
    CONT='CONT'
    EXPAGTCAR='EXPAGTCAR'
    EXPVECTOR='EXPVECTOR'
    FOMITE='FOMITE'
    INGR='INGR'
    ACTI='ACTI'
    ACTIB='ACTIB'
    ACTIM='ACTIM'
    ACTIR='ACTIR'
    ADJV='ADJV'
    ADTV='ADTV'
    BASE='BASE'
    IACT='IACT'
    COLR='COLR'
    FLVR='FLVR'
    PRSV='PRSV'
    STBL='STBL'
    MECH='MECH'
    LOCE='LOCE'
    STOR='STOR'
    MBR='MBR'
    PART='PART'
    ACTM='ACTM'
    SPEC='SPEC'
    ALQT='ALQT'
    ISLT='ISLT'


class RoleClassSame(str, Enum):
    SAME='SAME'


class RoleClassServiceDeliveryLocation(str, Enum):
    SDLOC='SDLOC'
    DSDLOC='DSDLOC'
    ISDLOC='ISDLOC'


class RoleClassSigningAuthorityOrOfficer(str, Enum):
    SGNOFF='SGNOFF'


class RoleClassSpecimen(str, Enum):
    SPEC='SPEC'
    ALQT='ALQT'
    ISLT='ISLT'


class RoleClassStabilizer(str, Enum):
    STBL='STBL'


class RoleClassStoredEntity(str, Enum):
    STOR='STOR'


class RoleClassStudent(str, Enum):
    STD='STD'


class RoleClassSubscriber(str, Enum):
    SUBSCR='SUBSCR'


class RoleClassSubstancePresence(str, Enum):
    CONT='CONT'
    INGR='INGR'
    ACTI='ACTI'
    ACTIB='ACTIB'
    ACTIM='ACTIM'
    ACTIR='ACTIR'
    ADJV='ADJV'
    ADTV='ADTV'
    BASE='BASE'
    IACT='IACT'
    COLR='COLR'
    FLVR='FLVR'
    PRSV='PRSV'
    STBL='STBL'
    MECH='MECH'
    LOCE='LOCE'
    STOR='STOR'
    PART='PART'
    ACTM='ACTM'


class RoleClassSubsumedBy(str, Enum):
    SUBY='SUBY'


class RoleClassSubsumer(str, Enum):
    SUBS='SUBS'


class RoleClassTerritoryOfAuthority(str, Enum):
    TERR='TERR'


class RoleClassTherapeuticAgent(str, Enum):
    THER='THER'


class RoleClassUnderwriter(str, Enum):
    UNDWRT='UNDWRT'


class RoleClassUsedEntity(str, Enum):
    USED='USED'


class RoleClassWarrantedProduct(str, Enum):
    WRTE='WRTE'


class RoleLinkHasContact(str, Enum):
    CONT='CONT'


class RoleLinkHasDirectAuthorityOver(str, Enum):
    DIRAUTH='DIRAUTH'


class RoleLinkHasIndirectAuthorityOver(str, Enum):
    INDAUTH='INDAUTH'


class RoleLinkHasPart(str, Enum):
    PART='PART'


class RoleLinkIdentification(str, Enum):
    IDENT='IDENT'


class RoleLinkIsBackupFor(str, Enum):
    BACKUP='BACKUP'


class RoleLinkRelated(str, Enum):
    REL='REL'
    BACKUP='BACKUP'
    CONT='CONT'
    DIRAUTH='DIRAUTH'
    IDENT='IDENT'
    INDAUTH='INDAUTH'
    PART='PART'
    REPL='REPL'


class RoleLinkReplaces(str, Enum):
    REPL='REPL'


class RoleLinkType(str, Enum):
    BACKUP='BACKUP'
    CONT='CONT'
    DIRAUTH='DIRAUTH'
    IDENT='IDENT'
    INDAUTH='INDAUTH'
    PART='PART'
    REL='REL'
    REPL='REPL'


class RoleStatus(str, Enum):
    ACTIVE='active'
    CANCELLED='cancelled'
    NORMAL='normal'
    NULLIFIED='nullified'
    PENDING='pending'
    SUSPENDED='suspended'
    TERMINATED='terminated'


class RoleStatusActive(str, Enum):
    ACTIVE='active'


class RoleStatusCancelled(str, Enum):
    CANCELLED='cancelled'


class RoleStatusNormal(str, Enum):
    NORMAL='normal'
    ACTIVE='active'
    CANCELLED='cancelled'
    PENDING='pending'
    SUSPENDED='suspended'
    TERMINATED='terminated'


class RoleStatusNullified(str, Enum):
    NULLIFIED='nullified'


class RoleStatusPending(str, Enum):
    PENDING='pending'


class RoleStatusSuspended(str, Enum):
    SUSPENDED='suspended'


class RoleStatusTerminated(str, Enum):
    TERMINATED='terminated'


class Sequencing(str, Enum):
    A='A'
    D='D'
    N='N'


class SetOperator(str, Enum):
    A='A'
    E='E'
    H='H'
    I='I'
    P='P'


class StreetAddressLine(str, Enum):
    SAL='SAL'


class StreetName(str, Enum):
    STR='STR'


class TelecommunicationAddressUse(str, Enum):
    AS='AS'
    BAD='BAD'
    CONF='CONF'
    DIR='DIR'
    EC='EC'
    H='H'
    HP='HP'
    HV='HV'
    MC='MC'
    PG='PG'
    PUB='PUB'
    TMP='TMP'
    WP='WP'


class TelecommunicationCapabilities(str, Enum):
    DATA='DATA'
    FAX='FAX'
    SMS='SMS'
    TTY='TTY'
    VOICE='VOICE'


class TextMediaType(str, Enum):
    TEXTHTML='text/html'
    TEXTPLAIN='text/plain'
    TEXTRTF='text/rtf'
    TEXTSGML='text/sgml'
    TEXTXHL_7FT='text/x-hl7-ft'
    TEXTXHL_7TEXTXML='text/x-hl7-text+xml'
    TEXTXML='text/xml'


class TimingEvent(str, Enum):
    AC='AC'
    ACD='ACD'
    ACM='ACM'
    ACV='ACV'
    C='C'
    CD='CD'
    CM='CM'
    CV='CV'
    HS='HS'
    IC='IC'
    ICD='ICD'
    ICM='ICM'
    ICV='ICV'
    PC='PC'
    PCD='PCD'
    PCM='PCM'
    PCV='PCV'
    WAKE='WAKE'


class TransmissionRelationshipTypeCode(str, Enum):
    SEQL='SEQL'


class URLScheme(str, Enum):
    CID='cid'
    FILE='file'
    FTP='ftp'
    HL_7ATT='hl7-att'
    HTTP='http'
    MAILTO='mailto'
    MLLP='mllp'
    NFS='nfs'
    TEL='tel'
    TELNET='telnet'


class Unknown(str, Enum):
    UNK='UNK'
    ASKU='ASKU'
    NAV='NAV'
    NASK='NASK'
    QS='QS'
    TRC='TRC'


class VideoMediaType(str, Enum):
    VIDEOMPEG='video/mpeg'
    VIDEOXAVI='video/x-avi'


class WorkPlace(str, Enum):
    WP='WP'
    DIR='DIR'
    PUB='PUB'


class alignType(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType1(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType10(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType12(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType14(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType3(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType5(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType7(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class codeType(str, Enum):
    ACTIVE='active'
    COMPLETED='completed'


class frameType(str, Enum):
    VOID='void'
    ABOVE='above'
    BELOW='below'
    HSIDES='hsides'
    LHS='lhs'
    RHS='rhs'
    VSIDES='vsides'
    BOX='box'
    BORDER='border'


class listTypeType(str, Enum):
    ORDERED='ordered'
    UNORDERED='unordered'


class revisedType(str, Enum):
    INSERT='insert'
    DELETE='delete'


class rulesType(str, Enum):
    NONE='none'
    GROUPS='groups'
    ROWS='rows'
    COLS='cols'
    ALL='all'


class scopeType(str, Enum):
    ROW='row'
    COL='col'
    ROWGROUP='rowgroup'
    COLGROUP='colgroup'


class scopeType9(str, Enum):
    ROW='row'
    COL='col'
    ROWGROUP='rowgroup'
    COLGROUP='colgroup'


class valignType(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType11(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType13(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType15(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType2(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType4(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType6(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType8(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class x_AccommodationRequestorRole(str, Enum):
    AGNT='AGNT'
    PAT='PAT'
    PROV='PROV'
    PRS='PRS'


class x_ActClassCareProvisionEncounter(str, Enum):
    ENC='ENC'
    PCPR='PCPR'


class x_ActClassCareProvisionObservation(str, Enum):
    OBS='OBS'
    PCPR='PCPR'


class x_ActClassCareProvisionProcedure(str, Enum):
    PCPR='PCPR'
    PROC='PROC'


class x_ActClassDocumentEntryAct(str, Enum):
    ACCM='ACCM'
    ACSN='ACSN'
    ACT='ACT'
    AEXPOS='AEXPOS'
    CONS='CONS'
    CONTREG='CONTREG'
    CTTEVENT='CTTEVENT'
    DISPACT='DISPACT'
    EXPOS='EXPOS'
    INC='INC'
    INFRM='INFRM'
    LIST='LIST'
    MPROT='MPROT'
    PCPR='PCPR'
    REG='REG'
    REV='REV'
    SPCTRT='SPCTRT'
    STORE='STORE'
    TEXPOS='TEXPOS'
    TRFR='TRFR'
    TRNS='TRNS'


class x_ActClassDocumentEntryOrganizer(str, Enum):
    BATTERY='BATTERY'
    CLUSTER='CLUSTER'


class x_ActMoodCompletionCriterion(str, Enum):
    CRT='CRT'
    DEF='DEF'
    EVN='EVN'
    EVNCRT='EVN.CRT'
    INT='INT'
    RQO='RQO'


class x_ActMoodDefEvn(str, Enum):
    DEF='DEF'
    EVN='EVN'


class x_ActMoodDefEvnRqo(str, Enum):
    DEF='DEF'
    EVN='EVN'
    RQO='RQO'


class x_ActMoodDefEvnRqoPrmsPrp(str, Enum):
    DEF='DEF'
    EVN='EVN'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_ActMoodDocumentObservation(str, Enum):
    APT='APT'
    ARQ='ARQ'
    DEF='DEF'
    EVN='EVN'
    GOL='GOL'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'
    RSK='RSK'


class x_ActMoodEvnOrdPrmsPrp(str, Enum):
    EVN='EVN'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_ActMoodIntentEvent(str, Enum):
    APT='APT'
    ARQ='ARQ'
    EVN='EVN'
    INT='INT'
    PERMRQ='PERMRQ'
    PRMS='PRMS'
    PRP='PRP'
    RMD='RMD'
    RQO='RQO'


class x_ActMoodOrdPrms(str, Enum):
    PRMS='PRMS'
    RQO='RQO'


class x_ActMoodOrdPrmsEvn(str, Enum):
    EVN='EVN'
    PRMS='PRMS'
    RQO='RQO'


class x_ActMoodPermPermrq(str, Enum):
    PERM='PERM'
    PERMRQ='PERMRQ'


class x_ActMoodRequestEvent(str, Enum):
    EVN='EVN'
    RQO='RQO'


class x_ActMoodRqoPrpAptArq(str, Enum):
    APT='APT'
    ARQ='ARQ'
    PRP='PRP'
    RQO='RQO'


class x_ActOrderableOrBillable(str, Enum):
    ACCM='ACCM'
    ALRT='ALRT'
    BATTERY='BATTERY'
    CASE='CASE'
    CLNTRL='CLNTRL'
    CNOD='CNOD'
    CONC='CONC'
    COND='COND'
    DETPOL='DETPOL'
    DGIMG='DGIMG'
    ENC='ENC'
    EXP='EXP'
    GEN='GEN'
    INVSTG='INVSTG'
    LLD='LLD'
    LOC='LOC'
    OBS='OBS'
    OBSCOR='OBSCOR'
    OBSSER='OBSSER'
    OUTB='OUTB'
    PCPR='PCPR'
    PHN='PHN'
    POL='POL'
    POS='POS'
    POSACC='POSACC'
    POSCOORD='POSCOORD'
    PRN='PRN'
    PROC='PROC'
    RLD='RLD'
    ROIBND='ROIBND'
    ROIOVL='ROIOVL'
    RTRD='RTRD'
    SBADM='SBADM'
    SBEXT='SBEXT'
    SEQ='SEQ'
    SEQVAR='SEQVAR'
    SFWL='SFWL'
    SIT='SIT'
    SPCOBS='SPCOBS'
    SPECCOLLECT='SPECCOLLECT'
    STN='STN'
    SUP='SUP'
    TRD='TRD'
    TRNS='TRNS'
    VERIF='VERIF'


class x_ActRelationshipDocument(str, Enum):
    APND='APND'
    RPLC='RPLC'
    XFRM='XFRM'


class x_ActRelationshipDocumentSPL(str, Enum):
    APND='APND'
    DRIV='DRIV'
    RPLC='RPLC'
    XCRPT='XCRPT'
    XFRM='XFRM'


class x_ActRelationshipEntry(str, Enum):
    COMP='COMP'
    DRIV='DRIV'


class x_ActRelationshipEntryRelationship(str, Enum):
    CAUS='CAUS'
    COMP='COMP'
    GEVL='GEVL'
    MFST='MFST'
    REFR='REFR'
    RSON='RSON'
    SAS='SAS'
    SPRT='SPRT'
    SUBJ='SUBJ'
    XCRPT='XCRPT'


class x_ActRelationshipExternalReference(str, Enum):
    ELNK='ELNK'
    REFR='REFR'
    RPLC='RPLC'
    SPRT='SPRT'
    SUBJ='SUBJ'
    XCRPT='XCRPT'


class x_ActRelationshipPatientTransport(str, Enum):
    ARR='ARR'
    DEP='DEP'


class x_ActRelationshipPertinentInfo(str, Enum):
    CAUS='CAUS'
    MFST='MFST'
    REFR='REFR'
    SPRT='SPRT'
    SUBJ='SUBJ'


class x_ActRelationshipRelatedAuthorizations(str, Enum):
    AUTH='AUTH'
    REFR='REFR'


class x_ActReplaceOrRevise(str, Enum):
    MOD='MOD'
    RPLC='RPLC'


class x_ActStatusActiveComplete(str, Enum):
    ACTIVE='active'
    COMPLETED='completed'


class x_ActStatusActiveSuspended(str, Enum):
    ACTIVE='active'
    SUSPENDED='suspended'


class x_ActStatusPrevious(str, Enum):
    CANCELLED='cancelled'
    NULLIFIED='nullified'
    OBSOLETE='obsolete'


class x_ClinicalStatementActMood(str, Enum):
    APT='APT'
    ARQ='ARQ'
    DEF='DEF'
    EVN='EVN'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'
    RSK='RSK'


class x_ClinicalStatementEncounterMood(str, Enum):
    APT='APT'
    ARQ='ARQ'
    DEF='DEF'
    EVN='EVN'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_ClinicalStatementExposureMood(str, Enum):
    CRT='CRT'
    DEF='DEF'
    EVN='EVN'
    EVNCRT='EVN.CRT'
    RSK='RSK'


class x_ClinicalStatementObservationMood(str, Enum):
    APT='APT'
    ARQ='ARQ'
    CRT='CRT'
    DEF='DEF'
    EVN='EVN'
    EVNCRT='EVN.CRT'
    GOL='GOL'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'
    RSK='RSK'


class x_ClinicalStatementProcedureMood(str, Enum):
    APT='APT'
    ARQ='ARQ'
    CRT='CRT'
    DEF='DEF'
    EVN='EVN'
    EVNCRT='EVN.CRT'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_ClinicalStatementSubstanceMood(str, Enum):
    CRT='CRT'
    DEF='DEF'
    EVN='EVN'
    EVNCRT='EVN.CRT'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_ClinicalStatementSupplyMood(str, Enum):
    DEF='DEF'
    EVN='EVN'
    INT='INT'


class x_DeterminerInstanceKind(str, Enum):
    INSTANCE='INSTANCE'
    KIND='KIND'
    QUANTIFIED_KIND='QUANTIFIED_KIND'


class x_DocumentActMood(str, Enum):
    APT='APT'
    ARQ='ARQ'
    DEF='DEF'
    EVN='EVN'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'
    RSK='RSK'


class x_DocumentEncounterMood(str, Enum):
    APT='APT'
    ARQ='ARQ'
    DEF='DEF'
    EVN='EVN'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_DocumentEntrySubject(str, Enum):
    PAT='PAT'
    PRS='PRS'
    SPEC='SPEC'


class x_DocumentProcedureMood(str, Enum):
    APT='APT'
    ARQ='ARQ'
    DEF='DEF'
    EVN='EVN'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_DocumentStatus(str, Enum):
    ACTIVE='active'
    CANCELLED='cancelled'
    NEW='new'
    OBSOLETE='obsolete'


class x_DocumentSubject(str, Enum):
    PAT='PAT'
    PRS='PRS'


class x_DocumentSubstanceMood(str, Enum):
    DEF='DEF'
    EVN='EVN'
    INT='INT'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_EncounterParticipant(str, Enum):
    ADM='ADM'
    ATND='ATND'
    CON='CON'
    DIS='DIS'
    REF='REF'


class x_EncounterPerformerParticipation(str, Enum):
    CON='CON'
    PRF='PRF'
    SPRF='SPRF'


class x_EntityClassDocumentReceiving(str, Enum):
    HCE='HCE'
    NAT='NAT'
    ORG='ORG'
    PSN='PSN'
    PUB='PUB'
    STATE='STATE'


class x_EntityClassPersonOrOrgReceiving(str, Enum):
    NAT='NAT'
    ORG='ORG'
    PSN='PSN'
    PUB='PUB'
    STATE='STATE'


class x_InformationRecipient(str, Enum):
    PRCP='PRCP'
    TRC='TRC'


class x_InformationRecipientRole(str, Enum):
    ASSIGNED='ASSIGNED'
    HLTHCHRT='HLTHCHRT'


class x_LabProcessClassCodes(str, Enum):
    ACSN='ACSN'
    CONTREG='CONTREG'
    OBS='OBS'
    PROC='PROC'
    SPCTRT='SPCTRT'
    SPECCOLLECT='SPECCOLLECT'
    STORE='STORE'
    TRNS='TRNS'


class x_OrganizationNamePartType(str, Enum):
    DEL='DEL'
    PFX='PFX'
    SFX='SFX'


class x_ParticipationAuthorPerformer(str, Enum):
    AUT='AUT'
    PRF='PRF'


class x_ParticipationEntVrf(str, Enum):
    ENT='ENT'
    VRF='VRF'


class x_ParticipationPrfEntVrf(str, Enum):
    ENT='ENT'
    PRF='PRF'
    VRF='VRF'


class x_ParticipationVrfRespSprfWit(str, Enum):
    RESP='RESP'
    SPRF='SPRF'
    VRF='VRF'
    WIT='WIT'


class x_PersonNamePartType(str, Enum):
    DEL='DEL'
    FAM='FAM'
    GIV='GIV'
    PFX='PFX'
    SFX='SFX'


class x_PhoneOrEmailURLScheme(str, Enum):
    MAILTO='mailto'
    TEL='tel'


class x_PhoneURLScheme(str, Enum):
    TEL='tel'


class x_RoleClassAccommodationRequestor(str, Enum):
    AGNT='AGNT'
    PAT='PAT'
    PROV='PROV'
    PRS='PRS'


class x_RoleClassCoverage(str, Enum):
    COVPTY='COVPTY'
    POLHOLD='POLHOLD'
    SPNSR='SPNSR'
    UNDWRT='UNDWRT'


class x_RoleClassCoverageInvoice(str, Enum):
    PAYEE='PAYEE'
    PAYOR='PAYOR'


class x_RoleClassCredentialedEntity(str, Enum):
    ASSIGNED='ASSIGNED'
    LIC='LIC'
    NOT='NOT'
    PROV='PROV'
    QUAL='QUAL'


class x_RoleClassPayeePolicyRelationship(str, Enum):
    COVPTY='COVPTY'
    GUAR='GUAR'
    POLHOLD='POLHOLD'
    PROV='PROV'
    PRS='PRS'


class x_SUCC_REPL_PREV(str, Enum):
    PREV='PREV'
    RPLC='RPLC'
    SUCC='SUCC'


class x_ServiceEventPerformer(str, Enum):
    PRF='PRF'
    SPRF='SPRF'


#
# Start data representation classes
#
class POCD_MT000040UV02_Act(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'x_ActClassDocumentEntryAct' = None, moodCode: 'x_DocumentActMood' = None, actionNegationInd: 'bl' = None, negationInd: 'bl' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, statusCode: 'CS' = None, effectiveTime: 'IVL_TS' = None, activityTime: List_['SXCM_TS'] = None, availabilityTime: 'TS' = None, priorityCode: 'CE' = None, confidentialityCode: 'CE' = None, uncertaintyCode: 'CE' = None, reasonCode: List_['CE'] = None, languageCode: 'CS' = None, subject: 'POCD_MT000040UV02.Subject' = None, specimen: List_['POCD_MT000040UV02.Specimen'] = None, performer: List_['POCD_MT000040UV02.Performer2'] = None, author: List_['POCD_MT000040UV02.Author'] = None, informant: List_['POCD_MT000040UV02.Informant12'] = None, participant: List_['POCD_MT000040UV02.Participant3'] = None, entryRelationship: List_['POCD_MT000040UV02.EntryRelationship'] = None, reference: List_['POCD_MT000040UV02.Reference'] = None, precondition: List_['POCD_MT000040UV02.Precondition'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        self.actionNegationInd = _cast(bool, actionNegationInd)
        self.actionNegationInd_nsprefix_ = None
        self.negationInd = _cast(bool, negationInd)
        self.negationInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        if activityTime is None:
            self.activityTime = []
        else:
            self.activityTime = activityTime
        self.activityTime_nsprefix_ = None
        self.availabilityTime = availabilityTime
        self.availabilityTime_nsprefix_ = None
        self.priorityCode = priorityCode
        self.priorityCode_nsprefix_ = None
        self.confidentialityCode = confidentialityCode
        self.confidentialityCode_nsprefix_ = None
        self.uncertaintyCode = uncertaintyCode
        self.uncertaintyCode_nsprefix_ = None
        if reasonCode is None:
            self.reasonCode = []
        else:
            self.reasonCode = reasonCode
        self.reasonCode_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        self.subject = subject
        self.subject_nsprefix_ = None
        if specimen is None:
            self.specimen = []
        else:
            self.specimen = specimen
        self.specimen_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if entryRelationship is None:
            self.entryRelationship = []
        else:
            self.entryRelationship = entryRelationship
        self.entryRelationship_nsprefix_ = None
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        self.reference_nsprefix_ = None
        if precondition is None:
            self.precondition = []
        else:
            self.precondition = precondition
        self.precondition_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Act)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Act.subclass:
            return POCD_MT000040UV02_Act.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Act(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_activityTime(self):
        return self.activityTime
    def set_activityTime(self, activityTime):
        self.activityTime = activityTime
    def add_activityTime(self, value):
        self.activityTime.append(value)
    def insert_activityTime_at(self, index, value):
        self.activityTime.insert(index, value)
    def replace_activityTime_at(self, index, value):
        self.activityTime[index] = value
    def get_availabilityTime(self):
        return self.availabilityTime
    def set_availabilityTime(self, availabilityTime):
        self.availabilityTime = availabilityTime
    def get_priorityCode(self):
        return self.priorityCode
    def set_priorityCode(self, priorityCode):
        self.priorityCode = priorityCode
    def get_confidentialityCode(self):
        return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode):
        self.confidentialityCode = confidentialityCode
    def get_uncertaintyCode(self):
        return self.uncertaintyCode
    def set_uncertaintyCode(self, uncertaintyCode):
        self.uncertaintyCode = uncertaintyCode
    def get_reasonCode(self):
        return self.reasonCode
    def set_reasonCode(self, reasonCode):
        self.reasonCode = reasonCode
    def add_reasonCode(self, value):
        self.reasonCode.append(value)
    def insert_reasonCode_at(self, index, value):
        self.reasonCode.insert(index, value)
    def replace_reasonCode_at(self, index, value):
        self.reasonCode[index] = value
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_subject(self):
        return self.subject
    def set_subject(self, subject):
        self.subject = subject
    def get_specimen(self):
        return self.specimen
    def set_specimen(self, specimen):
        self.specimen = specimen
    def add_specimen(self, value):
        self.specimen.append(value)
    def insert_specimen_at(self, index, value):
        self.specimen.insert(index, value)
    def replace_specimen_at(self, index, value):
        self.specimen[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_entryRelationship(self):
        return self.entryRelationship
    def set_entryRelationship(self, entryRelationship):
        self.entryRelationship = entryRelationship
    def add_entryRelationship(self, value):
        self.entryRelationship.append(value)
    def insert_entryRelationship_at(self, index, value):
        self.entryRelationship.insert(index, value)
    def replace_entryRelationship_at(self, index, value):
        self.entryRelationship[index] = value
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def add_reference(self, value):
        self.reference.append(value)
    def insert_reference_at(self, index, value):
        self.reference.insert(index, value)
    def replace_reference_at(self, index, value):
        self.reference[index] = value
    def get_precondition(self):
        return self.precondition
    def set_precondition(self, precondition):
        self.precondition = precondition
    def add_precondition(self, value):
        self.precondition.append(value)
    def insert_precondition_at(self, index, value):
        self.precondition.insert(index, value)
    def replace_precondition_at(self, index, value):
        self.precondition[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def get_actionNegationInd(self):
        return self.actionNegationInd
    def set_actionNegationInd(self, actionNegationInd):
        self.actionNegationInd = actionNegationInd
    def get_negationInd(self):
        return self.negationInd
    def set_negationInd(self, negationInd):
        self.negationInd = negationInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_x_ActClassDocumentEntryAct(self, value):
        # Validate type x_ActClassDocumentEntryAct, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCM', 'ACSN', 'ACT', 'AEXPOS', 'CONS', 'CONTREG', 'CTTEVENT', 'DISPACT', 'EXPOS', 'INC', 'INFRM', 'LIST', 'MPROT', 'PCPR', 'REG', 'REV', 'SPCTRT', 'STORE', 'TEXPOS', 'TRFR', 'TRNS']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_ActClassDocumentEntryAct' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActClassDocumentEntryAct_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_ActClassDocumentEntryAct_patterns_, ))
    validate_x_ActClassDocumentEntryAct_patterns_ = [['^([^\\s]+)$']]
    def validate_x_DocumentActMood(self, value):
        # Validate type x_DocumentActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'DEF', 'EVN', 'INT', 'PRMS', 'PRP', 'RQO', 'RSK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_DocumentActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_DocumentActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_DocumentActMood_patterns_, ))
    validate_x_DocumentActMood_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.activityTime or
            self.availabilityTime is not None or
            self.priorityCode is not None or
            self.confidentialityCode is not None or
            self.uncertaintyCode is not None or
            self.reasonCode or
            self.languageCode is not None or
            self.subject is not None or
            self.specimen or
            self.performer or
            self.author or
            self.informant or
            self.participant or
            self.entryRelationship or
            self.reference or
            self.precondition
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Act', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Act')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Act':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Act')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Act', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Act'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
        if self.actionNegationInd is not None and 'actionNegationInd' not in already_processed:
            already_processed.add('actionNegationInd')
            outfile.write(' actionNegationInd="%s"' % self.gds_format_boolean(self.actionNegationInd, input_name='actionNegationInd'))
        if self.negationInd is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            outfile.write(' negationInd="%s"' % self.gds_format_boolean(self.negationInd, input_name='negationInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Act', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        for activityTime_ in self.activityTime:
            namespaceprefix_ = self.activityTime_nsprefix_ + ':' if (UseCapturedNS_ and self.activityTime_nsprefix_) else ''
            activityTime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='activityTime', pretty_print=pretty_print)
        if self.availabilityTime is not None:
            namespaceprefix_ = self.availabilityTime_nsprefix_ + ':' if (UseCapturedNS_ and self.availabilityTime_nsprefix_) else ''
            self.availabilityTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='availabilityTime', pretty_print=pretty_print)
        if self.priorityCode is not None:
            namespaceprefix_ = self.priorityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.priorityCode_nsprefix_) else ''
            self.priorityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='priorityCode', pretty_print=pretty_print)
        if self.confidentialityCode is not None:
            namespaceprefix_ = self.confidentialityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.confidentialityCode_nsprefix_) else ''
            self.confidentialityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='confidentialityCode', pretty_print=pretty_print)
        if self.uncertaintyCode is not None:
            namespaceprefix_ = self.uncertaintyCode_nsprefix_ + ':' if (UseCapturedNS_ and self.uncertaintyCode_nsprefix_) else ''
            self.uncertaintyCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='uncertaintyCode', pretty_print=pretty_print)
        for reasonCode_ in self.reasonCode:
            namespaceprefix_ = self.reasonCode_nsprefix_ + ':' if (UseCapturedNS_ and self.reasonCode_nsprefix_) else ''
            reasonCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reasonCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        if self.subject is not None:
            namespaceprefix_ = self.subject_nsprefix_ + ':' if (UseCapturedNS_ and self.subject_nsprefix_) else ''
            self.subject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subject', pretty_print=pretty_print)
        for specimen_ in self.specimen:
            namespaceprefix_ = self.specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_nsprefix_) else ''
            specimen_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen', pretty_print=pretty_print)
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for entryRelationship_ in self.entryRelationship:
            namespaceprefix_ = self.entryRelationship_nsprefix_ + ':' if (UseCapturedNS_ and self.entryRelationship_nsprefix_) else ''
            entryRelationship_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entryRelationship', pretty_print=pretty_print)
        for reference_ in self.reference:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        for precondition_ in self.precondition:
            namespaceprefix_ = self.precondition_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition_nsprefix_) else ''
            precondition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='precondition', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_x_ActClassDocumentEntryAct(self.classCode)    # validate type x_ActClassDocumentEntryAct
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_x_DocumentActMood(self.moodCode)    # validate type x_DocumentActMood
        value = find_attr_value_('actionNegationInd', node)
        if value is not None and 'actionNegationInd' not in already_processed:
            already_processed.add('actionNegationInd')
            if value in ('true', '1'):
                self.actionNegationInd = True
            elif value in ('false', '0'):
                self.actionNegationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.actionNegationInd)    # validate type bl
        value = find_attr_value_('negationInd', node)
        if value is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            if value in ('true', '1'):
                self.negationInd = True
            elif value in ('false', '0'):
                self.negationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.negationInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'activityTime':
            class_obj_ = self.get_class_obj_(child_, SXCM_TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.activityTime.append(obj_)
            obj_.original_tagname_ = 'activityTime'
        elif nodeName_ == 'availabilityTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.availabilityTime = obj_
            obj_.original_tagname_ = 'availabilityTime'
        elif nodeName_ == 'priorityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.priorityCode = obj_
            obj_.original_tagname_ = 'priorityCode'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.confidentialityCode = obj_
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'uncertaintyCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.uncertaintyCode = obj_
            obj_.original_tagname_ = 'uncertaintyCode'
        elif nodeName_ == 'reasonCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reasonCode.append(obj_)
            obj_.original_tagname_ = 'reasonCode'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'subject':
            obj_ = POCD_MT000040UV02_Subject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subject = obj_
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'specimen':
            obj_ = POCD_MT000040UV02_Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen.append(obj_)
            obj_.original_tagname_ = 'specimen'
        elif nodeName_ == 'performer':
            obj_ = POCD_MT000040UV02_Performer2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040UV02_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040UV02_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040UV02_Participant3.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'entryRelationship':
            obj_ = POCD_MT000040UV02_EntryRelationship.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entryRelationship.append(obj_)
            obj_.original_tagname_ = 'entryRelationship'
        elif nodeName_ == 'reference':
            obj_ = POCD_MT000040UV02_Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference.append(obj_)
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'precondition':
            obj_ = POCD_MT000040UV02_Precondition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition.append(obj_)
            obj_.original_tagname_ = 'precondition'
# end class POCD_MT000040UV02_Act


class POCD_MT000040UV02_AssignedAuthor(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'ASSIGNED', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, assignedPerson: 'POCD_MT000040UV02.Person' = None, assignedAuthoringDevice: 'POCD_MT000040UV02.AuthoringDevice' = None, representedOrganization: 'POCD_MT000040UV02.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.assignedPerson = assignedPerson
        self.assignedPerson_nsprefix_ = None
        self.assignedAuthoringDevice = assignedAuthoringDevice
        self.assignedAuthoringDevice_nsprefix_ = None
        self.representedOrganization = representedOrganization
        self.representedOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_AssignedAuthor)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_AssignedAuthor.subclass:
            return POCD_MT000040UV02_AssignedAuthor.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_AssignedAuthor(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_assignedPerson(self):
        return self.assignedPerson
    def set_assignedPerson(self, assignedPerson):
        self.assignedPerson = assignedPerson
    def get_assignedAuthoringDevice(self):
        return self.assignedAuthoringDevice
    def set_assignedAuthoringDevice(self, assignedAuthoringDevice):
        self.assignedAuthoringDevice = assignedAuthoringDevice
    def get_representedOrganization(self):
        return self.representedOrganization
    def set_representedOrganization(self, representedOrganization):
        self.representedOrganization = representedOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCESS', 'ACTI', 'ACTIB', 'ACTIM', 'ACTIR', 'ACTM', 'ADJV', 'ADJY', 'ADMM', 'ADTV', 'AFFL', 'AGNT', 'ALQT', 'ASSIGNED', 'BASE', 'BIRTHPL', 'BOND', 'CAREGIVER', 'CASEBJ', 'CHILD', 'CIT', 'CLAIM', 'COLR', 'COMPAR', 'CON', 'CONC', 'CONT', 'CONY', 'COVPTY', 'CRED', 'CRINV', 'CRSPNSR', 'DEATHPLC', 'DEPEN', 'DSDLOC', 'DST', 'ECON', 'EMP', 'EQUIV', 'EXPAGTCAR', 'EXPR', 'EXPVECTOR', 'FLVR', 'FOMITE', 'GEN', 'GRIC', 'GUAR', 'GUARD', 'HLD', 'HLTHCHRT', 'IACT', 'IDENT', 'INDIV', 'INGR', 'INST', 'INVSBJ', 'ISDLOC', 'ISLT', 'LIC', 'LOCE', 'MANU', 'MBR', 'MECH', 'MIL', 'MNT', 'NAMED', 'NOK', 'NOT', 'NURPRAC', 'NURS', 'OWN', 'PA', 'PART', 'PAT', 'PAYEE', 'PAYOR', 'PHYS', 'POLHOLD', 'PROG', 'PROV', 'PRS', 'PRSV', 'QUAL', 'RESBJ', 'RET', 'RGPR', 'ROL', 'SAME', 'SDLOC', 'SGNOFF', 'SPEC', 'SPNSR', 'STBL', 'STD', 'STOR', 'SUBS', 'SUBSCR', 'SUBY', 'TERR', 'THER', 'UNDWRT', 'USED', 'WRTE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClass_patterns_, ))
    validate_RoleClass_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.assignedPerson is not None or
            self.assignedAuthoringDevice is not None or
            self.representedOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AssignedAuthor', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.AssignedAuthor')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.AssignedAuthor':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.AssignedAuthor')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.AssignedAuthor', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.AssignedAuthor'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ASSIGNED" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AssignedAuthor', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.assignedPerson is not None:
            namespaceprefix_ = self.assignedPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedPerson_nsprefix_) else ''
            self.assignedPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedPerson', pretty_print=pretty_print)
        if self.assignedAuthoringDevice is not None:
            namespaceprefix_ = self.assignedAuthoringDevice_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedAuthoringDevice_nsprefix_) else ''
            self.assignedAuthoringDevice.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedAuthoringDevice', pretty_print=pretty_print)
        if self.representedOrganization is not None:
            namespaceprefix_ = self.representedOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.representedOrganization_nsprefix_) else ''
            self.representedOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='representedOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'assignedPerson':
            obj_ = POCD_MT000040UV02_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedPerson = obj_
            obj_.original_tagname_ = 'assignedPerson'
        elif nodeName_ == 'assignedAuthoringDevice':
            obj_ = POCD_MT000040UV02_AuthoringDevice.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedAuthoringDevice = obj_
            obj_.original_tagname_ = 'assignedAuthoringDevice'
        elif nodeName_ == 'representedOrganization':
            obj_ = POCD_MT000040UV02_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.representedOrganization = obj_
            obj_.original_tagname_ = 'representedOrganization'
# end class POCD_MT000040UV02_AssignedAuthor


class POCD_MT000040UV02_AssignedCustodian(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'ASSIGNED', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, representedCustodianOrganization: 'POCD_MT000040UV02.CustodianOrganization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.representedCustodianOrganization = representedCustodianOrganization
        self.representedCustodianOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_AssignedCustodian)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_AssignedCustodian.subclass:
            return POCD_MT000040UV02_AssignedCustodian.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_AssignedCustodian(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_representedCustodianOrganization(self):
        return self.representedCustodianOrganization
    def set_representedCustodianOrganization(self, representedCustodianOrganization):
        self.representedCustodianOrganization = representedCustodianOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCESS', 'ACTI', 'ACTIB', 'ACTIM', 'ACTIR', 'ACTM', 'ADJV', 'ADJY', 'ADMM', 'ADTV', 'AFFL', 'AGNT', 'ALQT', 'ASSIGNED', 'BASE', 'BIRTHPL', 'BOND', 'CAREGIVER', 'CASEBJ', 'CHILD', 'CIT', 'CLAIM', 'COLR', 'COMPAR', 'CON', 'CONC', 'CONT', 'CONY', 'COVPTY', 'CRED', 'CRINV', 'CRSPNSR', 'DEATHPLC', 'DEPEN', 'DSDLOC', 'DST', 'ECON', 'EMP', 'EQUIV', 'EXPAGTCAR', 'EXPR', 'EXPVECTOR', 'FLVR', 'FOMITE', 'GEN', 'GRIC', 'GUAR', 'GUARD', 'HLD', 'HLTHCHRT', 'IACT', 'IDENT', 'INDIV', 'INGR', 'INST', 'INVSBJ', 'ISDLOC', 'ISLT', 'LIC', 'LOCE', 'MANU', 'MBR', 'MECH', 'MIL', 'MNT', 'NAMED', 'NOK', 'NOT', 'NURPRAC', 'NURS', 'OWN', 'PA', 'PART', 'PAT', 'PAYEE', 'PAYOR', 'PHYS', 'POLHOLD', 'PROG', 'PROV', 'PRS', 'PRSV', 'QUAL', 'RESBJ', 'RET', 'RGPR', 'ROL', 'SAME', 'SDLOC', 'SGNOFF', 'SPEC', 'SPNSR', 'STBL', 'STD', 'STOR', 'SUBS', 'SUBSCR', 'SUBY', 'TERR', 'THER', 'UNDWRT', 'USED', 'WRTE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClass_patterns_, ))
    validate_RoleClass_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.representedCustodianOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AssignedCustodian', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.AssignedCustodian')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.AssignedCustodian':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.AssignedCustodian')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.AssignedCustodian', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.AssignedCustodian'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ASSIGNED" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AssignedCustodian', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.representedCustodianOrganization is not None:
            namespaceprefix_ = self.representedCustodianOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.representedCustodianOrganization_nsprefix_) else ''
            self.representedCustodianOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='representedCustodianOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'representedCustodianOrganization':
            obj_ = POCD_MT000040UV02_CustodianOrganization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.representedCustodianOrganization = obj_
            obj_.original_tagname_ = 'representedCustodianOrganization'
# end class POCD_MT000040UV02_AssignedCustodian


class POCD_MT000040UV02_AssignedEntity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'ASSIGNED', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, assignedPerson: 'POCD_MT000040UV02.Person' = None, representedOrganization: 'POCD_MT000040UV02.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.assignedPerson = assignedPerson
        self.assignedPerson_nsprefix_ = None
        self.representedOrganization = representedOrganization
        self.representedOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_AssignedEntity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_AssignedEntity.subclass:
            return POCD_MT000040UV02_AssignedEntity.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_AssignedEntity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_assignedPerson(self):
        return self.assignedPerson
    def set_assignedPerson(self, assignedPerson):
        self.assignedPerson = assignedPerson
    def get_representedOrganization(self):
        return self.representedOrganization
    def set_representedOrganization(self, representedOrganization):
        self.representedOrganization = representedOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCESS', 'ACTI', 'ACTIB', 'ACTIM', 'ACTIR', 'ACTM', 'ADJV', 'ADJY', 'ADMM', 'ADTV', 'AFFL', 'AGNT', 'ALQT', 'ASSIGNED', 'BASE', 'BIRTHPL', 'BOND', 'CAREGIVER', 'CASEBJ', 'CHILD', 'CIT', 'CLAIM', 'COLR', 'COMPAR', 'CON', 'CONC', 'CONT', 'CONY', 'COVPTY', 'CRED', 'CRINV', 'CRSPNSR', 'DEATHPLC', 'DEPEN', 'DSDLOC', 'DST', 'ECON', 'EMP', 'EQUIV', 'EXPAGTCAR', 'EXPR', 'EXPVECTOR', 'FLVR', 'FOMITE', 'GEN', 'GRIC', 'GUAR', 'GUARD', 'HLD', 'HLTHCHRT', 'IACT', 'IDENT', 'INDIV', 'INGR', 'INST', 'INVSBJ', 'ISDLOC', 'ISLT', 'LIC', 'LOCE', 'MANU', 'MBR', 'MECH', 'MIL', 'MNT', 'NAMED', 'NOK', 'NOT', 'NURPRAC', 'NURS', 'OWN', 'PA', 'PART', 'PAT', 'PAYEE', 'PAYOR', 'PHYS', 'POLHOLD', 'PROG', 'PROV', 'PRS', 'PRSV', 'QUAL', 'RESBJ', 'RET', 'RGPR', 'ROL', 'SAME', 'SDLOC', 'SGNOFF', 'SPEC', 'SPNSR', 'STBL', 'STD', 'STOR', 'SUBS', 'SUBSCR', 'SUBY', 'TERR', 'THER', 'UNDWRT', 'USED', 'WRTE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClass_patterns_, ))
    validate_RoleClass_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.assignedPerson is not None or
            self.representedOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AssignedEntity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.AssignedEntity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.AssignedEntity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.AssignedEntity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.AssignedEntity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.AssignedEntity'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ASSIGNED" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AssignedEntity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.assignedPerson is not None:
            namespaceprefix_ = self.assignedPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedPerson_nsprefix_) else ''
            self.assignedPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedPerson', pretty_print=pretty_print)
        if self.representedOrganization is not None:
            namespaceprefix_ = self.representedOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.representedOrganization_nsprefix_) else ''
            self.representedOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='representedOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'assignedPerson':
            obj_ = POCD_MT000040UV02_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedPerson = obj_
            obj_.original_tagname_ = 'assignedPerson'
        elif nodeName_ == 'representedOrganization':
            obj_ = POCD_MT000040UV02_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.representedOrganization = obj_
            obj_.original_tagname_ = 'representedOrganization'
# end class POCD_MT000040UV02_AssignedEntity


class POCD_MT000040UV02_AssociatedEntity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassAssociative' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, associatedPerson: 'POCD_MT000040UV02.Person' = None, scopingOrganization: 'POCD_MT000040UV02.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.associatedPerson = associatedPerson
        self.associatedPerson_nsprefix_ = None
        self.scopingOrganization = scopingOrganization
        self.scopingOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_AssociatedEntity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_AssociatedEntity.subclass:
            return POCD_MT000040UV02_AssociatedEntity.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_AssociatedEntity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_associatedPerson(self):
        return self.associatedPerson
    def set_associatedPerson(self, associatedPerson):
        self.associatedPerson = associatedPerson
    def get_scopingOrganization(self):
        return self.scopingOrganization
    def set_scopingOrganization(self, scopingOrganization):
        self.scopingOrganization = scopingOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClassAssociative(self, value):
        # Validate type RoleClassAssociative, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AFFL', 'AGNT', 'ASSIGNED', 'COMPAR', 'SGNOFF', 'CON', 'ECON', 'NOK', 'GUARD', 'CIT', 'COVPTY', 'CLAIM', 'NAMED', 'DEPEN', 'INDIV', 'SUBSCR', 'PROG', 'CRINV', 'CRSPNSR', 'EMP', 'MIL', 'GUAR', 'INVSBJ', 'CASEBJ', 'RESBJ', 'LIC', 'NOT', 'PROV', 'PAT', 'PAYEE', 'PAYOR', 'POLHOLD', 'QUAL', 'SPNSR', 'STD', 'UNDWRT', 'CAREGIVER', 'PRS', 'ACCESS', 'ADJY', 'CONC', 'BOND', 'CONY', 'ADMM', 'BIRTHPL', 'DEATHPLC', 'DST', 'RET', 'EXPR', 'HLD', 'HLTHCHRT', 'IDENT', 'MANU', 'THER', 'MNT', 'OWN', 'RGPR', 'SDLOC', 'DSDLOC', 'ISDLOC', 'TERR', 'USED', 'WRTE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClassAssociative' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClassAssociative_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClassAssociative_patterns_, ))
    validate_RoleClassAssociative_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.associatedPerson is not None or
            self.scopingOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AssociatedEntity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.AssociatedEntity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.AssociatedEntity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.AssociatedEntity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.AssociatedEntity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.AssociatedEntity'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AssociatedEntity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.associatedPerson is not None:
            namespaceprefix_ = self.associatedPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.associatedPerson_nsprefix_) else ''
            self.associatedPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='associatedPerson', pretty_print=pretty_print)
        if self.scopingOrganization is not None:
            namespaceprefix_ = self.scopingOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.scopingOrganization_nsprefix_) else ''
            self.scopingOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='scopingOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassAssociative(self.classCode)    # validate type RoleClassAssociative
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'associatedPerson':
            obj_ = POCD_MT000040UV02_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.associatedPerson = obj_
            obj_.original_tagname_ = 'associatedPerson'
        elif nodeName_ == 'scopingOrganization':
            obj_ = POCD_MT000040UV02_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.scopingOrganization = obj_
            obj_.original_tagname_ = 'scopingOrganization'
# end class POCD_MT000040UV02_AssociatedEntity


class POCD_MT000040UV02_Authenticator(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'AUTHEN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, time: 'TS' = None, signatureCode: 'CV' = None, signatureText: 'ED' = None, assignedEntity: 'POCD_MT000040UV02.AssignedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.signatureCode = signatureCode
        self.signatureCode_nsprefix_ = None
        self.signatureText = signatureText
        self.signatureText_nsprefix_ = None
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Authenticator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Authenticator.subclass:
            return POCD_MT000040UV02_Authenticator.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Authenticator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_signatureCode(self):
        return self.signatureCode
    def set_signatureCode(self, signatureCode):
        self.signatureCode = signatureCode
    def get_signatureText(self):
        return self.signatureText
    def set_signatureText(self, signatureText):
        self.signatureText = signatureText
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ALY', 'ATND', 'AUT', 'AUTHEN', 'BBY', 'BEN', 'CAGNT', 'CALLBCK', 'CAT', 'CON', 'COV', 'CSM', 'CST', 'DEV', 'DIR', 'DIS', 'DIST', 'DON', 'DST', 'ELOC', 'ENT', 'ESC', 'EXPAGNT', 'EXPART', 'EXPTRGT', 'EXSRC', 'GUAR', 'HLD', 'IND', 'INF', 'IRCP', 'LA', 'LOC', 'NOT', 'NRD', 'ORG', 'PART', 'PPRF', 'PRCP', 'PRD', 'PRF', 'RCT', 'RCV', 'RDV', 'REF', 'REFB', 'REFT', 'RESP', 'RML', 'SBJ', 'SPC', 'SPRF', 'TRANS', 'TRC', 'VIA', 'VRF', 'WIT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationType_patterns_, ))
    validate_ParticipationType_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.time is not None or
            self.signatureCode is not None or
            self.signatureText is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Authenticator', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Authenticator')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Authenticator':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Authenticator')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Authenticator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Authenticator'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "AUTHEN" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Authenticator', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.signatureCode is not None:
            namespaceprefix_ = self.signatureCode_nsprefix_ + ':' if (UseCapturedNS_ and self.signatureCode_nsprefix_) else ''
            self.signatureCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='signatureCode', pretty_print=pretty_print)
        if self.signatureText is not None:
            namespaceprefix_ = self.signatureText_nsprefix_ + ':' if (UseCapturedNS_ and self.signatureText_nsprefix_) else ''
            self.signatureText.export(outfile, level, namespaceprefix_, namespacedef_='', name_='signatureText', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'signatureCode':
            class_obj_ = self.get_class_obj_(child_, CV)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signatureCode = obj_
            obj_.original_tagname_ = 'signatureCode'
        elif nodeName_ == 'signatureText':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signatureText = obj_
            obj_.original_tagname_ = 'signatureText'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040UV02_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class POCD_MT000040UV02_Authenticator


class POCD_MT000040UV02_Author(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'AUT', contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, functionCode: 'CE' = None, time: 'TS' = None, assignedAuthor: 'POCD_MT000040UV02.AssignedAuthor' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.functionCode = functionCode
        self.functionCode_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.assignedAuthor = assignedAuthor
        self.assignedAuthor_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Author)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Author.subclass:
            return POCD_MT000040UV02_Author.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Author(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_functionCode(self):
        return self.functionCode
    def set_functionCode(self, functionCode):
        self.functionCode = functionCode
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_assignedAuthor(self):
        return self.assignedAuthor
    def set_assignedAuthor(self, assignedAuthor):
        self.assignedAuthor = assignedAuthor
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def set_contextControlCode(self, contextControlCode):
        self.contextControlCode = contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ALY', 'ATND', 'AUT', 'AUTHEN', 'BBY', 'BEN', 'CAGNT', 'CALLBCK', 'CAT', 'CON', 'COV', 'CSM', 'CST', 'DEV', 'DIR', 'DIS', 'DIST', 'DON', 'DST', 'ELOC', 'ENT', 'ESC', 'EXPAGNT', 'EXPART', 'EXPTRGT', 'EXSRC', 'GUAR', 'HLD', 'IND', 'INF', 'IRCP', 'LA', 'LOC', 'NOT', 'NRD', 'ORG', 'PART', 'PPRF', 'PRCP', 'PRD', 'PRF', 'RCT', 'RCV', 'RDV', 'REF', 'REFB', 'REFT', 'RESP', 'RML', 'SBJ', 'SPC', 'SPRF', 'TRANS', 'TRC', 'VIA', 'VRF', 'WIT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationType_patterns_, ))
    validate_ParticipationType_patterns_ = [['^([^\\s]+)$']]
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AN', 'AP', 'ON', 'OP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ContextControl' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ContextControl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ContextControl_patterns_, ))
    validate_ContextControl_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.functionCode is not None or
            self.time is not None or
            self.assignedAuthor is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Author', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Author')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Author':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Author')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Author', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Author'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "AUT" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode != "OP" and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Author', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.functionCode is not None:
            namespaceprefix_ = self.functionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.functionCode_nsprefix_) else ''
            self.functionCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='functionCode', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.assignedAuthor is not None:
            namespaceprefix_ = self.assignedAuthor_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedAuthor_nsprefix_) else ''
            self.assignedAuthor.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedAuthor', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.contextControlCode = ' '.join(self.contextControlCode.split())
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'functionCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.functionCode = obj_
            obj_.original_tagname_ = 'functionCode'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'assignedAuthor':
            obj_ = POCD_MT000040UV02_AssignedAuthor.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedAuthor = obj_
            obj_.original_tagname_ = 'assignedAuthor'
# end class POCD_MT000040UV02_Author


class POCD_MT000040UV02_AuthoringDevice(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClass' = 'DEV', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CE' = None, manufacturerModelName: 'SC' = None, softwareName: 'SC' = None, asMaintainedEntity: List_['POCD_MT000040UV02.MaintainedEntity'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.manufacturerModelName = manufacturerModelName
        self.manufacturerModelName_nsprefix_ = None
        self.softwareName = softwareName
        self.softwareName_nsprefix_ = None
        if asMaintainedEntity is None:
            self.asMaintainedEntity = []
        else:
            self.asMaintainedEntity = asMaintainedEntity
        self.asMaintainedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_AuthoringDevice)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_AuthoringDevice.subclass:
            return POCD_MT000040UV02_AuthoringDevice.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_AuthoringDevice(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_manufacturerModelName(self):
        return self.manufacturerModelName
    def set_manufacturerModelName(self, manufacturerModelName):
        self.manufacturerModelName = manufacturerModelName
    def get_softwareName(self):
        return self.softwareName
    def set_softwareName(self, softwareName):
        self.softwareName = softwareName
    def get_asMaintainedEntity(self):
        return self.asMaintainedEntity
    def set_asMaintainedEntity(self, asMaintainedEntity):
        self.asMaintainedEntity = asMaintainedEntity
    def add_asMaintainedEntity(self, value):
        self.asMaintainedEntity.append(value)
    def insert_asMaintainedEntity_at(self, index, value):
        self.asMaintainedEntity.insert(index, value)
    def replace_asMaintainedEntity_at(self, index, value):
        self.asMaintainedEntity[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_determinerCode(self):
        return self.determinerCode
    def set_determinerCode(self, determinerCode):
        self.determinerCode = determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityClass(self, value):
        # Validate type EntityClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ANM', 'CER', 'CHEM', 'CITY', 'CONT', 'COUNTRY', 'COUNTY', 'DEV', 'ENT', 'FOOD', 'HCE', 'HOLD', 'LIV', 'MAT', 'MIC', 'MMAT', 'MODDV', 'NAT', 'NLIV', 'ORG', 'PLC', 'PLNT', 'PROVINCE', 'PSN', 'PUB', 'RGRP', 'STATE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityClass_patterns_, ))
    validate_EntityClass_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INSTANCE', 'KIND', 'QUANTIFIED_KIND']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityDeterminer' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityDeterminer_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityDeterminer_patterns_, ))
    validate_EntityDeterminer_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.manufacturerModelName is not None or
            self.softwareName is not None or
            self.asMaintainedEntity
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AuthoringDevice', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.AuthoringDevice')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.AuthoringDevice':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.AuthoringDevice')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.AuthoringDevice', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.AuthoringDevice'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DEV" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode != "INSTANCE" and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.AuthoringDevice', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.manufacturerModelName is not None:
            namespaceprefix_ = self.manufacturerModelName_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturerModelName_nsprefix_) else ''
            self.manufacturerModelName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturerModelName', pretty_print=pretty_print)
        if self.softwareName is not None:
            namespaceprefix_ = self.softwareName_nsprefix_ + ':' if (UseCapturedNS_ and self.softwareName_nsprefix_) else ''
            self.softwareName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='softwareName', pretty_print=pretty_print)
        for asMaintainedEntity_ in self.asMaintainedEntity:
            namespaceprefix_ = self.asMaintainedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.asMaintainedEntity_nsprefix_) else ''
            asMaintainedEntity_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='asMaintainedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClass(self.classCode)    # validate type EntityClass
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'manufacturerModelName':
            obj_ = SC.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturerModelName = obj_
            obj_.original_tagname_ = 'manufacturerModelName'
        elif nodeName_ == 'softwareName':
            obj_ = SC.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.softwareName = obj_
            obj_.original_tagname_ = 'softwareName'
        elif nodeName_ == 'asMaintainedEntity':
            obj_ = POCD_MT000040UV02_MaintainedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.asMaintainedEntity.append(obj_)
            obj_.original_tagname_ = 'asMaintainedEntity'
# end class POCD_MT000040UV02_AuthoringDevice


class POCD_MT000040UV02_Authorization(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'AUTH', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, consent: 'POCD_MT000040UV02.Consent' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.consent = consent
        self.consent_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Authorization)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Authorization.subclass:
            return POCD_MT000040UV02_Authorization.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Authorization(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_consent(self):
        return self.consent
    def set_consent(self, consent):
        self.consent = consent
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.consent is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Authorization', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Authorization')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Authorization':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Authorization')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Authorization', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Authorization'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "AUTH" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Authorization', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.consent is not None:
            namespaceprefix_ = self.consent_nsprefix_ + ':' if (UseCapturedNS_ and self.consent_nsprefix_) else ''
            self.consent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='consent', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'consent':
            obj_ = POCD_MT000040UV02_Consent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.consent = obj_
            obj_.original_tagname_ = 'consent'
# end class POCD_MT000040UV02_Authorization


class POCD_MT000040UV02_Birthplace(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'BIRTHPL', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, place: 'POCD_MT000040UV02.Place' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.place = place
        self.place_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Birthplace)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Birthplace.subclass:
            return POCD_MT000040UV02_Birthplace.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Birthplace(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_place(self):
        return self.place
    def set_place(self, place):
        self.place = place
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCESS', 'ACTI', 'ACTIB', 'ACTIM', 'ACTIR', 'ACTM', 'ADJV', 'ADJY', 'ADMM', 'ADTV', 'AFFL', 'AGNT', 'ALQT', 'ASSIGNED', 'BASE', 'BIRTHPL', 'BOND', 'CAREGIVER', 'CASEBJ', 'CHILD', 'CIT', 'CLAIM', 'COLR', 'COMPAR', 'CON', 'CONC', 'CONT', 'CONY', 'COVPTY', 'CRED', 'CRINV', 'CRSPNSR', 'DEATHPLC', 'DEPEN', 'DSDLOC', 'DST', 'ECON', 'EMP', 'EQUIV', 'EXPAGTCAR', 'EXPR', 'EXPVECTOR', 'FLVR', 'FOMITE', 'GEN', 'GRIC', 'GUAR', 'GUARD', 'HLD', 'HLTHCHRT', 'IACT', 'IDENT', 'INDIV', 'INGR', 'INST', 'INVSBJ', 'ISDLOC', 'ISLT', 'LIC', 'LOCE', 'MANU', 'MBR', 'MECH', 'MIL', 'MNT', 'NAMED', 'NOK', 'NOT', 'NURPRAC', 'NURS', 'OWN', 'PA', 'PART', 'PAT', 'PAYEE', 'PAYOR', 'PHYS', 'POLHOLD', 'PROG', 'PROV', 'PRS', 'PRSV', 'QUAL', 'RESBJ', 'RET', 'RGPR', 'ROL', 'SAME', 'SDLOC', 'SGNOFF', 'SPEC', 'SPNSR', 'STBL', 'STD', 'STOR', 'SUBS', 'SUBSCR', 'SUBY', 'TERR', 'THER', 'UNDWRT', 'USED', 'WRTE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClass_patterns_, ))
    validate_RoleClass_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.place is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Birthplace', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Birthplace')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Birthplace':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Birthplace')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Birthplace', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Birthplace'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "BIRTHPL" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Birthplace', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.place is not None:
            namespaceprefix_ = self.place_nsprefix_ + ':' if (UseCapturedNS_ and self.place_nsprefix_) else ''
            self.place.export(outfile, level, namespaceprefix_, namespacedef_='', name_='place', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'place':
            obj_ = POCD_MT000040UV02_Place.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.place = obj_
            obj_.original_tagname_ = 'place'
# end class POCD_MT000040UV02_Birthplace


class POCD_MT000040UV02_ClinicalDocument(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'DOCCLIN', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: 'II' = None, code: 'CE' = None, title: 'ST' = None, statusCode: 'statusCode' = None, effectiveTime: 'TS' = None, confidentialityCode: 'CE' = None, languageCode: 'CS' = None, setId: 'II' = None, versionNumber: 'ST.r2b' = None, copyTime: 'TS' = None, recordTarget: List_['POCD_MT000040UV02.RecordTarget'] = None, author: List_['POCD_MT000040UV02.Author'] = None, dataEnterer: 'POCD_MT000040UV02.DataEnterer' = None, informant: List_['POCD_MT000040UV02.Informant12'] = None, custodian: 'POCD_MT000040UV02.Custodian' = None, informationRecipient: List_['POCD_MT000040UV02.Participant'] = None, legalAuthenticator: List_['POCD_MT000040UV02.LegalAuthenticator'] = None, authenticator: List_['POCD_MT000040UV02.Authenticator'] = None, participant: List_['POCD_MT000040UV02.Participant2'] = None, inFulfillmentOf: List_['POCD_MT000040UV02.InFulfillmentOf'] = None, documentationOf: List_['POCD_MT000040UV02.DocumentationOf'] = None, relatedDocument: List_['POCD_MT000040UV02.RelatedDocument'] = None, authorization: List_['POCD_MT000040UV02.Authorization'] = None, componentOf: 'POCD_MT000040UV02.Component1' = None, component: 'POCD_MT000040UV02.Component2' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "sdtc"
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = "sdtc"
        self.typeId = typeId
        self.typeId_nsprefix_ = "sdtc"
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = "sdtc"
        self.id = id
        self.id_nsprefix_ = "sdtc"
        self.code = code
        self.code_nsprefix_ = "sdtc"
        self.title = title
        self.title_nsprefix_ = "sdtc"
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = "sdtc"
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = "sdtc"
        self.confidentialityCode = confidentialityCode
        self.confidentialityCode_nsprefix_ = "sdtc"
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = "sdtc"
        self.setId = setId
        self.setId_nsprefix_ = "sdtc"
        self.versionNumber = versionNumber
        self.versionNumber_nsprefix_ = "sdtc"
        self.copyTime = copyTime
        self.copyTime_nsprefix_ = "sdtc"
        if recordTarget is None:
            self.recordTarget = []
        else:
            self.recordTarget = recordTarget
        self.recordTarget_nsprefix_ = "sdtc"
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = "sdtc"
        self.dataEnterer = dataEnterer
        self.dataEnterer_nsprefix_ = "sdtc"
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = "sdtc"
        self.custodian = custodian
        self.custodian_nsprefix_ = "sdtc"
        if informationRecipient is None:
            self.informationRecipient = []
        else:
            self.informationRecipient = informationRecipient
        self.informationRecipient_nsprefix_ = "sdtc"
        if legalAuthenticator is None:
            self.legalAuthenticator = []
        else:
            self.legalAuthenticator = legalAuthenticator
        self.legalAuthenticator_nsprefix_ = "sdtc"
        if authenticator is None:
            self.authenticator = []
        else:
            self.authenticator = authenticator
        self.authenticator_nsprefix_ = "sdtc"
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = "sdtc"
        if inFulfillmentOf is None:
            self.inFulfillmentOf = []
        else:
            self.inFulfillmentOf = inFulfillmentOf
        self.inFulfillmentOf_nsprefix_ = "sdtc"
        if documentationOf is None:
            self.documentationOf = []
        else:
            self.documentationOf = documentationOf
        self.documentationOf_nsprefix_ = "sdtc"
        if relatedDocument is None:
            self.relatedDocument = []
        else:
            self.relatedDocument = relatedDocument
        self.relatedDocument_nsprefix_ = "sdtc"
        if authorization is None:
            self.authorization = []
        else:
            self.authorization = authorization
        self.authorization_nsprefix_ = "sdtc"
        self.componentOf = componentOf
        self.componentOf_nsprefix_ = "sdtc"
        self.component = component
        self.component_nsprefix_ = "sdtc"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_ClinicalDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_ClinicalDocument.subclass:
            return POCD_MT000040UV02_ClinicalDocument.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_ClinicalDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_confidentialityCode(self):
        return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode):
        self.confidentialityCode = confidentialityCode
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_setId(self):
        return self.setId
    def set_setId(self, setId):
        self.setId = setId
    def get_versionNumber(self):
        return self.versionNumber
    def set_versionNumber(self, versionNumber):
        self.versionNumber = versionNumber
    def get_copyTime(self):
        return self.copyTime
    def set_copyTime(self, copyTime):
        self.copyTime = copyTime
    def get_recordTarget(self):
        return self.recordTarget
    def set_recordTarget(self, recordTarget):
        self.recordTarget = recordTarget
    def add_recordTarget(self, value):
        self.recordTarget.append(value)
    def insert_recordTarget_at(self, index, value):
        self.recordTarget.insert(index, value)
    def replace_recordTarget_at(self, index, value):
        self.recordTarget[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_dataEnterer(self):
        return self.dataEnterer
    def set_dataEnterer(self, dataEnterer):
        self.dataEnterer = dataEnterer
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_custodian(self):
        return self.custodian
    def set_custodian(self, custodian):
        self.custodian = custodian
    def get_informationRecipient(self):
        return self.informationRecipient
    def set_informationRecipient(self, informationRecipient):
        self.informationRecipient = informationRecipient
    def add_informationRecipient(self, value):
        self.informationRecipient.append(value)
    def insert_informationRecipient_at(self, index, value):
        self.informationRecipient.insert(index, value)
    def replace_informationRecipient_at(self, index, value):
        self.informationRecipient[index] = value
    def get_legalAuthenticator(self):
        return self.legalAuthenticator
    def set_legalAuthenticator(self, legalAuthenticator):
        self.legalAuthenticator = legalAuthenticator
    def add_legalAuthenticator(self, value):
        self.legalAuthenticator.append(value)
    def insert_legalAuthenticator_at(self, index, value):
        self.legalAuthenticator.insert(index, value)
    def replace_legalAuthenticator_at(self, index, value):
        self.legalAuthenticator[index] = value
    def get_authenticator(self):
        return self.authenticator
    def set_authenticator(self, authenticator):
        self.authenticator = authenticator
    def add_authenticator(self, value):
        self.authenticator.append(value)
    def insert_authenticator_at(self, index, value):
        self.authenticator.insert(index, value)
    def replace_authenticator_at(self, index, value):
        self.authenticator[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_inFulfillmentOf(self):
        return self.inFulfillmentOf
    def set_inFulfillmentOf(self, inFulfillmentOf):
        self.inFulfillmentOf = inFulfillmentOf
    def add_inFulfillmentOf(self, value):
        self.inFulfillmentOf.append(value)
    def insert_inFulfillmentOf_at(self, index, value):
        self.inFulfillmentOf.insert(index, value)
    def replace_inFulfillmentOf_at(self, index, value):
        self.inFulfillmentOf[index] = value
    def get_documentationOf(self):
        return self.documentationOf
    def set_documentationOf(self, documentationOf):
        self.documentationOf = documentationOf
    def add_documentationOf(self, value):
        self.documentationOf.append(value)
    def insert_documentationOf_at(self, index, value):
        self.documentationOf.insert(index, value)
    def replace_documentationOf_at(self, index, value):
        self.documentationOf[index] = value
    def get_relatedDocument(self):
        return self.relatedDocument
    def set_relatedDocument(self, relatedDocument):
        self.relatedDocument = relatedDocument
    def add_relatedDocument(self, value):
        self.relatedDocument.append(value)
    def insert_relatedDocument_at(self, index, value):
        self.relatedDocument.insert(index, value)
    def replace_relatedDocument_at(self, index, value):
        self.relatedDocument[index] = value
    def get_authorization(self):
        return self.authorization
    def set_authorization(self, authorization):
        self.authorization = authorization
    def add_authorization(self, value):
        self.authorization.append(value)
    def insert_authorization_at(self, index, value):
        self.authorization.insert(index, value)
    def replace_authorization_at(self, index, value):
        self.authorization[index] = value
    def get_componentOf(self):
        return self.componentOf
    def set_componentOf(self, componentOf):
        self.componentOf = componentOf
    def get_component(self):
        return self.component
    def set_component(self, component):
        self.component = component
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCM', 'ACCT', 'ACSN', 'ACT', 'ACTN', 'ADJUD', 'AEXPOS', 'ALRT', 'BATTERY', 'CACT', 'CASE', 'CATEGORY', 'CDALVLONE', 'CLNTRL', 'CLUSTER', 'CNOD', 'CNTRCT', 'COMPOSITION', 'CONC', 'COND', 'CONS', 'CONTAINER', 'CONTREG', 'COV', 'CTTEVENT', 'DETPOL', 'DGIMG', 'DIET', 'DISPACT', 'DOC', 'DOCBODY', 'DOCCLIN', 'DOCSECT', 'EHR', 'ENC', 'EXP', 'EXPOS', 'EXTRACT', 'FCNTRCT', 'FOLDER', 'GEN', 'GROUPER', 'INC', 'INFO', 'INFRM', 'INVE', 'INVSTG', 'JURISPOL', 'LIST', 'LLD', 'LOC', 'MPROT', 'OBS', 'OBSCOR', 'OBSSER', 'ORGPOL', 'OUTB', 'PCPR', 'PHN', 'POL', 'POLICY', 'POS', 'POSACC', 'POSCOORD', 'PRN', 'PROC', 'REG', 'REV', 'RLD', 'ROIBND', 'ROIOVL', 'RTRD', 'SBADM', 'SBEXT', 'SCOPOL', 'SEQ', 'SEQVAR', 'SFWL', 'SIT', 'SPCOBS', 'SPCTRT', 'SPECCOLLECT', 'SPLY', 'STC', 'STDPOL', 'STN', 'STORE', 'SUBST', 'SUP', 'TEXPOS', 'TOPIC', 'TRD', 'TRFR', 'TRNS', 'VERIF', 'XACT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClass_patterns_, ))
    validate_ActClass_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id is not None or
            self.code is not None or
            self.title is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.confidentialityCode is not None or
            self.languageCode is not None or
            self.setId is not None or
            self.versionNumber is not None or
            self.copyTime is not None or
            self.recordTarget or
            self.author or
            self.dataEnterer is not None or
            self.informant or
            self.custodian is not None or
            self.informationRecipient or
            self.legalAuthenticator or
            self.authenticator or
            self.participant or
            self.inFulfillmentOf or
            self.documentationOf or
            self.relatedDocument or
            self.authorization or
            self.componentOf is not None or
            self.component is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ClinicalDocument', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.ClinicalDocument')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.ClinicalDocument':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.ClinicalDocument')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.ClinicalDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.ClinicalDocument'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOCCLIN" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ClinicalDocument', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            self.id.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            self.title.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.confidentialityCode is not None:
            namespaceprefix_ = self.confidentialityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.confidentialityCode_nsprefix_) else ''
            self.confidentialityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='confidentialityCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        if self.setId is not None:
            namespaceprefix_ = self.setId_nsprefix_ + ':' if (UseCapturedNS_ and self.setId_nsprefix_) else ''
            self.setId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='setId', pretty_print=pretty_print)
        if self.versionNumber is not None:
            namespaceprefix_ = self.versionNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.versionNumber_nsprefix_) else ''
            self.versionNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='versionNumber', pretty_print=pretty_print)
        if self.copyTime is not None:
            namespaceprefix_ = self.copyTime_nsprefix_ + ':' if (UseCapturedNS_ and self.copyTime_nsprefix_) else ''
            self.copyTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='copyTime', pretty_print=pretty_print)
        for recordTarget_ in self.recordTarget:
            namespaceprefix_ = self.recordTarget_nsprefix_ + ':' if (UseCapturedNS_ and self.recordTarget_nsprefix_) else ''
            recordTarget_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recordTarget', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        if self.dataEnterer is not None:
            namespaceprefix_ = self.dataEnterer_nsprefix_ + ':' if (UseCapturedNS_ and self.dataEnterer_nsprefix_) else ''
            self.dataEnterer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dataEnterer', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        if self.custodian is not None:
            namespaceprefix_ = self.custodian_nsprefix_ + ':' if (UseCapturedNS_ and self.custodian_nsprefix_) else ''
            self.custodian.export(outfile, level, namespaceprefix_, namespacedef_='', name_='custodian', pretty_print=pretty_print)
        for informationRecipient_ in self.informationRecipient:
            namespaceprefix_ = self.informationRecipient_nsprefix_ + ':' if (UseCapturedNS_ and self.informationRecipient_nsprefix_) else ''
            informationRecipient_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informationRecipient', pretty_print=pretty_print)
        for legalAuthenticator_ in self.legalAuthenticator:
            namespaceprefix_ = self.legalAuthenticator_nsprefix_ + ':' if (UseCapturedNS_ and self.legalAuthenticator_nsprefix_) else ''
            legalAuthenticator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='legalAuthenticator', pretty_print=pretty_print)
        for authenticator_ in self.authenticator:
            namespaceprefix_ = self.authenticator_nsprefix_ + ':' if (UseCapturedNS_ and self.authenticator_nsprefix_) else ''
            authenticator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='authenticator', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for inFulfillmentOf_ in self.inFulfillmentOf:
            namespaceprefix_ = self.inFulfillmentOf_nsprefix_ + ':' if (UseCapturedNS_ and self.inFulfillmentOf_nsprefix_) else ''
            inFulfillmentOf_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='inFulfillmentOf', pretty_print=pretty_print)
        for documentationOf_ in self.documentationOf:
            namespaceprefix_ = self.documentationOf_nsprefix_ + ':' if (UseCapturedNS_ and self.documentationOf_nsprefix_) else ''
            documentationOf_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='documentationOf', pretty_print=pretty_print)
        for relatedDocument_ in self.relatedDocument:
            namespaceprefix_ = self.relatedDocument_nsprefix_ + ':' if (UseCapturedNS_ and self.relatedDocument_nsprefix_) else ''
            relatedDocument_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='relatedDocument', pretty_print=pretty_print)
        for authorization_ in self.authorization:
            namespaceprefix_ = self.authorization_nsprefix_ + ':' if (UseCapturedNS_ and self.authorization_nsprefix_) else ''
            authorization_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='authorization', pretty_print=pretty_print)
        if self.componentOf is not None:
            namespaceprefix_ = self.componentOf_nsprefix_ + ':' if (UseCapturedNS_ and self.componentOf_nsprefix_) else ''
            self.componentOf.export(outfile, level, namespaceprefix_, namespacedef_='', name_='componentOf', pretty_print=pretty_print)
        if self.component is not None:
            namespaceprefix_ = self.component_nsprefix_ + ':' if (UseCapturedNS_ and self.component_nsprefix_) else ''
            self.component.export(outfile, level, namespaceprefix_, namespacedef_='', name_='component', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'title':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title = obj_
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'statusCode':
            obj_ = statusCode.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.confidentialityCode = obj_
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'setId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.setId = obj_
            obj_.original_tagname_ = 'setId'
        elif nodeName_ == 'versionNumber':
            obj_ = ST_r2b.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.versionNumber = obj_
            obj_.original_tagname_ = 'versionNumber'
        elif nodeName_ == 'copyTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.copyTime = obj_
            obj_.original_tagname_ = 'copyTime'
        elif nodeName_ == 'recordTarget':
            obj_ = POCD_MT000040UV02_RecordTarget.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recordTarget.append(obj_)
            obj_.original_tagname_ = 'recordTarget'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040UV02_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'dataEnterer':
            obj_ = POCD_MT000040UV02_DataEnterer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dataEnterer = obj_
            obj_.original_tagname_ = 'dataEnterer'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040UV02_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'custodian':
            obj_ = POCD_MT000040UV02_Custodian.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.custodian = obj_
            obj_.original_tagname_ = 'custodian'
        elif nodeName_ == 'informationRecipient':
            obj_ = POCD_MT000040UV02_Participant.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informationRecipient.append(obj_)
            obj_.original_tagname_ = 'informationRecipient'
        elif nodeName_ == 'legalAuthenticator':
            obj_ = POCD_MT000040UV02_LegalAuthenticator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.legalAuthenticator.append(obj_)
            obj_.original_tagname_ = 'legalAuthenticator'
        elif nodeName_ == 'authenticator':
            obj_ = POCD_MT000040UV02_Authenticator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authenticator.append(obj_)
            obj_.original_tagname_ = 'authenticator'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040UV02_Participant2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'inFulfillmentOf':
            obj_ = POCD_MT000040UV02_InFulfillmentOf.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inFulfillmentOf.append(obj_)
            obj_.original_tagname_ = 'inFulfillmentOf'
        elif nodeName_ == 'documentationOf':
            obj_ = POCD_MT000040UV02_DocumentationOf.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.documentationOf.append(obj_)
            obj_.original_tagname_ = 'documentationOf'
        elif nodeName_ == 'relatedDocument':
            obj_ = POCD_MT000040UV02_RelatedDocument.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.relatedDocument.append(obj_)
            obj_.original_tagname_ = 'relatedDocument'
        elif nodeName_ == 'authorization':
            obj_ = POCD_MT000040UV02_Authorization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authorization.append(obj_)
            obj_.original_tagname_ = 'authorization'
        elif nodeName_ == 'componentOf':
            obj_ = POCD_MT000040UV02_Component1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.componentOf = obj_
            obj_.original_tagname_ = 'componentOf'
        elif nodeName_ == 'component':
            obj_ = POCD_MT000040UV02_Component2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.component = obj_
            obj_.original_tagname_ = 'component'
# end class POCD_MT000040UV02_ClinicalDocument


class POCD_MT000040UV02_Component1(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'COMP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, encompassingEncounter: 'POCD_MT000040UV02.EncompassingEncounter' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.encompassingEncounter = encompassingEncounter
        self.encompassingEncounter_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Component1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Component1.subclass:
            return POCD_MT000040UV02_Component1.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Component1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_encompassingEncounter(self):
        return self.encompassingEncounter
    def set_encompassingEncounter(self, encompassingEncounter):
        self.encompassingEncounter = encompassingEncounter
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.encompassingEncounter is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component1', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Component1')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Component1':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Component1')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Component1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Component1'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.encompassingEncounter is not None:
            namespaceprefix_ = self.encompassingEncounter_nsprefix_ + ':' if (UseCapturedNS_ and self.encompassingEncounter_nsprefix_) else ''
            self.encompassingEncounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encompassingEncounter', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'encompassingEncounter':
            obj_ = POCD_MT000040UV02_EncompassingEncounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encompassingEncounter = obj_
            obj_.original_tagname_ = 'encompassingEncounter'
# end class POCD_MT000040UV02_Component1


class POCD_MT000040UV02_Component2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, nonXMLBody: 'POCD_MT000040UV02.NonXMLBody' = None, structuredBody: 'POCD_MT000040UV02.StructuredBody' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.nonXMLBody = nonXMLBody
        self.nonXMLBody_nsprefix_ = None
        self.structuredBody = structuredBody
        self.structuredBody_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Component2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Component2.subclass:
            return POCD_MT000040UV02_Component2.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Component2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_nonXMLBody(self):
        return self.nonXMLBody
    def set_nonXMLBody(self, nonXMLBody):
        self.nonXMLBody = nonXMLBody
    def get_structuredBody(self):
        return self.structuredBody
    def set_structuredBody(self, structuredBody):
        self.structuredBody = structuredBody
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd):
        self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.nonXMLBody is not None or
            self.structuredBody is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Component2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Component2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Component2')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Component2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Component2'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.nonXMLBody is not None:
            namespaceprefix_ = self.nonXMLBody_nsprefix_ + ':' if (UseCapturedNS_ and self.nonXMLBody_nsprefix_) else ''
            self.nonXMLBody.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nonXMLBody', pretty_print=pretty_print)
        if self.structuredBody is not None:
            namespaceprefix_ = self.structuredBody_nsprefix_ + ':' if (UseCapturedNS_ and self.structuredBody_nsprefix_) else ''
            self.structuredBody.export(outfile, level, namespaceprefix_, namespacedef_='', name_='structuredBody', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'nonXMLBody':
            obj_ = POCD_MT000040UV02_NonXMLBody.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.nonXMLBody = obj_
            obj_.original_tagname_ = 'nonXMLBody'
        elif nodeName_ == 'structuredBody':
            obj_ = POCD_MT000040UV02_StructuredBody.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.structuredBody = obj_
            obj_.original_tagname_ = 'structuredBody'
# end class POCD_MT000040UV02_Component2


class POCD_MT000040UV02_Component3(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, section: 'POCD_MT000040UV02.Section' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.section = section
        self.section_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Component3)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Component3.subclass:
            return POCD_MT000040UV02_Component3.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Component3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_section(self):
        return self.section
    def set_section(self, section):
        self.section = section
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd):
        self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.section is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component3', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Component3')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Component3':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Component3')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Component3', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Component3'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component3', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.section is not None:
            namespaceprefix_ = self.section_nsprefix_ + ':' if (UseCapturedNS_ and self.section_nsprefix_) else ''
            self.section.export(outfile, level, namespaceprefix_, namespacedef_='', name_='section', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'section':
            obj_ = POCD_MT000040UV02_Section.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.section = obj_
            obj_.original_tagname_ = 'section'
# end class POCD_MT000040UV02_Component3


class POCD_MT000040UV02_Component4(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, sequenceNumber: 'INT' = None, seperatableInd: 'BL' = None, act: 'POCD_MT000040UV02.Act' = None, encounter: 'POCD_MT000040UV02.Encounter' = None, observation: 'POCD_MT000040UV02.Observation' = None, observationMedia: 'POCD_MT000040UV02.ObservationMedia' = None, organizer: 'POCD_MT000040UV02.Organizer' = None, procedure: 'POCD_MT000040UV02.Procedure' = None, regionOfInterest: 'POCD_MT000040UV02.RegionOfInterest' = None, substanceAdministration: 'POCD_MT000040UV02.SubstanceAdministration' = None, supply: 'POCD_MT000040UV02.Supply' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.sequenceNumber = sequenceNumber
        self.sequenceNumber_nsprefix_ = None
        self.seperatableInd = seperatableInd
        self.seperatableInd_nsprefix_ = None
        self.act = act
        self.act_nsprefix_ = None
        self.encounter = encounter
        self.encounter_nsprefix_ = None
        self.observation = observation
        self.observation_nsprefix_ = None
        self.observationMedia = observationMedia
        self.observationMedia_nsprefix_ = None
        self.organizer = organizer
        self.organizer_nsprefix_ = None
        self.procedure = procedure
        self.procedure_nsprefix_ = None
        self.regionOfInterest = regionOfInterest
        self.regionOfInterest_nsprefix_ = None
        self.substanceAdministration = substanceAdministration
        self.substanceAdministration_nsprefix_ = None
        self.supply = supply
        self.supply_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Component4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Component4.subclass:
            return POCD_MT000040UV02_Component4.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Component4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_sequenceNumber(self):
        return self.sequenceNumber
    def set_sequenceNumber(self, sequenceNumber):
        self.sequenceNumber = sequenceNumber
    def get_seperatableInd(self):
        return self.seperatableInd
    def set_seperatableInd(self, seperatableInd):
        self.seperatableInd = seperatableInd
    def get_act(self):
        return self.act
    def set_act(self, act):
        self.act = act
    def get_encounter(self):
        return self.encounter
    def set_encounter(self, encounter):
        self.encounter = encounter
    def get_observation(self):
        return self.observation
    def set_observation(self, observation):
        self.observation = observation
    def get_observationMedia(self):
        return self.observationMedia
    def set_observationMedia(self, observationMedia):
        self.observationMedia = observationMedia
    def get_organizer(self):
        return self.organizer
    def set_organizer(self, organizer):
        self.organizer = organizer
    def get_procedure(self):
        return self.procedure
    def set_procedure(self, procedure):
        self.procedure = procedure
    def get_regionOfInterest(self):
        return self.regionOfInterest
    def set_regionOfInterest(self, regionOfInterest):
        self.regionOfInterest = regionOfInterest
    def get_substanceAdministration(self):
        return self.substanceAdministration
    def set_substanceAdministration(self, substanceAdministration):
        self.substanceAdministration = substanceAdministration
    def get_supply(self):
        return self.supply
    def set_supply(self, supply):
        self.supply = supply
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd):
        self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.sequenceNumber is not None or
            self.seperatableInd is not None or
            self.act is not None or
            self.encounter is not None or
            self.observation is not None or
            self.observationMedia is not None or
            self.organizer is not None or
            self.procedure is not None or
            self.regionOfInterest is not None or
            self.substanceAdministration is not None or
            self.supply is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component4', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Component4')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Component4':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Component4')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Component4', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Component4'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component4', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.sequenceNumber is not None:
            namespaceprefix_ = self.sequenceNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.sequenceNumber_nsprefix_) else ''
            self.sequenceNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sequenceNumber', pretty_print=pretty_print)
        if self.seperatableInd is not None:
            namespaceprefix_ = self.seperatableInd_nsprefix_ + ':' if (UseCapturedNS_ and self.seperatableInd_nsprefix_) else ''
            self.seperatableInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='seperatableInd', pretty_print=pretty_print)
        if self.act is not None:
            namespaceprefix_ = self.act_nsprefix_ + ':' if (UseCapturedNS_ and self.act_nsprefix_) else ''
            self.act.export(outfile, level, namespaceprefix_, namespacedef_='', name_='act', pretty_print=pretty_print)
        if self.encounter is not None:
            namespaceprefix_ = self.encounter_nsprefix_ + ':' if (UseCapturedNS_ and self.encounter_nsprefix_) else ''
            self.encounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encounter', pretty_print=pretty_print)
        if self.observation is not None:
            namespaceprefix_ = self.observation_nsprefix_ + ':' if (UseCapturedNS_ and self.observation_nsprefix_) else ''
            self.observation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observation', pretty_print=pretty_print)
        if self.observationMedia is not None:
            namespaceprefix_ = self.observationMedia_nsprefix_ + ':' if (UseCapturedNS_ and self.observationMedia_nsprefix_) else ''
            self.observationMedia.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observationMedia', pretty_print=pretty_print)
        if self.organizer is not None:
            namespaceprefix_ = self.organizer_nsprefix_ + ':' if (UseCapturedNS_ and self.organizer_nsprefix_) else ''
            self.organizer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organizer', pretty_print=pretty_print)
        if self.procedure is not None:
            namespaceprefix_ = self.procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.procedure_nsprefix_) else ''
            self.procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='procedure', pretty_print=pretty_print)
        if self.regionOfInterest is not None:
            namespaceprefix_ = self.regionOfInterest_nsprefix_ + ':' if (UseCapturedNS_ and self.regionOfInterest_nsprefix_) else ''
            self.regionOfInterest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='regionOfInterest', pretty_print=pretty_print)
        if self.substanceAdministration is not None:
            namespaceprefix_ = self.substanceAdministration_nsprefix_ + ':' if (UseCapturedNS_ and self.substanceAdministration_nsprefix_) else ''
            self.substanceAdministration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='substanceAdministration', pretty_print=pretty_print)
        if self.supply is not None:
            namespaceprefix_ = self.supply_nsprefix_ + ':' if (UseCapturedNS_ and self.supply_nsprefix_) else ''
            self.supply.export(outfile, level, namespaceprefix_, namespacedef_='', name_='supply', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'sequenceNumber':
            class_obj_ = self.get_class_obj_(child_, INT)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sequenceNumber = obj_
            obj_.original_tagname_ = 'sequenceNumber'
        elif nodeName_ == 'seperatableInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.seperatableInd = obj_
            obj_.original_tagname_ = 'seperatableInd'
        elif nodeName_ == 'act':
            obj_ = POCD_MT000040UV02_Act.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.act = obj_
            obj_.original_tagname_ = 'act'
        elif nodeName_ == 'encounter':
            obj_ = POCD_MT000040UV02_Encounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encounter = obj_
            obj_.original_tagname_ = 'encounter'
        elif nodeName_ == 'observation':
            obj_ = POCD_MT000040UV02_Observation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observation = obj_
            obj_.original_tagname_ = 'observation'
        elif nodeName_ == 'observationMedia':
            obj_ = POCD_MT000040UV02_ObservationMedia.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observationMedia = obj_
            obj_.original_tagname_ = 'observationMedia'
        elif nodeName_ == 'organizer':
            obj_ = POCD_MT000040UV02_Organizer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organizer = obj_
            obj_.original_tagname_ = 'organizer'
        elif nodeName_ == 'procedure':
            obj_ = POCD_MT000040UV02_Procedure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.procedure = obj_
            obj_.original_tagname_ = 'procedure'
        elif nodeName_ == 'regionOfInterest':
            obj_ = POCD_MT000040UV02_RegionOfInterest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.regionOfInterest = obj_
            obj_.original_tagname_ = 'regionOfInterest'
        elif nodeName_ == 'substanceAdministration':
            obj_ = POCD_MT000040UV02_SubstanceAdministration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.substanceAdministration = obj_
            obj_.original_tagname_ = 'substanceAdministration'
        elif nodeName_ == 'supply':
            obj_ = POCD_MT000040UV02_Supply.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.supply = obj_
            obj_.original_tagname_ = 'supply'
# end class POCD_MT000040UV02_Component4


class POCD_MT000040UV02_Component5(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, section: 'POCD_MT000040UV02.Section' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.section = section
        self.section_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Component5)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Component5.subclass:
            return POCD_MT000040UV02_Component5.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Component5(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_section(self):
        return self.section
    def set_section(self, section):
        self.section = section
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd):
        self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.section is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component5', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Component5')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Component5':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Component5')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Component5', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Component5'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Component5', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.section is not None:
            namespaceprefix_ = self.section_nsprefix_ + ':' if (UseCapturedNS_ and self.section_nsprefix_) else ''
            self.section.export(outfile, level, namespaceprefix_, namespacedef_='', name_='section', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'section':
            obj_ = POCD_MT000040UV02_Section.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.section = obj_
            obj_.original_tagname_ = 'section'
# end class POCD_MT000040UV02_Component5


class POCD_MT000040UV02_Consent(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'CONS', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, statusCode: 'CS' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Consent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Consent.subclass:
            return POCD_MT000040UV02_Consent.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Consent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCM', 'ACCT', 'ACSN', 'ACT', 'ACTN', 'ADJUD', 'AEXPOS', 'ALRT', 'BATTERY', 'CACT', 'CASE', 'CATEGORY', 'CDALVLONE', 'CLNTRL', 'CLUSTER', 'CNOD', 'CNTRCT', 'COMPOSITION', 'CONC', 'COND', 'CONS', 'CONTAINER', 'CONTREG', 'COV', 'CTTEVENT', 'DETPOL', 'DGIMG', 'DIET', 'DISPACT', 'DOC', 'DOCBODY', 'DOCCLIN', 'DOCSECT', 'EHR', 'ENC', 'EXP', 'EXPOS', 'EXTRACT', 'FCNTRCT', 'FOLDER', 'GEN', 'GROUPER', 'INC', 'INFO', 'INFRM', 'INVE', 'INVSTG', 'JURISPOL', 'LIST', 'LLD', 'LOC', 'MPROT', 'OBS', 'OBSCOR', 'OBSSER', 'ORGPOL', 'OUTB', 'PCPR', 'PHN', 'POL', 'POLICY', 'POS', 'POSACC', 'POSCOORD', 'PRN', 'PROC', 'REG', 'REV', 'RLD', 'ROIBND', 'ROIOVL', 'RTRD', 'SBADM', 'SBEXT', 'SCOPOL', 'SEQ', 'SEQVAR', 'SFWL', 'SIT', 'SPCOBS', 'SPCTRT', 'SPECCOLLECT', 'SPLY', 'STC', 'STDPOL', 'STN', 'STORE', 'SUBST', 'SUP', 'TEXPOS', 'TOPIC', 'TRD', 'TRFR', 'TRNS', 'VERIF', 'XACT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClass_patterns_, ))
    validate_ActClass_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.statusCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Consent', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Consent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Consent':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Consent')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Consent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Consent'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "CONS" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Consent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
# end class POCD_MT000040UV02_Consent


class POCD_MT000040UV02_Consumable(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'CSM', contextControlCode: 'ContextControl' = 'ON', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, manufacturedProduct: 'POCD_MT000040UV02.ManufacturedProduct' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.manufacturedProduct = manufacturedProduct
        self.manufacturedProduct_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Consumable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Consumable.subclass:
            return POCD_MT000040UV02_Consumable.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Consumable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_manufacturedProduct(self):
        return self.manufacturedProduct
    def set_manufacturedProduct(self, manufacturedProduct):
        self.manufacturedProduct = manufacturedProduct
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def set_contextControlCode(self, contextControlCode):
        self.contextControlCode = contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ALY', 'ATND', 'AUT', 'AUTHEN', 'BBY', 'BEN', 'CAGNT', 'CALLBCK', 'CAT', 'CON', 'COV', 'CSM', 'CST', 'DEV', 'DIR', 'DIS', 'DIST', 'DON', 'DST', 'ELOC', 'ENT', 'ESC', 'EXPAGNT', 'EXPART', 'EXPTRGT', 'EXSRC', 'GUAR', 'HLD', 'IND', 'INF', 'IRCP', 'LA', 'LOC', 'NOT', 'NRD', 'ORG', 'PART', 'PPRF', 'PRCP', 'PRD', 'PRF', 'RCT', 'RCV', 'RDV', 'REF', 'REFB', 'REFT', 'RESP', 'RML', 'SBJ', 'SPC', 'SPRF', 'TRANS', 'TRC', 'VIA', 'VRF', 'WIT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationType_patterns_, ))
    validate_ParticipationType_patterns_ = [['^([^\\s]+)$']]
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AN', 'AP', 'ON', 'OP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ContextControl' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ContextControl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ContextControl_patterns_, ))
    validate_ContextControl_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.manufacturedProduct is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Consumable', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Consumable')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Consumable':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Consumable')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Consumable', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Consumable'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "CSM" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode != "ON" and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Consumable', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.manufacturedProduct is not None:
            namespaceprefix_ = self.manufacturedProduct_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturedProduct_nsprefix_) else ''
            self.manufacturedProduct.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturedProduct', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.contextControlCode = ' '.join(self.contextControlCode.split())
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'manufacturedProduct':
            obj_ = POCD_MT000040UV02_ManufacturedProduct.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturedProduct = obj_
            obj_.original_tagname_ = 'manufacturedProduct'
# end class POCD_MT000040UV02_Consumable


class POCD_MT000040UV02_Criterion(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassObservation' = 'OBS', moodCode: 'ActMood' = 'EVN.CRT', actionNegationInd: 'bl' = None, isCriterionInd: 'bl' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, value: 'ANY' = None, valueNegationInd: 'BL' = None, interpretationCode: 'CE' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        self.actionNegationInd = _cast(bool, actionNegationInd)
        self.actionNegationInd_nsprefix_ = None
        self.isCriterionInd = _cast(bool, isCriterionInd)
        self.isCriterionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
        self.valueNegationInd = valueNegationInd
        self.valueNegationInd_nsprefix_ = None
        self.interpretationCode = interpretationCode
        self.interpretationCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Criterion)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Criterion.subclass:
            return POCD_MT000040UV02_Criterion.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Criterion(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def set_value_with_type(self, value):
        self.value = value
        value.original_tagname_ = 'value'
        value.extensiontype_ = value.__class__.__name__
    def get_valueNegationInd(self):
        return self.valueNegationInd
    def set_valueNegationInd(self, valueNegationInd):
        self.valueNegationInd = valueNegationInd
    def get_interpretationCode(self):
        return self.interpretationCode
    def set_interpretationCode(self, interpretationCode):
        self.interpretationCode = interpretationCode
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def get_actionNegationInd(self):
        return self.actionNegationInd
    def set_actionNegationInd(self, actionNegationInd):
        self.actionNegationInd = actionNegationInd
    def get_isCriterionInd(self):
        return self.isCriterionInd
    def set_isCriterionInd(self, isCriterionInd):
        self.isCriterionInd = isCriterionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['OBS', 'ROIBND', 'ROIOVL', 'LLD', 'PRN', 'RLD', 'SFWL', 'SIT', 'STN', 'SUP', 'RTRD', 'TRD', 'ALRT', 'BATTERY', 'CLNTRL', 'CNOD', 'CONC', 'COND', 'CASE', 'OUTB', 'DGIMG', 'GEN', 'DETPOL', 'EXP', 'LOC', 'PHN', 'POL', 'SEQ', 'SEQVAR', 'INVSTG', 'OBSSER', 'OBSCOR', 'POS', 'POSACC', 'POSCOORD', 'SPCOBS', 'VERIF']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClassObservation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassObservation_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClassObservation_patterns_, ))
    validate_ActClassObservation_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.text is not None or
            self.value is not None or
            self.valueNegationInd is not None or
            self.interpretationCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Criterion', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Criterion')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Criterion':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Criterion')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Criterion', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Criterion'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "OBS" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN.CRT" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
        if self.actionNegationInd is not None and 'actionNegationInd' not in already_processed:
            already_processed.add('actionNegationInd')
            outfile.write(' actionNegationInd="%s"' % self.gds_format_boolean(self.actionNegationInd, input_name='actionNegationInd'))
        if self.isCriterionInd is not None and 'isCriterionInd' not in already_processed:
            already_processed.add('isCriterionInd')
            outfile.write(' isCriterionInd="%s"' % self.gds_format_boolean(self.isCriterionInd, input_name='isCriterionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Criterion', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.value is not None:
            self.value.export(outfile, level, namespaceprefix_, name_='value', namespacedef_='', pretty_print=pretty_print)
        if self.valueNegationInd is not None:
            namespaceprefix_ = self.valueNegationInd_nsprefix_ + ':' if (UseCapturedNS_ and self.valueNegationInd_nsprefix_) else ''
            self.valueNegationInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueNegationInd', pretty_print=pretty_print)
        if self.interpretationCode is not None:
            namespaceprefix_ = self.interpretationCode_nsprefix_ + ':' if (UseCapturedNS_ and self.interpretationCode_nsprefix_) else ''
            self.interpretationCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='interpretationCode', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
        value = find_attr_value_('actionNegationInd', node)
        if value is not None and 'actionNegationInd' not in already_processed:
            already_processed.add('actionNegationInd')
            if value in ('true', '1'):
                self.actionNegationInd = True
            elif value in ('false', '0'):
                self.actionNegationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.actionNegationInd)    # validate type bl
        value = find_attr_value_('isCriterionInd', node)
        if value is not None and 'isCriterionInd' not in already_processed:
            already_processed.add('isCriterionInd')
            if value in ('true', '1'):
                self.isCriterionInd = True
            elif value in ('false', '0'):
                self.isCriterionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.isCriterionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'value':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()["" + type_name_]
                obj_ = class_.factory()
                obj_.build(child_, gds_collector_=gds_collector_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <value> element')
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'valueNegationInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueNegationInd = obj_
            obj_.original_tagname_ = 'valueNegationInd'
        elif nodeName_ == 'interpretationCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.interpretationCode = obj_
            obj_.original_tagname_ = 'interpretationCode'
# end class POCD_MT000040UV02_Criterion


class POCD_MT000040UV02_Custodian(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'CST', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, assignedCustodian: 'POCD_MT000040UV02.AssignedCustodian' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.assignedCustodian = assignedCustodian
        self.assignedCustodian_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Custodian)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Custodian.subclass:
            return POCD_MT000040UV02_Custodian.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Custodian(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_assignedCustodian(self):
        return self.assignedCustodian
    def set_assignedCustodian(self, assignedCustodian):
        self.assignedCustodian = assignedCustodian
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ALY', 'ATND', 'AUT', 'AUTHEN', 'BBY', 'BEN', 'CAGNT', 'CALLBCK', 'CAT', 'CON', 'COV', 'CSM', 'CST', 'DEV', 'DIR', 'DIS', 'DIST', 'DON', 'DST', 'ELOC', 'ENT', 'ESC', 'EXPAGNT', 'EXPART', 'EXPTRGT', 'EXSRC', 'GUAR', 'HLD', 'IND', 'INF', 'IRCP', 'LA', 'LOC', 'NOT', 'NRD', 'ORG', 'PART', 'PPRF', 'PRCP', 'PRD', 'PRF', 'RCT', 'RCV', 'RDV', 'REF', 'REFB', 'REFT', 'RESP', 'RML', 'SBJ', 'SPC', 'SPRF', 'TRANS', 'TRC', 'VIA', 'VRF', 'WIT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationType_patterns_, ))
    validate_ParticipationType_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.assignedCustodian is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Custodian', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Custodian')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Custodian':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Custodian')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Custodian', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Custodian'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "CST" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Custodian', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.assignedCustodian is not None:
            namespaceprefix_ = self.assignedCustodian_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedCustodian_nsprefix_) else ''
            self.assignedCustodian.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedCustodian', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'assignedCustodian':
            obj_ = POCD_MT000040UV02_AssignedCustodian.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedCustodian = obj_
            obj_.original_tagname_ = 'assignedCustodian'
# end class POCD_MT000040UV02_Custodian


class POCD_MT000040UV02_CustodianOrganization(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClass' = 'ORG', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, name: 'ON' = None, telecom: 'TEL' = None, addr: 'AD' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.addr = addr
        self.addr_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_CustodianOrganization)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_CustodianOrganization.subclass:
            return POCD_MT000040UV02_CustodianOrganization.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_CustodianOrganization(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_determinerCode(self):
        return self.determinerCode
    def set_determinerCode(self, determinerCode):
        self.determinerCode = determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityClass(self, value):
        # Validate type EntityClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ANM', 'CER', 'CHEM', 'CITY', 'CONT', 'COUNTRY', 'COUNTY', 'DEV', 'ENT', 'FOOD', 'HCE', 'HOLD', 'LIV', 'MAT', 'MIC', 'MMAT', 'MODDV', 'NAT', 'NLIV', 'ORG', 'PLC', 'PLNT', 'PROVINCE', 'PSN', 'PUB', 'RGRP', 'STATE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityClass_patterns_, ))
    validate_EntityClass_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INSTANCE', 'KIND', 'QUANTIFIED_KIND']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityDeterminer' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityDeterminer_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityDeterminer_patterns_, ))
    validate_EntityDeterminer_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.name is not None or
            self.telecom is not None or
            self.addr is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.CustodianOrganization', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.CustodianOrganization')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.CustodianOrganization':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.CustodianOrganization')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.CustodianOrganization', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.CustodianOrganization'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ORG" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode != "INSTANCE" and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.CustodianOrganization', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.telecom is not None:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            self.telecom.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.addr is not None:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            self.addr.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClass(self.classCode)    # validate type EntityClass
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'name':
            obj_ = ON.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom = obj_
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr = obj_
            obj_.original_tagname_ = 'addr'
# end class POCD_MT000040UV02_CustodianOrganization


class POCD_MT000040UV02_DataEnterer(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'ENT', contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, time: 'TS' = None, assignedEntity: 'POCD_MT000040UV02.AssignedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_DataEnterer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_DataEnterer.subclass:
            return POCD_MT000040UV02_DataEnterer.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_DataEnterer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def set_contextControlCode(self, contextControlCode):
        self.contextControlCode = contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ALY', 'ATND', 'AUT', 'AUTHEN', 'BBY', 'BEN', 'CAGNT', 'CALLBCK', 'CAT', 'CON', 'COV', 'CSM', 'CST', 'DEV', 'DIR', 'DIS', 'DIST', 'DON', 'DST', 'ELOC', 'ENT', 'ESC', 'EXPAGNT', 'EXPART', 'EXPTRGT', 'EXSRC', 'GUAR', 'HLD', 'IND', 'INF', 'IRCP', 'LA', 'LOC', 'NOT', 'NRD', 'ORG', 'PART', 'PPRF', 'PRCP', 'PRD', 'PRF', 'RCT', 'RCV', 'RDV', 'REF', 'REFB', 'REFT', 'RESP', 'RML', 'SBJ', 'SPC', 'SPRF', 'TRANS', 'TRC', 'VIA', 'VRF', 'WIT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationType_patterns_, ))
    validate_ParticipationType_patterns_ = [['^([^\\s]+)$']]
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AN', 'AP', 'ON', 'OP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ContextControl' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ContextControl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ContextControl_patterns_, ))
    validate_ContextControl_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.time is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.DataEnterer', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.DataEnterer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.DataEnterer':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.DataEnterer')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.DataEnterer', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.DataEnterer'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "ENT" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode != "OP" and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.DataEnterer', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.contextControlCode = ' '.join(self.contextControlCode.split())
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040UV02_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class POCD_MT000040UV02_DataEnterer


class POCD_MT000040UV02_Device(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassDevice' = 'DEV', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CE' = None, manufacturerModelName: 'SC' = None, softwareName: 'SC' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.manufacturerModelName = manufacturerModelName
        self.manufacturerModelName_nsprefix_ = None
        self.softwareName = softwareName
        self.softwareName_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Device)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Device.subclass:
            return POCD_MT000040UV02_Device.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Device(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_manufacturerModelName(self):
        return self.manufacturerModelName
    def set_manufacturerModelName(self, manufacturerModelName):
        self.manufacturerModelName = manufacturerModelName
    def get_softwareName(self):
        return self.softwareName
    def set_softwareName(self, softwareName):
        self.softwareName = softwareName
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_determinerCode(self):
        return self.determinerCode
    def set_determinerCode(self, determinerCode):
        self.determinerCode = determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityClassDevice(self, value):
        # Validate type EntityClassDevice, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DEV', 'CER', 'MODDV']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityClassDevice' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityClassDevice_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityClassDevice_patterns_, ))
    validate_EntityClassDevice_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INSTANCE', 'KIND', 'QUANTIFIED_KIND']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityDeterminer' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityDeterminer_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityDeterminer_patterns_, ))
    validate_EntityDeterminer_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.manufacturerModelName is not None or
            self.softwareName is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Device', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Device')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Device':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Device')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Device', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Device'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DEV" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode != "INSTANCE" and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Device', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.manufacturerModelName is not None:
            namespaceprefix_ = self.manufacturerModelName_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturerModelName_nsprefix_) else ''
            self.manufacturerModelName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturerModelName', pretty_print=pretty_print)
        if self.softwareName is not None:
            namespaceprefix_ = self.softwareName_nsprefix_ + ':' if (UseCapturedNS_ and self.softwareName_nsprefix_) else ''
            self.softwareName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='softwareName', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassDevice(self.classCode)    # validate type EntityClassDevice
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'manufacturerModelName':
            obj_ = SC.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturerModelName = obj_
            obj_.original_tagname_ = 'manufacturerModelName'
        elif nodeName_ == 'softwareName':
            obj_ = SC.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.softwareName = obj_
            obj_.original_tagname_ = 'softwareName'
# end class POCD_MT000040UV02_Device


class POCD_MT000040UV02_DocumentationOf(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'DOC', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, serviceEvent: 'POCD_MT000040UV02.ServiceEvent' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.serviceEvent = serviceEvent
        self.serviceEvent_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_DocumentationOf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_DocumentationOf.subclass:
            return POCD_MT000040UV02_DocumentationOf.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_DocumentationOf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_serviceEvent(self):
        return self.serviceEvent
    def set_serviceEvent(self, serviceEvent):
        self.serviceEvent = serviceEvent
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.serviceEvent is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.DocumentationOf', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.DocumentationOf')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.DocumentationOf':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.DocumentationOf')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.DocumentationOf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.DocumentationOf'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "DOC" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.DocumentationOf', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.serviceEvent is not None:
            namespaceprefix_ = self.serviceEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.serviceEvent_nsprefix_) else ''
            self.serviceEvent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='serviceEvent', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'serviceEvent':
            obj_ = POCD_MT000040UV02_ServiceEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.serviceEvent = obj_
            obj_.original_tagname_ = 'serviceEvent'
# end class POCD_MT000040UV02_DocumentationOf


class POCD_MT000040UV02_EncompassingEncounter(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'ENC', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, effectiveTime: 'IVL_TS' = None, admissionReferralSourceCode: 'CE' = None, dischargeDispositionCode: 'CE' = None, responsibleParty: 'POCD_MT000040UV02.ResponsibleParty' = None, encounterParticipant: List_['POCD_MT000040UV02.EncounterParticipant'] = None, location: 'POCD_MT000040UV02.Location' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.admissionReferralSourceCode = admissionReferralSourceCode
        self.admissionReferralSourceCode_nsprefix_ = None
        self.dischargeDispositionCode = dischargeDispositionCode
        self.dischargeDispositionCode_nsprefix_ = None
        self.responsibleParty = responsibleParty
        self.responsibleParty_nsprefix_ = None
        if encounterParticipant is None:
            self.encounterParticipant = []
        else:
            self.encounterParticipant = encounterParticipant
        self.encounterParticipant_nsprefix_ = None
        self.location = location
        self.location_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_EncompassingEncounter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_EncompassingEncounter.subclass:
            return POCD_MT000040UV02_EncompassingEncounter.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_EncompassingEncounter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_admissionReferralSourceCode(self):
        return self.admissionReferralSourceCode
    def set_admissionReferralSourceCode(self, admissionReferralSourceCode):
        self.admissionReferralSourceCode = admissionReferralSourceCode
    def get_dischargeDispositionCode(self):
        return self.dischargeDispositionCode
    def set_dischargeDispositionCode(self, dischargeDispositionCode):
        self.dischargeDispositionCode = dischargeDispositionCode
    def get_responsibleParty(self):
        return self.responsibleParty
    def set_responsibleParty(self, responsibleParty):
        self.responsibleParty = responsibleParty
    def get_encounterParticipant(self):
        return self.encounterParticipant
    def set_encounterParticipant(self, encounterParticipant):
        self.encounterParticipant = encounterParticipant
    def add_encounterParticipant(self, value):
        self.encounterParticipant.append(value)
    def insert_encounterParticipant_at(self, index, value):
        self.encounterParticipant.insert(index, value)
    def replace_encounterParticipant_at(self, index, value):
        self.encounterParticipant[index] = value
    def get_location(self):
        return self.location
    def set_location(self, location):
        self.location = location
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCM', 'ACCT', 'ACSN', 'ACT', 'ACTN', 'ADJUD', 'AEXPOS', 'ALRT', 'BATTERY', 'CACT', 'CASE', 'CATEGORY', 'CDALVLONE', 'CLNTRL', 'CLUSTER', 'CNOD', 'CNTRCT', 'COMPOSITION', 'CONC', 'COND', 'CONS', 'CONTAINER', 'CONTREG', 'COV', 'CTTEVENT', 'DETPOL', 'DGIMG', 'DIET', 'DISPACT', 'DOC', 'DOCBODY', 'DOCCLIN', 'DOCSECT', 'EHR', 'ENC', 'EXP', 'EXPOS', 'EXTRACT', 'FCNTRCT', 'FOLDER', 'GEN', 'GROUPER', 'INC', 'INFO', 'INFRM', 'INVE', 'INVSTG', 'JURISPOL', 'LIST', 'LLD', 'LOC', 'MPROT', 'OBS', 'OBSCOR', 'OBSSER', 'ORGPOL', 'OUTB', 'PCPR', 'PHN', 'POL', 'POLICY', 'POS', 'POSACC', 'POSCOORD', 'PRN', 'PROC', 'REG', 'REV', 'RLD', 'ROIBND', 'ROIOVL', 'RTRD', 'SBADM', 'SBEXT', 'SCOPOL', 'SEQ', 'SEQVAR', 'SFWL', 'SIT', 'SPCOBS', 'SPCTRT', 'SPECCOLLECT', 'SPLY', 'STC', 'STDPOL', 'STN', 'STORE', 'SUBST', 'SUP', 'TEXPOS', 'TOPIC', 'TRD', 'TRFR', 'TRNS', 'VERIF', 'XACT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClass_patterns_, ))
    validate_ActClass_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.effectiveTime is not None or
            self.admissionReferralSourceCode is not None or
            self.dischargeDispositionCode is not None or
            self.responsibleParty is not None or
            self.encounterParticipant or
            self.location is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.EncompassingEncounter', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.EncompassingEncounter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.EncompassingEncounter':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.EncompassingEncounter')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.EncompassingEncounter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.EncompassingEncounter'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ENC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.EncompassingEncounter', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.admissionReferralSourceCode is not None:
            namespaceprefix_ = self.admissionReferralSourceCode_nsprefix_ + ':' if (UseCapturedNS_ and self.admissionReferralSourceCode_nsprefix_) else ''
            self.admissionReferralSourceCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='admissionReferralSourceCode', pretty_print=pretty_print)
        if self.dischargeDispositionCode is not None:
            namespaceprefix_ = self.dischargeDispositionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.dischargeDispositionCode_nsprefix_) else ''
            self.dischargeDispositionCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dischargeDispositionCode', pretty_print=pretty_print)
        if self.responsibleParty is not None:
            namespaceprefix_ = self.responsibleParty_nsprefix_ + ':' if (UseCapturedNS_ and self.responsibleParty_nsprefix_) else ''
            self.responsibleParty.export(outfile, level, namespaceprefix_, namespacedef_='', name_='responsibleParty', pretty_print=pretty_print)
        for encounterParticipant_ in self.encounterParticipant:
            namespaceprefix_ = self.encounterParticipant_nsprefix_ + ':' if (UseCapturedNS_ and self.encounterParticipant_nsprefix_) else ''
            encounterParticipant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encounterParticipant', pretty_print=pretty_print)
        if self.location is not None:
            namespaceprefix_ = self.location_nsprefix_ + ':' if (UseCapturedNS_ and self.location_nsprefix_) else ''
            self.location.export(outfile, level, namespaceprefix_, namespacedef_='', name_='location', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'admissionReferralSourceCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.admissionReferralSourceCode = obj_
            obj_.original_tagname_ = 'admissionReferralSourceCode'
        elif nodeName_ == 'dischargeDispositionCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dischargeDispositionCode = obj_
            obj_.original_tagname_ = 'dischargeDispositionCode'
        elif nodeName_ == 'responsibleParty':
            obj_ = POCD_MT000040UV02_ResponsibleParty.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.responsibleParty = obj_
            obj_.original_tagname_ = 'responsibleParty'
        elif nodeName_ == 'encounterParticipant':
            obj_ = POCD_MT000040UV02_EncounterParticipant.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encounterParticipant.append(obj_)
            obj_.original_tagname_ = 'encounterParticipant'
        elif nodeName_ == 'location':
            obj_ = POCD_MT000040UV02_Location.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.location = obj_
            obj_.original_tagname_ = 'location'
# end class POCD_MT000040UV02_EncompassingEncounter


class POCD_MT000040UV02_Encounter(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'ENC', moodCode: 'x_DocumentEncounterMood' = None, actionNegationInd: 'bl' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, statusCode: 'CS' = None, effectiveTime: 'IVL_TS' = None, activityTime: List_['SXCM_TS'] = None, availabilityTime: 'TS' = None, priorityCode: 'CE' = None, confidentialityCode: 'CE' = None, reasonCode: List_['CE'] = None, languageCode: 'CS' = None, admissionReferralSourceCode: 'CE' = None, lengthOfStayQuantity: 'PQ' = None, dischargeDispositionCode: 'CE' = None, preAdmitTestInd: 'BL' = None, specialCourtesiesCode: List_['CE'] = None, specialArrangementCode: List_['CE'] = None, subject: 'POCD_MT000040UV02.Subject' = None, specimen: List_['POCD_MT000040UV02.Specimen'] = None, performer: List_['POCD_MT000040UV02.Performer2'] = None, author: List_['POCD_MT000040UV02.Author'] = None, informant: List_['POCD_MT000040UV02.Informant12'] = None, participant: List_['POCD_MT000040UV02.Participant3'] = None, entryRelationship: List_['POCD_MT000040UV02.EntryRelationship'] = None, reference: List_['POCD_MT000040UV02.Reference'] = None, precondition: List_['POCD_MT000040UV02.Precondition'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        self.actionNegationInd = _cast(bool, actionNegationInd)
        self.actionNegationInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        if activityTime is None:
            self.activityTime = []
        else:
            self.activityTime = activityTime
        self.activityTime_nsprefix_ = None
        self.availabilityTime = availabilityTime
        self.availabilityTime_nsprefix_ = None
        self.priorityCode = priorityCode
        self.priorityCode_nsprefix_ = None
        self.confidentialityCode = confidentialityCode
        self.confidentialityCode_nsprefix_ = None
        if reasonCode is None:
            self.reasonCode = []
        else:
            self.reasonCode = reasonCode
        self.reasonCode_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        self.admissionReferralSourceCode = admissionReferralSourceCode
        self.admissionReferralSourceCode_nsprefix_ = None
        self.lengthOfStayQuantity = lengthOfStayQuantity
        self.lengthOfStayQuantity_nsprefix_ = None
        self.dischargeDispositionCode = dischargeDispositionCode
        self.dischargeDispositionCode_nsprefix_ = None
        self.preAdmitTestInd = preAdmitTestInd
        self.preAdmitTestInd_nsprefix_ = None
        if specialCourtesiesCode is None:
            self.specialCourtesiesCode = []
        else:
            self.specialCourtesiesCode = specialCourtesiesCode
        self.specialCourtesiesCode_nsprefix_ = None
        if specialArrangementCode is None:
            self.specialArrangementCode = []
        else:
            self.specialArrangementCode = specialArrangementCode
        self.specialArrangementCode_nsprefix_ = None
        self.subject = subject
        self.subject_nsprefix_ = None
        if specimen is None:
            self.specimen = []
        else:
            self.specimen = specimen
        self.specimen_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if entryRelationship is None:
            self.entryRelationship = []
        else:
            self.entryRelationship = entryRelationship
        self.entryRelationship_nsprefix_ = None
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        self.reference_nsprefix_ = None
        if precondition is None:
            self.precondition = []
        else:
            self.precondition = precondition
        self.precondition_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Encounter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Encounter.subclass:
            return POCD_MT000040UV02_Encounter.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Encounter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_activityTime(self):
        return self.activityTime
    def set_activityTime(self, activityTime):
        self.activityTime = activityTime
    def add_activityTime(self, value):
        self.activityTime.append(value)
    def insert_activityTime_at(self, index, value):
        self.activityTime.insert(index, value)
    def replace_activityTime_at(self, index, value):
        self.activityTime[index] = value
    def get_availabilityTime(self):
        return self.availabilityTime
    def set_availabilityTime(self, availabilityTime):
        self.availabilityTime = availabilityTime
    def get_priorityCode(self):
        return self.priorityCode
    def set_priorityCode(self, priorityCode):
        self.priorityCode = priorityCode
    def get_confidentialityCode(self):
        return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode):
        self.confidentialityCode = confidentialityCode
    def get_reasonCode(self):
        return self.reasonCode
    def set_reasonCode(self, reasonCode):
        self.reasonCode = reasonCode
    def add_reasonCode(self, value):
        self.reasonCode.append(value)
    def insert_reasonCode_at(self, index, value):
        self.reasonCode.insert(index, value)
    def replace_reasonCode_at(self, index, value):
        self.reasonCode[index] = value
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_admissionReferralSourceCode(self):
        return self.admissionReferralSourceCode
    def set_admissionReferralSourceCode(self, admissionReferralSourceCode):
        self.admissionReferralSourceCode = admissionReferralSourceCode
    def get_lengthOfStayQuantity(self):
        return self.lengthOfStayQuantity
    def set_lengthOfStayQuantity(self, lengthOfStayQuantity):
        self.lengthOfStayQuantity = lengthOfStayQuantity
    def get_dischargeDispositionCode(self):
        return self.dischargeDispositionCode
    def set_dischargeDispositionCode(self, dischargeDispositionCode):
        self.dischargeDispositionCode = dischargeDispositionCode
    def get_preAdmitTestInd(self):
        return self.preAdmitTestInd
    def set_preAdmitTestInd(self, preAdmitTestInd):
        self.preAdmitTestInd = preAdmitTestInd
    def get_specialCourtesiesCode(self):
        return self.specialCourtesiesCode
    def set_specialCourtesiesCode(self, specialCourtesiesCode):
        self.specialCourtesiesCode = specialCourtesiesCode
    def add_specialCourtesiesCode(self, value):
        self.specialCourtesiesCode.append(value)
    def insert_specialCourtesiesCode_at(self, index, value):
        self.specialCourtesiesCode.insert(index, value)
    def replace_specialCourtesiesCode_at(self, index, value):
        self.specialCourtesiesCode[index] = value
    def get_specialArrangementCode(self):
        return self.specialArrangementCode
    def set_specialArrangementCode(self, specialArrangementCode):
        self.specialArrangementCode = specialArrangementCode
    def add_specialArrangementCode(self, value):
        self.specialArrangementCode.append(value)
    def insert_specialArrangementCode_at(self, index, value):
        self.specialArrangementCode.insert(index, value)
    def replace_specialArrangementCode_at(self, index, value):
        self.specialArrangementCode[index] = value
    def get_subject(self):
        return self.subject
    def set_subject(self, subject):
        self.subject = subject
    def get_specimen(self):
        return self.specimen
    def set_specimen(self, specimen):
        self.specimen = specimen
    def add_specimen(self, value):
        self.specimen.append(value)
    def insert_specimen_at(self, index, value):
        self.specimen.insert(index, value)
    def replace_specimen_at(self, index, value):
        self.specimen[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_entryRelationship(self):
        return self.entryRelationship
    def set_entryRelationship(self, entryRelationship):
        self.entryRelationship = entryRelationship
    def add_entryRelationship(self, value):
        self.entryRelationship.append(value)
    def insert_entryRelationship_at(self, index, value):
        self.entryRelationship.insert(index, value)
    def replace_entryRelationship_at(self, index, value):
        self.entryRelationship[index] = value
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def add_reference(self, value):
        self.reference.append(value)
    def insert_reference_at(self, index, value):
        self.reference.insert(index, value)
    def replace_reference_at(self, index, value):
        self.reference[index] = value
    def get_precondition(self):
        return self.precondition
    def set_precondition(self, precondition):
        self.precondition = precondition
    def add_precondition(self, value):
        self.precondition.append(value)
    def insert_precondition_at(self, index, value):
        self.precondition.insert(index, value)
    def replace_precondition_at(self, index, value):
        self.precondition[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def get_actionNegationInd(self):
        return self.actionNegationInd
    def set_actionNegationInd(self, actionNegationInd):
        self.actionNegationInd = actionNegationInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCM', 'ACCT', 'ACSN', 'ACT', 'ACTN', 'ADJUD', 'AEXPOS', 'ALRT', 'BATTERY', 'CACT', 'CASE', 'CATEGORY', 'CDALVLONE', 'CLNTRL', 'CLUSTER', 'CNOD', 'CNTRCT', 'COMPOSITION', 'CONC', 'COND', 'CONS', 'CONTAINER', 'CONTREG', 'COV', 'CTTEVENT', 'DETPOL', 'DGIMG', 'DIET', 'DISPACT', 'DOC', 'DOCBODY', 'DOCCLIN', 'DOCSECT', 'EHR', 'ENC', 'EXP', 'EXPOS', 'EXTRACT', 'FCNTRCT', 'FOLDER', 'GEN', 'GROUPER', 'INC', 'INFO', 'INFRM', 'INVE', 'INVSTG', 'JURISPOL', 'LIST', 'LLD', 'LOC', 'MPROT', 'OBS', 'OBSCOR', 'OBSSER', 'ORGPOL', 'OUTB', 'PCPR', 'PHN', 'POL', 'POLICY', 'POS', 'POSACC', 'POSCOORD', 'PRN', 'PROC', 'REG', 'REV', 'RLD', 'ROIBND', 'ROIOVL', 'RTRD', 'SBADM', 'SBEXT', 'SCOPOL', 'SEQ', 'SEQVAR', 'SFWL', 'SIT', 'SPCOBS', 'SPCTRT', 'SPECCOLLECT', 'SPLY', 'STC', 'STDPOL', 'STN', 'STORE', 'SUBST', 'SUP', 'TEXPOS', 'TOPIC', 'TRD', 'TRFR', 'TRNS', 'VERIF', 'XACT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClass_patterns_, ))
    validate_ActClass_patterns_ = [['^([^\\s]+)$']]
    def validate_x_DocumentEncounterMood(self, value):
        # Validate type x_DocumentEncounterMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'DEF', 'EVN', 'INT', 'PRMS', 'PRP', 'RQO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_DocumentEncounterMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_DocumentEncounterMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_DocumentEncounterMood_patterns_, ))
    validate_x_DocumentEncounterMood_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.activityTime or
            self.availabilityTime is not None or
            self.priorityCode is not None or
            self.confidentialityCode is not None or
            self.reasonCode or
            self.languageCode is not None or
            self.admissionReferralSourceCode is not None or
            self.lengthOfStayQuantity is not None or
            self.dischargeDispositionCode is not None or
            self.preAdmitTestInd is not None or
            self.specialCourtesiesCode or
            self.specialArrangementCode or
            self.subject is not None or
            self.specimen or
            self.performer or
            self.author or
            self.informant or
            self.participant or
            self.entryRelationship or
            self.reference or
            self.precondition
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Encounter', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Encounter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Encounter':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Encounter')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Encounter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Encounter'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ENC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
        if self.actionNegationInd is not None and 'actionNegationInd' not in already_processed:
            already_processed.add('actionNegationInd')
            outfile.write(' actionNegationInd="%s"' % self.gds_format_boolean(self.actionNegationInd, input_name='actionNegationInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Encounter', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        for activityTime_ in self.activityTime:
            namespaceprefix_ = self.activityTime_nsprefix_ + ':' if (UseCapturedNS_ and self.activityTime_nsprefix_) else ''
            activityTime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='activityTime', pretty_print=pretty_print)
        if self.availabilityTime is not None:
            namespaceprefix_ = self.availabilityTime_nsprefix_ + ':' if (UseCapturedNS_ and self.availabilityTime_nsprefix_) else ''
            self.availabilityTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='availabilityTime', pretty_print=pretty_print)
        if self.priorityCode is not None:
            namespaceprefix_ = self.priorityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.priorityCode_nsprefix_) else ''
            self.priorityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='priorityCode', pretty_print=pretty_print)
        if self.confidentialityCode is not None:
            namespaceprefix_ = self.confidentialityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.confidentialityCode_nsprefix_) else ''
            self.confidentialityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='confidentialityCode', pretty_print=pretty_print)
        for reasonCode_ in self.reasonCode:
            namespaceprefix_ = self.reasonCode_nsprefix_ + ':' if (UseCapturedNS_ and self.reasonCode_nsprefix_) else ''
            reasonCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reasonCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        if self.admissionReferralSourceCode is not None:
            namespaceprefix_ = self.admissionReferralSourceCode_nsprefix_ + ':' if (UseCapturedNS_ and self.admissionReferralSourceCode_nsprefix_) else ''
            self.admissionReferralSourceCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='admissionReferralSourceCode', pretty_print=pretty_print)
        if self.lengthOfStayQuantity is not None:
            namespaceprefix_ = self.lengthOfStayQuantity_nsprefix_ + ':' if (UseCapturedNS_ and self.lengthOfStayQuantity_nsprefix_) else ''
            self.lengthOfStayQuantity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lengthOfStayQuantity', pretty_print=pretty_print)
        if self.dischargeDispositionCode is not None:
            namespaceprefix_ = self.dischargeDispositionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.dischargeDispositionCode_nsprefix_) else ''
            self.dischargeDispositionCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dischargeDispositionCode', pretty_print=pretty_print)
        if self.preAdmitTestInd is not None:
            namespaceprefix_ = self.preAdmitTestInd_nsprefix_ + ':' if (UseCapturedNS_ and self.preAdmitTestInd_nsprefix_) else ''
            self.preAdmitTestInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='preAdmitTestInd', pretty_print=pretty_print)
        for specialCourtesiesCode_ in self.specialCourtesiesCode:
            namespaceprefix_ = self.specialCourtesiesCode_nsprefix_ + ':' if (UseCapturedNS_ and self.specialCourtesiesCode_nsprefix_) else ''
            specialCourtesiesCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specialCourtesiesCode', pretty_print=pretty_print)
        for specialArrangementCode_ in self.specialArrangementCode:
            namespaceprefix_ = self.specialArrangementCode_nsprefix_ + ':' if (UseCapturedNS_ and self.specialArrangementCode_nsprefix_) else ''
            specialArrangementCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specialArrangementCode', pretty_print=pretty_print)
        if self.subject is not None:
            namespaceprefix_ = self.subject_nsprefix_ + ':' if (UseCapturedNS_ and self.subject_nsprefix_) else ''
            self.subject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subject', pretty_print=pretty_print)
        for specimen_ in self.specimen:
            namespaceprefix_ = self.specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_nsprefix_) else ''
            specimen_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen', pretty_print=pretty_print)
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for entryRelationship_ in self.entryRelationship:
            namespaceprefix_ = self.entryRelationship_nsprefix_ + ':' if (UseCapturedNS_ and self.entryRelationship_nsprefix_) else ''
            entryRelationship_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entryRelationship', pretty_print=pretty_print)
        for reference_ in self.reference:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        for precondition_ in self.precondition:
            namespaceprefix_ = self.precondition_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition_nsprefix_) else ''
            precondition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='precondition', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_x_DocumentEncounterMood(self.moodCode)    # validate type x_DocumentEncounterMood
        value = find_attr_value_('actionNegationInd', node)
        if value is not None and 'actionNegationInd' not in already_processed:
            already_processed.add('actionNegationInd')
            if value in ('true', '1'):
                self.actionNegationInd = True
            elif value in ('false', '0'):
                self.actionNegationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.actionNegationInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'activityTime':
            class_obj_ = self.get_class_obj_(child_, SXCM_TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.activityTime.append(obj_)
            obj_.original_tagname_ = 'activityTime'
        elif nodeName_ == 'availabilityTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.availabilityTime = obj_
            obj_.original_tagname_ = 'availabilityTime'
        elif nodeName_ == 'priorityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.priorityCode = obj_
            obj_.original_tagname_ = 'priorityCode'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.confidentialityCode = obj_
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'reasonCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reasonCode.append(obj_)
            obj_.original_tagname_ = 'reasonCode'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'admissionReferralSourceCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.admissionReferralSourceCode = obj_
            obj_.original_tagname_ = 'admissionReferralSourceCode'
        elif nodeName_ == 'lengthOfStayQuantity':
            class_obj_ = self.get_class_obj_(child_, PQ)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lengthOfStayQuantity = obj_
            obj_.original_tagname_ = 'lengthOfStayQuantity'
        elif nodeName_ == 'dischargeDispositionCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dischargeDispositionCode = obj_
            obj_.original_tagname_ = 'dischargeDispositionCode'
        elif nodeName_ == 'preAdmitTestInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preAdmitTestInd = obj_
            obj_.original_tagname_ = 'preAdmitTestInd'
        elif nodeName_ == 'specialCourtesiesCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specialCourtesiesCode.append(obj_)
            obj_.original_tagname_ = 'specialCourtesiesCode'
        elif nodeName_ == 'specialArrangementCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specialArrangementCode.append(obj_)
            obj_.original_tagname_ = 'specialArrangementCode'
        elif nodeName_ == 'subject':
            obj_ = POCD_MT000040UV02_Subject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subject = obj_
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'specimen':
            obj_ = POCD_MT000040UV02_Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen.append(obj_)
            obj_.original_tagname_ = 'specimen'
        elif nodeName_ == 'performer':
            obj_ = POCD_MT000040UV02_Performer2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040UV02_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040UV02_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040UV02_Participant3.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'entryRelationship':
            obj_ = POCD_MT000040UV02_EntryRelationship.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entryRelationship.append(obj_)
            obj_.original_tagname_ = 'entryRelationship'
        elif nodeName_ == 'reference':
            obj_ = POCD_MT000040UV02_Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference.append(obj_)
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'precondition':
            obj_ = POCD_MT000040UV02_Precondition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition.append(obj_)
            obj_.original_tagname_ = 'precondition'
# end class POCD_MT000040UV02_Encounter


class POCD_MT000040UV02_EncounterParticipant(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'x_EncounterParticipant' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, time: 'IVL_TS' = None, assignedEntity: 'POCD_MT000040UV02.AssignedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_EncounterParticipant)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_EncounterParticipant.subclass:
            return POCD_MT000040UV02_EncounterParticipant.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_EncounterParticipant(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_x_EncounterParticipant(self, value):
        # Validate type x_EncounterParticipant, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ATND', 'CON', 'DIS', 'REF']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_EncounterParticipant' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_EncounterParticipant_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_EncounterParticipant_patterns_, ))
    validate_x_EncounterParticipant_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.time is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.EncounterParticipant', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.EncounterParticipant')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.EncounterParticipant':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.EncounterParticipant')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.EncounterParticipant', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.EncounterParticipant'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.EncounterParticipant', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_x_EncounterParticipant(self.typeCode)    # validate type x_EncounterParticipant
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'time':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040UV02_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class POCD_MT000040UV02_EncounterParticipant


class POCD_MT000040UV02_Entity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassRoot' = 'ENT', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, desc: 'ED' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.desc = desc
        self.desc_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Entity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Entity.subclass:
            return POCD_MT000040UV02_Entity.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Entity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_desc(self):
        return self.desc
    def set_desc(self, desc):
        self.desc = desc
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_determinerCode(self):
        return self.determinerCode
    def set_determinerCode(self, determinerCode):
        self.determinerCode = determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityClassRoot(self, value):
        # Validate type EntityClassRoot, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ENT', 'HCE', 'LIV', 'NLIV', 'ANM', 'MIC', 'PLNT', 'PSN', 'MAT', 'CHEM', 'FOOD', 'MMAT', 'CONT', 'HOLD', 'DEV', 'CER', 'MODDV', 'ORG', 'PUB', 'STATE', 'NAT', 'PLC', 'CITY', 'COUNTRY', 'COUNTY', 'PROVINCE', 'RGRP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityClassRoot' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityClassRoot_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityClassRoot_patterns_, ))
    validate_EntityClassRoot_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INSTANCE', 'KIND', 'QUANTIFIED_KIND']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityDeterminer' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityDeterminer_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityDeterminer_patterns_, ))
    validate_EntityDeterminer_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.desc is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Entity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Entity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Entity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Entity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Entity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Entity'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ENT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode != "INSTANCE" and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Entity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.desc is not None:
            namespaceprefix_ = self.desc_nsprefix_ + ':' if (UseCapturedNS_ and self.desc_nsprefix_) else ''
            self.desc.export(outfile, level, namespaceprefix_, namespacedef_='', name_='desc', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassRoot(self.classCode)    # validate type EntityClassRoot
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'desc':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.desc = obj_
            obj_.original_tagname_ = 'desc'
# end class POCD_MT000040UV02_Entity


class POCD_MT000040UV02_Entry(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'x_ActRelationshipEntry' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, act: 'POCD_MT000040UV02.Act' = None, encounter: 'POCD_MT000040UV02.Encounter' = None, observation: 'POCD_MT000040UV02.Observation' = None, observationMedia: 'POCD_MT000040UV02.ObservationMedia' = None, organizer: 'POCD_MT000040UV02.Organizer' = None, procedure: 'POCD_MT000040UV02.Procedure' = None, regionOfInterest: 'POCD_MT000040UV02.RegionOfInterest' = None, substanceAdministration: 'POCD_MT000040UV02.SubstanceAdministration' = None, supply: 'POCD_MT000040UV02.Supply' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.act = act
        self.act_nsprefix_ = None
        self.encounter = encounter
        self.encounter_nsprefix_ = None
        self.observation = observation
        self.observation_nsprefix_ = None
        self.observationMedia = observationMedia
        self.observationMedia_nsprefix_ = None
        self.organizer = organizer
        self.organizer_nsprefix_ = None
        self.procedure = procedure
        self.procedure_nsprefix_ = None
        self.regionOfInterest = regionOfInterest
        self.regionOfInterest_nsprefix_ = None
        self.substanceAdministration = substanceAdministration
        self.substanceAdministration_nsprefix_ = None
        self.supply = supply
        self.supply_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Entry)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Entry.subclass:
            return POCD_MT000040UV02_Entry.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Entry(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_act(self):
        return self.act
    def set_act(self, act):
        self.act = act
    def get_encounter(self):
        return self.encounter
    def set_encounter(self, encounter):
        self.encounter = encounter
    def get_observation(self):
        return self.observation
    def set_observation(self, observation):
        self.observation = observation
    def get_observationMedia(self):
        return self.observationMedia
    def set_observationMedia(self, observationMedia):
        self.observationMedia = observationMedia
    def get_organizer(self):
        return self.organizer
    def set_organizer(self, organizer):
        self.organizer = organizer
    def get_procedure(self):
        return self.procedure
    def set_procedure(self, procedure):
        self.procedure = procedure
    def get_regionOfInterest(self):
        return self.regionOfInterest
    def set_regionOfInterest(self, regionOfInterest):
        self.regionOfInterest = regionOfInterest
    def get_substanceAdministration(self):
        return self.substanceAdministration
    def set_substanceAdministration(self, substanceAdministration):
        self.substanceAdministration = substanceAdministration
    def get_supply(self):
        return self.supply
    def set_supply(self, supply):
        self.supply = supply
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd):
        self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_x_ActRelationshipEntry(self, value):
        # Validate type x_ActRelationshipEntry, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COMP', 'DRIV']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_ActRelationshipEntry' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActRelationshipEntry_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_ActRelationshipEntry_patterns_, ))
    validate_x_ActRelationshipEntry_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.act is not None or
            self.encounter is not None or
            self.observation is not None or
            self.observationMedia is not None or
            self.organizer is not None or
            self.procedure is not None or
            self.regionOfInterest is not None or
            self.substanceAdministration is not None or
            self.supply is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Entry', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Entry')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Entry':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Entry')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Entry', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Entry'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Entry', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.act is not None:
            namespaceprefix_ = self.act_nsprefix_ + ':' if (UseCapturedNS_ and self.act_nsprefix_) else ''
            self.act.export(outfile, level, namespaceprefix_, namespacedef_='', name_='act', pretty_print=pretty_print)
        if self.encounter is not None:
            namespaceprefix_ = self.encounter_nsprefix_ + ':' if (UseCapturedNS_ and self.encounter_nsprefix_) else ''
            self.encounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encounter', pretty_print=pretty_print)
        if self.observation is not None:
            namespaceprefix_ = self.observation_nsprefix_ + ':' if (UseCapturedNS_ and self.observation_nsprefix_) else ''
            self.observation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observation', pretty_print=pretty_print)
        if self.observationMedia is not None:
            namespaceprefix_ = self.observationMedia_nsprefix_ + ':' if (UseCapturedNS_ and self.observationMedia_nsprefix_) else ''
            self.observationMedia.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observationMedia', pretty_print=pretty_print)
        if self.organizer is not None:
            namespaceprefix_ = self.organizer_nsprefix_ + ':' if (UseCapturedNS_ and self.organizer_nsprefix_) else ''
            self.organizer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organizer', pretty_print=pretty_print)
        if self.procedure is not None:
            namespaceprefix_ = self.procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.procedure_nsprefix_) else ''
            self.procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='procedure', pretty_print=pretty_print)
        if self.regionOfInterest is not None:
            namespaceprefix_ = self.regionOfInterest_nsprefix_ + ':' if (UseCapturedNS_ and self.regionOfInterest_nsprefix_) else ''
            self.regionOfInterest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='regionOfInterest', pretty_print=pretty_print)
        if self.substanceAdministration is not None:
            namespaceprefix_ = self.substanceAdministration_nsprefix_ + ':' if (UseCapturedNS_ and self.substanceAdministration_nsprefix_) else ''
            self.substanceAdministration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='substanceAdministration', pretty_print=pretty_print)
        if self.supply is not None:
            namespaceprefix_ = self.supply_nsprefix_ + ':' if (UseCapturedNS_ and self.supply_nsprefix_) else ''
            self.supply.export(outfile, level, namespaceprefix_, namespacedef_='', name_='supply', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_x_ActRelationshipEntry(self.typeCode)    # validate type x_ActRelationshipEntry
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'act':
            obj_ = POCD_MT000040UV02_Act.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.act = obj_
            obj_.original_tagname_ = 'act'
        elif nodeName_ == 'encounter':
            obj_ = POCD_MT000040UV02_Encounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encounter = obj_
            obj_.original_tagname_ = 'encounter'
        elif nodeName_ == 'observation':
            obj_ = POCD_MT000040UV02_Observation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observation = obj_
            obj_.original_tagname_ = 'observation'
        elif nodeName_ == 'observationMedia':
            obj_ = POCD_MT000040UV02_ObservationMedia.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observationMedia = obj_
            obj_.original_tagname_ = 'observationMedia'
        elif nodeName_ == 'organizer':
            obj_ = POCD_MT000040UV02_Organizer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organizer = obj_
            obj_.original_tagname_ = 'organizer'
        elif nodeName_ == 'procedure':
            obj_ = POCD_MT000040UV02_Procedure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.procedure = obj_
            obj_.original_tagname_ = 'procedure'
        elif nodeName_ == 'regionOfInterest':
            obj_ = POCD_MT000040UV02_RegionOfInterest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.regionOfInterest = obj_
            obj_.original_tagname_ = 'regionOfInterest'
        elif nodeName_ == 'substanceAdministration':
            obj_ = POCD_MT000040UV02_SubstanceAdministration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.substanceAdministration = obj_
            obj_.original_tagname_ = 'substanceAdministration'
        elif nodeName_ == 'supply':
            obj_ = POCD_MT000040UV02_Supply.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.supply = obj_
            obj_.original_tagname_ = 'supply'
# end class POCD_MT000040UV02_Entry


class POCD_MT000040UV02_EntryRelationship(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = None, inversionInd: 'bl' = None, contextConductionInd: 'bl' = 'true', negationInd: 'bl' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, sequenceNumber: 'INT' = None, seperatableInd: 'BL' = None, act: 'POCD_MT000040UV02.Act' = None, encounter: 'POCD_MT000040UV02.Encounter' = None, observation: 'POCD_MT000040UV02.Observation' = None, observationMedia: 'POCD_MT000040UV02.ObservationMedia' = None, organizer: 'POCD_MT000040UV02.Organizer' = None, procedure: 'POCD_MT000040UV02.Procedure' = None, regionOfInterest: 'POCD_MT000040UV02.RegionOfInterest' = None, substanceAdministration: 'POCD_MT000040UV02.SubstanceAdministration' = None, supply: 'POCD_MT000040UV02.Supply' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.inversionInd = _cast(bool, inversionInd)
        self.inversionInd_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        self.negationInd = _cast(bool, negationInd)
        self.negationInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.sequenceNumber = sequenceNumber
        self.sequenceNumber_nsprefix_ = None
        self.seperatableInd = seperatableInd
        self.seperatableInd_nsprefix_ = None
        self.act = act
        self.act_nsprefix_ = None
        self.encounter = encounter
        self.encounter_nsprefix_ = None
        self.observation = observation
        self.observation_nsprefix_ = None
        self.observationMedia = observationMedia
        self.observationMedia_nsprefix_ = None
        self.organizer = organizer
        self.organizer_nsprefix_ = None
        self.procedure = procedure
        self.procedure_nsprefix_ = None
        self.regionOfInterest = regionOfInterest
        self.regionOfInterest_nsprefix_ = None
        self.substanceAdministration = substanceAdministration
        self.substanceAdministration_nsprefix_ = None
        self.supply = supply
        self.supply_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_EntryRelationship)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_EntryRelationship.subclass:
            return POCD_MT000040UV02_EntryRelationship.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_EntryRelationship(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_sequenceNumber(self):
        return self.sequenceNumber
    def set_sequenceNumber(self, sequenceNumber):
        self.sequenceNumber = sequenceNumber
    def get_seperatableInd(self):
        return self.seperatableInd
    def set_seperatableInd(self, seperatableInd):
        self.seperatableInd = seperatableInd
    def get_act(self):
        return self.act
    def set_act(self, act):
        self.act = act
    def get_encounter(self):
        return self.encounter
    def set_encounter(self, encounter):
        self.encounter = encounter
    def get_observation(self):
        return self.observation
    def set_observation(self, observation):
        self.observation = observation
    def get_observationMedia(self):
        return self.observationMedia
    def set_observationMedia(self, observationMedia):
        self.observationMedia = observationMedia
    def get_organizer(self):
        return self.organizer
    def set_organizer(self, organizer):
        self.organizer = organizer
    def get_procedure(self):
        return self.procedure
    def set_procedure(self, procedure):
        self.procedure = procedure
    def get_regionOfInterest(self):
        return self.regionOfInterest
    def set_regionOfInterest(self, regionOfInterest):
        self.regionOfInterest = regionOfInterest
    def get_substanceAdministration(self):
        return self.substanceAdministration
    def set_substanceAdministration(self, substanceAdministration):
        self.substanceAdministration = substanceAdministration
    def get_supply(self):
        return self.supply
    def set_supply(self, supply):
        self.supply = supply
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_inversionInd(self):
        return self.inversionInd
    def set_inversionInd(self, inversionInd):
        self.inversionInd = inversionInd
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd):
        self.contextConductionInd = contextConductionInd
    def get_negationInd(self):
        return self.negationInd
    def set_negationInd(self, negationInd):
        self.negationInd = negationInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.sequenceNumber is not None or
            self.seperatableInd is not None or
            self.act is not None or
            self.encounter is not None or
            self.observation is not None or
            self.observationMedia is not None or
            self.organizer is not None or
            self.procedure is not None or
            self.regionOfInterest is not None or
            self.substanceAdministration is not None or
            self.supply is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.EntryRelationship', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.EntryRelationship')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.EntryRelationship':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.EntryRelationship')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.EntryRelationship', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.EntryRelationship'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.inversionInd is not None and 'inversionInd' not in already_processed:
            already_processed.add('inversionInd')
            outfile.write(' inversionInd="%s"' % self.gds_format_boolean(self.inversionInd, input_name='inversionInd'))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
        if self.negationInd is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            outfile.write(' negationInd="%s"' % self.gds_format_boolean(self.negationInd, input_name='negationInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.EntryRelationship', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.sequenceNumber is not None:
            namespaceprefix_ = self.sequenceNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.sequenceNumber_nsprefix_) else ''
            self.sequenceNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sequenceNumber', pretty_print=pretty_print)
        if self.seperatableInd is not None:
            namespaceprefix_ = self.seperatableInd_nsprefix_ + ':' if (UseCapturedNS_ and self.seperatableInd_nsprefix_) else ''
            self.seperatableInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='seperatableInd', pretty_print=pretty_print)
        if self.act is not None:
            namespaceprefix_ = self.act_nsprefix_ + ':' if (UseCapturedNS_ and self.act_nsprefix_) else ''
            self.act.export(outfile, level, namespaceprefix_, namespacedef_='', name_='act', pretty_print=pretty_print)
        if self.encounter is not None:
            namespaceprefix_ = self.encounter_nsprefix_ + ':' if (UseCapturedNS_ and self.encounter_nsprefix_) else ''
            self.encounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encounter', pretty_print=pretty_print)
        if self.observation is not None:
            namespaceprefix_ = self.observation_nsprefix_ + ':' if (UseCapturedNS_ and self.observation_nsprefix_) else ''
            self.observation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observation', pretty_print=pretty_print)
        if self.observationMedia is not None:
            namespaceprefix_ = self.observationMedia_nsprefix_ + ':' if (UseCapturedNS_ and self.observationMedia_nsprefix_) else ''
            self.observationMedia.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observationMedia', pretty_print=pretty_print)
        if self.organizer is not None:
            namespaceprefix_ = self.organizer_nsprefix_ + ':' if (UseCapturedNS_ and self.organizer_nsprefix_) else ''
            self.organizer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organizer', pretty_print=pretty_print)
        if self.procedure is not None:
            namespaceprefix_ = self.procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.procedure_nsprefix_) else ''
            self.procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='procedure', pretty_print=pretty_print)
        if self.regionOfInterest is not None:
            namespaceprefix_ = self.regionOfInterest_nsprefix_ + ':' if (UseCapturedNS_ and self.regionOfInterest_nsprefix_) else ''
            self.regionOfInterest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='regionOfInterest', pretty_print=pretty_print)
        if self.substanceAdministration is not None:
            namespaceprefix_ = self.substanceAdministration_nsprefix_ + ':' if (UseCapturedNS_ and self.substanceAdministration_nsprefix_) else ''
            self.substanceAdministration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='substanceAdministration', pretty_print=pretty_print)
        if self.supply is not None:
            namespaceprefix_ = self.supply_nsprefix_ + ':' if (UseCapturedNS_ and self.supply_nsprefix_) else ''
            self.supply.export(outfile, level, namespaceprefix_, namespacedef_='', name_='supply', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
        value = find_attr_value_('inversionInd', node)
        if value is not None and 'inversionInd' not in already_processed:
            already_processed.add('inversionInd')
            if value in ('true', '1'):
                self.inversionInd = True
            elif value in ('false', '0'):
                self.inversionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.inversionInd)    # validate type bl
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
        value = find_attr_value_('negationInd', node)
        if value is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            if value in ('true', '1'):
                self.negationInd = True
            elif value in ('false', '0'):
                self.negationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.negationInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'sequenceNumber':
            class_obj_ = self.get_class_obj_(child_, INT)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sequenceNumber = obj_
            obj_.original_tagname_ = 'sequenceNumber'
        elif nodeName_ == 'seperatableInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.seperatableInd = obj_
            obj_.original_tagname_ = 'seperatableInd'
        elif nodeName_ == 'act':
            obj_ = POCD_MT000040UV02_Act.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.act = obj_
            obj_.original_tagname_ = 'act'
        elif nodeName_ == 'encounter':
            obj_ = POCD_MT000040UV02_Encounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encounter = obj_
            obj_.original_tagname_ = 'encounter'
        elif nodeName_ == 'observation':
            obj_ = POCD_MT000040UV02_Observation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observation = obj_
            obj_.original_tagname_ = 'observation'
        elif nodeName_ == 'observationMedia':
            obj_ = POCD_MT000040UV02_ObservationMedia.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observationMedia = obj_
            obj_.original_tagname_ = 'observationMedia'
        elif nodeName_ == 'organizer':
            obj_ = POCD_MT000040UV02_Organizer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organizer = obj_
            obj_.original_tagname_ = 'organizer'
        elif nodeName_ == 'procedure':
            obj_ = POCD_MT000040UV02_Procedure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.procedure = obj_
            obj_.original_tagname_ = 'procedure'
        elif nodeName_ == 'regionOfInterest':
            obj_ = POCD_MT000040UV02_RegionOfInterest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.regionOfInterest = obj_
            obj_.original_tagname_ = 'regionOfInterest'
        elif nodeName_ == 'substanceAdministration':
            obj_ = POCD_MT000040UV02_SubstanceAdministration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.substanceAdministration = obj_
            obj_.original_tagname_ = 'substanceAdministration'
        elif nodeName_ == 'supply':
            obj_ = POCD_MT000040UV02_Supply.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.supply = obj_
            obj_.original_tagname_ = 'supply'
# end class POCD_MT000040UV02_EntryRelationship


class POCD_MT000040UV02_ExternalAct(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassRoot' = 'ACT', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_ExternalAct)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_ExternalAct.subclass:
            return POCD_MT000040UV02_ExternalAct.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_ExternalAct(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClassRoot(self, value):
        # Validate type ActClassRoot, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACT', 'COMPOSITION', 'DOC', 'DOCCLIN', 'CDALVLONE', 'CONTAINER', 'CATEGORY', 'DOCBODY', 'DOCSECT', 'TOPIC', 'EXTRACT', 'EHR', 'FOLDER', 'GROUPER', 'CLUSTER', 'ACCM', 'ACCT', 'ACSN', 'ADJUD', 'CACT', 'ACTN', 'INFO', 'STC', 'CNTRCT', 'FCNTRCT', 'COV', 'CONS', 'CONTREG', 'CTTEVENT', 'DISPACT', 'EXPOS', 'AEXPOS', 'TEXPOS', 'INC', 'INFRM', 'INVE', 'LIST', 'MPROT', 'OBS', 'ROIBND', 'ROIOVL', 'LLD', 'PRN', 'RLD', 'SFWL', 'SIT', 'STN', 'SUP', 'RTRD', 'TRD', 'ALRT', 'BATTERY', 'CLNTRL', 'CNOD', 'CONC', 'COND', 'CASE', 'OUTB', 'DGIMG', 'GEN', 'DETPOL', 'EXP', 'LOC', 'PHN', 'POL', 'SEQ', 'SEQVAR', 'INVSTG', 'OBSSER', 'OBSCOR', 'POS', 'POSACC', 'POSCOORD', 'SPCOBS', 'VERIF', 'PCPR', 'ENC', 'POLICY', 'JURISPOL', 'ORGPOL', 'SCOPOL', 'STDPOL', 'PROC', 'SBADM', 'SBEXT', 'SPECCOLLECT', 'REG', 'REV', 'SPCTRT', 'SPLY', 'DIET', 'STORE', 'SUBST', 'TRFR', 'TRNS', 'XACT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClassRoot' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassRoot_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClassRoot_patterns_, ))
    validate_ActClassRoot_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ExternalAct', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.ExternalAct')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.ExternalAct':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.ExternalAct')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.ExternalAct', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.ExternalAct'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ACT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ExternalAct', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassRoot(self.classCode)    # validate type ActClassRoot
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
# end class POCD_MT000040UV02_ExternalAct


class POCD_MT000040UV02_ExternalDocument(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassDocument' = 'DOC', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, setId: 'II' = None, versionNumber: 'ST.r2b' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.setId = setId
        self.setId_nsprefix_ = None
        self.versionNumber = versionNumber
        self.versionNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_ExternalDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_ExternalDocument.subclass:
            return POCD_MT000040UV02_ExternalDocument.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_ExternalDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_setId(self):
        return self.setId
    def set_setId(self, setId):
        self.setId = setId
    def get_versionNumber(self):
        return self.versionNumber
    def set_versionNumber(self, versionNumber):
        self.versionNumber = versionNumber
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClassDocument(self, value):
        # Validate type ActClassDocument, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DOC', 'DOCCLIN', 'CDALVLONE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClassDocument' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassDocument_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClassDocument_patterns_, ))
    validate_ActClassDocument_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None or
            self.setId is not None or
            self.versionNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ExternalDocument', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.ExternalDocument')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.ExternalDocument':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.ExternalDocument')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.ExternalDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.ExternalDocument'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ExternalDocument', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.setId is not None:
            namespaceprefix_ = self.setId_nsprefix_ + ':' if (UseCapturedNS_ and self.setId_nsprefix_) else ''
            self.setId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='setId', pretty_print=pretty_print)
        if self.versionNumber is not None:
            namespaceprefix_ = self.versionNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.versionNumber_nsprefix_) else ''
            self.versionNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='versionNumber', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassDocument(self.classCode)    # validate type ActClassDocument
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'setId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.setId = obj_
            obj_.original_tagname_ = 'setId'
        elif nodeName_ == 'versionNumber':
            obj_ = ST_r2b.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.versionNumber = obj_
            obj_.original_tagname_ = 'versionNumber'
# end class POCD_MT000040UV02_ExternalDocument


class POCD_MT000040UV02_ExternalObservation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassObservation' = 'OBS', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_ExternalObservation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_ExternalObservation.subclass:
            return POCD_MT000040UV02_ExternalObservation.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_ExternalObservation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['OBS', 'ROIBND', 'ROIOVL', 'LLD', 'PRN', 'RLD', 'SFWL', 'SIT', 'STN', 'SUP', 'RTRD', 'TRD', 'ALRT', 'BATTERY', 'CLNTRL', 'CNOD', 'CONC', 'COND', 'CASE', 'OUTB', 'DGIMG', 'GEN', 'DETPOL', 'EXP', 'LOC', 'PHN', 'POL', 'SEQ', 'SEQVAR', 'INVSTG', 'OBSSER', 'OBSCOR', 'POS', 'POSACC', 'POSCOORD', 'SPCOBS', 'VERIF']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClassObservation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassObservation_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClassObservation_patterns_, ))
    validate_ActClassObservation_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ExternalObservation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.ExternalObservation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.ExternalObservation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.ExternalObservation')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.ExternalObservation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.ExternalObservation'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "OBS" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ExternalObservation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
# end class POCD_MT000040UV02_ExternalObservation


class POCD_MT000040UV02_ExternalProcedure(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'PROC', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_ExternalProcedure)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_ExternalProcedure.subclass:
            return POCD_MT000040UV02_ExternalProcedure.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_ExternalProcedure(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCM', 'ACCT', 'ACSN', 'ACT', 'ACTN', 'ADJUD', 'AEXPOS', 'ALRT', 'BATTERY', 'CACT', 'CASE', 'CATEGORY', 'CDALVLONE', 'CLNTRL', 'CLUSTER', 'CNOD', 'CNTRCT', 'COMPOSITION', 'CONC', 'COND', 'CONS', 'CONTAINER', 'CONTREG', 'COV', 'CTTEVENT', 'DETPOL', 'DGIMG', 'DIET', 'DISPACT', 'DOC', 'DOCBODY', 'DOCCLIN', 'DOCSECT', 'EHR', 'ENC', 'EXP', 'EXPOS', 'EXTRACT', 'FCNTRCT', 'FOLDER', 'GEN', 'GROUPER', 'INC', 'INFO', 'INFRM', 'INVE', 'INVSTG', 'JURISPOL', 'LIST', 'LLD', 'LOC', 'MPROT', 'OBS', 'OBSCOR', 'OBSSER', 'ORGPOL', 'OUTB', 'PCPR', 'PHN', 'POL', 'POLICY', 'POS', 'POSACC', 'POSCOORD', 'PRN', 'PROC', 'REG', 'REV', 'RLD', 'ROIBND', 'ROIOVL', 'RTRD', 'SBADM', 'SBEXT', 'SCOPOL', 'SEQ', 'SEQVAR', 'SFWL', 'SIT', 'SPCOBS', 'SPCTRT', 'SPECCOLLECT', 'SPLY', 'STC', 'STDPOL', 'STN', 'STORE', 'SUBST', 'SUP', 'TEXPOS', 'TOPIC', 'TRD', 'TRFR', 'TRNS', 'VERIF', 'XACT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClass_patterns_, ))
    validate_ActClass_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ExternalProcedure', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.ExternalProcedure')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.ExternalProcedure':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.ExternalProcedure')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.ExternalProcedure', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.ExternalProcedure'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "PROC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ExternalProcedure', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
# end class POCD_MT000040UV02_ExternalProcedure


class POCD_MT000040UV02_Guardian(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'GUARD', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, guardianPerson: 'POCD_MT000040UV02.Person' = None, guardianOrganization: 'POCD_MT000040UV02.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.guardianPerson = guardianPerson
        self.guardianPerson_nsprefix_ = None
        self.guardianOrganization = guardianOrganization
        self.guardianOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Guardian)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Guardian.subclass:
            return POCD_MT000040UV02_Guardian.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Guardian(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_guardianPerson(self):
        return self.guardianPerson
    def set_guardianPerson(self, guardianPerson):
        self.guardianPerson = guardianPerson
    def get_guardianOrganization(self):
        return self.guardianOrganization
    def set_guardianOrganization(self, guardianOrganization):
        self.guardianOrganization = guardianOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCESS', 'ACTI', 'ACTIB', 'ACTIM', 'ACTIR', 'ACTM', 'ADJV', 'ADJY', 'ADMM', 'ADTV', 'AFFL', 'AGNT', 'ALQT', 'ASSIGNED', 'BASE', 'BIRTHPL', 'BOND', 'CAREGIVER', 'CASEBJ', 'CHILD', 'CIT', 'CLAIM', 'COLR', 'COMPAR', 'CON', 'CONC', 'CONT', 'CONY', 'COVPTY', 'CRED', 'CRINV', 'CRSPNSR', 'DEATHPLC', 'DEPEN', 'DSDLOC', 'DST', 'ECON', 'EMP', 'EQUIV', 'EXPAGTCAR', 'EXPR', 'EXPVECTOR', 'FLVR', 'FOMITE', 'GEN', 'GRIC', 'GUAR', 'GUARD', 'HLD', 'HLTHCHRT', 'IACT', 'IDENT', 'INDIV', 'INGR', 'INST', 'INVSBJ', 'ISDLOC', 'ISLT', 'LIC', 'LOCE', 'MANU', 'MBR', 'MECH', 'MIL', 'MNT', 'NAMED', 'NOK', 'NOT', 'NURPRAC', 'NURS', 'OWN', 'PA', 'PART', 'PAT', 'PAYEE', 'PAYOR', 'PHYS', 'POLHOLD', 'PROG', 'PROV', 'PRS', 'PRSV', 'QUAL', 'RESBJ', 'RET', 'RGPR', 'ROL', 'SAME', 'SDLOC', 'SGNOFF', 'SPEC', 'SPNSR', 'STBL', 'STD', 'STOR', 'SUBS', 'SUBSCR', 'SUBY', 'TERR', 'THER', 'UNDWRT', 'USED', 'WRTE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClass_patterns_, ))
    validate_RoleClass_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.guardianPerson is not None or
            self.guardianOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Guardian', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Guardian')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Guardian':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Guardian')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Guardian', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Guardian'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "GUARD" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Guardian', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.guardianPerson is not None:
            namespaceprefix_ = self.guardianPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.guardianPerson_nsprefix_) else ''
            self.guardianPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='guardianPerson', pretty_print=pretty_print)
        if self.guardianOrganization is not None:
            namespaceprefix_ = self.guardianOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.guardianOrganization_nsprefix_) else ''
            self.guardianOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='guardianOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'guardianPerson':
            obj_ = POCD_MT000040UV02_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.guardianPerson = obj_
            obj_.original_tagname_ = 'guardianPerson'
        elif nodeName_ == 'guardianOrganization':
            obj_ = POCD_MT000040UV02_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.guardianOrganization = obj_
            obj_.original_tagname_ = 'guardianOrganization'
# end class POCD_MT000040UV02_Guardian


class POCD_MT000040UV02_HealthCareFacility(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassServiceDeliveryLocation' = 'SDLOC', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, location: 'POCD_MT000040UV02.Place' = None, serviceProviderOrganization: 'POCD_MT000040UV02.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.location = location
        self.location_nsprefix_ = None
        self.serviceProviderOrganization = serviceProviderOrganization
        self.serviceProviderOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_HealthCareFacility)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_HealthCareFacility.subclass:
            return POCD_MT000040UV02_HealthCareFacility.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_HealthCareFacility(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_location(self):
        return self.location
    def set_location(self, location):
        self.location = location
    def get_serviceProviderOrganization(self):
        return self.serviceProviderOrganization
    def set_serviceProviderOrganization(self, serviceProviderOrganization):
        self.serviceProviderOrganization = serviceProviderOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClassServiceDeliveryLocation(self, value):
        # Validate type RoleClassServiceDeliveryLocation, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['SDLOC', 'DSDLOC', 'ISDLOC']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClassServiceDeliveryLocation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClassServiceDeliveryLocation_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClassServiceDeliveryLocation_patterns_, ))
    validate_RoleClassServiceDeliveryLocation_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.location is not None or
            self.serviceProviderOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.HealthCareFacility', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.HealthCareFacility')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.HealthCareFacility':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.HealthCareFacility')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.HealthCareFacility', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.HealthCareFacility'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "SDLOC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.HealthCareFacility', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.location is not None:
            namespaceprefix_ = self.location_nsprefix_ + ':' if (UseCapturedNS_ and self.location_nsprefix_) else ''
            self.location.export(outfile, level, namespaceprefix_, namespacedef_='', name_='location', pretty_print=pretty_print)
        if self.serviceProviderOrganization is not None:
            namespaceprefix_ = self.serviceProviderOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.serviceProviderOrganization_nsprefix_) else ''
            self.serviceProviderOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='serviceProviderOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassServiceDeliveryLocation(self.classCode)    # validate type RoleClassServiceDeliveryLocation
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'location':
            obj_ = POCD_MT000040UV02_Place.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.location = obj_
            obj_.original_tagname_ = 'location'
        elif nodeName_ == 'serviceProviderOrganization':
            obj_ = POCD_MT000040UV02_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.serviceProviderOrganization = obj_
            obj_.original_tagname_ = 'serviceProviderOrganization'
# end class POCD_MT000040UV02_HealthCareFacility


class POCD_MT000040UV02_Informant12(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'INF', contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, assignedEntity: 'POCD_MT000040UV02.AssignedEntity' = None, relatedEntity: 'POCD_MT000040UV02.RelatedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
        self.relatedEntity = relatedEntity
        self.relatedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Informant12)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Informant12.subclass:
            return POCD_MT000040UV02_Informant12.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Informant12(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_relatedEntity(self):
        return self.relatedEntity
    def set_relatedEntity(self, relatedEntity):
        self.relatedEntity = relatedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def set_contextControlCode(self, contextControlCode):
        self.contextControlCode = contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ALY', 'ATND', 'AUT', 'AUTHEN', 'BBY', 'BEN', 'CAGNT', 'CALLBCK', 'CAT', 'CON', 'COV', 'CSM', 'CST', 'DEV', 'DIR', 'DIS', 'DIST', 'DON', 'DST', 'ELOC', 'ENT', 'ESC', 'EXPAGNT', 'EXPART', 'EXPTRGT', 'EXSRC', 'GUAR', 'HLD', 'IND', 'INF', 'IRCP', 'LA', 'LOC', 'NOT', 'NRD', 'ORG', 'PART', 'PPRF', 'PRCP', 'PRD', 'PRF', 'RCT', 'RCV', 'RDV', 'REF', 'REFB', 'REFT', 'RESP', 'RML', 'SBJ', 'SPC', 'SPRF', 'TRANS', 'TRC', 'VIA', 'VRF', 'WIT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationType_patterns_, ))
    validate_ParticipationType_patterns_ = [['^([^\\s]+)$']]
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AN', 'AP', 'ON', 'OP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ContextControl' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ContextControl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ContextControl_patterns_, ))
    validate_ContextControl_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.assignedEntity is not None or
            self.relatedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Informant12', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Informant12')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Informant12':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Informant12')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Informant12', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Informant12'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "INF" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode != "OP" and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Informant12', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
        if self.relatedEntity is not None:
            namespaceprefix_ = self.relatedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.relatedEntity_nsprefix_) else ''
            self.relatedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='relatedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.contextControlCode = ' '.join(self.contextControlCode.split())
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040UV02_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
        elif nodeName_ == 'relatedEntity':
            obj_ = POCD_MT000040UV02_RelatedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.relatedEntity = obj_
            obj_.original_tagname_ = 'relatedEntity'
# end class POCD_MT000040UV02_Informant12


class POCD_MT000040UV02_InFulfillmentOf(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'FLFS', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, order: 'POCD_MT000040UV02.Order' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.order = order
        self.order_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_InFulfillmentOf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_InFulfillmentOf.subclass:
            return POCD_MT000040UV02_InFulfillmentOf.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_InFulfillmentOf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_order(self):
        return self.order
    def set_order(self, order):
        self.order = order
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APND', 'ARR', 'AUTH', 'BLOCK', 'BSLN', 'CAUS', 'CHRG', 'CIND', 'COMP', 'COMPLY', 'CONCURRENT', 'COST', 'COVBY', 'CREDIT', 'CTRLV', 'CURE', 'CURE.ADJ', 'DEBIT', 'DEP', 'DIAG', 'DOC', 'DRIV', 'DURING', 'EAE', 'EAS', 'EBS', 'ECW', 'EDU', 'ELNK', 'EVID', 'EXACBY', 'EXPL', 'FLFS', 'GEN', 'GEVL', 'GOAL', 'INST', 'ITEMSLOC', 'LIMIT', 'META', 'MFST', 'MITGT', 'MOD', 'MTCH', 'MTGT.ADJ', 'NAME', 'OBJC', 'OBJF', 'OCCR', 'OPTN', 'OREF', 'OUTC', 'OVERLAP', 'PERT', 'PRCN', 'PREV', 'RCHAL', 'RCVY', 'REFR', 'REFV', 'RELVBY', 'REV', 'RISK', 'RPLC', 'RSON', 'SAE', 'SAS', 'SBS', 'SCH', 'SCW', 'SDU', 'SEQL', 'SPRT', 'SPRTBND', 'SUBJ', 'SUCC', 'SUMM', 'SYMP', 'TRIG', 'UPDT', 'USE', 'VRXCRPT', 'XCRPT', 'XFRM']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipType_patterns_, ))
    validate_ActRelationshipType_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.order is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.InFulfillmentOf', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.InFulfillmentOf')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.InFulfillmentOf':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.InFulfillmentOf')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.InFulfillmentOf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.InFulfillmentOf'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "FLFS" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.InFulfillmentOf', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.order is not None:
            namespaceprefix_ = self.order_nsprefix_ + ':' if (UseCapturedNS_ and self.order_nsprefix_) else ''
            self.order.export(outfile, level, namespaceprefix_, namespacedef_='', name_='order', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'order':
            obj_ = POCD_MT000040UV02_Order.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.order = obj_
            obj_.original_tagname_ = 'order'
# end class POCD_MT000040UV02_InFulfillmentOf


class POCD_MT000040UV02_IntendedRecipient(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'x_InformationRecipientRole' = 'ASSIGNED', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, informationRecipient: 'POCD_MT000040UV02.Person' = None, receivedOrganization: 'POCD_MT000040UV02.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.informationRecipient = informationRecipient
        self.informationRecipient_nsprefix_ = None
        self.receivedOrganization = receivedOrganization
        self.receivedOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_IntendedRecipient)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_IntendedRecipient.subclass:
            return POCD_MT000040UV02_IntendedRecipient.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_IntendedRecipient(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_informationRecipient(self):
        return self.informationRecipient
    def set_informationRecipient(self, informationRecipient):
        self.informationRecipient = informationRecipient
    def get_receivedOrganization(self):
        return self.receivedOrganization
    def set_receivedOrganization(self, receivedOrganization):
        self.receivedOrganization = receivedOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_x_InformationRecipientRole(self, value):
        # Validate type x_InformationRecipientRole, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASSIGNED', 'HLTHCHRT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_InformationRecipientRole' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_InformationRecipientRole_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_InformationRecipientRole_patterns_, ))
    validate_x_InformationRecipientRole_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.addr or
            self.telecom or
            self.informationRecipient is not None or
            self.receivedOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.IntendedRecipient', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.IntendedRecipient')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.IntendedRecipient':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.IntendedRecipient')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.IntendedRecipient', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.IntendedRecipient'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ASSIGNED" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.IntendedRecipient', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.informationRecipient is not None:
            namespaceprefix_ = self.informationRecipient_nsprefix_ + ':' if (UseCapturedNS_ and self.informationRecipient_nsprefix_) else ''
            self.informationRecipient.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informationRecipient', pretty_print=pretty_print)
        if self.receivedOrganization is not None:
            namespaceprefix_ = self.receivedOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.receivedOrganization_nsprefix_) else ''
            self.receivedOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='receivedOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_x_InformationRecipientRole(self.classCode)    # validate type x_InformationRecipientRole
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'informationRecipient':
            obj_ = POCD_MT000040UV02_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informationRecipient = obj_
            obj_.original_tagname_ = 'informationRecipient'
        elif nodeName_ == 'receivedOrganization':
            obj_ = POCD_MT000040UV02_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.receivedOrganization = obj_
            obj_.original_tagname_ = 'receivedOrganization'
# end class POCD_MT000040UV02_IntendedRecipient


class POCD_MT000040UV02_LabeledDrug(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClass' = 'MMAT', determinerCode: 'EntityDeterminer' = 'KIND', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CE' = None, name: 'EN' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_LabeledDrug)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_LabeledDrug.subclass:
            return POCD_MT000040UV02_LabeledDrug.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_LabeledDrug(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_determinerCode(self):
        return self.determinerCode
    def set_determinerCode(self, determinerCode):
        self.determinerCode = determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityClass(self, value):
        # Validate type EntityClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ANM', 'CER', 'CHEM', 'CITY', 'CONT', 'COUNTRY', 'COUNTY', 'DEV', 'ENT', 'FOOD', 'HCE', 'HOLD', 'LIV', 'MAT', 'MIC', 'MMAT', 'MODDV', 'NAT', 'NLIV', 'ORG', 'PLC', 'PLNT', 'PROVINCE', 'PSN', 'PUB', 'RGRP', 'STATE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityClass_patterns_, ))
    validate_EntityClass_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INSTANCE', 'KIND', 'QUANTIFIED_KIND']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityDeterminer' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityDeterminer_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityDeterminer_patterns_, ))
    validate_EntityDeterminer_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.LabeledDrug', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.LabeledDrug')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.LabeledDrug':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.LabeledDrug')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.LabeledDrug', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.LabeledDrug'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "MMAT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode != "KIND" and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.LabeledDrug', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClass(self.classCode)    # validate type EntityClass
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'name':
            class_obj_ = self.get_class_obj_(child_, EN)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
# end class POCD_MT000040UV02_LabeledDrug


class POCD_MT000040UV02_LanguageCommunication(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, languageCode: 'CS' = None, modeCode: 'CE' = None, proficiencyLevelCode: 'CE' = None, preferenceInd: 'BL' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        self.modeCode = modeCode
        self.modeCode_nsprefix_ = None
        self.proficiencyLevelCode = proficiencyLevelCode
        self.proficiencyLevelCode_nsprefix_ = None
        self.preferenceInd = preferenceInd
        self.preferenceInd_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_LanguageCommunication)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_LanguageCommunication.subclass:
            return POCD_MT000040UV02_LanguageCommunication.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_LanguageCommunication(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_modeCode(self):
        return self.modeCode
    def set_modeCode(self, modeCode):
        self.modeCode = modeCode
    def get_proficiencyLevelCode(self):
        return self.proficiencyLevelCode
    def set_proficiencyLevelCode(self, proficiencyLevelCode):
        self.proficiencyLevelCode = proficiencyLevelCode
    def get_preferenceInd(self):
        return self.preferenceInd
    def set_preferenceInd(self, preferenceInd):
        self.preferenceInd = preferenceInd
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.languageCode is not None or
            self.modeCode is not None or
            self.proficiencyLevelCode is not None or
            self.preferenceInd is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.LanguageCommunication', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.LanguageCommunication')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.LanguageCommunication':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.LanguageCommunication')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.LanguageCommunication', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.LanguageCommunication'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.LanguageCommunication', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        if self.modeCode is not None:
            namespaceprefix_ = self.modeCode_nsprefix_ + ':' if (UseCapturedNS_ and self.modeCode_nsprefix_) else ''
            self.modeCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='modeCode', pretty_print=pretty_print)
        if self.proficiencyLevelCode is not None:
            namespaceprefix_ = self.proficiencyLevelCode_nsprefix_ + ':' if (UseCapturedNS_ and self.proficiencyLevelCode_nsprefix_) else ''
            self.proficiencyLevelCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='proficiencyLevelCode', pretty_print=pretty_print)
        if self.preferenceInd is not None:
            namespaceprefix_ = self.preferenceInd_nsprefix_ + ':' if (UseCapturedNS_ and self.preferenceInd_nsprefix_) else ''
            self.preferenceInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='preferenceInd', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'modeCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.modeCode = obj_
            obj_.original_tagname_ = 'modeCode'
        elif nodeName_ == 'proficiencyLevelCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proficiencyLevelCode = obj_
            obj_.original_tagname_ = 'proficiencyLevelCode'
        elif nodeName_ == 'preferenceInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preferenceInd = obj_
            obj_.original_tagname_ = 'preferenceInd'
# end class POCD_MT000040UV02_LanguageCommunication


class POCD_MT000040UV02_LegalAuthenticator(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'LA', contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, time: 'TS' = None, signatureCode: 'CV' = None, signatureText: 'ED' = None, assignedEntity: 'POCD_MT000040UV02.AssignedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.signatureCode = signatureCode
        self.signatureCode_nsprefix_ = None
        self.signatureText = signatureText
        self.signatureText_nsprefix_ = None
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_LegalAuthenticator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_LegalAuthenticator.subclass:
            return POCD_MT000040UV02_LegalAuthenticator.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_LegalAuthenticator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_signatureCode(self):
        return self.signatureCode
    def set_signatureCode(self, signatureCode):
        self.signatureCode = signatureCode
    def get_signatureText(self):
        return self.signatureText
    def set_signatureText(self, signatureText):
        self.signatureText = signatureText
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def set_contextControlCode(self, contextControlCode):
        self.contextControlCode = contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ALY', 'ATND', 'AUT', 'AUTHEN', 'BBY', 'BEN', 'CAGNT', 'CALLBCK', 'CAT', 'CON', 'COV', 'CSM', 'CST', 'DEV', 'DIR', 'DIS', 'DIST', 'DON', 'DST', 'ELOC', 'ENT', 'ESC', 'EXPAGNT', 'EXPART', 'EXPTRGT', 'EXSRC', 'GUAR', 'HLD', 'IND', 'INF', 'IRCP', 'LA', 'LOC', 'NOT', 'NRD', 'ORG', 'PART', 'PPRF', 'PRCP', 'PRD', 'PRF', 'RCT', 'RCV', 'RDV', 'REF', 'REFB', 'REFT', 'RESP', 'RML', 'SBJ', 'SPC', 'SPRF', 'TRANS', 'TRC', 'VIA', 'VRF', 'WIT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationType_patterns_, ))
    validate_ParticipationType_patterns_ = [['^([^\\s]+)$']]
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AN', 'AP', 'ON', 'OP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ContextControl' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ContextControl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ContextControl_patterns_, ))
    validate_ContextControl_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.time is not None or
            self.signatureCode is not None or
            self.signatureText is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.LegalAuthenticator', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.LegalAuthenticator')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.LegalAuthenticator':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.LegalAuthenticator')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.LegalAuthenticator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.LegalAuthenticator'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "LA" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode != "OP" and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.LegalAuthenticator', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.signatureCode is not None:
            namespaceprefix_ = self.signatureCode_nsprefix_ + ':' if (UseCapturedNS_ and self.signatureCode_nsprefix_) else ''
            self.signatureCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='signatureCode', pretty_print=pretty_print)
        if self.signatureText is not None:
            namespaceprefix_ = self.signatureText_nsprefix_ + ':' if (UseCapturedNS_ and self.signatureText_nsprefix_) else ''
            self.signatureText.export(outfile, level, namespaceprefix_, namespacedef_='', name_='signatureText', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.contextControlCode = ' '.join(self.contextControlCode.split())
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'signatureCode':
            class_obj_ = self.get_class_obj_(child_, CV)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signatureCode = obj_
            obj_.original_tagname_ = 'signatureCode'
        elif nodeName_ == 'signatureText':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signatureText = obj_
            obj_.original_tagname_ = 'signatureText'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040UV02_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class POCD_MT000040UV02_LegalAuthenticator


class POCD_MT000040UV02_Location(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'LOC', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, healthCareFacility: 'POCD_MT000040UV02.HealthCareFacility' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.healthCareFacility = healthCareFacility
        self.healthCareFacility_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Location)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Location.subclass:
            return POCD_MT000040UV02_Location.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Location(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_healthCareFacility(self):
        return self.healthCareFacility
    def set_healthCareFacility(self, healthCareFacility):
        self.healthCareFacility = healthCareFacility
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ALY', 'ATND', 'AUT', 'AUTHEN', 'BBY', 'BEN', 'CAGNT', 'CALLBCK', 'CAT', 'CON', 'COV', 'CSM', 'CST', 'DEV', 'DIR', 'DIS', 'DIST', 'DON', 'DST', 'ELOC', 'ENT', 'ESC', 'EXPAGNT', 'EXPART', 'EXPTRGT', 'EXSRC', 'GUAR', 'HLD', 'IND', 'INF', 'IRCP', 'LA', 'LOC', 'NOT', 'NRD', 'ORG', 'PART', 'PPRF', 'PRCP', 'PRD', 'PRF', 'RCT', 'RCV', 'RDV', 'REF', 'REFB', 'REFT', 'RESP', 'RML', 'SBJ', 'SPC', 'SPRF', 'TRANS', 'TRC', 'VIA', 'VRF', 'WIT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationType_patterns_, ))
    validate_ParticipationType_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.healthCareFacility is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Location', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Location')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Location':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Location')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Location', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Location'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "LOC" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Location', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.healthCareFacility is not None:
            namespaceprefix_ = self.healthCareFacility_nsprefix_ + ':' if (UseCapturedNS_ and self.healthCareFacility_nsprefix_) else ''
            self.healthCareFacility.export(outfile, level, namespaceprefix_, namespacedef_='', name_='healthCareFacility', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'healthCareFacility':
            obj_ = POCD_MT000040UV02_HealthCareFacility.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.healthCareFacility = obj_
            obj_.original_tagname_ = 'healthCareFacility'
# end class POCD_MT000040UV02_Location


class POCD_MT000040UV02_MaintainedEntity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'MNT', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, effectiveTime: 'IVL_TS' = None, maintainingPerson: 'POCD_MT000040UV02.Person' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.maintainingPerson = maintainingPerson
        self.maintainingPerson_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_MaintainedEntity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_MaintainedEntity.subclass:
            return POCD_MT000040UV02_MaintainedEntity.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_MaintainedEntity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_maintainingPerson(self):
        return self.maintainingPerson
    def set_maintainingPerson(self, maintainingPerson):
        self.maintainingPerson = maintainingPerson
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCESS', 'ACTI', 'ACTIB', 'ACTIM', 'ACTIR', 'ACTM', 'ADJV', 'ADJY', 'ADMM', 'ADTV', 'AFFL', 'AGNT', 'ALQT', 'ASSIGNED', 'BASE', 'BIRTHPL', 'BOND', 'CAREGIVER', 'CASEBJ', 'CHILD', 'CIT', 'CLAIM', 'COLR', 'COMPAR', 'CON', 'CONC', 'CONT', 'CONY', 'COVPTY', 'CRED', 'CRINV', 'CRSPNSR', 'DEATHPLC', 'DEPEN', 'DSDLOC', 'DST', 'ECON', 'EMP', 'EQUIV', 'EXPAGTCAR', 'EXPR', 'EXPVECTOR', 'FLVR', 'FOMITE', 'GEN', 'GRIC', 'GUAR', 'GUARD', 'HLD', 'HLTHCHRT', 'IACT', 'IDENT', 'INDIV', 'INGR', 'INST', 'INVSBJ', 'ISDLOC', 'ISLT', 'LIC', 'LOCE', 'MANU', 'MBR', 'MECH', 'MIL', 'MNT', 'NAMED', 'NOK', 'NOT', 'NURPRAC', 'NURS', 'OWN', 'PA', 'PART', 'PAT', 'PAYEE', 'PAYOR', 'PHYS', 'POLHOLD', 'PROG', 'PROV', 'PRS', 'PRSV', 'QUAL', 'RESBJ', 'RET', 'RGPR', 'ROL', 'SAME', 'SDLOC', 'SGNOFF', 'SPEC', 'SPNSR', 'STBL', 'STD', 'STOR', 'SUBS', 'SUBSCR', 'SUBY', 'TERR', 'THER', 'UNDWRT', 'USED', 'WRTE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClass_patterns_, ))
    validate_RoleClass_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.effectiveTime is not None or
            self.maintainingPerson is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.MaintainedEntity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.MaintainedEntity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.MaintainedEntity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.MaintainedEntity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.MaintainedEntity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.MaintainedEntity'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "MNT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.MaintainedEntity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.maintainingPerson is not None:
            namespaceprefix_ = self.maintainingPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.maintainingPerson_nsprefix_) else ''
            self.maintainingPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='maintainingPerson', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'maintainingPerson':
            obj_ = POCD_MT000040UV02_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.maintainingPerson = obj_
            obj_.original_tagname_ = 'maintainingPerson'
# end class POCD_MT000040UV02_MaintainedEntity


class POCD_MT000040UV02_ManufacturedProduct(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'MANU', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, manufacturedLabeledDrug: 'POCD_MT000040UV02.LabeledDrug' = None, manufacturedMaterial: 'POCD_MT000040UV02.Material' = None, manufacturerOrganization: 'POCD_MT000040UV02.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.manufacturedLabeledDrug = manufacturedLabeledDrug
        self.manufacturedLabeledDrug_nsprefix_ = None
        self.manufacturedMaterial = manufacturedMaterial
        self.manufacturedMaterial_nsprefix_ = None
        self.manufacturerOrganization = manufacturerOrganization
        self.manufacturerOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_ManufacturedProduct)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_ManufacturedProduct.subclass:
            return POCD_MT000040UV02_ManufacturedProduct.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_ManufacturedProduct(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_manufacturedLabeledDrug(self):
        return self.manufacturedLabeledDrug
    def set_manufacturedLabeledDrug(self, manufacturedLabeledDrug):
        self.manufacturedLabeledDrug = manufacturedLabeledDrug
    def get_manufacturedMaterial(self):
        return self.manufacturedMaterial
    def set_manufacturedMaterial(self, manufacturedMaterial):
        self.manufacturedMaterial = manufacturedMaterial
    def get_manufacturerOrganization(self):
        return self.manufacturerOrganization
    def set_manufacturerOrganization(self, manufacturerOrganization):
        self.manufacturerOrganization = manufacturerOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCESS', 'ACTI', 'ACTIB', 'ACTIM', 'ACTIR', 'ACTM', 'ADJV', 'ADJY', 'ADMM', 'ADTV', 'AFFL', 'AGNT', 'ALQT', 'ASSIGNED', 'BASE', 'BIRTHPL', 'BOND', 'CAREGIVER', 'CASEBJ', 'CHILD', 'CIT', 'CLAIM', 'COLR', 'COMPAR', 'CON', 'CONC', 'CONT', 'CONY', 'COVPTY', 'CRED', 'CRINV', 'CRSPNSR', 'DEATHPLC', 'DEPEN', 'DSDLOC', 'DST', 'ECON', 'EMP', 'EQUIV', 'EXPAGTCAR', 'EXPR', 'EXPVECTOR', 'FLVR', 'FOMITE', 'GEN', 'GRIC', 'GUAR', 'GUARD', 'HLD', 'HLTHCHRT', 'IACT', 'IDENT', 'INDIV', 'INGR', 'INST', 'INVSBJ', 'ISDLOC', 'ISLT', 'LIC', 'LOCE', 'MANU', 'MBR', 'MECH', 'MIL', 'MNT', 'NAMED', 'NOK', 'NOT', 'NURPRAC', 'NURS', 'OWN', 'PA', 'PART', 'PAT', 'PAYEE', 'PAYOR', 'PHYS', 'POLHOLD', 'PROG', 'PROV', 'PRS', 'PRSV', 'QUAL', 'RESBJ', 'RET', 'RGPR', 'ROL', 'SAME', 'SDLOC', 'SGNOFF', 'SPEC', 'SPNSR', 'STBL', 'STD', 'STOR', 'SUBS', 'SUBSCR', 'SUBY', 'TERR', 'THER', 'UNDWRT', 'USED', 'WRTE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClass_patterns_, ))
    validate_RoleClass_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.manufacturedLabeledDrug is not None or
            self.manufacturedMaterial is not None or
            self.manufacturerOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ManufacturedProduct', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.ManufacturedProduct')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.ManufacturedProduct':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.ManufacturedProduct')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.ManufacturedProduct', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.ManufacturedProduct'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "MANU" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.ManufacturedProduct', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.manufacturedLabeledDrug is not None:
            namespaceprefix_ = self.manufacturedLabeledDrug_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturedLabeledDrug_nsprefix_) else ''
            self.manufacturedLabeledDrug.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturedLabeledDrug', pretty_print=pretty_print)
        if self.manufacturedMaterial is not None:
            namespaceprefix_ = self.manufacturedMaterial_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturedMaterial_nsprefix_) else ''
            self.manufacturedMaterial.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturedMaterial', pretty_print=pretty_print)
        if self.manufacturerOrganization is not None:
            namespaceprefix_ = self.manufacturerOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturerOrganization_nsprefix_) else ''
            self.manufacturerOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturerOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'manufacturedLabeledDrug':
            obj_ = POCD_MT000040UV02_LabeledDrug.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturedLabeledDrug = obj_
            obj_.original_tagname_ = 'manufacturedLabeledDrug'
        elif nodeName_ == 'manufacturedMaterial':
            obj_ = POCD_MT000040UV02_Material.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturedMaterial = obj_
            obj_.original_tagname_ = 'manufacturedMaterial'
        elif nodeName_ == 'manufacturerOrganization':
            obj_ = POCD_MT000040UV02_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturerOrganization = obj_
            obj_.original_tagname_ = 'manufacturerOrganization'
# end class POCD_MT000040UV02_ManufacturedProduct


class POCD_MT000040UV02_Material(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClass' = 'MMAT', determinerCode: 'EntityDeterminer' = 'KIND', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CE' = None, name: 'EN' = None, desc: 'ED' = None, formCode: 'CE' = None, lotNumberText: 'ST' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.desc = desc
        self.desc_nsprefix_ = None
        self.formCode = formCode
        self.formCode_nsprefix_ = None
        self.lotNumberText = lotNumberText
        self.lotNumberText_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Material)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Material.subclass:
            return POCD_MT000040UV02_Material.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Material(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_desc(self):
        return self.desc
    def set_desc(self, desc):
        self.desc = desc
    def get_formCode(self):
        return self.formCode
    def set_formCode(self, formCode):
        self.formCode = formCode
    def get_lotNumberText(self):
        return self.lotNumberText
    def set_lotNumberText(self, lotNumberText):
        self.lotNumberText = lotNumberText
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_determinerCode(self):
        return self.determinerCode
    def set_determinerCode(self, determinerCode):
        self.determinerCode = determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityClass(self, value):
        # Validate type EntityClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ANM', 'CER', 'CHEM', 'CITY', 'CONT', 'COUNTRY', 'COUNTY', 'DEV', 'ENT', 'FOOD', 'HCE', 'HOLD', 'LIV', 'MAT', 'MIC', 'MMAT', 'MODDV', 'NAT', 'NLIV', 'ORG', 'PLC', 'PLNT', 'PROVINCE', 'PSN', 'PUB', 'RGRP', 'STATE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityClass_patterns_, ))
    validate_EntityClass_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INSTANCE', 'KIND', 'QUANTIFIED_KIND']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityDeterminer' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityDeterminer_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityDeterminer_patterns_, ))
    validate_EntityDeterminer_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.name is not None or
            self.desc is not None or
            self.formCode is not None or
            self.lotNumberText is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Material', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Material')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Material':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Material')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Material', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Material'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "MMAT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode != "KIND" and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Material', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.desc is not None:
            namespaceprefix_ = self.desc_nsprefix_ + ':' if (UseCapturedNS_ and self.desc_nsprefix_) else ''
            self.desc.export(outfile, level, namespaceprefix_, namespacedef_='', name_='desc', pretty_print=pretty_print)
        if self.formCode is not None:
            namespaceprefix_ = self.formCode_nsprefix_ + ':' if (UseCapturedNS_ and self.formCode_nsprefix_) else ''
            self.formCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='formCode', pretty_print=pretty_print)
        if self.lotNumberText is not None:
            namespaceprefix_ = self.lotNumberText_nsprefix_ + ':' if (UseCapturedNS_ and self.lotNumberText_nsprefix_) else ''
            self.lotNumberText.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lotNumberText', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClass(self.classCode)    # validate type EntityClass
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'name':
            class_obj_ = self.get_class_obj_(child_, EN)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'desc':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.desc = obj_
            obj_.original_tagname_ = 'desc'
        elif nodeName_ == 'formCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.formCode = obj_
            obj_.original_tagname_ = 'formCode'
        elif nodeName_ == 'lotNumberText':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lotNumberText = obj_
            obj_.original_tagname_ = 'lotNumberText'
# end class POCD_MT000040UV02_Material


class POCD_MT000040UV02_NonXMLBody(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'DOCBODY', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, text: 'ED' = None, confidentialityCode: 'CE' = None, languageCode: 'CS' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.confidentialityCode = confidentialityCode
        self.confidentialityCode_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_NonXMLBody)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_NonXMLBody.subclass:
            return POCD_MT000040UV02_NonXMLBody.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_NonXMLBody(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_confidentialityCode(self):
        return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode):
        self.confidentialityCode = confidentialityCode
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACCM', 'ACCT', 'ACSN', 'ACT', 'ACTN', 'ADJUD', 'AEXPOS', 'ALRT', 'BATTERY', 'CACT', 'CASE', 'CATEGORY', 'CDALVLONE', 'CLNTRL', 'CLUSTER', 'CNOD', 'CNTRCT', 'COMPOSITION', 'CONC', 'COND', 'CONS', 'CONTAINER', 'CONTREG', 'COV', 'CTTEVENT', 'DETPOL', 'DGIMG', 'DIET', 'DISPACT', 'DOC', 'DOCBODY', 'DOCCLIN', 'DOCSECT', 'EHR', 'ENC', 'EXP', 'EXPOS', 'EXTRACT', 'FCNTRCT', 'FOLDER', 'GEN', 'GROUPER', 'INC', 'INFO', 'INFRM', 'INVE', 'INVSTG', 'JURISPOL', 'LIST', 'LLD', 'LOC', 'MPROT', 'OBS', 'OBSCOR', 'OBSSER', 'ORGPOL', 'OUTB', 'PCPR', 'PHN', 'POL', 'POLICY', 'POS', 'POSACC', 'POSCOORD', 'PRN', 'PROC', 'REG', 'REV', 'RLD', 'ROIBND', 'ROIOVL', 'RTRD', 'SBADM', 'SBEXT', 'SCOPOL', 'SEQ', 'SEQVAR', 'SFWL', 'SIT', 'SPCOBS', 'SPCTRT', 'SPECCOLLECT', 'SPLY', 'STC', 'STDPOL', 'STN', 'STORE', 'SUBST', 'SUP', 'TEXPOS', 'TOPIC', 'TRD', 'TRFR', 'TRNS', 'VERIF', 'XACT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClass_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClass_patterns_, ))
    validate_ActClass_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'CRT', 'DEF', 'EVN', 'EVN.CRT', 'EXPEC', 'GOL', 'INT', 'OPT', 'PERM', 'PERMRQ', 'PRMS', 'PRP', 'RMD', 'RQO', 'RSK', 'SLOT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActMood_patterns_, ))
    validate_ActMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.text is not None or
            self.confidentialityCode is not None or
            self.languageCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.NonXMLBody', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.NonXMLBody')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.NonXMLBody':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.NonXMLBody')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.NonXMLBody', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.NonXMLBody'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOCBODY" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.NonXMLBody', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.confidentialityCode is not None:
            namespaceprefix_ = self.confidentialityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.confidentialityCode_nsprefix_) else ''
            self.confidentialityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='confidentialityCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.confidentialityCode = obj_
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
# end class POCD_MT000040UV02_NonXMLBody


class POCD_MT000040UV02_Observation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassObservation' = 'OBS', moodCode: 'x_ActMoodDocumentObservation' = None, actionNegationInd: 'bl' = None, negationInd: 'bl' = None, isCriterionInd: 'bl' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040UV02.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, derivationExpr: 'ST' = None, title: 'ED' = None, text: 'ED' = None, statusCode: 'CS' = None, effectiveTime: 'IVL_TS' = None, activityTime: List_['SXCM_TS'] = None, availabilityTime: 'TS' = None, priorityCode: 'CE' = None, confidentialityCode: List_['CE'] = None, repeatNumber: 'IVL_INT' = None, uncertaintyCode: 'CE' = None, languageCode: 'CS' = None, value: List_['ANY'] = None, valueNegationInd: 'BL' = None, interpretationCode: List_['CE'] = None, methodCode: List_['CE'] = None, targetSiteCode: List_['CD'] = None, subject: 'POCD_MT000040UV02.Subject' = None, specimen: List_['POCD_MT000040UV02.Specimen'] = None, performer: List_['POCD_MT000040UV02.Performer2'] = None, author: List_['POCD_MT000040UV02.Author'] = None, informant: List_['POCD_MT000040UV02.Informant12'] = None, participant: List_['POCD_MT000040UV02.Participant3'] = None, entryRelationship: List_['POCD_MT000040UV02.EntryRelationship'] = None, reference: List_['POCD_MT000040UV02.Reference'] = None, precondition: List_['POCD_MT000040UV02.Precondition'] = None, referenceRange: List_['POCD_MT000040UV02.ReferenceRange'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        self.actionNegationInd = _cast(bool, actionNegationInd)
        self.actionNegationInd_nsprefix_ = None
        self.negationInd = _cast(bool, negationInd)
        self.negationInd_nsprefix_ = None
        self.isCriterionInd = _cast(bool, isCriterionInd)
        self.isCriterionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.derivationExpr = derivationExpr
        self.derivationExpr_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        if activityTime is None:
            self.activityTime = []
        else:
            self.activityTime = activityTime
        self.activityTime_nsprefix_ = None
        self.availabilityTime = availabilityTime
        self.availabilityTime_nsprefix_ = None
        self.priorityCode = priorityCode
        self.priorityCode_nsprefix_ = None
        if confidentialityCode is None:
            self.confidentialityCode = []
        else:
            self.confidentialityCode = confidentialityCode
        self.confidentialityCode_nsprefix_ = None
        self.repeatNumber = repeatNumber
        self.repeatNumber_nsprefix_ = None
        self.uncertaintyCode = uncertaintyCode
        self.uncertaintyCode_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
        self.value_nsprefix_ = None
        self.valueNegationInd = valueNegationInd
        self.valueNegationInd_nsprefix_ = None
        if interpretationCode is None:
            self.interpretationCode = []
        else:
            self.interpretationCode = interpretationCode
        self.interpretationCode_nsprefix_ = None
        if methodCode is None:
            self.methodCode = []
        else:
            self.methodCode = methodCode
        self.methodCode_nsprefix_ = None
        if targetSiteCode is None:
            self.targetSiteCode = []
        else:
            self.targetSiteCode = targetSiteCode
        self.targetSiteCode_nsprefix_ = None
        self.subject = subject
        self.subject_nsprefix_ = None
        if specimen is None:
            self.specimen = []
        else:
            self.specimen = specimen
        self.specimen_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if entryRelationship is None:
            self.entryRelationship = []
        else:
            self.entryRelationship = entryRelationship
        self.entryRelationship_nsprefix_ = None
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        self.reference_nsprefix_ = None
        if precondition is None:
            self.precondition = []
        else:
            self.precondition = precondition
        self.precondition_nsprefix_ = None
        if referenceRange is None:
            self.referenceRange = []
        else:
            self.referenceRange = referenceRange
        self.referenceRange_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040UV02_Observation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040UV02_Observation.subclass:
            return POCD_MT000040UV02_Observation.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040UV02_Observation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_derivationExpr(self):
        return self.derivationExpr
    def set_derivationExpr(self, derivationExpr):
        self.derivationExpr = derivationExpr
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_activityTime(self):
        return self.activityTime
    def set_activityTime(self, activityTime):
        self.activityTime = activityTime
    def add_activityTime(self, value):
        self.activityTime.append(value)
    def insert_activityTime_at(self, index, value):
        self.activityTime.insert(index, value)
    def replace_activityTime_at(self, index, value):
        self.activityTime[index] = value
    def get_availabilityTime(self):
        return self.availabilityTime
    def set_availabilityTime(self, availabilityTime):
        self.availabilityTime = availabilityTime
    def get_priorityCode(self):
        return self.priorityCode
    def set_priorityCode(self, priorityCode):
        self.priorityCode = priorityCode
    def get_confidentialityCode(self):
        return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode):
        self.confidentialityCode = confidentialityCode
    def add_confidentialityCode(self, value):
        self.confidentialityCode.append(value)
    def insert_confidentialityCode_at(self, index, value):
        self.confidentialityCode.insert(index, value)
    def replace_confidentialityCode_at(self, index, value):
        self.confidentialityCode[index] = value
    def get_repeatNumber(self):
        return self.repeatNumber
    def set_repeatNumber(self, repeatNumber):
        self.repeatNumber = repeatNumber
    def get_uncertaintyCode(self):
        return self.uncertaintyCode
    def set_uncertaintyCode(self, uncertaintyCode):
        self.uncertaintyCode = uncertaintyCode
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def set_value_with_type(self, value):
        self.value = value
        value.original_tagname_ = 'value'
        value.extensiontype_ = value.__class__.__name__
    def add_value(self, value):
        self.value.append(value)
    def add_value_with_type(self, value):
        self.value.append(value)
        value.original_tagname_ = 'value'
        value.extensiontype_ = value.__class__.__name__
    def insert_value_at(self, index, value):
        self.value.insert(index, value)
    def replace_value_at(self, index, value):
        self.value[index] = value
    def get_valueNegationInd(self):
        return self.valueNegationInd
    def set_valueNegationInd(self, valueNegationInd):
        self.valueNegationInd = valueNegationInd
    def get_interpretationCode(self):
        return self.interpretationCode
    def set_interpretationCode(self, interpretationCode):
        self.interpretationCode = interpretationCode
    def add_interpretationCode(self, value):
        self.interpretationCode.append(value)
    def insert_interpretationCode_at(self, index, value):
        self.interpretationCode.insert(index, value)
    def replace_interpretationCode_at(self, index, value):
        self.interpretationCode[index] = value
    def get_methodCode(self):
        return self.methodCode
    def set_methodCode(self, methodCode):
        self.methodCode = methodCode
    def add_methodCode(self, value):
        self.methodCode.append(value)
    def insert_methodCode_at(self, index, value):
        self.methodCode.insert(index, value)
    def replace_methodCode_at(self, index, value):
        self.methodCode[index] = value
    def get_targetSiteCode(self):
        return self.targetSiteCode
    def set_targetSiteCode(self, targetSiteCode):
        self.targetSiteCode = targetSiteCode
    def add_targetSiteCode(self, value):
        self.targetSiteCode.append(value)
    def insert_targetSiteCode_at(self, index, value):
        self.targetSiteCode.insert(index, value)
    def replace_targetSiteCode_at(self, index, value):
        self.targetSiteCode[index] = value
    def get_subject(self):
        return self.subject
    def set_subject(self, subject):
        self.subject = subject
    def get_specimen(self):
        return self.specimen
    def set_specimen(self, specimen):
        self.specimen = specimen
    def add_specimen(self, value):
        self.specimen.append(value)
    def insert_specimen_at(self, index, value):
        self.specimen.insert(index, value)
    def replace_specimen_at(self, index, value):
        self.specimen[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_entryRelationship(self):
        return self.entryRelationship
    def set_entryRelationship(self, entryRelationship):
        self.entryRelationship = entryRelationship
    def add_entryRelationship(self, value):
        self.entryRelationship.append(value)
    def insert_entryRelationship_at(self, index, value):
        self.entryRelationship.insert(index, value)
    def replace_entryRelationship_at(self, index, value):
        self.entryRelationship[index] = value
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def add_reference(self, value):
        self.reference.append(value)
    def insert_reference_at(self, index, value):
        self.reference.insert(index, value)
    def replace_reference_at(self, index, value):
        self.reference[index] = value
    def get_precondition(self):
        return self.precondition
    def set_precondition(self, precondition):
        self.precondition = precondition
    def add_precondition(self, value):
        self.precondition.append(value)
    def insert_precondition_at(self, index, value):
        self.precondition.insert(index, value)
    def replace_precondition_at(self, index, value):
        self.precondition[index] = value
    def get_referenceRange(self):
        return self.referenceRange
    def set_referenceRange(self, referenceRange):
        self.referenceRange = referenceRange
    def add_referenceRange(self, value):
        self.referenceRange.append(value)
    def insert_referenceRange_at(self, index, value):
        self.referenceRange.insert(index, value)
    def replace_referenceRange_at(self, index, value):
        self.referenceRange[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def get_actionNegationInd(self):
        return self.actionNegationInd
    def set_actionNegationInd(self, actionNegationInd):
        self.actionNegationInd = actionNegationInd
    def get_negationInd(self):
        return self.negationInd
    def set_negationInd(self, negationInd):
        self.negationInd = negationInd
    def get_isCriterionInd(self):
        return self.isCriterionInd
    def set_isCriterionInd(self, isCriterionInd):
        self.isCriterionInd = isCriterionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NullFlavor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^([^\\s]+)$']]
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['OBS', 'ROIBND', 'ROIOVL', 'LLD', 'PRN', 'RLD', 'SFWL', 'SIT', 'STN', 'SUP', 'RTRD', 'TRD', 'ALRT', 'BATTERY', 'CLNTRL', 'CNOD', 'CONC', 'COND', 'CASE', 'OUTB', 'DGIMG', 'GEN', 'DETPOL', 'EXP', 'LOC', 'PHN', 'POL', 'SEQ', 'SEQVAR', 'INVSTG', 'OBSSER', 'OBSCOR', 'POS', 'POSACC', 'POSCOORD', 'SPCOBS', 'VERIF']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClassObservation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassObservation_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClassObservation_patterns_, ))
    validate_ActClassObservation_patterns_ = [['^([^\\s]+)$']]
    def validate_x_ActMoodDocumentObservation(self, value):
        # Validate type x_ActMoodDocumentObservation, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['APT', 'ARQ', 'DEF', 'EVN', 'GOL', 'INT', 'PRMS', 'PRP', 'RQO', 'RSK']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_ActMoodDocumentObservation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActMoodDocumentObservation_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_ActMoodDocumentObservation_patterns_, ))
    validate_x_ActMoodDocumentObservation_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.derivationExpr is not None or
            self.title is not None or
            self.text is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.activityTime or
            self.availabilityTime is not None or
            self.priorityCode is not None or
            self.confidentialityCode or
            self.repeatNumber is not None or
            self.uncertaintyCode is not None or
            self.languageCode is not None or
            self.value or
            self.valueNegationInd is not None or
            self.interpretationCode or
            self.methodCode or
            self.targetSiteCode or
            self.subject is not None or
            self.specimen or
            self.performer or
            self.author or
            self.informant or
            self.participant or
            self.entryRelationship or
            self.reference or
            self.precondition or
            self.referenceRange
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Observation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040UV02.Observation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040UV02.Observation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040UV02.Observation')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040UV02.Observation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040UV02.Observation'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "OBS" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
        if self.actionNegationInd is not None and 'actionNegationInd' not in already_processed:
            already_processed.add('actionNegationInd')
            outfile.write(' actionNegationInd="%s"' % self.gds_format_boolean(self.actionNegationInd, input_name='actionNegationInd'))
        if self.negationInd is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            outfile.write(' negationInd="%s"' % self.gds_format_boolean(self.negationInd, input_name='negationInd'))
        if self.isCriterionInd is not None and 'isCriterionInd' not in already_processed:
            already_processed.add('isCriterionInd')
            outfile.write(' isCriterionInd="%s"' % self.gds_format_boolean(self.isCriterionInd, input_name='isCriterionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:sdtc" ', name_='POCD_MT000040UV02.Observation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.derivationExpr is not None:
            namespaceprefix_ = self.derivationExpr_nsprefix_ + ':' if (UseCapturedNS_ and self.derivationExpr_nsprefix_) else ''
            self.derivationExpr.export(outfile, level, namespaceprefix_, namespacedef_='', name_='derivationExpr', pretty_print=pretty_print)
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            self.title.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        for activityTime_ in self.activityTime:
            namespaceprefix_ = self.activityTime_nsprefix_ + ':' if (UseCapturedNS_ and self.activityTime_nsprefix_) else ''
            activityTime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='activityTime', pretty_print=pretty_print)
        if self.availabilityTime is not None:
            namespaceprefix_ = self.availabilityTime_nsprefix_ + ':' if (UseCapturedNS_ and self.availabilityTime_nsprefix_) else ''
            self.availabilityTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='availabilityTime', pretty_print=pretty_print)
        if self.priorityCode is not None:
            namespaceprefix_ = self.priorityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.priorityCode_nsprefix_) else ''
            self.priorityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='priorityCode', pretty_print=pretty_print)
        for confidentialityCode_ in self.confidentialityCode:
            namespaceprefix_ = self.confidentialityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.confidentialityCode_nsprefix_) else ''
            confidentialityCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='confidentialityCode', pretty_print=pretty_print)
        if self.repeatNumber is not None:
            namespaceprefix_ = self.repeatNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.repeatNumber_nsprefix_) else ''
            self.repeatNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='repeatNumber', pretty_print=pretty_print)
        if self.uncertaintyCode is not None:
            namespaceprefix_ = self.uncertaintyCode_nsprefix_ + ':' if (UseCapturedNS_ and self.uncertaintyCode_nsprefix_) else ''
            self.uncertaintyCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='uncertaintyCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        for value_ in self.value:
            value_.export(outfile, level, namespaceprefix_, name_='value', namespacedef_='', pretty_print=pretty_print)
        if self.valueNegationInd is not None:
            namespaceprefix_ = self.valueNegationInd_nsprefix_ + ':' if (UseCapturedNS_ and self.valueNegationInd_nsprefix_) else ''
            self.valueNegationInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueNegationInd', pretty_print=pretty_print)
        for interpretationCode_ in self.interpretationCode:
            namespaceprefix_ = self.interpretationCode_nsprefix_ + ':' if (UseCapturedNS_ and self.interpretationCode_nsprefix_) else ''
            interpretationCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='interpretationCode', pretty_print=pretty_print)
        for methodCode_ in self.methodCode:
            namespaceprefix_ = self.methodCode_nsprefix_ + ':' if (UseCapturedNS_ and self.methodCode_nsprefix_) else ''
            methodCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='methodCode', pretty_print=pretty_print)
        for targetSiteCode_ in self.targetSiteCode:
            namespaceprefix_ = self.targetSiteCode_nsprefix_ + ':' if (UseCapturedNS_ and self.targetSiteCode_nsprefix_) else ''
            targetSiteCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='targetSiteCode', pretty_print=pretty_print)
        if self.subject is not None:
            namespaceprefix_ = self.subject_nsprefix_ + ':' if (UseCapturedNS_ and self.subject_nsprefix_) else ''
            self.subject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subject', pretty_print=pretty_print)
        for specimen_ in self.specimen:
            namespaceprefix_ = self.specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_nsprefix_) else ''
            specimen_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen', pretty_print=pretty_print)
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for entryRelationship_ in self.entryRelationship:
            namespaceprefix_ = self.entryRelationship_nsprefix_ + ':' if (UseCapturedNS_ and self.entryRelationship_nsprefix_) else ''
            entryRelationship_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entryRelationship', pretty_print=pretty_print)
        for reference_ in self.reference:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        for precondition_ in self.precondition:
            namespaceprefix_ = self.precondition_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition_nsprefix_) else ''
            precondition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='precondition', pretty_print=pretty_print)
        for referenceRange_ in self.referenceRange:
            namespaceprefix_ = self.referenceRange_nsprefix_ + ':' if (UseCapturedNS_ and self.referenceRange_nsprefix_) else ''
            referenceRange_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='referenceRange', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_x_ActMoodDocumentObservation(self.moodCode)    # validate type x_ActMoodDocumentObservation
        value = find_attr_value_('actionNegationInd', node)
        if value is not None and 'actionNegationInd' not in already_processed:
            already_processed.add('actionNegationInd')
            if value in ('true', '1'):
                self.actionNegationInd = True
            elif value in ('false', '0'):
                self.actionNegationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.actionNegationInd)    # validate type bl
        value = find_attr_value_('negationInd', node)
        if value is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            if value in ('true', '1'):
                self.negationInd = True
            elif value in ('false', '0'):
                self.negationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.negationInd)    # validate type bl
        value = find_attr_value_('isCriterionInd', node)
        if value is not None and 'isCriterionInd' not in already_processed:
            already_processed.add('isCriterionInd')
            if value in ('true', '1'):
                self.isCriterionInd = True
            elif value in ('false', '0'):
                self.isCriterionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.isCriterionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040UV02_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'derivationExpr':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.derivationExpr = obj_
            obj_.original_tagname_ = 'derivationExpr'
        elif nodeName_ == 'title':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title = obj_
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'activityTime':
            class_obj_ = self.get_class_obj_(child_, SXCM_TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.activityTime.append(obj_)
            obj_.original_tagname_ = 'activityTime'
        elif nodeName_ == 'availabilityTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.availabilityTime = obj_
            obj_.original_tagname_ = 'availabilityTime'
        elif nodeName_ == 'priorityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.priorityCode = obj_
            obj_.original_tagname_ = 'priorityCode'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.confidentialityCode.append(obj_)
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'repeatNumber':
            obj_ = IVL_INT.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.repeatNumber = obj_
            obj_.original_tagname_ = 'repeatNumber'
        elif nodeName_ == 'uncertaintyCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.uncertaintyCode = obj_
            obj_.original_tagname_ = 'uncertaintyCode'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'value':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()["" + type_name_]
                obj_ = class_.factory()
                obj_.build(child_, gds_collector_=gds_collector_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <value> element')
            self.value.append(obj_)
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'valueNegationInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueNegationInd = obj_
            obj_.original_tagname_ = 'valueNegationInd'
        elif nodeName_ == 'interpretationCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.interpretationCode.append(obj_)
            obj_.original_tagname_ = 'interpretationCode'
        elif nodeName_ == 'methodCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.methodCode.append(obj_)
            obj_.original_tagname_ = 'methodCode'
        elif nodeName_ == 'targetSiteCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.targetSiteCode.append(obj_)
            obj_.original_tagname_ = 'targetSiteCode'
        elif nodeName_ == 'subject':
            obj_ = POCD_MT000040UV02_Subject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subject = obj_
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'specimen':
            obj_ = POCD_MT000040UV02_Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen.append(obj_)
            obj_.original_tagname_ = 'specimen'
        elif nodeName_ == 'performer':
            obj_ = POCD_MT000040UV02_Performer2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040UV02_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040UV02_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040UV02_Participant3.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'entryRelationship':
            obj_ = POCD_MT000040UV02_EntryRelationship.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entryRelationship.append(obj_)
            obj_.original_tagname_ = 'entryRelationship'
        elif nodeName_ == 'reference':
            obj_ = POCD_MT000040UV02_Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference.append(obj_)
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'precondition':
            obj_ = POCD_MT000040UV02_Precondition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition.append(obj_)
            obj_.original_tagname_ = 'precondition'
      