#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Jan 30 14:47:55 2025 by generateDS.py version 2.43.3.
# Python 3.12.6 (tags/v3.12.6:a4a2d2b, Sep  6 2024, 20:11:23) [MSC v.1940 64 bit (AMD64)]
#
# Command line options:
#   ('-o', 'r5.py')
#   ('--no-questions', '')
#   ('-f', '')
#   ('--export', 'write json')
#   ('--use-namespacedef-instead-of-namespaceprefix-for', 'xhtml')
#
# Command line arguments:
#   C:\Users\nikol\gitrepos\malac-hd\malac\models\fhir\schema\r5\fhir-single.xsd
#
# Command line:
#   generateDS.py -o "r5.py" --no-questions -f --export="write json" --use-namespacedef-instead-of-namespaceprefix-for="xhtml" C:\Users\nikol\gitrepos\malac-hd\malac\models\fhir\schema\r5\fhir-single.xsd
#
# Current working directory (os.getcwd()):
#   generateds
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
# imports for django and/or sqlalchemy
import json as json_
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_
from typing import List as List_


Validate_simpletypes_ = True
SaveElementTreeNode = True
SaveNodeDict = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str
node_dict = {}


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            value = ('%.15f' % float(input_data)).rstrip('0')
            if value.endswith('.'):
                value += '0'
            return value
    
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            input_data = input_data.strip()
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if instring is None:
                result = ""
            elif isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    s1 = s1.replace('\n', '&#10;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Start enum classes
#
class AccountStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in error
    ONHOLD='on-hold' # On Hold
    UNKNOWN='unknown' # Unknown


class ActionCardinalityBehaviorEnum(str, Enum):
    SINGLE='single' # Single
    MULTIPLE='multiple' # Multiple


class ActionConditionKindEnum(str, Enum):
    APPLICABILITY='applicability' # Applicability
    START='start' # Start
    STOP='stop' # Stop


class ActionGroupingBehaviorEnum(str, Enum):
    VISUALGROUP='visual-group' # Visual Group
    LOGICALGROUP='logical-group' # Logical Group
    SENTENCEGROUP='sentence-group' # Sentence Group


class ActionParticipantTypeEnum(str, Enum):
    CARETEAM='careteam' # CareTeam
    DEVICE='device' # Device
    GROUP='group' # Group
    HEALTHCARESERVICE='healthcareservice' # HealthcareService
    LOCATION='location' # Location
    ORGANIZATION='organization' # Organization
    PATIENT='patient' # Patient
    PRACTITIONER='practitioner' # Practitioner
    PRACTITIONERROLE='practitionerrole' # PractitionerRole
    RELATEDPERSON='relatedperson' # RelatedPerson


class ActionPrecheckBehaviorEnum(str, Enum):
    YES='yes' # Yes
    NO='no' # No


class ActionRelationshipTypeEnum(str, Enum):
    BEFORE='before' # Before
    BEFORESTART='before-start' # Before Start
    BEFOREEND='before-end' # Before End
    CONCURRENT='concurrent' # Concurrent
    CONCURRENTWITHSTART='concurrent-with-start' # Concurrent With Start
    CONCURRENTWITHEND='concurrent-with-end' # Concurrent With End
    AFTER='after' # After
    AFTERSTART='after-start' # After Start
    AFTEREND='after-end' # After End


class ActionRequiredBehaviorEnum(str, Enum):
    MUST='must' # Must
    COULD='could' # Could
    MUSTUNLESSDOCUMENTED='must-unless-documented' # Must Unless Documented


class ActionSelectionBehaviorEnum(str, Enum):
    ANY='any' # Any
    ALL='all' # All
    ALLORNONE='all-or-none' # All Or None
    EXACTLYONE='exactly-one' # Exactly One
    ATMOSTONE='at-most-one' # At Most One
    ONEORMORE='one-or-more' # One Or More


class AddressTypeEnum(str, Enum):
    POSTAL='postal' # Postal
    PHYSICAL='physical' # Physical
    BOTH='both' # Postal & Physical


class AddressUseEnum(str, Enum):
    HOME='home' # Home
    WORK='work' # Work
    TEMP='temp' # Temporary
    OLD='old' # Old / Incorrect
    BILLING='billing' # Billing


class AdministrativeGenderEnum(str, Enum):
    MALE='male' # Male
    FEMALE='female' # Female
    OTHER='other' # Other
    UNKNOWN='unknown' # Unknown


class AdverseEventActualityEnum(str, Enum):
    ACTUAL='actual' # Adverse Event
    POTENTIAL='potential' # Potential Adverse Event


class AdverseEventStatusEnum(str, Enum):
    INPROGRESS='in-progress' # In Progress
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class AgeUnitsEnum(str, Enum):
    MIN='min' # Minute
    H='h' # Hour
    D='d' # Day
    WK='wk' # Week
    MO='mo' # Month
    A='a' # Year


class AggregationModeEnum(str, Enum):
    CONTAINED='contained' # Contained
    REFERENCED='referenced' # Referenced
    BUNDLED='bundled' # Bundled


class AllResourceTypesEnum(str, Enum):
    ACCOUNT='Account' # Account
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinition
    ACTOR_DEFINITION='ActorDefinition' # ActorDefinition
    ADMINISTRABLE_PRODUCT_DEFINITION='AdministrableProductDefinition' # AdministrableProductDefinition
    ADVERSE_EVENT='AdverseEvent' # AdverseEvent
    ALLERGY_INTOLERANCE='AllergyIntolerance' # AllergyIntolerance
    APPOINTMENT='Appointment' # Appointment
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponse
    ARTIFACT_ASSESSMENT='ArtifactAssessment' # ArtifactAssessment
    AUDIT_EVENT='AuditEvent' # AuditEvent
    BASIC='Basic' # Basic
    BINARY='Binary' # Binary
    BIOLOGICALLY_DERIVED_PRODUCT='BiologicallyDerivedProduct' # BiologicallyDerivedProduct
    BIOLOGICALLY_DERIVED_PRODUCT_DISPENSE='BiologicallyDerivedProductDispense' # BiologicallyDerivedProductDispense
    BODY_STRUCTURE='BodyStructure' # BodyStructure
    BUNDLE='Bundle' # Bundle
    CANONICAL_RESOURCE='CanonicalResource' # CanonicalResource
    CAPABILITY_STATEMENT='CapabilityStatement' # CapabilityStatement
    CARE_PLAN='CarePlan' # CarePlan
    CARE_TEAM='CareTeam' # CareTeam
    CHARGE_ITEM='ChargeItem' # ChargeItem
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CITATION='Citation' # Citation
    CLAIM='Claim' # Claim
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponse
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpression
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    CODE_SYSTEM='CodeSystem' # CodeSystem
    COMMUNICATION='Communication' # Communication
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequest
    COMPARTMENT_DEFINITION='CompartmentDefinition' # CompartmentDefinition
    COMPOSITION='Composition' # Composition
    CONCEPT_MAP='ConceptMap' # ConceptMap
    CONDITION='Condition' # Condition
    CONDITION_DEFINITION='ConditionDefinition' # ConditionDefinition
    CONSENT='Consent' # Consent
    CONTRACT='Contract' # Contract
    COVERAGE='Coverage' # Coverage
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequest
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponse
    DETECTED_ISSUE='DetectedIssue' # DetectedIssue
    DEVICE='Device' # Device
    DEVICE_ASSOCIATION='DeviceAssociation' # DeviceAssociation
    DEVICE_DEFINITION='DeviceDefinition' # DeviceDefinition
    DEVICE_DISPENSE='DeviceDispense' # DeviceDispense
    DEVICE_METRIC='DeviceMetric' # DeviceMetric
    DEVICE_REQUEST='DeviceRequest' # DeviceRequest
    DEVICE_USAGE='DeviceUsage' # DeviceUsage
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReport
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReference
    DOMAIN_RESOURCE='DomainResource' # DomainResource
    ENCOUNTER='Encounter' # Encounter
    ENCOUNTER_HISTORY='EncounterHistory' # EncounterHistory
    ENDPOINT='Endpoint' # Endpoint
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequest
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponse
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare
    EVENT_DEFINITION='EventDefinition' # EventDefinition
    EVIDENCE='Evidence' # Evidence
    EVIDENCE_REPORT='EvidenceReport' # EvidenceReport
    EVIDENCE_VARIABLE='EvidenceVariable' # EvidenceVariable
    EXAMPLE_SCENARIO='ExampleScenario' # ExampleScenario
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefit
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistory
    FLAG='Flag' # Flag
    FORMULARY_ITEM='FormularyItem' # FormularyItem
    GENOMIC_STUDY='GenomicStudy' # GenomicStudy
    GOAL='Goal' # Goal
    GRAPH_DEFINITION='GraphDefinition' # GraphDefinition
    GROUP='Group' # Group
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponse
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareService
    IMAGING_SELECTION='ImagingSelection' # ImagingSelection
    IMAGING_STUDY='ImagingStudy' # ImagingStudy
    IMMUNIZATION='Immunization' # Immunization
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendation
    IMPLEMENTATION_GUIDE='ImplementationGuide' # ImplementationGuide
    INGREDIENT='Ingredient' # Ingredient
    INSURANCE_PLAN='InsurancePlan' # InsurancePlan
    INVENTORY_ITEM='InventoryItem' # InventoryItem
    INVENTORY_REPORT='InventoryReport' # InventoryReport
    INVOICE='Invoice' # Invoice
    LIBRARY='Library' # Library
    LINKAGE='Linkage' # Linkage
    LIST='List' # List
    LOCATION='Location' # Location
    MANUFACTURED_ITEM_DEFINITION='ManufacturedItemDefinition' # ManufacturedItemDefinition
    MEASURE='Measure' # Measure
    MEASURE_REPORT='MeasureReport' # MeasureReport
    MEDICATION='Medication' # Medication
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministration
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispense
    MEDICATION_KNOWLEDGE='MedicationKnowledge' # MedicationKnowledge
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequest
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatement
    MEDICINAL_PRODUCT_DEFINITION='MedicinalProductDefinition' # MedicinalProductDefinition
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinition
    MESSAGE_HEADER='MessageHeader' # MessageHeader
    METADATA_RESOURCE='MetadataResource' # MetadataResource
    MOLECULAR_SEQUENCE='MolecularSequence' # MolecularSequence
    NAMING_SYSTEM='NamingSystem' # NamingSystem
    NUTRITION_INTAKE='NutritionIntake' # NutritionIntake
    NUTRITION_ORDER='NutritionOrder' # NutritionOrder
    NUTRITION_PRODUCT='NutritionProduct' # NutritionProduct
    OBSERVATION='Observation' # Observation
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinition
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinition
    OPERATION_OUTCOME='OperationOutcome' # OperationOutcome
    ORGANIZATION='Organization' # Organization
    ORGANIZATION_AFFILIATION='OrganizationAffiliation' # OrganizationAffiliation
    PACKAGED_PRODUCT_DEFINITION='PackagedProductDefinition' # PackagedProductDefinition
    PARAMETERS='Parameters' # Parameters
    PATIENT='Patient' # Patient
    PAYMENT_NOTICE='PaymentNotice' # PaymentNotice
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliation
    PERMISSION='Permission' # Permission
    PERSON='Person' # Person
    PLAN_DEFINITION='PlanDefinition' # PlanDefinition
    PRACTITIONER='Practitioner' # Practitioner
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRole
    PROCEDURE='Procedure' # Procedure
    PROVENANCE='Provenance' # Provenance
    QUESTIONNAIRE='Questionnaire' # Questionnaire
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponse
    REGULATED_AUTHORIZATION='RegulatedAuthorization' # RegulatedAuthorization
    RELATED_PERSON='RelatedPerson' # RelatedPerson
    REQUEST_ORCHESTRATION='RequestOrchestration' # RequestOrchestration
    REQUIREMENTS='Requirements' # Requirements
    RESEARCH_STUDY='ResearchStudy' # ResearchStudy
    RESEARCH_SUBJECT='ResearchSubject' # ResearchSubject
    RESOURCE='Resource' # Resource
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessment
    SCHEDULE='Schedule' # Schedule
    SEARCH_PARAMETER='SearchParameter' # SearchParameter
    SERVICE_REQUEST='ServiceRequest' # ServiceRequest
    SLOT='Slot' # Slot
    SPECIMEN='Specimen' # Specimen
    SPECIMEN_DEFINITION='SpecimenDefinition' # SpecimenDefinition
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinition
    STRUCTURE_MAP='StructureMap' # StructureMap
    SUBSCRIPTION='Subscription' # Subscription
    SUBSCRIPTION_STATUS='SubscriptionStatus' # SubscriptionStatus
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    SUBSTANCE='Substance' # Substance
    SUBSTANCE_DEFINITION='SubstanceDefinition' # SubstanceDefinition
    SUBSTANCE_NUCLEIC_ACID='SubstanceNucleicAcid' # SubstanceNucleicAcid
    SUBSTANCE_POLYMER='SubstancePolymer' # SubstancePolymer
    SUBSTANCE_PROTEIN='SubstanceProtein' # SubstanceProtein
    SUBSTANCE_REFERENCE_INFORMATION='SubstanceReferenceInformation' # SubstanceReferenceInformation
    SUBSTANCE_SOURCE_MATERIAL='SubstanceSourceMaterial' # SubstanceSourceMaterial
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDelivery
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequest
    TASK='Task' # Task
    TERMINOLOGY_CAPABILITIES='TerminologyCapabilities' # TerminologyCapabilities
    TEST_PLAN='TestPlan' # TestPlan
    TEST_REPORT='TestReport' # TestReport
    TEST_SCRIPT='TestScript' # TestScript
    TRANSPORT='Transport' # Transport
    VALUE_SET='ValueSet' # ValueSet
    VERIFICATION_RESULT='VerificationResult' # VerificationResult
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescription


class AllergyIntoleranceCategoryEnum(str, Enum):
    FOOD='food' # Food
    MEDICATION='medication' # Medication
    ENVIRONMENT='environment' # Environment
    BIOLOGIC='biologic' # Biologic


class AllergyIntoleranceCriticalityEnum(str, Enum):
    LOW='low' # Low Risk
    HIGH='high' # High Risk
    UNABLETOASSESS='unable-to-assess' # Unable to Assess Risk


class AllergyIntoleranceSeverityEnum(str, Enum):
    MILD='mild' # Mild
    MODERATE='moderate' # Moderate
    SEVERE='severe' # Severe


class AppointmentResponseStatusEnum(str, Enum):
    ACCEPTED='accepted' # Accepted
    DECLINED='declined' # Declined
    TENTATIVE='tentative' # Tentative
    NEEDSACTION='needs-action' # Needs Action
    ENTEREDINERROR='entered-in-error' # Entered in error


class AppointmentStatusEnum(str, Enum):
    PROPOSED='proposed' # Proposed
    PENDING='pending' # Pending
    BOOKED='booked' # Booked
    ARRIVED='arrived' # Arrived
    FULFILLED='fulfilled' # Fulfilled
    CANCELLED='cancelled' # Cancelled
    NOSHOW='noshow' # No Show
    ENTEREDINERROR='entered-in-error' # Entered in error
    CHECKEDIN='checked-in' # Checked In
    WAITLIST='waitlist' # Waitlisted


class ArtifactAssessmentDispositionEnum(str, Enum):
    UNRESOLVED='unresolved' # Unresolved
    NOTPERSUASIVE='not-persuasive' # Not Persuasive
    PERSUASIVE='persuasive' # Persuasive
    PERSUASIVEWITHMODIFICATION='persuasive-with-modification' # Persuasive with Modification
    NOTPERSUASIVEWITHMODIFICATION='not-persuasive-with-modification' # Not Persuasive with Modification


class ArtifactAssessmentInformationTypeEnum(str, Enum):
    COMMENT='comment' # Comment
    CLASSIFIER='classifier' # Classifier
    RATING='rating' # Rating
    CONTAINER='container' # Container
    RESPONSE='response' # Response
    CHANGEREQUEST='change-request' # Change Request


class ArtifactAssessmentWorkflowStatusEnum(str, Enum):
    SUBMITTED='submitted' # Submitted
    TRIAGED='triaged' # Triaged
    WAITINGFORINPUT='waiting-for-input' # Waiting for Input
    RESOLVEDNOCHANGE='resolved-no-change' # Resolved - No Change
    RESOLVEDCHANGEREQUIRED='resolved-change-required' # Resolved - Change Required
    DEFERRED='deferred' # Deferred
    DUPLICATE='duplicate' # Duplicate
    APPLIED='applied' # Applied
    PUBLISHED='published' # Published
    ENTEREDINERROR='entered-in-error' # Entered in Error


class AssertionDirectionTypeEnum(str, Enum):
    RESPONSE='response' # response
    REQUEST='request' # request


class AssertionManualCompletionTypeEnum(str, Enum):
    FAIL='fail' # Fail
    PASS='pass' # Pass
    SKIP='skip' # Skip
    STOP='stop' # Stop


class AssertionOperatorTypeEnum(str, Enum):
    EQUALS='equals' # equals
    NOT_EQUALS='notEquals' # notEquals
    IN='in' # in
    NOT_IN='notIn' # notIn
    GREATER_THAN='greaterThan' # greaterThan
    LESS_THAN='lessThan' # lessThan
    EMPTY='empty' # empty
    NOT_EMPTY='notEmpty' # notEmpty
    CONTAINS='contains' # contains
    NOT_CONTAINS='notContains' # notContains
    EVAL='eval' # evaluate
    MANUAL_EVAL='manualEval' # manualEvaluate


class AssertionResponseTypesEnum(str, Enum):
    CONTINUE='continue' # Continue
    SWITCHING_PROTOCOLS='switchingProtocols' # Switching Protocols
    OKAY='okay' # OK
    CREATED='created' # Created
    ACCEPTED='accepted' # Accepted
    NON_AUTHORITATIVE_INFORMATION='nonAuthoritativeInformation' # Non-Authoritative Information
    NO_CONTENT='noContent' # No Content
    RESET_CONTENT='resetContent' # Reset Content
    PARTIAL_CONTENT='partialContent' # Partial Content
    MULTIPLE_CHOICES='multipleChoices' # Multiple Choices
    MOVED_PERMANENTLY='movedPermanently' # Moved Permanently
    FOUND='found' # Found
    SEE_OTHER='seeOther' # See Other
    NOT_MODIFIED='notModified' # Not Modified
    USE_PROXY='useProxy' # Use Proxy
    TEMPORARY_REDIRECT='temporaryRedirect' # Temporary Redirect
    PERMANENT_REDIRECT='permanentRedirect' # Permanent Redirect
    BAD_REQUEST='badRequest' # Bad Request
    UNAUTHORIZED='unauthorized' # Unauthorized
    PAYMENT_REQUIRED='paymentRequired' # Payment Required
    FORBIDDEN='forbidden' # Forbidden
    NOT_FOUND='notFound' # Not Found
    METHOD_NOT_ALLOWED='methodNotAllowed' # Method Not Allowed
    NOT_ACCEPTABLE='notAcceptable' # Not Acceptable
    PROXY_AUTHENTICATION_REQUIRED='proxyAuthenticationRequired' # Proxy Authentication Required
    REQUEST_TIMEOUT='requestTimeout' # Request Timeout
    CONFLICT='conflict' # Conflict
    GONE='gone' # Gone
    LENGTH_REQUIRED='lengthRequired' # Length Required
    PRECONDITION_FAILED='preconditionFailed' # Precondition Failed
    CONTENT_TOO_LARGE='contentTooLarge' # Content Too Large
    URI_TOO_LONG='uriTooLong' # URI Too Long
    UNSUPPORTED_MEDIA_TYPE='unsupportedMediaType' # Unsupported Media Type
    RANGE_NOT_SATISFIABLE='rangeNotSatisfiable' # Range Not Satisfiable
    EXPECTATION_FAILED='expectationFailed' # Expectation Failed
    MISDIRECTED_REQUEST='misdirectedRequest' # Misdirected Request
    UNPROCESSABLE_CONTENT='unprocessableContent' # Unprocessable Content
    UPGRADE_REQUIRED='upgradeRequired' # Upgrade Required
    INTERNAL_SERVER_ERROR='internalServerError' # Internal Server Error
    NOT_IMPLEMENTED='notImplemented' # Not Implemented
    BAD_GATEWAY='badGateway' # Bad Gateway
    SERVICE_UNAVAILABLE='serviceUnavailable' # Service Unavailable
    GATEWAY_TIMEOUT='gatewayTimeout' # Gateway Timeout
    HTTP_VERSION_NOT_SUPPORTED='httpVersionNotSupported' # HTTP Version Not Supported


class AuditEventActionEnum(str, Enum):
    C='C' # Create
    R='R' # Read
    U='U' # Update
    D='D' # Delete
    E='E' # Execute


class AuditEventSeverityEnum(str, Enum):
    EMERGENCY='emergency' # Emergency
    ALERT='alert' # Alert
    CRITICAL='critical' # Critical
    ERROR='error' # Error
    WARNING='warning' # Warning
    NOTICE='notice' # Notice
    INFORMATIONAL='informational' # Informational
    DEBUG='debug' # Debug


class BindingStrengthEnum(str, Enum):
    REQUIRED='required' # Required
    EXTENSIBLE='extensible' # Extensible
    PREFERRED='preferred' # Preferred
    EXAMPLE='example' # Example


class BiologicallyDerivedProductDispenseCodesEnum(str, Enum):
    PREPARATION='preparation' # Preparation
    INPROGRESS='in-progress' # In Progress
    ALLOCATED='allocated' # Allocated
    ISSUED='issued' # Issued
    UNFULFILLED='unfulfilled' # Unfulfilled
    RETURNED='returned' # Returned
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class BundleTypeEnum(str, Enum):
    DOCUMENT='document' # Document
    MESSAGE='message' # Message
    TRANSACTION='transaction' # Transaction
    TRANSACTIONRESPONSE='transaction-response' # Transaction Response
    BATCH='batch' # Batch
    BATCHRESPONSE='batch-response' # Batch Response
    HISTORY='history' # History List
    SEARCHSET='searchset' # Search Results
    COLLECTION='collection' # Collection
    SUBSCRIPTIONNOTIFICATION='subscription-notification' # Subscription Notification


class CapabilityStatementKindEnum(str, Enum):
    INSTANCE='instance' # Instance
    CAPABILITY='capability' # Capability
    REQUIREMENTS='requirements' # Requirements


class CarePlanIntentEnum(str, Enum):
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    ORDER='order' # Order
    OPTION='option' # Option
    DIRECTIVE='directive' # Directive


class CareTeamStatusEnum(str, Enum):
    PROPOSED='proposed' # Proposed
    ACTIVE='active' # Active
    SUSPENDED='suspended' # Suspended
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class CharacteristicCombinationEnum(str, Enum):
    ALLOF='all-of' # All of
    ANYOF='any-of' # Any of
    ATLEAST='at-least' # At least
    ATMOST='at-most' # At most
    STATISTICAL='statistical' # Statistical
    NETEFFECT='net-effect' # Net effect
    DATASET='dataset' # Dataset


class ChargeItemStatusEnum(str, Enum):
    PLANNED='planned' # Planned
    BILLABLE='billable' # Billable
    NOTBILLABLE='not-billable' # Not billable
    ABORTED='aborted' # Aborted
    BILLED='billed' # Billed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class ClaimProcessingCodesEnum(str, Enum):
    QUEUED='queued' # Queued
    COMPLETE='complete' # Processing Complete
    ERROR='error' # Error
    PARTIAL='partial' # Partial Processing


class ClinicalUseDefinitionTypeEnum(str, Enum):
    INDICATION='indication' # Indication
    CONTRAINDICATION='contraindication' # Contraindication
    INTERACTION='interaction' # Interaction
    UNDESIRABLEEFFECT='undesirable-effect' # Undesirable Effect
    WARNING='warning' # Warning


class CodeSearchSupportEnum(str, Enum):
    INCOMPOSE='in-compose' # In Compose
    INEXPANSION='in-expansion' # In Expansion
    INCOMPOSEOREXPANSION='in-compose-or-expansion' # In Compose Or Expansion


class CodeSystemContentModeEnum(str, Enum):
    NOTPRESENT='not-present' # Not Present
    EXAMPLE='example' # Example
    FRAGMENT='fragment' # Fragment
    COMPLETE='complete' # Complete
    SUPPLEMENT='supplement' # Supplement


class CodeSystemHierarchyMeaningEnum(str, Enum):
    GROUPEDBY='grouped-by' # Grouped By
    ISA='is-a' # Is-A
    PARTOF='part-of' # Part Of
    CLASSIFIEDWITH='classified-with' # Classified With


class CommonLanguagesEnum(str, Enum):
    AR='ar' # Arabisk
    BG='bg' # Bulgarian
    BGBG='bg-BG' # Bulgarian (Bulgaria)
    BN='bn' # Bengali
    CS='cs' # Czech
    CSCZ='cs-CZ' # Czech (Czechia)
    BS='bs' # Bosnian
    BSBA='bs-BA' # Bosnian (Bosnia and Herzegovina))
    DA='da' # Danish
    DADK='da-DK' # Danish (Denmark)
    DE='de' # German
    DEAT='de-AT' # German (Austria)
    DECH='de-CH' # German (Switzerland)
    DEDE='de-DE' # German (Germany)
    EL='el' # Greek
    ELGR='el-GR' # Greek (Greece)
    EN='en' # English
    ENAU='en-AU' # English (Australia)
    ENCA='en-CA' # English (Canada)
    ENGB='en-GB' # English (Great Britain)
    ENIN='en-IN' # English (India)
    ENNZ='en-NZ' # English (New Zealand)
    ENSG='en-SG' # English (Singapore)
    ENUS='en-US' # English (United States)
    ES='es' # Spanish
    ESAR='es-AR' # Spanish (Argentina)
    ESES='es-ES' # Spanish (Spain)
    ESUY='es-UY' # Spanish (Uruguay)
    ET='et' # Estonian
    ETEE='et-EE' # Estonian (Estonia)
    FI='fi' # Finnish
    FR='fr' # French
    FRBE='fr-BE' # French (Belgium)
    FRCH='fr-CH' # French (Switzerland)
    FRFR='fr-FR' # French (France)
    FIFI='fi-FI' # Finnish (Finland)
    FRCA='fr-CA' # French (Canada)
    FY='fy' # Frisian
    FYNL='fy-NL' # Frisian (Netherlands)
    HI='hi' # Hindi
    HR='hr' # Croatian
    HRHR='hr-HR' # Croatian (Croatia)
    IS='is' # Icelandic
    ISIS='is-IS' # Icelandic (Iceland)
    IT='it' # Italian
    ITCH='it-CH' # Italian (Switzerland)
    ITIT='it-IT' # Italian (Italy)
    JA='ja' # Japanese
    KO='ko' # Korean
    LT='lt' # Lithuanian
    LTLT='lt-LT' # Lithuanian (Lithuania)
    LV='lv' # Latvian
    LVLV='lv-LV' # Latvian (Latvia)
    NL='nl' # Dutch
    NLBE='nl-BE' # Dutch (Belgium)
    NLNL='nl-NL' # Dutch (Netherlands)
    NO='no' # Norwegian
    NONO='no-NO' # Norwegian (Norway)
    PA='pa' # Punjabi
    PL='pl' # Polskie
    PLPL='pl-PL' # Polish (Poland)
    PT='pt' # Portuguese
    PTPT='pt-PT' # Portuguese (Portugal)
    PTBR='pt-BR' # Portuguese (Brazil)
    RO='ro' # Romanian
    RORO='ro-RO' # Romanian (Romania)
    RU='ru' # Russian
    RURU='ru-RU' # Russian (Russia)
    SK='sk' # Slovakian
    SKSK='sk-SK' # Slovakian (Slovakia)
    SL='sl' # Slovenian
    SLSI='sl-SI' # Slovenian (Slovenia)
    SR='sr' # Serbian
    SRRS='sr-RS' # Serbian (Serbia)
    SV='sv' # Swedish
    SVSE='sv-SE' # Swedish (Sweden)
    TE='te' # Telugu
    ZH='zh' # Chinese
    ZHCN='zh-CN' # Chinese (China)
    ZHHK='zh-HK' # Chinese (Hong Kong)
    ZHSG='zh-SG' # Chinese (Singapore)
    ZHTW='zh-TW' # Chinese (Taiwan)


class CompartmentTypeEnum(str, Enum):
    PATIENT='Patient' # Patient
    ENCOUNTER='Encounter' # Encounter
    RELATED_PERSON='RelatedPerson' # RelatedPerson
    PRACTITIONER='Practitioner' # Practitioner
    DEVICE='Device' # Device
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare


class CompositionStatusEnum(str, Enum):
    REGISTERED='registered' # Registered
    PARTIAL='partial' # Partial
    PRELIMINARY='preliminary' # Preliminary
    FINAL='final' # Final
    AMENDED='amended' # Amended
    CORRECTED='corrected' # Corrected
    APPENDED='appended' # Appended
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    DEPRECATED='deprecated' # Deprecated
    UNKNOWN='unknown' # Unknown


class ConceptMapAttributeTypeEnum(str, Enum):
    CODE='code' # code
    CODING='Coding' # Coding
    STRING='string' # string
    BOOLEAN='boolean' # boolean
    QUANTITY='Quantity' # Quantity


class ConceptMapGroupUnmappedModeEnum(str, Enum):
    USESOURCECODE='use-source-code' # Use Provided Source Code
    FIXED='fixed' # Fixed Code
    OTHERMAP='other-map' # Other Map


class ConceptMapPropertyTypeEnum(str, Enum):
    CODING='Coding' # Coding (external reference)
    STRING='string' # string
    INTEGER='integer' # integer
    BOOLEAN='boolean' # boolean
    DATE_TIME='dateTime' # dateTime
    DECIMAL='decimal' # decimal
    CODE='code' # code


class ConceptMapRelationshipEnum(str, Enum):
    RELATEDTO='related-to' # Related To
    EQUIVALENT='equivalent' # Equivalent
    SOURCEISNARROWERTHANTARGET='source-is-narrower-than-target' # Source Is Narrower Than Target
    SOURCEISBROADERTHANTARGET='source-is-broader-than-target' # Source Is Broader Than Target
    NOTRELATEDTO='not-related-to' # Not Related To


class ConcreteFHIRTypesEnum(str, Enum):
    ACCOUNT='Account' # Account
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinition
    ACTOR_DEFINITION='ActorDefinition' # ActorDefinition
    ADDRESS='Address' # Address
    ADMINISTRABLE_PRODUCT_DEFINITION='AdministrableProductDefinition' # AdministrableProductDefinition
    ADVERSE_EVENT='AdverseEvent' # AdverseEvent
    AGE='Age' # Age
    ALLERGY_INTOLERANCE='AllergyIntolerance' # AllergyIntolerance
    ANNOTATION='Annotation' # Annotation
    APPOINTMENT='Appointment' # Appointment
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponse
    ARTIFACT_ASSESSMENT='ArtifactAssessment' # ArtifactAssessment
    ATTACHMENT='Attachment' # Attachment
    AUDIT_EVENT='AuditEvent' # AuditEvent
    AVAILABILITY='Availability' # Availability
    BASE_64_BINARY='base64Binary' # base64Binary
    BASIC='Basic' # Basic
    BINARY='Binary' # Binary
    BIOLOGICALLY_DERIVED_PRODUCT='BiologicallyDerivedProduct' # BiologicallyDerivedProduct
    BIOLOGICALLY_DERIVED_PRODUCT_DISPENSE='BiologicallyDerivedProductDispense' # BiologicallyDerivedProductDispense
    BODY_STRUCTURE='BodyStructure' # BodyStructure
    BOOLEAN='boolean' # boolean
    BUNDLE='Bundle' # Bundle
    CANONICAL='canonical' # canonical
    CAPABILITY_STATEMENT='CapabilityStatement' # CapabilityStatement
    CARE_PLAN='CarePlan' # CarePlan
    CARE_TEAM='CareTeam' # CareTeam
    CHARGE_ITEM='ChargeItem' # ChargeItem
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CITATION='Citation' # Citation
    CLAIM='Claim' # Claim
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponse
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpression
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    CODE='code' # code
    CODEABLE_CONCEPT='CodeableConcept' # CodeableConcept
    CODEABLE_REFERENCE='CodeableReference' # CodeableReference
    CODE_SYSTEM='CodeSystem' # CodeSystem
    CODING='Coding' # Coding
    COMMUNICATION='Communication' # Communication
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequest
    COMPARTMENT_DEFINITION='CompartmentDefinition' # CompartmentDefinition
    COMPOSITION='Composition' # Composition
    CONCEPT_MAP='ConceptMap' # ConceptMap
    CONDITION='Condition' # Condition
    CONDITION_DEFINITION='ConditionDefinition' # ConditionDefinition
    CONSENT='Consent' # Consent
    CONTACT_DETAIL='ContactDetail' # ContactDetail
    CONTACT_POINT='ContactPoint' # ContactPoint
    CONTRACT='Contract' # Contract
    CONTRIBUTOR='Contributor' # Contributor
    COUNT='Count' # Count
    COVERAGE='Coverage' # Coverage
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequest
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponse
    DATA_REQUIREMENT='DataRequirement' # DataRequirement
    DATE='date' # date
    DATE_TIME='dateTime' # dateTime
    DECIMAL='decimal' # decimal
    DETECTED_ISSUE='DetectedIssue' # DetectedIssue
    DEVICE='Device' # Device
    DEVICE_ASSOCIATION='DeviceAssociation' # DeviceAssociation
    DEVICE_DEFINITION='DeviceDefinition' # DeviceDefinition
    DEVICE_DISPENSE='DeviceDispense' # DeviceDispense
    DEVICE_METRIC='DeviceMetric' # DeviceMetric
    DEVICE_REQUEST='DeviceRequest' # DeviceRequest
    DEVICE_USAGE='DeviceUsage' # DeviceUsage
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReport
    DISTANCE='Distance' # Distance
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReference
    DOSAGE='Dosage' # Dosage
    DURATION='Duration' # Duration
    ELEMENT_DEFINITION='ElementDefinition' # ElementDefinition
    ENCOUNTER='Encounter' # Encounter
    ENCOUNTER_HISTORY='EncounterHistory' # EncounterHistory
    ENDPOINT='Endpoint' # Endpoint
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequest
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponse
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare
    EVENT_DEFINITION='EventDefinition' # EventDefinition
    EVIDENCE='Evidence' # Evidence
    EVIDENCE_REPORT='EvidenceReport' # EvidenceReport
    EVIDENCE_VARIABLE='EvidenceVariable' # EvidenceVariable
    EXAMPLE_SCENARIO='ExampleScenario' # ExampleScenario
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefit
    EXPRESSION='Expression' # Expression
    EXTENDED_CONTACT_DETAIL='ExtendedContactDetail' # ExtendedContactDetail
    EXTENSION='Extension' # Extension
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistory
    FLAG='Flag' # Flag
    FORMULARY_ITEM='FormularyItem' # FormularyItem
    GENOMIC_STUDY='GenomicStudy' # GenomicStudy
    GOAL='Goal' # Goal
    GRAPH_DEFINITION='GraphDefinition' # GraphDefinition
    GROUP='Group' # Group
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponse
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareService
    HUMAN_NAME='HumanName' # HumanName
    ID='id' # id
    IDENTIFIER='Identifier' # Identifier
    IMAGING_SELECTION='ImagingSelection' # ImagingSelection
    IMAGING_STUDY='ImagingStudy' # ImagingStudy
    IMMUNIZATION='Immunization' # Immunization
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendation
    IMPLEMENTATION_GUIDE='ImplementationGuide' # ImplementationGuide
    INGREDIENT='Ingredient' # Ingredient
    INSTANT='instant' # instant
    INSURANCE_PLAN='InsurancePlan' # InsurancePlan
    INTEGER='integer' # integer
    INTEGER_64='integer64' # integer64
    INVENTORY_ITEM='InventoryItem' # InventoryItem
    INVENTORY_REPORT='InventoryReport' # InventoryReport
    INVOICE='Invoice' # Invoice
    LIBRARY='Library' # Library
    LINKAGE='Linkage' # Linkage
    LIST='List' # List
    LOCATION='Location' # Location
    MANUFACTURED_ITEM_DEFINITION='ManufacturedItemDefinition' # ManufacturedItemDefinition
    MARKDOWN='markdown' # markdown
    MARKETING_STATUS='MarketingStatus' # MarketingStatus
    MEASURE='Measure' # Measure
    MEASURE_REPORT='MeasureReport' # MeasureReport
    MEDICATION='Medication' # Medication
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministration
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispense
    MEDICATION_KNOWLEDGE='MedicationKnowledge' # MedicationKnowledge
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequest
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatement
    MEDICINAL_PRODUCT_DEFINITION='MedicinalProductDefinition' # MedicinalProductDefinition
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinition
    MESSAGE_HEADER='MessageHeader' # MessageHeader
    META='Meta' # Meta
    MOLECULAR_SEQUENCE='MolecularSequence' # MolecularSequence
    MONETARY_COMPONENT='MonetaryComponent' # MonetaryComponent
    MONEY='Money' # Money
    NAMING_SYSTEM='NamingSystem' # NamingSystem
    NARRATIVE='Narrative' # Narrative
    NUTRITION_INTAKE='NutritionIntake' # NutritionIntake
    NUTRITION_ORDER='NutritionOrder' # NutritionOrder
    NUTRITION_PRODUCT='NutritionProduct' # NutritionProduct
    OBSERVATION='Observation' # Observation
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinition
    OID='oid' # oid
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinition
    OPERATION_OUTCOME='OperationOutcome' # OperationOutcome
    ORGANIZATION='Organization' # Organization
    ORGANIZATION_AFFILIATION='OrganizationAffiliation' # OrganizationAffiliation
    PACKAGED_PRODUCT_DEFINITION='PackagedProductDefinition' # PackagedProductDefinition
    PARAMETER_DEFINITION='ParameterDefinition' # ParameterDefinition
    PARAMETERS='Parameters' # Parameters
    PATIENT='Patient' # Patient
    PAYMENT_NOTICE='PaymentNotice' # PaymentNotice
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliation
    PERIOD='Period' # Period
    PERMISSION='Permission' # Permission
    PERSON='Person' # Person
    PLAN_DEFINITION='PlanDefinition' # PlanDefinition
    POSITIVE_INT='positiveInt' # positiveInt
    PRACTITIONER='Practitioner' # Practitioner
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRole
    PROCEDURE='Procedure' # Procedure
    PRODUCT_SHELF_LIFE='ProductShelfLife' # ProductShelfLife
    PROVENANCE='Provenance' # Provenance
    QUANTITY='Quantity' # Quantity
    QUESTIONNAIRE='Questionnaire' # Questionnaire
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponse
    RANGE='Range' # Range
    RATIO='Ratio' # Ratio
    RATIO_RANGE='RatioRange' # RatioRange
    REFERENCE='Reference' # Reference
    REGULATED_AUTHORIZATION='RegulatedAuthorization' # RegulatedAuthorization
    RELATED_ARTIFACT='RelatedArtifact' # RelatedArtifact
    RELATED_PERSON='RelatedPerson' # RelatedPerson
    REQUEST_ORCHESTRATION='RequestOrchestration' # RequestOrchestration
    REQUIREMENTS='Requirements' # Requirements
    RESEARCH_STUDY='ResearchStudy' # ResearchStudy
    RESEARCH_SUBJECT='ResearchSubject' # ResearchSubject
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessment
    SAMPLED_DATA='SampledData' # SampledData
    SCHEDULE='Schedule' # Schedule
    SEARCH_PARAMETER='SearchParameter' # SearchParameter
    SERVICE_REQUEST='ServiceRequest' # ServiceRequest
    SIGNATURE='Signature' # Signature
    SLOT='Slot' # Slot
    SPECIMEN='Specimen' # Specimen
    SPECIMEN_DEFINITION='SpecimenDefinition' # SpecimenDefinition
    STRING='string' # string
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinition
    STRUCTURE_MAP='StructureMap' # StructureMap
    SUBSCRIPTION='Subscription' # Subscription
    SUBSCRIPTION_STATUS='SubscriptionStatus' # SubscriptionStatus
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    SUBSTANCE='Substance' # Substance
    SUBSTANCE_DEFINITION='SubstanceDefinition' # SubstanceDefinition
    SUBSTANCE_NUCLEIC_ACID='SubstanceNucleicAcid' # SubstanceNucleicAcid
    SUBSTANCE_POLYMER='SubstancePolymer' # SubstancePolymer
    SUBSTANCE_PROTEIN='SubstanceProtein' # SubstanceProtein
    SUBSTANCE_REFERENCE_INFORMATION='SubstanceReferenceInformation' # SubstanceReferenceInformation
    SUBSTANCE_SOURCE_MATERIAL='SubstanceSourceMaterial' # SubstanceSourceMaterial
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDelivery
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequest
    TASK='Task' # Task
    TERMINOLOGY_CAPABILITIES='TerminologyCapabilities' # TerminologyCapabilities
    TEST_PLAN='TestPlan' # TestPlan
    TEST_REPORT='TestReport' # TestReport
    TEST_SCRIPT='TestScript' # TestScript
    TIME='time' # time
    TIMING='Timing' # Timing
    TRANSPORT='Transport' # Transport
    TRIGGER_DEFINITION='TriggerDefinition' # TriggerDefinition
    UNSIGNED_INT='unsignedInt' # unsignedInt
    URI='uri' # uri
    URL='url' # url
    USAGE_CONTEXT='UsageContext' # UsageContext
    UUID='uuid' # uuid
    VALUE_SET='ValueSet' # ValueSet
    VERIFICATION_RESULT='VerificationResult' # VerificationResult
    VIRTUAL_SERVICE_DETAIL='VirtualServiceDetail' # VirtualServiceDetail
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescription
    XHTML='xhtml' # xhtml


class ConditionPreconditionTypeEnum(str, Enum):
    SENSITIVE='sensitive' # Sensitive
    SPECIFIC='specific' # Specific


class ConditionQuestionnairePurposeEnum(str, Enum):
    PREADMIT='preadmit' # Pre-admit
    DIFFDIAGNOSIS='diff-diagnosis' # Diff Diagnosis
    OUTCOME='outcome' # Outcome


class ConditionalDeleteStatusEnum(str, Enum):
    NOTSUPPORTED='not-supported' # Not Supported
    SINGLE='single' # Single Deletes Supported
    MULTIPLE='multiple' # Multiple Deletes Supported


class ConditionalReadStatusEnum(str, Enum):
    NOTSUPPORTED='not-supported' # Not Supported
    MODIFIEDSINCE='modified-since' # If-Modified-Since
    NOTMATCH='not-match' # If-None-Match
    FULLSUPPORT='full-support' # Full Support


class ConformanceExpectationEnum(str, Enum):
    SHALL='SHALL' # SHALL
    SHOULD='SHOULD' # SHOULD
    MAY='MAY' # MAY
    SHOULDNOT='SHOULD-NOT' # SHOULD-NOT


class ConsentDataMeaningEnum(str, Enum):
    INSTANCE='instance' # Instance
    RELATED='related' # Related
    DEPENDENTS='dependents' # Dependents
    AUTHOREDBY='authoredby' # AuthoredBy


class ConsentProvisionTypeEnum(str, Enum):
    DENY='deny' # Deny
    PERMIT='permit' # Permit


class ConsentStateEnum(str, Enum):
    DRAFT='draft' # Pending
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    NOTDONE='not-done' # Abandoned
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class ConstraintSeverityEnum(str, Enum):
    ERROR='error' # Error
    WARNING='warning' # Warning


class ContactPointSystemEnum(str, Enum):
    PHONE='phone' # Phone
    FAX='fax' # Fax
    EMAIL='email' # Email
    PAGER='pager' # Pager
    URL='url' # URL
    SMS='sms' # SMS
    OTHER='other' # Other


class ContactPointUseEnum(str, Enum):
    HOME='home' # Home
    WORK='work' # Work
    TEMP='temp' # Temp
    OLD='old' # Old
    MOBILE='mobile' # Mobile


class ContractResourcePublicationStatusCodesEnum(str, Enum):
    AMENDED='amended' # Amended
    APPENDED='appended' # Appended
    CANCELLED='cancelled' # Cancelled
    DISPUTED='disputed' # Disputed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    EXECUTABLE='executable' # Executable
    EXECUTED='executed' # Executed
    NEGOTIABLE='negotiable' # Negotiable
    OFFERED='offered' # Offered
    POLICY='policy' # Policy
    REJECTED='rejected' # Rejected
    RENEWED='renewed' # Renewed
    REVOKED='revoked' # Revoked
    RESOLVED='resolved' # Resolved
    TERMINATED='terminated' # Terminated


class ContractResourceStatusCodesEnum(str, Enum):
    AMENDED='amended' # Amended
    APPENDED='appended' # Appended
    CANCELLED='cancelled' # Cancelled
    DISPUTED='disputed' # Disputed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    EXECUTABLE='executable' # Executable
    EXECUTED='executed' # Executed
    NEGOTIABLE='negotiable' # Negotiable
    OFFERED='offered' # Offered
    POLICY='policy' # Policy
    REJECTED='rejected' # Rejected
    RENEWED='renewed' # Renewed
    REVOKED='revoked' # Revoked
    RESOLVED='resolved' # Resolved
    TERMINATED='terminated' # Terminated


class ContributorTypeEnum(str, Enum):
    AUTHOR='author' # Author
    EDITOR='editor' # Editor
    REVIEWER='reviewer' # Reviewer
    ENDORSER='endorser' # Endorser


class CriteriaNotExistsBehaviorEnum(str, Enum):
    TESTPASSES='test-passes' # Test passes
    TESTFAILS='test-fails' # Test fails


class DefinitionResourceTypesEnum(str, Enum):
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinition
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    EVENT_DEFINITION='EventDefinition' # EventDefinition
    MEASURE='Measure' # Measure
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinition
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinition
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinition
    PLAN_DEFINITION='PlanDefinition' # PlanDefinition
    QUESTIONNAIRE='Questionnaire' # Questionnaire
    REQUIREMENTS='Requirements' # Requirements
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    TEST_PLAN='TestPlan' # TestPlan
    TEST_SCRIPT='TestScript' # TestScript


class DetectedIssueSeverityEnum(str, Enum):
    HIGH='high' # High
    MODERATE='moderate' # Moderate
    LOW='low' # Low


class DetectedIssueStatusEnum(str, Enum):
    PRELIMINARY='preliminary' # Preliminary
    FINAL='final' # Final
    ENTEREDINERROR='entered-in-error' # Entered in Error
    MITIGATED='mitigated' # Mitigated


class DeviceCorrectiveActionScopeEnum(str, Enum):
    MODEL='model' # Model
    LOTNUMBERS='lot-numbers' # Lot Numbers
    SERIALNUMBERS='serial-numbers' # Serial Numbers


class DeviceDefinitionRegulatoryIdentifierTypeEnum(str, Enum):
    BASIC='basic' # Basic
    MASTER='master' # Master
    LICENSE='license' # License


class DeviceDispenseStatusCodesEnum(str, Enum):
    PREPARATION='preparation' # Preparation
    INPROGRESS='in-progress' # In Progress
    CANCELLED='cancelled' # Cancelled
    ONHOLD='on-hold' # On Hold
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    STOPPED='stopped' # Stopped
    DECLINED='declined' # Declined
    UNKNOWN='unknown' # Unknown


class DeviceMetricCalibrationStateEnum(str, Enum):
    NOTCALIBRATED='not-calibrated' # Not Calibrated
    CALIBRATIONREQUIRED='calibration-required' # Calibration Required
    CALIBRATED='calibrated' # Calibrated
    UNSPECIFIED='unspecified' # Unspecified


class DeviceMetricCalibrationTypeEnum(str, Enum):
    UNSPECIFIED='unspecified' # Unspecified
    OFFSET='offset' # Offset
    GAIN='gain' # Gain
    TWOPOINT='two-point' # Two Point


class DeviceMetricCategoryEnum(str, Enum):
    MEASUREMENT='measurement' # Measurement
    SETTING='setting' # Setting
    CALCULATION='calculation' # Calculation
    UNSPECIFIED='unspecified' # Unspecified


class DeviceMetricOperationalStatusEnum(str, Enum):
    ON='on' # On
    OFF='off' # Off
    STANDBY='standby' # Standby
    ENTEREDINERROR='entered-in-error' # Entered In Error


class DeviceNameTypeEnum(str, Enum):
    REGISTEREDNAME='registered-name' # Registered name
    USERFRIENDLYNAME='user-friendly-name' # User Friendly name
    PATIENTREPORTEDNAME='patient-reported-name' # Patient Reported name


class DeviceProductionIdentifierInUDIEnum(str, Enum):
    LOTNUMBER='lot-number' # Lot Number
    MANUFACTUREDDATE='manufactured-date' # Manufactured date
    SERIALNUMBER='serial-number' # Serial Number
    EXPIRATIONDATE='expiration-date' # Expiration date
    BIOLOGICALSOURCE='biological-source' # Biological source
    SOFTWAREVERSION='software-version' # Software Version


class DeviceUsageStatusEnum(str, Enum):
    ACTIVE='active' # Active
    COMPLETED='completed' # Completed
    NOTDONE='not-done' # Not done
    ENTEREDINERROR='entered-in-error' # Entered in Error
    INTENDED='intended' # Intended
    STOPPED='stopped' # Stopped
    ONHOLD='on-hold' # On Hold


class DiagnosticReportStatusEnum(str, Enum):
    REGISTERED='registered' # Registered
    PARTIAL='partial' # Partial
    PRELIMINARY='preliminary' # Preliminary
    MODIFIED='modified' # Modified
    FINAL='final' # Final
    AMENDED='amended' # Amended
    CORRECTED='corrected' # Corrected
    APPENDED='appended' # Appended
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class DiscriminatorTypeEnum(str, Enum):
    VALUE='value' # Value
    EXISTS='exists' # Exists
    PATTERN='pattern' # Pattern
    TYPE='type' # Type
    PROFILE='profile' # Profile
    POSITION='position' # Position


class DocumentModeEnum(str, Enum):
    PRODUCER='producer' # Producer
    CONSUMER='consumer' # Consumer


class DocumentReferenceStatusEnum(str, Enum):
    CURRENT='current' # Current
    SUPERSEDED='superseded' # Superseded
    ENTEREDINERROR='entered-in-error' # Entered in Error


class EligibilityOutcomeEnum(str, Enum):
    QUEUED='queued' # Queued
    COMPLETE='complete' # Processing Complete
    ERROR='error' # Error
    PARTIAL='partial' # Partial Processing


class EligibilityRequestPurposeEnum(str, Enum):
    AUTHREQUIREMENTS='auth-requirements' # Coverage auth-requirements
    BENEFITS='benefits' # Coverage benefits
    DISCOVERY='discovery' # Coverage Discovery
    VALIDATION='validation' # Coverage Validation


class EligibilityResponsePurposeEnum(str, Enum):
    AUTHREQUIREMENTS='auth-requirements' # Coverage auth-requirements
    BENEFITS='benefits' # Coverage benefits
    DISCOVERY='discovery' # Coverage Discovery
    VALIDATION='validation' # Coverage Validation


class EnableWhenBehaviorEnum(str, Enum):
    ALL='all' # All
    ANY='any' # Any


class EncounterLocationStatusEnum(str, Enum):
    PLANNED='planned' # Planned
    ACTIVE='active' # Active
    RESERVED='reserved' # Reserved
    COMPLETED='completed' # Completed


class EncounterStatusEnum(str, Enum):
    PLANNED='planned' # Planned
    INPROGRESS='in-progress' # In Progress
    ONHOLD='on-hold' # On Hold
    DISCHARGED='discharged' # Discharged
    COMPLETED='completed' # Completed
    CANCELLED='cancelled' # Cancelled
    DISCONTINUED='discontinued' # Discontinued
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class EndpointStatusEnum(str, Enum):
    ACTIVE='active' # Active
    SUSPENDED='suspended' # Suspended
    ERROR='error' # Error
    OFF='off' # Off
    ENTEREDINERROR='entered-in-error' # Entered in error


class EnrollmentOutcomeEnum(str, Enum):
    QUEUED='queued' # Queued
    COMPLETE='complete' # Processing Complete
    ERROR='error' # Error
    PARTIAL='partial' # Partial Processing


class EpisodeOfCareStatusEnum(str, Enum):
    PLANNED='planned' # Planned
    WAITLIST='waitlist' # Waitlist
    ACTIVE='active' # Active
    ONHOLD='onhold' # On Hold
    FINISHED='finished' # Finished
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error


class EventCapabilityModeEnum(str, Enum):
    SENDER='sender' # Sender
    RECEIVER='receiver' # Receiver


class EventResourceTypesEnum(str, Enum):
    ADVERSE_EVENT='AdverseEvent' # AdverseEvent
    AUDIT_EVENT='AuditEvent' # AuditEvent
    CHARGE_ITEM='ChargeItem' # ChargeItem
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponse
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpression
    COMMUNICATION='Communication' # Communication
    COMPOSITION='Composition' # Composition
    CONSENT='Consent' # Consent
    CONTRACT='Contract' # Contract
    COVERAGE='Coverage' # Coverage
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponse
    DETECTED_ISSUE='DetectedIssue' # DetectedIssue
    DEVICE_DISPENSE='DeviceDispense' # DeviceDispense
    DEVICE_USAGE='DeviceUsage' # DeviceUsage
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReport
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReference
    ENCOUNTER='Encounter' # Encounter
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponse
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefit
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistory
    GENOMIC_STUDY='GenomicStudy' # GenomicStudy
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponse
    IMAGING_SELECTION='ImagingSelection' # ImagingSelection
    IMAGING_STUDY='ImagingStudy' # ImagingStudy
    IMMUNIZATION='Immunization' # Immunization
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    INVENTORY_REPORT='InventoryReport' # InventoryReport
    INVOICE='Invoice' # Invoice
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministration
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispense
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatement
    MESSAGE_HEADER='MessageHeader' # MessageHeader
    NUTRITION_INTAKE='NutritionIntake' # NutritionIntake
    OBSERVATION='Observation' # Observation
    PAYMENT_NOTICE='PaymentNotice' # PaymentNotice
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliation
    PROCEDURE='Procedure' # Procedure
    PROVENANCE='Provenance' # Provenance
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponse
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessment
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDelivery
    TRANSPORT='Transport' # Transport


class EventStatusEnum(str, Enum):
    PREPARATION='preparation' # Preparation
    INPROGRESS='in-progress' # In Progress
    NOTDONE='not-done' # Not Done
    ONHOLD='on-hold' # On Hold
    STOPPED='stopped' # Stopped
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class EventTimingEnum(str, Enum):
    MORN='MORN' # Morning
    MORNEARLY='MORN.early' # Early Morning
    MORNLATE='MORN.late' # Late Morning
    NOON='NOON' # Noon
    AFT='AFT' # Afternoon
    AFTEARLY='AFT.early' # Early Afternoon
    AFTLATE='AFT.late' # Late Afternoon
    EVE='EVE' # Evening
    EVEEARLY='EVE.early' # Early Evening
    EVELATE='EVE.late' # Late Evening
    NIGHT='NIGHT' # Night
    PHS='PHS' # After Sleep
    IMD='IMD' # Immediate
    HS='HS' # HS
    WAKE='WAKE' # WAKE
    C='C' # C
    CM='CM' # CM
    CD='CD' # CD
    CV='CV' # CV
    AC='AC' # AC
    ACM='ACM' # ACM
    ACD='ACD' # ACD
    ACV='ACV' # ACV
    PC='PC' # PC
    PCM='PCM' # PCM
    PCD='PCD' # PCD
    PCV='PCV' # PCV


class EvidenceVariableHandlingEnum(str, Enum):
    CONTINUOUS='continuous' # continuous variable
    DICHOTOMOUS='dichotomous' # dichotomous variable
    ORDINAL='ordinal' # ordinal variable
    POLYCHOTOMOUS='polychotomous' # polychotomous variable


class ExampleScenarioActorTypeEnum(str, Enum):
    PERSON='person' # Person
    SYSTEM='system' # System


class ExplanationOfBenefitStatusEnum(str, Enum):
    ACTIVE='active' # Active
    CANCELLED='cancelled' # Cancelled
    DRAFT='draft' # Draft
    ENTEREDINERROR='entered-in-error' # Entered In Error


class ExtensionContextTypeEnum(str, Enum):
    FHIRPATH='fhirpath' # FHIRPath
    ELEMENT='element' # Element ID
    EXTENSION='extension' # Extension URL


class FHIRDeviceStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class FHIRPathTypesEnum(str, Enum):
    HTTPHL_7ORGFHIRPATH_SYSTEM_STRING='http://hl7.org/fhirpath/System.String' # String
    HTTPHL_7ORGFHIRPATH_SYSTEM_BOOLEAN='http://hl7.org/fhirpath/System.Boolean' # Boolean
    HTTPHL_7ORGFHIRPATH_SYSTEM_DATE='http://hl7.org/fhirpath/System.Date' # Date
    HTTPHL_7ORGFHIRPATH_SYSTEM_DATE_TIME='http://hl7.org/fhirpath/System.DateTime' # DateTime
    HTTPHL_7ORGFHIRPATH_SYSTEM_DECIMAL='http://hl7.org/fhirpath/System.Decimal' # Decimal
    HTTPHL_7ORGFHIRPATH_SYSTEM_INTEGER='http://hl7.org/fhirpath/System.Integer' # Integer
    HTTPHL_7ORGFHIRPATH_SYSTEM_TIME='http://hl7.org/fhirpath/System.Time' # Time


class FHIRSubstanceStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class FHIRTypesEnum(str, Enum):
    BASE='Base' # Base
    ELEMENT='Element' # Element
    BACKBONE_ELEMENT='BackboneElement' # BackboneElement
    DATA_TYPE='DataType' # DataType
    ADDRESS='Address' # Address
    ANNOTATION='Annotation' # Annotation
    ATTACHMENT='Attachment' # Attachment
    AVAILABILITY='Availability' # Availability
    BACKBONE_TYPE='BackboneType' # BackboneType
    DOSAGE='Dosage' # Dosage
    ELEMENT_DEFINITION='ElementDefinition' # ElementDefinition
    MARKETING_STATUS='MarketingStatus' # MarketingStatus
    PRODUCT_SHELF_LIFE='ProductShelfLife' # ProductShelfLife
    TIMING='Timing' # Timing
    CODEABLE_CONCEPT='CodeableConcept' # CodeableConcept
    CODEABLE_REFERENCE='CodeableReference' # CodeableReference
    CODING='Coding' # Coding
    CONTACT_DETAIL='ContactDetail' # ContactDetail
    CONTACT_POINT='ContactPoint' # ContactPoint
    CONTRIBUTOR='Contributor' # Contributor
    DATA_REQUIREMENT='DataRequirement' # DataRequirement
    EXPRESSION='Expression' # Expression
    EXTENDED_CONTACT_DETAIL='ExtendedContactDetail' # ExtendedContactDetail
    EXTENSION='Extension' # Extension
    HUMAN_NAME='HumanName' # HumanName
    IDENTIFIER='Identifier' # Identifier
    META='Meta' # Meta
    MONETARY_COMPONENT='MonetaryComponent' # MonetaryComponent
    MONEY='Money' # Money
    NARRATIVE='Narrative' # Narrative
    PARAMETER_DEFINITION='ParameterDefinition' # ParameterDefinition
    PERIOD='Period' # Period
    PRIMITIVE_TYPE='PrimitiveType' # PrimitiveType
    BASE_64_BINARY='base64Binary' # base64Binary
    BOOLEAN='boolean' # boolean
    DATE='date' # date
    DATE_TIME='dateTime' # dateTime
    DECIMAL='decimal' # decimal
    INSTANT='instant' # instant
    INTEGER='integer' # integer
    POSITIVE_INT='positiveInt' # positiveInt
    UNSIGNED_INT='unsignedInt' # unsignedInt
    INTEGER_64='integer64' # integer64
    STRING='string' # string
    CODE='code' # code
    ID='id' # id
    MARKDOWN='markdown' # markdown
    TIME='time' # time
    URI='uri' # uri
    CANONICAL='canonical' # canonical
    OID='oid' # oid
    URL='url' # url
    UUID='uuid' # uuid
    QUANTITY='Quantity' # Quantity
    AGE='Age' # Age
    COUNT='Count' # Count
    DISTANCE='Distance' # Distance
    DURATION='Duration' # Duration
    RANGE='Range' # Range
    RATIO='Ratio' # Ratio
    RATIO_RANGE='RatioRange' # RatioRange
    REFERENCE='Reference' # Reference
    RELATED_ARTIFACT='RelatedArtifact' # RelatedArtifact
    SAMPLED_DATA='SampledData' # SampledData
    SIGNATURE='Signature' # Signature
    TRIGGER_DEFINITION='TriggerDefinition' # TriggerDefinition
    USAGE_CONTEXT='UsageContext' # UsageContext
    VIRTUAL_SERVICE_DETAIL='VirtualServiceDetail' # VirtualServiceDetail
    XHTML='xhtml' # xhtml
    RESOURCE='Resource' # Resource
    BINARY='Binary' # Binary
    BUNDLE='Bundle' # Bundle
    DOMAIN_RESOURCE='DomainResource' # DomainResource
    ACCOUNT='Account' # Account
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinition
    ACTOR_DEFINITION='ActorDefinition' # ActorDefinition
    ADMINISTRABLE_PRODUCT_DEFINITION='AdministrableProductDefinition' # AdministrableProductDefinition
    ADVERSE_EVENT='AdverseEvent' # AdverseEvent
    ALLERGY_INTOLERANCE='AllergyIntolerance' # AllergyIntolerance
    APPOINTMENT='Appointment' # Appointment
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponse
    ARTIFACT_ASSESSMENT='ArtifactAssessment' # ArtifactAssessment
    AUDIT_EVENT='AuditEvent' # AuditEvent
    BASIC='Basic' # Basic
    BIOLOGICALLY_DERIVED_PRODUCT='BiologicallyDerivedProduct' # BiologicallyDerivedProduct
    BIOLOGICALLY_DERIVED_PRODUCT_DISPENSE='BiologicallyDerivedProductDispense' # BiologicallyDerivedProductDispense
    BODY_STRUCTURE='BodyStructure' # BodyStructure
    CANONICAL_RESOURCE='CanonicalResource' # CanonicalResource
    CAPABILITY_STATEMENT='CapabilityStatement' # CapabilityStatement
    CARE_PLAN='CarePlan' # CarePlan
    CARE_TEAM='CareTeam' # CareTeam
    CHARGE_ITEM='ChargeItem' # ChargeItem
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CITATION='Citation' # Citation
    CLAIM='Claim' # Claim
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponse
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpression
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    CODE_SYSTEM='CodeSystem' # CodeSystem
    COMMUNICATION='Communication' # Communication
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequest
    COMPARTMENT_DEFINITION='CompartmentDefinition' # CompartmentDefinition
    COMPOSITION='Composition' # Composition
    CONCEPT_MAP='ConceptMap' # ConceptMap
    CONDITION='Condition' # Condition
    CONDITION_DEFINITION='ConditionDefinition' # ConditionDefinition
    CONSENT='Consent' # Consent
    CONTRACT='Contract' # Contract
    COVERAGE='Coverage' # Coverage
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequest
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponse
    DETECTED_ISSUE='DetectedIssue' # DetectedIssue
    DEVICE='Device' # Device
    DEVICE_ASSOCIATION='DeviceAssociation' # DeviceAssociation
    DEVICE_DEFINITION='DeviceDefinition' # DeviceDefinition
    DEVICE_DISPENSE='DeviceDispense' # DeviceDispense
    DEVICE_METRIC='DeviceMetric' # DeviceMetric
    DEVICE_REQUEST='DeviceRequest' # DeviceRequest
    DEVICE_USAGE='DeviceUsage' # DeviceUsage
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReport
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReference
    ENCOUNTER='Encounter' # Encounter
    ENCOUNTER_HISTORY='EncounterHistory' # EncounterHistory
    ENDPOINT='Endpoint' # Endpoint
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequest
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponse
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare
    EVENT_DEFINITION='EventDefinition' # EventDefinition
    EVIDENCE='Evidence' # Evidence
    EVIDENCE_REPORT='EvidenceReport' # EvidenceReport
    EVIDENCE_VARIABLE='EvidenceVariable' # EvidenceVariable
    EXAMPLE_SCENARIO='ExampleScenario' # ExampleScenario
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefit
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistory
    FLAG='Flag' # Flag
    FORMULARY_ITEM='FormularyItem' # FormularyItem
    GENOMIC_STUDY='GenomicStudy' # GenomicStudy
    GOAL='Goal' # Goal
    GRAPH_DEFINITION='GraphDefinition' # GraphDefinition
    GROUP='Group' # Group
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponse
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareService
    IMAGING_SELECTION='ImagingSelection' # ImagingSelection
    IMAGING_STUDY='ImagingStudy' # ImagingStudy
    IMMUNIZATION='Immunization' # Immunization
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendation
    IMPLEMENTATION_GUIDE='ImplementationGuide' # ImplementationGuide
    INGREDIENT='Ingredient' # Ingredient
    INSURANCE_PLAN='InsurancePlan' # InsurancePlan
    INVENTORY_ITEM='InventoryItem' # InventoryItem
    INVENTORY_REPORT='InventoryReport' # InventoryReport
    INVOICE='Invoice' # Invoice
    LIBRARY='Library' # Library
    LINKAGE='Linkage' # Linkage
    LIST='List' # List
    LOCATION='Location' # Location
    MANUFACTURED_ITEM_DEFINITION='ManufacturedItemDefinition' # ManufacturedItemDefinition
    MEASURE='Measure' # Measure
    MEASURE_REPORT='MeasureReport' # MeasureReport
    MEDICATION='Medication' # Medication
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministration
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispense
    MEDICATION_KNOWLEDGE='MedicationKnowledge' # MedicationKnowledge
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequest
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatement
    MEDICINAL_PRODUCT_DEFINITION='MedicinalProductDefinition' # MedicinalProductDefinition
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinition
    MESSAGE_HEADER='MessageHeader' # MessageHeader
    METADATA_RESOURCE='MetadataResource' # MetadataResource
    MOLECULAR_SEQUENCE='MolecularSequence' # MolecularSequence
    NAMING_SYSTEM='NamingSystem' # NamingSystem
    NUTRITION_INTAKE='NutritionIntake' # NutritionIntake
    NUTRITION_ORDER='NutritionOrder' # NutritionOrder
    NUTRITION_PRODUCT='NutritionProduct' # NutritionProduct
    OBSERVATION='Observation' # Observation
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinition
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinition
    OPERATION_OUTCOME='OperationOutcome' # OperationOutcome
    ORGANIZATION='Organization' # Organization
    ORGANIZATION_AFFILIATION='OrganizationAffiliation' # OrganizationAffiliation
    PACKAGED_PRODUCT_DEFINITION='PackagedProductDefinition' # PackagedProductDefinition
    PATIENT='Patient' # Patient
    PAYMENT_NOTICE='PaymentNotice' # PaymentNotice
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliation
    PERMISSION='Permission' # Permission
    PERSON='Person' # Person
    PLAN_DEFINITION='PlanDefinition' # PlanDefinition
    PRACTITIONER='Practitioner' # Practitioner
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRole
    PROCEDURE='Procedure' # Procedure
    PROVENANCE='Provenance' # Provenance
    QUESTIONNAIRE='Questionnaire' # Questionnaire
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponse
    REGULATED_AUTHORIZATION='RegulatedAuthorization' # RegulatedAuthorization
    RELATED_PERSON='RelatedPerson' # RelatedPerson
    REQUEST_ORCHESTRATION='RequestOrchestration' # RequestOrchestration
    REQUIREMENTS='Requirements' # Requirements
    RESEARCH_STUDY='ResearchStudy' # ResearchStudy
    RESEARCH_SUBJECT='ResearchSubject' # ResearchSubject
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessment
    SCHEDULE='Schedule' # Schedule
    SEARCH_PARAMETER='SearchParameter' # SearchParameter
    SERVICE_REQUEST='ServiceRequest' # ServiceRequest
    SLOT='Slot' # Slot
    SPECIMEN='Specimen' # Specimen
    SPECIMEN_DEFINITION='SpecimenDefinition' # SpecimenDefinition
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinition
    STRUCTURE_MAP='StructureMap' # StructureMap
    SUBSCRIPTION='Subscription' # Subscription
    SUBSCRIPTION_STATUS='SubscriptionStatus' # SubscriptionStatus
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    SUBSTANCE='Substance' # Substance
    SUBSTANCE_DEFINITION='SubstanceDefinition' # SubstanceDefinition
    SUBSTANCE_NUCLEIC_ACID='SubstanceNucleicAcid' # SubstanceNucleicAcid
    SUBSTANCE_POLYMER='SubstancePolymer' # SubstancePolymer
    SUBSTANCE_PROTEIN='SubstanceProtein' # SubstanceProtein
    SUBSTANCE_REFERENCE_INFORMATION='SubstanceReferenceInformation' # SubstanceReferenceInformation
    SUBSTANCE_SOURCE_MATERIAL='SubstanceSourceMaterial' # SubstanceSourceMaterial
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDelivery
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequest
    TASK='Task' # Task
    TERMINOLOGY_CAPABILITIES='TerminologyCapabilities' # TerminologyCapabilities
    TEST_PLAN='TestPlan' # TestPlan
    TEST_REPORT='TestReport' # TestReport
    TEST_SCRIPT='TestScript' # TestScript
    TRANSPORT='Transport' # Transport
    VALUE_SET='ValueSet' # ValueSet
    VERIFICATION_RESULT='VerificationResult' # VerificationResult
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescription
    PARAMETERS='Parameters' # Parameters


class FHIRVersionEnum(str, Enum):
    _0_01='0.01' # 0.01
    _0_05='0.05' # 0.05
    _0_06='0.06' # 0.06
    _0_11='0.11' # 0.11
    _0_0='0.0' # 0.0
    _0_0_80='0.0.80' # 0.0.80
    _0_0_81='0.0.81' # 0.0.81
    _0_0_82='0.0.82' # 0.0.82
    _0_4='0.4' # 0.4
    _0_4_0='0.4.0' # 0.4.0
    _0_5='0.5' # 0.5
    _0_5_0='0.5.0' # 0.5.0
    _1_0='1.0' # 1.0
    _1_0_0='1.0.0' # 1.0.0
    _1_0_1='1.0.1' # 1.0.1
    _1_0_2='1.0.2' # 1.0.2
    _1_1='1.1' # 1.1
    _1_1_0='1.1.0' # 1.1.0
    _1_4='1.4' # 1.4
    _1_4_0='1.4.0' # 1.4.0
    _1_6='1.6' # 1.6
    _1_6_0='1.6.0' # 1.6.0
    _1_8='1.8' # 1.8
    _1_8_0='1.8.0' # 1.8.0
    _3_0='3.0' # 3.0
    _3_0_0='3.0.0' # 3.0.0
    _3_0_1='3.0.1' # 3.0.1
    _3_0_2='3.0.2' # 3.0.2
    _3_3='3.3' # 3.3
    _3_3_0='3.3.0' # 3.3.0
    _3_5='3.5' # 3.5
    _3_5_0='3.5.0' # 3.5.0
    _4_0='4.0' # 4.0
    _4_0_0='4.0.0' # 4.0.0
    _4_0_1='4.0.1' # 4.0.1
    _4_1='4.1' # 4.1
    _4_1_0='4.1.0' # 4.1.0
    _4_2='4.2' # 4.2
    _4_2_0='4.2.0' # 4.2.0
    _4_3='4.3' # 4.3
    _4_3_0='4.3.0' # 4.3.0
    _4_3_0CIBUILD='4.3.0-cibuild' # 4.3.0-cibuild
    _4_3_0SNAPSHOT_1='4.3.0-snapshot1' # 4.3.0-snapshot1
    _4_4='4.4' # 4.4
    _4_4_0='4.4.0' # 4.4.0
    _4_5='4.5' # 4.5
    _4_5_0='4.5.0' # 4.5.0
    _4_6='4.6' # 4.6
    _4_6_0='4.6.0' # 4.6.0
    _5_0='5.0' # 5.0
    _5_0_0='5.0.0' # 5.0.0
    _5_0_0CIBUILD='5.0.0-cibuild' # 5.0.0-cibuild
    _5_0_0SNAPSHOT_1='5.0.0-snapshot1' # 5.0.0-snapshot1
    _5_0_0SNAPSHOT_2='5.0.0-snapshot2' # 5.0.0-snapshot2
    _5_0_0BALLOT='5.0.0-ballot' # 5.0.0-ballot
    _5_0_0SNAPSHOT_3='5.0.0-snapshot3' # 5.0.0-snapshot3
    _5_0_0DRAFTFINAL='5.0.0-draft-final' # 5.0.0-draft-final


class FamilyHistoryStatusEnum(str, Enum):
    PARTIAL='partial' # Partial
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    HEALTHUNKNOWN='health-unknown' # Health Unknown


class FilterOperatorEnum(str, Enum):
    _='=' # Equals
    ISA='is-a' # Is A (by subsumption)
    DESCENDENTOF='descendent-of' # Descendent Of (by subsumption)
    ISNOTA='is-not-a' # Not (Is A) (by subsumption)
    REGEX='regex' # Regular Expression
    IN='in' # In Set
    NOTIN='not-in' # Not in Set
    GENERALIZES='generalizes' # Generalizes (by Subsumption)
    CHILDOF='child-of' # Child Of
    DESCENDENTLEAF='descendent-leaf' # Descendent Leaf
    EXISTS='exists' # Exists


class FinancialResourceStatusCodesEnum(str, Enum):
    ACTIVE='active' # Active
    CANCELLED='cancelled' # Cancelled
    DRAFT='draft' # Draft
    ENTEREDINERROR='entered-in-error' # Entered in Error


class FlagStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class FormularyItemStatusCodesEnum(str, Enum):
    ACTIVE='active' # Active
    ENTEREDINERROR='entered-in-error' # Entered in Error
    INACTIVE='inactive' # Inactive


class GenomicStudyStatusEnum(str, Enum):
    REGISTERED='registered' # Registered
    AVAILABLE='available' # Available
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class GoalLifecycleStatusEnum(str, Enum):
    PROPOSED='proposed' # Proposed
    PLANNED='planned' # Planned
    ACCEPTED='accepted' # Accepted
    ACTIVE='active' # Active
    ONHOLD='on-hold' # On Hold
    COMPLETED='completed' # Completed
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    REJECTED='rejected' # Rejected


class GraphCompartmentRuleEnum(str, Enum):
    IDENTICAL='identical' # Identical
    MATCHING='matching' # Matching
    DIFFERENT='different' # Different
    CUSTOM='custom' # Custom


class GraphCompartmentUseEnum(str, Enum):
    WHERE='where' # Where
    REQUIRES='requires' # requires


class GroupMembershipBasisEnum(str, Enum):
    DEFINITIONAL='definitional' # Definitional
    ENUMERATED='enumerated' # Enumerated


class GroupTypeEnum(str, Enum):
    PERSON='person' # Person
    ANIMAL='animal' # Animal
    PRACTITIONER='practitioner' # Practitioner
    DEVICE='device' # Device
    CARETEAM='careteam' # CareTeam
    HEALTHCARESERVICE='healthcareservice' # HealthcareService
    LOCATION='location' # Location
    ORGANIZATION='organization' # Organization
    RELATEDPERSON='relatedperson' # RelatedPerson
    SPECIMEN='specimen' # Specimen


class GuidanceResponseStatusEnum(str, Enum):
    SUCCESS='success' # Success
    DATAREQUESTED='data-requested' # Data Requested
    DATAREQUIRED='data-required' # Data Required
    INPROGRESS='in-progress' # In Progress
    FAILURE='failure' # Failure
    ENTEREDINERROR='entered-in-error' # Entered In Error


class GuidePageGenerationEnum(str, Enum):
    HTML='html' # HTML
    MARKDOWN='markdown' # Markdown
    XML='xml' # XML
    GENERATED='generated' # Generated


class HTTPVerbEnum(str, Enum):
    GET='GET' # GET
    HEAD='HEAD' # HEAD
    POST='POST' # POST
    PUT='PUT' # PUT
    DELETE='DELETE' # DELETE
    PATCH='PATCH' # PATCH


class IdentifierUseEnum(str, Enum):
    USUAL='usual' # Usual
    OFFICIAL='official' # Official
    TEMP='temp' # Temp
    SECONDARY='secondary' # Secondary
    OLD='old' # Old


class IdentityAssuranceLevelEnum(str, Enum):
    LEVEL_1='level1' # Level 1
    LEVEL_2='level2' # Level 2
    LEVEL_3='level3' # Level 3
    LEVEL_4='level4' # Level 4


class ImagingSelectionDGraphicTypeEnum(str, Enum):
    POINT='point' # POINT
    MULTIPOINT='multipoint' # MULTIPOINT
    POLYLINE='polyline' # POLYLINE
    POLYGON='polygon' # POLYGON
    ELLIPSE='ellipse' # ELLIPSE
    ELLIPSOID='ellipsoid' # ELLIPSOID


class ImagingSelectionStatusEnum(str, Enum):
    AVAILABLE='available' # Available
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class ImagingStudyStatusEnum(str, Enum):
    REGISTERED='registered' # Registered
    AVAILABLE='available' # Available
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class ImmunizationEvaluationStatusCodesEnum(str, Enum):
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error


class ImmunizationStatusCodesEnum(str, Enum):
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    NOTDONE='not-done' # Not Done


class IngredientManufacturerRoleEnum(str, Enum):
    ALLOWED='allowed' # Manufacturer is specifically allowed for this ingredient
    POSSIBLE='possible' # Manufacturer is known to make this ingredient in general
    ACTUAL='actual' # Manufacturer actually makes this particular ingredient


class InteractionTriggerEnum(str, Enum):
    CREATE='create' # create
    UPDATE='update' # update
    DELETE='delete' # delete


class InventoryCountTypeEnum(str, Enum):
    SNAPSHOT='snapshot' # Snapshot
    DIFFERENCE='difference' # Difference


class InventoryItemStatusCodesEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class InventoryReportStatusEnum(str, Enum):
    DRAFT='draft' # Draft
    REQUESTED='requested' # Requested
    ACTIVE='active' # Active
    ENTEREDINERROR='entered-in-error' # Entered in Error


class InvoiceStatusEnum(str, Enum):
    DRAFT='draft' # draft
    ISSUED='issued' # issued
    BALANCED='balanced' # balanced
    CANCELLED='cancelled' # cancelled
    ENTEREDINERROR='entered-in-error' # entered in error


class IssueSeverityEnum(str, Enum):
    FATAL='fatal' # Fatal
    ERROR='error' # Error
    WARNING='warning' # Warning
    INFORMATION='information' # Information
    SUCCESS='success' # Operation Successful


class IssueTypeEnum(str, Enum):
    INVALID='invalid' # Invalid Content
    STRUCTURE='structure' # Structural Issue
    REQUIRED='required' # Required element missing
    VALUE='value' # Element value invalid
    INVARIANT='invariant' # Validation rule failed
    SECURITY='security' # Security Problem
    LOGIN='login' # Login Required
    UNKNOWN='unknown' # Unknown User
    EXPIRED='expired' # Session Expired
    FORBIDDEN='forbidden' # Forbidden
    SUPPRESSED='suppressed' # Information Suppressed
    PROCESSING='processing' # Processing Failure
    NOTSUPPORTED='not-supported' # Content not supported
    DUPLICATE='duplicate' # Duplicate
    MULTIPLEMATCHES='multiple-matches' # Multiple Matches
    NOTFOUND='not-found' # Not Found
    DELETED='deleted' # Deleted
    TOOLONG='too-long' # Content Too Long
    CODEINVALID='code-invalid' # Invalid Code
    EXTENSION='extension' # Unacceptable Extension
    TOOCOSTLY='too-costly' # Operation Too Costly
    BUSINESSRULE='business-rule' # Business Rule Violation
    CONFLICT='conflict' # Edit Version Conflict
    LIMITEDFILTER='limited-filter' # Limited Filter Application
    TRANSIENT='transient' # Transient Issue
    LOCKERROR='lock-error' # Lock Error
    NOSTORE='no-store' # No Store Available
    EXCEPTION='exception' # Exception
    TIMEOUT='timeout' # Timeout
    INCOMPLETE='incomplete' # Incomplete Results
    THROTTLED='throttled' # Throttled
    INFORMATIONAL='informational' # Informational Note
    SUCCESS='success' # Operation Successful


class JurisdictionValueSetEnum(str, Enum):
    AD='AD' # Andorra
    AE='AE' # United Arab Emirates
    AF='AF' # Afghanistan
    AG='AG' # Antigua and Barbuda
    AI='AI' # Anguilla
    AL='AL' # Albania
    AM='AM' # Armenia
    AO='AO' # Angola
    AQ='AQ' # Antarctica
    AR='AR' # Argentina
    AS='AS' # American Samoa
    AT='AT' # Austria
    AU='AU' # Australia
    AW='AW' # Aruba
    AX='AX' # Eland Islands
    AZ='AZ' # Azerbaijan
    BA='BA' # Bosnia and Herzegovina
    BB='BB' # Barbados
    BD='BD' # Bangladesh
    BE='BE' # Belgium
    BF='BF' # Burkina Faso
    BG='BG' # Bulgaria
    BH='BH' # Bahrain
    BI='BI' # Burundi
    BJ='BJ' # Benin
    BL='BL' # Saint Barthilemy
    BM='BM' # Bermuda
    BN='BN' # Brunei Darussalam
    BO='BO' # Bolivia, Plurinational State of
    BQ='BQ' # Bonaire, Sint Eustatius and Saba
    BR='BR' # Brazil
    BS='BS' # Bahamas
    BT='BT' # Bhutan
    BV='BV' # Bouvet Island
    BW='BW' # Botswana
    BY='BY' # Belarus
    BZ='BZ' # Belize
    CA='CA' # Canada
    CC='CC' # Cocos (Keeling) Islands
    CD='CD' # Congo, the Democratic Republic of the
    CF='CF' # Central African Republic
    CG='CG' # Congo
    CH='CH' # Switzerland
    CI='CI' # Ctte d'Ivoire
    CK='CK' # Cook Islands
    CL='CL' # Chile
    CM='CM' # Cameroon
    CN='CN' # China
    CO='CO' # Colombia
    CR='CR' # Costa Rica
    CU='CU' # Cuba
    CV='CV' # Cabo Verde
    CW='CW' # Curagao
    CX='CX' # Christmas Island
    CY='CY' # Cyprus
    CZ='CZ' # Czechia
    DE='DE' # Germany
    DJ='DJ' # Djibouti
    DK='DK' # Denmark
    DM='DM' # Dominica
    DO='DO' # Dominican Republic
    DZ='DZ' # Algeria
    EC='EC' # Ecuador
    EE='EE' # Estonia
    EG='EG' # Egypt
    EH='EH' # Western Sahara
    ER='ER' # Eritrea
    ES='ES' # Spain
    ET='ET' # Ethiopia
    FI='FI' # Finland
    FJ='FJ' # Fiji
    FK='FK' # Falkland Islands (Malvinas)
    FM='FM' # Micronesia, Federated States of
    FO='FO' # Faroe Islands
    FR='FR' # France
    GA='GA' # Gabon
    GB='GB' # United Kingdom of Great Britain and Northern Ireland
    GD='GD' # Grenada
    GE='GE' # Georgia
    GF='GF' # French Guiana
    GG='GG' # Guernsey
    GH='GH' # Ghana
    GI='GI' # Gibraltar
    GL='GL' # Greenland
    GM='GM' # Gambia
    GN='GN' # Guinea
    GP='GP' # Guadeloupe
    GQ='GQ' # Equatorial Guinea
    GR='GR' # Greece
    GS='GS' # South Georgia and the South Sandwich Islands
    GT='GT' # Guatemala
    GU='GU' # Guam
    GW='GW' # Guinea-Bissau
    GY='GY' # Guyana
    HK='HK' # Hong Kong
    HM='HM' # Heard Island and McDonald Islands
    HN='HN' # Honduras
    HR='HR' # Croatia
    HT='HT' # Haiti
    HU='HU' # Hungary
    ID='ID' # Indonesia
    IE='IE' # Ireland
    IL='IL' # Israel
    IM='IM' # Isle of Man
    IN='IN' # India
    IO='IO' # British Indian Ocean Territory
    IQ='IQ' # Iraq
    IR='IR' # Iran, Islamic Republic of
    IS='IS' # Iceland
    IT='IT' # Italy
    JE='JE' # Jersey
    JM='JM' # Jamaica
    JO='JO' # Jordan
    JP='JP' # Japan
    KE='KE' # Kenya
    KG='KG' # Kyrgyzstan
    KH='KH' # Cambodia
    KI='KI' # Kiribati
    KM='KM' # Comoros
    KN='KN' # Saint Kitts and Nevis
    KP='KP' # Korea, Democratic People's Republic of
    KR='KR' # Korea, Republic of
    KW='KW' # Kuwait
    KY='KY' # Cayman Islands
    KZ='KZ' # Kazakhstan
    LA='LA' # Lao People's Democratic Republic
    LB='LB' # Lebanon
    LC='LC' # Saint Lucia
    LI='LI' # Liechtenstein
    LK='LK' # Sri Lanka
    LR='LR' # Liberia
    LS='LS' # Lesotho
    LT='LT' # Lithuania
    LU='LU' # Luxembourg
    LV='LV' # Latvia
    LY='LY' # Libya
    MA='MA' # Morocco
    MC='MC' # Monaco
    MD='MD' # Moldova, Republic of
    ME='ME' # Montenegro
    MF='MF' # Saint Martin (French part)
    MG='MG' # Madagascar
    MH='MH' # Marshall Islands
    MK='MK' # Macedonia, the former Yugoslav Republic of
    ML='ML' # Mali
    MM='MM' # Myanmar
    MN='MN' # Mongolia
    MO='MO' # Macao
    MP='MP' # Northern Mariana Islands
    MQ='MQ' # Martinique
    MR='MR' # Mauritania
    MS='MS' # Montserrat
    MT='MT' # Malta
    MU='MU' # Mauritius
    MV='MV' # Maldives
    MW='MW' # Malawi
    MX='MX' # Mexico
    MY='MY' # Malaysia
    MZ='MZ' # Mozambique
    NA='NA' # Namibia
    NC='NC' # New Caledonia
    NE='NE' # Niger
    NF='NF' # Norfolk Island
    NG='NG' # Nigeria
    NI='NI' # Nicaragua
    NL='NL' # Netherlands
    NO='NO' # Norway
    NP='NP' # Nepal
    NR='NR' # Nauru
    NU='NU' # Niue
    NZ='NZ' # New Zealand
    OM='OM' # Oman
    PA='PA' # Panama
    PE='PE' # Peru
    PF='PF' # French Polynesia
    PG='PG' # Papua New Guinea
    PH='PH' # Philippines
    PK='PK' # Pakistan
    PL='PL' # Poland
    PM='PM' # Saint Pierre and Miquelon
    PN='PN' # Pitcairn
    PR='PR' # Puerto Rico
    PS='PS' # Palestine, State of
    PT='PT' # Portugal
    PW='PW' # Palau
    PY='PY' # Paraguay
    QA='QA' # Qatar
    RE='RE' # Riunion
    RO='RO' # Romania
    RS='RS' # Serbia
    RU='RU' # Russian Federation
    RW='RW' # Rwanda
    SA='SA' # Saudi Arabia
    SB='SB' # Solomon Islands
    SC='SC' # Seychelles
    SD='SD' # Sudan
    SE='SE' # Sweden
    SG='SG' # Singapore
    SH='SH' # Saint Helena, Ascension and Tristan da Cunha
    SI='SI' # Slovenia
    SJ='SJ' # Svalbard and Jan Mayen
    SK='SK' # Slovakia
    SL='SL' # Sierra Leone
    SM='SM' # San Marino
    SN='SN' # Senegal
    SO='SO' # Somalia
    SR='SR' # Suriname
    SS='SS' # South Sudan
    ST='ST' # Sao Tome and Principe
    SV='SV' # El Salvador
    SX='SX' # Sint Maarten (Dutch part)
    SY='SY' # Syrian Arab Republic
    SZ='SZ' # Swaziland
    TC='TC' # Turks and Caicos Islands
    TD='TD' # Chad
    TF='TF' # French Southern Territories
    TG='TG' # Togo
    TH='TH' # Thailand
    TJ='TJ' # Tajikistan
    TK='TK' # Tokelau
    TL='TL' # Timor-Leste
    TM='TM' # Turkmenistan
    TN='TN' # Tunisia
    TO='TO' # Tonga
    TR='TR' # Turkey
    TT='TT' # Trinidad and Tobago
    TV='TV' # Tuvalu
    TW='TW' # Taiwan, Province of China
    TZ='TZ' # Tanzania, United Republic of
    UA='UA' # Ukraine
    UG='UG' # Uganda
    UM='UM' # United States Minor Outlying Islands
    US='US' # United States of America
    UY='UY' # Uruguay
    UZ='UZ' # Uzbekistan
    VA='VA' # Holy See
    VC='VC' # Saint Vincent and the Grenadines
    VE='VE' # Venezuela, Bolivarian Republic of
    VG='VG' # Virgin Islands, British
    VI='VI' # Virgin Islands,
    VN='VN' # Viet Nam
    VU='VU' # Vanuatu
    WF='WF' # Wallis and Futuna
    WS='WS' # Samoa
    YE='YE' # Yemen
    YT='YT' # Mayotte
    ZA='ZA' # South Africa
    ZM='ZM' # Zambia
    ZW='ZW' # Zimbabwe
    ABW='ABW' # Aruba
    AFG='AFG' # Afghanistan
    AGO='AGO' # Angola
    AIA='AIA' # Anguilla
    ALA='ALA' # Eland Islands
    ALB='ALB' # Albania
    AND='AND' # Andorra
    ARE='ARE' # United Arab Emirates
    ARG='ARG' # Argentina
    ARM='ARM' # Armenia
    ASM='ASM' # American Samoa
    ATA='ATA' # Antarctica
    ATF='ATF' # French Southern Territories
    ATG='ATG' # Antigua and Barbuda
    AUS='AUS' # Australia
    AUT='AUT' # Austria
    AZE='AZE' # Azerbaijan
    BDI='BDI' # Burundi
    BEL='BEL' # Belgium
    BEN='BEN' # Benin
    BES='BES' # Bonaire, Sint Eustatius and Saba
    BFA='BFA' # Burkina Faso
    BGD='BGD' # Bangladesh
    BGR='BGR' # Bulgaria
    BHR='BHR' # Bahrain
    BHS='BHS' # Bahamas
    BIH='BIH' # Bosnia and Herzegovina
    BLM='BLM' # Saint Barthilemy
    BLR='BLR' # Belarus
    BLZ='BLZ' # Belize
    BMU='BMU' # Bermuda
    BOL='BOL' # Bolivia, Plurinational State of
    BRA='BRA' # Brazil
    BRB='BRB' # Barbados
    BRN='BRN' # Brunei Darussalam
    BTN='BTN' # Bhutan
    BVT='BVT' # Bouvet Island
    BWA='BWA' # Botswana
    CAF='CAF' # Central African Republic
    CAN='CAN' # Canada
    CCK='CCK' # Cocos (Keeling) Islands
    CHE='CHE' # Switzerland
    CHL='CHL' # Chile
    CHN='CHN' # China
    CIV='CIV' # Ctte d'Ivoire
    CMR='CMR' # Cameroon
    COD='COD' # Congo, the Democratic Republic of the
    COG='COG' # Congo
    COK='COK' # Cook Islands
    COL='COL' # Colombia
    COM='COM' # Comoros
    CPV='CPV' # Cabo Verde
    CRI='CRI' # Costa Rica
    CUB='CUB' # Cuba
    CUW='CUW' # Curagao
    CXR='CXR' # Christmas Island
    CYM='CYM' # Cayman Islands
    CYP='CYP' # Cyprus
    CZE='CZE' # Czechia
    DEU='DEU' # Germany
    DJI='DJI' # Djibouti
    DMA='DMA' # Dominica
    DNK='DNK' # Denmark
    DOM='DOM' # Dominican Republic
    DZA='DZA' # Algeria
    ECU='ECU' # Ecuador
    EGY='EGY' # Egypt
    ERI='ERI' # Eritrea
    ESH='ESH' # Western Sahara
    ESP='ESP' # Spain
    EST='EST' # Estonia
    ETH='ETH' # Ethiopia
    FIN='FIN' # Finland
    FJI='FJI' # Fiji
    FLK='FLK' # Falkland Islands (Malvinas)
    FRA='FRA' # France
    FRO='FRO' # Faroe Islands
    FSM='FSM' # Micronesia, Federated States of
    GAB='GAB' # Gabon
    GBR='GBR' # United Kingdom
    GEO='GEO' # Georgia
    GGY='GGY' # Guernsey
    GHA='GHA' # Ghana
    GIB='GIB' # Gibraltar
    GIN='GIN' # Guinea
    GLP='GLP' # Guadeloupe
    GMB='GMB' # Gambia
    GNB='GNB' # Guinea-Bissau
    GNQ='GNQ' # Equatorial Guinea
    GRC='GRC' # Greece
    GRD='GRD' # Grenada
    GRL='GRL' # Greenland
    GTM='GTM' # Guatemala
    GUF='GUF' # French Guiana
    GUM='GUM' # Guam
    GUY='GUY' # Guyana
    HKG='HKG' # Hong Kong
    HMD='HMD' # Heard Island and McDonald Islands
    HND='HND' # Honduras
    HRV='HRV' # Croatia
    HTI='HTI' # Haiti
    HUN='HUN' # Hungary
    IDN='IDN' # Indonesia
    IMN='IMN' # Isle of Man
    IND='IND' # India
    IOT='IOT' # British Indian Ocean Territory
    IRL='IRL' # Ireland
    IRN='IRN' # Iran, Islamic Republic of
    IRQ='IRQ' # Iraq
    ISL='ISL' # Iceland
    ISR='ISR' # Israel
    ITA='ITA' # Italy
    JAM='JAM' # Jamaica
    JEY='JEY' # Jersey
    JOR='JOR' # Jordan
    JPN='JPN' # Japan
    KAZ='KAZ' # Kazakhstan
    KEN='KEN' # Kenya
    KGZ='KGZ' # Kyrgyzstan
    KHM='KHM' # Cambodia
    KIR='KIR' # Kiribati
    KNA='KNA' # Saint Kitts and Nevis
    KOR='KOR' # Korea, Republic of
    KWT='KWT' # Kuwait
    LAO='LAO' # Lao People's Democratic Republic
    LBN='LBN' # Lebanon
    LBR='LBR' # Liberia
    LBY='LBY' # Libya
    LCA='LCA' # Saint Lucia
    LIE='LIE' # Liechtenstein
    LKA='LKA' # Sri Lanka
    LSO='LSO' # Lesotho
    LTU='LTU' # Lithuania
    LUX='LUX' # Luxembourg
    LVA='LVA' # Latvia
    MAC='MAC' # Macao
    MAF='MAF' # Saint Martin (French part)
    MAR='MAR' # Morocco
    MCO='MCO' # Monaco
    MDA='MDA' # Moldova, Republic of
    MDG='MDG' # Madagascar
    MDV='MDV' # Maldives
    MEX='MEX' # Mexico
    MHL='MHL' # Marshall Islands
    MKD='MKD' # Macedonia, the former Yugoslav Republic of
    MLI='MLI' # Mali
    MLT='MLT' # Malta
    MMR='MMR' # Myanmar
    MNE='MNE' # Montenegro
    MNG='MNG' # Mongolia
    MNP='MNP' # Northern Mariana Islands
    MOZ='MOZ' # Mozambique
    MRT='MRT' # Mauritania
    MSR='MSR' # Montserrat
    MTQ='MTQ' # Martinique
    MUS='MUS' # Mauritius
    MWI='MWI' # Malawi
    MYS='MYS' # Malaysia
    MYT='MYT' # Mayotte
    NAM='NAM' # Namibia
    NCL='NCL' # New Caledonia
    NER='NER' # Niger
    NFK='NFK' # Norfolk Island
    NGA='NGA' # Nigeria
    NIC='NIC' # Nicaragua
    NIU='NIU' # Niue
    NLD='NLD' # Netherlands
    NOR='NOR' # Norway
    NPL='NPL' # Nepal
    NRU='NRU' # Nauru
    NZL='NZL' # New Zealand
    OMN='OMN' # Oman
    PAK='PAK' # Pakistan
    PAN='PAN' # Panama
    PCN='PCN' # Pitcairn
    PER='PER' # Peru
    PHL='PHL' # Philippines
    PLW='PLW' # Palau
    PNG='PNG' # Papua New Guinea
    POL='POL' # Poland
    PRI='PRI' # Puerto Rico
    PRK='PRK' # Korea, Democratic People's Republic of
    PRT='PRT' # Portugal
    PRY='PRY' # Paraguay
    PSE='PSE' # Palestine, State of
    PYF='PYF' # French Polynesia
    QAT='QAT' # Qatar
    REU='REU' # Riunion
    ROU='ROU' # Romania
    RUS='RUS' # Russian Federation
    RWA='RWA' # Rwanda
    SAU='SAU' # Saudi Arabia
    SDN='SDN' # Sudan
    SEN='SEN' # Senegal
    SGP='SGP' # Singapore
    SGS='SGS' # South Georgia and the South Sandwich Islands
    SHN='SHN' # Saint Helena, Ascension and Tristan da Cunha
    SJM='SJM' # Svalbard and Jan Mayen
    SLB='SLB' # Solomon Islands
    SLE='SLE' # Sierra Leone
    SLV='SLV' # El Salvador
    SMR='SMR' # San Marino
    SOM='SOM' # Somalia
    SPM='SPM' # Saint Pierre and Miquelon
    SRB='SRB' # Serbia
    SSD='SSD' # South Sudan
    STP='STP' # Sao Tome and Principe
    SUR='SUR' # Suriname
    SVK='SVK' # Slovakia
    SVN='SVN' # Slovenia
    SWE='SWE' # Sweden
    SWZ='SWZ' # Swaziland
    SXM='SXM' # Sint Maarten (Dutch part)
    SYC='SYC' # Seychelles
    SYR='SYR' # Syrian Arab Republic
    TCA='TCA' # Turks and Caicos Islands
    TCD='TCD' # Chad
    TGO='TGO' # Togo
    THA='THA' # Thailand
    TJK='TJK' # Tajikistan
    TKL='TKL' # Tokelau
    TKM='TKM' # Turkmenistan
    TLS='TLS' # Timor-Leste
    TON='TON' # Tonga
    TTO='TTO' # Trinidad and Tobago
    TUN='TUN' # Tunisia
    TUR='TUR' # Turkey
    TUV='TUV' # Tuvalu
    TWN='TWN' # Taiwan, Province of China
    TZA='TZA' # Tanzania, United Republic of
    UGA='UGA' # Uganda
    UKR='UKR' # Ukraine
    UMI='UMI' # United States Minor Outlying Islands
    URY='URY' # Uruguay
    USA='USA' # United States of America
    UZB='UZB' # Uzbekistan
    VAT='VAT' # Holy See
    VCT='VCT' # Saint Vincent and the Grenadines
    VEN='VEN' # Venezuela, Bolivarian Republic of
    VGB='VGB' # Virgin Islands, British
    VIR='VIR' # Virgin Islands, U.S.
    VNM='VNM' # Viet Nam
    VUT='VUT' # Vanuatu
    WLF='WLF' # Wallis and Futuna
    WSM='WSM' # Samoa
    YEM='YEM' # Yemen
    ZAF='ZAF' # South Africa
    ZMB='ZMB' # Zambia
    ZWE='ZWE' # Zimbabwe
    _0_04='004' # Afghanistan
    _0_08='008' # Albania
    _0_10='010' # Antarctica
    _0_12='012' # Algeria
    _0_16='016' # American Samoa
    _0_20='020' # Andorra
    _0_24='024' # Angola
    _0_28='028' # Antigua and Barbuda
    _0_31='031' # Azerbaijan
    _0_32='032' # Argentina
    _0_36='036' # Australia
    _0_40='040' # Austria
    _0_44='044' # Bahamas
    _0_48='048' # Bahrain
    _0_50='050' # Bangladesh
    _0_51='051' # Armenia
    _0_52='052' # Barbados
    _0_56='056' # Belgium
    _0_60='060' # Bermuda
    _0_64='064' # Bhutan
    _0_68='068' # Bolivia, Plurinational State of
    _0_70='070' # Bosnia and Herzegovina
    _0_72='072' # Botswana
    _0_74='074' # Bouvet Island
    _0_76='076' # Brazil
    _0_84='084' # Belize
    _0_86='086' # British Indian Ocean Territory
    _0_90='090' # Solomon Islands
    _0_92='092' # Virgin Islands, British
    _0_96='096' # Brunei Darussalam
    _1_00='100' # Bulgaria
    _1_04='104' # Myanmar
    _1_08='108' # Burundi
    _1_12='112' # Belarus
    _1_16='116' # Cambodia
    _1_20='120' # Cameroon
    _1_24='124' # Canada
    _1_32='132' # Cabo Verde
    _1_36='136' # Cayman Islands
    _1_40='140' # Central African Republic
    _1_44='144' # Sri Lanka
    _1_48='148' # Chad
    _1_52='152' # Chile
    _1_56='156' # China
    _1_58='158' # Taiwan, Province of China
    _1_62='162' # Christmas Island
    _1_66='166' # Cocos (Keeling) Islands
    _1_70='170' # Colombia
    _1_74='174' # Comoros
    _1_75='175' # Mayotte
    _1_78='178' # Congo
    _1_80='180' # Congo, the Democratic Republic of the
    _1_84='184' # Cook Islands
    _1_88='188' # Costa Rica
    _1_91='191' # Croatia
    _1_92='192' # Cuba
    _1_96='196' # Cyprus
    _2_03='203' # Czechia
    _2_04='204' # Benin
    _2_08='208' # Denmark
    _2_12='212' # Dominica
    _2_14='214' # Dominican Republic
    _2_18='218' # Ecuador
    _2_22='222' # El Salvador
    _2_26='226' # Equatorial Guinea
    _2_31='231' # Ethiopia
    _2_32='232' # Eritrea
    _2_33='233' # Estonia
    _2_34='234' # Faroe Islands
    _2_38='238' # Falkland Islands (Malvinas)
    _2_39='239' # South Georgia and the South Sandwich Islands
    _2_42='242' # Fiji
    _2_46='246' # Finland
    _2_48='248' # Eland Islands
    _2_50='250' # France
    _2_54='254' # French Guiana
    _2_58='258' # French Polynesia
    _2_60='260' # French Southern Territories
    _2_62='262' # Djibouti
    _2_66='266' # Gabon
    _2_68='268' # Georgia
    _2_70='270' # Gambia
    _2_75='275' # Palestine, State of
    _2_76='276' # Germany
    _2_88='288' # Ghana
    _2_92='292' # Gibraltar
    _2_96='296' # Kiribati
    _3_00='300' # Greece
    _3_04='304' # Greenland
    _3_08='308' # Grenada
    _3_12='312' # Guadeloupe
    _3_16='316' # Guam
    _3_20='320' # Guatemala
    _3_24='324' # Guinea
    _3_28='328' # Guyana
    _3_32='332' # Haiti
    _3_34='334' # Heard Island and McDonald Islands
    _3_36='336' # Holy See
    _3_40='340' # Honduras
    _3_44='344' # Hong Kong
    _3_48='348' # Hungary
    _3_52='352' # Iceland
    _3_56='356' # India
    _3_60='360' # Indonesia
    _3_64='364' # Iran, Islamic Republic of
    _3_68='368' # Iraq
    _3_72='372' # Ireland
    _3_76='376' # Israel
    _3_80='380' # Italy
    _3_84='384' # Ctte d'Ivoire
    _3_88='388' # Jamaica
    _3_92='392' # Japan
    _3_98='398' # Kazakhstan
    _4_00='400' # Jordan
    _4_04='404' # Kenya
    _4_08='408' # Korea, Democratic People's Republic of
    _4_10='410' # Korea, Republic of
    _4_14='414' # Kuwait
    _4_17='417' # Kyrgyzstan
    _4_18='418' # Lao People's Democratic Republic
    _4_22='422' # Lebanon
    _4_26='426' # Lesotho
    _4_28='428' # Latvia
    _4_30='430' # Liberia
    _4_34='434' # Libya
    _4_38='438' # Liechtenstein
    _4_40='440' # Lithuania
    _4_42='442' # Luxembourg
    _4_46='446' # Macao
    _4_50='450' # Madagascar
    _4_54='454' # Malawi
    _4_58='458' # Malaysia
    _4_62='462' # Maldives
    _4_66='466' # Mali
    _4_70='470' # Malta
    _4_74='474' # Martinique
    _4_78='478' # Mauritania
    _4_80='480' # Mauritius
    _4_84='484' # Mexico
    _4_92='492' # Monaco
    _4_96='496' # Mongolia
    _4_98='498' # Moldova, Republic of
    _4_99='499' # Montenegro
    _5_00='500' # Montserrat
    _5_04='504' # Morocco
    _5_08='508' # Mozambique
    _5_12='512' # Oman
    _5_16='516' # Namibia
    _5_20='520' # Nauru
    _5_24='524' # Nepal
    _5_28='528' # Netherlands
    _5_31='531' # Curagao
    _5_33='533' # Aruba
    _5_34='534' # Sint Maarten (Dutch part)
    _5_35='535' # Bonaire, Sint Eustatius and Saba
    _5_40='540' # New Caledonia
    _5_48='548' # Vanuatu
    _5_54='554' # New Zealand
    _5_58='558' # Nicaragua
    _5_62='562' # Niger
    _5_66='566' # Nigeria
    _5_70='570' # Niue
    _5_74='574' # Norfolk Island
    _5_78='578' # Norway
    _5_80='580' # Northern Mariana Islands
    _5_81='581' # United States Minor Outlying Islands
    _5_83='583' # Micronesia, Federated States of
    _5_84='584' # Marshall Islands
    _5_85='585' # Palau
    _5_86='586' # Pakistan
    _5_91='591' # Panama
    _5_98='598' # Papua New Guinea
    _6_00='600' # Paraguay
    _6_04='604' # Peru
    _6_08='608' # Philippines
    _6_12='612' # Pitcairn
    _6_16='616' # Poland
    _6_20='620' # Portugal
    _6_24='624' # Guinea-Bissau
    _6_26='626' # Timor-Leste
    _6_30='630' # Puerto Rico
    _6_34='634' # Qatar
    _6_38='638' # Riunion
    _6_42='642' # Romania
    _6_43='643' # Russian Federation
    _6_46='646' # Rwanda
    _6_52='652' # Saint Barthilemy
    _6_54='654' # Saint Helena, Ascension and Tristan da Cunha
    _6_59='659' # Saint Kitts and Nevis
    _6_60='660' # Anguilla
    _6_62='662' # Saint Lucia
    _6_63='663' # Saint Martin (French part)
    _6_66='666' # Saint Pierre and Miquelon
    _6_70='670' # Saint Vincent and the Grenadines
    _6_74='674' # San Marino
    _6_78='678' # Sao Tome and Principe
    _6_82='682' # Saudi Arabia
    _6_86='686' # Senegal
    _6_88='688' # Serbia
    _6_90='690' # Seychelles
    _6_94='694' # Sierra Leone
    _7_02='702' # Singapore
    _7_03='703' # Slovakia
    _7_04='704' # Viet Nam
    _7_05='705' # Slovenia
    _7_06='706' # Somalia
    _7_10='710' # South Africa
    _7_16='716' # Zimbabwe
    _7_24='724' # Spain
    _7_28='728' # South Sudan
    _7_29='729' # Sudan
    _7_32='732' # Western Sahara
    _7_40='740' # Suriname
    _7_44='744' # Svalbard and Jan Mayen
    _7_48='748' # Swaziland
    _7_52='752' # Sweden
    _7_56='756' # Switzerland
    _7_60='760' # Syrian Arab Republic
    _7_62='762' # Tajikistan
    _7_64='764' # Thailand
    _7_68='768' # Togo
    _7_72='772' # Tokelau
    _7_76='776' # Tonga
    _7_80='780' # Trinidad and Tobago
    _7_84='784' # United Arab Emirates
    _7_88='788' # Tunisia
    _7_92='792' # Turkey
    _7_95='795' # Turkmenistan
    _7_96='796' # Turks and Caicos Islands
    _7_98='798' # Tuvalu
    _8_00='800' # Uganda
    _8_04='804' # Ukraine
    _8_07='807' # Macedonia, the former Yugoslav Republic of
    _8_18='818' # Egypt
    _8_26='826' # United Kingdom
    _8_31='831' # Guernsey
    _8_32='832' # Jersey
    _8_33='833' # Isle of Man
    _8_34='834' # Tanzania, United Republic of
    _8_40='840' # United States of America
    _8_50='850' # Virgin Islands, U.S.
    _8_54='854' # Burkina Faso
    _8_58='858' # Uruguay
    _8_60='860' # Uzbekistan
    _8_62='862' # Venezuela, Bolivarian Republic of
    _8_76='876' # Wallis and Futuna
    _8_82='882' # Samoa
    _8_87='887' # Yemen
    _8_94='894' # Zambia
    AFBAL='AF-BAL' # Balkh
    AFBAM='AF-BAM' # Bāmyān
    AFBDG='AF-BDG' # Bādghīs
    AFBDS='AF-BDS' # Badakhshān
    AFBGL='AF-BGL' # Baghlān
    AFDAY='AF-DAY' # Dāykundī
    AFFRA='AF-FRA' # Farāh
    AFFYB='AF-FYB' # Fāryāb
    AFGHA='AF-GHA' # Ghaznī
    AFGHO='AF-GHO' # Ghōr
    AFHEL='AF-HEL' # Helmand
    AFHER='AF-HER' # Herāt
    AFJOW='AF-JOW' # Jowzjān
    AFKAB='AF-KAB' # Kābul
    AFKAN='AF-KAN' # Kandahār
    AFKAP='AF-KAP' # Kāpīsā
    AFKDZ='AF-KDZ' # Kunduz
    AFKHO='AF-KHO' # Khōst
    AFKNR='AF-KNR' # Kunar
    AFLAG='AF-LAG' # Laghmān
    AFLOG='AF-LOG' # Lōgar
    AFNAN='AF-NAN' # Nangarhār
    AFNIM='AF-NIM' # Nīmrōz
    AFNUR='AF-NUR' # Nūristān
    AFPAN='AF-PAN' # Panjshayr
    AFPAR='AF-PAR' # Parwān
    AFPIA='AF-PIA' # Paktiyā
    AFPKA='AF-PKA' # Paktīkā
    AFSAM='AF-SAM' # Samangān
    AFSAR='AF-SAR' # Sar-e Pul
    AFTAK='AF-TAK' # Takhār
    AFURU='AF-URU' # Uruzgān
    AFWAR='AF-WAR' # Wardak
    AFZAB='AF-ZAB' # Zābul
    AXAX='AX-AX' # Åland Islands
    AL_01='AL-01' # Berat
    AL_02='AL-02' # Durrës
    AL_03='AL-03' # Elbasan
    AL_04='AL-04' # Fier
    AL_05='AL-05' # Gjirokastër
    AL_06='AL-06' # Korçë
    AL_07='AL-07' # Kukës
    AL_08='AL-08' # Lezhë
    AL_09='AL-09' # Dibër
    AL_10='AL-10' # Shkodër
    AL_11='AL-11' # Tiranë
    AL_12='AL-12' # Vlorë
    ALBR='AL-BR' # Berat
    ALBU='AL-BU' # Bulqizë
    ALDI='AL-DI' # Dibër
    ALDL='AL-DL' # Delvinë
    ALDR='AL-DR' # Durrës
    ALDV='AL-DV' # Devoll
    ALEL='AL-EL' # Elbasan
    ALER='AL-ER' # Kolonjë
    ALFR='AL-FR' # Fier
    ALGJ='AL-GJ' # Gjirokastër
    ALGR='AL-GR' # Gramsh
    ALHA='AL-HA' # Has
    ALKA='AL-KA' # Kavajë
    ALKB='AL-KB' # Kurbin
    ALKC='AL-KC' # Kuçovë
    ALKO='AL-KO' # Korçë
    ALKR='AL-KR' # Krujë
    ALKU='AL-KU' # Kukës
    ALLB='AL-LB' # Librazhd
    ALLE='AL-LE' # Lezhë
    ALLU='AL-LU' # Lushnjë
    ALMK='AL-MK' # Mallakastër
    ALMM='AL-MM' # Malësi e Madhe
    ALMR='AL-MR' # Mirditë
    ALMT='AL-MT' # Mat
    ALPG='AL-PG' # Pogradec
    ALPQ='AL-PQ' # Peqin
    ALPR='AL-PR' # Përmet
    ALPU='AL-PU' # Pukë
    ALSH='AL-SH' # Shkodër
    ALSK='AL-SK' # Skrapar
    ALSR='AL-SR' # Sarandë
    ALTE='AL-TE' # Tepelenë
    ALTP='AL-TP' # Tropojë
    ALTR='AL-TR' # Tiranë
    ALVL='AL-VL' # Vlorë
    DZ_01='DZ-01' # Adrar
    DZ_02='DZ-02' # Chlef
    DZ_03='DZ-03' # Laghouat
    DZ_04='DZ-04' # Oum el Bouaghi
    DZ_05='DZ-05' # Batna
    DZ_06='DZ-06' # Béjaïa
    DZ_07='DZ-07' # Biskra
    DZ_08='DZ-08' # Béchar
    DZ_09='DZ-09' # Blida
    DZ_10='DZ-10' # Bouira
    DZ_11='DZ-11' # Tamanrasset
    DZ_12='DZ-12' # Tébessa
    DZ_13='DZ-13' # Tlemcen
    DZ_14='DZ-14' # Tiaret
    DZ_15='DZ-15' # Tizi Ouzou
    DZ_16='DZ-16' # Alger
    DZ_17='DZ-17' # Djelfa
    DZ_18='DZ-18' # Jijel
    DZ_19='DZ-19' # Sétif
    DZ_20='DZ-20' # Saïda
    DZ_21='DZ-21' # Skikda
    DZ_22='DZ-22' # Sidi Bel Abbès
    DZ_23='DZ-23' # Annaba
    DZ_24='DZ-24' # Guelma
    DZ_25='DZ-25' # Constantine
    DZ_26='DZ-26' # Médéa
    DZ_27='DZ-27' # Mostaganem
    DZ_28='DZ-28' # Msila
    DZ_29='DZ-29' # Mascara
    DZ_30='DZ-30' # Ouargla
    DZ_31='DZ-31' # Oran
    DZ_32='DZ-32' # El Bayadh
    DZ_33='DZ-33' # Illizi
    DZ_34='DZ-34' # Bordj Bou Arréridj
    DZ_35='DZ-35' # Boumerdès
    DZ_36='DZ-36' # El Tarf
    DZ_37='DZ-37' # Tindouf
    DZ_38='DZ-38' # Tissemsilt
    DZ_39='DZ-39' # El Oued
    DZ_40='DZ-40' # Khenchela
    DZ_41='DZ-41' # Souk Ahras
    DZ_42='DZ-42' # Tipaza
    DZ_43='DZ-43' # Mila
    DZ_44='DZ-44' # Aïn Defla
    DZ_45='DZ-45' # Naama
    DZ_46='DZ-46' # Aïn Témouchent
    DZ_47='DZ-47' # Ghardaïa
    DZ_48='DZ-48' # Relizane
    ASAS='AS-AS' # American Samoa
    AD_02='AD-02' # Canillo
    AD_03='AD-03' # Encamp
    AD_04='AD-04' # La Massana
    AD_05='AD-05' # Ordino
    AD_06='AD-06' # Sant Julià de Lòria
    AD_07='AD-07' # Andorra la Vella
    AD_08='AD-08' # Escaldes-Engordany
    AOBGO='AO-BGO' # Bengo
    AOBGU='AO-BGU' # Benguela
    AOBIE='AO-BIE' # Bié
    AOCAB='AO-CAB' # Cabinda
    AOCCU='AO-CCU' # Kuando Kubango
    AOCNN='AO-CNN' # Cunene
    AOCNO='AO-CNO' # Kwanza Norte
    AOCUS='AO-CUS' # Kwanza Sul
    AOHUA='AO-HUA' # Huambo
    AOHUI='AO-HUI' # Huíla
    AOLNO='AO-LNO' # Lunda Norte
    AOLSU='AO-LSU' # Lunda Sul
    AOLUA='AO-LUA' # Luanda
    AOMAL='AO-MAL' # Malange
    AOMOX='AO-MOX' # Moxico
    AONAM='AO-NAM' # Namibe
    AOUIG='AO-UIG' # Uíge
    AOZAI='AO-ZAI' # Zaire
    AIAI='AI-AI' # Anguilla
    AQAQ='AQ-AQ' # Antarctica
    AG_03='AG-03' # Saint George
    AG_04='AG-04' # Saint John
    AG_05='AG-05' # Saint Mary
    AG_06='AG-06' # Saint Paul
    AG_07='AG-07' # Saint Peter
    AG_08='AG-08' # Saint Philip
    AG_10='AG-10' # Barbuda
    AG_11='AG-11' # Redonda
    ARA='AR-A' # Salta
    ARB='AR-B' # Buenos Aires
    ARC='AR-C' # Ciudad Autónoma de Buenos Aires
    ARD='AR-D' # San Luis
    ARE_1='AR-E' # Entre Ríos
    ARF='AR-F' # La Rioja
    ARG_1='AR-G' # Santiago del Estero
    ARH='AR-H' # Chaco
    ARJ='AR-J' # San Juan
    ARK='AR-K' # Catamarca
    ARL='AR-L' # La Pampa
    ARM_1='AR-M' # Mendoza
    ARN='AR-N' # Misiones
    ARP='AR-P' # Formosa
    ARQ='AR-Q' # Neuquén
    ARR='AR-R' # Río Negro
    ARS='AR-S' # Santa Fe
    ART='AR-T' # Tucumán
    ARU='AR-U' # Chubut
    ARV='AR-V' # Tierra del Fuego
    ARW='AR-W' # Corrientes
    ARX='AR-X' # Córdoba
    ARY='AR-Y' # Jujuy
    ARZ='AR-Z' # Santa Cruz
    AMAG='AM-AG' # Aragac̣otn
    AMAR='AM-AR' # Ararat
    AMAV='AM-AV' # Armavir
    AMER='AM-ER' # Erevan
    AMGR='AM-GR' # Geġark'unik'
    AMKT='AM-KT' # Kotayk'
    AMLO='AM-LO' # Loṙi
    AMSH='AM-SH' # Širak
    AMSU='AM-SU' # Syunik'
    AMTV='AM-TV' # Tavuš
    AMVD='AM-VD' # Vayoć Jor
    AWAW='AW-AW' # Aruba
    AUACT='AU-ACT' # Australian Capital Territory
    AUNSW='AU-NSW' # New South Wales
    AUNT='AU-NT' # Northern Territory
    AUQLD='AU-QLD' # Queensland
    AUSA='AU-SA' # South Australia
    AUTAS='AU-TAS' # Tasmania
    AUVIC='AU-VIC' # Victoria
    AUWA='AU-WA' # Western Australia
    AT_1='AT-1' # Burgenland
    AT_2='AT-2' # Kärnten
    AT_3='AT-3' # Niederösterreich
    AT_4='AT-4' # Oberösterreich
    AT_5='AT-5' # Salzburg
    AT_6='AT-6' # Steiermark
    AT_7='AT-7' # Tirol
    AT_8='AT-8' # Vorarlberg
    AT_9='AT-9' # Wien
    AZABS='AZ-ABS' # Abşeron
    AZAGA='AZ-AGA' # Ağstafa
    AZAGC='AZ-AGC' # Ağcabәdi
    AZAGM='AZ-AGM' # Ağdam
    AZAGS='AZ-AGS' # Ağdaş
    AZAGU='AZ-AGU' # Ağsu
    AZAST='AZ-AST' # Astara
    AZBA='AZ-BA' # Bakı
    AZBAB='AZ-BAB' # Babək
    AZBAL='AZ-BAL' # Balakən
    AZBAR='AZ-BAR' # Bərdə
    AZBEY='AZ-BEY' # Beyləqan
    AZBIL='AZ-BIL' # Biləsuvar
    AZCAB='AZ-CAB' # Cəbrayıl
    AZCAL='AZ-CAL' # Cəlilabad
    AZCUL='AZ-CUL' # Culfa
    AZDAS='AZ-DAS' # Daşkəsən
    AZFUZ='AZ-FUZ' # Füzuli
    AZGAD='AZ-GAD' # Gədəbəy
    AZGA='AZ-GA' # Gәncә
    AZGOR='AZ-GOR' # Goranboy
    AZGOY='AZ-GOY' # Göyçay
    AZGYG='AZ-GYG' # Göygöl
    AZHAC='AZ-HAC' # Hacıqabul
    AZIMI='AZ-IMI' # İmişli
    AZISM='AZ-ISM' # İsmayıllı
    AZKAL='AZ-KAL' # Kəlbəcər
    AZKAN='AZ-KAN' # Kǝngǝrli
    AZKUR='AZ-KUR' # Kürdəmir
    AZLAC='AZ-LAC' # Laçın
    AZLA='AZ-LA' # Lәnkәran
    AZLAN='AZ-LAN' # Lənkəran
    AZLER='AZ-LER' # Lerik
    AZMAS='AZ-MAS' # Masallı
    AZMI='AZ-MI' # Mingәçevir
    AZNA='AZ-NA' # Naftalan
    AZNEF='AZ-NEF' # Neftçala
    AZNV='AZ-NV' # Naxçıvan
    AZNX='AZ-NX' # Naxçıvan
    AZOGU='AZ-OGU' # Oğuz
    AZORD='AZ-ORD' # Ordubad
    AZQAB='AZ-QAB' # Qәbәlә
    AZQAX='AZ-QAX' # Qax
    AZQAZ='AZ-QAZ' # Qazax
    AZQBA='AZ-QBA' # Quba
    AZQBI='AZ-QBI' # Qubadlı
    AZQOB='AZ-QOB' # Qobustan
    AZQUS='AZ-QUS' # Qusar
    AZSAB='AZ-SAB' # Sabirabad
    AZSAD='AZ-SAD' # Sәdәrәk
    AZSAH='AZ-SAH' # Şahbuz
    AZSAK='AZ-SAK' # Şәki
    AZSAL='AZ-SAL' # Salyan
    AZSAR='AZ-SAR' # Şәrur
    AZSA='AZ-SA' # Şәki
    AZSAT='AZ-SAT' # Saatlı
    AZSBN='AZ-SBN' # Şabran
    AZSIY='AZ-SIY' # Siyәzәn
    AZSKR='AZ-SKR' # Şәmkir
    AZSMI='AZ-SMI' # Şamaxı
    AZSM='AZ-SM' # Sumqayıt
    AZSMX='AZ-SMX' # Samux
    AZSR='AZ-SR' # Şirvan
    AZSUS='AZ-SUS' # Şuşa
    AZTAR='AZ-TAR' # Tәrtәr
    AZTOV='AZ-TOV' # Tovuz
    AZUCA='AZ-UCA' # Ucar
    AZXAC='AZ-XAC' # Xaçmaz
    AZXA='AZ-XA' # Xankәndi
    AZXCI='AZ-XCI' # Xocalı
    AZXIZ='AZ-XIZ' # Xızı
    AZXVD='AZ-XVD' # Xocavәnd
    AZYAR='AZ-YAR' # Yardımlı
    AZYEV='AZ-YEV' # Yevlax
    AZYE='AZ-YE' # Yevlax
    AZZAN='AZ-ZAN' # Zәngilan
    AZZAQ='AZ-ZAQ' # Zaqatala
    AZZAR='AZ-ZAR' # Zәrdab
    BSAK='BS-AK' # Acklins
    BSBI='BS-BI' # Bimini
    BSBP='BS-BP' # Black Point
    BSBY='BS-BY' # Berry Islands
    BSCE='BS-CE' # Central Eleuthera
    BSCI='BS-CI' # Cat Island
    BSCK='BS-CK' # Crooked Island and Long Cay
    BSCO='BS-CO' # Central Abaco
    BSCS='BS-CS' # Central Andros
    BSEG='BS-EG' # East Grand Bahama
    BSEX='BS-EX' # Exuma
    BSFP='BS-FP' # City of Freeport
    BSGC='BS-GC' # Grand Cay
    BSHI='BS-HI' # Harbour Island
    BSHT='BS-HT' # Hope Town
    BSIN='BS-IN' # Inagua
    BSLI='BS-LI' # Long Island
    BSMC='BS-MC' # Mangrove Cay
    BSMG='BS-MG' # Mayaguana
    BSMI='BS-MI' # Moore's Island
    BSNE='BS-NE' # North Eleuthera
    BSNO='BS-NO' # North Abaco
    BSNS='BS-NS' # North Andros
    BSRC='BS-RC' # Rum Cay
    BSRI='BS-RI' # Ragged Island
    BSSA='BS-SA' # South Andros
    BSSE='BS-SE' # South Eleuthera
    BSSO='BS-SO' # South Abaco
    BSSS='BS-SS' # San Salvador
    BSSW='BS-SW' # Spanish Wells
    BSWG='BS-WG' # West Grand Bahama
    BH_13='BH-13' # Al Manāmah
    BH_14='BH-14' # Al Janūbīyah
    BH_15='BH-15' # Al Muḩarraq
    BH_16='BH-16' # Al Wusţá
    BH_17='BH-17' # Ash Shamālīyah
    BD_01='BD-01' # Bandarban
    BD_02='BD-02' # Barguna
    BD_03='BD-03' # Bogra
    BD_04='BD-04' # Brahmanbaria
    BD_05='BD-05' # Bagerhat
    BD_06='BD-06' # Barisal
    BD_07='BD-07' # Bhola
    BD_08='BD-08' # Comilla
    BD_09='BD-09' # Chandpur
    BD_10='BD-10' # Chittagong
    BD_11='BD-11' # Cox's Bazar
    BD_12='BD-12' # Chuadanga
    BD_13='BD-13' # Dhaka
    BD_14='BD-14' # Dinajpur
    BD_15='BD-15' # Faridpur
    BD_16='BD-16' # Feni
    BD_17='BD-17' # Gopalganj
    BD_18='BD-18' # Gazipur
    BD_19='BD-19' # Gaibandha
    BD_20='BD-20' # Habiganj
    BD_21='BD-21' # Jamalpur
    BD_22='BD-22' # Jessore
    BD_23='BD-23' # Jhenaidah
    BD_24='BD-24' # Jaipurhat
    BD_25='BD-25' # Jhalakati
    BD_26='BD-26' # Kishoreganj
    BD_27='BD-27' # Khulna
    BD_28='BD-28' # Kurigram
    BD_29='BD-29' # Khagrachari
    BD_30='BD-30' # Kushtia
    BD_31='BD-31' # Lakshmipur
    BD_32='BD-32' # Lalmonirhat
    BD_33='BD-33' # Manikganj
    BD_34='BD-34' # Mymensingh
    BD_35='BD-35' # Munshiganj
    BD_36='BD-36' # Madaripur
    BD_37='BD-37' # Magura
    BD_38='BD-38' # Moulvibazar
    BD_39='BD-39' # Meherpur
    BD_40='BD-40' # Narayanganj
    BD_41='BD-41' # Netrakona
    BD_42='BD-42' # Narsingdi
    BD_43='BD-43' # Narail
    BD_44='BD-44' # Natore
    BD_45='BD-45' # Nawabganj
    BD_46='BD-46' # Nilphamari
    BD_47='BD-47' # Noakhali
    BD_48='BD-48' # Naogaon
    BD_49='BD-49' # Pabna
    BD_50='BD-50' # Pirojpur
    BD_51='BD-51' # Patuakhali
    BD_52='BD-52' # Panchagarh
    BD_53='BD-53' # Rajbari
    BD_54='BD-54' # Rajshahi
    BD_55='BD-55' # Rangpur
    BD_56='BD-56' # Rangamati
    BD_57='BD-57' # Sherpur
    BD_58='BD-58' # Satkhira
    BD_59='BD-59' # Sirajganj
    BD_60='BD-60' # Sylhet
    BD_61='BD-61' # Sunamganj
    BD_62='BD-62' # Shariatpur
    BD_63='BD-63' # Tangail
    BD_64='BD-64' # Thakurgaon
    BDA='BD-A' # Barisal
    BDB='BD-B' # Chittagong
    BDC='BD-C' # Dhaka
    BDD='BD-D' # Khulna
    BDE='BD-E' # Rajshahi
    BDF='BD-F' # Rangpur
    BDG='BD-G' # Sylhet
    BB_01='BB-01' # Christ Church
    BB_02='BB-02' # Saint Andrew
    BB_03='BB-03' # Saint George
    BB_04='BB-04' # Saint James
    BB_05='BB-05' # Saint John
    BB_06='BB-06' # Saint Joseph
    BB_07='BB-07' # Saint Lucy
    BB_08='BB-08' # Saint Michael
    BB_09='BB-09' # Saint Peter
    BB_10='BB-10' # Saint Philip
    BB_11='BB-11' # Saint Thomas
    BYBR='BY-BR' # Bresckaja voblasć
    BYHM='BY-HM' # Gorod Minsk
    BYHO='BY-HO' # Gomel'skaja oblast'
    BYHR='BY-HR' # Grodnenskaja oblast'
    BYMA='BY-MA' # Mahilioŭskaja voblasć
    BYMI='BY-MI' # Minskaja oblast'
    BYVI='BY-VI' # Viciebskaja voblasć
    BEBRU='BE-BRU' # Brussels Hoofdstedelijk Gewest
    BEVAN='BE-VAN' # Antwerpen
    BEVBR='BE-VBR' # Vlaams-Brabant
    BEVLG='BE-VLG' # Vlaams Gewest
    BEVLI='BE-VLI' # Limburg
    BEVOV='BE-VOV' # Oost-Vlaanderen
    BEVWV='BE-VWV' # West-Vlaanderen
    BEWAL='BE-WAL' # wallonne, Région
    BEWBR='BE-WBR' # Brabant wallon
    BEWHT='BE-WHT' # Hainaut
    BEWLG='BE-WLG' # Liège
    BEWLX='BE-WLX' # Luxembourg
    BEWNA='BE-WNA' # Namur
    BZBZ='BZ-BZ' # Belize
    BZCY='BZ-CY' # Cayo
    BZCZL='BZ-CZL' # Corozal
    BZOW='BZ-OW' # Orange Walk
    BZSC='BZ-SC' # Stann Creek
    BZTOL='BZ-TOL' # Toledo
    BJAK='BJ-AK' # Atakora
    BJAL='BJ-AL' # Alibori
    BJAQ='BJ-AQ' # Atlantique
    BJBO='BJ-BO' # Borgou
    BJCO='BJ-CO' # Collines
    BJDO='BJ-DO' # Donga
    BJKO='BJ-KO' # Kouffo
    BJLI='BJ-LI' # Littoral
    BJMO='BJ-MO' # Mono
    BJOU='BJ-OU' # Ouémé
    BJPL='BJ-PL' # Plateau
    BJZO='BJ-ZO' # Zou
    BMBM='BM-BM' # Bermuda
    BT_11='BT-11' # Paro
    BT_12='BT-12' # Chhukha
    BT_13='BT-13' # Ha
    BT_14='BT-14' # Samtse
    BT_15='BT-15' # Thimphu
    BT_21='BT-21' # Tsirang
    BT_22='BT-22' # Dagana
    BT_23='BT-23' # Punakha
    BT_24='BT-24' # Wangdue Phodrang
    BT_31='BT-31' # Sarpang
    BT_32='BT-32' # Trongsa
    BT_33='BT-33' # Bumthang
    BT_34='BT-34' # Zhemgang
    BT_41='BT-41' # Trashigang
    BT_42='BT-42' # Monggar
    BT_43='BT-43' # Pemagatshel
    BT_44='BT-44' # Lhuentse
    BT_45='BT-45' # Samdrup Jongkha
    BTGA='BT-GA' # Gasa
    BTTY='BT-TY' # Trashi Yangtse
    BOB='BO-B' # El Beni
    BOC='BO-C' # Cochabamba
    BOH='BO-H' # Chuquisaca
    BOL_1='BO-L' # La Paz
    BON='BO-N' # Pando
    BOO='BO-O' # Oruro
    BOP='BO-P' # Potosí
    BOS='BO-S' # Santa Cruz
    BOT='BO-T' # Tarija
    BQBO='BQ-BO' # Bonaire
    BQSA='BQ-SA' # Saba
    BQSE='BQ-SE' # Sint Eustatius
    BA_01='BA-01' # Unsko-sanska županija
    BA_02='BA-02' # Posavska županija
    BA_03='BA-03' # Tuzlanska županija
    BA_04='BA-04' # Zeničko-dobojska županija
    BA_05='BA-05' # Bosansko-podrinjska županija
    BA_06='BA-06' # Srednjobosanska županija
    BA_07='BA-07' # Hercegovačko-neretvanska županija
    BA_08='BA-08' # Zapadnohercegovačka županija
    BA_09='BA-09' # Kanton Sarajevo
    BA_10='BA-10' # Kanton br. 10
    BABIH='BA-BIH' # Federacija Bosne i Hercegovine
    BABRC='BA-BRC' # Brčko distrikt
    BASRP='BA-SRP' # Republika Srpska
    BWCE='BW-CE' # Central
    BWCH='BW-CH' # Chobe
    BWFR='BW-FR' # Francistown
    BWGA='BW-GA' # Gaborone
    BWGH='BW-GH' # Ghanzi
    BWJW='BW-JW' # Jwaneng
    BWKG='BW-KG' # Kgalagadi
    BWKL='BW-KL' # Kgatleng
    BWKW='BW-KW' # Kweneng
    BWLO='BW-LO' # Lobatse
    BWNE='BW-NE' # North East
    BWNW='BW-NW' # North West
    BWSE='BW-SE' # South East
    BWSO='BW-SO' # Southern
    BWSP='BW-SP' # Selibe Phikwe
    BWST='BW-ST' # Sowa Town
    BVBV='BV-BV' # Bouvet Island
    BRAC='BR-AC' # Acre
    BRAL='BR-AL' # Alagoas
    BRAM='BR-AM' # Amazonas
    BRAP='BR-AP' # Amapá
    BRBA='BR-BA' # Bahia
    BRCE='BR-CE' # Ceará
    BRDF='BR-DF' # Distrito Federal
    BRES='BR-ES' # Espírito Santo
    BRGO='BR-GO' # Goiás
    BRMA='BR-MA' # Maranhão
    BRMG='BR-MG' # Minas Gerais
    BRMS='BR-MS' # Mato Grosso do Sul
    BRMT='BR-MT' # Mato Grosso
    BRPA='BR-PA' # Pará
    BRPB='BR-PB' # Paraíba
    BRPE='BR-PE' # Pernambuco
    BRPI='BR-PI' # Piauí
    BRPR='BR-PR' # Paraná
    BRRJ='BR-RJ' # Rio de Janeiro
    BRRN='BR-RN' # Rio Grande do Norte
    BRRO='BR-RO' # Rondônia
    BRRR='BR-RR' # Roraima
    BRRS='BR-RS' # Rio Grande do Sul
    BRSC='BR-SC' # Santa Catarina
    BRSE='BR-SE' # Sergipe
    BRSP='BR-SP' # São Paulo
    BRTO='BR-TO' # Tocantins
    IOIO='IO-IO' # British Indian Ocean Territory
    BNBE='BN-BE' # Belait
    BNBM='BN-BM' # Brunei-Muara
    BNTE='BN-TE' # Temburong
    BNTU='BN-TU' # Tutong
    BG_01='BG-01' # Blagoevgrad
    BG_02='BG-02' # Burgas
    BG_03='BG-03' # Varna
    BG_04='BG-04' # Veliko Tarnovo
    BG_05='BG-05' # Vidin
    BG_06='BG-06' # Vratsa
    BG_07='BG-07' # Gabrovo
    BG_08='BG-08' # Dobrich
    BG_09='BG-09' # Kardzhali
    BG_10='BG-10' # Kyustendil
    BG_11='BG-11' # Lovech
    BG_12='BG-12' # Montana
    BG_13='BG-13' # Pazardzhik
    BG_14='BG-14' # Pernik
    BG_15='BG-15' # Pleven
    BG_16='BG-16' # Plovdiv
    BG_17='BG-17' # Razgrad
    BG_18='BG-18' # Ruse
    BG_19='BG-19' # Silistra
    BG_20='BG-20' # Sliven
    BG_21='BG-21' # Smolyan
    BG_22='BG-22' # Sofia
    BG_23='BG-23' # Sofia
    BG_24='BG-24' # Stara Zagora
    BG_25='BG-25' # Targovishte
    BG_26='BG-26' # Haskovo
    BG_27='BG-27' # Shumen
    BG_28='BG-28' # Yambol
    BF_01='BF-01' # Boucle du Mouhoun
    BF_02='BF-02' # Cascades
    BF_03='BF-03' # Centre
    BF_04='BF-04' # Centre-Est
    BF_05='BF-05' # Centre-Nord
    BF_06='BF-06' # Centre-Ouest
    BF_07='BF-07' # Centre-Sud
    BF_08='BF-08' # Est
    BF_09='BF-09' # Hauts-Bassins
    BF_10='BF-10' # Nord
    BF_11='BF-11' # Plateau-Central
    BF_12='BF-12' # Sahel
    BF_13='BF-13' # Sud-Ouest
    BFBAL='BF-BAL' # Balé
    BFBAM='BF-BAM' # Bam
    BFBAN='BF-BAN' # Banwa
    BFBAZ='BF-BAZ' # Bazèga
    BFBGR='BF-BGR' # Bougouriba
    BFBLG='BF-BLG' # Boulgou
    BFBLK='BF-BLK' # Boulkiemdé
    BFCOM='BF-COM' # Comoé
    BFGAN='BF-GAN' # Ganzourgou
    BFGNA='BF-GNA' # Gnagna
    BFGOU='BF-GOU' # Gourma
    BFHOU='BF-HOU' # Houet
    BFIOB='BF-IOB' # Ioba
    BFKAD='BF-KAD' # Kadiogo
    BFKEN='BF-KEN' # Kénédougou
    BFKMD='BF-KMD' # Komondjari
    BFKMP='BF-KMP' # Kompienga
    BFKOP='BF-KOP' # Koulpélogo
    BFKOS='BF-KOS' # Kossi
    BFKOT='BF-KOT' # Kouritenga
    BFKOW='BF-KOW' # Kourwéogo
    BFLER='BF-LER' # Léraba
    BFLOR='BF-LOR' # Loroum
    BFMOU='BF-MOU' # Mouhoun
    BFNAM='BF-NAM' # Namentenga
    BFNAO='BF-NAO' # Nahouri
    BFNAY='BF-NAY' # Nayala
    BFNOU='BF-NOU' # Noumbiel
    BFOUB='BF-OUB' # Oubritenga
    BFOUD='BF-OUD' # Oudalan
    BFPAS='BF-PAS' # Passoré
    BFPON='BF-PON' # Poni
    BFSEN='BF-SEN' # Séno
    BFSIS='BF-SIS' # Sissili
    BFSMT='BF-SMT' # Sanmatenga
    BFSNG='BF-SNG' # Sanguié
    BFSOM='BF-SOM' # Soum
    BFSOR='BF-SOR' # Sourou
    BFTAP='BF-TAP' # Tapoa
    BFTUI='BF-TUI' # Tui
    BFYAG='BF-YAG' # Yagha
    BFYAT='BF-YAT' # Yatenga
    BFZIR='BF-ZIR' # Ziro
    BFZON='BF-ZON' # Zondoma
    BFZOU='BF-ZOU' # Zoundwéogo
    BIBB='BI-BB' # Bubanza
    BIBL='BI-BL' # Bujumbura Rural
    BIBM='BI-BM' # Bujumbura Mairie
    BIBR='BI-BR' # Bururi
    BICA='BI-CA' # Cankuzo
    BICI='BI-CI' # Cibitoke
    BIGI='BI-GI' # Gitega
    BIKI='BI-KI' # Kirundo
    BIKR='BI-KR' # Karuzi
    BIKY='BI-KY' # Kayanza
    BIMA='BI-MA' # Makamba
    BIMU='BI-MU' # Muramvya
    BIMW='BI-MW' # Mwaro
    BIMY='BI-MY' # Muyinga
    BING='BI-NG' # Ngozi
    BIRT='BI-RT' # Rutana
    BIRY='BI-RY' # Ruyigi
    KH_10='KH-10' # Krâchéh
    KH_11='KH-11' # Môndól Kiri
    KH_12='KH-12' # Phnom Penh
    KH_13='KH-13' # Preăh Vihéar
    KH_14='KH-14' # Prey Veaeng
    KH_15='KH-15' # Pousaat
    KH_16='KH-16' # Rotanak Kiri
    KH_17='KH-17' # Siem Reab
    KH_18='KH-18' # Krŏng Preăh Sihanouk
    KH_19='KH-19' # Stoĕng Trêng
    KH_1='KH-1' # Bântéay Méanchey
    KH_20='KH-20' # Svaay Rieng
    KH_21='KH-21' # Taakaev
    KH_22='KH-22' # Ŏtdâr Méanchey
    KH_23='KH-23' # Krong Kaeb
    KH_24='KH-24' # Krŏng Pailĭn
    KH_2='KH-2' # Baat Dambang
    KH_3='KH-3' # Kampong Chaam
    KH_4='KH-4' # Kampong Chhnang
    KH_5='KH-5' # Kâmpóng Spœ
    KH_6='KH-6' # Kâmpóng Thum
    KH_7='KH-7' # Kampot
    KH_8='KH-8' # Kandaal
    KH_9='KH-9' # Kaoh Kong
    CMAD='CM-AD' # Adamaoua
    CMCE='CM-CE' # Centre
    CMEN='CM-EN' # Extrême-Nord
    CMES='CM-ES' # East
    CMLT='CM-LT' # Littoral
    CMNO='CM-NO' # Nord
    CMNW='CM-NW' # Nord-Ouest
    CMOU='CM-OU' # Ouest
    CMSU='CM-SU' # South
    CMSW='CM-SW' # South-West
    CAAB='CA-AB' # Alberta
    CABC='CA-BC' # British Columbia
    CAMB='CA-MB' # Manitoba
    CANB='CA-NB' # New Brunswick
    CANL='CA-NL' # Newfoundland and Labrador
    CANS='CA-NS' # Nova Scotia
    CANT='CA-NT' # Northwest Territories
    CANU='CA-NU' # Nunavut
    CAON='CA-ON' # Ontario
    CAPE='CA-PE' # Prince Edward Island
    CAQC='CA-QC' # Quebec
    CASK='CA-SK' # Saskatchewan
    CAYT='CA-YT' # Yukon
    CVB='CV-B' # Ilhas de Barlavento
    CVBR='CV-BR' # Brava
    CVBV='CV-BV' # Boa Vista
    CVCA='CV-CA' # Santa Catarina
    CVCF='CV-CF' # Santa Catarina do Fogo
    CVCR='CV-CR' # Santa Cruz
    CVMA='CV-MA' # Maio
    CVMO='CV-MO' # Mosteiros
    CVPA='CV-PA' # Paul
    CVPN='CV-PN' # Porto Novo
    CVPR='CV-PR' # Praia
    CVRB='CV-RB' # Ribeira Brava
    CVRG='CV-RG' # Ribeira Grande
    CVRS='CV-RS' # Ribeira Grande de Santiago
    CVSD='CV-SD' # São Domingos
    CVSF='CV-SF' # São Filipe
    CVS='CV-S' # Ilhas de Sotavento
    CVSL='CV-SL' # Sal
    CVSM='CV-SM' # São Miguel
    CVSO='CV-SO' # São Lourenço dos Órgãos
    CVSS='CV-SS' # São Salvador do Mundo
    CVSV='CV-SV' # São Vicente
    CVTA='CV-TA' # Tarrafal
    CVTS='CV-TS' # Tarrafal de São Nicolau
    KYKY='KY-KY' # Cayman Islands
    CFAC='CF-AC' # Ouham
    CFBB='CF-BB' # Bamïngï-Bangoran
    CFBGF='CF-BGF' # Bangî
    CFBK='CF-BK' # Basse-Kotto
    CFHK='CF-HK' # Haute-Kotto
    CFHM='CF-HM' # Haut-Mbomou
    CFHS='CF-HS' # Haute-Sangha / Mambéré-Kadéï
    CFKB='CF-KB' # Gïrïbïngï
    CFKG='CF-KG' # Kemö-Gïrïbïngï
    CFLB='CF-LB' # Lobaye
    CFMB='CF-MB' # Mbomou
    CFMP='CF-MP' # Ömbëlä-Pökö
    CFNM='CF-NM' # Nana-Mambéré
    CFOP='CF-OP' # Ouham-Pendé
    CFSE='CF-SE' # Sangä
    CFUK='CF-UK' # Ouaka
    CFVK='CF-VK' # Vakaga
    TDBA='TD-BA' # Al Baţḩah
    TDBG='TD-BG' # Baḩr al Ghazāl
    TDBO='TD-BO' # Borkou
    TDCB='TD-CB' # Chari-Baguirmi
    TDEE='TD-EE' # Ennedi-Est
    TDEO='TD-EO' # Ennedi-Ouest
    TDGR='TD-GR' # Guéra
    TDHL='TD-HL' # Hadjer Lamis
    TDKA='TD-KA' # Kanem
    TDLC='TD-LC' # Al Buḩayrah
    TDLO='TD-LO' # Logone-Occidental
    TDLR='TD-LR' # Logone-Oriental
    TDMA='TD-MA' # Mandoul
    TDMC='TD-MC' # Moyen-Chari
    TDME='TD-ME' # Mayo-Kebbi-Est
    TDMO='TD-MO' # Mayo-Kebbi-Ouest
    TDND='TD-ND' # Madīnat Injamīnā
    TDOD='TD-OD' # Ouaddaï
    TDSA='TD-SA' # Salamat
    TDSI='TD-SI' # Sila
    TDTA='TD-TA' # Tandjilé
    TDTI='TD-TI' # Tibastī
    TDWF='TD-WF' # Wadi Fira
    CLAI='CL-AI' # Aysén
    CLAN='CL-AN' # Antofagasta
    CLAP='CL-AP' # Arica y Parinacota
    CLAR='CL-AR' # Araucanía
    CLAT='CL-AT' # Atacama
    CLBI='CL-BI' # Biobío
    CLCO='CL-CO' # Coquimbo
    CLLI='CL-LI' # Libertador General Bernardo O'Higgins
    CLLL='CL-LL' # Los Lagos
    CLLR='CL-LR' # Los Ríos
    CLMA='CL-MA' # Magallanes
    CLML='CL-ML' # Maule
    CLRM='CL-RM' # Región Metropolitana de Santiago
    CLTA='CL-TA' # Tarapacá
    CLVS='CL-VS' # Valparaíso
    CN_11='CN-11' # Beijing
    CN_12='CN-12' # Tianjin
    CN_13='CN-13' # Hebei
    CN_14='CN-14' # Shanxi
    CN_15='CN-15' # Nei Mongol
    CN_21='CN-21' # Liaoning
    CN_22='CN-22' # Jilin
    CN_23='CN-23' # Heilongjiang
    CN_31='CN-31' # Shanghai
    CN_32='CN-32' # Jiangsu
    CN_33='CN-33' # Zhejiang
    CN_34='CN-34' # Anhui
    CN_35='CN-35' # Fujian
    CN_36='CN-36' # Jiangxi
    CN_37='CN-37' # Shandong
    CN_41='CN-41' # Henan
    CN_42='CN-42' # Hubei
    CN_43='CN-43' # Hunan
    CN_44='CN-44' # Guangdong
    CN_45='CN-45' # Guangxi
    CN_46='CN-46' # Hainan
    CN_50='CN-50' # Chongqing
    CN_51='CN-51' # Sichuan
    CN_52='CN-52' # Guizhou
    CN_53='CN-53' # Yunnan
    CN_54='CN-54' # Xizang
    CN_61='CN-61' # Shaanxi
    CN_62='CN-62' # Gansu
    CN_63='CN-63' # Qinghai
    CN_64='CN-64' # Ningxia
    CN_65='CN-65' # Xinjiang
    CN_71='CN-71' # Taiwan
    CN_91='CN-91' # Hong Kong
    CN_92='CN-92' # Aomen
    CXCX='CX-CX' # Christmas Island
    CCCC='CC-CC' # Cocos Islands
    COAMA='CO-AMA' # Amazonas
    COANT='CO-ANT' # Antioquia
    COARA='CO-ARA' # Arauca
    COATL='CO-ATL' # Atlántico
    COBOL='CO-BOL' # Bolívar
    COBOY='CO-BOY' # Boyacá
    COCAL='CO-CAL' # Caldas
    COCAQ='CO-CAQ' # Caquetá
    COCAS='CO-CAS' # Casanare
    COCAU='CO-CAU' # Cauca
    COCES='CO-CES' # Cesar
    COCHO='CO-CHO' # Chocó
    COCOR='CO-COR' # Córdoba
    COCUN='CO-CUN' # Cundinamarca
    CODC='CO-DC' # Distrito Capital de Bogotá
    COGUA='CO-GUA' # Guainía
    COGUV='CO-GUV' # Guaviare
    COHUI='CO-HUI' # Huila
    COLAG='CO-LAG' # La Guajira
    COMAG='CO-MAG' # Magdalena
    COMET='CO-MET' # Meta
    CONAR='CO-NAR' # Nariño
    CONSA='CO-NSA' # Norte de Santander
    COPUT='CO-PUT' # Putumayo
    COQUI='CO-QUI' # Quindío
    CORIS='CO-RIS' # Risaralda
    COSAN='CO-SAN' # Santander
    COSAP='CO-SAP' # San Andrés, Providencia y Santa Catalina
    COSUC='CO-SUC' # Sucre
    COTOL='CO-TOL' # Tolima
    COVAC='CO-VAC' # Valle del Cauca
    COVAU='CO-VAU' # Vaupés
    COVID='CO-VID' # Vichada
    KMA='KM-A' # Andjouân
    KMG='KM-G' # Andjazîdja
    KMM='KM-M' # Mohéli
    CG_11='CG-11' # Bouenza
    CG_12='CG-12' # Pool
    CG_13='CG-13' # Sangha
    CG_14='CG-14' # Plateaux
    CG_15='CG-15' # Cuvette-Ouest
    CG_16='CG-16' # Pointe-Noire
    CG_2='CG-2' # Lékoumou
    CG_5='CG-5' # Kouilou
    CG_7='CG-7' # Likouala
    CG_8='CG-8' # Cuvette
    CG_9='CG-9' # Niari
    CGBZV='CG-BZV' # Brazzaville
    CDBC='CD-BC' # Bas-Congo
    CDBN='CD-BN' # Bandundu
    CDEQ='CD-EQ' # Équateur
    CDKA='CD-KA' # Katanga
    CDKE='CD-KE' # Kasai-Oriental
    CDKN='CD-KN' # Kinshasa
    CDKW='CD-KW' # Kasai-Occidental
    CDMA='CD-MA' # Maniema
    CDNK='CD-NK' # Nord-Kivu
    CDOR='CD-OR' # Orientale
    CDSK='CD-SK' # Sud-Kivu
    CKCK='CK-CK' # Cook Islands
    CRA='CR-A' # Alajuela
    CRC='CR-C' # Cartago
    CRG='CR-G' # Guanacaste
    CRH='CR-H' # Heredia
    CRL='CR-L' # Limón
    CRP='CR-P' # Puntarenas
    CRSJ='CR-SJ' # San José
    CI_01='CI-01' # Lagunes
    CI_02='CI-02' # Haut-Sassandra
    CI_03='CI-03' # Savanes
    CI_04='CI-04' # Vallée du Bandama
    CI_05='CI-05' # Moyen-Comoé
    CI_06='CI-06' # 18 Montagnes
    CI_07='CI-07' # Lacs
    CI_08='CI-08' # Zanzan
    CI_09='CI-09' # Bas-Sassandra
    CI_10='CI-10' # Denguélé
    CI_11='CI-11' # Nzi-Comoé
    CI_12='CI-12' # Marahoué
    CI_13='CI-13' # Sud-Comoé
    CI_14='CI-14' # Worodougou
    CI_15='CI-15' # Sud-Bandama
    CI_16='CI-16' # Agnébi
    CI_17='CI-17' # Bafing
    CI_18='CI-18' # Fromager
    CI_19='CI-19' # Moyen-Cavally
    HR_01='HR-01' # Zagrebačka županija
    HR_02='HR-02' # Krapinsko-zagorska županija
    HR_03='HR-03' # Sisačko-moslavačka županija
    HR_04='HR-04' # Karlovačka županija
    HR_05='HR-05' # Varaždinska županija
    HR_06='HR-06' # Koprivničko-križevačka županija
    HR_07='HR-07' # Bjelovarsko-bilogorska županija
    HR_08='HR-08' # Primorsko-goranska županija
    HR_09='HR-09' # Ličko-senjska županija
    HR_10='HR-10' # Virovitičko-podravska županija
    HR_11='HR-11' # Požeško-slavonska županija
    HR_12='HR-12' # Brodsko-posavska županija
    HR_13='HR-13' # Zadarska županija
    HR_14='HR-14' # Osječko-baranjska županija
    HR_15='HR-15' # Šibensko-kninska županija
    HR_16='HR-16' # Vukovarsko-srijemska županija
    HR_17='HR-17' # Splitsko-dalmatinska županija
    HR_18='HR-18' # Istarska županija
    HR_19='HR-19' # Dubrovačko-neretvanska županija
    HR_20='HR-20' # Međimurska županija
    HR_21='HR-21' # Grad Zagreb
    CU_01='CU-01' # Pinar del Río
    CU_03='CU-03' # La Habana
    CU_04='CU-04' # Matanzas
    CU_05='CU-05' # Villa Clara
    CU_06='CU-06' # Cienfuegos
    CU_07='CU-07' # Sancti Spíritus
    CU_08='CU-08' # Ciego de Ávila
    CU_09='CU-09' # Camagüey
    CU_10='CU-10' # Las Tunas
    CU_11='CU-11' # Holguín
    CU_12='CU-12' # Granma
    CU_13='CU-13' # Santiago de Cuba
    CU_14='CU-14' # Guantánamo
    CU_15='CU-15' # Artemisa
    CU_16='CU-16' # Mayabeque
    CU_99='CU-99' # Isla de la Juventud
    CWCW='CW-CW' # Curaçao
    CY_01='CY-01' # Lefkoşa
    CY_02='CY-02' # Lemesos
    CY_03='CY-03' # Larnaka
    CY_04='CY-04' # Ammochostos
    CY_05='CY-05' # Baf
    CY_06='CY-06' # Girne
    CZ_101='CZ-101' # Praha 1
    CZ_102='CZ-102' # Praha 2
    CZ_103='CZ-103' # Praha 3
    CZ_104='CZ-104' # Praha 4
    CZ_105='CZ-105' # Praha 5
    CZ_106='CZ-106' # Praha 6
    CZ_107='CZ-107' # Praha 7
    CZ_108='CZ-108' # Praha 8
    CZ_109='CZ-109' # Praha 9
    CZ_10_A='CZ-10A' # Praha 10
    CZ_10_B='CZ-10B' # Praha 11
    CZ_10_C='CZ-10C' # Praha 12
    CZ_10_D='CZ-10D' # Praha 13
    CZ_10_E='CZ-10E' # Praha 14
    CZ_10_F='CZ-10F' # Praha 15
    CZ_201='CZ-201' # Benešov
    CZ_202='CZ-202' # Beroun
    CZ_203='CZ-203' # Kladno
    CZ_204='CZ-204' # Kolín
    CZ_205='CZ-205' # Kutná Hora
    CZ_206='CZ-206' # Mělník
    CZ_207='CZ-207' # Mladá Boleslav
    CZ_208='CZ-208' # Nymburk
    CZ_209='CZ-209' # Praha-východ
    CZ_20_A='CZ-20A' # Praha-západ
    CZ_20_B='CZ-20B' # Příbram
    CZ_20_C='CZ-20C' # Rakovník
    CZ_311='CZ-311' # České Budějovice
    CZ_312='CZ-312' # Český Krumlov
    CZ_313='CZ-313' # Jindřichův Hradec
    CZ_314='CZ-314' # Písek
    CZ_315='CZ-315' # Prachatice
    CZ_316='CZ-316' # Strakonice
    CZ_317='CZ-317' # Tábor
    CZ_321='CZ-321' # Domažlice
    CZ_322='CZ-322' # Klatovy
    CZ_323='CZ-323' # Plzeň-město
    CZ_324='CZ-324' # Plzeň-jih
    CZ_325='CZ-325' # Plzeň-sever
    CZ_326='CZ-326' # Rokycany
    CZ_327='CZ-327' # Tachov
    CZ_411='CZ-411' # Cheb
    CZ_412='CZ-412' # Karlovy Vary
    CZ_413='CZ-413' # Sokolov
    CZ_421='CZ-421' # Děčín
    CZ_422='CZ-422' # Chomutov
    CZ_423='CZ-423' # Litoměřice
    CZ_424='CZ-424' # Louny
    CZ_425='CZ-425' # Most
    CZ_426='CZ-426' # Teplice
    CZ_427='CZ-427' # Ústí nad Labem
    CZ_511='CZ-511' # Česká Lípa
    CZ_512='CZ-512' # Jablonec nad Nisou
    CZ_513='CZ-513' # Liberec
    CZ_514='CZ-514' # Semily
    _0_01='001' # World
    _0_02='002' # Africa
    _0_14='014' # Eastern Africa
    _0_17='017' # Middle Africa
    _0_15='015' # Northern Africa
    _0_18='018' # Southern Africa
    _0_11='011' # Western Africa
    _0_19='019' # Americas
    _4_19='419' # Latin America and the Caribbean
    _0_29='029' # Caribbean
    _0_13='013' # Central America
    _0_05='005' # South America
    _0_21='021' # Northern America a/
    _1_42='142' # Asia
    _1_43='143' # Central Asia
    _0_30='030' # Eastern Asia
    _0_34='034' # Southern Asia
    _0_35='035' # South-Eastern Asia
    _1_45='145' # Western Asia
    _1_50='150' # Europe
    _1_51='151' # Eastern Europe
    _1_54='154' # Northern Europe
    _0_39='039' # Southern Europe
    _1_55='155' # Western Europe
    _0_09='009' # Oceania
    _0_53='053' # Australia and New Zealand
    _0_54='054' # Melanesia
    _0_57='057' # Micronesia
    _0_61='061' # Polynesia


class KindEnum(str, Enum):
    INSURANCE='insurance' # Insurance
    SELFPAY='self-pay' # Self-pay
    OTHER='other' # Other


class LinkRelationTypesEnum(str, Enum):
    ABOUT='about' # Refers to a resource that is the subject of the link's context.
    ACL='acl' # Asserts that the link target provides an access control description for the link context.
    ALTERNATE='alternate' # Refers to a substitute for this context
    AMPHTML='amphtml' # Used to reference alternative content that uses the AMP profile of the HTML format.
    APPENDIX='appendix' # Refers to an appendix.
    APPLETOUCHICON='apple-touch-icon' # Refers to an icon for the context. Synonym for icon.
    APPLETOUCHSTARTUPIMAGE='apple-touch-startup-image' # Refers to a launch screen for the context.
    ARCHIVES='archives' # Refers to a collection of records, documents, or other materials of historical interest.
    AUTHOR='author' # Refers to the context's author.
    BLOCKEDBY='blocked-by' # Identifies the entity that blocks access to a resource following receipt of a legal demand.
    BOOKMARK='bookmark' # Gives a permanent link to use for bookmarking purposes.
    CANONICAL='canonical' # Designates the preferred version of a resource (the IRI and its contents).
    CHAPTER='chapter' # Refers to a chapter in a collection of resources.
    CITEAS='cite-as' # Indicates that the link target is preferred over the link context for the purpose of permanent citation.
    COLLECTION='collection' # The target IRI points to a resource which represents the collection resource for the context IRI.
    CONTENTS='contents' # Refers to a table of contents.
    CONVERTED_FROM='convertedFrom' # The document linked to was later converted to the document that contains this link relation. For example, an RFC can have a link to the Internet-Draft that became the RFC; in that case, the link relation would be "convertedFrom".
    COPYRIGHT='copyright' # Refers to a copyright statement that applies to the link's context.
    CREATEFORM='create-form' # The target IRI points to a resource where a submission form can be obtained.
    CURRENT='current' # Refers to a resource containing the most recent item(s) in a collection of resources.
    DESCRIBEDBY='describedby' # Refers to a resource providing information about the link's context.
    DESCRIBES='describes' # The relationship A 'describes' B asserts that resource A provides a description of resource B. There are no constraints on the format or representation of either A or B, neither are there any further constraints on either resource.
    DISCLOSURE='disclosure' # Refers to a list of patent disclosures made with respect to material for which 'disclosure' relation is specified.
    DNSPREFETCH='dns-prefetch' # Used to indicate an origin that will be used to fetch required resources for the link context, and that the user agent ought to resolve as early as possible.
    DUPLICATE='duplicate' # Refers to a resource whose available representations are byte-for-byte identical with the corresponding representations of the context IRI.
    EDIT='edit' # Refers to a resource that can be used to edit the link's context.
    EDITFORM='edit-form' # The target IRI points to a resource where a submission form for editing associated resource can be obtained.
    EDITMEDIA='edit-media' # Refers to a resource that can be used to edit media associated with the link's context.
    ENCLOSURE='enclosure' # Identifies a related resource that is potentially large and might require special handling.
    EXTERNAL='external' # Refers to a resource that is not part of the same site as the current context.
    FIRST='first' # An IRI that refers to the furthest preceding resource in a series of resources.
    GLOSSARY='glossary' # Refers to a glossary of terms.
    HELP='help' # Refers to context-sensitive help.
    HOSTS='hosts' # Refers to a resource hosted by the server indicated by the link context.
    HUB='hub' # Refers to a hub that enables registration for notification of updates to the context.
    ICON='icon' # Refers to an icon representing the link's context.
    INDEX='index' # Refers to an index.
    INTERVAL_AFTER='intervalAfter' # refers to a resource associated with a time interval that ends before the beginning of the time interval associated with the context resource
    INTERVAL_BEFORE='intervalBefore' # refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource
    INTERVAL_CONTAINS='intervalContains' # refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource
    INTERVAL_DISJOINT='intervalDisjoint' # refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource, or ends before the beginning of the time interval associated with the context resource
    INTERVAL_DURING='intervalDuring' # refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource
    INTERVAL_EQUALS='intervalEquals' # refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource
    INTERVAL_FINISHED_BY='intervalFinishedBy' # refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource
    INTERVAL_FINISHES='intervalFinishes' # refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource
    INTERVAL_IN='intervalIn' # refers to a resource associated with a time interval that begins before or is coincident with the beginning of the time interval associated with the context resource, and ends after or is coincident with the end of the time interval associated with the context resource
    INTERVAL_MEETS='intervalMeets' # refers to a resource associated with a time interval whose beginning coincides with the end of the time interval associated with the context resource
    INTERVAL_MET_BY='intervalMetBy' # refers to a resource associated with a time interval whose end coincides with the beginning of the time interval associated with the context resource
    INTERVAL_OVERLAPPED_BY='intervalOverlappedBy' # refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the beginning of the time interval associated with the context resource
    INTERVAL_OVERLAPS='intervalOverlaps' # refers to a resource associated with a time interval that begins before the end of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource
    INTERVAL_STARTED_BY='intervalStartedBy' # refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource
    INTERVAL_STARTS='intervalStarts' # refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource
    ITEM='item' # The target IRI points to a resource that is a member of the collection represented by the context IRI.
    LAST='last' # An IRI that refers to the furthest following resource in a series of resources.
    LATESTVERSION='latest-version' # Points to a resource containing the latest (e.g., current) version of the context.
    LICENSE='license' # Refers to a license associated with this context.
    LINKSET='linkset' # The link target of a link with the "linkset" relation type provides a set of links, including links in which the link context of the link participates.
    LRDD='lrdd' # Refers to further information about the link's context, expressed as a LRDD ("Link-based Resource Descriptor Document") resource. See for information about processing this relation type in host-meta documents. When used elsewhere, it refers to additional links and other metadata. Multiple instances indicate additional LRDD resources. LRDD resources MUST have an "application/xrd+xml" representation, and MAY have others.
    MANIFEST='manifest' # Links to a manifest file for the context.
    MASKICON='mask-icon' # Refers to a mask that can be applied to the icon for the context.
    MEDIAFEED='media-feed' # Refers to a feed of personalised media recommendations relevant to the link context.
    MEMENTO='memento' # The Target IRI points to a Memento, a fixed resource that will not change state anymore.
    MICROPUB='micropub' # Links to the context's Micropub endpoint.
    MODULEPRELOAD='modulepreload' # Refers to a module that the user agent is to preemptively fetch and store for use in the current context.
    MONITOR='monitor' # Refers to a resource that can be used to monitor changes in an HTTP resource.
    MONITORGROUP='monitor-group' # Refers to a resource that can be used to monitor changes in a specified group of HTTP resources.
    NEXT='next' # Indicates that the link's context is a part of a series, and that the next in the series is the link target.
    NEXTARCHIVE='next-archive' # Refers to the immediately following archive resource.
    NOFOLLOW='nofollow' # Indicates that the context’s original author or publisher does not endorse the link target.
    NOOPENER='noopener' # Indicates that any newly created top-level browsing context which results from following the link will not be an auxiliary browsing context.
    NOREFERRER='noreferrer' # Indicates that no referrer information is to be leaked when following the link.
    OPENER='opener' # Indicates that any newly created top-level browsing context which results from following the link will be an auxiliary browsing context.
    OPENID_2LOCAL_ID='openid2.local_id' # Refers to an OpenID Authentication server on which the context relies for an assertion that the end user controls an Identifier.
    OPENID_2PROVIDER='openid2.provider' # Refers to a resource which accepts OpenID Authentication protocol messages for the context.
    ORIGINAL='original' # The Target IRI points to an Original Resource.
    P_3_PV_1='P3Pv1' # Refers to a P3P privacy policy for the context.
    PAYMENT='payment' # Indicates a resource where payment is accepted.
    PINGBACK='pingback' # Gives the address of the pingback resource for the link context.
    PRECONNECT='preconnect' # Used to indicate an origin that will be used to fetch required resources for the link context. Initiating an early connection, which includes the DNS lookup, TCP handshake, and optional TLS negotiation, allows the user agent to mask the high latency costs of establishing a connection.
    PREDECESSORVERSION='predecessor-version' # Points to a resource containing the predecessor version in the version history.
    PREFETCH='prefetch' # The prefetch link relation type is used to identify a resource that might be required by the next navigation from the link context, and that the user agent ought to fetch, such that the user agent can deliver a faster response once the resource is requested in the future.
    PRELOAD='preload' # Refers to a resource that should be loaded early in the processing of the link's context, without blocking rendering.
    PRERENDER='prerender' # Used to identify a resource that might be required by the next navigation from the link context, and that the user agent ought to fetch and execute, such that the user agent can deliver a faster response once the resource is requested in the future.
    PREV='prev' # Indicates that the link's context is a part of a series, and that the previous in the series is the link target.
    PREVIEW='preview' # Refers to a resource that provides a preview of the link's context.
    PREVIOUS='previous' # Refers to the previous resource in an ordered series of resources. Synonym for "prev".
    PREVARCHIVE='prev-archive' # Refers to the immediately preceding archive resource.
    PRIVACYPOLICY='privacy-policy' # Refers to a privacy policy associated with the link's context.
    PROFILE='profile' # Identifying that a resource representation conforms to a certain profile, without affecting the non-profile semantics of the resource representation.
    PUBLICATION='publication' # Links to a publication manifest. A manifest represents structured information about a publication, such as informative metadata, a list of resources, and a default reading order.
    RELATED='related' # Identifies a related resource.
    RESTCONF='restconf' # Identifies the root of RESTCONF API as configured on this HTTP server. The "restconf" relation defines the root of the API defined in RFC8040. Subsequent revisions of RESTCONF will use alternate relation values to support protocol versioning.
    REPLIES='replies' # Identifies a resource that is a reply to the context of the link.
    RULEINPUT='ruleinput' # The resource identified by the link target provides an input value to an instance of a rule, where the resource which represents the rule instance is identified by the link context.
    SEARCH='search' # Refers to a resource that can be used to search through the link's context and related resources.
    SECTION='section' # Refers to a section in a collection of resources.
    SELF='self' # Conveys an identifier for the link's context.
    SERVICE='service' # Indicates a URI that can be used to retrieve a service document.
    SERVICEDESC='service-desc' # Identifies service description for the context that is primarily intended for consumption by machines.
    SERVICEDOC='service-doc' # Identifies service documentation for the context that is primarily intended for human consumption.
    SERVICEMETA='service-meta' # Identifies general metadata for the context that is primarily intended for consumption by machines.
    SPONSORED='sponsored' # Refers to a resource that is within a context that is sponsored (such as advertising or another compensation agreement).
    START='start' # Refers to the first resource in a collection of resources.
    STATUS='status' # Identifies a resource that represents the context's status.
    STYLESHEET='stylesheet' # Refers to a stylesheet.
    SUBSECTION='subsection' # Refers to a resource serving as a subsection in a collection of resources.
    SUCCESSORVERSION='successor-version' # Points to a resource containing the successor version in the version history.
    SUNSET='sunset' # Identifies a resource that provides information about the context's retirement policy.
    TAG='tag' # Gives a tag (identified by the given address) that applies to the current document.
    TERMSOFSERVICE='terms-of-service' # Refers to the terms of service associated with the link's context.
    TIMEGATE='timegate' # The Target IRI points to a TimeGate for an Original Resource.
    TIMEMAP='timemap' # The Target IRI points to a TimeMap for an Original Resource.
    TYPE='type' # Refers to a resource identifying the abstract semantic type of which the link's context is considered to be an instance.
    UGC='ugc' # Refers to a resource that is within a context that is User Generated Content.
    UP='up' # Refers to a parent document in a hierarchy of documents.
    VERSIONHISTORY='version-history' # Points to a resource containing the version history for the context.
    VIA='via' # Identifies a resource that is the source of the information in the link's context.
    WEBMENTION='webmention' # Identifies a target URI that supports the Webmention protocol. This allows clients that mention a resource in some form of publishing process to contact that endpoint and inform it that this resource has been mentioned.
    WORKINGCOPY='working-copy' # Points to a working copy for this resource.
    WORKINGCOPYOF='working-copy-of' # Points to the versioned resource from which this working copy was obtained.


class LinkTypeEnum(str, Enum):
    REPLACEDBY='replaced-by' # Replaced-byVervangen door
    REPLACES='replaces' # ReplacesVervangt
    REFER='refer' # ReferVerwijzing
    SEEALSO='seealso' # See alsoZie ook


class LinkageTypeEnum(str, Enum):
    SOURCE='source' # Source of Truth
    ALTERNATE='alternate' # Alternate Record
    HISTORICAL='historical' # Historical/Obsolete Record


class ListModeEnum(str, Enum):
    WORKING='working' # Working List
    SNAPSHOT='snapshot' # Snapshot List
    CHANGES='changes' # Change List


class ListStatusEnum(str, Enum):
    CURRENT='current' # Current
    RETIRED='retired' # Retired
    ENTEREDINERROR='entered-in-error' # Entered In Error


class LocationModeEnum(str, Enum):
    INSTANCE='instance' # Instance
    KIND='kind' # Kind


class LocationStatusEnum(str, Enum):
    ACTIVE='active' # Active
    SUSPENDED='suspended' # Suspended
    INACTIVE='inactive' # Inactive


class MeasureReportStatusEnum(str, Enum):
    COMPLETE='complete' # Complete
    PENDING='pending' # Pending
    ERROR='error' # Error


class MeasureReportTypeEnum(str, Enum):
    INDIVIDUAL='individual' # Individual
    SUBJECTLIST='subject-list' # Subject List
    SUMMARY='summary' # Summary
    DATAEXCHANGE='data-exchange' # Data Exchange


class MedicationAdministrationStatusCodesEnum(str, Enum):
    INPROGRESS='in-progress' # In Progress
    NOTDONE='not-done' # Not Done
    ONHOLD='on-hold' # On Hold
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    STOPPED='stopped' # Stopped
    UNKNOWN='unknown' # Unknown


class MedicationDispenseStatusCodesEnum(str, Enum):
    PREPARATION='preparation' # Preparation
    INPROGRESS='in-progress' # In Progress
    CANCELLED='cancelled' # Cancelled
    ONHOLD='on-hold' # On Hold
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    STOPPED='stopped' # Stopped
    DECLINED='declined' # Declined
    UNKNOWN='unknown' # Unknown


class MedicationKnowledgeStatusCodesEnum(str, Enum):
    ACTIVE='active' # Active
    ENTEREDINERROR='entered-in-error' # Entered in Error
    INACTIVE='inactive' # Inactive


class MedicationRequestIntentEnum(str, Enum):
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    ORDER='order' # Order
    ORIGINALORDER='original-order' # Original Order
    REFLEXORDER='reflex-order' # Reflex Order
    FILLERORDER='filler-order' # Filler Order
    INSTANCEORDER='instance-order' # Instance Order
    OPTION='option' # Option


class MedicationStatementStatusCodesEnum(str, Enum):
    RECORDED='recorded' # Recorded
    ENTEREDINERROR='entered-in-error' # Entered in Error
    DRAFT='draft' # Draft


class MedicationStatusCodesEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class MedicationrequestStatusEnum(str, Enum):
    ACTIVE='active' # Active
    ONHOLD='on-hold' # On Hold
    ENDED='ended' # Ended
    STOPPED='stopped' # Stopped
    COMPLETED='completed' # Completed
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    DRAFT='draft' # Draft
    UNKNOWN='unknown' # Unknown


class MessageSignificanceCategoryEnum(str, Enum):
    CONSEQUENCE='consequence' # Consequence
    CURRENCY='currency' # Currency
    NOTIFICATION='notification' # Notification


class MessageheaderResponseRequestEnum(str, Enum):
    ALWAYS='always' # Always
    ONERROR='on-error' # Error/reject conditions only
    NEVER='never' # Never
    ONSUCCESS='on-success' # Successful completion only


class NameUseEnum(str, Enum):
    USUAL='usual' # Usual
    OFFICIAL='official' # Official
    TEMP='temp' # Temp
    NICKNAME='nickname' # Nickname
    ANONYMOUS='anonymous' # Anonymous
    OLD='old' # Old
    MAIDEN='maiden' # Name changed for Marriage


class NamingSystemIdentifierTypeEnum(str, Enum):
    OID='oid' # OID
    UUID='uuid' # UUID
    URI='uri' # URI
    IRISTEM='iri-stem' # IRI stem
    V_2_CSMNEMONIC='v2csmnemonic' # V2CSMNemonic
    OTHER='other' # Other


class NamingSystemTypeEnum(str, Enum):
    CODESYSTEM='codesystem' # Code System
    IDENTIFIER='identifier' # Identifier
    ROOT='root' # Root


class NarrativeStatusEnum(str, Enum):
    GENERATED='generated' # Generated
    EXTENSIONS='extensions' # Extensions
    ADDITIONAL='additional' # Additional
    EMPTY='empty' # Empty


class NoteTypeEnum(str, Enum):
    DISPLAY='display' # Display
    PRINT='print' # Print (Form)
    PRINTOPER='printoper' # Print (Operator)


class NutritionProductStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class ObservationDataTypeEnum(str, Enum):
    QUANTITY='Quantity' # Quantity
    CODEABLE_CONCEPT='CodeableConcept' # CodeableConcept
    STRING='string' # string
    BOOLEAN='boolean' # boolean
    INTEGER='integer' # integer
    RANGE='Range' # Range
    RATIO='Ratio' # Ratio
    SAMPLED_DATA='SampledData' # SampledData
    TIME='time' # time
    DATE_TIME='dateTime' # dateTime
    PERIOD='Period' # Period


class ObservationRangeCategoryEnum(str, Enum):
    REFERENCE='reference' # reference range
    CRITICAL='critical' # critical range
    ABSOLUTE='absolute' # absolute range


class ObservationStatusEnum(str, Enum):
    REGISTERED='registered' # Registered
    PRELIMINARY='preliminary' # Preliminary
    FINAL='final' # Final
    AMENDED='amended' # Amended
    CORRECTED='corrected' # Corrected
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class OperationKindEnum(str, Enum):
    OPERATION='operation' # Operation
    QUERY='query' # Query


class OperationOutcomeCodesEnum(str, Enum):
    DELETE_MULTIPLE_MATCHES='DELETE_MULTIPLE_MATCHES' # Error: Multiple matches exist for the conditional deleteFout: er is meer dan één resultaat voor de conditionele delete
    MSG_AUTH_REQUIRED='MSG_AUTH_REQUIRED' # You must authenticate before you can use this serviceAutenticazione richiesta prima di usare questo servizioWymagana autentykacja przed użyciem tego serwisuVous devez être authentifié avant de pouvoir utiliser ce serviceU moet zich authenticeren voor gebruik van deze service使用此服务前需认证Debe autenticarse antes de poder usar este servicio
    MSG_BAD_FORMAT='MSG_BAD_FORMAT' # Bad Syntax: "%s" must be a %s'Неверный синтакс: "%s" должен быть %sSintassi Errata: "%s" deve essere un %s'Błąd składni: "%s" powinno być %s'Erreur de Syntaxe : "%s" doit être un %sVerkeerde syntax: "%s" moet een %s zijn句法错误: "%s" 必须是一个 %s'Sintaxis Incorrecta: "%s" debe de ser un %s'
    MSG_BAD_SYNTAX='MSG_BAD_SYNTAX' # Bad Syntax in %sНеверный синтакс: %sSintassi errata in %sBłąd składni w %sErreur de Syntaxe dans %sVerkeerde syntax in %s%s 中句法错误Sintaxis Incorrecta en %s
    MSG_CANT_PARSE_CONTENT='MSG_CANT_PARSE_CONTENT' # Unable to parse feed (entry content type = "%s")Impossibile effettuare il parsing del feed (tipo del contenuto della entry = "%s")Błąd parsowania (typ zawartości wejściowej = "%s")Impossible d'analyser le flux (type de contenu de l'entrée = "%s")Kan feed niet verwerken (contenttype inhoud = "%s")无法解析feed (条目的内容类型 = "%s")No se pudo parsear el feed (el tipo de contenido de la entry = "%s")
    MSG_CANT_PARSE_ROOT='MSG_CANT_PARSE_ROOT' # Unable to parse feed (root element name = "%s")Не удалось разобрать данные (корневой элемент = "%s")Impossibile effettuare il parsing del feed (nome elemento root = "%s")Błąd parsowania (nazwa elementu root = "%s")Impossible d'analyser le flux (nom de l'élément racine = "%s")Kan feed niet verwerken (rootelementnaam = "%s")无法解析feed (根元素名 = "%s")No se pudo parsear el feed (nombre del elemento raiz = "%s")
    MSG_CREATED='MSG_CREATED' # New resource createdNieuwe resource gemaakt
    MSG_DATE_FORMAT='MSG_DATE_FORMAT' # The Date value %s is not in the correct format (Xml Date Format required)Значение Date %s в неверном формате (требуется Xml Date формат)Il valore %s per la data non è nel formato corretto (richiesto il Formato Data Xml)Niepoprawny format wartości daty %s (wymagany format XML)Le format de la date %s est incorrect (format Date Xml attendu)De Datum-waarde %s heeft niet de juiste structuur (Xml Date vereist)日期的值 %s 格式不正确 (要求是Xml Date格式)El valor de la fecha %s no está en el formato correcto (se requiere un formato de fecha Xml)
    MSG_DELETED='MSG_DELETED' # This resource has been deletedДанный ресурс был удалёнQuesta risorsa è stata cancellataTen zasób został usuniętyLa ressource a été suppriméeDeze resource is verwijderd该资源已删除Este recurso ha sido borrado
    MSG_DELETED_DONE='MSG_DELETED_DONE' # Resource deletedРесурс удалёнRisorsa cancellataZasób usuniętoRessource suppriméeResource verwijderd资源已删除Recurso borrado
    MSG_DELETED_ID='MSG_DELETED_ID' # The resource "%s" has been deletedРесурс "%s" был удалёнLa risorsa "%s" è stata eliminataZasób "%s" został usuniętyLa ressource "%s" a été suppriméeDe resource "%s" is verwijderd资源 "%s" 已被删除El recurso "%s" ha sido borrado
    MSG_DUPLICATE_ID='MSG_DUPLICATE_ID' # Duplicate Id %s for resource type %sДублирующий Id %s для типа ресурса %sId %s duplicato per il tipo di risorsa %sZdublowany identyfikator %s dla zasobu typu %sId %s en double pour le type de ressource %sDuplicaat-id %s voor resourcetype %sID %s 重复（资源类型 %s）Id %s duplicada para el recurso de tipo %s
    MSG_ERROR_PARSING='MSG_ERROR_PARSING' # Error parsing resource Xml (%s)Ошибка синтаксического разбора ресурса Xml (%s)Errore nel parsing della risorsa Xml (%s)Błąd w trakcie parsowania zasobu XML (%s)Erreur d'analyse de la ressource Xml (%s)Fout in verwerking resource Xml (%s)解析资源Xml时出错 (%s)Error parseando el recurso Xml (%s)
    MSG_ID_INVALID='MSG_ID_INVALID' # Id "%s" has an invalid character "%s"Id "%s" содержит недопустимые символы "%s"L''Id "%s" ha un carattere non valido: "%s"Identyfikator "%s" zawiera niepoprawny znak "%s"Id "%s" possède un caractère invalide "%s"Id "%s" heeft een ongeldig teken "%s"ID "%s" 带有非法字符: "%s"El Id "%s" contiene el caracter inválido "%s"
    MSG_ID_TOO_LONG='MSG_ID_TOO_LONG' # Id "%s" too long (length limit 36)Недопустимая длина Id "%s" (ограничение 36)Id "%s" troppo lunga (limite di lunghezza: 36)Identyfikator "%s" jest zbyt długi (limit długości 36)Id "%s" trop long (la longueur limite est 36)Id "%s" te lang (max lengte 36)Id "%s" 过长 (长度限制: 36)El Id "%s" es demasiado largo (limite de longitud: 36)
    MSG_INVALID_ID='MSG_INVALID_ID' # Id not acceptedId не принятоId non accettatoIdentyfikator nie zaakceptowanyId non acceptéId niet geaccepteerdId不被接受Id no aceptada
    MSG_JSON_OBJECT='MSG_JSON_OBJECT' # Json Source for a resource should start with an objectJson Source для ресурса должен начинаться с объектаIl sorgente Json di una risorsa dovrebbe iniziare con un oggettoŹródło json dla zasobu powinno rozpoczynać się od obiektuLa source Json pour une ressource doit commencer par un objetJson Source van een resource moeten beginnen met een object资源的Json源应以一个object开始La fuente Json para un recurso debería empezar con un objeto
    MSG_LOCAL_FAIL='MSG_LOCAL_FAIL' # Unable to resolve local reference to resource %sНевозможно определить локальную ссылку на ресурс %sImpossibile risolvere il riferimento locale alla risorsa %sZasób wskazywany przez loklaną referencję %s nie został odnalezionyImpossible de résourdre la référence locale à la ressource %sDe resource met lokale referentie %s is niet gevonden无法解析对资源 %s 的本地引用Imposible resolver la referencia al recurso %s
    MSG_NO_EXIST='MSG_NO_EXIST' # Resource Id "%s" does not existРесурс Id "%s" не существуетLa risorsa con Id "%s" non esisteZasób o identyfikatorze "%s" nie istniejeLa ressource avec l'Id "%s" n'existe pasResource-id "%s" bestaat niet资源Id "%s"不存在El recurso con Id "%s" no existe
    MSG_NO_MATCH='MSG_NO_MATCH' # No Resource found matching the query "%s"Nessuna Risorsa soddisfa la query "%s"Geen resource gevonden met query "%s"
    MSG_NO_MODULE='MSG_NO_MODULE' # No module could be found to handle the request "%s"Модуль для обработки запроса "%s" не найденImpossibile trovare un modulo per gestire la richiesta "%s"Nie można odnaleźć modułu, aby obsłużyć żądanie "%s"Aucun module disponible pour traiter la requête "%s"Er kon geen module worden gevonden om verzoek "%s" te verwerken无法找到处理请求"%s"的模块No se encontró un modulo que gestione la petición "%s"
    MSG_NO_SUMMARY='MSG_NO_SUMMARY' # No Summary for this resourceОтсутствует Summary для данного ресурсаNessun riepilogo per questa risorsaBrak podsumowania (Summary) dla tego zasobuAucun résumé disponible pour cette ressourceGeen samenvatting voor deze resource该资源无summaryNo existe un resumen para este recurso
    MSG_OP_NOT_ALLOWED='MSG_OP_NOT_ALLOWED' # Operation %s not allowed for resource %s (due to local configuration)Операция %s недопустима для ресурса %s (по причине локальной конфигурации)Operazione %s non consentita per la risorsa %s (a causa di configurazioni locali)Niedozwolona operacja %s dla zasobu %s (ze względu na lokalną konfigurację)L'opération %s n'est pas permise pour la ressource %s (à cause de la configuration locale)Bewerking %s niet toegestaan voor resource %s (vanwege lokale configuratie)操作 %s 不允许，对于资源 %s (由于本地配置)Operación %s no permitida para el recurso %s (debido a la configuración local)
    MSG_PARAM_CHAINED='MSG_PARAM_CHAINED' # Unknown chained parameter name "%s"Неизвестое вложенное наименование параметра "%s"Nome di parametro concatenato sconosciuto: "%s"Nieznana nazwa parametru powiązanego "%s"Nom du paramètre chainé inconnu : "%s"Onbekende geschakelde parameternaam "%s"未知的链式参数名: "%s"Nombre de parametro encadenado desconocido: "%s"
    MSG_PARAM_INVALID='MSG_PARAM_INVALID' # Parameter "%s" content is invalidIl contenuto del Parametro "%s" non è validoWaarde van parameter "%s" is ongeldig
    MSG_PARAM_MODIFIER_INVALID='MSG_PARAM_MODIFIER_INVALID' # Parameter "%s" modifier is invalidModifier van parameter "%s" is ongeldig
    MSG_PARAM_NO_REPEAT='MSG_PARAM_NO_REPEAT' # Parameter "%s" is not allowed to repeatПараметр "%s" не может быть повторёнNon � consentito ripetere il parametro "%s"Parametr "%s" nie może zostać powtórzonyLe paramètre "%s" ne peut pas être répétéParameter "%s" mag niet herhalen参数"%s"不可重复No se permite la repetición del parámetro "%s"
    MSG_PARAM_UNKNOWN='MSG_PARAM_UNKNOWN' # Parameter "%s" not understoodПараметр "%s" не понятParametro "%s" non riconosciutoNiezrozumiały parametr "%s"Paramètre "%s" non reconnuParameter "%s" onbekend无法理解参数"%s"Parámetro "%s" no reconocido
    MSG_REMOTE_FAIL='MSG_REMOTE_FAIL' # Unable to resolve local reference to resource %s
    MSG_RESOURCE_EXAMPLE_PROTECTED='MSG_RESOURCE_EXAMPLE_PROTECTED' # Resources with identity "example" cannot be deleted (for testing/training purposes)Ресурс с идентификатором "example" не может быть удалён (для случаев тестирования/обучения)Le Risorse aventi l'identità "example" non possono essere cancellate (per finalità di test/formazione)Zasoby oznaczone jako "example" nie mogą zostać usunięte (dla celów testów/szkoleń)Les ressources ayant l'identité "example" ne peuvent pas être supprimées (utilisées pour les tests/formations)Resources met identiteit "voorbeeld" kunnen niet worden verwijderd (ten behoeve van testen/training)以"example" 为ID的资源不能被删除 (用于测试/培训)Recursos con la identidad "example" no pueden ser borrados (son usados para pruebas/entrenamiento)
    MSG_RESOURCE_ID_FAIL='MSG_RESOURCE_ID_FAIL' # unable to allocate resource idневозможно выделить идентификатор ресурсаimpossibile allocare l''id della risorsanie można nadać identyfikatora zasobuimpossible d'allouer l'id de la ressourcekan geen resource-id reserveren无法分配资源IDimposible encontrar el id del recurso
    MSG_RESOURCE_ID_MISMATCH='MSG_RESOURCE_ID_MISMATCH' # Resource Id MismatchProblème de correspondance d'Id de la RessourceResource ID's komen niet overeen
    MSG_RESOURCE_ID_MISSING='MSG_RESOURCE_ID_MISSING' # Resource Id MissingId della Risorsa mancanteId de la Ressource manquanteResource ID ontbreekt
    MSG_RESOURCE_NOT_ALLOWED='MSG_RESOURCE_NOT_ALLOWED' # Not allowed to submit a resource for this operationДля данной операции отправка ресурса недопустимаNon è consentito sottomettere una risorsa per questa operazioneNie można zgłosić zasobu dla tej operacjiNon autorisé à soumettre une ressource pour cette opérationNiet toegestaan om een resource in te dienen voor deze bewerking该操作不允许提交资源No se permite el envío de un recurso para esta operación
    MSG_RESOURCE_REQUIRED='MSG_RESOURCE_REQUIRED' # A resource is requiredТребуется ресурсE'' richiesta una risorsaZasób jest wymaganyUne ressource est requiseEen resource is verplicht必须提供一个资源Se requiere un recurso
    MSG_RESOURCE_TYPE_MISMATCH='MSG_RESOURCE_TYPE_MISMATCH' # Resource Type MismatchНесоответствие типа ресурсаTipo Risorsa non corrispondenteNiepoprawny typ zasobuType de ressource incorrectVerkeerd resourcetype资源类型不匹配Los Tipos de los recursos no coinciden
    MSG_SORT_UNKNOWN='MSG_SORT_UNKNOWN' # Unknown sort parameter name "%s"Неизвестное имя параметра сортировки "%s"Nome del parametro di ordinamento "%s" non riconosciutoNieznany parametr sortowania "%s"Nom du paramètre de tri inconnu "%s"Onbekende parameternaam "%s" voor sortering未知的排序参数名称"%s"Nombre del parámetro de ordenación "%s" desconocido
    MSG_TRANSACTION_DUPLICATE_ID='MSG_TRANSACTION_DUPLICATE_ID' # Duplicate Identifier in transaction: %sДублирующий идентификатор в транзакции: %sZdublowany identyfikator w transakcji: %sIdentifiant en double dans la transaction : %sDubbele identificatie in transactie: %s事务中存在重复Id: %sIdentificador duplicado en la transacción: %s
    MSG_TRANSACTION_MISSING_ID='MSG_TRANSACTION_MISSING_ID' # Missing Identifier in transaction - an entry.id must be providedОтсутствует идентификатор в транзакции - требуется entry.idBrak identyfikatora w transakcji - należy podać entry.idIdentifiant manquant dans la transaction - un élément entry.id doit être fourniOntbrekende identificatie in transactie - entry.id is verplicht事务中缺少Id - 必须提供一个entry.idIdentificador de la transacción no encontrado - se debe proporcionar un entry.id
    MSG_UNHANDLED_NODE_TYPE='MSG_UNHANDLED_NODE_TYPE' # Unhandled xml node type "%s"Не обработанный xml узел "%s"Tipo di nodo Xml non gestito "%s"Nieobsługiwany typ węzła XML "%s"Type de noeud xml "%s" non traitéKan xml nodetype "%s" niet verwerken未处理的XML节点类型"%s"Tipo de nodo Xml no soportado "%s"
    MSG_UNKNOWN_CONTENT='MSG_UNKNOWN_CONTENT' # Unknown Content (%s) at %sНеизвестный контент (%s) в %sContenuto Sconosciuto (%s) at %sNieznana zawartość (%s) dla %sContenu inconnu (%s) à %sOnbekende content (%s) at %s未知内容 (%s) 位于 %sContenido desconocido (%s) en %s
    MSG_UNKNOWN_OPERATION='MSG_UNKNOWN_OPERATION' # unknown FHIR http operationнеизвестная операция FHIR httpoperazione http FHIR sconosciutanieznana operacja FHIR httpoperation http FHIR inconnueonbekende FHIR http operation未知的FHIR HTTP操作Operación http FHIR desconocida
    MSG_UNKNOWN_TYPE='MSG_UNKNOWN_TYPE' # Resource Type "%s" not recognisedТип ресурса "%s" не распознанTipo di Risorsa "%s" non riconosciutoNie rozpoznany typ zasobu: "%s"Type de ressource "%s" non reconnuResourcetype "%s" niet herkend资源类型"%s"未识别Tipo de Recurso "%s" no reconocido
    MSG_UPDATED='MSG_UPDATED' # existing resource updatedсуществующий ресурс обновлёнrisorsa esistente aggiornatauaktualniono istniejący zasóbressource existante mise à jourbestaande resource updated已有资源被更新Recurso existente actualizado
    MSG_VERSION_AWARE='MSG_VERSION_AWARE' # Version aware updates are required for this resourceДля данного ресурса необходимы обновления с учётом версииQuesta risorsa richiede aggiornamenti per versioneUaktualnienia zakładające wersjonowanie są wymagane dla tego zasobuDes mises à jour en relation avec la version sont requises pour cette ressourceVersie-bewuste updates zijn vereist voor deze resource该资源的更新必须针对版本Este recurso requiere actualizaciones en base a versiones
    MSG_VERSION_AWARE_CONFLICT='MSG_VERSION_AWARE_CONFLICT' # Update Conflict (server current version = "%s", client version referenced = "%s")Конфликт обновления (текущая версия сервера = "%s", указанная версия клиента = "%s")Conflitto nell''aggiornamento (attuale = "%s", quotato = "%s")Konflikt podczas uaktualnienia (obecna wersja na serwerze = "%s", wersja wskazana przez klienta = "%s")Conflit de mise à jour (version courante du serveur = "%s", version référencée du client = "%s")Updateconflict (huidige serverversie = "%s", opgegeven clientversie = "%s")更新冲突 (服务器当前版本 = "%s", 客户端引用的版本 = "%s")Conflicto de actualizaciones (versión actual del servidor = "%s", versión del cliente referenciada = "%s")
    MSG_VERSION_AWARE_URL='MSG_VERSION_AWARE_URL' # Version specific URL not recognisedURL для указанной версии не распознанURL specifico alla versione non riconosciutoNie rozpoznany URL specyficzny dla wersjiURL spécifique à une version non reconnueVersie-specifieke URL niet herkend未识别特定版本的URLURL especifica de la versión no reconocida
    MSG_WRONG_NS='MSG_WRONG_NS' # This does not appear to be a FHIR element or resource (wrong namespace "%s")Dit lijkt geen FHIR element of resource te zijn (verkeerde namespace "%s")
    SEARCH_MULTIPLE='SEARCH_MULTIPLE' # Error: Multiple matches exist for %s search parameters "%s"Ошибка: множественные совпадения для %s с параметрами поиска "%s"Errore: Trovate corrispondenze multiple per %s parametri di ricerca "%s"Błąd: Istnieją wielokrotne dopasowania dla %s parametrów wyszukiwania "%s"Erreur : Plusieurs correspondances existent pour ce paramètre de recherche %sFout: er is meer dan één resultaat voor %s zoekparameters "%s"错误: 对于 %s 搜索的参数 "%s"存在多个匹配Error: Multiples ocurrencias existen para %s parametros de búsqueda "%s"
    SEARCH_NONE='SEARCH_NONE' # Error: no processable search found for %s search parameters "%s"Ошибка: обрабатываемых результатов поиска для %s с параметрами поиска "%s" не найденоErrore: non è stato trovato alcun parametro di ricerca processabile per %s parametri di ricerca "%s"Błąd: Niewykonalne wyszukiwanie dla %s parametrów wyszukiwania "%s"Erreur : aucune recherche trouvée pour les paramètres %s "%s"Fout: geen verwerkbare zoekactie gevonden voor %s zoekparameters "%s"错误: 对%s搜索参数"%s"未找到可处理的搜索Error: no se encontro una búsqueda apropiada para %s parametros de búsqueda "%s"
    UPDATE_MULTIPLE_MATCHES='UPDATE_MULTIPLE_MATCHES' # Error: Multiple matches exist for the conditional updateFout: er is meer dan één resultaat voor de conditionele update


class OperationParameterScopeEnum(str, Enum):
    INSTANCE='instance' # Instance
    TYPE='type' # Type
    SYSTEM='system' # System


class OperationParameterUseEnum(str, Enum):
    IN='in' # In
    OUT='out' # Out


class OrientationTypeEnum(str, Enum):
    SENSE='sense' # Sense orientation of referenceSeq
    ANTISENSE='antisense' # Antisense orientation of referenceSeq


class ParticipantResourceTypesEnum(str, Enum):
    CARE_TEAM='CareTeam' # CareTeam
    DEVICE='Device' # Device
    GROUP='Group' # Group
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareService
    LOCATION='Location' # Location
    ORGANIZATION='Organization' # Organization
    PATIENT='Patient' # Patient
    PRACTITIONER='Practitioner' # Practitioner
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRole
    RELATED_PERSON='RelatedPerson' # RelatedPerson


class ParticipationStatusEnum(str, Enum):
    ACCEPTED='accepted' # Accepted
    DECLINED='declined' # Declined
    TENTATIVE='tentative' # Tentative
    NEEDSACTION='needs-action' # Needs Action


class PaymentOutcomeEnum(str, Enum):
    QUEUED='queued' # Queued
    COMPLETE='complete' # Processing Complete
    ERROR='error' # Error
    PARTIAL='partial' # Partial Processing


class PermissionRuleCombiningEnum(str, Enum):
    DENYOVERRIDES='deny-overrides' # Deny-overrides
    PERMITOVERRIDES='permit-overrides' # Permit-overrides
    ORDEREDDENYOVERRIDES='ordered-deny-overrides' # Ordered-deny-overrides
    ORDEREDPERMITOVERRIDES='ordered-permit-overrides' # Ordered-permit-overrides
    DENYUNLESSPERMIT='deny-unless-permit' # Deny-unless-permit
    PERMITUNLESSDENY='permit-unless-deny' # Permit-unless-deny


class PermissionStatusEnum(str, Enum):
    ACTIVE='active' # Active
    ENTEREDINERROR='entered-in-error' # Entered in Error
    DRAFT='draft' # Draft
    REJECTED='rejected' # Rejected


class PropertyRepresentationEnum(str, Enum):
    XML_ATTR='xmlAttr' # XML Attribute
    XML_TEXT='xmlText' # XML Text
    TYPE_ATTR='typeAttr' # Type Attribute
    CDA_TEXT='cdaText' # CDA Text Format
    XHTML='xhtml' # XHTML


class PropertyTypeEnum(str, Enum):
    CODE='code' # code (internal reference)
    CODING='Coding' # Coding (external reference)
    STRING='string' # string
    INTEGER='integer' # integer
    BOOLEAN='boolean' # boolean
    DATE_TIME='dateTime' # dateTime
    DECIMAL='decimal' # decimal


class ProvenanceEntityRoleEnum(str, Enum):
    REVISION='revision' # Revision
    QUOTATION='quotation' # Quotation
    SOURCE='source' # Source
    INSTANTIATES='instantiates' # Instantiates
    REMOVAL='removal' # Removal


class PublicationStatusEnum(str, Enum):
    DRAFT='draft' # Draftчерновикontwerp
    ACTIVE='active' # Activeактивныйactief
    RETIRED='retired' # Retiredудалёнverouderd
    UNKNOWN='unknown' # Unknown


class QuantityComparatorEnum(str, Enum):
    _='<' # Less than
    __1='<=' # Less or Equal to
    __2='>=' # Greater or Equal to
    __3='>' # Greater than
    AD='ad' # Sufficient to achieve this total quantity


class QuestionnaireAnswerConstraintEnum(str, Enum):
    OPTIONS_ONLY='optionsOnly' # Options only
    OPTIONS_OR_TYPE='optionsOrType' # Options or 'type'
    OPTIONS_OR_STRING='optionsOrString' # Options or string


class QuestionnaireItemDisabledDisplayEnum(str, Enum):
    HIDDEN='hidden' # Hidden
    PROTECTED='protected' # Protected


class QuestionnaireItemOperatorEnum(str, Enum):
    EXISTS='exists' # Exists
    _='=' # Equals
    __1='!=' # Not Equals
    __2='>' # Greater Than
    __3='<' # Less Than
    __4='>=' # Greater or Equals
    __5='<=' # Less or Equals


class QuestionnaireItemTypeEnum(str, Enum):
    GROUP='group' # Group
    DISPLAY='display' # Display
    QUESTION='question' # Question
    BOOLEAN='boolean' # Boolean
    DECIMAL='decimal' # Decimal
    INTEGER='integer' # Integer
    DATE='date' # Date
    DATE_TIME='dateTime' # Date Time
    TIME='time' # Time
    STRING='string' # String
    TEXT='text' # Text
    URL='url' # Url
    CODING='coding' # Coding
    ATTACHMENT='attachment' # Attachment
    REFERENCE='reference' # Reference
    QUANTITY='quantity' # Quantity


class QuestionnaireResponseStatusEnum(str, Enum):
    INPROGRESS='in-progress' # In Progress
    COMPLETED='completed' # Completed
    AMENDED='amended' # Amended
    ENTEREDINERROR='entered-in-error' # Entered in Error
    STOPPED='stopped' # Stopped


class ReferenceHandlingPolicyEnum(str, Enum):
    LITERAL='literal' # Literal References
    LOGICAL='logical' # Logical References
    RESOLVES='resolves' # Resolves References
    ENFORCED='enforced' # Reference Integrity Enforced
    LOCAL='local' # Local References Only


class ReferenceVersionRulesEnum(str, Enum):
    EITHER='either' # Either Specific or independent
    INDEPENDENT='independent' # Version independent
    SPECIFIC='specific' # Version Specific


class RelatedArtifactTypeEnum(str, Enum):
    DOCUMENTATION='documentation' # Documentation
    JUSTIFICATION='justification' # Justification
    CITATION='citation' # Citation
    PREDECESSOR='predecessor' # Predecessor
    SUCCESSOR='successor' # Successor
    DERIVEDFROM='derived-from' # Derived From
    DEPENDSON='depends-on' # Depends On
    COMPOSEDOF='composed-of' # Composed Of
    PARTOF='part-of' # Part Of
    AMENDS='amends' # Amends
    AMENDEDWITH='amended-with' # Amended With
    APPENDS='appends' # Appends
    APPENDEDWITH='appended-with' # Appended With
    CITES='cites' # Cites
    CITEDBY='cited-by' # Cited By
    COMMENTSON='comments-on' # Is Comment On
    COMMENTIN='comment-in' # Has Comment In
    CONTAINS='contains' # Contains
    CONTAINEDIN='contained-in' # Contained In
    CORRECTS='corrects' # Corrects
    CORRECTIONIN='correction-in' # Correction In
    REPLACES='replaces' # Replaces
    REPLACEDWITH='replaced-with' # Replaced With
    RETRACTS='retracts' # Retracts
    RETRACTEDBY='retracted-by' # Retracted By
    SIGNS='signs' # Signs
    SIMILARTO='similar-to' # Similar To
    SUPPORTS='supports' # Supports
    SUPPORTEDWITH='supported-with' # Supported With
    TRANSFORMS='transforms' # Transforms
    TRANSFORMEDINTO='transformed-into' # Transformed Into
    TRANSFORMEDWITH='transformed-with' # Transformed With
    DOCUMENTS='documents' # Documents
    SPECIFICATIONOF='specification-of' # Specification Of
    CREATEDWITH='created-with' # Created With
    CITEAS='cite-as' # Cite As


class RelatedArtifactTypeExpandedEnum(str, Enum):
    DOCUMENTATION='documentation' # Documentation
    JUSTIFICATION='justification' # Justification
    CITATION='citation' # Citation
    PREDECESSOR='predecessor' # Predecessor
    SUCCESSOR='successor' # Successor
    DERIVEDFROM='derived-from' # Derived From
    DEPENDSON='depends-on' # Depends On
    COMPOSEDOF='composed-of' # Composed Of
    PARTOF='part-of' # Part Of
    AMENDS='amends' # Amends
    AMENDEDWITH='amended-with' # Amended With
    APPENDS='appends' # Appends
    APPENDEDWITH='appended-with' # Appended With
    CITES='cites' # Cites
    CITEDBY='cited-by' # Cited By
    COMMENTSON='comments-on' # Is Comment On
    COMMENTIN='comment-in' # Has Comment In
    CONTAINS='contains' # Contains
    CONTAINEDIN='contained-in' # Contained In
    CORRECTS='corrects' # Corrects
    CORRECTIONIN='correction-in' # Correction In
    REPLACES='replaces' # Replaces
    REPLACEDWITH='replaced-with' # Replaced With
    RETRACTS='retracts' # Retracts
    RETRACTEDBY='retracted-by' # Retracted By
    SIGNS='signs' # Signs
    SIMILARTO='similar-to' # Similar To
    SUPPORTS='supports' # Supports
    SUPPORTEDWITH='supported-with' # Supported With
    TRANSFORMS='transforms' # Transforms
    TRANSFORMEDINTO='transformed-into' # Transformed Into
    TRANSFORMEDWITH='transformed-with' # Transformed With
    DOCUMENTS='documents' # Documents
    SPECIFICATIONOF='specification-of' # Specification Of
    CREATEDWITH='created-with' # Created With
    CITEAS='cite-as' # Cite As
    REPRINT='reprint' # Reprint
    REPRINTOF='reprint-of' # Reprint Of


class RemittanceOutcomeEnum(str, Enum):
    COMPLETE='complete' # Complete
    ERROR='error' # Error
    PARTIAL='partial' # Partial


class ReportRelationshipTypeEnum(str, Enum):
    REPLACES='replaces' # Replaces
    AMENDS='amends' # Amends
    APPENDS='appends' # Appends
    TRANSFORMS='transforms' # Transforms
    REPLACED_WITH='replacedWith' # Replaced With
    AMENDED_WITH='amendedWith' # Amended With
    APPENDED_WITH='appendedWith' # Appended With
    TRANSFORMED_WITH='transformedWith' # Transformed With


class RequestIntentEnum(str, Enum):
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    DIRECTIVE='directive' # Directive
    ORDER='order' # Order
    ORIGINALORDER='original-order' # Original Order
    REFLEXORDER='reflex-order' # Reflex Order
    FILLERORDER='filler-order' # Filler Order
    INSTANCEORDER='instance-order' # Instance Order
    OPTION='option' # Option


class RequestPriorityEnum(str, Enum):
    ROUTINE='routine' # Routine
    URGENT='urgent' # Urgent
    ASAP='asap' # ASAP
    STAT='stat' # STAT


class RequestResourceTypesEnum(str, Enum):
    APPOINTMENT='Appointment' # Appointment
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponse
    CARE_PLAN='CarePlan' # CarePlan
    CLAIM='Claim' # Claim
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequest
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequest
    DEVICE_REQUEST='DeviceRequest' # DeviceRequest
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequest
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendation
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequest
    NUTRITION_ORDER='NutritionOrder' # NutritionOrder
    REQUEST_ORCHESTRATION='RequestOrchestration' # RequestOrchestration
    SERVICE_REQUEST='ServiceRequest' # ServiceRequest
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequest
    TASK='Task' # Task
    TRANSPORT='Transport' # Transport
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescription


class RequestStatusEnum(str, Enum):
    DRAFT='draft' # Draft
    ACTIVE='active' # Active
    ONHOLD='on-hold' # On Hold
    REVOKED='revoked' # Revoked
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class ResourceTypeEnum(str, Enum):
    ACCOUNT='Account' # Account
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinition
    ACTOR_DEFINITION='ActorDefinition' # ActorDefinition
    ADMINISTRABLE_PRODUCT_DEFINITION='AdministrableProductDefinition' # AdministrableProductDefinition
    ADVERSE_EVENT='AdverseEvent' # AdverseEvent
    ALLERGY_INTOLERANCE='AllergyIntolerance' # AllergyIntolerance
    APPOINTMENT='Appointment' # Appointment
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponse
    ARTIFACT_ASSESSMENT='ArtifactAssessment' # ArtifactAssessment
    AUDIT_EVENT='AuditEvent' # AuditEvent
    BASIC='Basic' # Basic
    BINARY='Binary' # Binary
    BIOLOGICALLY_DERIVED_PRODUCT='BiologicallyDerivedProduct' # BiologicallyDerivedProduct
    BIOLOGICALLY_DERIVED_PRODUCT_DISPENSE='BiologicallyDerivedProductDispense' # BiologicallyDerivedProductDispense
    BODY_STRUCTURE='BodyStructure' # BodyStructure
    BUNDLE='Bundle' # Bundle
    CAPABILITY_STATEMENT='CapabilityStatement' # CapabilityStatement
    CARE_PLAN='CarePlan' # CarePlan
    CARE_TEAM='CareTeam' # CareTeam
    CHARGE_ITEM='ChargeItem' # ChargeItem
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CITATION='Citation' # Citation
    CLAIM='Claim' # Claim
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponse
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpression
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    CODE_SYSTEM='CodeSystem' # CodeSystem
    COMMUNICATION='Communication' # Communication
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequest
    COMPARTMENT_DEFINITION='CompartmentDefinition' # CompartmentDefinition
    COMPOSITION='Composition' # Composition
    CONCEPT_MAP='ConceptMap' # ConceptMap
    CONDITION='Condition' # Condition
    CONDITION_DEFINITION='ConditionDefinition' # ConditionDefinition
    CONSENT='Consent' # Consent
    CONTRACT='Contract' # Contract
    COVERAGE='Coverage' # Coverage
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequest
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponse
    DETECTED_ISSUE='DetectedIssue' # DetectedIssue
    DEVICE='Device' # Device
    DEVICE_ASSOCIATION='DeviceAssociation' # DeviceAssociation
    DEVICE_DEFINITION='DeviceDefinition' # DeviceDefinition
    DEVICE_DISPENSE='DeviceDispense' # DeviceDispense
    DEVICE_METRIC='DeviceMetric' # DeviceMetric
    DEVICE_REQUEST='DeviceRequest' # DeviceRequest
    DEVICE_USAGE='DeviceUsage' # DeviceUsage
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReport
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReference
    ENCOUNTER='Encounter' # Encounter
    ENCOUNTER_HISTORY='EncounterHistory' # EncounterHistory
    ENDPOINT='Endpoint' # Endpoint
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequest
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponse
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare
    EVENT_DEFINITION='EventDefinition' # EventDefinition
    EVIDENCE='Evidence' # Evidence
    EVIDENCE_REPORT='EvidenceReport' # EvidenceReport
    EVIDENCE_VARIABLE='EvidenceVariable' # EvidenceVariable
    EXAMPLE_SCENARIO='ExampleScenario' # ExampleScenario
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefit
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistory
    FLAG='Flag' # Flag
    FORMULARY_ITEM='FormularyItem' # FormularyItem
    GENOMIC_STUDY='GenomicStudy' # GenomicStudy
    GOAL='Goal' # Goal
    GRAPH_DEFINITION='GraphDefinition' # GraphDefinition
    GROUP='Group' # Group
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponse
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareService
    IMAGING_SELECTION='ImagingSelection' # ImagingSelection
    IMAGING_STUDY='ImagingStudy' # ImagingStudy
    IMMUNIZATION='Immunization' # Immunization
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendation
    IMPLEMENTATION_GUIDE='ImplementationGuide' # ImplementationGuide
    INGREDIENT='Ingredient' # Ingredient
    INSURANCE_PLAN='InsurancePlan' # InsurancePlan
    INVENTORY_ITEM='InventoryItem' # InventoryItem
    INVENTORY_REPORT='InventoryReport' # InventoryReport
    INVOICE='Invoice' # Invoice
    LIBRARY='Library' # Library
    LINKAGE='Linkage' # Linkage
    LIST='List' # List
    LOCATION='Location' # Location
    MANUFACTURED_ITEM_DEFINITION='ManufacturedItemDefinition' # ManufacturedItemDefinition
    MEASURE='Measure' # Measure
    MEASURE_REPORT='MeasureReport' # MeasureReport
    MEDICATION='Medication' # Medication
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministration
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispense
    MEDICATION_KNOWLEDGE='MedicationKnowledge' # MedicationKnowledge
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequest
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatement
    MEDICINAL_PRODUCT_DEFINITION='MedicinalProductDefinition' # MedicinalProductDefinition
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinition
    MESSAGE_HEADER='MessageHeader' # MessageHeader
    MOLECULAR_SEQUENCE='MolecularSequence' # MolecularSequence
    NAMING_SYSTEM='NamingSystem' # NamingSystem
    NUTRITION_INTAKE='NutritionIntake' # NutritionIntake
    NUTRITION_ORDER='NutritionOrder' # NutritionOrder
    NUTRITION_PRODUCT='NutritionProduct' # NutritionProduct
    OBSERVATION='Observation' # Observation
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinition
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinition
    OPERATION_OUTCOME='OperationOutcome' # OperationOutcome
    ORGANIZATION='Organization' # Organization
    ORGANIZATION_AFFILIATION='OrganizationAffiliation' # OrganizationAffiliation
    PACKAGED_PRODUCT_DEFINITION='PackagedProductDefinition' # PackagedProductDefinition
    PARAMETERS='Parameters' # Parameters
    PATIENT='Patient' # Patient
    PAYMENT_NOTICE='PaymentNotice' # PaymentNotice
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliation
    PERMISSION='Permission' # Permission
    PERSON='Person' # Person
    PLAN_DEFINITION='PlanDefinition' # PlanDefinition
    PRACTITIONER='Practitioner' # Practitioner
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRole
    PROCEDURE='Procedure' # Procedure
    PROVENANCE='Provenance' # Provenance
    QUESTIONNAIRE='Questionnaire' # Questionnaire
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponse
    REGULATED_AUTHORIZATION='RegulatedAuthorization' # RegulatedAuthorization
    RELATED_PERSON='RelatedPerson' # RelatedPerson
    REQUEST_ORCHESTRATION='RequestOrchestration' # RequestOrchestration
    REQUIREMENTS='Requirements' # Requirements
    RESEARCH_STUDY='ResearchStudy' # ResearchStudy
    RESEARCH_SUBJECT='ResearchSubject' # ResearchSubject
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessment
    SCHEDULE='Schedule' # Schedule
    SEARCH_PARAMETER='SearchParameter' # SearchParameter
    SERVICE_REQUEST='ServiceRequest' # ServiceRequest
    SLOT='Slot' # Slot
    SPECIMEN='Specimen' # Specimen
    SPECIMEN_DEFINITION='SpecimenDefinition' # SpecimenDefinition
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinition
    STRUCTURE_MAP='StructureMap' # StructureMap
    SUBSCRIPTION='Subscription' # Subscription
    SUBSCRIPTION_STATUS='SubscriptionStatus' # SubscriptionStatus
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    SUBSTANCE='Substance' # Substance
    SUBSTANCE_DEFINITION='SubstanceDefinition' # SubstanceDefinition
    SUBSTANCE_NUCLEIC_ACID='SubstanceNucleicAcid' # SubstanceNucleicAcid
    SUBSTANCE_POLYMER='SubstancePolymer' # SubstancePolymer
    SUBSTANCE_PROTEIN='SubstanceProtein' # SubstanceProtein
    SUBSTANCE_REFERENCE_INFORMATION='SubstanceReferenceInformation' # SubstanceReferenceInformation
    SUBSTANCE_SOURCE_MATERIAL='SubstanceSourceMaterial' # SubstanceSourceMaterial
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDelivery
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequest
    TASK='Task' # Task
    TERMINOLOGY_CAPABILITIES='TerminologyCapabilities' # TerminologyCapabilities
    TEST_PLAN='TestPlan' # TestPlan
    TEST_REPORT='TestReport' # TestReport
    TEST_SCRIPT='TestScript' # TestScript
    TRANSPORT='Transport' # Transport
    VALUE_SET='ValueSet' # ValueSet
    VERIFICATION_RESULT='VerificationResult' # VerificationResult
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescription


class ResourceVersionPolicyEnum(str, Enum):
    NOVERSION='no-version' # No VersionId Support
    VERSIONED='versioned' # Versioned
    VERSIONEDUPDATE='versioned-update' # VersionId tracked fully


class ResponseTypeEnum(str, Enum):
    OK='ok' # OK
    TRANSIENTERROR='transient-error' # Transient Error
    FATALERROR='fatal-error' # Fatal Error


class RestfulCapabilityModeEnum(str, Enum):
    CLIENT='client' # Client
    SERVER='server' # Server


class SPDXLicenseEnum(str, Enum):
    NOTOPENSOURCE='not-open-source' # Not open source
    _0_BSD='0BSD' # BSD Zero Clause License
    AAL='AAL' # Attribution Assurance License
    ABSTYLES='Abstyles' # Abstyles License
    ADOBE_2006='Adobe-2006' # Adobe Systems Incorporated Source Code License Agreement
    ADOBE_GLYPH='Adobe-Glyph' # Adobe Glyph List License
    ADSL='ADSL' # Amazon Digital Services License
    AFL_1_1='AFL-1.1' # Academic Free License v1.1
    AFL_1_2='AFL-1.2' # Academic Free License v1.2
    AFL_2_0='AFL-2.0' # Academic Free License v2.0
    AFL_2_1='AFL-2.1' # Academic Free License v2.1
    AFL_3_0='AFL-3.0' # Academic Free License v3.0
    AFMPARSE='Afmparse' # Afmparse License
    AGPL_1_0ONLY='AGPL-1.0-only' # Affero General Public License v1.0 only
    AGPL_1_0ORLATER='AGPL-1.0-or-later' # Affero General Public License v1.0 or later
    AGPL_3_0ONLY='AGPL-3.0-only' # GNU Affero General Public License v3.0 only
    AGPL_3_0ORLATER='AGPL-3.0-or-later' # GNU Affero General Public License v3.0 or later
    ALADDIN='Aladdin' # Aladdin Free Public License
    AMDPLPA='AMDPLPA' # AMD's plpa_map.c License
    AML='AML' # Apple MIT License
    AMPAS='AMPAS' # Academy of Motion Picture Arts and Sciences BSD
    ANTLRPD='ANTLR-PD' # ANTLR Software Rights Notice
    APACHE_1_0='Apache-1.0' # Apache License 1.0
    APACHE_1_1='Apache-1.1' # Apache License 1.1
    APACHE_2_0='Apache-2.0' # Apache License 2.0
    APAFML='APAFML' # Adobe Postscript AFM License
    APL_1_0='APL-1.0' # Adaptive Public License 1.0
    APSL_1_0='APSL-1.0' # Apple Public Source License 1.0
    APSL_1_1='APSL-1.1' # Apple Public Source License 1.1
    APSL_1_2='APSL-1.2' # Apple Public Source License 1.2
    APSL_2_0='APSL-2.0' # Apple Public Source License 2.0
    ARTISTIC_1_0CL_8='Artistic-1.0-cl8' # Artistic License 1.0 w/clause 8
    ARTISTIC_1_0_PERL='Artistic-1.0-Perl' # Artistic License 1.0 (Perl)
    ARTISTIC_1_0='Artistic-1.0' # Artistic License 1.0
    ARTISTIC_2_0='Artistic-2.0' # Artistic License 2.0
    BAHYPH='Bahyph' # Bahyph License
    BARR='Barr' # Barr License
    BEERWARE='Beerware' # Beerware License
    BIT_TORRENT_1_0='BitTorrent-1.0' # BitTorrent Open Source License v1.0
    BIT_TORRENT_1_1='BitTorrent-1.1' # BitTorrent Open Source License v1.1
    BORCEUX='Borceux' # Borceux license
    BSD_1_CLAUSE='BSD-1-Clause' # BSD 1-Clause License
    BSD_2_CLAUSE_FREE_BSD='BSD-2-Clause-FreeBSD' # BSD 2-Clause FreeBSD License
    BSD_2_CLAUSE_NET_BSD='BSD-2-Clause-NetBSD' # BSD 2-Clause NetBSD License
    BSD_2_CLAUSE_PATENT='BSD-2-Clause-Patent' # BSD-2-Clause Plus Patent License
    BSD_2_CLAUSE='BSD-2-Clause' # BSD 2-Clause "Simplified" License
    BSD_3_CLAUSE_ATTRIBUTION='BSD-3-Clause-Attribution' # BSD with attribution
    BSD_3_CLAUSE_CLEAR='BSD-3-Clause-Clear' # BSD 3-Clause Clear License
    BSD_3_CLAUSELBNL='BSD-3-Clause-LBNL' # Lawrence Berkeley National Labs BSD variant license
    BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014='BSD-3-Clause-No-Nuclear-License-2014' # BSD 3-Clause No Nuclear License 2014
    BSD_3_CLAUSE_NO_NUCLEAR_LICENSE='BSD-3-Clause-No-Nuclear-License' # BSD 3-Clause No Nuclear License
    BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY='BSD-3-Clause-No-Nuclear-Warranty' # BSD 3-Clause No Nuclear Warranty
    BSD_3_CLAUSE='BSD-3-Clause' # BSD 3-Clause "New" or "Revised" License
    BSD_4_CLAUSEUC='BSD-4-Clause-UC' # BSD-4-Clause (University of California-Specific)
    BSD_4_CLAUSE='BSD-4-Clause' # BSD 4-Clause "Original" or "Old" License
    BSD_PROTECTION='BSD-Protection' # BSD Protection License
    BSD_SOURCE_CODE='BSD-Source-Code' # BSD Source Code Attribution
    BSL_1_0='BSL-1.0' # Boost Software License 1.0
    BZIP_2_1_0_5='bzip2-1.0.5' # bzip2 and libbzip2 License v1.0.5
    BZIP_2_1_0_6='bzip2-1.0.6' # bzip2 and libbzip2 License v1.0.6
    CALDERA='Caldera' # Caldera License
    CATOSL_1_1='CATOSL-1.1' # Computer Associates Trusted Open Source License 1.1
    CCBY_1_0='CC-BY-1.0' # Creative Commons Attribution 1.0 Generic
    CCBY_2_0='CC-BY-2.0' # Creative Commons Attribution 2.0 Generic
    CCBY_2_5='CC-BY-2.5' # Creative Commons Attribution 2.5 Generic
    CCBY_3_0='CC-BY-3.0' # Creative Commons Attribution 3.0 Unported
    CCBY_4_0='CC-BY-4.0' # Creative Commons Attribution 4.0 International
    CCBYNC_1_0='CC-BY-NC-1.0' # Creative Commons Attribution Non Commercial 1.0 Generic
    CCBYNC_2_0='CC-BY-NC-2.0' # Creative Commons Attribution Non Commercial 2.0 Generic
    CCBYNC_2_5='CC-BY-NC-2.5' # Creative Commons Attribution Non Commercial 2.5 Generic
    CCBYNC_3_0='CC-BY-NC-3.0' # Creative Commons Attribution Non Commercial 3.0 Unported
    CCBYNC_4_0='CC-BY-NC-4.0' # Creative Commons Attribution Non Commercial 4.0 International
    CCBYNCND_1_0='CC-BY-NC-ND-1.0' # Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic
    CCBYNCND_2_0='CC-BY-NC-ND-2.0' # Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic
    CCBYNCND_2_5='CC-BY-NC-ND-2.5' # Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic
    CCBYNCND_3_0='CC-BY-NC-ND-3.0' # Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported
    CCBYNCND_4_0='CC-BY-NC-ND-4.0' # Creative Commons Attribution Non Commercial No Derivatives 4.0 International
    CCBYNCSA_1_0='CC-BY-NC-SA-1.0' # Creative Commons Attribution Non Commercial Share Alike 1.0 Generic
    CCBYNCSA_2_0='CC-BY-NC-SA-2.0' # Creative Commons Attribution Non Commercial Share Alike 2.0 Generic
    CCBYNCSA_2_5='CC-BY-NC-SA-2.5' # Creative Commons Attribution Non Commercial Share Alike 2.5 Generic
    CCBYNCSA_3_0='CC-BY-NC-SA-3.0' # Creative Commons Attribution Non Commercial Share Alike 3.0 Unported
    CCBYNCSA_4_0='CC-BY-NC-SA-4.0' # Creative Commons Attribution Non Commercial Share Alike 4.0 International
    CCBYND_1_0='CC-BY-ND-1.0' # Creative Commons Attribution No Derivatives 1.0 Generic
    CCBYND_2_0='CC-BY-ND-2.0' # Creative Commons Attribution No Derivatives 2.0 Generic
    CCBYND_2_5='CC-BY-ND-2.5' # Creative Commons Attribution No Derivatives 2.5 Generic
    CCBYND_3_0='CC-BY-ND-3.0' # Creative Commons Attribution No Derivatives 3.0 Unported
    CCBYND_4_0='CC-BY-ND-4.0' # Creative Commons Attribution No Derivatives 4.0 International
    CCBYSA_1_0='CC-BY-SA-1.0' # Creative Commons Attribution Share Alike 1.0 Generic
    CCBYSA_2_0='CC-BY-SA-2.0' # Creative Commons Attribution Share Alike 2.0 Generic
    CCBYSA_2_5='CC-BY-SA-2.5' # Creative Commons Attribution Share Alike 2.5 Generic
    CCBYSA_3_0='CC-BY-SA-3.0' # Creative Commons Attribution Share Alike 3.0 Unported
    CCBYSA_4_0='CC-BY-SA-4.0' # Creative Commons Attribution Share Alike 4.0 International
    CC_0_1_0='CC0-1.0' # Creative Commons Zero v1.0 Universal
    CDDL_1_0='CDDL-1.0' # Common Development and Distribution License 1.0
    CDDL_1_1='CDDL-1.1' # Common Development and Distribution License 1.1
    CDLA_PERMISSIVE_1_0='CDLA-Permissive-1.0' # Community Data License Agreement Permissive 1.0
    CDLA_SHARING_1_0='CDLA-Sharing-1.0' # Community Data License Agreement Sharing 1.0
    CECILL_1_0='CECILL-1.0' # CeCILL Free Software License Agreement v1.0
    CECILL_1_1='CECILL-1.1' # CeCILL Free Software License Agreement v1.1
    CECILL_2_0='CECILL-2.0' # CeCILL Free Software License Agreement v2.0
    CECILL_2_1='CECILL-2.1' # CeCILL Free Software License Agreement v2.1
    CECILLB='CECILL-B' # CeCILL-B Free Software License Agreement
    CECILLC='CECILL-C' # CeCILL-C Free Software License Agreement
    CL_ARTISTIC='ClArtistic' # Clarified Artistic License
    CNRI_JYTHON='CNRI-Jython' # CNRI Jython License
    CNRI_PYTHONGPL_COMPATIBLE='CNRI-Python-GPL-Compatible' # CNRI Python Open Source GPL Compatible License Agreement
    CNRI_PYTHON='CNRI-Python' # CNRI Python License
    CONDOR_1_1='Condor-1.1' # Condor Public License v1.1
    CPAL_1_0='CPAL-1.0' # Common Public Attribution License 1.0
    CPL_1_0='CPL-1.0' # Common Public License 1.0
    CPOL_1_02='CPOL-1.02' # Code Project Open License 1.02
    CROSSWORD='Crossword' # Crossword License
    CRYSTAL_STACKER='CrystalStacker' # CrystalStacker License
    CUAOPL_1_0='CUA-OPL-1.0' # CUA Office Public License v1.0
    CUBE='Cube' # Cube License
    CURL='curl' # curl License
    DFSL_1_0='D-FSL-1.0' # Deutsche Freie Software Lizenz
    DIFFMARK='diffmark' # diffmark license
    DOC='DOC' # DOC License
    DOTSEQN='Dotseqn' # Dotseqn License
    DSDP='DSDP' # DSDP License
    DVIPDFM='dvipdfm' # dvipdfm License
    ECL_1_0='ECL-1.0' # Educational Community License v1.0
    ECL_2_0='ECL-2.0' # Educational Community License v2.0
    EFL_1_0='EFL-1.0' # Eiffel Forum License v1.0
    EFL_2_0='EFL-2.0' # Eiffel Forum License v2.0
    E_GENIX='eGenix' # eGenix.com Public License 1.1.0
    ENTESSA='Entessa' # Entessa Public License v1.0
    EPL_1_0='EPL-1.0' # Eclipse Public License 1.0
    EPL_2_0='EPL-2.0' # Eclipse Public License 2.0
    ERL_PL_1_1='ErlPL-1.1' # Erlang Public License v1.1
    EU_DATAGRID='EUDatagrid' # EU DataGrid Software License
    EUPL_1_0='EUPL-1.0' # European Union Public License 1.0
    EUPL_1_1='EUPL-1.1' # European Union Public License 1.1
    EUPL_1_2='EUPL-1.2' # European Union Public License 1.2
    EUROSYM='Eurosym' # Eurosym License
    FAIR='Fair' # Fair License
    FRAMEWORX_1_0='Frameworx-1.0' # Frameworx Open License 1.0
    FREE_IMAGE='FreeImage' # FreeImage Public License v1.0
    FSFAP='FSFAP' # FSF All Permissive License
    FSFUL='FSFUL' # FSF Unlimited License
    FSFULLR='FSFULLR' # FSF Unlimited License (with License Retention)
    FTL='FTL' # Freetype Project License
    GFDL_1_1ONLY='GFDL-1.1-only' # GNU Free Documentation License v1.1 only
    GFDL_1_1ORLATER='GFDL-1.1-or-later' # GNU Free Documentation License v1.1 or later
    GFDL_1_2ONLY='GFDL-1.2-only' # GNU Free Documentation License v1.2 only
    GFDL_1_2ORLATER='GFDL-1.2-or-later' # GNU Free Documentation License v1.2 or later
    GFDL_1_3ONLY='GFDL-1.3-only' # GNU Free Documentation License v1.3 only
    GFDL_1_3ORLATER='GFDL-1.3-or-later' # GNU Free Documentation License v1.3 or later
    GIFTWARE='Giftware' # Giftware License
    GL_2_PS='GL2PS' # GL2PS License
    GLIDE='Glide' # 3dfx Glide License
    GLULXE='Glulxe' # Glulxe License
    GNUPLOT='gnuplot' # gnuplot License
    GPL_1_0ONLY='GPL-1.0-only' # GNU General Public License v1.0 only
    GPL_1_0ORLATER='GPL-1.0-or-later' # GNU General Public License v1.0 or later
    GPL_2_0ONLY='GPL-2.0-only' # GNU General Public License v2.0 only
    GPL_2_0ORLATER='GPL-2.0-or-later' # GNU General Public License v2.0 or later
    GPL_3_0ONLY='GPL-3.0-only' # GNU General Public License v3.0 only
    GPL_3_0ORLATER='GPL-3.0-or-later' # GNU General Public License v3.0 or later
    G_SOAP_1_3_B='gSOAP-1.3b' # gSOAP Public License v1.3b
    HASKELL_REPORT='HaskellReport' # Haskell Language Report License
    HPND='HPND' # Historical Permission Notice and Disclaimer
    IBMPIBS='IBM-pibs' # IBM PowerPC Initialization and Boot Software
    ICU='ICU' # ICU License
    IJG='IJG' # Independent JPEG Group License
    IMAGE_MAGICK='ImageMagick' # ImageMagick License
    I_MATIX='iMatix' # iMatix Standard Function Library Agreement
    IMLIB_2='Imlib2' # Imlib2 License
    INFOZIP='Info-ZIP' # Info-ZIP License
    INTELACPI='Intel-ACPI' # Intel ACPI Software License Agreement
    INTEL='Intel' # Intel Open Source License
    INTERBASE_1_0='Interbase-1.0' # Interbase Public License v1.0
    IPA='IPA' # IPA Font License
    IPL_1_0='IPL-1.0' # IBM Public License v1.0
    ISC='ISC' # ISC License
    JAS_PER_2_0='JasPer-2.0' # JasPer License
    JSON='JSON' # JSON License
    LAL_1_2='LAL-1.2' # Licence Art Libre 1.2
    LAL_1_3='LAL-1.3' # Licence Art Libre 1.3
    LATEX_2_E='Latex2e' # Latex2e License
    LEPTONICA='Leptonica' # Leptonica License
    LGPL_2_0ONLY='LGPL-2.0-only' # GNU Library General Public License v2 only
    LGPL_2_0ORLATER='LGPL-2.0-or-later' # GNU Library General Public License v2 or later
    LGPL_2_1ONLY='LGPL-2.1-only' # GNU Lesser General Public License v2.1 only
    LGPL_2_1ORLATER='LGPL-2.1-or-later' # GNU Lesser General Public License v2.1 or later
    LGPL_3_0ONLY='LGPL-3.0-only' # GNU Lesser General Public License v3.0 only
    LGPL_3_0ORLATER='LGPL-3.0-or-later' # GNU Lesser General Public License v3.0 or later
    LGPLLR='LGPLLR' # Lesser General Public License For Linguistic Resources
    LIBPNG='Libpng' # libpng License
    LIBTIFF='libtiff' # libtiff License
    LI_LI_QP_1_1='LiLiQ-P-1.1' # Licence Libre du Québec – Permissive version 1.1
    LI_LI_QR_1_1='LiLiQ-R-1.1' # Licence Libre du Québec – Réciprocité version 1.1
    LI_LI_Q_RPLUS_1_1='LiLiQ-Rplus-1.1' # Licence Libre du Québec – Réciprocité forte version 1.1
    LINUX_OPEN_IB='Linux-OpenIB' # Linux Kernel Variant of OpenIB.org license
    LPL_1_0='LPL-1.0' # Lucent Public License Version 1.0
    LPL_1_02='LPL-1.02' # Lucent Public License v1.02
    LPPL_1_0='LPPL-1.0' # LaTeX Project Public License v1.0
    LPPL_1_1='LPPL-1.1' # LaTeX Project Public License v1.1
    LPPL_1_2='LPPL-1.2' # LaTeX Project Public License v1.2
    LPPL_1_3_A='LPPL-1.3a' # LaTeX Project Public License v1.3a
    LPPL_1_3_C='LPPL-1.3c' # LaTeX Project Public License v1.3c
    MAKE_INDEX='MakeIndex' # MakeIndex License
    MIR_OS='MirOS' # MirOS License
    MIT_0='MIT-0' # MIT No Attribution
    MITADVERTISING='MIT-advertising' # Enlightenment License (e16)
    MITCMU='MIT-CMU' # CMU License
    MITENNA='MIT-enna' # enna License
    MITFEH='MIT-feh' # feh License
    MIT='MIT' # MIT License
    MITNFA='MITNFA' # MIT +no-false-attribs license
    MOTOSOTO='Motosoto' # Motosoto License
    MPICH_2='mpich2' # mpich2 License
    MPL_1_0='MPL-1.0' # Mozilla Public License 1.0
    MPL_1_1='MPL-1.1' # Mozilla Public License 1.1
    MPL_2_0NOCOPYLEFTEXCEPTION='MPL-2.0-no-copyleft-exception' # Mozilla Public License 2.0 (no copyleft exception)
    MPL_2_0='MPL-2.0' # Mozilla Public License 2.0
    MSPL='MS-PL' # Microsoft Public License
    MSRL='MS-RL' # Microsoft Reciprocal License
    MTLL='MTLL' # Matrix Template Library License
    MULTICS='Multics' # Multics License
    MUP='Mup' # Mup License
    NASA_1_3='NASA-1.3' # NASA Open Source Agreement 1.3
    NAUMEN='Naumen' # Naumen Public License
    NBPL_1_0='NBPL-1.0' # Net Boolean Public License v1
    NCSA='NCSA' # University of Illinois/NCSA Open Source License
    NETSNMP='Net-SNMP' # Net-SNMP License
    NET_CDF='NetCDF' # NetCDF license
    NEWSLETR='Newsletr' # Newsletr License
    NGPL='NGPL' # Nethack General Public License
    NLOD_1_0='NLOD-1.0' # Norwegian Licence for Open Government Data
    NLPL='NLPL' # No Limit Public License
    NOKIA='Nokia' # Nokia Open Source License
    NOSL='NOSL' # Netizen Open Source License
    NOWEB='Noweb' # Noweb License
    NPL_1_0='NPL-1.0' # Netscape Public License v1.0
    NPL_1_1='NPL-1.1' # Netscape Public License v1.1
    NPOSL_3_0='NPOSL-3.0' # Non-Profit Open Software License 3.0
    NRL='NRL' # NRL License
    NTP='NTP' # NTP License
    OCCTPL='OCCT-PL' # Open CASCADE Technology Public License
    OCLC_2_0='OCLC-2.0' # OCLC Research Public License 2.0
    O_DB_L_1_0='ODbL-1.0' # ODC Open Database License v1.0
    OFL_1_0='OFL-1.0' # SIL Open Font License 1.0
    OFL_1_1='OFL-1.1' # SIL Open Font License 1.1
    OGTSL='OGTSL' # Open Group Test Suite License
    OLDAP_1_1='OLDAP-1.1' # Open LDAP Public License v1.1
    OLDAP_1_2='OLDAP-1.2' # Open LDAP Public License v1.2
    OLDAP_1_3='OLDAP-1.3' # Open LDAP Public License v1.3
    OLDAP_1_4='OLDAP-1.4' # Open LDAP Public License v1.4
    OLDAP_2_0_1='OLDAP-2.0.1' # Open LDAP Public License v2.0.1
    OLDAP_2_0='OLDAP-2.0' # Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)
    OLDAP_2_1='OLDAP-2.1' # Open LDAP Public License v2.1
    OLDAP_2_2_1='OLDAP-2.2.1' # Open LDAP Public License v2.2.1
    OLDAP_2_2_2='OLDAP-2.2.2' # Open LDAP Public License 2.2.2
    OLDAP_2_2='OLDAP-2.2' # Open LDAP Public License v2.2
    OLDAP_2_3='OLDAP-2.3' # Open LDAP Public License v2.3
    OLDAP_2_4='OLDAP-2.4' # Open LDAP Public License v2.4
    OLDAP_2_5='OLDAP-2.5' # Open LDAP Public License v2.5
    OLDAP_2_6='OLDAP-2.6' # Open LDAP Public License v2.6
    OLDAP_2_7='OLDAP-2.7' # Open LDAP Public License v2.7
    OLDAP_2_8='OLDAP-2.8' # Open LDAP Public License v2.8
    OML='OML' # Open Market License
    OPEN_SSL='OpenSSL' # OpenSSL License
    OPL_1_0='OPL-1.0' # Open Public License v1.0
    OSETPL_2_1='OSET-PL-2.1' # OSET Public License version 2.1
    OSL_1_0='OSL-1.0' # Open Software License 1.0
    OSL_1_1='OSL-1.1' # Open Software License 1.1
    OSL_2_0='OSL-2.0' # Open Software License 2.0
    OSL_2_1='OSL-2.1' # Open Software License 2.1
    OSL_3_0='OSL-3.0' # Open Software License 3.0
    PDDL_1_0='PDDL-1.0' # ODC Public Domain Dedication & License 1.0
    PHP_3_0='PHP-3.0' # PHP License v3.0
    PHP_3_01='PHP-3.01' # PHP License v3.01
    PLEXUS='Plexus' # Plexus Classworlds License
    POSTGRE_SQL='PostgreSQL' # PostgreSQL License
    PSFRAG='psfrag' # psfrag License
    PSUTILS='psutils' # psutils License
    PYTHON_2_0='Python-2.0' # Python License 2.0
    QHULL='Qhull' # Qhull License
    QPL_1_0='QPL-1.0' # Q Public License 1.0
    RDISC='Rdisc' # Rdisc License
    R_HE_COS_1_1='RHeCos-1.1' # Red Hat eCos Public License v1.1
    RPL_1_1='RPL-1.1' # Reciprocal Public License 1.1
    RPL_1_5='RPL-1.5' # Reciprocal Public License 1.5
    RPSL_1_0='RPSL-1.0' # RealNetworks Public Source License v1.0
    RSAMD='RSA-MD' # RSA Message-Digest License
    RSCPL='RSCPL' # Ricoh Source Code Public License
    RUBY='Ruby' # Ruby License
    SAXPD='SAX-PD' # Sax Public Domain Notice
    SAXPATH='Saxpath' # Saxpath License
    SCEA='SCEA' # SCEA Shared Source License
    SENDMAIL='Sendmail' # Sendmail License
    SGIB_1_0='SGI-B-1.0' # SGI Free Software License B v1.0
    SGIB_1_1='SGI-B-1.1' # SGI Free Software License B v1.1
    SGIB_2_0='SGI-B-2.0' # SGI Free Software License B v2.0
    SIM_PL_2_0='SimPL-2.0' # Simple Public License 2.0
    SISSL_1_2='SISSL-1.2' # Sun Industry Standards Source License v1.2
    SISSL='SISSL' # Sun Industry Standards Source License v1.1
    SLEEPYCAT='Sleepycat' # Sleepycat License
    SMLNJ='SMLNJ' # Standard ML of New Jersey License
    SMPPL='SMPPL' # Secure Messaging Protocol Public License
    SNIA='SNIA' # SNIA Public License 1.1
    SPENCER_86='Spencer-86' # Spencer License 86
    SPENCER_94='Spencer-94' # Spencer License 94
    SPENCER_99='Spencer-99' # Spencer License 99
    SPL_1_0='SPL-1.0' # Sun Public License v1.0
    SUGAR_CRM_1_1_3='SugarCRM-1.1.3' # SugarCRM Public License v1.1.3
    SWL='SWL' # Scheme Widget Library (SWL) Software License Agreement
    TCL='TCL' # TCL/TK License
    TCPWRAPPERS='TCP-wrappers' # TCP Wrappers License
    T_MATE='TMate' # TMate Open Source License
    TORQUE_1_1='TORQUE-1.1' # TORQUE v2.5+ Software License v1.1
    TOSL='TOSL' # Trusster Open Source License
    UNICODEDFS_2015='Unicode-DFS-2015' # Unicode License Agreement - Data Files and Software (2015)
    UNICODEDFS_2016='Unicode-DFS-2016' # Unicode License Agreement - Data Files and Software (2016)
    UNICODETOU='Unicode-TOU' # Unicode Terms of Use
    UNLICENSE='Unlicense' # The Unlicense
    UPL_1_0='UPL-1.0' # Universal Permissive License v1.0
    VIM='Vim' # Vim License
    VOSTROM='VOSTROM' # VOSTROM Public License for Open Source
    VSL_1_0='VSL-1.0' # Vovida Software License v1.0
    W_3_C_19980720='W3C-19980720' # W3C Software Notice and License (1998-07-20)
    W_3_C_20150513='W3C-20150513' # W3C Software Notice and Document License (2015-05-13)
    W_3_C='W3C' # W3C Software Notice and License (2002-12-31)
    WATCOM_1_0='Watcom-1.0' # Sybase Open Watcom Public License 1.0
    WSUIPA='Wsuipa' # Wsuipa License
    WTFPL='WTFPL' # Do What The F*ck You Want To Public License
    X_11='X11' # X11 License
    XEROX='Xerox' # Xerox License
    X_FREE_86_1_1='XFree86-1.1' # XFree86 License 1.1
    XINETD='xinetd' # xinetd License
    XNET='Xnet' # X.Net License
    XPP='xpp' # XPP License
    X_SKAT='XSkat' # XSkat License
    YPL_1_0='YPL-1.0' # Yahoo! Public License v1.0
    YPL_1_1='YPL-1.1' # Yahoo! Public License v1.1
    ZED='Zed' # Zed License
    ZEND_2_0='Zend-2.0' # Zend License v2.0
    ZIMBRA_1_3='Zimbra-1.3' # Zimbra Public License v1.3
    ZIMBRA_1_4='Zimbra-1.4' # Zimbra Public License v1.4
    ZLIBACKNOWLEDGEMENT='zlib-acknowledgement' # zlib/libpng License with Acknowledgement
    ZLIB='Zlib' # zlib License
    ZPL_1_1='ZPL-1.1' # Zope Public License 1.1
    ZPL_2_0='ZPL-2.0' # Zope Public License 2.0
    ZPL_2_1='ZPL-2.1' # Zope Public License 2.1


class Scope(str, Enum):
    """Scope --
    Scope is simpler than headers attribute for common tables
    
    """
    ROW='row'
    COL='col'
    ROWGROUP='rowgroup'
    COLGROUP='colgroup'


class SearchComparatorEnum(str, Enum):
    EQ='eq' # Equals
    NE='ne' # Not Equals
    GT='gt' # Greater Than
    LT='lt' # Less Than
    GE='ge' # Greater or Equals
    LE='le' # Less of Equal
    SA='sa' # Starts After
    EB='eb' # Ends Before
    AP='ap' # Approximately


class SearchEntryModeEnum(str, Enum):
    MATCH='match' # Match
    INCLUDE='include' # Include
    OUTCOME='outcome' # Outcome


class SearchModifierCodeEnum(str, Enum):
    MISSING='missing' # Missing
    EXACT='exact' # Exact
    CONTAINS='contains' # Contains
    NOT='not' # Not
    TEXT='text' # Text
    IN='in' # In
    NOTIN='not-in' # Not In
    BELOW='below' # Below
    ABOVE='above' # Above
    TYPE='type' # Type
    IDENTIFIER='identifier' # Identifier
    OFTYPE='of-type' # Of Type
    CODETEXT='code-text' # Code Text
    TEXTADVANCED='text-advanced' # Text Advanced
    ITERATE='iterate' # Iterate


class SearchParamTypeEnum(str, Enum):
    NUMBER='number' # Number
    DATE='date' # Date/DateTime
    STRING='string' # String
    TOKEN='token' # Token
    REFERENCE='reference' # Reference
    COMPOSITE='composite' # Composite
    QUANTITY='quantity' # Quantity
    URI='uri' # URI
    SPECIAL='special' # Special


class SearchProcessingModeTypeEnum(str, Enum):
    NORMAL='normal' # Normal
    PHONETIC='phonetic' # Phonetic
    OTHER='other' # Other


class SequenceTypeEnum(str, Enum):
    AA='aa' # AA Sequence
    DNA='dna' # DNA Sequence
    RNA='rna' # RNA Sequence


class Shape(str, Enum):
    RECT='rect'
    CIRCLE='circle'
    POLY='poly'
    DEFAULT='default'


class SlicingRulesEnum(str, Enum):
    CLOSED='closed' # Closed
    OPEN='open' # Open
    OPEN_AT_END='openAtEnd' # Open at End


class SlotStatusEnum(str, Enum):
    BUSY='busy' # Busy
    FREE='free' # Free
    BUSYUNAVAILABLE='busy-unavailable' # Busy (Unavailable)
    BUSYTENTATIVE='busy-tentative' # Busy (Tentative)
    ENTEREDINERROR='entered-in-error' # Entered in error


class SortDirectionEnum(str, Enum):
    ASCENDING='ascending' # Ascending
    DESCENDING='descending' # Descending


class SpecimenCombinedEnum(str, Enum):
    GROUPED='grouped' # Grouped
    POOLED='pooled' # Pooled


class SpecimenContainedPreferenceEnum(str, Enum):
    PREFERRED='preferred' # Preferred
    ALTERNATE='alternate' # Alternate


class SpecimenStatusEnum(str, Enum):
    AVAILABLE='available' # Available
    UNAVAILABLE='unavailable' # Unavailable
    UNSATISFACTORY='unsatisfactory' # Unsatisfactory
    ENTEREDINERROR='entered-in-error' # Entered in Error


class StrandTypeEnum(str, Enum):
    WATSON='watson' # Watson strand of starting sequence
    CRICK='crick' # Crick strand of starting sequence


class StructureDefinitionKindEnum(str, Enum):
    PRIMITIVETYPE='primitive-type' # Primitive Data Type
    COMPLEXTYPE='complex-type' # Complex Data Type
    RESOURCE='resource' # Resource
    LOGICAL='logical' # Logical


class StructureMapGroupTypeModeEnum(str, Enum):
    TYPES='types' # Default for Type Combination
    TYPEANDTYPES='type-and-types' # Default for type + combination


class StructureMapInputModeEnum(str, Enum):
    SOURCE='source' # Source Instance
    TARGET='target' # Target Instance


class StructureMapModelModeEnum(str, Enum):
    SOURCE='source' # Source Structure Definition
    QUERIED='queried' # Queried Structure Definition
    TARGET='target' # Target Structure Definition
    PRODUCED='produced' # Produced Structure Definition


class StructureMapSourceListModeEnum(str, Enum):
    FIRST='first' # First
    NOT_FIRST='not_first' # All but the first
    LAST='last' # Last
    NOT_LAST='not_last' # All but the last
    ONLY_ONE='only_one' # Enforce only one


class StructureMapTargetListModeEnum(str, Enum):
    FIRST='first' # First
    SHARE='share' # Share
    LAST='last' # Last
    SINGLE='single' # single


class StructureMapTransformEnum(str, Enum):
    CREATE='create' # create
    COPY='copy' # copy
    TRUNCATE='truncate' # truncate
    ESCAPE='escape' # escape
    CAST='cast' # cast
    APPEND='append' # append
    TRANSLATE='translate' # translate
    REFERENCE='reference' # reference
    DATE_OP='dateOp' # dateOp
    UUID='uuid' # uuid
    POINTER='pointer' # pointer
    EVALUATE='evaluate' # evaluate
    CC='cc' # cc
    C='c' # c
    QTY='qty' # qty
    ID='id' # id
    CP='cp' # cp


class SubmitDataUpdateTypeEnum(str, Enum):
    INCREMENTAL='incremental' # Incremental
    SNAPSHOT='snapshot' # Snapshot


class SubscriptionNotificationTypeEnum(str, Enum):
    HANDSHAKE='handshake' # Handshake
    HEARTBEAT='heartbeat' # Heartbeat
    EVENTNOTIFICATION='event-notification' # Event Notification
    QUERYSTATUS='query-status' # Query Status
    QUERYEVENT='query-event' # Query Event


class SubscriptionPayloadContentEnum(str, Enum):
    EMPTY='empty' # Empty
    IDONLY='id-only' # Id-only
    FULLRESOURCE='full-resource' # Full-resource


class SubscriptionStatusCodesEnum(str, Enum):
    REQUESTED='requested' # Requested
    ACTIVE='active' # Active
    ERROR='error' # Error
    OFF='off' # Off
    ENTEREDINERROR='entered-in-error' # Entered in Error


class SupplyDeliveryStatusEnum(str, Enum):
    INPROGRESS='in-progress' # In Progress
    COMPLETED='completed' # Delivered
    ABANDONED='abandoned' # Abandoned
    ENTEREDINERROR='entered-in-error' # Entered In Error


class SupplyRequestStatusEnum(str, Enum):
    DRAFT='draft' # Draft
    ACTIVE='active' # Active
    SUSPENDED='suspended' # Suspended
    CANCELLED='cancelled' # Cancelled
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class SystemRestfulInteractionEnum(str, Enum):
    TRANSACTION='transaction' # transaction
    BATCH='batch' # batch
    SEARCHSYSTEM='search-system' # search-system
    HISTORYSYSTEM='history-system' # history-system


class TFrame(str, Enum):
    """TFrame --
    The border attribute sets the thickness of the frame around the
    table. The default units are screen pixels.
    The frame attribute specifies which parts of the frame around
    the table should be rendered. The values are not the same as
    CALS to avoid a name clash with the valign attribute.
    
    """
    VOID='void'
    ABOVE='above'
    BELOW='below'
    HSIDES='hsides'
    LHS='lhs'
    RHS='rhs'
    VSIDES='vsides'
    BOX='box'
    BORDER='border'


class TRules(str, Enum):
    """TRules --
    The rules attribute defines which rules to draw between cells:
    If rules is absent then assume:
    "none" if border is absent or border="0" otherwise "all"
    
    """
    NONE='none'
    GROUPS='groups'
    ROWS='rows'
    COLS='cols'
    ALL='all'


class TaskIntentEnum(str, Enum):
    UNKNOWN='unknown' # Unknown
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    ORDER='order' # Order
    ORIGINALORDER='original-order' # Original Order
    REFLEXORDER='reflex-order' # Reflex Order
    FILLERORDER='filler-order' # Filler Order
    INSTANCEORDER='instance-order' # Instance Order
    OPTION='option' # Option


class TaskStatusEnum(str, Enum):
    DRAFT='draft' # Draft
    REQUESTED='requested' # Requested
    RECEIVED='received' # Received
    ACCEPTED='accepted' # Accepted
    REJECTED='rejected' # Rejected
    READY='ready' # Ready
    CANCELLED='cancelled' # Cancelled
    INPROGRESS='in-progress' # In Progress
    ONHOLD='on-hold' # On Hold
    FAILED='failed' # Failed
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error


class TestReportActionResultEnum(str, Enum):
    PASS='pass' # Pass
    SKIP='skip' # Skip
    FAIL='fail' # Fail
    WARNING='warning' # Warning
    ERROR='error' # Error


class TestReportParticipantTypeEnum(str, Enum):
    TESTENGINE='test-engine' # Test Engine
    CLIENT='client' # Client
    SERVER='server' # Server


class TestReportResultEnum(str, Enum):
    PASS='pass' # Pass
    FAIL='fail' # Fail
    PENDING='pending' # Pending


class TestReportStatusEnum(str, Enum):
    COMPLETED='completed' # Completed
    INPROGRESS='in-progress' # In Progress
    WAITING='waiting' # Waiting
    STOPPED='stopped' # Stopped
    ENTEREDINERROR='entered-in-error' # Entered In Error


class TestScriptRequestMethodCodeEnum(str, Enum):
    DELETE='delete' # DELETE
    GET='get' # GET
    OPTIONS='options' # OPTIONS
    PATCH='patch' # PATCH
    POST='post' # POST
    PUT='put' # PUT
    HEAD='head' # HEAD


class TransportIntentEnum(str, Enum):
    UNKNOWN='unknown' # Unknown
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    ORDER='order' # Order
    ORIGINALORDER='original-order' # Original Order
    REFLEXORDER='reflex-order' # Reflex Order
    FILLERORDER='filler-order' # Filler Order
    INSTANCEORDER='instance-order' # Instance Order
    OPTION='option' # Option


class TransportStatusEnum(str, Enum):
    INPROGRESS='in-progress' # In Progress
    COMPLETED='completed' # Completed
    ABANDONED='abandoned' # Abandoned
    CANCELLED='cancelled' # Cancelled
    PLANNED='planned' # Planned
    ENTEREDINERROR='entered-in-error' # Entered In Error


class TriggerTypeEnum(str, Enum):
    NAMEDEVENT='named-event' # Named Event
    PERIODIC='periodic' # Periodic
    DATACHANGED='data-changed' # Data Changed
    DATAADDED='data-added' # Data Added
    DATAMODIFIED='data-modified' # Data Updated
    DATAREMOVED='data-removed' # Data Removed
    DATAACCESSED='data-accessed' # Data Accessed
    DATAACCESSENDED='data-access-ended' # Data Access Ended


class TriggeredBytypeEnum(str, Enum):
    REFLEX='reflex' # Reflex
    REPEAT='repeat' # Repeat (per policy)
    RERUN='re-run' # Re-run (per policy)


class TypeDerivationRuleEnum(str, Enum):
    SPECIALIZATION='specialization' # Specialization
    CONSTRAINT='constraint' # Constraint


class TypeRestfulInteractionEnum(str, Enum):
    READ='read' # read
    VREAD='vread' # vread
    UPDATE='update' # update
    PATCH='patch' # patch
    DELETE='delete' # delete
    HISTORYINSTANCE='history-instance' # history-instance
    HISTORYTYPE='history-type' # history-type
    CREATE='create' # create
    SEARCHTYPE='search-type' # search-type


class UDIEntryTypeEnum(str, Enum):
    BARCODE='barcode' # Barcode
    RFID='rfid' # RFID
    MANUAL='manual' # Manual
    CARD='card' # Card
    SELFREPORTED='self-reported' # Self Reported
    ELECTRONICTRANSMISSION='electronic-transmission' # Electronic Transmission
    UNKNOWN='unknown' # Unknown


class UnitsOfTimeEnum(str, Enum):
    S='s' # 秒
    MIN='min' # 分钟
    H='h' # 小时
    D='d' # 天
    WK='wk' # 星期
    MO='mo' # 月
    A='a' # 年


class UseEnum(str, Enum):
    CLAIM='claim' # Claim
    PREAUTHORIZATION='preauthorization' # Preauthorization
    PREDETERMINATION='predetermination' # Predetermination


class VerificationResultStatusEnum(str, Enum):
    ATTESTED='attested' # Attested
    VALIDATED='validated' # Validated
    INPROCESS='in-process' # In process
    REQREVALID='req-revalid' # Requires revalidation
    VALFAIL='val-fail' # Validation failed
    REVALFAIL='reval-fail' # Re-Validation failed
    ENTEREDINERROR='entered-in-error' # Entered in Error


class VersionIndependentResourceTypesAllEnum(str, Enum):
    ACCOUNT='Account' # Account
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinition
    ACTOR_DEFINITION='ActorDefinition' # ActorDefinition
    ADMINISTRABLE_PRODUCT_DEFINITION='AdministrableProductDefinition' # AdministrableProductDefinition
    ADVERSE_EVENT='AdverseEvent' # AdverseEvent
    ALLERGY_INTOLERANCE='AllergyIntolerance' # AllergyIntolerance
    APPOINTMENT='Appointment' # Appointment
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponse
    ARTIFACT_ASSESSMENT='ArtifactAssessment' # ArtifactAssessment
    AUDIT_EVENT='AuditEvent' # AuditEvent
    BASIC='Basic' # Basic
    BINARY='Binary' # Binary
    BIOLOGICALLY_DERIVED_PRODUCT='BiologicallyDerivedProduct' # BiologicallyDerivedProduct
    BIOLOGICALLY_DERIVED_PRODUCT_DISPENSE='BiologicallyDerivedProductDispense' # BiologicallyDerivedProductDispense
    BODY_STRUCTURE='BodyStructure' # BodyStructure
    BUNDLE='Bundle' # Bundle
    CANONICAL_RESOURCE='CanonicalResource' # CanonicalResource
    CAPABILITY_STATEMENT='CapabilityStatement' # CapabilityStatement
    CARE_PLAN='CarePlan' # CarePlan
    CARE_TEAM='CareTeam' # CareTeam
    CHARGE_ITEM='ChargeItem' # ChargeItem
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CITATION='Citation' # Citation
    CLAIM='Claim' # Claim
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponse
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpression
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    CODE_SYSTEM='CodeSystem' # CodeSystem
    COMMUNICATION='Communication' # Communication
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequest
    COMPARTMENT_DEFINITION='CompartmentDefinition' # CompartmentDefinition
    COMPOSITION='Composition' # Composition
    CONCEPT_MAP='ConceptMap' # ConceptMap
    CONDITION='Condition' # Condition
    CONDITION_DEFINITION='ConditionDefinition' # ConditionDefinition
    CONSENT='Consent' # Consent
    CONTRACT='Contract' # Contract
    COVERAGE='Coverage' # Coverage
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequest
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponse
    DETECTED_ISSUE='DetectedIssue' # DetectedIssue
    DEVICE='Device' # Device
    DEVICE_ASSOCIATION='DeviceAssociation' # DeviceAssociation
    DEVICE_DEFINITION='DeviceDefinition' # DeviceDefinition
    DEVICE_DISPENSE='DeviceDispense' # DeviceDispense
    DEVICE_METRIC='DeviceMetric' # DeviceMetric
    DEVICE_REQUEST='DeviceRequest' # DeviceRequest
    DEVICE_USAGE='DeviceUsage' # DeviceUsage
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReport
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReference
    DOMAIN_RESOURCE='DomainResource' # DomainResource
    ENCOUNTER='Encounter' # Encounter
    ENCOUNTER_HISTORY='EncounterHistory' # EncounterHistory
    ENDPOINT='Endpoint' # Endpoint
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequest
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponse
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare
    EVENT_DEFINITION='EventDefinition' # EventDefinition
    EVIDENCE='Evidence' # Evidence
    EVIDENCE_REPORT='EvidenceReport' # EvidenceReport
    EVIDENCE_VARIABLE='EvidenceVariable' # EvidenceVariable
    EXAMPLE_SCENARIO='ExampleScenario' # ExampleScenario
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefit
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistory
    FLAG='Flag' # Flag
    FORMULARY_ITEM='FormularyItem' # FormularyItem
    GENOMIC_STUDY='GenomicStudy' # GenomicStudy
    GOAL='Goal' # Goal
    GRAPH_DEFINITION='GraphDefinition' # GraphDefinition
    GROUP='Group' # Group
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponse
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareService
    IMAGING_SELECTION='ImagingSelection' # ImagingSelection
    IMAGING_STUDY='ImagingStudy' # ImagingStudy
    IMMUNIZATION='Immunization' # Immunization
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendation
    IMPLEMENTATION_GUIDE='ImplementationGuide' # ImplementationGuide
    INGREDIENT='Ingredient' # Ingredient
    INSURANCE_PLAN='InsurancePlan' # InsurancePlan
    INVENTORY_ITEM='InventoryItem' # InventoryItem
    INVENTORY_REPORT='InventoryReport' # InventoryReport
    INVOICE='Invoice' # Invoice
    LIBRARY='Library' # Library
    LINKAGE='Linkage' # Linkage
    LIST='List' # List
    LOCATION='Location' # Location
    MANUFACTURED_ITEM_DEFINITION='ManufacturedItemDefinition' # ManufacturedItemDefinition
    MEASURE='Measure' # Measure
    MEASURE_REPORT='MeasureReport' # MeasureReport
    MEDICATION='Medication' # Medication
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministration
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispense
    MEDICATION_KNOWLEDGE='MedicationKnowledge' # MedicationKnowledge
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequest
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatement
    MEDICINAL_PRODUCT_DEFINITION='MedicinalProductDefinition' # MedicinalProductDefinition
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinition
    MESSAGE_HEADER='MessageHeader' # MessageHeader
    METADATA_RESOURCE='MetadataResource' # MetadataResource
    MOLECULAR_SEQUENCE='MolecularSequence' # MolecularSequence
    NAMING_SYSTEM='NamingSystem' # NamingSystem
    NUTRITION_INTAKE='NutritionIntake' # NutritionIntake
    NUTRITION_ORDER='NutritionOrder' # NutritionOrder
    NUTRITION_PRODUCT='NutritionProduct' # NutritionProduct
    OBSERVATION='Observation' # Observation
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinition
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinition
    OPERATION_OUTCOME='OperationOutcome' # OperationOutcome
    ORGANIZATION='Organization' # Organization
    ORGANIZATION_AFFILIATION='OrganizationAffiliation' # OrganizationAffiliation
    PACKAGED_PRODUCT_DEFINITION='PackagedProductDefinition' # PackagedProductDefinition
    PARAMETERS='Parameters' # Parameters
    PATIENT='Patient' # Patient
    PAYMENT_NOTICE='PaymentNotice' # PaymentNotice
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliation
    PERMISSION='Permission' # Permission
    PERSON='Person' # Person
    PLAN_DEFINITION='PlanDefinition' # PlanDefinition
    PRACTITIONER='Practitioner' # Practitioner
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRole
    PROCEDURE='Procedure' # Procedure
    PROVENANCE='Provenance' # Provenance
    QUESTIONNAIRE='Questionnaire' # Questionnaire
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponse
    REGULATED_AUTHORIZATION='RegulatedAuthorization' # RegulatedAuthorization
    RELATED_PERSON='RelatedPerson' # RelatedPerson
    REQUEST_ORCHESTRATION='RequestOrchestration' # RequestOrchestration
    REQUIREMENTS='Requirements' # Requirements
    RESEARCH_STUDY='ResearchStudy' # ResearchStudy
    RESEARCH_SUBJECT='ResearchSubject' # ResearchSubject
    RESOURCE='Resource' # Resource
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessment
    SCHEDULE='Schedule' # Schedule
    SEARCH_PARAMETER='SearchParameter' # SearchParameter
    SERVICE_REQUEST='ServiceRequest' # ServiceRequest
    SLOT='Slot' # Slot
    SPECIMEN='Specimen' # Specimen
    SPECIMEN_DEFINITION='SpecimenDefinition' # SpecimenDefinition
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinition
    STRUCTURE_MAP='StructureMap' # StructureMap
    SUBSCRIPTION='Subscription' # Subscription
    SUBSCRIPTION_STATUS='SubscriptionStatus' # SubscriptionStatus
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    SUBSTANCE='Substance' # Substance
    SUBSTANCE_DEFINITION='SubstanceDefinition' # SubstanceDefinition
    SUBSTANCE_NUCLEIC_ACID='SubstanceNucleicAcid' # SubstanceNucleicAcid
    SUBSTANCE_POLYMER='SubstancePolymer' # SubstancePolymer
    SUBSTANCE_PROTEIN='SubstanceProtein' # SubstanceProtein
    SUBSTANCE_REFERENCE_INFORMATION='SubstanceReferenceInformation' # SubstanceReferenceInformation
    SUBSTANCE_SOURCE_MATERIAL='SubstanceSourceMaterial' # SubstanceSourceMaterial
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDelivery
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequest
    TASK='Task' # Task
    TERMINOLOGY_CAPABILITIES='TerminologyCapabilities' # TerminologyCapabilities
    TEST_PLAN='TestPlan' # TestPlan
    TEST_REPORT='TestReport' # TestReport
    TEST_SCRIPT='TestScript' # TestScript
    TRANSPORT='Transport' # Transport
    VALUE_SET='ValueSet' # ValueSet
    VERIFICATION_RESULT='VerificationResult' # VerificationResult
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescription
    BODY_SITE='BodySite' # BodySite
    CATALOG_ENTRY='CatalogEntry' # CatalogEntry
    CONFORMANCE='Conformance' # Conformance
    DATA_ELEMENT='DataElement' # DataElement
    DEVICE_COMPONENT='DeviceComponent' # DeviceComponent
    DEVICE_USE_REQUEST='DeviceUseRequest' # DeviceUseRequest
    DEVICE_USE_STATEMENT='DeviceUseStatement' # DeviceUseStatement
    DIAGNOSTIC_ORDER='DiagnosticOrder' # DiagnosticOrder
    DOCUMENT_MANIFEST='DocumentManifest' # DocumentManifest
    EFFECT_EVIDENCE_SYNTHESIS='EffectEvidenceSynthesis' # EffectEvidenceSynthesis
    ELIGIBILITY_REQUEST='EligibilityRequest' # EligibilityRequest
    ELIGIBILITY_RESPONSE='EligibilityResponse' # EligibilityResponse
    EXPANSION_PROFILE='ExpansionProfile' # ExpansionProfile
    IMAGING_MANIFEST='ImagingManifest' # ImagingManifest
    IMAGING_OBJECT_SELECTION='ImagingObjectSelection' # ImagingObjectSelection
    MEDIA='Media' # Media
    MEDICATION_ORDER='MedicationOrder' # MedicationOrder
    MEDICATION_USAGE='MedicationUsage' # MedicationUsage
    MEDICINAL_PRODUCT='MedicinalProduct' # MedicinalProduct
    MEDICINAL_PRODUCT_AUTHORIZATION='MedicinalProductAuthorization' # MedicinalProductAuthorization
    MEDICINAL_PRODUCT_CONTRAINDICATION='MedicinalProductContraindication' # MedicinalProductContraindication
    MEDICINAL_PRODUCT_INDICATION='MedicinalProductIndication' # MedicinalProductIndication
    MEDICINAL_PRODUCT_INGREDIENT='MedicinalProductIngredient' # MedicinalProductIngredient
    MEDICINAL_PRODUCT_INTERACTION='MedicinalProductInteraction' # MedicinalProductInteraction
    MEDICINAL_PRODUCT_MANUFACTURED='MedicinalProductManufactured' # MedicinalProductManufactured
    MEDICINAL_PRODUCT_PACKAGED='MedicinalProductPackaged' # MedicinalProductPackaged
    MEDICINAL_PRODUCT_PHARMACEUTICAL='MedicinalProductPharmaceutical' # MedicinalProductPharmaceutical
    MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT='MedicinalProductUndesirableEffect' # MedicinalProductUndesirableEffect
    ORDER='Order' # Order
    ORDER_RESPONSE='OrderResponse' # OrderResponse
    PROCEDURE_REQUEST='ProcedureRequest' # ProcedureRequest
    PROCESS_REQUEST='ProcessRequest' # ProcessRequest
    PROCESS_RESPONSE='ProcessResponse' # ProcessResponse
    REFERRAL_REQUEST='ReferralRequest' # ReferralRequest
    REQUEST_GROUP='RequestGroup' # RequestGroup
    RESEARCH_DEFINITION='ResearchDefinition' # ResearchDefinition
    RESEARCH_ELEMENT_DEFINITION='ResearchElementDefinition' # ResearchElementDefinition
    RISK_EVIDENCE_SYNTHESIS='RiskEvidenceSynthesis' # RiskEvidenceSynthesis
    SEQUENCE='Sequence' # Sequence
    SERVICE_DEFINITION='ServiceDefinition' # ServiceDefinition
    SUBSTANCE_SPECIFICATION='SubstanceSpecification' # SubstanceSpecification


class VisionBaseEnum(str, Enum):
    UP='up' # Up
    DOWN='down' # Down
    IN='in' # In
    OUT='out' # Out


class VisionEyesEnum(str, Enum):
    RIGHT='right' # Right Eye
    LEFT='left' # Left Eye


class alignType(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class dirType(str, Enum):
    LTR='ltr'
    RTL='rtl'


class dirType1(str, Enum):
    LTR='ltr'
    RTL='rtl'


class ismapType(str, Enum):
    ISMAP='ismap'


class nohrefType(str, Enum):
    NOHREF='nohref'


class valignType(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


#
# Start data representation classes
#
class ResourceContainer(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Account: 'Account' = None, ActivityDefinition: 'ActivityDefinition' = None, ActorDefinition: 'ActorDefinition' = None, AdministrableProductDefinition: 'AdministrableProductDefinition' = None, AdverseEvent: 'AdverseEvent' = None, AllergyIntolerance: 'AllergyIntolerance' = None, Appointment: 'Appointment' = None, AppointmentResponse: 'AppointmentResponse' = None, ArtifactAssessment: 'ArtifactAssessment' = None, AuditEvent: 'AuditEvent' = None, Basic: 'Basic' = None, Binary: 'Binary' = None, BiologicallyDerivedProduct: 'BiologicallyDerivedProduct' = None, BiologicallyDerivedProductDispense: 'BiologicallyDerivedProductDispense' = None, BodyStructure: 'BodyStructure' = None, Bundle: 'Bundle' = None, CapabilityStatement: 'CapabilityStatement' = None, CarePlan: 'CarePlan' = None, CareTeam: 'CareTeam' = None, ChargeItem: 'ChargeItem' = None, ChargeItemDefinition: 'ChargeItemDefinition' = None, Citation: 'Citation' = None, Claim: 'Claim' = None, ClaimResponse: 'ClaimResponse' = None, ClinicalImpression: 'ClinicalImpression' = None, ClinicalUseDefinition: 'ClinicalUseDefinition' = None, CodeSystem: 'CodeSystem' = None, Communication: 'Communication' = None, CommunicationRequest: 'CommunicationRequest' = None, CompartmentDefinition: 'CompartmentDefinition' = None, Composition: 'Composition' = None, ConceptMap: 'ConceptMap' = None, Condition: 'Condition' = None, ConditionDefinition: 'ConditionDefinition' = None, Consent: 'Consent' = None, Contract: 'Contract' = None, Coverage: 'Coverage' = None, CoverageEligibilityRequest: 'CoverageEligibilityRequest' = None, CoverageEligibilityResponse: 'CoverageEligibilityResponse' = None, DetectedIssue: 'DetectedIssue' = None, Device: 'Device' = None, DeviceAssociation: 'DeviceAssociation' = None, DeviceDefinition: 'DeviceDefinition' = None, DeviceDispense: 'DeviceDispense' = None, DeviceMetric: 'DeviceMetric' = None, DeviceRequest: 'DeviceRequest' = None, DeviceUsage: 'DeviceUsage' = None, DiagnosticReport: 'DiagnosticReport' = None, DocumentReference: 'DocumentReference' = None, Encounter: 'Encounter' = None, EncounterHistory: 'EncounterHistory' = None, Endpoint: 'Endpoint' = None, EnrollmentRequest: 'EnrollmentRequest' = None, EnrollmentResponse: 'EnrollmentResponse' = None, EpisodeOfCare: 'EpisodeOfCare' = None, EventDefinition: 'EventDefinition' = None, Evidence: 'Evidence' = None, EvidenceReport: 'EvidenceReport' = None, EvidenceVariable: 'EvidenceVariable' = None, ExampleScenario: 'ExampleScenario' = None, ExplanationOfBenefit: 'ExplanationOfBenefit' = None, FamilyMemberHistory: 'FamilyMemberHistory' = None, Flag: 'Flag' = None, FormularyItem: 'FormularyItem' = None, GenomicStudy: 'GenomicStudy' = None, Goal: 'Goal' = None, GraphDefinition: 'GraphDefinition' = None, Group: 'Group' = None, GuidanceResponse: 'GuidanceResponse' = None, HealthcareService: 'HealthcareService' = None, ImagingSelection: 'ImagingSelection' = None, ImagingStudy: 'ImagingStudy' = None, Immunization: 'Immunization' = None, ImmunizationEvaluation: 'ImmunizationEvaluation' = None, ImmunizationRecommendation: 'ImmunizationRecommendation' = None, ImplementationGuide: 'ImplementationGuide' = None, Ingredient: 'Ingredient' = None, InsurancePlan: 'InsurancePlan' = None, InventoryItem: 'InventoryItem' = None, InventoryReport: 'InventoryReport' = None, Invoice: 'Invoice' = None, Library: 'Library' = None, Linkage: 'Linkage' = None, List: 'List' = None, Location: 'Location' = None, ManufacturedItemDefinition: 'ManufacturedItemDefinition' = None, Measure: 'Measure' = None, MeasureReport: 'MeasureReport' = None, Medication: 'Medication' = None, MedicationAdministration: 'MedicationAdministration' = None, MedicationDispense: 'MedicationDispense' = None, MedicationKnowledge: 'MedicationKnowledge' = None, MedicationRequest: 'MedicationRequest' = None, MedicationStatement: 'MedicationStatement' = None, MedicinalProductDefinition: 'MedicinalProductDefinition' = None, MessageDefinition: 'MessageDefinition' = None, MessageHeader: 'MessageHeader' = None, MolecularSequence: 'MolecularSequence' = None, NamingSystem: 'NamingSystem' = None, NutritionIntake: 'NutritionIntake' = None, NutritionOrder: 'NutritionOrder' = None, NutritionProduct: 'NutritionProduct' = None, Observation: 'Observation' = None, ObservationDefinition: 'ObservationDefinition' = None, OperationDefinition: 'OperationDefinition' = None, OperationOutcome: 'OperationOutcome' = None, Organization: 'Organization' = None, OrganizationAffiliation: 'OrganizationAffiliation' = None, PackagedProductDefinition: 'PackagedProductDefinition' = None, Patient: 'Patient' = None, PaymentNotice: 'PaymentNotice' = None, PaymentReconciliation: 'PaymentReconciliation' = None, Permission: 'Permission' = None, Person: 'Person' = None, PlanDefinition: 'PlanDefinition' = None, Practitioner: 'Practitioner' = None, PractitionerRole: 'PractitionerRole' = None, Procedure: 'Procedure' = None, Provenance: 'Provenance' = None, Questionnaire: 'Questionnaire' = None, QuestionnaireResponse: 'QuestionnaireResponse' = None, RegulatedAuthorization: 'RegulatedAuthorization' = None, RelatedPerson: 'RelatedPerson' = None, RequestOrchestration: 'RequestOrchestration' = None, Requirements: 'Requirements' = None, ResearchStudy: 'ResearchStudy' = None, ResearchSubject: 'ResearchSubject' = None, RiskAssessment: 'RiskAssessment' = None, Schedule: 'Schedule' = None, SearchParameter: 'SearchParameter' = None, ServiceRequest: 'ServiceRequest' = None, Slot: 'Slot' = None, Specimen: 'Specimen' = None, SpecimenDefinition: 'SpecimenDefinition' = None, StructureDefinition: 'StructureDefinition' = None, StructureMap: 'StructureMap' = None, Subscription: 'Subscription' = None, SubscriptionStatus: 'SubscriptionStatus' = None, SubscriptionTopic: 'SubscriptionTopic' = None, Substance: 'Substance' = None, SubstanceDefinition: 'SubstanceDefinition' = None, SubstanceNucleicAcid: 'SubstanceNucleicAcid' = None, SubstancePolymer: 'SubstancePolymer' = None, SubstanceProtein: 'SubstanceProtein' = None, SubstanceReferenceInformation: 'SubstanceReferenceInformation' = None, SubstanceSourceMaterial: 'SubstanceSourceMaterial' = None, SupplyDelivery: 'SupplyDelivery' = None, SupplyRequest: 'SupplyRequest' = None, Task: 'Task' = None, TerminologyCapabilities: 'TerminologyCapabilities' = None, TestPlan: 'TestPlan' = None, TestReport: 'TestReport' = None, TestScript: 'TestScript' = None, Transport: 'Transport' = None, ValueSet: 'ValueSet' = None, VerificationResult: 'VerificationResult' = None, VisionPrescription: 'VisionPrescription' = None, Parameters: 'Parameters' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Account = Account
        self.Account_nsprefix_ = None
        self.ActivityDefinition = ActivityDefinition
        self.ActivityDefinition_nsprefix_ = None
        self.ActorDefinition = ActorDefinition
        self.ActorDefinition_nsprefix_ = None
        self.AdministrableProductDefinition = AdministrableProductDefinition
        self.AdministrableProductDefinition_nsprefix_ = None
        self.AdverseEvent = AdverseEvent
        self.AdverseEvent_nsprefix_ = None
        self.AllergyIntolerance = AllergyIntolerance
        self.AllergyIntolerance_nsprefix_ = None
        self.Appointment = Appointment
        self.Appointment_nsprefix_ = None
        self.AppointmentResponse = AppointmentResponse
        self.AppointmentResponse_nsprefix_ = None
        self.ArtifactAssessment = ArtifactAssessment
        self.ArtifactAssessment_nsprefix_ = None
        self.AuditEvent = AuditEvent
        self.AuditEvent_nsprefix_ = None
        self.Basic = Basic
        self.Basic_nsprefix_ = None
        self.Binary = Binary
        self.Binary_nsprefix_ = None
        self.BiologicallyDerivedProduct = BiologicallyDerivedProduct
        self.BiologicallyDerivedProduct_nsprefix_ = None
        self.BiologicallyDerivedProductDispense = BiologicallyDerivedProductDispense
        self.BiologicallyDerivedProductDispense_nsprefix_ = None
        self.BodyStructure = BodyStructure
        self.BodyStructure_nsprefix_ = None
        self.Bundle = Bundle
        self.Bundle_nsprefix_ = None
        self.CapabilityStatement = CapabilityStatement
        self.CapabilityStatement_nsprefix_ = None
        self.CarePlan = CarePlan
        self.CarePlan_nsprefix_ = None
        self.CareTeam = CareTeam
        self.CareTeam_nsprefix_ = None
        self.ChargeItem = ChargeItem
        self.ChargeItem_nsprefix_ = None
        self.ChargeItemDefinition = ChargeItemDefinition
        self.ChargeItemDefinition_nsprefix_ = None
        self.Citation = Citation
        self.Citation_nsprefix_ = None
        self.Claim = Claim
        self.Claim_nsprefix_ = None
        self.ClaimResponse = ClaimResponse
        self.ClaimResponse_nsprefix_ = None
        self.ClinicalImpression = ClinicalImpression
        self.ClinicalImpression_nsprefix_ = None
        self.ClinicalUseDefinition = ClinicalUseDefinition
        self.ClinicalUseDefinition_nsprefix_ = None
        self.CodeSystem = CodeSystem
        self.CodeSystem_nsprefix_ = None
        self.Communication = Communication
        self.Communication_nsprefix_ = None
        self.CommunicationRequest = CommunicationRequest
        self.CommunicationRequest_nsprefix_ = None
        self.CompartmentDefinition = CompartmentDefinition
        self.CompartmentDefinition_nsprefix_ = None
        self.Composition = Composition
        self.Composition_nsprefix_ = None
        self.ConceptMap = ConceptMap
        self.ConceptMap_nsprefix_ = None
        self.Condition = Condition
        self.Condition_nsprefix_ = None
        self.ConditionDefinition = ConditionDefinition
        self.ConditionDefinition_nsprefix_ = None
        self.Consent = Consent
        self.Consent_nsprefix_ = None
        self.Contract = Contract
        self.Contract_nsprefix_ = None
        self.Coverage = Coverage
        self.Coverage_nsprefix_ = None
        self.CoverageEligibilityRequest = CoverageEligibilityRequest
        self.CoverageEligibilityRequest_nsprefix_ = None
        self.CoverageEligibilityResponse = CoverageEligibilityResponse
        self.CoverageEligibilityResponse_nsprefix_ = None
        self.DetectedIssue = DetectedIssue
        self.DetectedIssue_nsprefix_ = None
        self.Device = Device
        self.Device_nsprefix_ = None
        self.DeviceAssociation = DeviceAssociation
        self.DeviceAssociation_nsprefix_ = None
        self.DeviceDefinition = DeviceDefinition
        self.DeviceDefinition_nsprefix_ = None
        self.DeviceDispense = DeviceDispense
        self.DeviceDispense_nsprefix_ = None
        self.DeviceMetric = DeviceMetric
        self.DeviceMetric_nsprefix_ = None
        self.DeviceRequest = DeviceRequest
        self.DeviceRequest_nsprefix_ = None
        self.DeviceUsage = DeviceUsage
        self.DeviceUsage_nsprefix_ = None
        self.DiagnosticReport = DiagnosticReport
        self.DiagnosticReport_nsprefix_ = None
        self.DocumentReference = DocumentReference
        self.DocumentReference_nsprefix_ = None
        self.Encounter = Encounter
        self.Encounter_nsprefix_ = None
        self.EncounterHistory = EncounterHistory
        self.EncounterHistory_nsprefix_ = None
        self.Endpoint = Endpoint
        self.Endpoint_nsprefix_ = None
        self.EnrollmentRequest = EnrollmentRequest
        self.EnrollmentRequest_nsprefix_ = None
        self.EnrollmentResponse = EnrollmentResponse
        self.EnrollmentResponse_nsprefix_ = None
        self.EpisodeOfCare = EpisodeOfCare
        self.EpisodeOfCare_nsprefix_ = None
        self.EventDefinition = EventDefinition
        self.EventDefinition_nsprefix_ = None
        self.Evidence = Evidence
        self.Evidence_nsprefix_ = None
        self.EvidenceReport = EvidenceReport
        self.EvidenceReport_nsprefix_ = None
        self.EvidenceVariable = EvidenceVariable
        self.EvidenceVariable_nsprefix_ = None
        self.ExampleScenario = ExampleScenario
        self.ExampleScenario_nsprefix_ = None
        self.ExplanationOfBenefit = ExplanationOfBenefit
        self.ExplanationOfBenefit_nsprefix_ = None
        self.FamilyMemberHistory = FamilyMemberHistory
        self.FamilyMemberHistory_nsprefix_ = None
        self.Flag = Flag
        self.Flag_nsprefix_ = None
        self.FormularyItem = FormularyItem
        self.FormularyItem_nsprefix_ = None
        self.GenomicStudy = GenomicStudy
        self.GenomicStudy_nsprefix_ = None
        self.Goal = Goal
        self.Goal_nsprefix_ = None
        self.GraphDefinition = GraphDefinition
        self.GraphDefinition_nsprefix_ = None
        self.Group = Group
        self.Group_nsprefix_ = None
        self.GuidanceResponse = GuidanceResponse
        self.GuidanceResponse_nsprefix_ = None
        self.HealthcareService = HealthcareService
        self.HealthcareService_nsprefix_ = None
        self.ImagingSelection = ImagingSelection
        self.ImagingSelection_nsprefix_ = None
        self.ImagingStudy = ImagingStudy
        self.ImagingStudy_nsprefix_ = None
        self.Immunization = Immunization
        self.Immunization_nsprefix_ = None
        self.ImmunizationEvaluation = ImmunizationEvaluation
        self.ImmunizationEvaluation_nsprefix_ = None
        self.ImmunizationRecommendation = ImmunizationRecommendation
        self.ImmunizationRecommendation_nsprefix_ = None
        self.ImplementationGuide = ImplementationGuide
        self.ImplementationGuide_nsprefix_ = None
        self.Ingredient = Ingredient
        self.Ingredient_nsprefix_ = None
        self.InsurancePlan = InsurancePlan
        self.InsurancePlan_nsprefix_ = None
        self.InventoryItem = InventoryItem
        self.InventoryItem_nsprefix_ = None
        self.InventoryReport = InventoryReport
        self.InventoryReport_nsprefix_ = None
        self.Invoice = Invoice
        self.Invoice_nsprefix_ = None
        self.Library = Library
        self.Library_nsprefix_ = None
        self.Linkage = Linkage
        self.Linkage_nsprefix_ = None
        self.List = List
        self.List_nsprefix_ = None
        self.Location = Location
        self.Location_nsprefix_ = None
        self.ManufacturedItemDefinition = ManufacturedItemDefinition
        self.ManufacturedItemDefinition_nsprefix_ = None
        self.Measure = Measure
        self.Measure_nsprefix_ = None
        self.MeasureReport = MeasureReport
        self.MeasureReport_nsprefix_ = None
        self.Medication = Medication
        self.Medication_nsprefix_ = None
        self.MedicationAdministration = MedicationAdministration
        self.MedicationAdministration_nsprefix_ = None
        self.MedicationDispense = MedicationDispense
        self.MedicationDispense_nsprefix_ = None
        self.MedicationKnowledge = MedicationKnowledge
        self.MedicationKnowledge_nsprefix_ = None
        self.MedicationRequest = MedicationRequest
        self.MedicationRequest_nsprefix_ = None
        self.MedicationStatement = MedicationStatement
        self.MedicationStatement_nsprefix_ = None
        self.MedicinalProductDefinition = MedicinalProductDefinition
        self.MedicinalProductDefinition_nsprefix_ = None
        self.MessageDefinition = MessageDefinition
        self.MessageDefinition_nsprefix_ = None
        self.MessageHeader = MessageHeader
        self.MessageHeader_nsprefix_ = None
        self.MolecularSequence = MolecularSequence
        self.MolecularSequence_nsprefix_ = None
        self.NamingSystem = NamingSystem
        self.NamingSystem_nsprefix_ = None
        self.NutritionIntake = NutritionIntake
        self.NutritionIntake_nsprefix_ = None
        self.NutritionOrder = NutritionOrder
        self.NutritionOrder_nsprefix_ = None
        self.NutritionProduct = NutritionProduct
        self.NutritionProduct_nsprefix_ = None
        self.Observation = Observation
        self.Observation_nsprefix_ = None
        self.ObservationDefinition = ObservationDefinition
        self.ObservationDefinition_nsprefix_ = None
        self.OperationDefinition = OperationDefinition
        self.OperationDefinition_nsprefix_ = None
        self.OperationOutcome = OperationOutcome
        self.OperationOutcome_nsprefix_ = None
        self.Organization = Organization
        self.Organization_nsprefix_ = None
        self.OrganizationAffiliation = OrganizationAffiliation
        self.OrganizationAffiliation_nsprefix_ = None
        self.PackagedProductDefinition = PackagedProductDefinition
        self.PackagedProductDefinition_nsprefix_ = None
        self.Patient = Patient
        self.Patient_nsprefix_ = None
        self.PaymentNotice = PaymentNotice
        self.PaymentNotice_nsprefix_ = None
        self.PaymentReconciliation = PaymentReconciliation
        self.PaymentReconciliation_nsprefix_ = None
        self.Permission = Permission
        self.Permission_nsprefix_ = None
        self.Person = Person
        self.Person_nsprefix_ = None
        self.PlanDefinition = PlanDefinition
        self.PlanDefinition_nsprefix_ = None
        self.Practitioner = Practitioner
        self.Practitioner_nsprefix_ = None
        self.PractitionerRole = PractitionerRole
        self.PractitionerRole_nsprefix_ = None
        self.Procedure = Procedure
        self.Procedure_nsprefix_ = None
        self.Provenance = Provenance
        self.Provenance_nsprefix_ = None
        self.Questionnaire = Questionnaire
        self.Questionnaire_nsprefix_ = None
        self.QuestionnaireResponse = QuestionnaireResponse
        self.QuestionnaireResponse_nsprefix_ = None
        self.RegulatedAuthorization = RegulatedAuthorization
        self.RegulatedAuthorization_nsprefix_ = None
        self.RelatedPerson = RelatedPerson
        self.RelatedPerson_nsprefix_ = None
        self.RequestOrchestration = RequestOrchestration
        self.RequestOrchestration_nsprefix_ = None
        self.Requirements = Requirements
        self.Requirements_nsprefix_ = None
        self.ResearchStudy = ResearchStudy
        self.ResearchStudy_nsprefix_ = None
        self.ResearchSubject = ResearchSubject
        self.ResearchSubject_nsprefix_ = None
        self.RiskAssessment = RiskAssessment
        self.RiskAssessment_nsprefix_ = None
        self.Schedule = Schedule
        self.Schedule_nsprefix_ = None
        self.SearchParameter = SearchParameter
        self.SearchParameter_nsprefix_ = None
        self.ServiceRequest = ServiceRequest
        self.ServiceRequest_nsprefix_ = None
        self.Slot = Slot
        self.Slot_nsprefix_ = None
        self.Specimen = Specimen
        self.Specimen_nsprefix_ = None
        self.SpecimenDefinition = SpecimenDefinition
        self.SpecimenDefinition_nsprefix_ = None
        self.StructureDefinition = StructureDefinition
        self.StructureDefinition_nsprefix_ = None
        self.StructureMap = StructureMap
        self.StructureMap_nsprefix_ = None
        self.Subscription = Subscription
        self.Subscription_nsprefix_ = None
        self.SubscriptionStatus = SubscriptionStatus
        self.SubscriptionStatus_nsprefix_ = None
        self.SubscriptionTopic = SubscriptionTopic
        self.SubscriptionTopic_nsprefix_ = None
        self.Substance = Substance
        self.Substance_nsprefix_ = None
        self.SubstanceDefinition = SubstanceDefinition
        self.SubstanceDefinition_nsprefix_ = None
        self.SubstanceNucleicAcid = SubstanceNucleicAcid
        self.SubstanceNucleicAcid_nsprefix_ = None
        self.SubstancePolymer = SubstancePolymer
        self.SubstancePolymer_nsprefix_ = None
        self.SubstanceProtein = SubstanceProtein
        self.SubstanceProtein_nsprefix_ = None
        self.SubstanceReferenceInformation = SubstanceReferenceInformation
        self.SubstanceReferenceInformation_nsprefix_ = None
        self.SubstanceSourceMaterial = SubstanceSourceMaterial
        self.SubstanceSourceMaterial_nsprefix_ = None
        self.SupplyDelivery = SupplyDelivery
        self.SupplyDelivery_nsprefix_ = None
        self.SupplyRequest = SupplyRequest
        self.SupplyRequest_nsprefix_ = None
        self.Task = Task
        self.Task_nsprefix_ = None
        self.TerminologyCapabilities = TerminologyCapabilities
        self.TerminologyCapabilities_nsprefix_ = None
        self.TestPlan = TestPlan
        self.TestPlan_nsprefix_ = None
        self.TestReport = TestReport
        self.TestReport_nsprefix_ = None
        self.TestScript = TestScript
        self.TestScript_nsprefix_ = None
        self.Transport = Transport
        self.Transport_nsprefix_ = None
        self.ValueSet = ValueSet
        self.ValueSet_nsprefix_ = None
        self.VerificationResult = VerificationResult
        self.VerificationResult_nsprefix_ = None
        self.VisionPrescription = VisionPrescription
        self.VisionPrescription_nsprefix_ = None
        self.Parameters = Parameters
        self.Parameters_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResourceContainer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResourceContainer.subclass:
            return ResourceContainer.subclass(*args_, **kwargs_)
        else:
            return ResourceContainer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Account(self):
        return self.Account
    def set_Account(self, Account):
        self.Account = Account
    def get_ActivityDefinition(self):
        return self.ActivityDefinition
    def set_ActivityDefinition(self, ActivityDefinition):
        self.ActivityDefinition = ActivityDefinition
    def get_ActorDefinition(self):
        return self.ActorDefinition
    def set_ActorDefinition(self, ActorDefinition):
        self.ActorDefinition = ActorDefinition
    def get_AdministrableProductDefinition(self):
        return self.AdministrableProductDefinition
    def set_AdministrableProductDefinition(self, AdministrableProductDefinition):
        self.AdministrableProductDefinition = AdministrableProductDefinition
    def get_AdverseEvent(self):
        return self.AdverseEvent
    def set_AdverseEvent(self, AdverseEvent):
        self.AdverseEvent = AdverseEvent
    def get_AllergyIntolerance(self):
        return self.AllergyIntolerance
    def set_AllergyIntolerance(self, AllergyIntolerance):
        self.AllergyIntolerance = AllergyIntolerance
    def get_Appointment(self):
        return self.Appointment
    def set_Appointment(self, Appointment):
        self.Appointment = Appointment
    def get_AppointmentResponse(self):
        return self.AppointmentResponse
    def set_AppointmentResponse(self, AppointmentResponse):
        self.AppointmentResponse = AppointmentResponse
    def get_ArtifactAssessment(self):
        return self.ArtifactAssessment
    def set_ArtifactAssessment(self, ArtifactAssessment):
        self.ArtifactAssessment = ArtifactAssessment
    def get_AuditEvent(self):
        return self.AuditEvent
    def set_AuditEvent(self, AuditEvent):
        self.AuditEvent = AuditEvent
    def get_Basic(self):
        return self.Basic
    def set_Basic(self, Basic):
        self.Basic = Basic
    def get_Binary(self):
        return self.Binary
    def set_Binary(self, Binary):
        self.Binary = Binary
    def get_BiologicallyDerivedProduct(self):
        return self.BiologicallyDerivedProduct
    def set_BiologicallyDerivedProduct(self, BiologicallyDerivedProduct):
        self.BiologicallyDerivedProduct = BiologicallyDerivedProduct
    def get_BiologicallyDerivedProductDispense(self):
        return self.BiologicallyDerivedProductDispense
    def set_BiologicallyDerivedProductDispense(self, BiologicallyDerivedProductDispense):
        self.BiologicallyDerivedProductDispense = BiologicallyDerivedProductDispense
    def get_BodyStructure(self):
        return self.BodyStructure
    def set_BodyStructure(self, BodyStructure):
        self.BodyStructure = BodyStructure
    def get_Bundle(self):
        return self.Bundle
    def set_Bundle(self, Bundle):
        self.Bundle = Bundle
    def get_CapabilityStatement(self):
        return self.CapabilityStatement
    def set_CapabilityStatement(self, CapabilityStatement):
        self.CapabilityStatement = CapabilityStatement
    def get_CarePlan(self):
        return self.CarePlan
    def set_CarePlan(self, CarePlan):
        self.CarePlan = CarePlan
    def get_CareTeam(self):
        return self.CareTeam
    def set_CareTeam(self, CareTeam):
        self.CareTeam = CareTeam
    def get_ChargeItem(self):
        return self.ChargeItem
    def set_ChargeItem(self, ChargeItem):
        self.ChargeItem = ChargeItem
    def get_ChargeItemDefinition(self):
        return self.ChargeItemDefinition
    def set_ChargeItemDefinition(self, ChargeItemDefinition):
        self.ChargeItemDefinition = ChargeItemDefinition
    def get_Citation(self):
        return self.Citation
    def set_Citation(self, Citation):
        self.Citation = Citation
    def get_Claim(self):
        return self.Claim
    def set_Claim(self, Claim):
        self.Claim = Claim
    def get_ClaimResponse(self):
        return self.ClaimResponse
    def set_ClaimResponse(self, ClaimResponse):
        self.ClaimResponse = ClaimResponse
    def get_ClinicalImpression(self):
        return self.ClinicalImpression
    def set_ClinicalImpression(self, ClinicalImpression):
        self.ClinicalImpression = ClinicalImpression
    def get_ClinicalUseDefinition(self):
        return self.ClinicalUseDefinition
    def set_ClinicalUseDefinition(self, ClinicalUseDefinition):
        self.ClinicalUseDefinition = ClinicalUseDefinition
    def get_CodeSystem(self):
        return self.CodeSystem
    def set_CodeSystem(self, CodeSystem):
        self.CodeSystem = CodeSystem
    def get_Communication(self):
        return self.Communication
    def set_Communication(self, Communication):
        self.Communication = Communication
    def get_CommunicationRequest(self):
        return self.CommunicationRequest
    def set_CommunicationRequest(self, CommunicationRequest):
        self.CommunicationRequest = CommunicationRequest
    def get_CompartmentDefinition(self):
        return self.CompartmentDefinition
    def set_CompartmentDefinition(self, CompartmentDefinition):
        self.CompartmentDefinition = CompartmentDefinition
    def get_Composition(self):
        return self.Composition
    def set_Composition(self, Composition):
        self.Composition = Composition
    def get_ConceptMap(self):
        return self.ConceptMap
    def set_ConceptMap(self, ConceptMap):
        self.ConceptMap = ConceptMap
    def get_Condition(self):
        return self.Condition
    def set_Condition(self, Condition):
        self.Condition = Condition
    def get_ConditionDefinition(self):
        return self.ConditionDefinition
    def set_ConditionDefinition(self, ConditionDefinition):
        self.ConditionDefinition = ConditionDefinition
    def get_Consent(self):
        return self.Consent
    def set_Consent(self, Consent):
        self.Consent = Consent
    def get_Contract(self):
        return self.Contract
    def set_Contract(self, Contract):
        self.Contract = Contract
    def get_Coverage(self):
        return self.Coverage
    def set_Coverage(self, Coverage):
        self.Coverage = Coverage
    def get_CoverageEligibilityRequest(self):
        return self.CoverageEligibilityRequest
    def set_CoverageEligibilityRequest(self, CoverageEligibilityRequest):
        self.CoverageEligibilityRequest = CoverageEligibilityRequest
    def get_CoverageEligibilityResponse(self):
        return self.CoverageEligibilityResponse
    def set_CoverageEligibilityResponse(self, CoverageEligibilityResponse):
        self.CoverageEligibilityResponse = CoverageEligibilityResponse
    def get_DetectedIssue(self):
        return self.DetectedIssue
    def set_DetectedIssue(self, DetectedIssue):
        self.DetectedIssue = DetectedIssue
    def get_Device(self):
        return self.Device
    def set_Device(self, Device):
        self.Device = Device
    def get_DeviceAssociation(self):
        return self.DeviceAssociation
    def set_DeviceAssociation(self, DeviceAssociation):
        self.DeviceAssociation = DeviceAssociation
    def get_DeviceDefinition(self):
        return self.DeviceDefinition
    def set_DeviceDefinition(self, DeviceDefinition):
        self.DeviceDefinition = DeviceDefinition
    def get_DeviceDispense(self):
        return self.DeviceDispense
    def set_DeviceDispense(self, DeviceDispense):
        self.DeviceDispense = DeviceDispense
    def get_DeviceMetric(self):
        return self.DeviceMetric
    def set_DeviceMetric(self, DeviceMetric):
        self.DeviceMetric = DeviceMetric
    def get_DeviceRequest(self):
        return self.DeviceRequest
    def set_DeviceRequest(self, DeviceRequest):
        self.DeviceRequest = DeviceRequest
    def get_DeviceUsage(self):
        return self.DeviceUsage
    def set_DeviceUsage(self, DeviceUsage):
        self.DeviceUsage = DeviceUsage
    def get_DiagnosticReport(self):
        return self.DiagnosticReport
    def set_DiagnosticReport(self, DiagnosticReport):
        self.DiagnosticReport = DiagnosticReport
    def get_DocumentReference(self):
        return self.DocumentReference
    def set_DocumentReference(self, DocumentReference):
        self.DocumentReference = DocumentReference
    def get_Encounter(self):
        return self.Encounter
    def set_Encounter(self, Encounter):
        self.Encounter = Encounter
    def get_EncounterHistory(self):
        return self.EncounterHistory
    def set_EncounterHistory(self, EncounterHistory):
        self.EncounterHistory = EncounterHistory
    def get_Endpoint(self):
        return self.Endpoint
    def set_Endpoint(self, Endpoint):
        self.Endpoint = Endpoint
    def get_EnrollmentRequest(self):
        return self.EnrollmentRequest
    def set_EnrollmentRequest(self, EnrollmentRequest):
        self.EnrollmentRequest = EnrollmentRequest
    def get_EnrollmentResponse(self):
        return self.EnrollmentResponse
    def set_EnrollmentResponse(self, EnrollmentResponse):
        self.EnrollmentResponse = EnrollmentResponse
    def get_EpisodeOfCare(self):
        return self.EpisodeOfCare
    def set_EpisodeOfCare(self, EpisodeOfCare):
        self.EpisodeOfCare = EpisodeOfCare
    def get_EventDefinition(self):
        return self.EventDefinition
    def set_EventDefinition(self, EventDefinition):
        self.EventDefinition = EventDefinition
    def get_Evidence(self):
        return self.Evidence
    def set_Evidence(self, Evidence):
        self.Evidence = Evidence
    def get_EvidenceReport(self):
        return self.EvidenceReport
    def set_EvidenceReport(self, EvidenceReport):
        self.EvidenceReport = EvidenceReport
    def get_EvidenceVariable(self):
        return self.EvidenceVariable
    def set_EvidenceVariable(self, EvidenceVariable):
        self.EvidenceVariable = EvidenceVariable
    def get_ExampleScenario(self):
        return self.ExampleScenario
    def set_ExampleScenario(self, ExampleScenario):
        self.ExampleScenario = ExampleScenario
    def get_ExplanationOfBenefit(self):
        return self.ExplanationOfBenefit
    def set_ExplanationOfBenefit(self, ExplanationOfBenefit):
        self.ExplanationOfBenefit = ExplanationOfBenefit
    def get_FamilyMemberHistory(self):
        return self.FamilyMemberHistory
    def set_FamilyMemberHistory(self, FamilyMemberHistory):
        self.FamilyMemberHistory = FamilyMemberHistory
    def get_Flag(self):
        return self.Flag
    def set_Flag(self, Flag):
        self.Flag = Flag
    def get_FormularyItem(self):
        return self.FormularyItem
    def set_FormularyItem(self, FormularyItem):
        self.FormularyItem = FormularyItem
    def get_GenomicStudy(self):
        return self.GenomicStudy
    def set_GenomicStudy(self, GenomicStudy):
        self.GenomicStudy = GenomicStudy
    def get_Goal(self):
        return self.Goal
    def set_Goal(self, Goal):
        self.Goal = Goal
    def get_GraphDefinition(self):
        return self.GraphDefinition
    def set_GraphDefinition(self, GraphDefinition):
        self.GraphDefinition = GraphDefinition
    def get_Group(self):
        return self.Group
    def set_Group(self, Group):
        self.Group = Group
    def get_GuidanceResponse(self):
        return self.GuidanceResponse
    def set_GuidanceResponse(self, GuidanceResponse):
        self.GuidanceResponse = GuidanceResponse
    def get_HealthcareService(self):
        return self.HealthcareService
    def set_HealthcareService(self, HealthcareService):
        self.HealthcareService = HealthcareService
    def get_ImagingSelection(self):
        return self.ImagingSelection
    def set_ImagingSelection(self, ImagingSelection):
        self.ImagingSelection = ImagingSelection
    def get_ImagingStudy(self):
        return self.ImagingStudy
    def set_ImagingStudy(self, ImagingStudy):
        self.ImagingStudy = ImagingStudy
    def get_Immunization(self):
        return self.Immunization
    def set_Immunization(self, Immunization):
        self.Immunization = Immunization
    def get_ImmunizationEvaluation(self):
        return self.ImmunizationEvaluation
    def set_ImmunizationEvaluation(self, ImmunizationEvaluation):
        self.ImmunizationEvaluation = ImmunizationEvaluation
    def get_ImmunizationRecommendation(self):
        return self.ImmunizationRecommendation
    def set_ImmunizationRecommendation(self, ImmunizationRecommendation):
        self.ImmunizationRecommendation = ImmunizationRecommendation
    def get_ImplementationGuide(self):
        return self.ImplementationGuide
    def set_ImplementationGuide(self, ImplementationGuide):
        self.ImplementationGuide = ImplementationGuide
    def get_Ingredient(self):
        return self.Ingredient
    def set_Ingredient(self, Ingredient):
        self.Ingredient = Ingredient
    def get_InsurancePlan(self):
        return self.InsurancePlan
    def set_InsurancePlan(self, InsurancePlan):
        self.InsurancePlan = InsurancePlan
    def get_InventoryItem(self):
        return self.InventoryItem
    def set_InventoryItem(self, InventoryItem):
        self.InventoryItem = InventoryItem
    def get_InventoryReport(self):
        return self.InventoryReport
    def set_InventoryReport(self, InventoryReport):
        self.InventoryReport = InventoryReport
    def get_Invoice(self):
        return self.Invoice
    def set_Invoice(self, Invoice):
        self.Invoice = Invoice
    def get_Library(self):
        return self.Library
    def set_Library(self, Library):
        self.Library = Library
    def get_Linkage(self):
        return self.Linkage
    def set_Linkage(self, Linkage):
        self.Linkage = Linkage
    def get_List(self):
        return self.List
    def set_List(self, List):
        self.List = List
    def get_Location(self):
        return self.Location
    def set_Location(self, Location):
        self.Location = Location
    def get_ManufacturedItemDefinition(self):
        return self.ManufacturedItemDefinition
    def set_ManufacturedItemDefinition(self, ManufacturedItemDefinition):
        self.ManufacturedItemDefinition = ManufacturedItemDefinition
    def get_Measure(self):
        return self.Measure
    def set_Measure(self, Measure):
        self.Measure = Measure
    def get_MeasureReport(self):
        return self.MeasureReport
    def set_MeasureReport(self, MeasureReport):
        self.MeasureReport = MeasureReport
    def get_Medication(self):
        return self.Medication
    def set_Medication(self, Medication):
        self.Medication = Medication
    def get_MedicationAdministration(self):
        return self.MedicationAdministration
    def set_MedicationAdministration(self, MedicationAdministration):
        self.MedicationAdministration = MedicationAdministration
    def get_MedicationDispense(self):
        return self.MedicationDispense
    def set_MedicationDispense(self, MedicationDispense):
        self.MedicationDispense = MedicationDispense
    def get_MedicationKnowledge(self):
        return self.MedicationKnowledge
    def set_MedicationKnowledge(self, MedicationKnowledge):
        self.MedicationKnowledge = MedicationKnowledge
    def get_MedicationRequest(self):
        return self.MedicationRequest
    def set_MedicationRequest(self, MedicationRequest):
        self.MedicationRequest = MedicationRequest
    def get_MedicationStatement(self):
        return self.MedicationStatement
    def set_MedicationStatement(self, MedicationStatement):
        self.MedicationStatement = MedicationStatement
    def get_MedicinalProductDefinition(self):
        return self.MedicinalProductDefinition
    def set_MedicinalProductDefinition(self, MedicinalProductDefinition):
        self.MedicinalProductDefinition = MedicinalProductDefinition
    def get_MessageDefinition(self):
        return self.MessageDefinition
    def set_MessageDefinition(self, MessageDefinition):
        self.MessageDefinition = MessageDefinition
    def get_MessageHeader(self):
        return self.MessageHeader
    def set_MessageHeader(self, MessageHeader):
        self.MessageHeader = MessageHeader
    def get_MolecularSequence(self):
        return self.MolecularSequence
    def set_MolecularSequence(self, MolecularSequence):
        self.MolecularSequence = MolecularSequence
    def get_NamingSystem(self):
        return self.NamingSystem
    def set_NamingSystem(self, NamingSystem):
        self.NamingSystem = NamingSystem
    def get_NutritionIntake(self):
        return self.NutritionIntake
    def set_NutritionIntake(self, NutritionIntake):
        self.NutritionIntake = NutritionIntake
    def get_NutritionOrder(self):
        return self.NutritionOrder
    def set_NutritionOrder(self, NutritionOrder):
        self.NutritionOrder = NutritionOrder
    def get_NutritionProduct(self):
        return self.NutritionProduct
    def set_NutritionProduct(self, NutritionProduct):
        self.NutritionProduct = NutritionProduct
    def get_Observation(self):
        return self.Observation
    def set_Observation(self, Observation):
        self.Observation = Observation
    def get_ObservationDefinition(self):
        return self.ObservationDefinition
    def set_ObservationDefinition(self, ObservationDefinition):
        self.ObservationDefinition = ObservationDefinition
    def get_OperationDefinition(self):
        return self.OperationDefinition
    def set_OperationDefinition(self, OperationDefinition):
        self.OperationDefinition = OperationDefinition
    def get_OperationOutcome(self):
        return self.OperationOutcome
    def set_OperationOutcome(self, OperationOutcome):
        self.OperationOutcome = OperationOutcome
    def get_Organization(self):
        return self.Organization
    def set_Organization(self, Organization):
        self.Organization = Organization
    def get_OrganizationAffiliation(self):
        return self.OrganizationAffiliation
    def set_OrganizationAffiliation(self, OrganizationAffiliation):
        self.OrganizationAffiliation = OrganizationAffiliation
    def get_PackagedProductDefinition(self):
        return self.PackagedProductDefinition
    def set_PackagedProductDefinition(self, PackagedProductDefinition):
        self.PackagedProductDefinition = PackagedProductDefinition
    def get_Patient(self):
        return self.Patient
    def set_Patient(self, Patient):
        self.Patient = Patient
    def get_PaymentNotice(self):
        return self.PaymentNotice
    def set_PaymentNotice(self, PaymentNotice):
        self.PaymentNotice = PaymentNotice
    def get_PaymentReconciliation(self):
        return self.PaymentReconciliation
    def set_PaymentReconciliation(self, PaymentReconciliation):
        self.PaymentReconciliation = PaymentReconciliation
    def get_Permission(self):
        return self.Permission
    def set_Permission(self, Permission):
        self.Permission = Permission
    def get_Person(self):
        return self.Person
    def set_Person(self, Person):
        self.Person = Person
    def get_PlanDefinition(self):
        return self.PlanDefinition
    def set_PlanDefinition(self, PlanDefinition):
        self.PlanDefinition = PlanDefinition
    def get_Practitioner(self):
        return self.Practitioner
    def set_Practitioner(self, Practitioner):
        self.Practitioner = Practitioner
    def get_PractitionerRole(self):
        return self.PractitionerRole
    def set_PractitionerRole(self, PractitionerRole):
        self.PractitionerRole = PractitionerRole
    def get_Procedure(self):
        return self.Procedure
    def set_Procedure(self, Procedure):
        self.Procedure = Procedure
    def get_Provenance(self):
        return self.Provenance
    def set_Provenance(self, Provenance):
        self.Provenance = Provenance
    def get_Questionnaire(self):
        return self.Questionnaire
    def set_Questionnaire(self, Questionnaire):
        self.Questionnaire = Questionnaire
    def get_QuestionnaireResponse(self):
        return self.QuestionnaireResponse
    def set_QuestionnaireResponse(self, QuestionnaireResponse):
        self.QuestionnaireResponse = QuestionnaireResponse
    def get_RegulatedAuthorization(self):
        return self.RegulatedAuthorization
    def set_RegulatedAuthorization(self, RegulatedAuthorization):
        self.RegulatedAuthorization = RegulatedAuthorization
    def get_RelatedPerson(self):
        return self.RelatedPerson
    def set_RelatedPerson(self, RelatedPerson):
        self.RelatedPerson = RelatedPerson
    def get_RequestOrchestration(self):
        return self.RequestOrchestration
    def set_RequestOrchestration(self, RequestOrchestration):
        self.RequestOrchestration = RequestOrchestration
    def get_Requirements(self):
        return self.Requirements
    def set_Requirements(self, Requirements):
        self.Requirements = Requirements
    def get_ResearchStudy(self):
        return self.ResearchStudy
    def set_ResearchStudy(self, ResearchStudy):
        self.ResearchStudy = ResearchStudy
    def get_ResearchSubject(self):
        return self.ResearchSubject
    def set_ResearchSubject(self, ResearchSubject):
        self.ResearchSubject = ResearchSubject
    def get_RiskAssessment(self):
        return self.RiskAssessment
    def set_RiskAssessment(self, RiskAssessment):
        self.RiskAssessment = RiskAssessment
    def get_Schedule(self):
        return self.Schedule
    def set_Schedule(self, Schedule):
        self.Schedule = Schedule
    def get_SearchParameter(self):
        return self.SearchParameter
    def set_SearchParameter(self, SearchParameter):
        self.SearchParameter = SearchParameter
    def get_ServiceRequest(self):
        return self.ServiceRequest
    def set_ServiceRequest(self, ServiceRequest):
        self.ServiceRequest = ServiceRequest
    def get_Slot(self):
        return self.Slot
    def set_Slot(self, Slot):
        self.Slot = Slot
    def get_Specimen(self):
        return self.Specimen
    def set_Specimen(self, Specimen):
        self.Specimen = Specimen
    def get_SpecimenDefinition(self):
        return self.SpecimenDefinition
    def set_SpecimenDefinition(self, SpecimenDefinition):
        self.SpecimenDefinition = SpecimenDefinition
    def get_StructureDefinition(self):
        return self.StructureDefinition
    def set_StructureDefinition(self, StructureDefinition):
        self.StructureDefinition = StructureDefinition
    def get_StructureMap(self):
        return self.StructureMap
    def set_StructureMap(self, StructureMap):
        self.StructureMap = StructureMap
    def get_Subscription(self):
        return self.Subscription
    def set_Subscription(self, Subscription):
        self.Subscription = Subscription
    def get_SubscriptionStatus(self):
        return self.SubscriptionStatus
    def set_SubscriptionStatus(self, SubscriptionStatus):
        self.SubscriptionStatus = SubscriptionStatus
    def get_SubscriptionTopic(self):
        return self.SubscriptionTopic
    def set_SubscriptionTopic(self, SubscriptionTopic):
        self.SubscriptionTopic = SubscriptionTopic
    def get_Substance(self):
        return self.Substance
    def set_Substance(self, Substance):
        self.Substance = Substance
    def get_SubstanceDefinition(self):
        return self.SubstanceDefinition
    def set_SubstanceDefinition(self, SubstanceDefinition):
        self.SubstanceDefinition = SubstanceDefinition
    def get_SubstanceNucleicAcid(self):
        return self.SubstanceNucleicAcid
    def set_SubstanceNucleicAcid(self, SubstanceNucleicAcid):
        self.SubstanceNucleicAcid = SubstanceNucleicAcid
    def get_SubstancePolymer(self):
        return self.SubstancePolymer
    def set_SubstancePolymer(self, SubstancePolymer):
        self.SubstancePolymer = SubstancePolymer
    def get_SubstanceProtein(self):
        return self.SubstanceProtein
    def set_SubstanceProtein(self, SubstanceProtein):
        self.SubstanceProtein = SubstanceProtein
    def get_SubstanceReferenceInformation(self):
        return self.SubstanceReferenceInformation
    def set_SubstanceReferenceInformation(self, SubstanceReferenceInformation):
        self.SubstanceReferenceInformation = SubstanceReferenceInformation
    def get_SubstanceSourceMaterial(self):
        return self.SubstanceSourceMaterial
    def set_SubstanceSourceMaterial(self, SubstanceSourceMaterial):
        self.SubstanceSourceMaterial = SubstanceSourceMaterial
    def get_SupplyDelivery(self):
        return self.SupplyDelivery
    def set_SupplyDelivery(self, SupplyDelivery):
        self.SupplyDelivery = SupplyDelivery
    def get_SupplyRequest(self):
        return self.SupplyRequest
    def set_SupplyRequest(self, SupplyRequest):
        self.SupplyRequest = SupplyRequest
    def get_Task(self):
        return self.Task
    def set_Task(self, Task):
        self.Task = Task
    def get_TerminologyCapabilities(self):
        return self.TerminologyCapabilities
    def set_TerminologyCapabilities(self, TerminologyCapabilities):
        self.TerminologyCapabilities = TerminologyCapabilities
    def get_TestPlan(self):
        return self.TestPlan
    def set_TestPlan(self, TestPlan):
        self.TestPlan = TestPlan
    def get_TestReport(self):
        return self.TestReport
    def set_TestReport(self, TestReport):
        self.TestReport = TestReport
    def get_TestScript(self):
        return self.TestScript
    def set_TestScript(self, TestScript):
        self.TestScript = TestScript
    def get_Transport(self):
        return self.Transport
    def set_Transport(self, Transport):
        self.Transport = Transport
    def get_ValueSet(self):
        return self.ValueSet
    def set_ValueSet(self, ValueSet):
        self.ValueSet = ValueSet
    def get_VerificationResult(self):
        return self.VerificationResult
    def set_VerificationResult(self, VerificationResult):
        self.VerificationResult = VerificationResult
    def get_VisionPrescription(self):
        return self.VisionPrescription
    def set_VisionPrescription(self, VisionPrescription):
        self.VisionPrescription = VisionPrescription
    def get_Parameters(self):
        return self.Parameters
    def set_Parameters(self, Parameters):
        self.Parameters = Parameters
    def has__content(self):
        if (
            self.Account is not None or
            self.ActivityDefinition is not None or
            self.ActorDefinition is not None or
            self.AdministrableProductDefinition is not None or
            self.AdverseEvent is not None or
            self.AllergyIntolerance is not None or
            self.Appointment is not None or
            self.AppointmentResponse is not None or
            self.ArtifactAssessment is not None or
            self.AuditEvent is not None or
            self.Basic is not None or
            self.Binary is not None or
            self.BiologicallyDerivedProduct is not None or
            self.BiologicallyDerivedProductDispense is not None or
            self.BodyStructure is not None or
            self.Bundle is not None or
            self.CapabilityStatement is not None or
            self.CarePlan is not None or
            self.CareTeam is not None or
            self.ChargeItem is not None or
            self.ChargeItemDefinition is not None or
            self.Citation is not None or
            self.Claim is not None or
            self.ClaimResponse is not None or
            self.ClinicalImpression is not None or
            self.ClinicalUseDefinition is not None or
            self.CodeSystem is not None or
            self.Communication is not None or
            self.CommunicationRequest is not None or
            self.CompartmentDefinition is not None or
            self.Composition is not None or
            self.ConceptMap is not None or
            self.Condition is not None or
            self.ConditionDefinition is not None or
            self.Consent is not None or
            self.Contract is not None or
            self.Coverage is not None or
            self.CoverageEligibilityRequest is not None or
            self.CoverageEligibilityResponse is not None or
            self.DetectedIssue is not None or
            self.Device is not None or
            self.DeviceAssociation is not None or
            self.DeviceDefinition is not None or
            self.DeviceDispense is not None or
            self.DeviceMetric is not None or
            self.DeviceRequest is not None or
            self.DeviceUsage is not None or
            self.DiagnosticReport is not None or
            self.DocumentReference is not None or
            self.Encounter is not None or
            self.EncounterHistory is not None or
            self.Endpoint is not None or
            self.EnrollmentRequest is not None or
            self.EnrollmentResponse is not None or
            self.EpisodeOfCare is not None or
            self.EventDefinition is not None or
            self.Evidence is not None or
            self.EvidenceReport is not None or
            self.EvidenceVariable is not None or
            self.ExampleScenario is not None or
            self.ExplanationOfBenefit is not None or
            self.FamilyMemberHistory is not None or
            self.Flag is not None or
            self.FormularyItem is not None or
            self.GenomicStudy is not None or
            self.Goal is not None or
            self.GraphDefinition is not None or
            self.Group is not None or
            self.GuidanceResponse is not None or
            self.HealthcareService is not None or
            self.ImagingSelection is not None or
            self.ImagingStudy is not None or
            self.Immunization is not None or
            self.ImmunizationEvaluation is not None or
            self.ImmunizationRecommendation is not None or
            self.ImplementationGuide is not None or
            self.Ingredient is not None or
            self.InsurancePlan is not None or
            self.InventoryItem is not None or
            self.InventoryReport is not None or
            self.Invoice is not None or
            self.Library is not None or
            self.Linkage is not None or
            self.List is not None or
            self.Location is not None or
            self.ManufacturedItemDefinition is not None or
            self.Measure is not None or
            self.MeasureReport is not None or
            self.Medication is not None or
            self.MedicationAdministration is not None or
            self.MedicationDispense is not None or
            self.MedicationKnowledge is not None or
            self.MedicationRequest is not None or
            self.MedicationStatement is not None or
            self.MedicinalProductDefinition is not None or
            self.MessageDefinition is not None or
            self.MessageHeader is not None or
            self.MolecularSequence is not None or
            self.NamingSystem is not None or
            self.NutritionIntake is not None or
            self.NutritionOrder is not None or
            self.NutritionProduct is not None or
            self.Observation is not None or
            self.ObservationDefinition is not None or
            self.OperationDefinition is not None or
            self.OperationOutcome is not None or
            self.Organization is not None or
            self.OrganizationAffiliation is not None or
            self.PackagedProductDefinition is not None or
            self.Patient is not None or
            self.PaymentNotice is not None or
            self.PaymentReconciliation is not None or
            self.Permission is not None or
            self.Person is not None or
            self.PlanDefinition is not None or
            self.Practitioner is not None or
            self.PractitionerRole is not None or
            self.Procedure is not None or
            self.Provenance is not None or
            self.Questionnaire is not None or
            self.QuestionnaireResponse is not None or
            self.RegulatedAuthorization is not None or
            self.RelatedPerson is not None or
            self.RequestOrchestration is not None or
            self.Requirements is not None or
            self.ResearchStudy is not None or
            self.ResearchSubject is not None or
            self.RiskAssessment is not None or
            self.Schedule is not None or
            self.SearchParameter is not None or
            self.ServiceRequest is not None or
            self.Slot is not None or
            self.Specimen is not None or
            self.SpecimenDefinition is not None or
            self.StructureDefinition is not None or
            self.StructureMap is not None or
            self.Subscription is not None or
            self.SubscriptionStatus is not None or
            self.SubscriptionTopic is not None or
            self.Substance is not None or
            self.SubstanceDefinition is not None or
            self.SubstanceNucleicAcid is not None or
            self.SubstancePolymer is not None or
            self.SubstanceProtein is not None or
            self.SubstanceReferenceInformation is not None or
            self.SubstanceSourceMaterial is not None or
            self.SupplyDelivery is not None or
            self.SupplyRequest is not None or
            self.Task is not None or
            self.TerminologyCapabilities is not None or
            self.TestPlan is not None or
            self.TestReport is not None or
            self.TestScript is not None or
            self.Transport is not None or
            self.ValueSet is not None or
            self.VerificationResult is not None or
            self.VisionPrescription is not None or
            self.Parameters is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ResourceContainer', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResourceContainer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResourceContainer':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResourceContainer')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResourceContainer', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResourceContainer'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ResourceContainer', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Account is not None:
            namespaceprefix_ = self.Account_nsprefix_ + ':' if (UseCapturedNS_ and self.Account_nsprefix_) else ''
            self.Account.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Account', pretty_print=pretty_print)
        if self.ActivityDefinition is not None:
            namespaceprefix_ = self.ActivityDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ActivityDefinition_nsprefix_) else ''
            self.ActivityDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ActivityDefinition', pretty_print=pretty_print)
        if self.ActorDefinition is not None:
            namespaceprefix_ = self.ActorDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ActorDefinition_nsprefix_) else ''
            self.ActorDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ActorDefinition', pretty_print=pretty_print)
        if self.AdministrableProductDefinition is not None:
            namespaceprefix_ = self.AdministrableProductDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.AdministrableProductDefinition_nsprefix_) else ''
            self.AdministrableProductDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdministrableProductDefinition', pretty_print=pretty_print)
        if self.AdverseEvent is not None:
            namespaceprefix_ = self.AdverseEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.AdverseEvent_nsprefix_) else ''
            self.AdverseEvent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdverseEvent', pretty_print=pretty_print)
        if self.AllergyIntolerance is not None:
            namespaceprefix_ = self.AllergyIntolerance_nsprefix_ + ':' if (UseCapturedNS_ and self.AllergyIntolerance_nsprefix_) else ''
            self.AllergyIntolerance.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AllergyIntolerance', pretty_print=pretty_print)
        if self.Appointment is not None:
            namespaceprefix_ = self.Appointment_nsprefix_ + ':' if (UseCapturedNS_ and self.Appointment_nsprefix_) else ''
            self.Appointment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Appointment', pretty_print=pretty_print)
        if self.AppointmentResponse is not None:
            namespaceprefix_ = self.AppointmentResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.AppointmentResponse_nsprefix_) else ''
            self.AppointmentResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AppointmentResponse', pretty_print=pretty_print)
        if self.ArtifactAssessment is not None:
            namespaceprefix_ = self.ArtifactAssessment_nsprefix_ + ':' if (UseCapturedNS_ and self.ArtifactAssessment_nsprefix_) else ''
            self.ArtifactAssessment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ArtifactAssessment', pretty_print=pretty_print)
        if self.AuditEvent is not None:
            namespaceprefix_ = self.AuditEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.AuditEvent_nsprefix_) else ''
            self.AuditEvent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuditEvent', pretty_print=pretty_print)
        if self.Basic is not None:
            namespaceprefix_ = self.Basic_nsprefix_ + ':' if (UseCapturedNS_ and self.Basic_nsprefix_) else ''
            self.Basic.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Basic', pretty_print=pretty_print)
        if self.Binary is not None:
            namespaceprefix_ = self.Binary_nsprefix_ + ':' if (UseCapturedNS_ and self.Binary_nsprefix_) else ''
            self.Binary.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Binary', pretty_print=pretty_print)
        if self.BiologicallyDerivedProduct is not None:
            namespaceprefix_ = self.BiologicallyDerivedProduct_nsprefix_ + ':' if (UseCapturedNS_ and self.BiologicallyDerivedProduct_nsprefix_) else ''
            self.BiologicallyDerivedProduct.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BiologicallyDerivedProduct', pretty_print=pretty_print)
        if self.BiologicallyDerivedProductDispense is not None:
            namespaceprefix_ = self.BiologicallyDerivedProductDispense_nsprefix_ + ':' if (UseCapturedNS_ and self.BiologicallyDerivedProductDispense_nsprefix_) else ''
            self.BiologicallyDerivedProductDispense.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BiologicallyDerivedProductDispense', pretty_print=pretty_print)
        if self.BodyStructure is not None:
            namespaceprefix_ = self.BodyStructure_nsprefix_ + ':' if (UseCapturedNS_ and self.BodyStructure_nsprefix_) else ''
            self.BodyStructure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BodyStructure', pretty_print=pretty_print)
        if self.Bundle is not None:
            namespaceprefix_ = self.Bundle_nsprefix_ + ':' if (UseCapturedNS_ and self.Bundle_nsprefix_) else ''
            self.Bundle.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Bundle', pretty_print=pretty_print)
        if self.CapabilityStatement is not None:
            namespaceprefix_ = self.CapabilityStatement_nsprefix_ + ':' if (UseCapturedNS_ and self.CapabilityStatement_nsprefix_) else ''
            self.CapabilityStatement.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CapabilityStatement', pretty_print=pretty_print)
        if self.CarePlan is not None:
            namespaceprefix_ = self.CarePlan_nsprefix_ + ':' if (UseCapturedNS_ and self.CarePlan_nsprefix_) else ''
            self.CarePlan.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CarePlan', pretty_print=pretty_print)
        if self.CareTeam is not None:
            namespaceprefix_ = self.CareTeam_nsprefix_ + ':' if (UseCapturedNS_ and self.CareTeam_nsprefix_) else ''
            self.CareTeam.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CareTeam', pretty_print=pretty_print)
        if self.ChargeItem is not None:
            namespaceprefix_ = self.ChargeItem_nsprefix_ + ':' if (UseCapturedNS_ and self.ChargeItem_nsprefix_) else ''
            self.ChargeItem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ChargeItem', pretty_print=pretty_print)
        if self.ChargeItemDefinition is not None:
            namespaceprefix_ = self.ChargeItemDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ChargeItemDefinition_nsprefix_) else ''
            self.ChargeItemDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ChargeItemDefinition', pretty_print=pretty_print)
        if self.Citation is not None:
            namespaceprefix_ = self.Citation_nsprefix_ + ':' if (UseCapturedNS_ and self.Citation_nsprefix_) else ''
            self.Citation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Citation', pretty_print=pretty_print)
        if self.Claim is not None:
            namespaceprefix_ = self.Claim_nsprefix_ + ':' if (UseCapturedNS_ and self.Claim_nsprefix_) else ''
            self.Claim.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Claim', pretty_print=pretty_print)
        if self.ClaimResponse is not None:
            namespaceprefix_ = self.ClaimResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.ClaimResponse_nsprefix_) else ''
            self.ClaimResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ClaimResponse', pretty_print=pretty_print)
        if self.ClinicalImpression is not None:
            namespaceprefix_ = self.ClinicalImpression_nsprefix_ + ':' if (UseCapturedNS_ and self.ClinicalImpression_nsprefix_) else ''
            self.ClinicalImpression.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ClinicalImpression', pretty_print=pretty_print)
        if self.ClinicalUseDefinition is not None:
            namespaceprefix_ = self.ClinicalUseDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ClinicalUseDefinition_nsprefix_) else ''
            self.ClinicalUseDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ClinicalUseDefinition', pretty_print=pretty_print)
        if self.CodeSystem is not None:
            namespaceprefix_ = self.CodeSystem_nsprefix_ + ':' if (UseCapturedNS_ and self.CodeSystem_nsprefix_) else ''
            self.CodeSystem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CodeSystem', pretty_print=pretty_print)
        if self.Communication is not None:
            namespaceprefix_ = self.Communication_nsprefix_ + ':' if (UseCapturedNS_ and self.Communication_nsprefix_) else ''
            self.Communication.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Communication', pretty_print=pretty_print)
        if self.CommunicationRequest is not None:
            namespaceprefix_ = self.CommunicationRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.CommunicationRequest_nsprefix_) else ''
            self.CommunicationRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CommunicationRequest', pretty_print=pretty_print)
        if self.CompartmentDefinition is not None:
            namespaceprefix_ = self.CompartmentDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.CompartmentDefinition_nsprefix_) else ''
            self.CompartmentDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CompartmentDefinition', pretty_print=pretty_print)
        if self.Composition is not None:
            namespaceprefix_ = self.Composition_nsprefix_ + ':' if (UseCapturedNS_ and self.Composition_nsprefix_) else ''
            self.Composition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Composition', pretty_print=pretty_print)
        if self.ConceptMap is not None:
            namespaceprefix_ = self.ConceptMap_nsprefix_ + ':' if (UseCapturedNS_ and self.ConceptMap_nsprefix_) else ''
            self.ConceptMap.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ConceptMap', pretty_print=pretty_print)
        if self.Condition is not None:
            namespaceprefix_ = self.Condition_nsprefix_ + ':' if (UseCapturedNS_ and self.Condition_nsprefix_) else ''
            self.Condition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Condition', pretty_print=pretty_print)
        if self.ConditionDefinition is not None:
            namespaceprefix_ = self.ConditionDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ConditionDefinition_nsprefix_) else ''
            self.ConditionDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ConditionDefinition', pretty_print=pretty_print)
        if self.Consent is not None:
            namespaceprefix_ = self.Consent_nsprefix_ + ':' if (UseCapturedNS_ and self.Consent_nsprefix_) else ''
            self.Consent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Consent', pretty_print=pretty_print)
        if self.Contract is not None:
            namespaceprefix_ = self.Contract_nsprefix_ + ':' if (UseCapturedNS_ and self.Contract_nsprefix_) else ''
            self.Contract.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Contract', pretty_print=pretty_print)
        if self.Coverage is not None:
            namespaceprefix_ = self.Coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.Coverage_nsprefix_) else ''
            self.Coverage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Coverage', pretty_print=pretty_print)
        if self.CoverageEligibilityRequest is not None:
            namespaceprefix_ = self.CoverageEligibilityRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.CoverageEligibilityRequest_nsprefix_) else ''
            self.CoverageEligibilityRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CoverageEligibilityRequest', pretty_print=pretty_print)
        if self.CoverageEligibilityResponse is not None:
            namespaceprefix_ = self.CoverageEligibilityResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.CoverageEligibilityResponse_nsprefix_) else ''
            self.CoverageEligibilityResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CoverageEligibilityResponse', pretty_print=pretty_print)
        if self.DetectedIssue is not None:
            namespaceprefix_ = self.DetectedIssue_nsprefix_ + ':' if (UseCapturedNS_ and self.DetectedIssue_nsprefix_) else ''
            self.DetectedIssue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DetectedIssue', pretty_print=pretty_print)
        if self.Device is not None:
            namespaceprefix_ = self.Device_nsprefix_ + ':' if (UseCapturedNS_ and self.Device_nsprefix_) else ''
            self.Device.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Device', pretty_print=pretty_print)
        if self.DeviceAssociation is not None:
            namespaceprefix_ = self.DeviceAssociation_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceAssociation_nsprefix_) else ''
            self.DeviceAssociation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceAssociation', pretty_print=pretty_print)
        if self.DeviceDefinition is not None:
            namespaceprefix_ = self.DeviceDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceDefinition_nsprefix_) else ''
            self.DeviceDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceDefinition', pretty_print=pretty_print)
        if self.DeviceDispense is not None:
            namespaceprefix_ = self.DeviceDispense_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceDispense_nsprefix_) else ''
            self.DeviceDispense.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceDispense', pretty_print=pretty_print)
        if self.DeviceMetric is not None:
            namespaceprefix_ = self.DeviceMetric_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceMetric_nsprefix_) else ''
            self.DeviceMetric.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceMetric', pretty_print=pretty_print)
        if self.DeviceRequest is not None:
            namespaceprefix_ = self.DeviceRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceRequest_nsprefix_) else ''
            self.DeviceRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceRequest', pretty_print=pretty_print)
        if self.DeviceUsage is not None:
            namespaceprefix_ = self.DeviceUsage_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceUsage_nsprefix_) else ''
            self.DeviceUsage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceUsage', pretty_print=pretty_print)
        if self.DiagnosticReport is not None:
            namespaceprefix_ = self.DiagnosticReport_nsprefix_ + ':' if (UseCapturedNS_ and self.DiagnosticReport_nsprefix_) else ''
            self.DiagnosticReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DiagnosticReport', pretty_print=pretty_print)
        if self.DocumentReference is not None:
            namespaceprefix_ = self.DocumentReference_nsprefix_ + ':' if (UseCapturedNS_ and self.DocumentReference_nsprefix_) else ''
            self.DocumentReference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DocumentReference', pretty_print=pretty_print)
        if self.Encounter is not None:
            namespaceprefix_ = self.Encounter_nsprefix_ + ':' if (UseCapturedNS_ and self.Encounter_nsprefix_) else ''
            self.Encounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Encounter', pretty_print=pretty_print)
        if self.EncounterHistory is not None:
            namespaceprefix_ = self.EncounterHistory_nsprefix_ + ':' if (UseCapturedNS_ and self.EncounterHistory_nsprefix_) else ''
            self.EncounterHistory.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EncounterHistory', pretty_print=pretty_print)
        if self.Endpoint is not None:
            namespaceprefix_ = self.Endpoint_nsprefix_ + ':' if (UseCapturedNS_ and self.Endpoint_nsprefix_) else ''
            self.Endpoint.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Endpoint', pretty_print=pretty_print)
        if self.EnrollmentRequest is not None:
            namespaceprefix_ = self.EnrollmentRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.EnrollmentRequest_nsprefix_) else ''
            self.EnrollmentRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EnrollmentRequest', pretty_print=pretty_print)
        if self.EnrollmentResponse is not None:
            namespaceprefix_ = self.EnrollmentResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.EnrollmentResponse_nsprefix_) else ''
            self.EnrollmentResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EnrollmentResponse', pretty_print=pretty_print)
        if self.EpisodeOfCare is not None:
            namespaceprefix_ = self.EpisodeOfCare_nsprefix_ + ':' if (UseCapturedNS_ and self.EpisodeOfCare_nsprefix_) else ''
            self.EpisodeOfCare.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EpisodeOfCare', pretty_print=pretty_print)
        if self.EventDefinition is not None:
            namespaceprefix_ = self.EventDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.EventDefinition_nsprefix_) else ''
            self.EventDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EventDefinition', pretty_print=pretty_print)
        if self.Evidence is not None:
            namespaceprefix_ = self.Evidence_nsprefix_ + ':' if (UseCapturedNS_ and self.Evidence_nsprefix_) else ''
            self.Evidence.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Evidence', pretty_print=pretty_print)
        if self.EvidenceReport is not None:
            namespaceprefix_ = self.EvidenceReport_nsprefix_ + ':' if (UseCapturedNS_ and self.EvidenceReport_nsprefix_) else ''
            self.EvidenceReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EvidenceReport', pretty_print=pretty_print)
        if self.EvidenceVariable is not None:
            namespaceprefix_ = self.EvidenceVariable_nsprefix_ + ':' if (UseCapturedNS_ and self.EvidenceVariable_nsprefix_) else ''
            self.EvidenceVariable.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EvidenceVariable', pretty_print=pretty_print)
        if self.ExampleScenario is not None:
            namespaceprefix_ = self.ExampleScenario_nsprefix_ + ':' if (UseCapturedNS_ and self.ExampleScenario_nsprefix_) else ''
            self.ExampleScenario.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ExampleScenario', pretty_print=pretty_print)
        if self.ExplanationOfBenefit is not None:
            namespaceprefix_ = self.ExplanationOfBenefit_nsprefix_ + ':' if (UseCapturedNS_ and self.ExplanationOfBenefit_nsprefix_) else ''
            self.ExplanationOfBenefit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ExplanationOfBenefit', pretty_print=pretty_print)
        if self.FamilyMemberHistory is not None:
            namespaceprefix_ = self.FamilyMemberHistory_nsprefix_ + ':' if (UseCapturedNS_ and self.FamilyMemberHistory_nsprefix_) else ''
            self.FamilyMemberHistory.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FamilyMemberHistory', pretty_print=pretty_print)
        if self.Flag is not None:
            namespaceprefix_ = self.Flag_nsprefix_ + ':' if (UseCapturedNS_ and self.Flag_nsprefix_) else ''
            self.Flag.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Flag', pretty_print=pretty_print)
        if self.FormularyItem is not None:
            namespaceprefix_ = self.FormularyItem_nsprefix_ + ':' if (UseCapturedNS_ and self.FormularyItem_nsprefix_) else ''
            self.FormularyItem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FormularyItem', pretty_print=pretty_print)
        if self.GenomicStudy is not None:
            namespaceprefix_ = self.GenomicStudy_nsprefix_ + ':' if (UseCapturedNS_ and self.GenomicStudy_nsprefix_) else ''
            self.GenomicStudy.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GenomicStudy', pretty_print=pretty_print)
        if self.Goal is not None:
            namespaceprefix_ = self.Goal_nsprefix_ + ':' if (UseCapturedNS_ and self.Goal_nsprefix_) else ''
            self.Goal.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Goal', pretty_print=pretty_print)
        if self.GraphDefinition is not None:
            namespaceprefix_ = self.GraphDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.GraphDefinition_nsprefix_) else ''
            self.GraphDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GraphDefinition', pretty_print=pretty_print)
        if self.Group is not None:
            namespaceprefix_ = self.Group_nsprefix_ + ':' if (UseCapturedNS_ and self.Group_nsprefix_) else ''
            self.Group.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Group', pretty_print=pretty_print)
        if self.GuidanceResponse is not None:
            namespaceprefix_ = self.GuidanceResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.GuidanceResponse_nsprefix_) else ''
            self.GuidanceResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GuidanceResponse', pretty_print=pretty_print)
        if self.HealthcareService is not None:
            namespaceprefix_ = self.HealthcareService_nsprefix_ + ':' if (UseCapturedNS_ and self.HealthcareService_nsprefix_) else ''
            self.HealthcareService.export(outfile, level, namespaceprefix_, namespacedef_='', name_='HealthcareService', pretty_print=pretty_print)
        if self.ImagingSelection is not None:
            namespaceprefix_ = self.ImagingSelection_nsprefix_ + ':' if (UseCapturedNS_ and self.ImagingSelection_nsprefix_) else ''
            self.ImagingSelection.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImagingSelection', pretty_print=pretty_print)
        if self.ImagingStudy is not None:
            namespaceprefix_ = self.ImagingStudy_nsprefix_ + ':' if (UseCapturedNS_ and self.ImagingStudy_nsprefix_) else ''
            self.ImagingStudy.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImagingStudy', pretty_print=pretty_print)
        if self.Immunization is not None:
            namespaceprefix_ = self.Immunization_nsprefix_ + ':' if (UseCapturedNS_ and self.Immunization_nsprefix_) else ''
            self.Immunization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Immunization', pretty_print=pretty_print)
        if self.ImmunizationEvaluation is not None:
            namespaceprefix_ = self.ImmunizationEvaluation_nsprefix_ + ':' if (UseCapturedNS_ and self.ImmunizationEvaluation_nsprefix_) else ''
            self.ImmunizationEvaluation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImmunizationEvaluation', pretty_print=pretty_print)
        if self.ImmunizationRecommendation is not None:
            namespaceprefix_ = self.ImmunizationRecommendation_nsprefix_ + ':' if (UseCapturedNS_ and self.ImmunizationRecommendation_nsprefix_) else ''
            self.ImmunizationRecommendation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImmunizationRecommendation', pretty_print=pretty_print)
        if self.ImplementationGuide is not None:
            namespaceprefix_ = self.ImplementationGuide_nsprefix_ + ':' if (UseCapturedNS_ and self.ImplementationGuide_nsprefix_) else ''
            self.ImplementationGuide.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImplementationGuide', pretty_print=pretty_print)
        if self.Ingredient is not None:
            namespaceprefix_ = self.Ingredient_nsprefix_ + ':' if (UseCapturedNS_ and self.Ingredient_nsprefix_) else ''
            self.Ingredient.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Ingredient', pretty_print=pretty_print)
        if self.InsurancePlan is not None:
            namespaceprefix_ = self.InsurancePlan_nsprefix_ + ':' if (UseCapturedNS_ and self.InsurancePlan_nsprefix_) else ''
            self.InsurancePlan.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InsurancePlan', pretty_print=pretty_print)
        if self.InventoryItem is not None:
            namespaceprefix_ = self.InventoryItem_nsprefix_ + ':' if (UseCapturedNS_ and self.InventoryItem_nsprefix_) else ''
            self.InventoryItem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InventoryItem', pretty_print=pretty_print)
        if self.InventoryReport is not None:
            namespaceprefix_ = self.InventoryReport_nsprefix_ + ':' if (UseCapturedNS_ and self.InventoryReport_nsprefix_) else ''
            self.InventoryReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InventoryReport', pretty_print=pretty_print)
        if self.Invoice is not None:
            namespaceprefix_ = self.Invoice_nsprefix_ + ':' if (UseCapturedNS_ and self.Invoice_nsprefix_) else ''
            self.Invoice.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Invoice', pretty_print=pretty_print)
        if self.Library is not None:
            namespaceprefix_ = self.Library_nsprefix_ + ':' if (UseCapturedNS_ and self.Library_nsprefix_) else ''
            self.Library.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Library', pretty_print=pretty_print)
        if self.Linkage is not None:
            namespaceprefix_ = self.Linkage_nsprefix_ + ':' if (UseCapturedNS_ and self.Linkage_nsprefix_) else ''
            self.Linkage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Linkage', pretty_print=pretty_print)
        if self.List is not None:
            namespaceprefix_ = self.List_nsprefix_ + ':' if (UseCapturedNS_ and self.List_nsprefix_) else ''
            self.List.export(outfile, level, namespaceprefix_, namespacedef_='', name_='List', pretty_print=pretty_print)
        if self.Location is not None:
            namespaceprefix_ = self.Location_nsprefix_ + ':' if (UseCapturedNS_ and self.Location_nsprefix_) else ''
            self.Location.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Location', pretty_print=pretty_print)
        if self.ManufacturedItemDefinition is not None:
            namespaceprefix_ = self.ManufacturedItemDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ManufacturedItemDefinition_nsprefix_) else ''
            self.ManufacturedItemDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ManufacturedItemDefinition', pretty_print=pretty_print)
        if self.Measure is not None:
            namespaceprefix_ = self.Measure_nsprefix_ + ':' if (UseCapturedNS_ and self.Measure_nsprefix_) else ''
            self.Measure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Measure', pretty_print=pretty_print)
        if self.MeasureReport is not None:
            namespaceprefix_ = self.MeasureReport_nsprefix_ + ':' if (UseCapturedNS_ and self.MeasureReport_nsprefix_) else ''
            self.MeasureReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MeasureReport', pretty_print=pretty_print)
        if self.Medication is not None:
            namespaceprefix_ = self.Medication_nsprefix_ + ':' if (UseCapturedNS_ and self.Medication_nsprefix_) else ''
            self.Medication.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Medication', pretty_print=pretty_print)
        if self.MedicationAdministration is not None:
            namespaceprefix_ = self.MedicationAdministration_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationAdministration_nsprefix_) else ''
            self.MedicationAdministration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationAdministration', pretty_print=pretty_print)
        if self.MedicationDispense is not None:
            namespaceprefix_ = self.MedicationDispense_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationDispense_nsprefix_) else ''
            self.MedicationDispense.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationDispense', pretty_print=pretty_print)
        if self.MedicationKnowledge is not None:
            namespaceprefix_ = self.MedicationKnowledge_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationKnowledge_nsprefix_) else ''
            self.MedicationKnowledge.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationKnowledge', pretty_print=pretty_print)
        if self.MedicationRequest is not None:
            namespaceprefix_ = self.MedicationRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationRequest_nsprefix_) else ''
            self.MedicationRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationRequest', pretty_print=pretty_print)
        if self.MedicationStatement is not None:
            namespaceprefix_ = self.MedicationStatement_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationStatement_nsprefix_) else ''
            self.MedicationStatement.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationStatement', pretty_print=pretty_print)
        if self.MedicinalProductDefinition is not None:
            namespaceprefix_ = self.MedicinalProductDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicinalProductDefinition_nsprefix_) else ''
            self.MedicinalProductDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicinalProductDefinition', pretty_print=pretty_print)
        if self.MessageDefinition is not None:
            namespaceprefix_ = self.MessageDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageDefinition_nsprefix_) else ''
            self.MessageDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MessageDefinition', pretty_print=pretty_print)
        if self.MessageHeader is not None:
            namespaceprefix_ = self.MessageHeader_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageHeader_nsprefix_) else ''
            self.MessageHeader.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MessageHeader', pretty_print=pretty_print)
        if self.MolecularSequence is not None:
            namespaceprefix_ = self.MolecularSequence_nsprefix_ + ':' if (UseCapturedNS_ and self.MolecularSequence_nsprefix_) else ''
            self.MolecularSequence.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MolecularSequence', pretty_print=pretty_print)
        if self.NamingSystem is not None:
            namespaceprefix_ = self.NamingSystem_nsprefix_ + ':' if (UseCapturedNS_ and self.NamingSystem_nsprefix_) else ''
            self.NamingSystem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NamingSystem', pretty_print=pretty_print)
        if self.NutritionIntake is not None:
            namespaceprefix_ = self.NutritionIntake_nsprefix_ + ':' if (UseCapturedNS_ and self.NutritionIntake_nsprefix_) else ''
            self.NutritionIntake.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NutritionIntake', pretty_print=pretty_print)
        if self.NutritionOrder is not None:
            namespaceprefix_ = self.NutritionOrder_nsprefix_ + ':' if (UseCapturedNS_ and self.NutritionOrder_nsprefix_) else ''
            self.NutritionOrder.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NutritionOrder', pretty_print=pretty_print)
        if self.NutritionProduct is not None:
            namespaceprefix_ = self.NutritionProduct_nsprefix_ + ':' if (UseCapturedNS_ and self.NutritionProduct_nsprefix_) else ''
            self.NutritionProduct.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NutritionProduct', pretty_print=pretty_print)
        if self.Observation is not None:
            namespaceprefix_ = self.Observation_nsprefix_ + ':' if (UseCapturedNS_ and self.Observation_nsprefix_) else ''
            self.Observation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Observation', pretty_print=pretty_print)
        if self.ObservationDefinition is not None:
            namespaceprefix_ = self.ObservationDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ObservationDefinition_nsprefix_) else ''
            self.ObservationDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ObservationDefinition', pretty_print=pretty_print)
        if self.OperationDefinition is not None:
            namespaceprefix_ = self.OperationDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.OperationDefinition_nsprefix_) else ''
            self.OperationDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OperationDefinition', pretty_print=pretty_print)
        if self.OperationOutcome is not None:
            namespaceprefix_ = self.OperationOutcome_nsprefix_ + ':' if (UseCapturedNS_ and self.OperationOutcome_nsprefix_) else ''
            self.OperationOutcome.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OperationOutcome', pretty_print=pretty_print)
        if self.Organization is not None:
            namespaceprefix_ = self.Organization_nsprefix_ + ':' if (UseCapturedNS_ and self.Organization_nsprefix_) else ''
            self.Organization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Organization', pretty_print=pretty_print)
        if self.OrganizationAffiliation is not None:
            namespaceprefix_ = self.OrganizationAffiliation_nsprefix_ + ':' if (UseCapturedNS_ and self.OrganizationAffiliation_nsprefix_) else ''
            self.OrganizationAffiliation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OrganizationAffiliation', pretty_print=pretty_print)
        if self.PackagedProductDefinition is not None:
            namespaceprefix_ = self.PackagedProductDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.PackagedProductDefinition_nsprefix_) else ''
            self.PackagedProductDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackagedProductDefinition', pretty_print=pretty_print)
        if self.Patient is not None:
            namespaceprefix_ = self.Patient_nsprefix_ + ':' if (UseCapturedNS_ and self.Patient_nsprefix_) else ''
            self.Patient.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Patient', pretty_print=pretty_print)
        if self.PaymentNotice is not None:
            namespaceprefix_ = self.PaymentNotice_nsprefix_ + ':' if (UseCapturedNS_ and self.PaymentNotice_nsprefix_) else ''
            self.PaymentNotice.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PaymentNotice', pretty_print=pretty_print)
        if self.PaymentReconciliation is not None:
            namespaceprefix_ = self.PaymentReconciliation_nsprefix_ + ':' if (UseCapturedNS_ and self.PaymentReconciliation_nsprefix_) else ''
            self.PaymentReconciliation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PaymentReconciliation', pretty_print=pretty_print)
        if self.Permission is not None:
            namespaceprefix_ = self.Permission_nsprefix_ + ':' if (UseCapturedNS_ and self.Permission_nsprefix_) else ''
            self.Permission.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Permission', pretty_print=pretty_print)
        if self.Person is not None:
            namespaceprefix_ = self.Person_nsprefix_ + ':' if (UseCapturedNS_ and self.Person_nsprefix_) else ''
            self.Person.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Person', pretty_print=pretty_print)
        if self.PlanDefinition is not None:
            namespaceprefix_ = self.PlanDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.PlanDefinition_nsprefix_) else ''
            self.PlanDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PlanDefinition', pretty_print=pretty_print)
        if self.Practitioner is not None:
            namespaceprefix_ = self.Practitioner_nsprefix_ + ':' if (UseCapturedNS_ and self.Practitioner_nsprefix_) else ''
            self.Practitioner.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Practitioner', pretty_print=pretty_print)
        if self.PractitionerRole is not None:
            namespaceprefix_ = self.PractitionerRole_nsprefix_ + ':' if (UseCapturedNS_ and self.PractitionerRole_nsprefix_) else ''
            self.PractitionerRole.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PractitionerRole', pretty_print=pretty_print)
        if self.Procedure is not None:
            namespaceprefix_ = self.Procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.Procedure_nsprefix_) else ''
            self.Procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Procedure', pretty_print=pretty_print)
        if self.Provenance is not None:
            namespaceprefix_ = self.Provenance_nsprefix_ + ':' if (UseCapturedNS_ and self.Provenance_nsprefix_) else ''
            self.Provenance.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Provenance', pretty_print=pretty_print)
        if self.Questionnaire is not None:
            namespaceprefix_ = self.Questionnaire_nsprefix_ + ':' if (UseCapturedNS_ and self.Questionnaire_nsprefix_) else ''
            self.Questionnaire.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Questionnaire', pretty_print=pretty_print)
        if self.QuestionnaireResponse is not None:
            namespaceprefix_ = self.QuestionnaireResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.QuestionnaireResponse_nsprefix_) else ''
            self.QuestionnaireResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='QuestionnaireResponse', pretty_print=pretty_print)
        if self.RegulatedAuthorization is not None:
            namespaceprefix_ = self.RegulatedAuthorization_nsprefix_ + ':' if (UseCapturedNS_ and self.RegulatedAuthorization_nsprefix_) else ''
            self.RegulatedAuthorization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RegulatedAuthorization', pretty_print=pretty_print)
        if self.RelatedPerson is not None:
            namespaceprefix_ = self.RelatedPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.RelatedPerson_nsprefix_) else ''
            self.RelatedPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RelatedPerson', pretty_print=pretty_print)
        if self.RequestOrchestration is not None:
            namespaceprefix_ = self.RequestOrchestration_nsprefix_ + ':' if (UseCapturedNS_ and self.RequestOrchestration_nsprefix_) else ''
            self.RequestOrchestration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RequestOrchestration', pretty_print=pretty_print)
        if self.Requirements is not None:
            namespaceprefix_ = self.Requirements_nsprefix_ + ':' if (UseCapturedNS_ and self.Requirements_nsprefix_) else ''
            self.Requirements.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Requirements', pretty_print=pretty_print)
        if self.ResearchStudy is not None:
            namespaceprefix_ = self.ResearchStudy_nsprefix_ + ':' if (UseCapturedNS_ and self.ResearchStudy_nsprefix_) else ''
            self.ResearchStudy.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ResearchStudy', pretty_print=pretty_print)
        if self.ResearchSubject is not None:
            namespaceprefix_ = self.ResearchSubject_nsprefix_ + ':' if (UseCapturedNS_ and self.ResearchSubject_nsprefix_) else ''
            self.ResearchSubject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ResearchSubject', pretty_print=pretty_print)
        if self.RiskAssessment is not None:
            namespaceprefix_ = self.RiskAssessment_nsprefix_ + ':' if (UseCapturedNS_ and self.RiskAssessment_nsprefix_) else ''
            self.RiskAssessment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RiskAssessment', pretty_print=pretty_print)
        if self.Schedule is not None:
            namespaceprefix_ = self.Schedule_nsprefix_ + ':' if (UseCapturedNS_ and self.Schedule_nsprefix_) else ''
            self.Schedule.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Schedule', pretty_print=pretty_print)
        if self.SearchParameter is not None:
            namespaceprefix_ = self.SearchParameter_nsprefix_ + ':' if (UseCapturedNS_ and self.SearchParameter_nsprefix_) else ''
            self.SearchParameter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SearchParameter', pretty_print=pretty_print)
        if self.ServiceRequest is not None:
            namespaceprefix_ = self.ServiceRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceRequest_nsprefix_) else ''
            self.ServiceRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceRequest', pretty_print=pretty_print)
        if self.Slot is not None:
            namespaceprefix_ = self.Slot_nsprefix_ + ':' if (UseCapturedNS_ and self.Slot_nsprefix_) else ''
            self.Slot.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Slot', pretty_print=pretty_print)
        if self.Specimen is not None:
            namespaceprefix_ = self.Specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.Specimen_nsprefix_) else ''
            self.Specimen.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Specimen', pretty_print=pretty_print)
        if self.SpecimenDefinition is not None:
            namespaceprefix_ = self.SpecimenDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.SpecimenDefinition_nsprefix_) else ''
            self.SpecimenDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SpecimenDefinition', pretty_print=pretty_print)
        if self.StructureDefinition is not None:
            namespaceprefix_ = self.StructureDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.StructureDefinition_nsprefix_) else ''
            self.StructureDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StructureDefinition', pretty_print=pretty_print)
        if self.StructureMap is not None:
            namespaceprefix_ = self.StructureMap_nsprefix_ + ':' if (UseCapturedNS_ and self.StructureMap_nsprefix_) else ''
            self.StructureMap.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StructureMap', pretty_print=pretty_print)
        if self.Subscription is not None:
            namespaceprefix_ = self.Subscription_nsprefix_ + ':' if (UseCapturedNS_ and self.Subscription_nsprefix_) else ''
            self.Subscription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Subscription', pretty_print=pretty_print)
        if self.SubscriptionStatus is not None:
            namespaceprefix_ = self.SubscriptionStatus_nsprefix_ + ':' if (UseCapturedNS_ and self.SubscriptionStatus_nsprefix_) else ''
            self.SubscriptionStatus.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubscriptionStatus', pretty_print=pretty_print)
        if self.SubscriptionTopic is not None:
            namespaceprefix_ = self.SubscriptionTopic_nsprefix_ + ':' if (UseCapturedNS_ and self.SubscriptionTopic_nsprefix_) else ''
            self.SubscriptionTopic.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubscriptionTopic', pretty_print=pretty_print)
        if self.Substance is not None:
            namespaceprefix_ = self.Substance_nsprefix_ + ':' if (UseCapturedNS_ and self.Substance_nsprefix_) else ''
            self.Substance.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Substance', pretty_print=pretty_print)
        if self.SubstanceDefinition is not None:
            namespaceprefix_ = self.SubstanceDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.SubstanceDefinition_nsprefix_) else ''
            self.SubstanceDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubstanceDefinition', pretty_print=pretty_print)
        if self.SubstanceNucleicAcid is not None:
            namespaceprefix_ = self.SubstanceNucleicAcid_nsprefix_ + ':' if (UseCapturedNS_ and self.SubstanceNucleicAcid_nsprefix_) else ''
            self.SubstanceNucleicAcid.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubstanceNucleicAcid', pretty_print=pretty_print)
        if self.SubstancePolymer is not None:
            namespaceprefix_ = self.SubstancePolymer_nsprefix_ + ':' if (UseCapturedNS_ and self.SubstancePolymer_nsprefix_) else ''
            self.SubstancePolymer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubstancePolymer', pretty_print=pretty_print)
        if self.SubstanceProtein is not None:
            namespaceprefix_ = self.SubstanceProtein_nsprefix_ + ':' if (UseCapturedNS_ and self.SubstanceProtein_nsprefix_) else ''
            self.SubstanceProtein.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubstanceProtein', pretty_print=pretty_print)
        if self.SubstanceReferenceInformation is not None:
            namespaceprefix_ = self.SubstanceReferenceInformation_nsprefix_ + ':' if (UseCapturedNS_ and self.SubstanceReferenceInformation_nsprefix_) else ''
            self.SubstanceReferenceInformation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubstanceReferenceInformation', pretty_print=pretty_print)
        if self.SubstanceSourceMaterial is not None:
            namespaceprefix_ = self.SubstanceSourceMaterial_nsprefix_ + ':' if (UseCapturedNS_ and self.SubstanceSourceMaterial_nsprefix_) else ''
            self.SubstanceSourceMaterial.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubstanceSourceMaterial', pretty_print=pretty_print)
        if self.SupplyDelivery is not None:
            namespaceprefix_ = self.SupplyDelivery_nsprefix_ + ':' if (UseCapturedNS_ and self.SupplyDelivery_nsprefix_) else ''
            self.SupplyDelivery.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SupplyDelivery', pretty_print=pretty_print)
        if self.SupplyRequest is not None:
            namespaceprefix_ = self.SupplyRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.SupplyRequest_nsprefix_) else ''
            self.SupplyRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SupplyRequest', pretty_print=pretty_print)
        if self.Task is not None:
            namespaceprefix_ = self.Task_nsprefix_ + ':' if (UseCapturedNS_ and self.Task_nsprefix_) else ''
            self.Task.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Task', pretty_print=pretty_print)
        if self.TerminologyCapabilities is not None:
            namespaceprefix_ = self.TerminologyCapabilities_nsprefix_ + ':' if (UseCapturedNS_ and self.TerminologyCapabilities_nsprefix_) else ''
            self.TerminologyCapabilities.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TerminologyCapabilities', pretty_print=pretty_print)
        if self.TestPlan is not None:
            namespaceprefix_ = self.TestPlan_nsprefix_ + ':' if (UseCapturedNS_ and self.TestPlan_nsprefix_) else ''
            self.TestPlan.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TestPlan', pretty_print=pretty_print)
        if self.TestReport is not None:
            namespaceprefix_ = self.TestReport_nsprefix_ + ':' if (UseCapturedNS_ and self.TestReport_nsprefix_) else ''
            self.TestReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TestReport', pretty_print=pretty_print)
        if self.TestScript is not None:
            namespaceprefix_ = self.TestScript_nsprefix_ + ':' if (UseCapturedNS_ and self.TestScript_nsprefix_) else ''
            self.TestScript.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TestScript', pretty_print=pretty_print)
        if self.Transport is not None:
            namespaceprefix_ = self.Transport_nsprefix_ + ':' if (UseCapturedNS_ and self.Transport_nsprefix_) else ''
            self.Transport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Transport', pretty_print=pretty_print)
        if self.ValueSet is not None:
            namespaceprefix_ = self.ValueSet_nsprefix_ + ':' if (UseCapturedNS_ and self.ValueSet_nsprefix_) else ''
            self.ValueSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ValueSet', pretty_print=pretty_print)
        if self.VerificationResult is not None:
            namespaceprefix_ = self.VerificationResult_nsprefix_ + ':' if (UseCapturedNS_ and self.VerificationResult_nsprefix_) else ''
            self.VerificationResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='VerificationResult', pretty_print=pretty_print)
        if self.VisionPrescription is not None:
            namespaceprefix_ = self.VisionPrescription_nsprefix_ + ':' if (UseCapturedNS_ and self.VisionPrescription_nsprefix_) else ''
            self.VisionPrescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='VisionPrescription', pretty_print=pretty_print)
        if self.Parameters is not None:
            namespaceprefix_ = self.Parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.Parameters_nsprefix_) else ''
            self.Parameters.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Parameters', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        if self.Account is not None:
            child_dict = self.Account.exportJson(json_dict, 'Account', False)
            if child_dict:
                json_dict['Account'] = child_dict
        if self.ActivityDefinition is not None:
            child_dict = self.ActivityDefinition.exportJson(json_dict, 'ActivityDefinition', False)
            if child_dict:
                json_dict['ActivityDefinition'] = child_dict
        if self.ActorDefinition is not None:
            child_dict = self.ActorDefinition.exportJson(json_dict, 'ActorDefinition', False)
            if child_dict:
                json_dict['ActorDefinition'] = child_dict
        if self.AdministrableProductDefinition is not None:
            child_dict = self.AdministrableProductDefinition.exportJson(json_dict, 'AdministrableProductDefinition', False)
            if child_dict:
                json_dict['AdministrableProductDefinition'] = child_dict
        if self.AdverseEvent is not None:
            child_dict = self.AdverseEvent.exportJson(json_dict, 'AdverseEvent', False)
            if child_dict:
                json_dict['AdverseEvent'] = child_dict
        if self.AllergyIntolerance is not None:
            child_dict = self.AllergyIntolerance.exportJson(json_dict, 'AllergyIntolerance', False)
            if child_dict:
                json_dict['AllergyIntolerance'] = child_dict
        if self.Appointment is not None:
            child_dict = self.Appointment.exportJson(json_dict, 'Appointment', False)
            if child_dict:
                json_dict['Appointment'] = child_dict
        if self.AppointmentResponse is not None:
            child_dict = self.AppointmentResponse.exportJson(json_dict, 'AppointmentResponse', False)
            if child_dict:
                json_dict['AppointmentResponse'] = child_dict
        if self.ArtifactAssessment is not None:
            child_dict = self.ArtifactAssessment.exportJson(json_dict, 'ArtifactAssessment', False)
            if child_dict:
                json_dict['ArtifactAssessment'] = child_dict
        if self.AuditEvent is not None:
            child_dict = self.AuditEvent.exportJson(json_dict, 'AuditEvent', False)
            if child_dict:
                json_dict['AuditEvent'] = child_dict
        if self.Basic is not None:
            child_dict = self.Basic.exportJson(json_dict, 'Basic', False)
            if child_dict:
                json_dict['Basic'] = child_dict
        if self.Binary is not None:
            child_dict = self.Binary.exportJson(json_dict, 'Binary', False)
            if child_dict:
                json_dict['Binary'] = child_dict
        if self.BiologicallyDerivedProduct is not None:
            child_dict = self.BiologicallyDerivedProduct.exportJson(json_dict, 'BiologicallyDerivedProduct', False)
            if child_dict:
                json_dict['BiologicallyDerivedProduct'] = child_dict
        if self.BiologicallyDerivedProductDispense is not None:
            child_dict = self.BiologicallyDerivedProductDispense.exportJson(json_dict, 'BiologicallyDerivedProductDispense', False)
            if child_dict:
                json_dict['BiologicallyDerivedProductDispense'] = child_dict
        if self.BodyStructure is not None:
            child_dict = self.BodyStructure.exportJson(json_dict, 'BodyStructure', False)
            if child_dict:
                json_dict['BodyStructure'] = child_dict
        if self.Bundle is not None:
            child_dict = self.Bundle.exportJson(json_dict, 'Bundle', False)
            if child_dict:
                json_dict['Bundle'] = child_dict
        if self.CapabilityStatement is not None:
            child_dict = self.CapabilityStatement.exportJson(json_dict, 'CapabilityStatement', False)
            if child_dict:
                json_dict['CapabilityStatement'] = child_dict
        if self.CarePlan is not None:
            child_dict = self.CarePlan.exportJson(json_dict, 'CarePlan', False)
            if child_dict:
                json_dict['CarePlan'] = child_dict
        if self.CareTeam is not None:
            child_dict = self.CareTeam.exportJson(json_dict, 'CareTeam', False)
            if child_dict:
                json_dict['CareTeam'] = child_dict
        if self.ChargeItem is not None:
            child_dict = self.ChargeItem.exportJson(json_dict, 'ChargeItem', False)
            if child_dict:
                json_dict['ChargeItem'] = child_dict
        if self.ChargeItemDefinition is not None:
            child_dict = self.ChargeItemDefinition.exportJson(json_dict, 'ChargeItemDefinition', False)
            if child_dict:
                json_dict['ChargeItemDefinition'] = child_dict
        if self.Citation is not None:
            child_dict = self.Citation.exportJson(json_dict, 'Citation', False)
            if child_dict:
                json_dict['Citation'] = child_dict
        if self.Claim is not None:
            child_dict = self.Claim.exportJson(json_dict, 'Claim', False)
            if child_dict:
                json_dict['Claim'] = child_dict
        if self.ClaimResponse is not None:
            child_dict = self.ClaimResponse.exportJson(json_dict, 'ClaimResponse', False)
            if child_dict:
                json_dict['ClaimResponse'] = child_dict
        if self.ClinicalImpression is not None:
            child_dict = self.ClinicalImpression.exportJson(json_dict, 'ClinicalImpression', False)
            if child_dict:
                json_dict['ClinicalImpression'] = child_dict
        if self.ClinicalUseDefinition is not None:
            child_dict = self.ClinicalUseDefinition.exportJson(json_dict, 'ClinicalUseDefinition', False)
            if child_dict:
                json_dict['ClinicalUseDefinition'] = child_dict
        if self.CodeSystem is not None:
            child_dict = self.CodeSystem.exportJson(json_dict, 'CodeSystem', False)
            if child_dict:
                json_dict['CodeSystem'] = child_dict
        if self.Communication is not None:
            child_dict = self.Communication.exportJson(json_dict, 'Communication', False)
            if child_dict:
                json_dict['Communication'] = child_dict
        if self.CommunicationRequest is not None:
            child_dict = self.CommunicationRequest.exportJson(json_dict, 'CommunicationRequest', False)
            if child_dict:
                json_dict['CommunicationRequest'] = child_dict
        if self.CompartmentDefinition is not None:
            child_dict = self.CompartmentDefinition.exportJson(json_dict, 'CompartmentDefinition', False)
            if child_dict:
                json_dict['CompartmentDefinition'] = child_dict
        if self.Composition is not None:
            child_dict = self.Composition.exportJson(json_dict, 'Composition', False)
            if child_dict:
                json_dict['Composition'] = child_dict
        if self.ConceptMap is not None:
            child_dict = self.ConceptMap.exportJson(json_dict, 'ConceptMap', False)
            if child_dict:
                json_dict['ConceptMap'] = child_dict
        if self.Condition is not None:
            child_dict = self.Condition.exportJson(json_dict, 'Condition', False)
            if child_dict:
                json_dict['Condition'] = child_dict
        if self.ConditionDefinition is not None:
            child_dict = self.ConditionDefinition.exportJson(json_dict, 'ConditionDefinition', False)
            if child_dict:
                json_dict['ConditionDefinition'] = child_dict
        if self.Consent is not None:
            child_dict = self.Consent.exportJson(json_dict, 'Consent', False)
            if child_dict:
                json_dict['Consent'] = child_dict
        if self.Contract is not None:
            child_dict = self.Contract.exportJson(json_dict, 'Contract', False)
            if child_dict:
                json_dict['Contract'] = child_dict
        if self.Coverage is not None:
            child_dict = self.Coverage.exportJson(json_dict, 'Coverage', False)
            if child_dict:
                json_dict['Coverage'] = child_dict
        if self.CoverageEligibilityRequest is not None:
            child_dict = self.CoverageEligibilityRequest.exportJson(json_dict, 'CoverageEligibilityRequest', False)
            if child_dict:
                json_dict['CoverageEligibilityRequest'] = child_dict
        if self.CoverageEligibilityResponse is not None:
            child_dict = self.CoverageEligibilityResponse.exportJson(json_dict, 'CoverageEligibilityResponse', False)
            if child_dict:
                json_dict['CoverageEligibilityResponse'] = child_dict
        if self.DetectedIssue is not None:
            child_dict = self.DetectedIssue.exportJson(json_dict, 'DetectedIssue', False)
            if child_dict:
                json_dict['DetectedIssue'] = child_dict
        if self.Device is not None:
            child_dict = self.Device.exportJson(json_dict, 'Device', False)
            if child_dict:
                json_dict['Device'] = child_dict
        if self.DeviceAssociation is not None:
            child_dict = self.DeviceAssociation.exportJson(json_dict, 'DeviceAssociation', False)
            if child_dict:
                json_dict['DeviceAssociation'] = child_dict
        if self.DeviceDefinition is not None:
            child_dict = self.DeviceDefinition.exportJson(json_dict, 'DeviceDefinition', False)
            if child_dict:
                json_dict['DeviceDefinition'] = child_dict
        if self.DeviceDispense is not None:
            child_dict = self.DeviceDispense.exportJson(json_dict, 'DeviceDispense', False)
            if child_dict:
                json_dict['DeviceDispense'] = child_dict
        if self.DeviceMetric is not None:
            child_dict = self.DeviceMetric.exportJson(json_dict, 'DeviceMetric', False)
            if child_dict:
                json_dict['DeviceMetric'] = child_dict
        if self.DeviceRequest is not None:
            child_dict = self.DeviceRequest.exportJson(json_dict, 'DeviceRequest', False)
            if child_dict:
                json_dict['DeviceRequest'] = child_dict
        if self.DeviceUsage is not None:
            child_dict = self.DeviceUsage.exportJson(json_dict, 'DeviceUsage', False)
            if child_dict:
                json_dict['DeviceUsage'] = child_dict
        if self.DiagnosticReport is not None:
            child_dict = self.DiagnosticReport.exportJson(json_dict, 'DiagnosticReport', False)
            if child_dict:
                json_dict['DiagnosticReport'] = child_dict
        if self.DocumentReference is not None:
            child_dict = self.DocumentReference.exportJson(json_dict, 'DocumentReference', False)
            if child_dict:
                json_dict['DocumentReference'] = child_dict
        if self.Encounter is not None:
            child_dict = self.Encounter.exportJson(json_dict, 'Encounter', False)
            if child_dict:
                json_dict['Encounter'] = child_dict
        if self.EncounterHistory is not None:
            child_dict = self.EncounterHistory.exportJson(json_dict, 'EncounterHistory', False)
            if child_dict:
                json_dict['EncounterHistory'] = child_dict
        if self.Endpoint is not None:
            child_dict = self.Endpoint.exportJson(json_dict, 'Endpoint', False)
            if child_dict:
                json_dict['Endpoint'] = child_dict
        if self.EnrollmentRequest is not None:
            child_dict = self.EnrollmentRequest.exportJson(json_dict, 'EnrollmentRequest', False)
            if child_dict:
                json_dict['EnrollmentRequest'] = child_dict
        if self.EnrollmentResponse is not None:
            child_dict = self.EnrollmentResponse.exportJson(json_dict, 'EnrollmentResponse', False)
            if child_dict:
                json_dict['EnrollmentResponse'] = child_dict
        if self.EpisodeOfCare is not None:
            child_dict = self.EpisodeOfCare.exportJson(json_dict, 'EpisodeOfCare', False)
            if child_dict:
                json_dict['EpisodeOfCare'] = child_dict
        if self.EventDefinition is not None:
            child_dict = self.EventDefinition.exportJson(json_dict, 'EventDefinition', False)
            if child_dict:
                json_dict['EventDefinition'] = child_dict
        if self.Evidence is not None:
            child_dict = self.Evidence.exportJson(json_dict, 'Evidence', False)
            if child_dict:
                json_dict['Evidence'] = child_dict
        if self.EvidenceReport is not None:
            child_dict = self.EvidenceReport.exportJson(json_dict, 'EvidenceReport', False)
            if child_dict:
                json_dict['EvidenceReport'] = child_dict
        if self.EvidenceVariable is not None:
            child_dict = self.EvidenceVariable.exportJson(json_dict, 'EvidenceVariable', False)
            if child_dict:
                json_dict['EvidenceVariable'] = child_dict
        if self.ExampleScenario is not None:
            child_dict = self.ExampleScenario.exportJson(json_dict, 'ExampleScenario', False)
            if child_dict:
                json_dict['ExampleScenario'] = child_dict
        if self.ExplanationOfBenefit is not None:
            child_dict = self.ExplanationOfBenefit.exportJson(json_dict, 'ExplanationOfBenefit', False)
            if child_dict:
                json_dict['ExplanationOfBenefit'] = child_dict
        if self.FamilyMemberHistory is not None:
            child_dict = self.FamilyMemberHistory.exportJson(json_dict, 'FamilyMemberHistory', False)
            if child_dict:
                json_dict['FamilyMemberHistory'] = child_dict
        if self.Flag is not None:
            child_dict = self.Flag.exportJson(json_dict, 'Flag', False)
            if child_dict:
                json_dict['Flag'] = child_dict
        if self.FormularyItem is not None:
            child_dict = self.FormularyItem.exportJson(json_dict, 'FormularyItem', False)
            if child_dict:
                json_dict['FormularyItem'] = child_dict
        if self.GenomicStudy is not None:
            child_dict = self.GenomicStudy.exportJson(json_dict, 'GenomicStudy', False)
            if child_dict:
                json_dict['GenomicStudy'] = child_dict
        if self.Goal is not None:
            child_dict = self.Goal.exportJson(json_dict, 'Goal', False)
            if child_dict:
                json_dict['Goal'] = child_dict
        if self.GraphDefinition is not None:
            child_dict = self.GraphDefinition.exportJson(json_dict, 'GraphDefinition', False)
            if child_dict:
                json_dict['GraphDefinition'] = child_dict
        if self.Group is not None:
            child_dict = self.Group.exportJson(json_dict, 'Group', False)
            if child_dict:
                json_dict['Group'] = child_dict
        if self.GuidanceResponse is not None:
            child_dict = self.GuidanceResponse.exportJson(json_dict, 'GuidanceResponse', False)
            if child_dict:
                json_dict['GuidanceResponse'] = child_dict
        if self.HealthcareService is not None:
            child_dict = self.HealthcareService.exportJson(json_dict, 'HealthcareService', False)
            if child_dict:
                json_dict['HealthcareService'] = child_dict
        if self.ImagingSelection is not None:
            child_dict = self.ImagingSelection.exportJson(json_dict, 'ImagingSelection', False)
            if child_dict:
                json_dict['ImagingSelection'] = child_dict
        if self.ImagingStudy is not None:
            child_dict = self.ImagingStudy.exportJson(json_dict, 'ImagingStudy', False)
            if child_dict:
                json_dict['ImagingStudy'] = child_dict
        if self.Immunization is not None:
            child_dict = self.Immunization.exportJson(json_dict, 'Immunization', False)
            if child_dict:
                json_dict['Immunization'] = child_dict
        if self.ImmunizationEvaluation is not None:
            child_dict = self.ImmunizationEvaluation.exportJson(json_dict, 'ImmunizationEvaluation', False)
            if child_dict:
                json_dict['ImmunizationEvaluation'] = child_dict
        if self.ImmunizationRecommendation is not None:
            child_dict = self.ImmunizationRecommendation.exportJson(json_dict, 'ImmunizationRecommendation', False)
            if child_dict:
                json_dict['ImmunizationRecommendation'] = child_dict
        if self.ImplementationGuide is not None:
            child_dict = self.ImplementationGuide.exportJson(json_dict, 'ImplementationGuide', False)
            if child_dict:
                json_dict['ImplementationGuide'] = child_dict
        if self.Ingredient is not None:
            child_dict = self.Ingredient.exportJson(json_dict, 'Ingredient', False)
            if child_dict:
                json_dict['Ingredient'] = child_dict
        if self.InsurancePlan is not None:
            child_dict = self.InsurancePlan.exportJson(json_dict, 'InsurancePlan', False)
            if child_dict:
                json_dict['InsurancePlan'] = child_dict
        if self.InventoryItem is not None:
            child_dict = self.InventoryItem.exportJson(json_dict, 'InventoryItem', False)
            if child_dict:
                json_dict['InventoryItem'] = child_dict
        if self.InventoryReport is not None:
            child_dict = self.InventoryReport.exportJson(json_dict, 'InventoryReport', False)
            if child_dict:
                json_dict['InventoryReport'] = child_dict
        if self.Invoice is not None:
            child_dict = self.Invoice.exportJson(json_dict, 'Invoice', False)
            if child_dict:
                json_dict['Invoice'] = child_dict
        if self.Library is not None:
            child_dict = self.Library.exportJson(json_dict, 'Library', False)
            if child_dict:
                json_dict['Library'] = child_dict
        if self.Linkage is not None:
            child_dict = self.Linkage.exportJson(json_dict, 'Linkage', False)
            if child_dict:
                json_dict['Linkage'] = child_dict
        if self.List is not None:
            child_dict = self.List.exportJson(json_dict, 'List', False)
            if child_dict:
                json_dict['List'] = child_dict
        if self.Location is not None:
            child_dict = self.Location.exportJson(json_dict, 'Location', False)
            if child_dict:
                json_dict['Location'] = child_dict
        if self.ManufacturedItemDefinition is not None:
            child_dict = self.ManufacturedItemDefinition.exportJson(json_dict, 'ManufacturedItemDefinition', False)
            if child_dict:
                json_dict['ManufacturedItemDefinition'] = child_dict
        if self.Measure is not None:
            child_dict = self.Measure.exportJson(json_dict, 'Measure', False)
            if child_dict:
                json_dict['Measure'] = child_dict
        if self.MeasureReport is not None:
            child_dict = self.MeasureReport.exportJson(json_dict, 'MeasureReport', False)
            if child_dict:
                json_dict['MeasureReport'] = child_dict
        if self.Medication is not None:
            child_dict = self.Medication.exportJson(json_dict, 'Medication', False)
            if child_dict:
                json_dict['Medication'] = child_dict
        if self.MedicationAdministration is not None:
            child_dict = self.MedicationAdministration.exportJson(json_dict, 'MedicationAdministration', False)
            if child_dict:
                json_dict['MedicationAdministration'] = child_dict
        if self.MedicationDispense is not None:
            child_dict = self.MedicationDispense.exportJson(json_dict, 'MedicationDispense', False)
            if child_dict:
                json_dict['MedicationDispense'] = child_dict
        if self.MedicationKnowledge is not None:
            child_dict = self.MedicationKnowledge.exportJson(json_dict, 'MedicationKnowledge', False)
            if child_dict:
                json_dict['MedicationKnowledge'] = child_dict
        if self.MedicationRequest is not None:
            child_dict = self.MedicationRequest.exportJson(json_dict, 'MedicationRequest', False)
            if child_dict:
                json_dict['MedicationRequest'] = child_dict
        if self.MedicationStatement is not None:
            child_dict = self.MedicationStatement.exportJson(json_dict, 'MedicationStatement', False)
            if child_dict:
                json_dict['MedicationStatement'] = child_dict
        if self.MedicinalProductDefinition is not None:
            child_dict = self.MedicinalProductDefinition.exportJson(json_dict, 'MedicinalProductDefinition', False)
            if child_dict:
                json_dict['MedicinalProductDefinition'] = child_dict
        if self.MessageDefinition is not None:
            child_dict = self.MessageDefinition.exportJson(json_dict, 'MessageDefinition', False)
            if child_dict:
                json_dict['MessageDefinition'] = child_dict
        if self.MessageHeader is not None:
            child_dict = self.MessageHeader.exportJson(json_dict, 'MessageHeader', False)
            if child_dict:
                json_dict['MessageHeader'] = child_dict
        if self.MolecularSequence is not None:
            child_dict = self.MolecularSequence.exportJson(json_dict, 'MolecularSequence', False)
            if child_dict:
                json_dict['MolecularSequence'] = child_dict
        if self.NamingSystem is not None:
            child_dict = self.NamingSystem.exportJson(json_dict, 'NamingSystem', False)
            if child_dict:
                json_dict['NamingSystem'] = child_dict
        if self.NutritionIntake is not None:
            child_dict = self.NutritionIntake.exportJson(json_dict, 'NutritionIntake', False)
            if child_dict:
                json_dict['NutritionIntake'] = child_dict
        if self.NutritionOrder is not None:
            child_dict = self.NutritionOrder.exportJson(json_dict, 'NutritionOrder', False)
            if child_dict:
                json_dict['NutritionOrder'] = child_dict
        if self.NutritionProduct is not None:
            child_dict = self.NutritionProduct.exportJson(json_dict, 'NutritionProduct', False)
            if child_dict:
                json_dict['NutritionProduct'] = child_dict
        if self.Observation is not None:
            child_dict = self.Observation.exportJson(json_dict, 'Observation', False)
            if child_dict:
                json_dict['Observation'] = child_dict
        if self.ObservationDefinition is not None:
            child_dict = self.ObservationDefinition.exportJson(json_dict, 'ObservationDefinition', False)
            if child_dict:
                json_dict['ObservationDefinition'] = child_dict
        if self.OperationDefinition is not None:
            child_dict = self.OperationDefinition.exportJson(json_dict, 'OperationDefinition', False)
            if child_dict:
                json_dict['OperationDefinition'] = child_dict
        if self.OperationOutcome is not None:
            child_dict = self.OperationOutcome.exportJson(json_dict, 'OperationOutcome', False)
            if child_dict:
                json_dict['OperationOutcome'] = child_dict
        if self.Organization is not None:
            child_dict = self.Organization.exportJson(json_dict, 'Organization', False)
            if child_dict:
                json_dict['Organization'] = child_dict
        if self.OrganizationAffiliation is not None:
            child_dict = self.OrganizationAffiliation.exportJson(json_dict, 'OrganizationAffiliation', False)
            if child_dict:
                json_dict['OrganizationAffiliation'] = child_dict
        if self.PackagedProductDefinition is not None:
            child_dict = self.PackagedProductDefinition.exportJson(json_dict, 'PackagedProductDefinition', False)
            if child_dict:
                json_dict['PackagedProductDefinition'] = child_dict
        if self.Patient is not None:
            child_dict = self.Patient.exportJson(json_dict, 'Patient', False)
            if child_dict:
                json_dict['Patient'] = child_dict
        if self.PaymentNotice is not None:
            child_dict = self.PaymentNotice.exportJson(json_dict, 'PaymentNotice', False)
            if child_dict:
                json_dict['PaymentNotice'] = child_dict
        if self.PaymentReconciliation is not None:
            child_dict = self.PaymentReconciliation.exportJson(json_dict, 'PaymentReconciliation', False)
            if child_dict:
                json_dict['PaymentReconciliation'] = child_dict
        if self.Permission is not None:
            child_dict = self.Permission.exportJson(json_dict, 'Permission', False)
            if child_dict:
                json_dict['Permission'] = child_dict
        if self.Person is not None:
            child_dict = self.Person.exportJson(json_dict, 'Person', False)
            if child_dict:
                json_dict['Person'] = child_dict
        if self.PlanDefinition is not None:
            child_dict = self.PlanDefinition.exportJson(json_dict, 'PlanDefinition', False)
            if child_dict:
                json_dict['PlanDefinition'] = child_dict
        if self.Practitioner is not None:
            child_dict = self.Practitioner.exportJson(json_dict, 'Practitioner', False)
            if child_dict:
                json_dict['Practitioner'] = child_dict
        if self.PractitionerRole is not None:
            child_dict = self.PractitionerRole.exportJson(json_dict, 'PractitionerRole', False)
            if child_dict:
                json_dict['PractitionerRole'] = child_dict
        if self.Procedure is not None:
            child_dict = self.Procedure.exportJson(json_dict, 'Procedure', False)
            if child_dict:
                json_dict['Procedure'] = child_dict
        if self.Provenance is not None:
            child_dict = self.Provenance.exportJson(json_dict, 'Provenance', False)
            if child_dict:
                json_dict['Provenance'] = child_dict
        if self.Questionnaire is not None:
            child_dict = self.Questionnaire.exportJson(json_dict, 'Questionnaire', False)
            if child_dict:
                json_dict['Questionnaire'] = child_dict
        if self.QuestionnaireResponse is not None:
            child_dict = self.QuestionnaireResponse.exportJson(json_dict, 'QuestionnaireResponse', False)
            if child_dict:
                json_dict['QuestionnaireResponse'] = child_dict
        if self.RegulatedAuthorization is not None:
            child_dict = self.RegulatedAuthorization.exportJson(json_dict, 'RegulatedAuthorization', False)
            if child_dict:
                json_dict['RegulatedAuthorization'] = child_dict
        if self.RelatedPerson is not None:
            child_dict = self.RelatedPerson.exportJson(json_dict, 'RelatedPerson', False)
            if child_dict:
                json_dict['RelatedPerson'] = child_dict
        if self.RequestOrchestration is not None:
            child_dict = self.RequestOrchestration.exportJson(json_dict, 'RequestOrchestration', False)
            if child_dict:
                json_dict['RequestOrchestration'] = child_dict
        if self.Requirements is not None:
            child_dict = self.Requirements.exportJson(json_dict, 'Requirements', False)
            if child_dict:
                json_dict['Requirements'] = child_dict
        if self.ResearchStudy is not None:
            child_dict = self.ResearchStudy.exportJson(json_dict, 'ResearchStudy', False)
            if child_dict:
                json_dict['ResearchStudy'] = child_dict
        if self.ResearchSubject is not None:
            child_dict = self.ResearchSubject.exportJson(json_dict, 'ResearchSubject', False)
            if child_dict:
                json_dict['ResearchSubject'] = child_dict
        if self.RiskAssessment is not None:
            child_dict = self.RiskAssessment.exportJson(json_dict, 'RiskAssessment', False)
            if child_dict:
                json_dict['RiskAssessment'] = child_dict
        if self.Schedule is not None:
            child_dict = self.Schedule.exportJson(json_dict, 'Schedule', False)
            if child_dict:
                json_dict['Schedule'] = child_dict
        if self.SearchParameter is not None:
            child_dict = self.SearchParameter.exportJson(json_dict, 'SearchParameter', False)
            if child_dict:
                json_dict['SearchParameter'] = child_dict
        if self.ServiceRequest is not None:
            child_dict = self.ServiceRequest.exportJson(json_dict, 'ServiceRequest', False)
            if child_dict:
                json_dict['ServiceRequest'] = child_dict
        if self.Slot is not None:
            child_dict = self.Slot.exportJson(json_dict, 'Slot', False)
            if child_dict:
                json_dict['Slot'] = child_dict
        if self.Specimen is not None:
            child_dict = self.Specimen.exportJson(json_dict, 'Specimen', False)
            if child_dict:
                json_dict['Specimen'] = child_dict
        if self.SpecimenDefinition is not None:
            child_dict = self.SpecimenDefinition.exportJson(json_dict, 'SpecimenDefinition', False)
            if child_dict:
                json_dict['SpecimenDefinition'] = child_dict
        if self.StructureDefinition is not None:
            child_dict = self.StructureDefinition.exportJson(json_dict, 'StructureDefinition', False)
            if child_dict:
                json_dict['StructureDefinition'] = child_dict
        if self.StructureMap is not None:
            child_dict = self.StructureMap.exportJson(json_dict, 'StructureMap', False)
            if child_dict:
                json_dict['StructureMap'] = child_dict
        if self.Subscription is not None:
            child_dict = self.Subscription.exportJson(json_dict, 'Subscription', False)
            if child_dict:
                json_dict['Subscription'] = child_dict
        if self.SubscriptionStatus is not None:
            child_dict = self.SubscriptionStatus.exportJson(json_dict, 'SubscriptionStatus', False)
            if child_dict:
                json_dict['SubscriptionStatus'] = child_dict
        if self.SubscriptionTopic is not None:
            child_dict = self.SubscriptionTopic.exportJson(json_dict, 'SubscriptionTopic', False)
            if child_dict:
                json_dict['SubscriptionTopic'] = child_dict
        if self.Substance is not None:
            child_dict = self.Substance.exportJson(json_dict, 'Substance', False)
            if child_dict:
                json_dict['Substance'] = child_dict
        if self.SubstanceDefinition is not None:
            child_dict = self.SubstanceDefinition.exportJson(json_dict, 'SubstanceDefinition', False)
            if child_dict:
                json_dict['SubstanceDefinition'] = child_dict
        if self.SubstanceNucleicAcid is not None:
            child_dict = self.SubstanceNucleicAcid.exportJson(json_dict, 'SubstanceNucleicAcid', False)
            if child_dict:
                json_dict['SubstanceNucleicAcid'] = child_dict
        if self.SubstancePolymer is not None:
            child_dict = self.SubstancePolymer.exportJson(json_dict, 'SubstancePolymer', False)
            if child_dict:
                json_dict['SubstancePolymer'] = child_dict
        if self.SubstanceProtein is not None:
            child_dict = self.SubstanceProtein.exportJson(json_dict, 'SubstanceProtein', False)
            if child_dict:
                json_dict['SubstanceProtein'] = child_dict
        if self.SubstanceReferenceInformation is not None:
            child_dict = self.SubstanceReferenceInformation.exportJson(json_dict, 'SubstanceReferenceInformation', False)
            if child_dict:
                json_dict['SubstanceReferenceInformation'] = child_dict
        if self.SubstanceSourceMaterial is not None:
            child_dict = self.SubstanceSourceMaterial.exportJson(json_dict, 'SubstanceSourceMaterial', False)
            if child_dict:
                json_dict['SubstanceSourceMaterial'] = child_dict
        if self.SupplyDelivery is not None:
            child_dict = self.SupplyDelivery.exportJson(json_dict, 'SupplyDelivery', False)
            if child_dict:
                json_dict['SupplyDelivery'] = child_dict
        if self.SupplyRequest is not None:
            child_dict = self.SupplyRequest.exportJson(json_dict, 'SupplyRequest', False)
            if child_dict:
                json_dict['SupplyRequest'] = child_dict
        if self.Task is not None:
            child_dict = self.Task.exportJson(json_dict, 'Task', False)
            if child_dict:
                json_dict['Task'] = child_dict
        if self.TerminologyCapabilities is not None:
            child_dict = self.TerminologyCapabilities.exportJson(json_dict, 'TerminologyCapabilities', False)
            if child_dict:
                json_dict['TerminologyCapabilities'] = child_dict
        if self.TestPlan is not None:
            child_dict = self.TestPlan.exportJson(json_dict, 'TestPlan', False)
            if child_dict:
                json_dict['TestPlan'] = child_dict
        if self.TestReport is not None:
            child_dict = self.TestReport.exportJson(json_dict, 'TestReport', False)
            if child_dict:
                json_dict['TestReport'] = child_dict
        if self.TestScript is not None:
            child_dict = self.TestScript.exportJson(json_dict, 'TestScript', False)
            if child_dict:
                json_dict['TestScript'] = child_dict
        if self.Transport is not None:
            child_dict = self.Transport.exportJson(json_dict, 'Transport', False)
            if child_dict:
                json_dict['Transport'] = child_dict
        if self.ValueSet is not None:
            child_dict = self.ValueSet.exportJson(json_dict, 'ValueSet', False)
            if child_dict:
                json_dict['ValueSet'] = child_dict
        if self.VerificationResult is not None:
            child_dict = self.VerificationResult.exportJson(json_dict, 'VerificationResult', False)
            if child_dict:
                json_dict['VerificationResult'] = child_dict
        if self.VisionPrescription is not None:
            child_dict = self.VisionPrescription.exportJson(json_dict, 'VisionPrescription', False)
            if child_dict:
                json_dict['VisionPrescription'] = child_dict
        if self.Parameters is not None:
            child_dict = self.Parameters.exportJson(json_dict, 'Parameters', False)
            if child_dict:
                json_dict['Parameters'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Account':
            obj_ = Account.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Account = obj_
            obj_.original_tagname_ = 'Account'
        elif nodeName_ == 'ActivityDefinition':
            obj_ = ActivityDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ActivityDefinition = obj_
            obj_.original_tagname_ = 'ActivityDefinition'
        elif nodeName_ == 'ActorDefinition':
            obj_ = ActorDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ActorDefinition = obj_
            obj_.original_tagname_ = 'ActorDefinition'
        elif nodeName_ == 'AdministrableProductDefinition':
            obj_ = AdministrableProductDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AdministrableProductDefinition = obj_
            obj_.original_tagname_ = 'AdministrableProductDefinition'
        elif nodeName_ == 'AdverseEvent':
            obj_ = AdverseEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AdverseEvent = obj_
            obj_.original_tagname_ = 'AdverseEvent'
        elif nodeName_ == 'AllergyIntolerance':
            obj_ = AllergyIntolerance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AllergyIntolerance = obj_
            obj_.original_tagname_ = 'AllergyIntolerance'
        elif nodeName_ == 'Appointment':
            obj_ = Appointment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Appointment = obj_
            obj_.original_tagname_ = 'Appointment'
        elif nodeName_ == 'AppointmentResponse':
            obj_ = AppointmentResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AppointmentResponse = obj_
            obj_.original_tagname_ = 'AppointmentResponse'
        elif nodeName_ == 'ArtifactAssessment':
            obj_ = ArtifactAssessment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ArtifactAssessment = obj_
            obj_.original_tagname_ = 'ArtifactAssessment'
        elif nodeName_ == 'AuditEvent':
            obj_ = AuditEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuditEvent = obj_
            obj_.original_tagname_ = 'AuditEvent'
        elif nodeName_ == 'Basic':
            obj_ = Basic.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Basic = obj_
            obj_.original_tagname_ = 'Basic'
        elif nodeName_ == 'Binary':
            obj_ = Binary.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Binary = obj_
            obj_.original_tagname_ = 'Binary'
        elif nodeName_ == 'BiologicallyDerivedProduct':
            obj_ = BiologicallyDerivedProduct.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BiologicallyDerivedProduct = obj_
            obj_.original_tagname_ = 'BiologicallyDerivedProduct'
        elif nodeName_ == 'BiologicallyDerivedProductDispense':
            obj_ = BiologicallyDerivedProductDispense.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BiologicallyDerivedProductDispense = obj_
            obj_.original_tagname_ = 'BiologicallyDerivedProductDispense'
        elif nodeName_ == 'BodyStructure':
            obj_ = BodyStructure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BodyStructure = obj_
            obj_.original_tagname_ = 'BodyStructure'
        elif nodeName_ == 'Bundle':
            obj_ = Bundle.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Bundle = obj_
            obj_.original_tagname_ = 'Bundle'
        elif nodeName_ == 'CapabilityStatement':
            obj_ = CapabilityStatement.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CapabilityStatement = obj_
            obj_.original_tagname_ = 'CapabilityStatement'
        elif nodeName_ == 'CarePlan':
            obj_ = CarePlan.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CarePlan = obj_
            obj_.original_tagname_ = 'CarePlan'
        elif nodeName_ == 'CareTeam':
            obj_ = CareTeam.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CareTeam = obj_
            obj_.original_tagname_ = 'CareTeam'
        elif nodeName_ == 'ChargeItem':
            obj_ = ChargeItem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ChargeItem = obj_
            obj_.original_tagname_ = 'ChargeItem'
        elif nodeName_ == 'ChargeItemDefinition':
            obj_ = ChargeItemDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ChargeItemDefinition = obj_
            obj_.original_tagname_ = 'ChargeItemDefinition'
        elif nodeName_ == 'Citation':
            obj_ = Citation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Citation = obj_
            obj_.original_tagname_ = 'Citation'
        elif nodeName_ == 'Claim':
            obj_ = Claim.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Claim = obj_
            obj_.original_tagname_ = 'Claim'
        elif nodeName_ == 'ClaimResponse':
            obj_ = ClaimResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ClaimResponse = obj_
            obj_.original_tagname_ = 'ClaimResponse'
        elif nodeName_ == 'ClinicalImpression':
            obj_ = ClinicalImpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ClinicalImpression = obj_
            obj_.original_tagname_ = 'ClinicalImpression'
        elif nodeName_ == 'ClinicalUseDefinition':
            obj_ = ClinicalUseDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ClinicalUseDefinition = obj_
            obj_.original_tagname_ = 'ClinicalUseDefinition'
        elif nodeName_ == 'CodeSystem':
            obj_ = CodeSystem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CodeSystem = obj_
            obj_.original_tagname_ = 'CodeSystem'
        elif nodeName_ == 'Communication':
            obj_ = Communication.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Communication = obj_
            obj_.original_tagname_ = 'Communication'
        elif nodeName_ == 'CommunicationRequest':
            obj_ = CommunicationRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CommunicationRequest = obj_
            obj_.original_tagname_ = 'CommunicationRequest'
        elif nodeName_ == 'CompartmentDefinition':
            obj_ = CompartmentDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CompartmentDefinition = obj_
            obj_.original_tagname_ = 'CompartmentDefinition'
        elif nodeName_ == 'Composition':
            obj_ = Composition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Composition = obj_
            obj_.original_tagname_ = 'Composition'
        elif nodeName_ == 'ConceptMap':
            obj_ = ConceptMap.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ConceptMap = obj_
            obj_.original_tagname_ = 'ConceptMap'
        elif nodeName_ == 'Condition':
            obj_ = Condition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Condition = obj_
            obj_.original_tagname_ = 'Condition'
        elif nodeName_ == 'ConditionDefinition':
            obj_ = ConditionDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ConditionDefinition = obj_
            obj_.original_tagname_ = 'ConditionDefinition'
        elif nodeName_ == 'Consent':
            obj_ = Consent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Consent = obj_
            obj_.original_tagname_ = 'Consent'
        elif nodeName_ == 'Contract':
            obj_ = Contract.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Contract = obj_
            obj_.original_tagname_ = 'Contract'
        elif nodeName_ == 'Coverage':
            obj_ = Coverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Coverage = obj_
            obj_.original_tagname_ = 'Coverage'
        elif nodeName_ == 'CoverageEligibilityRequest':
            obj_ = CoverageEligibilityRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CoverageEligibilityRequest = obj_
            obj_.original_tagname_ = 'CoverageEligibilityRequest'
        elif nodeName_ == 'CoverageEligibilityResponse':
            obj_ = CoverageEligibilityResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CoverageEligibilityResponse = obj_
            obj_.original_tagname_ = 'CoverageEligibilityResponse'
        elif nodeName_ == 'DetectedIssue':
            obj_ = DetectedIssue.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DetectedIssue = obj_
            obj_.original_tagname_ = 'DetectedIssue'
        elif nodeName_ == 'Device':
            obj_ = Device.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Device = obj_
            obj_.original_tagname_ = 'Device'
        elif nodeName_ == 'DeviceAssociation':
            obj_ = DeviceAssociation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceAssociation = obj_
            obj_.original_tagname_ = 'DeviceAssociation'
        elif nodeName_ == 'DeviceDefinition':
            obj_ = DeviceDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceDefinition = obj_
            obj_.original_tagname_ = 'DeviceDefinition'
        elif nodeName_ == 'DeviceDispense':
            obj_ = DeviceDispense.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceDispense = obj_
            obj_.original_tagname_ = 'DeviceDispense'
        elif nodeName_ == 'DeviceMetric':
            obj_ = DeviceMetric.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceMetric = obj_
            obj_.original_tagname_ = 'DeviceMetric'
        elif nodeName_ == 'DeviceRequest':
            obj_ = DeviceRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceRequest = obj_
            obj_.original_tagname_ = 'DeviceRequest'
        elif nodeName_ == 'DeviceUsage':
            obj_ = DeviceUsage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceUsage = obj_
            obj_.original_tagname_ = 'DeviceUsage'
        elif nodeName_ == 'DiagnosticReport':
            obj_ = DiagnosticReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DiagnosticReport = obj_
            obj_.original_tagname_ = 'DiagnosticReport'
        elif nodeName_ == 'DocumentReference':
            obj_ = DocumentReference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DocumentReference = obj_
            obj_.original_tagname_ = 'DocumentReference'
        elif nodeName_ == 'Encounter':
            obj_ = Encounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Encounter = obj_
            obj_.original_tagname_ = 'Encounter'
        elif nodeName_ == 'EncounterHistory':
            obj_ = EncounterHistory.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EncounterHistory = obj_
            obj_.original_tagname_ = 'EncounterHistory'
        elif nodeName_ == 'Endpoint':
            obj_ = Endpoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Endpoint = obj_
            obj_.original_tagname_ = 'Endpoint'
        elif nodeName_ == 'EnrollmentRequest':
            obj_ = EnrollmentRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EnrollmentRequest = obj_
            obj_.original_tagname_ = 'EnrollmentRequest'
        elif nodeName_ == 'EnrollmentResponse':
            obj_ = EnrollmentResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EnrollmentResponse = obj_
            obj_.original_tagname_ = 'EnrollmentResponse'
        elif nodeName_ == 'EpisodeOfCare':
            obj_ = EpisodeOfCare.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EpisodeOfCare = obj_
            obj_.original_tagname_ = 'EpisodeOfCare'
        elif nodeName_ == 'EventDefinition':
            obj_ = EventDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EventDefinition = obj_
            obj_.original_tagname_ = 'EventDefinition'
        elif nodeName_ == 'Evidence':
            obj_ = Evidence.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Evidence = obj_
            obj_.original_tagname_ = 'Evidence'
        elif nodeName_ == 'EvidenceReport':
            obj_ = EvidenceReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EvidenceReport = obj_
            obj_.original_tagname_ = 'EvidenceReport'
        elif nodeName_ == 'EvidenceVariable':
            obj_ = EvidenceVariable.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EvidenceVariable = obj_
            obj_.original_tagname_ = 'EvidenceVariable'
        elif nodeName_ == 'ExampleScenario':
            obj_ = ExampleScenario.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ExampleScenario = obj_
            obj_.original_tagname_ = 'ExampleScenario'
        elif nodeName_ == 'ExplanationOfBenefit':
            obj_ = ExplanationOfBenefit.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ExplanationOfBenefit = obj_
            obj_.original_tagname_ = 'ExplanationOfBenefit'
        elif nodeName_ == 'FamilyMemberHistory':
            obj_ = FamilyMemberHistory.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FamilyMemberHistory = obj_
            obj_.original_tagname_ = 'FamilyMemberHistory'
        elif nodeName_ == 'Flag':
            obj_ = Flag.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Flag = obj_
            obj_.original_tagname_ = 'Flag'
        elif nodeName_ == 'FormularyItem':
            obj_ = FormularyItem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FormularyItem = obj_
            obj_.original_tagname_ = 'FormularyItem'
        elif nodeName_ == 'GenomicStudy':
            obj_ = GenomicStudy.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GenomicStudy = obj_
            obj_.original_tagname_ = 'GenomicStudy'
        elif nodeName_ == 'Goal':
            obj_ = Goal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Goal = obj_
            obj_.original_tagname_ = 'Goal'
        elif nodeName_ == 'GraphDefinition':
            obj_ = GraphDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GraphDefinition = obj_
            obj_.original_tagname_ = 'GraphDefinition'
        elif nodeName_ == 'Group':
            obj_ = Group.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Group = obj_
            obj_.original_tagname_ = 'Group'
        elif nodeName_ == 'GuidanceResponse':
            obj_ = GuidanceResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GuidanceResponse = obj_
            obj_.original_tagname_ = 'GuidanceResponse'
        elif nodeName_ == 'HealthcareService':
            obj_ = HealthcareService.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.HealthcareService = obj_
            obj_.original_tagname_ = 'HealthcareService'
        elif nodeName_ == 'ImagingSelection':
            obj_ = ImagingSelection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImagingSelection = obj_
            obj_.original_tagname_ = 'ImagingSelection'
        elif nodeName_ == 'ImagingStudy':
            obj_ = ImagingStudy.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImagingStudy = obj_
            obj_.original_tagname_ = 'ImagingStudy'
        elif nodeName_ == 'Immunization':
            obj_ = Immunization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Immunization = obj_
            obj_.original_tagname_ = 'Immunization'
        elif nodeName_ == 'ImmunizationEvaluation':
            obj_ = ImmunizationEvaluation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImmunizationEvaluation = obj_
            obj_.original_tagname_ = 'ImmunizationEvaluation'
        elif nodeName_ == 'ImmunizationRecommendation':
            obj_ = ImmunizationRecommendation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImmunizationRecommendation = obj_
            obj_.original_tagname_ = 'ImmunizationRecommendation'
        elif nodeName_ == 'ImplementationGuide':
            obj_ = ImplementationGuide.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImplementationGuide = obj_
            obj_.original_tagname_ = 'ImplementationGuide'
        elif nodeName_ == 'Ingredient':
            obj_ = Ingredient.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Ingredient = obj_
            obj_.original_tagname_ = 'Ingredient'
        elif nodeName_ == 'InsurancePlan':
            obj_ = InsurancePlan.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InsurancePlan = obj_
            obj_.original_tagname_ = 'InsurancePlan'
        elif nodeName_ == 'InventoryItem':
            obj_ = InventoryItem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InventoryItem = obj_
            obj_.original_tagname_ = 'InventoryItem'
        elif nodeName_ == 'InventoryReport':
            obj_ = InventoryReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InventoryReport = obj_
            obj_.original_tagname_ = 'InventoryReport'
        elif nodeName_ == 'Invoice':
            obj_ = Invoice.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Invoice = obj_
            obj_.original_tagname_ = 'Invoice'
        elif nodeName_ == 'Library':
            obj_ = Library.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Library = obj_
            obj_.original_tagname_ = 'Library'
        elif nodeName_ == 'Linkage':
            obj_ = Linkage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Linkage = obj_
            obj_.original_tagname_ = 'Linkage'
        elif nodeName_ == 'List':
            obj_ = List.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.List = obj_
            obj_.original_tagname_ = 'List'
        elif nodeName_ == 'Location':
            obj_ = Location.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Location = obj_
            obj_.original_tagname_ = 'Location'
        elif nodeName_ == 'ManufacturedItemDefinition':
            obj_ = ManufacturedItemDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ManufacturedItemDefinition = obj_
            obj_.original_tagname_ = 'ManufacturedItemDefinition'
        elif nodeName_ == 'Measure':
            obj_ = Measure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Measure = obj_
            obj_.original_tagname_ = 'Measure'
        elif nodeName_ == 'MeasureReport':
            obj_ = MeasureReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MeasureReport = obj_
            obj_.original_tagname_ = 'MeasureReport'
        elif nodeName_ == 'Medication':
            obj_ = Medication.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Medication = obj_
            obj_.original_tagname_ = 'Medication'
        elif nodeName_ == 'MedicationAdministration':
            obj_ = MedicationAdministration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationAdministration = obj_
            obj_.original_tagname_ = 'MedicationAdministration'
        elif nodeName_ == 'MedicationDispense':
            obj_ = MedicationDispense.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationDispense = obj_
            obj_.original_tagname_ = 'MedicationDispense'
        elif nodeName_ == 'MedicationKnowledge':
            obj_ = MedicationKnowledge.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationKnowledge = obj_
            obj_.original_tagname_ = 'MedicationKnowledge'
        elif nodeName_ == 'MedicationRequest':
            obj_ = MedicationRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationRequest = obj_
            obj_.original_tagname_ = 'MedicationRequest'
        elif nodeName_ == 'MedicationStatement':
            obj_ = MedicationStatement.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationStatement = obj_
            obj_.original_tagname_ = 'MedicationStatement'
        elif nodeName_ == 'MedicinalProductDefinition':
            obj_ = MedicinalProductDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicinalProductDefinition = obj_
            obj_.original_tagname_ = 'MedicinalProductDefinition'
        elif nodeName_ == 'MessageDefinition':
            obj_ = MessageDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MessageDefinition = obj_
            obj_.original_tagname_ = 'MessageDefinition'
        elif nodeName_ == 'MessageHeader':
            obj_ = MessageHeader.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MessageHeader = obj_
            obj_.original_tagname_ = 'MessageHeader'
        elif nodeName_ == 'MolecularSequence':
            obj_ = MolecularSequence.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MolecularSequence = obj_
            obj_.original_tagname_ = 'MolecularSequence'
        elif nodeName_ == 'NamingSystem':
            obj_ = NamingSystem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NamingSystem = obj_
            obj_.original_tagname_ = 'NamingSystem'
        elif nodeName_ == 'NutritionIntake':
            obj_ = NutritionIntake.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NutritionIntake = obj_
            obj_.original_tagname_ = 'NutritionIntake'
        elif nodeName_ == 'NutritionOrder':
            obj_ = NutritionOrder.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NutritionOrder = obj_
            obj_.original_tagname_ = 'NutritionOrder'
        elif nodeName_ == 'NutritionProduct':
            obj_ = NutritionProduct.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NutritionProduct = obj_
            obj_.original_tagname_ = 'NutritionProduct'
        elif nodeName_ == 'Observation':
            obj_ = Observation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Observation = obj_
            obj_.original_tagname_ = 'Observation'
        elif nodeName_ == 'ObservationDefinition':
            obj_ = ObservationDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ObservationDefinition = obj_
            obj_.original_tagname_ = 'ObservationDefinition'
        elif nodeName_ == 'OperationDefinition':
            obj_ = OperationDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OperationDefinition = obj_
            obj_.original_tagname_ = 'OperationDefinition'
        elif nodeName_ == 'OperationOutcome':
            obj_ = OperationOutcome.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OperationOutcome = obj_
            obj_.original_tagname_ = 'OperationOutcome'
        elif nodeName_ == 'Organization':
            obj_ = Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Organization = obj_
            obj_.original_tagname_ = 'Organization'
        elif nodeName_ == 'OrganizationAffiliation':
            obj_ = OrganizationAffiliation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OrganizationAffiliation = obj_
            obj_.original_tagname_ = 'OrganizationAffiliation'
        elif nodeName_ == 'PackagedProductDefinition':
            obj_ = PackagedProductDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackagedProductDefinition = obj_
            obj_.original_tagname_ = 'PackagedProductDefinition'
        elif nodeName_ == 'Patient':
            obj_ = Patient.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Patient = obj_
            obj_.original_tagname_ = 'Patient'
        elif nodeName_ == 'PaymentNotice':
            obj_ = PaymentNotice.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PaymentNotice = obj_
            obj_.original_tagname_ = 'PaymentNotice'
        elif nodeName_ == 'PaymentReconciliation':
            obj_ = PaymentReconciliation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PaymentReconciliation = obj_
            obj_.original_tagname_ = 'PaymentReconciliation'
        elif nodeName_ == 'Permission':
            obj_ = Permission.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Permission = obj_
            obj_.original_tagname_ = 'Permission'
        elif nodeName_ == 'Person':
            obj_ = Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Person = obj_
            obj_.original_tagname_ = 'Person'
        elif nodeName_ == 'PlanDefinition':
            obj_ = PlanDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PlanDefinition = obj_
            obj_.original_tagname_ = 'PlanDefinition'
        elif nodeName_ == 'Practitioner':
            obj_ = Practitioner.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Practitioner = obj_
            obj_.original_tagname_ = 'Practitioner'
        elif nodeName_ == 'PractitionerRole':
            obj_ = PractitionerRole.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PractitionerRole = obj_
            obj_.original_tagname_ = 'PractitionerRole'
        elif nodeName_ == 'Procedure':
            obj_ = Procedure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Procedure = obj_
            obj_.original_tagname_ = 'Procedure'
        elif nodeName_ == 'Provenance':
            obj_ = Provenance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Provenance = obj_
            obj_.original_tagname_ = 'Provenance'
        elif nodeName_ == 'Questionnaire':
            obj_ = Questionnaire.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Questionnaire = obj_
            obj_.original_tagname_ = 'Questionnaire'
        elif nodeName_ == 'QuestionnaireResponse':
            obj_ = QuestionnaireResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.QuestionnaireResponse = obj_
            obj_.original_tagname_ = 'QuestionnaireResponse'
        elif nodeName_ == 'RegulatedAuthorization':
            obj_ = RegulatedAuthorization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RegulatedAuthorization = obj_
            obj_.original_tagname_ = 'RegulatedAuthorization'
        elif nodeName_ == 'RelatedPerson':
            obj_ = RelatedPerson.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RelatedPerson = obj_
            obj_.original_tagname_ = 'RelatedPerson'
        elif nodeName_ == 'RequestOrchestration':
            obj_ = RequestOrchestration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RequestOrchestration = obj_
            obj_.original_tagname_ = 'RequestOrchestration'
        elif nodeName_ == 'Requirements':
            obj_ = Requirements.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Requirements = obj_
            obj_.original_tagname_ = 'Requirements'
        elif nodeName_ == 'ResearchStudy':
            obj_ = ResearchStudy.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ResearchStudy = obj_
            obj_.original_tagname_ = 'ResearchStudy'
        elif nodeName_ == 'ResearchSubject':
            obj_ = ResearchSubject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ResearchSubject = obj_
            obj_.original_tagname_ = 'ResearchSubject'
        elif nodeName_ == 'RiskAssessment':
            obj_ = RiskAssessment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RiskAssessment = obj_
            obj_.original_tagname_ = 'RiskAssessment'
        elif nodeName_ == 'Schedule':
            obj_ = Schedule.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Schedule = obj_
            obj_.original_tagname_ = 'Schedule'
        elif nodeName_ == 'SearchParameter':
            obj_ = SearchParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SearchParameter = obj_
            obj_.original_tagname_ = 'SearchParameter'
        elif nodeName_ == 'ServiceRequest':
            obj_ = ServiceRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceRequest = obj_
            obj_.original_tagname_ = 'ServiceRequest'
        elif nodeName_ == 'Slot':
            obj_ = Slot.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Slot = obj_
            obj_.original_tagname_ = 'Slot'
        elif nodeName_ == 'Specimen':
            obj_ = Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Specimen = obj_
            obj_.original_tagname_ = 'Specimen'
        elif nodeName_ == 'SpecimenDefinition':
            obj_ = SpecimenDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SpecimenDefinition = obj_
            obj_.original_tagname_ = 'SpecimenDefinition'
        elif nodeName_ == 'StructureDefinition':
            obj_ = StructureDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StructureDefinition = obj_
            obj_.original_tagname_ = 'StructureDefinition'
        elif nodeName_ == 'StructureMap':
            obj_ = StructureMap.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StructureMap = obj_
            obj_.original_tagname_ = 'StructureMap'
        elif nodeName_ == 'Subscription':
            obj_ = Subscription.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Subscription = obj_
            obj_.original_tagname_ = 'Subscription'
        elif nodeName_ == 'SubscriptionStatus':
            obj_ = SubscriptionStatus.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubscriptionStatus = obj_
            obj_.original_tagname_ = 'SubscriptionStatus'
        elif nodeName_ == 'SubscriptionTopic':
            obj_ = SubscriptionTopic.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubscriptionTopic = obj_
            obj_.original_tagname_ = 'SubscriptionTopic'
        elif nodeName_ == 'Substance':
            obj_ = Substance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Substance = obj_
            obj_.original_tagname_ = 'Substance'
        elif nodeName_ == 'SubstanceDefinition':
            obj_ = SubstanceDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubstanceDefinition = obj_
            obj_.original_tagname_ = 'SubstanceDefinition'
        elif nodeName_ == 'SubstanceNucleicAcid':
            obj_ = SubstanceNucleicAcid.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubstanceNucleicAcid = obj_
            obj_.original_tagname_ = 'SubstanceNucleicAcid'
        elif nodeName_ == 'SubstancePolymer':
            obj_ = SubstancePolymer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubstancePolymer = obj_
            obj_.original_tagname_ = 'SubstancePolymer'
        elif nodeName_ == 'SubstanceProtein':
            obj_ = SubstanceProtein.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubstanceProtein = obj_
            obj_.original_tagname_ = 'SubstanceProtein'
        elif nodeName_ == 'SubstanceReferenceInformation':
            obj_ = SubstanceReferenceInformation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubstanceReferenceInformation = obj_
            obj_.original_tagname_ = 'SubstanceReferenceInformation'
        elif nodeName_ == 'SubstanceSourceMaterial':
            obj_ = SubstanceSourceMaterial.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubstanceSourceMaterial = obj_
            obj_.original_tagname_ = 'SubstanceSourceMaterial'
        elif nodeName_ == 'SupplyDelivery':
            obj_ = SupplyDelivery.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SupplyDelivery = obj_
            obj_.original_tagname_ = 'SupplyDelivery'
        elif nodeName_ == 'SupplyRequest':
            obj_ = SupplyRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SupplyRequest = obj_
            obj_.original_tagname_ = 'SupplyRequest'
        elif nodeName_ == 'Task':
            obj_ = Task.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Task = obj_
            obj_.original_tagname_ = 'Task'
        elif nodeName_ == 'TerminologyCapabilities':
            obj_ = TerminologyCapabilities.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TerminologyCapabilities = obj_
            obj_.original_tagname_ = 'TerminologyCapabilities'
        elif nodeName_ == 'TestPlan':
            obj_ = TestPlan.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TestPlan = obj_
            obj_.original_tagname_ = 'TestPlan'
        elif nodeName_ == 'TestReport':
            obj_ = TestReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TestReport = obj_
            obj_.original_tagname_ = 'TestReport'
        elif nodeName_ == 'TestScript':
            obj_ = TestScript.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TestScript = obj_
            obj_.original_tagname_ = 'TestScript'
        elif nodeName_ == 'Transport':
            obj_ = Transport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Transport = obj_
            obj_.original_tagname_ = 'Transport'
        elif nodeName_ == 'ValueSet':
            obj_ = ValueSet.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ValueSet = obj_
            obj_.original_tagname_ = 'ValueSet'
        elif nodeName_ == 'VerificationResult':
            obj_ = VerificationResult.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.VerificationResult = obj_
            obj_.original_tagname_ = 'VerificationResult'
        elif nodeName_ == 'VisionPrescription':
            obj_ = VisionPrescription.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.VisionPrescription = obj_
            obj_.original_tagname_ = 'VisionPrescription'
        elif nodeName_ == 'Parameters':
            obj_ = Parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Parameters = obj_
            obj_.original_tagname_ = 'Parameters'
# end class ResourceContainer


class Base(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Base)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Base.subclass:
            return Base.subclass(*args_, **kwargs_)
        else:
            return Base(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Base', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Base')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Base':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Base')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Base', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Base'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Base', fromsubclass_=False, pretty_print=True):
        pass
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class Base


class Resource(Base):
    """id -- The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
    meta -- The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
    implicitRules -- A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
    language -- The base language in which the resource is written.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Base
    def __init__(self, id: 'id' = None, meta: 'Meta' = None, implicitRules: 'uri' = None, language: 'code' = None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Resource"), self).__init__(extensiontype_,  **kwargs_)
        self.id = id
        self.id_nsprefix_ = None
        self.meta = meta
        self.meta_nsprefix_ = None
        self.implicitRules = implicitRules
        self.implicitRules_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Resource)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Resource.subclass:
            return Resource.subclass(*args_, **kwargs_)
        else:
            return Resource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_meta(self):
        return self.meta
    def set_meta(self, meta):
        self.meta = meta
    def get_implicitRules(self):
        return self.implicitRules
    def set_implicitRules(self, implicitRules):
        self.implicitRules = implicitRules
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.id is not None or
            self.meta is not None or
            self.implicitRules is not None or
            self.language is not None or
            super(Resource, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Resource', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Resource')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Resource':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Resource')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Resource', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Resource'):
        super(Resource, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Resource')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Resource', fromsubclass_=False, pretty_print=True):
        super(Resource, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            self.id.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.meta is not None:
            namespaceprefix_ = self.meta_nsprefix_ + ':' if (UseCapturedNS_ and self.meta_nsprefix_) else ''
            self.meta.export(outfile, level, namespaceprefix_, namespacedef_='', name_='meta', pretty_print=pretty_print)
        if self.implicitRules is not None:
            namespaceprefix_ = self.implicitRules_nsprefix_ + ':' if (UseCapturedNS_ and self.implicitRules_nsprefix_) else ''
            self.implicitRules.export(outfile, level, namespaceprefix_, namespacedef_='', name_='implicitRules', pretty_print=pretty_print)
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            self.language.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.id is not None:
            child_dict = self.id.exportJson(json_dict, 'id', False)
            if child_dict:
                json_dict['id'] = child_dict
        if self.meta is not None:
            child_dict = self.meta.exportJson(json_dict, 'meta', False)
            if child_dict:
                json_dict['meta'] = child_dict
        if self.implicitRules is not None:
            child_dict = self.implicitRules.exportJson(json_dict, 'implicitRules', False)
            if child_dict:
                json_dict['implicitRules'] = child_dict
        if self.language is not None:
            child_dict = self.language.exportJson(json_dict, 'language', False)
            if child_dict:
                json_dict['language'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Resource, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id':
            obj_ = id.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'meta':
            obj_ = Meta.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.meta = obj_
            obj_.original_tagname_ = 'meta'
        elif nodeName_ == 'implicitRules':
            obj_ = uri.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.implicitRules = obj_
            obj_.original_tagname_ = 'implicitRules'
        elif nodeName_ == 'language':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.language = obj_
            obj_.original_tagname_ = 'language'
        super(Resource, self)._buildChildren(child_, node, nodeName_, True)
# end class Resource


class Binary(Resource):
    """contentType -- MimeType of the binary content represented as a standard MimeType (BCP 13).
    securityContext -- This element identifies another resource that can be used as a proxy of the security sensitivity to use when deciding and enforcing access control rules for the Binary resource. Given that the Binary resource contains very few elements that can be used to determine the sensitivity of the data and relationships to individuals, the referenced resource stands in as a proxy equivalent for this purpose. This referenced resource may be related to the Binary (e.g. DocumentReference), or may be some non-related Resource purely as a security proxy. E.g. to identify that the binary resource relates to a patient, and access should only be granted to applications that have access to the patient.
    data -- The actual content, base64 encoded.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Resource
    def __init__(self, id: 'id' = None, meta: 'Meta' = None, implicitRules: 'uri' = None, language: 'code' = None, contentType: 'code' = None, securityContext: 'Reference' = None, data: 'base64Binary' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Binary"), self).__init__(id, meta, implicitRules, language,  **kwargs_)
        self.contentType = contentType
        self.contentType_nsprefix_ = None
        self.securityContext = securityContext
        self.securityContext_nsprefix_ = None
        self.data = data
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Binary)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Binary.subclass:
            return Binary.subclass(*args_, **kwargs_)
        else:
            return Binary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_contentType(self):
        return self.contentType
    def set_contentType(self, contentType):
        self.contentType = contentType
    def get_securityContext(self):
        return self.securityContext
    def set_securityContext(self, securityContext):
        self.securityContext = securityContext
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def has__content(self):
        if (
            self.contentType is not None or
            self.securityContext is not None or
            self.data is not None or
            super(Binary, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Binary', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Binary')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Binary':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Binary')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Binary', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Binary'):
        super(Binary, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Binary')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Binary', fromsubclass_=False, pretty_print=True):
        super(Binary, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.contentType is not None:
            namespaceprefix_ = self.contentType_nsprefix_ + ':' if (UseCapturedNS_ and self.contentType_nsprefix_) else ''
            self.contentType.export(outfile, level, namespaceprefix_, namespacedef_='', name_='contentType', pretty_print=pretty_print)
        if self.securityContext is not None:
            namespaceprefix_ = self.securityContext_nsprefix_ + ':' if (UseCapturedNS_ and self.securityContext_nsprefix_) else ''
            self.securityContext.export(outfile, level, namespaceprefix_, namespacedef_='', name_='securityContext', pretty_print=pretty_print)
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            self.data.export(outfile, level, namespaceprefix_, namespacedef_='', name_='data', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.contentType is not None:
            child_dict = self.contentType.exportJson(json_dict, 'contentType', False)
            if child_dict:
                json_dict['contentType'] = child_dict
        if self.securityContext is not None:
            child_dict = self.securityContext.exportJson(json_dict, 'securityContext', False)
            if child_dict:
                json_dict['securityContext'] = child_dict
        if self.data is not None:
            child_dict = self.data.exportJson(json_dict, 'data', False)
            if child_dict:
                json_dict['data'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Binary, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'contentType':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contentType = obj_
            obj_.original_tagname_ = 'contentType'
        elif nodeName_ == 'securityContext':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.securityContext = obj_
            obj_.original_tagname_ = 'securityContext'
        elif nodeName_ == 'data':
            obj_ = base64Binary.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.data = obj_
            obj_.original_tagname_ = 'data'
        super(Binary, self)._buildChildren(child_, node, nodeName_, True)
# end class Binary


class Bundle(Resource):
    """identifier -- A persistent identifier for the bundle that won't change as a bundle is copied from server to server.
    type -- Indicates the purpose of this bundle - how it is intended to be used.
    timestamp -- The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.
    total -- If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.
    link -- A series of links that provide context to this bundle.
    entry -- An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).
    signature -- Digital Signature - base64 encoded. XML-DSig or a JWS.
    issues -- Captures issues and warnings that relate to the construction of the Bundle and the content within it.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Resource
    def __init__(self, id: 'id' = None, meta: 'Meta' = None, implicitRules: 'uri' = None, language: 'code' = None, identifier: 'Identifier' = None, type_: 'BundleType' = None, timestamp: 'instant' = None, total: 'unsignedInt' = None, link: List_['Bundle.Link'] = None, entry: List_['Bundle.Entry'] = None, signature: 'Signature' = None, issues: 'ResourceContainer' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Bundle"), self).__init__(id, meta, implicitRules, language,  **kwargs_)
        self.identifier = identifier
        self.identifier_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.timestamp = timestamp
        self.timestamp_nsprefix_ = None
        self.total = total
        self.total_nsprefix_ = None
        if link is None:
            self.link = []
        else:
            self.link = link
        self.link_nsprefix_ = None
        if entry is None:
            self.entry = []
        else:
            self.entry = entry
        self.entry_nsprefix_ = None
        self.signature = signature
        self.signature_nsprefix_ = None
        self.issues = issues
        self.issues_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Bundle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Bundle.subclass:
            return Bundle.subclass(*args_, **kwargs_)
        else:
            return Bundle(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_identifier(self):
        return self.identifier
    def set_identifier(self, identifier):
        self.identifier = identifier
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_timestamp(self):
        return self.timestamp
    def set_timestamp(self, timestamp):
        self.timestamp = timestamp
    def get_total(self):
        return self.total
    def set_total(self, total):
        self.total = total
    def get_link(self):
        return self.link
    def set_link(self, link):
        self.link = link
    def add_link(self, value):
        self.link.append(value)
    def insert_link_at(self, index, value):
        self.link.insert(index, value)
    def replace_link_at(self, index, value):
        self.link[index] = value
    def get_entry(self):
        return self.entry
    def set_entry(self, entry):
        self.entry = entry
    def add_entry(self, value):
        self.entry.append(value)
    def insert_entry_at(self, index, value):
        self.entry.insert(index, value)
    def replace_entry_at(self, index, value):
        self.entry[index] = value
    def get_signature(self):
        return self.signature
    def set_signature(self, signature):
        self.signature = signature
    def get_issues(self):
        return self.issues
    def set_issues(self, issues):
        self.issues = issues
    def has__content(self):
        if (
            self.identifier is not None or
            self.type_ is not None or
            self.timestamp is not None or
            self.total is not None or
            self.link or
            self.entry or
            self.signature is not None or
            self.issues is not None or
            super(Bundle, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Bundle', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Bundle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Bundle':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Bundle')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Bundle', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Bundle'):
        super(Bundle, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Bundle')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Bundle', fromsubclass_=False, pretty_print=True):
        super(Bundle, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.identifier is not None:
            namespaceprefix_ = self.identifier_nsprefix_ + ':' if (UseCapturedNS_ and self.identifier_nsprefix_) else ''
            self.identifier.export(outfile, level, namespaceprefix_, namespacedef_='', name_='identifier', pretty_print=pretty_print)
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.timestamp is not None:
            namespaceprefix_ = self.timestamp_nsprefix_ + ':' if (UseCapturedNS_ and self.timestamp_nsprefix_) else ''
            self.timestamp.export(outfile, level, namespaceprefix_, namespacedef_='', name_='timestamp', pretty_print=pretty_print)
        if self.total is not None:
            namespaceprefix_ = self.total_nsprefix_ + ':' if (UseCapturedNS_ and self.total_nsprefix_) else ''
            self.total.export(outfile, level, namespaceprefix_, namespacedef_='', name_='total', pretty_print=pretty_print)
        for link_ in self.link:
            namespaceprefix_ = self.link_nsprefix_ + ':' if (UseCapturedNS_ and self.link_nsprefix_) else ''
            link_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='link', pretty_print=pretty_print)
        for entry_ in self.entry:
            namespaceprefix_ = self.entry_nsprefix_ + ':' if (UseCapturedNS_ and self.entry_nsprefix_) else ''
            entry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entry', pretty_print=pretty_print)
        if self.signature is not None:
            namespaceprefix_ = self.signature_nsprefix_ + ':' if (UseCapturedNS_ and self.signature_nsprefix_) else ''
            self.signature.export(outfile, level, namespaceprefix_, namespacedef_='', name_='signature', pretty_print=pretty_print)
        if self.issues is not None:
            namespaceprefix_ = self.issues_nsprefix_ + ':' if (UseCapturedNS_ and self.issues_nsprefix_) else ''
            self.issues.export(outfile, level, namespaceprefix_, namespacedef_='', name_='issues', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.identifier is not None:
            child_dict = self.identifier.exportJson(json_dict, 'identifier', False)
            if child_dict:
                json_dict['identifier'] = child_dict
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.timestamp is not None:
            child_dict = self.timestamp.exportJson(json_dict, 'timestamp', False)
            if child_dict:
                json_dict['timestamp'] = child_dict
        if self.total is not None:
            child_dict = self.total.exportJson(json_dict, 'total', False)
            if child_dict:
                json_dict['total'] = child_dict
        child_list = []
        for child in self.link:
            child_dict = child.exportJson(json_dict, 'link', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['link'] = child_list
        child_list = []
        for child in self.entry:
            child_dict = child.exportJson(json_dict, 'entry', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['entry'] = child_list
        if self.signature is not None:
            child_dict = self.signature.exportJson(json_dict, 'signature', False)
            if child_dict:
                json_dict['signature'] = child_dict
        if self.issues is not None:
            child_dict = self.issues.exportJson(json_dict, 'issues', False)
            if child_dict:
                json_dict['issues'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Bundle, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'identifier':
            obj_ = Identifier.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.identifier = obj_
            obj_.original_tagname_ = 'identifier'
        elif nodeName_ == 'type':
            obj_ = BundleType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'timestamp':
            obj_ = instant.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.timestamp = obj_
            obj_.original_tagname_ = 'timestamp'
        elif nodeName_ == 'total':
            obj_ = unsignedInt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.total = obj_
            obj_.original_tagname_ = 'total'
        elif nodeName_ == 'link':
            obj_ = Bundle_Link.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.link.append(obj_)
            obj_.original_tagname_ = 'link'
        elif nodeName_ == 'entry':
            obj_ = Bundle_Entry.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entry.append(obj_)
            obj_.original_tagname_ = 'entry'
        elif nodeName_ == 'signature':
            obj_ = Signature.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signature = obj_
            obj_.original_tagname_ = 'signature'
        elif nodeName_ == 'issues':
            obj_ = ResourceContainer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.issues = obj_
            obj_.original_tagname_ = 'issues'
        super(Bundle, self)._buildChildren(child_, node, nodeName_, True)
# end class Bundle


class Parameters(Resource):
    """parameter -- A parameter passed to or received from the operation.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Resource
    def __init__(self, id: 'id' = None, meta: 'Meta' = None, implicitRules: 'uri' = None, language: 'code' = None, parameter: List_['Parameters.Parameter'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Parameters"), self).__init__(id, meta, implicitRules, language,  **kwargs_)
        if parameter is None:
            self.parameter = []
        else:
            self.parameter = parameter
        self.parameter_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Parameters)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Parameters.subclass:
            return Parameters.subclass(*args_, **kwargs_)
        else:
            return Parameters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_parameter(self):
        return self.parameter
    def set_parameter(self, parameter):
        self.parameter = parameter
    def add_parameter(self, value):
        self.parameter.append(value)
    def insert_parameter_at(self, index, value):
        self.parameter.insert(index, value)
    def replace_parameter_at(self, index, value):
        self.parameter[index] = value
    def has__content(self):
        if (
            self.parameter or
            super(Parameters, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Parameters', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Parameters')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Parameters':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Parameters')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Parameters', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Parameters'):
        super(Parameters, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Parameters')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Parameters', fromsubclass_=False, pretty_print=True):
        super(Parameters, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for parameter_ in self.parameter:
            namespaceprefix_ = self.parameter_nsprefix_ + ':' if (UseCapturedNS_ and self.parameter_nsprefix_) else ''
            parameter_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='parameter', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        child_list = []
        for child in self.parameter:
            child_dict = child.exportJson(json_dict, 'parameter', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['parameter'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Parameters, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'parameter':
            obj_ = Parameters_Parameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parameter.append(obj_)
            obj_.original_tagname_ = 'parameter'
        super(Parameters, self)._buildChildren(child_, node, nodeName_, True)
# end class Parameters


class Inline(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if a is None:
            self.a = []
        else:
            self.a = a
        self.a_nsprefix_ = None
        if br is None:
            self.br = []
        else:
            self.br = br
        self.br_nsprefix_ = None
        if span is None:
            self.span = []
        else:
            self.span = span
        self.span_nsprefix_ = None
        if bdo is None:
            self.bdo = []
        else:
            self.bdo = bdo
        self.bdo_nsprefix_ = None
        if map is None:
            self.map = []
        else:
            self.map = map
        self.map_nsprefix_ = None
        if img is None:
            self.img = []
        else:
            self.img = img
        self.img_nsprefix_ = None
        if tt is None:
            self.tt = []
        else:
            self.tt = tt
        self.tt_nsprefix_ = None
        if i is None:
            self.i = []
        else:
            self.i = i
        self.i_nsprefix_ = None
        if b is None:
            self.b = []
        else:
            self.b = b
        self.b_nsprefix_ = None
        if big is None:
            self.big = []
        else:
            self.big = big
        self.big_nsprefix_ = None
        if small is None:
            self.small = []
        else:
            self.small = small
        self.small_nsprefix_ = None
        if em is None:
            self.em = []
        else:
            self.em = em
        self.em_nsprefix_ = None
        if strong is None:
            self.strong = []
        else:
            self.strong = strong
        self.strong_nsprefix_ = None
        if dfn is None:
            self.dfn = []
        else:
            self.dfn = dfn
        self.dfn_nsprefix_ = None
        if code is None:
            self.code = []
        else:
            self.code = code
        self.code_nsprefix_ = None
        if q is None:
            self.q = []
        else:
            self.q = q
        self.q_nsprefix_ = None
        if samp is None:
            self.samp = []
        else:
            self.samp = samp
        self.samp_nsprefix_ = None
        if kbd is None:
            self.kbd = []
        else:
            self.kbd = kbd
        self.kbd_nsprefix_ = None
        if var is None:
            self.var = []
        else:
            self.var = var
        self.var_nsprefix_ = None
        if cite is None:
            self.cite = []
        else:
            self.cite = cite
        self.cite_nsprefix_ = None
        if abbr is None:
            self.abbr = []
        else:
            self.abbr = abbr
        self.abbr_nsprefix_ = None
        if acronym is None:
            self.acronym = []
        else:
            self.acronym = acronym
        self.acronym_nsprefix_ = None
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        self.sub_nsprefix_ = None
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        self.sup_nsprefix_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Inline)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Inline.subclass:
            return Inline.subclass(*args_, **kwargs_)
        else:
            return Inline(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_a(self):
        return self.a
    def set_a(self, a):
        self.a = a
    def add_a(self, value):
        self.a.append(value)
    def insert_a_at(self, index, value):
        self.a.insert(index, value)
    def replace_a_at(self, index, value):
        self.a[index] = value
    def get_br(self):
        return self.br
    def set_br(self, br):
        self.br = br
    def add_br(self, value):
        self.br.append(value)
    def insert_br_at(self, index, value):
        self.br.insert(index, value)
    def replace_br_at(self, index, value):
        self.br[index] = value
    def get_span(self):
        return self.span
    def set_span(self, span):
        self.span = span
    def add_span(self, value):
        self.span.append(value)
    def insert_span_at(self, index, value):
        self.span.insert(index, value)
    def replace_span_at(self, index, value):
        self.span[index] = value
    def get_bdo(self):
        return self.bdo
    def set_bdo(self, bdo):
        self.bdo = bdo
    def add_bdo(self, value):
        self.bdo.append(value)
    def insert_bdo_at(self, index, value):
        self.bdo.insert(index, value)
    def replace_bdo_at(self, index, value):
        self.bdo[index] = value
    def get_map(self):
        return self.map
    def set_map(self, map):
        self.map = map
    def add_map(self, value):
        self.map.append(value)
    def insert_map_at(self, index, value):
        self.map.insert(index, value)
    def replace_map_at(self, index, value):
        self.map[index] = value
    def get_img(self):
        return self.img
    def set_img(self, img):
        self.img = img
    def add_img(self, value):
        self.img.append(value)
    def insert_img_at(self, index, value):
        self.img.insert(index, value)
    def replace_img_at(self, index, value):
        self.img[index] = value
    def get_tt(self):
        return self.tt
    def set_tt(self, tt):
        self.tt = tt
    def add_tt(self, value):
        self.tt.append(value)
    def insert_tt_at(self, index, value):
        self.tt.insert(index, value)
    def replace_tt_at(self, index, value):
        self.tt[index] = value
    def get_i(self):
        return self.i
    def set_i(self, i):
        self.i = i
    def add_i(self, value):
        self.i.append(value)
    def insert_i_at(self, index, value):
        self.i.insert(index, value)
    def replace_i_at(self, index, value):
        self.i[index] = value
    def get_b(self):
        return self.b
    def set_b(self, b):
        self.b = b
    def add_b(self, value):
        self.b.append(value)
    def insert_b_at(self, index, value):
        self.b.insert(index, value)
    def replace_b_at(self, index, value):
        self.b[index] = value
    def get_big(self):
        return self.big
    def set_big(self, big):
        self.big = big
    def add_big(self, value):
        self.big.append(value)
    def insert_big_at(self, index, value):
        self.big.insert(index, value)
    def replace_big_at(self, index, value):
        self.big[index] = value
    def get_small(self):
        return self.small
    def set_small(self, small):
        self.small = small
    def add_small(self, value):
        self.small.append(value)
    def insert_small_at(self, index, value):
        self.small.insert(index, value)
    def replace_small_at(self, index, value):
        self.small[index] = value
    def get_em(self):
        return self.em
    def set_em(self, em):
        self.em = em
    def add_em(self, value):
        self.em.append(value)
    def insert_em_at(self, index, value):
        self.em.insert(index, value)
    def replace_em_at(self, index, value):
        self.em[index] = value
    def get_strong(self):
        return self.strong
    def set_strong(self, strong):
        self.strong = strong
    def add_strong(self, value):
        self.strong.append(value)
    def insert_strong_at(self, index, value):
        self.strong.insert(index, value)
    def replace_strong_at(self, index, value):
        self.strong[index] = value
    def get_dfn(self):
        return self.dfn
    def set_dfn(self, dfn):
        self.dfn = dfn
    def add_dfn(self, value):
        self.dfn.append(value)
    def insert_dfn_at(self, index, value):
        self.dfn.insert(index, value)
    def replace_dfn_at(self, index, value):
        self.dfn[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def add_code(self, value):
        self.code.append(value)
    def insert_code_at(self, index, value):
        self.code.insert(index, value)
    def replace_code_at(self, index, value):
        self.code[index] = value
    def get_q(self):
        return self.q
    def set_q(self, q):
        self.q = q
    def add_q(self, value):
        self.q.append(value)
    def insert_q_at(self, index, value):
        self.q.insert(index, value)
    def replace_q_at(self, index, value):
        self.q[index] = value
    def get_samp(self):
        return self.samp
    def set_samp(self, samp):
        self.samp = samp
    def add_samp(self, value):
        self.samp.append(value)
    def insert_samp_at(self, index, value):
        self.samp.insert(index, value)
    def replace_samp_at(self, index, value):
        self.samp[index] = value
    def get_kbd(self):
        return self.kbd
    def set_kbd(self, kbd):
        self.kbd = kbd
    def add_kbd(self, value):
        self.kbd.append(value)
    def insert_kbd_at(self, index, value):
        self.kbd.insert(index, value)
    def replace_kbd_at(self, index, value):
        self.kbd[index] = value
    def get_var(self):
        return self.var
    def set_var(self, var):
        self.var = var
    def add_var(self, value):
        self.var.append(value)
    def insert_var_at(self, index, value):
        self.var.insert(index, value)
    def replace_var_at(self, index, value):
        self.var[index] = value
    def get_cite(self):
        return self.cite
    def set_cite(self, cite):
        self.cite = cite
    def add_cite(self, value):
        self.cite.append(value)
    def insert_cite_at(self, index, value):
        self.cite.insert(index, value)
    def replace_cite_at(self, index, value):
        self.cite[index] = value
    def get_abbr(self):
        return self.abbr
    def set_abbr(self, abbr):
        self.abbr = abbr
    def add_abbr(self, value):
        self.abbr.append(value)
    def insert_abbr_at(self, index, value):
        self.abbr.insert(index, value)
    def replace_abbr_at(self, index, value):
        self.abbr[index] = value
    def get_acronym(self):
        return self.acronym
    def set_acronym(self, acronym):
        self.acronym = acronym
    def add_acronym(self, value):
        self.acronym.append(value)
    def insert_acronym_at(self, index, value):
        self.acronym.insert(index, value)
    def replace_acronym_at(self, index, value):
        self.acronym[index] = value
    def get_sub(self):
        return self.sub
    def set_sub(self, sub):
        self.sub = sub
    def add_sub(self, value):
        self.sub.append(value)
    def insert_sub_at(self, index, value):
        self.sub.insert(index, value)
    def replace_sub_at(self, index, value):
        self.sub[index] = value
    def get_sup(self):
        return self.sup
    def set_sup(self, sup):
        self.sup = sup
    def add_sup(self, value):
        self.sup.append(value)
    def insert_sup_at(self, index, value):
        self.sup.insert(index, value)
    def replace_sup_at(self, index, value):
        self.sup[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.a or
            self.br or
            self.span or
            self.bdo or
            self.map or
            self.img or
            self.tt or
            self.i or
            self.b or
            self.big or
            self.small or
            self.em or
            self.strong or
            self.dfn or
            self.code or
            self.q or
            self.samp or
            self.kbd or
            self.var or
            self.cite or
            self.abbr or
            self.acronym or
            self.sub or
            self.sup or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='Inline', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Inline')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Inline':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Inline')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Inline'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='Inline', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for a_ in self.a:
            namespaceprefix_ = self.a_nsprefix_ + ':' if (UseCapturedNS_ and self.a_nsprefix_) else ''
            a_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='a', pretty_print=pretty_print)
        for br_ in self.br:
            namespaceprefix_ = self.br_nsprefix_ + ':' if (UseCapturedNS_ and self.br_nsprefix_) else ''
            br_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='br', pretty_print=pretty_print)
        for span_ in self.span:
            namespaceprefix_ = self.span_nsprefix_ + ':' if (UseCapturedNS_ and self.span_nsprefix_) else ''
            span_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='span', pretty_print=pretty_print)
        for bdo_ in self.bdo:
            namespaceprefix_ = self.bdo_nsprefix_ + ':' if (UseCapturedNS_ and self.bdo_nsprefix_) else ''
            bdo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bdo', pretty_print=pretty_print)
        for map_ in self.map:
            namespaceprefix_ = self.map_nsprefix_ + ':' if (UseCapturedNS_ and self.map_nsprefix_) else ''
            map_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='map', pretty_print=pretty_print)
        for img_ in self.img:
            namespaceprefix_ = self.img_nsprefix_ + ':' if (UseCapturedNS_ and self.img_nsprefix_) else ''
            img_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='img', pretty_print=pretty_print)
        for tt_ in self.tt:
            namespaceprefix_ = self.tt_nsprefix_ + ':' if (UseCapturedNS_ and self.tt_nsprefix_) else ''
            tt_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tt', pretty_print=pretty_print)
        for i_ in self.i:
            namespaceprefix_ = self.i_nsprefix_ + ':' if (UseCapturedNS_ and self.i_nsprefix_) else ''
            i_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='i', pretty_print=pretty_print)
        for b_ in self.b:
            namespaceprefix_ = self.b_nsprefix_ + ':' if (UseCapturedNS_ and self.b_nsprefix_) else ''
            b_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='b', pretty_print=pretty_print)
        for big_ in self.big:
            namespaceprefix_ = self.big_nsprefix_ + ':' if (UseCapturedNS_ and self.big_nsprefix_) else ''
            big_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='big', pretty_print=pretty_print)
        for small_ in self.small:
            namespaceprefix_ = self.small_nsprefix_ + ':' if (UseCapturedNS_ and self.small_nsprefix_) else ''
            small_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='small', pretty_print=pretty_print)
        for em_ in self.em:
            namespaceprefix_ = self.em_nsprefix_ + ':' if (UseCapturedNS_ and self.em_nsprefix_) else ''
            em_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='em', pretty_print=pretty_print)
        for strong_ in self.strong:
            namespaceprefix_ = self.strong_nsprefix_ + ':' if (UseCapturedNS_ and self.strong_nsprefix_) else ''
            strong_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='strong', pretty_print=pretty_print)
        for dfn_ in self.dfn:
            namespaceprefix_ = self.dfn_nsprefix_ + ':' if (UseCapturedNS_ and self.dfn_nsprefix_) else ''
            dfn_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dfn', pretty_print=pretty_print)
        for code_ in self.code:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            code_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for q_ in self.q:
            namespaceprefix_ = self.q_nsprefix_ + ':' if (UseCapturedNS_ and self.q_nsprefix_) else ''
            q_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='q', pretty_print=pretty_print)
        for samp_ in self.samp:
            namespaceprefix_ = self.samp_nsprefix_ + ':' if (UseCapturedNS_ and self.samp_nsprefix_) else ''
            samp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='samp', pretty_print=pretty_print)
        for kbd_ in self.kbd:
            namespaceprefix_ = self.kbd_nsprefix_ + ':' if (UseCapturedNS_ and self.kbd_nsprefix_) else ''
            kbd_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='kbd', pretty_print=pretty_print)
        for var_ in self.var:
            namespaceprefix_ = self.var_nsprefix_ + ':' if (UseCapturedNS_ and self.var_nsprefix_) else ''
            var_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='var', pretty_print=pretty_print)
        for cite_ in self.cite:
            namespaceprefix_ = self.cite_nsprefix_ + ':' if (UseCapturedNS_ and self.cite_nsprefix_) else ''
            cite_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cite', pretty_print=pretty_print)
        for abbr_ in self.abbr:
            namespaceprefix_ = self.abbr_nsprefix_ + ':' if (UseCapturedNS_ and self.abbr_nsprefix_) else ''
            abbr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abbr', pretty_print=pretty_print)
        for acronym_ in self.acronym:
            namespaceprefix_ = self.acronym_nsprefix_ + ':' if (UseCapturedNS_ and self.acronym_nsprefix_) else ''
            acronym_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acronym', pretty_print=pretty_print)
        for sub_ in self.sub:
            namespaceprefix_ = self.sub_nsprefix_ + ':' if (UseCapturedNS_ and self.sub_nsprefix_) else ''
            sub_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sub', pretty_print=pretty_print)
        for sup_ in self.sup:
            namespaceprefix_ = self.sup_nsprefix_ + ':' if (UseCapturedNS_ and self.sup_nsprefix_) else ''
            sup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sup', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.a:
            child_dict = child.exportJson(json_dict, 'a', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['a'] = child_list
        child_list = []
        for child in self.br:
            child_dict = child.exportJson(json_dict, 'br', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['br'] = child_list
        child_list = []
        for child in self.span:
            child_dict = child.exportJson(json_dict, 'span', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['span'] = child_list
        child_list = []
        for child in self.bdo:
            child_dict = child.exportJson(json_dict, 'bdo', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['bdo'] = child_list
        child_list = []
        for child in self.map:
            child_dict = child.exportJson(json_dict, 'map', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['map'] = child_list
        child_list = []
        for child in self.img:
            child_dict = child.exportJson(json_dict, 'img', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['img'] = child_list
        child_list = []
        for child in self.tt:
            child_dict = child.exportJson(json_dict, 'tt', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['tt'] = child_list
        child_list = []
        for child in self.i:
            child_dict = child.exportJson(json_dict, 'i', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['i'] = child_list
        child_list = []
        for child in self.b:
            child_dict = child.exportJson(json_dict, 'b', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['b'] = child_list
        child_list = []
        for child in self.big:
            child_dict = child.exportJson(json_dict, 'big', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['big'] = child_list
        child_list = []
        for child in self.small:
            child_dict = child.exportJson(json_dict, 'small', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['small'] = child_list
        child_list = []
        for child in self.em:
            child_dict = child.exportJson(json_dict, 'em', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['em'] = child_list
        child_list = []
        for child in self.strong:
            child_dict = child.exportJson(json_dict, 'strong', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['strong'] = child_list
        child_list = []
        for child in self.dfn:
            child_dict = child.exportJson(json_dict, 'dfn', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dfn'] = child_list
        child_list = []
        for child in self.code:
            child_dict = child.exportJson(json_dict, 'code', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['code'] = child_list
        child_list = []
        for child in self.q:
            child_dict = child.exportJson(json_dict, 'q', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['q'] = child_list
        child_list = []
        for child in self.samp:
            child_dict = child.exportJson(json_dict, 'samp', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['samp'] = child_list
        child_list = []
        for child in self.kbd:
            child_dict = child.exportJson(json_dict, 'kbd', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['kbd'] = child_list
        child_list = []
        for child in self.var:
            child_dict = child.exportJson(json_dict, 'var', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['var'] = child_list
        child_list = []
        for child in self.cite:
            child_dict = child.exportJson(json_dict, 'cite', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['cite'] = child_list
        child_list = []
        for child in self.abbr:
            child_dict = child.exportJson(json_dict, 'abbr', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['abbr'] = child_list
        child_list = []
        for child in self.acronym:
            child_dict = child.exportJson(json_dict, 'acronym', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['acronym'] = child_list
        child_list = []
        for child in self.sub:
            child_dict = child.exportJson(json_dict, 'sub', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sub'] = child_list
        child_list = []
        for child in self.sup:
            child_dict = child.exportJson(json_dict, 'sup', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sup'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'a':
            obj_ = a.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'a', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_a'):
              self.add_a(obj_.value)
            elif hasattr(self, 'set_a'):
              self.set_a(obj_.value)
        elif nodeName_ == 'br':
            obj_ = br.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'br', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_br'):
              self.add_br(obj_.value)
            elif hasattr(self, 'set_br'):
              self.set_br(obj_.value)
        elif nodeName_ == 'span':
            obj_ = span.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'span', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_span'):
              self.add_span(obj_.value)
            elif hasattr(self, 'set_span'):
              self.set_span(obj_.value)
        elif nodeName_ == 'bdo':
            obj_ = bdo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'bdo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_bdo'):
              self.add_bdo(obj_.value)
            elif hasattr(self, 'set_bdo'):
              self.set_bdo(obj_.value)
        elif nodeName_ == 'map':
            obj_ = map.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'map', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_map'):
              self.add_map(obj_.value)
            elif hasattr(self, 'set_map'):
              self.set_map(obj_.value)
        elif nodeName_ == 'img':
            obj_ = img.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'img', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_img'):
              self.add_img(obj_.value)
            elif hasattr(self, 'set_img'):
              self.set_img(obj_.value)
        elif nodeName_ == 'tt':
            obj_ = tt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tt', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tt'):
              self.add_tt(obj_.value)
            elif hasattr(self, 'set_tt'):
              self.set_tt(obj_.value)
        elif nodeName_ == 'i':
            obj_ = i.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'i', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_i'):
              self.add_i(obj_.value)
            elif hasattr(self, 'set_i'):
              self.set_i(obj_.value)
        elif nodeName_ == 'b':
            obj_ = b.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'b', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_b'):
              self.add_b(obj_.value)
            elif hasattr(self, 'set_b'):
              self.set_b(obj_.value)
        elif nodeName_ == 'big':
            obj_ = big.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'big', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_big'):
              self.add_big(obj_.value)
            elif hasattr(self, 'set_big'):
              self.set_big(obj_.value)
        elif nodeName_ == 'small':
            obj_ = small.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'small', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_small'):
              self.add_small(obj_.value)
            elif hasattr(self, 'set_small'):
              self.set_small(obj_.value)
        elif nodeName_ == 'em':
            obj_ = em.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'em', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_em'):
              self.add_em(obj_.value)
            elif hasattr(self, 'set_em'):
              self.set_em(obj_.value)
        elif nodeName_ == 'strong':
            obj_ = strong.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'strong', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_strong'):
              self.add_strong(obj_.value)
            elif hasattr(self, 'set_strong'):
              self.set_strong(obj_.value)
        elif nodeName_ == 'dfn':
            obj_ = dfn.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'dfn', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_dfn'):
              self.add_dfn(obj_.value)
            elif hasattr(self, 'set_dfn'):
              self.set_dfn(obj_.value)
        elif nodeName_ == 'code':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'code', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_code'):
              self.add_code(obj_.value)
            elif hasattr(self, 'set_code'):
              self.set_code(obj_.value)
        elif nodeName_ == 'q':
            obj_ = q.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'q', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_q'):
              self.add_q(obj_.value)
            elif hasattr(self, 'set_q'):
              self.set_q(obj_.value)
        elif nodeName_ == 'samp':
            obj_ = samp.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'samp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_samp'):
              self.add_samp(obj_.value)
            elif hasattr(self, 'set_samp'):
              self.set_samp(obj_.value)
        elif nodeName_ == 'kbd':
            obj_ = kbd.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'kbd', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_kbd'):
              self.add_kbd(obj_.value)
            elif hasattr(self, 'set_kbd'):
              self.set_kbd(obj_.value)
        elif nodeName_ == 'var':
            obj_ = var.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'var', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_var'):
              self.add_var(obj_.value)
            elif hasattr(self, 'set_var'):
              self.set_var(obj_.value)
        elif nodeName_ == 'cite':
            obj_ = cite.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'cite', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_cite'):
              self.add_cite(obj_.value)
            elif hasattr(self, 'set_cite'):
              self.set_cite(obj_.value)
        elif nodeName_ == 'abbr':
            obj_ = abbr.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'abbr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_abbr'):
              self.add_abbr(obj_.value)
            elif hasattr(self, 'set_abbr'):
              self.set_abbr(obj_.value)
        elif nodeName_ == 'acronym':
            obj_ = acronym.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'acronym', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_acronym'):
              self.add_acronym(obj_.value)
            elif hasattr(self, 'set_acronym'):
              self.set_acronym(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = sub.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = sup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class Inline


class Block(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, p: List_['p'] = None, h1: List_['h1'] = None, h2: List_['h2'] = None, h3: List_['h3'] = None, h4: List_['h4'] = None, h5: List_['h5'] = None, h6: List_['h6'] = None, div: List_['div'] = None, ul: List_['ul'] = None, ol: List_['ol'] = None, dl: List_['dl'] = None, pre: List_['pre'] = None, hr: List_['hr'] = None, blockquote: List_['blockquote'] = None, address: List_['address'] = None, table: List_['table'] = None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if p is None:
            self.p = []
        else:
            self.p = p
        self.p_nsprefix_ = None
        if h1 is None:
            self.h1 = []
        else:
            self.h1 = h1
        self.h1_nsprefix_ = None
        if h2 is None:
            self.h2 = []
        else:
            self.h2 = h2
        self.h2_nsprefix_ = None
        if h3 is None:
            self.h3 = []
        else:
            self.h3 = h3
        self.h3_nsprefix_ = None
        if h4 is None:
            self.h4 = []
        else:
            self.h4 = h4
        self.h4_nsprefix_ = None
        if h5 is None:
            self.h5 = []
        else:
            self.h5 = h5
        self.h5_nsprefix_ = None
        if h6 is None:
            self.h6 = []
        else:
            self.h6 = h6
        self.h6_nsprefix_ = None
        if div is None:
            self.div = []
        else:
            self.div = div
        self.div_nsprefix_ = None
        if ul is None:
            self.ul = []
        else:
            self.ul = ul
        self.ul_nsprefix_ = None
        if ol is None:
            self.ol = []
        else:
            self.ol = ol
        self.ol_nsprefix_ = None
        if dl is None:
            self.dl = []
        else:
            self.dl = dl
        self.dl_nsprefix_ = None
        if pre is None:
            self.pre = []
        else:
            self.pre = pre
        self.pre_nsprefix_ = None
        if hr is None:
            self.hr = []
        else:
            self.hr = hr
        self.hr_nsprefix_ = None
        if blockquote is None:
            self.blockquote = []
        else:
            self.blockquote = blockquote
        self.blockquote_nsprefix_ = None
        if address is None:
            self.address = []
        else:
            self.address = address
        self.address_nsprefix_ = None
        if table is None:
            self.table = []
        else:
            self.table = table
        self.table_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Block)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Block.subclass:
            return Block.subclass(*args_, **kwargs_)
        else:
            return Block(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_p(self):
        return self.p
    def set_p(self, p):
        self.p = p
    def add_p(self, value):
        self.p.append(value)
    def insert_p_at(self, index, value):
        self.p.insert(index, value)
    def replace_p_at(self, index, value):
        self.p[index] = value
    def get_h1(self):
        return self.h1
    def set_h1(self, h1):
        self.h1 = h1
    def add_h1(self, value):
        self.h1.append(value)
    def insert_h1_at(self, index, value):
        self.h1.insert(index, value)
    def replace_h1_at(self, index, value):
        self.h1[index] = value
    def get_h2(self):
        return self.h2
    def set_h2(self, h2):
        self.h2 = h2
    def add_h2(self, value):
        self.h2.append(value)
    def insert_h2_at(self, index, value):
        self.h2.insert(index, value)
    def replace_h2_at(self, index, value):
        self.h2[index] = value
    def get_h3(self):
        return self.h3
    def set_h3(self, h3):
        self.h3 = h3
    def add_h3(self, value):
        self.h3.append(value)
    def insert_h3_at(self, index, value):
        self.h3.insert(index, value)
    def replace_h3_at(self, index, value):
        self.h3[index] = value
    def get_h4(self):
        return self.h4
    def set_h4(self, h4):
        self.h4 = h4
    def add_h4(self, value):
        self.h4.append(value)
    def insert_h4_at(self, index, value):
        self.h4.insert(index, value)
    def replace_h4_at(self, index, value):
        self.h4[index] = value
    def get_h5(self):
        return self.h5
    def set_h5(self, h5):
        self.h5 = h5
    def add_h5(self, value):
        self.h5.append(value)
    def insert_h5_at(self, index, value):
        self.h5.insert(index, value)
    def replace_h5_at(self, index, value):
        self.h5[index] = value
    def get_h6(self):
        return self.h6
    def set_h6(self, h6):
        self.h6 = h6
    def add_h6(self, value):
        self.h6.append(value)
    def insert_h6_at(self, index, value):
        self.h6.insert(index, value)
    def replace_h6_at(self, index, value):
        self.h6[index] = value
    def get_div(self):
        return self.div
    def set_div(self, div):
        self.div = div
    def add_div(self, value):
        self.div.append(value)
    def insert_div_at(self, index, value):
        self.div.insert(index, value)
    def replace_div_at(self, index, value):
        self.div[index] = value
    def get_ul(self):
        return self.ul
    def set_ul(self, ul):
        self.ul = ul
    def add_ul(self, value):
        self.ul.append(value)
    def insert_ul_at(self, index, value):
        self.ul.insert(index, value)
    def replace_ul_at(self, index, value):
        self.ul[index] = value
    def get_ol(self):
        return self.ol
    def set_ol(self, ol):
        self.ol = ol
    def add_ol(self, value):
        self.ol.append(value)
    def insert_ol_at(self, index, value):
        self.ol.insert(index, value)
    def replace_ol_at(self, index, value):
        self.ol[index] = value
    def get_dl(self):
        return self.dl
    def set_dl(self, dl):
        self.dl = dl
    def add_dl(self, value):
        self.dl.append(value)
    def insert_dl_at(self, index, value):
        self.dl.insert(index, value)
    def replace_dl_at(self, index, value):
        self.dl[index] = value
    def get_pre(self):
        return self.pre
    def set_pre(self, pre):
        self.pre = pre
    def add_pre(self, value):
        self.pre.append(value)
    def insert_pre_at(self, index, value):
        self.pre.insert(index, value)
    def replace_pre_at(self, index, value):
        self.pre[index] = value
    def get_hr(self):
        return self.hr
    def set_hr(self, hr):
        self.hr = hr
    def add_hr(self, value):
        self.hr.append(value)
    def insert_hr_at(self, index, value):
        self.hr.insert(index, value)
    def replace_hr_at(self, index, value):
        self.hr[index] = value
    def get_blockquote(self):
        return self.blockquote
    def set_blockquote(self, blockquote):
        self.blockquote = blockquote
    def add_blockquote(self, value):
        self.blockquote.append(value)
    def insert_blockquote_at(self, index, value):
        self.blockquote.insert(index, value)
    def replace_blockquote_at(self, index, value):
        self.blockquote[index] = value
    def get_address(self):
        return self.address
    def set_address(self, address):
        self.address = address
    def add_address(self, value):
        self.address.append(value)
    def insert_address_at(self, index, value):
        self.address.insert(index, value)
    def replace_address_at(self, index, value):
        self.address[index] = value
    def get_table(self):
        return self.table
    def set_table(self, table):
        self.table = table
    def add_table(self, value):
        self.table.append(value)
    def insert_table_at(self, index, value):
        self.table.insert(index, value)
    def replace_table_at(self, index, value):
        self.table[index] = value
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.p or
            self.h1 or
            self.h2 or
            self.h3 or
            self.h4 or
            self.h5 or
            self.h6 or
            self.div or
            self.ul or
            self.ol or
            self.dl or
            self.pre or
            self.hr or
            self.blockquote or
            self.address or
            self.table
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='Block', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Block')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Block':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Block')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Block', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Block'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='Block', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for p_ in self.p:
            namespaceprefix_ = self.p_nsprefix_ + ':' if (UseCapturedNS_ and self.p_nsprefix_) else ''
            p_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='p', pretty_print=pretty_print)
        for h1_ in self.h1:
            namespaceprefix_ = self.h1_nsprefix_ + ':' if (UseCapturedNS_ and self.h1_nsprefix_) else ''
            h1_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h1', pretty_print=pretty_print)
        for h2_ in self.h2:
            namespaceprefix_ = self.h2_nsprefix_ + ':' if (UseCapturedNS_ and self.h2_nsprefix_) else ''
            h2_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h2', pretty_print=pretty_print)
        for h3_ in self.h3:
            namespaceprefix_ = self.h3_nsprefix_ + ':' if (UseCapturedNS_ and self.h3_nsprefix_) else ''
            h3_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h3', pretty_print=pretty_print)
        for h4_ in self.h4:
            namespaceprefix_ = self.h4_nsprefix_ + ':' if (UseCapturedNS_ and self.h4_nsprefix_) else ''
            h4_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h4', pretty_print=pretty_print)
        for h5_ in self.h5:
            namespaceprefix_ = self.h5_nsprefix_ + ':' if (UseCapturedNS_ and self.h5_nsprefix_) else ''
            h5_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h5', pretty_print=pretty_print)
        for h6_ in self.h6:
            namespaceprefix_ = self.h6_nsprefix_ + ':' if (UseCapturedNS_ and self.h6_nsprefix_) else ''
            h6_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h6', pretty_print=pretty_print)
        for div_ in self.div:
            namespaceprefix_ = self.div_nsprefix_ + ':' if (UseCapturedNS_ and self.div_nsprefix_) else ''
            div_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='div', pretty_print=pretty_print)
        for ul_ in self.ul:
            namespaceprefix_ = self.ul_nsprefix_ + ':' if (UseCapturedNS_ and self.ul_nsprefix_) else ''
            ul_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ul', pretty_print=pretty_print)
        for ol_ in self.ol:
            namespaceprefix_ = self.ol_nsprefix_ + ':' if (UseCapturedNS_ and self.ol_nsprefix_) else ''
            ol_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ol', pretty_print=pretty_print)
        for dl_ in self.dl:
            namespaceprefix_ = self.dl_nsprefix_ + ':' if (UseCapturedNS_ and self.dl_nsprefix_) else ''
            dl_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dl', pretty_print=pretty_print)
        for pre_ in self.pre:
            namespaceprefix_ = self.pre_nsprefix_ + ':' if (UseCapturedNS_ and self.pre_nsprefix_) else ''
            pre_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pre', pretty_print=pretty_print)
        for hr_ in self.hr:
            namespaceprefix_ = self.hr_nsprefix_ + ':' if (UseCapturedNS_ and self.hr_nsprefix_) else ''
            hr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='hr', pretty_print=pretty_print)
        for blockquote_ in self.blockquote:
            namespaceprefix_ = self.blockquote_nsprefix_ + ':' if (UseCapturedNS_ and self.blockquote_nsprefix_) else ''
            blockquote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='blockquote', pretty_print=pretty_print)
        for address_ in self.address:
            namespaceprefix_ = self.address_nsprefix_ + ':' if (UseCapturedNS_ and self.address_nsprefix_) else ''
            address_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='address', pretty_print=pretty_print)
        for table_ in self.table:
            namespaceprefix_ = self.table_nsprefix_ + ':' if (UseCapturedNS_ and self.table_nsprefix_) else ''
            table_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='table', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.p:
            child_dict = child.exportJson(json_dict, 'p', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['p'] = child_list
        child_list = []
        for child in self.h1:
            child_dict = child.exportJson(json_dict, 'h1', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h1'] = child_list
        child_list = []
        for child in self.h2:
            child_dict = child.exportJson(json_dict, 'h2', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h2'] = child_list
        child_list = []
        for child in self.h3:
            child_dict = child.exportJson(json_dict, 'h3', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h3'] = child_list
        child_list = []
        for child in self.h4:
            child_dict = child.exportJson(json_dict, 'h4', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h4'] = child_list
        child_list = []
        for child in self.h5:
            child_dict = child.exportJson(json_dict, 'h5', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h5'] = child_list
        child_list = []
        for child in self.h6:
            child_dict = child.exportJson(json_dict, 'h6', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h6'] = child_list
        child_list = []
        for child in self.div:
            child_dict = child.exportJson(json_dict, 'div', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['div'] = child_list
        child_list = []
        for child in self.ul:
            child_dict = child.exportJson(json_dict, 'ul', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['ul'] = child_list
        child_list = []
        for child in self.ol:
            child_dict = child.exportJson(json_dict, 'ol', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['ol'] = child_list
        child_list = []
        for child in self.dl:
            child_dict = child.exportJson(json_dict, 'dl', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dl'] = child_list
        child_list = []
        for child in self.pre:
            child_dict = child.exportJson(json_dict, 'pre', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['pre'] = child_list
        child_list = []
        for child in self.hr:
            child_dict = child.exportJson(json_dict, 'hr', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['hr'] = child_list
        child_list = []
        for child in self.blockquote:
            child_dict = child.exportJson(json_dict, 'blockquote', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['blockquote'] = child_list
        child_list = []
        for child in self.address:
            child_dict = child.exportJson(json_dict, 'address', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['address'] = child_list
        child_list = []
        for child in self.table:
            child_dict = child.exportJson(json_dict, 'table', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['table'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'p':
            obj_ = p.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.p.append(obj_)
            obj_.original_tagname_ = 'p'
        elif nodeName_ == 'h1':
            obj_ = h1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.h1.append(obj_)
            obj_.original_tagname_ = 'h1'
        elif nodeName_ == 'h2':
            obj_ = h2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.h2.append(obj_)
            obj_.original_tagname_ = 'h2'
        elif nodeName_ == 'h3':
            obj_ = h3.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.h3.append(obj_)
            obj_.original_tagname_ = 'h3'
        elif nodeName_ == 'h4':
            obj_ = h4.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.h4.append(obj_)
            obj_.original_tagname_ = 'h4'
        elif nodeName_ == 'h5':
            obj_ = h5.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.h5.append(obj_)
            obj_.original_tagname_ = 'h5'
        elif nodeName_ == 'h6':
            obj_ = h6.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.h6.append(obj_)
            obj_.original_tagname_ = 'h6'
        elif nodeName_ == 'div':
            obj_ = div.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.div.append(obj_)
            obj_.original_tagname_ = 'div'
        elif nodeName_ == 'ul':
            obj_ = ul.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ul.append(obj_)
            obj_.original_tagname_ = 'ul'
        elif nodeName_ == 'ol':
            obj_ = ol.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ol.append(obj_)
            obj_.original_tagname_ = 'ol'
        elif nodeName_ == 'dl':
            obj_ = dl.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dl.append(obj_)
            obj_.original_tagname_ = 'dl'
        elif nodeName_ == 'pre':
            obj_ = pre.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pre.append(obj_)
            obj_.original_tagname_ = 'pre'
        elif nodeName_ == 'hr':
            obj_ = hr.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.hr.append(obj_)
            obj_.original_tagname_ = 'hr'
        elif nodeName_ == 'blockquote':
            obj_ = blockquote.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.blockquote.append(obj_)
            obj_.original_tagname_ = 'blockquote'
        elif nodeName_ == 'address':
            obj_ = address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.address.append(obj_)
            obj_.original_tagname_ = 'address'
        elif nodeName_ == 'table':
            obj_ = table.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.table.append(obj_)
            obj_.original_tagname_ = 'table'
# end class Block


class Flow(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, p: List_['p'] = None, h1: List_['h1'] = None, h2: List_['h2'] = None, h3: List_['h3'] = None, h4: List_['h4'] = None, h5: List_['h5'] = None, h6: List_['h6'] = None, div: List_['div'] = None, ul: List_['ul'] = None, ol: List_['ol'] = None, dl: List_['dl'] = None, pre: List_['pre'] = None, hr: List_['hr'] = None, blockquote: List_['blockquote'] = None, address: List_['address'] = None, table: List_['table'] = None, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if p is None:
            self.p = []
        else:
            self.p = p
        self.p_nsprefix_ = None
        if h1 is None:
            self.h1 = []
        else:
            self.h1 = h1
        self.h1_nsprefix_ = None
        if h2 is None:
            self.h2 = []
        else:
            self.h2 = h2
        self.h2_nsprefix_ = None
        if h3 is None:
            self.h3 = []
        else:
            self.h3 = h3
        self.h3_nsprefix_ = None
        if h4 is None:
            self.h4 = []
        else:
            self.h4 = h4
        self.h4_nsprefix_ = None
        if h5 is None:
            self.h5 = []
        else:
            self.h5 = h5
        self.h5_nsprefix_ = None
        if h6 is None:
            self.h6 = []
        else:
            self.h6 = h6
        self.h6_nsprefix_ = None
        if div is None:
            self.div = []
        else:
            self.div = div
        self.div_nsprefix_ = None
        if ul is None:
            self.ul = []
        else:
            self.ul = ul
        self.ul_nsprefix_ = None
        if ol is None:
            self.ol = []
        else:
            self.ol = ol
        self.ol_nsprefix_ = None
        if dl is None:
            self.dl = []
        else:
            self.dl = dl
        self.dl_nsprefix_ = None
        if pre is None:
            self.pre = []
        else:
            self.pre = pre
        self.pre_nsprefix_ = None
        if hr is None:
            self.hr = []
        else:
            self.hr = hr
        self.hr_nsprefix_ = None
        if blockquote is None:
            self.blockquote = []
        else:
            self.blockquote = blockquote
        self.blockquote_nsprefix_ = None
        if address is None:
            self.address = []
        else:
            self.address = address
        self.address_nsprefix_ = None
        if table is None:
            self.table = []
        else:
            self.table = table
        self.table_nsprefix_ = None
        if a is None:
            self.a = []
        else:
            self.a = a
        self.a_nsprefix_ = None
        if br is None:
            self.br = []
        else:
            self.br = br
        self.br_nsprefix_ = None
        if span is None:
            self.span = []
        else:
            self.span = span
        self.span_nsprefix_ = None
        if bdo is None:
            self.bdo = []
        else:
            self.bdo = bdo
        self.bdo_nsprefix_ = None
        if map is None:
            self.map = []
        else:
            self.map = map
        self.map_nsprefix_ = None
        if img is None:
            self.img = []
        else:
            self.img = img
        self.img_nsprefix_ = None
        if tt is None:
            self.tt = []
        else:
            self.tt = tt
        self.tt_nsprefix_ = None
        if i is None:
            self.i = []
        else:
            self.i = i
        self.i_nsprefix_ = None
        if b is None:
            self.b = []
        else:
            self.b = b
        self.b_nsprefix_ = None
        if big is None:
            self.big = []
        else:
            self.big = big
        self.big_nsprefix_ = None
        if small is None:
            self.small = []
        else:
            self.small = small
        self.small_nsprefix_ = None
        if em is None:
            self.em = []
        else:
            self.em = em
        self.em_nsprefix_ = None
        if strong is None:
            self.strong = []
        else:
            self.strong = strong
        self.strong_nsprefix_ = None
        if dfn is None:
            self.dfn = []
        else:
            self.dfn = dfn
        self.dfn_nsprefix_ = None
        if code is None:
            self.code = []
        else:
            self.code = code
        self.code_nsprefix_ = None
        if q is None:
            self.q = []
        else:
            self.q = q
        self.q_nsprefix_ = None
        if samp is None:
            self.samp = []
        else:
            self.samp = samp
        self.samp_nsprefix_ = None
        if kbd is None:
            self.kbd = []
        else:
            self.kbd = kbd
        self.kbd_nsprefix_ = None
        if var is None:
            self.var = []
        else:
            self.var = var
        self.var_nsprefix_ = None
        if cite is None:
            self.cite = []
        else:
            self.cite = cite
        self.cite_nsprefix_ = None
        if abbr is None:
            self.abbr = []
        else:
            self.abbr = abbr
        self.abbr_nsprefix_ = None
        if acronym is None:
            self.acronym = []
        else:
            self.acronym = acronym
        self.acronym_nsprefix_ = None
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        self.sub_nsprefix_ = None
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        self.sup_nsprefix_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Flow)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Flow.subclass:
            return Flow.subclass(*args_, **kwargs_)
        else:
            return Flow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_p(self):
        return self.p
    def set_p(self, p):
        self.p = p
    def add_p(self, value):
        self.p.append(value)
    def insert_p_at(self, index, value):
        self.p.insert(index, value)
    def replace_p_at(self, index, value):
        self.p[index] = value
    def get_h1(self):
        return self.h1
    def set_h1(self, h1):
        self.h1 = h1
    def add_h1(self, value):
        self.h1.append(value)
    def insert_h1_at(self, index, value):
        self.h1.insert(index, value)
    def replace_h1_at(self, index, value):
        self.h1[index] = value
    def get_h2(self):
        return self.h2
    def set_h2(self, h2):
        self.h2 = h2
    def add_h2(self, value):
        self.h2.append(value)
    def insert_h2_at(self, index, value):
        self.h2.insert(index, value)
    def replace_h2_at(self, index, value):
        self.h2[index] = value
    def get_h3(self):
        return self.h3
    def set_h3(self, h3):
        self.h3 = h3
    def add_h3(self, value):
        self.h3.append(value)
    def insert_h3_at(self, index, value):
        self.h3.insert(index, value)
    def replace_h3_at(self, index, value):
        self.h3[index] = value
    def get_h4(self):
        return self.h4
    def set_h4(self, h4):
        self.h4 = h4
    def add_h4(self, value):
        self.h4.append(value)
    def insert_h4_at(self, index, value):
        self.h4.insert(index, value)
    def replace_h4_at(self, index, value):
        self.h4[index] = value
    def get_h5(self):
        return self.h5
    def set_h5(self, h5):
        self.h5 = h5
    def add_h5(self, value):
        self.h5.append(value)
    def insert_h5_at(self, index, value):
        self.h5.insert(index, value)
    def replace_h5_at(self, index, value):
        self.h5[index] = value
    def get_h6(self):
        return self.h6
    def set_h6(self, h6):
        self.h6 = h6
    def add_h6(self, value):
        self.h6.append(value)
    def insert_h6_at(self, index, value):
        self.h6.insert(index, value)
    def replace_h6_at(self, index, value):
        self.h6[index] = value
    def get_div(self):
        return self.div
    def set_div(self, div):
        self.div = div
    def add_div(self, value):
        self.div.append(value)
    def insert_div_at(self, index, value):
        self.div.insert(index, value)
    def replace_div_at(self, index, value):
        self.div[index] = value
    def get_ul(self):
        return self.ul
    def set_ul(self, ul):
        self.ul = ul
    def add_ul(self, value):
        self.ul.append(value)
    def insert_ul_at(self, index, value):
        self.ul.insert(index, value)
    def replace_ul_at(self, index, value):
        self.ul[index] = value
    def get_ol(self):
        return self.ol
    def set_ol(self, ol):
        self.ol = ol
    def add_ol(self, value):
        self.ol.append(value)
    def insert_ol_at(self, index, value):
        self.ol.insert(index, value)
    def replace_ol_at(self, index, value):
        self.ol[index] = value
    def get_dl(self):
        return self.dl
    def set_dl(self, dl):
        self.dl = dl
    def add_dl(self, value):
        self.dl.append(value)
    def insert_dl_at(self, index, value):
        self.dl.insert(index, value)
    def replace_dl_at(self, index, value):
        self.dl[index] = value
    def get_pre(self):
        return self.pre
    def set_pre(self, pre):
        self.pre = pre
    def add_pre(self, value):
        self.pre.append(value)
    def insert_pre_at(self, index, value):
        self.pre.insert(index, value)
    def replace_pre_at(self, index, value):
        self.pre[index] = value
    def get_hr(self):
        return self.hr
    def set_hr(self, hr):
        self.hr = hr
    def add_hr(self, value):
        self.hr.append(value)
    def insert_hr_at(self, index, value):
        self.hr.insert(index, value)
    def replace_hr_at(self, index, value):
        self.hr[index] = value
    def get_blockquote(self):
        return self.blockquote
    def set_blockquote(self, blockquote):
        self.blockquote = blockquote
    def add_blockquote(self, value):
        self.blockquote.append(value)
    def insert_blockquote_at(self, index, value):
        self.blockquote.insert(index, value)
    def replace_blockquote_at(self, index, value):
        self.blockquote[index] = value
    def get_address(self):
        return self.address
    def set_address(self, address):
        self.address = address
    def add_address(self, value):
        self.address.append(value)
    def insert_address_at(self, index, value):
        self.address.insert(index, value)
    def replace_address_at(self, index, value):
        self.address[index] = value
    def get_table(self):
        return self.table
    def set_table(self, table):
        self.table = table
    def add_table(self, value):
        self.table.append(value)
    def insert_table_at(self, index, value):
        self.table.insert(index, value)
    def replace_table_at(self, index, value):
        self.table[index] = value
    def get_a(self):
        return self.a
    def set_a(self, a):
        self.a = a
    def add_a(self, value):
        self.a.append(value)
    def insert_a_at(self, index, value):
        self.a.insert(index, value)
    def replace_a_at(self, index, value):
        self.a[index] = value
    def get_br(self):
        return self.br
    def set_br(self, br):
        self.br = br
    def add_br(self, value):
        self.br.append(value)
    def insert_br_at(self, index, value):
        self.br.insert(index, value)
    def replace_br_at(self, index, value):
        self.br[index] = value
    def get_span(self):
        return self.span
    def set_span(self, span):
        self.span = span
    def add_span(self, value):
        self.span.append(value)
    def insert_span_at(self, index, value):
        self.span.insert(index, value)
    def replace_span_at(self, index, value):
        self.span[index] = value
    def get_bdo(self):
        return self.bdo
    def set_bdo(self, bdo):
        self.bdo = bdo
    def add_bdo(self, value):
        self.bdo.append(value)
    def insert_bdo_at(self, index, value):
        self.bdo.insert(index, value)
    def replace_bdo_at(self, index, value):
        self.bdo[index] = value
    def get_map(self):
        return self.map
    def set_map(self, map):
        self.map = map
    def add_map(self, value):
        self.map.append(value)
    def insert_map_at(self, index, value):
        self.map.insert(index, value)
    def replace_map_at(self, index, value):
        self.map[index] = value
    def get_img(self):
        return self.img
    def set_img(self, img):
        self.img = img
    def add_img(self, value):
        self.img.append(value)
    def insert_img_at(self, index, value):
        self.img.insert(index, value)
    def replace_img_at(self, index, value):
        self.img[index] = value
    def get_tt(self):
        return self.tt
    def set_tt(self, tt):
        self.tt = tt
    def add_tt(self, value):
        self.tt.append(value)
    def insert_tt_at(self, index, value):
        self.tt.insert(index, value)
    def replace_tt_at(self, index, value):
        self.tt[index] = value
    def get_i(self):
        return self.i
    def set_i(self, i):
        self.i = i
    def add_i(self, value):
        self.i.append(value)
    def insert_i_at(self, index, value):
        self.i.insert(index, value)
    def replace_i_at(self, index, value):
        self.i[index] = value
    def get_b(self):
        return self.b
    def set_b(self, b):
        self.b = b
    def add_b(self, value):
        self.b.append(value)
    def insert_b_at(self, index, value):
        self.b.insert(index, value)
    def replace_b_at(self, index, value):
        self.b[index] = value
    def get_big(self):
        return self.big
    def set_big(self, big):
        self.big = big
    def add_big(self, value):
        self.big.append(value)
    def insert_big_at(self, index, value):
        self.big.insert(index, value)
    def replace_big_at(self, index, value):
        self.big[index] = value
    def get_small(self):
        return self.small
    def set_small(self, small):
        self.small = small
    def add_small(self, value):
        self.small.append(value)
    def insert_small_at(self, index, value):
        self.small.insert(index, value)
    def replace_small_at(self, index, value):
        self.small[index] = value
    def get_em(self):
        return self.em
    def set_em(self, em):
        self.em = em
    def add_em(self, value):
        self.em.append(value)
    def insert_em_at(self, index, value):
        self.em.insert(index, value)
    def replace_em_at(self, index, value):
        self.em[index] = value
    def get_strong(self):
        return self.strong
    def set_strong(self, strong):
        self.strong = strong
    def add_strong(self, value):
        self.strong.append(value)
    def insert_strong_at(self, index, value):
        self.strong.insert(index, value)
    def replace_strong_at(self, index, value):
        self.strong[index] = value
    def get_dfn(self):
        return self.dfn
    def set_dfn(self, dfn):
        self.dfn = dfn
    def add_dfn(self, value):
        self.dfn.append(value)
    def insert_dfn_at(self, index, value):
        self.dfn.insert(index, value)
    def replace_dfn_at(self, index, value):
        self.dfn[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def add_code(self, value):
        self.code.append(value)
    def insert_code_at(self, index, value):
        self.code.insert(index, value)
    def replace_code_at(self, index, value):
        self.code[index] = value
    def get_q(self):
        return self.q
    def set_q(self, q):
        self.q = q
    def add_q(self, value):
        self.q.append(value)
    def insert_q_at(self, index, value):
        self.q.insert(index, value)
    def replace_q_at(self, index, value):
        self.q[index] = value
    def get_samp(self):
        return self.samp
    def set_samp(self, samp):
        self.samp = samp
    def add_samp(self, value):
        self.samp.append(value)
    def insert_samp_at(self, index, value):
        self.samp.insert(index, value)
    def replace_samp_at(self, index, value):
        self.samp[index] = value
    def get_kbd(self):
        return self.kbd
    def set_kbd(self, kbd):
        self.kbd = kbd
    def add_kbd(self, value):
        self.kbd.append(value)
    def insert_kbd_at(self, index, value):
        self.kbd.insert(index, value)
    def replace_kbd_at(self, index, value):
        self.kbd[index] = value
    def get_var(self):
        return self.var
    def set_var(self, var):
        self.var = var
    def add_var(self, value):
        self.var.append(value)
    def insert_var_at(self, index, value):
        self.var.insert(index, value)
    def replace_var_at(self, index, value):
        self.var[index] = value
    def get_cite(self):
        return self.cite
    def set_cite(self, cite):
        self.cite = cite
    def add_cite(self, value):
        self.cite.append(value)
    def insert_cite_at(self, index, value):
        self.cite.insert(index, value)
    def replace_cite_at(self, index, value):
        self.cite[index] = value
    def get_abbr(self):
        return self.abbr
    def set_abbr(self, abbr):
        self.abbr = abbr
    def add_abbr(self, value):
        self.abbr.append(value)
    def insert_abbr_at(self, index, value):
        self.abbr.insert(index, value)
    def replace_abbr_at(self, index, value):
        self.abbr[index] = value
    def get_acronym(self):
        return self.acronym
    def set_acronym(self, acronym):
        self.acronym = acronym
    def add_acronym(self, value):
        self.acronym.append(value)
    def insert_acronym_at(self, index, value):
        self.acronym.insert(index, value)
    def replace_acronym_at(self, index, value):
        self.acronym[index] = value
    def get_sub(self):
        return self.sub
    def set_sub(self, sub):
        self.sub = sub
    def add_sub(self, value):
        self.sub.append(value)
    def insert_sub_at(self, index, value):
        self.sub.insert(index, value)
    def replace_sub_at(self, index, value):
        self.sub[index] = value
    def get_sup(self):
        return self.sup
    def set_sup(self, sup):
        self.sup = sup
    def add_sup(self, value):
        self.sup.append(value)
    def insert_sup_at(self, index, value):
        self.sup.insert(index, value)
    def replace_sup_at(self, index, value):
        self.sup[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.p or
            self.h1 or
            self.h2 or
            self.h3 or
            self.h4 or
            self.h5 or
            self.h6 or
            self.div or
            self.ul or
            self.ol or
            self.dl or
            self.pre or
            self.hr or
            self.blockquote or
            self.address or
            self.table or
            self.a or
            self.br or
            self.span or
            self.bdo or
            self.map or
            self.img or
            self.tt or
            self.i or
            self.b or
            self.big or
            self.small or
            self.em or
            self.strong or
            self.dfn or
            self.code or
            self.q or
            self.samp or
            self.kbd or
            self.var or
            self.cite or
            self.abbr or
            self.acronym or
            self.sub or
            self.sup or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='Flow', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Flow')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Flow':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Flow')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Flow'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='Flow', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for p_ in self.p:
            namespaceprefix_ = self.p_nsprefix_ + ':' if (UseCapturedNS_ and self.p_nsprefix_) else ''
            p_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='p', pretty_print=pretty_print)
        for h1_ in self.h1:
            namespaceprefix_ = self.h1_nsprefix_ + ':' if (UseCapturedNS_ and self.h1_nsprefix_) else ''
            h1_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h1', pretty_print=pretty_print)
        for h2_ in self.h2:
            namespaceprefix_ = self.h2_nsprefix_ + ':' if (UseCapturedNS_ and self.h2_nsprefix_) else ''
            h2_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h2', pretty_print=pretty_print)
        for h3_ in self.h3:
            namespaceprefix_ = self.h3_nsprefix_ + ':' if (UseCapturedNS_ and self.h3_nsprefix_) else ''
            h3_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h3', pretty_print=pretty_print)
        for h4_ in self.h4:
            namespaceprefix_ = self.h4_nsprefix_ + ':' if (UseCapturedNS_ and self.h4_nsprefix_) else ''
            h4_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h4', pretty_print=pretty_print)
        for h5_ in self.h5:
            namespaceprefix_ = self.h5_nsprefix_ + ':' if (UseCapturedNS_ and self.h5_nsprefix_) else ''
            h5_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h5', pretty_print=pretty_print)
        for h6_ in self.h6:
            namespaceprefix_ = self.h6_nsprefix_ + ':' if (UseCapturedNS_ and self.h6_nsprefix_) else ''
            h6_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='h6', pretty_print=pretty_print)
        for div_ in self.div:
            namespaceprefix_ = self.div_nsprefix_ + ':' if (UseCapturedNS_ and self.div_nsprefix_) else ''
            div_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='div', pretty_print=pretty_print)
        for ul_ in self.ul:
            namespaceprefix_ = self.ul_nsprefix_ + ':' if (UseCapturedNS_ and self.ul_nsprefix_) else ''
            ul_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ul', pretty_print=pretty_print)
        for ol_ in self.ol:
            namespaceprefix_ = self.ol_nsprefix_ + ':' if (UseCapturedNS_ and self.ol_nsprefix_) else ''
            ol_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ol', pretty_print=pretty_print)
        for dl_ in self.dl:
            namespaceprefix_ = self.dl_nsprefix_ + ':' if (UseCapturedNS_ and self.dl_nsprefix_) else ''
            dl_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dl', pretty_print=pretty_print)
        for pre_ in self.pre:
            namespaceprefix_ = self.pre_nsprefix_ + ':' if (UseCapturedNS_ and self.pre_nsprefix_) else ''
            pre_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pre', pretty_print=pretty_print)
        for hr_ in self.hr:
            namespaceprefix_ = self.hr_nsprefix_ + ':' if (UseCapturedNS_ and self.hr_nsprefix_) else ''
            hr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='hr', pretty_print=pretty_print)
        for blockquote_ in self.blockquote:
            namespaceprefix_ = self.blockquote_nsprefix_ + ':' if (UseCapturedNS_ and self.blockquote_nsprefix_) else ''
            blockquote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='blockquote', pretty_print=pretty_print)
        for address_ in self.address:
            namespaceprefix_ = self.address_nsprefix_ + ':' if (UseCapturedNS_ and self.address_nsprefix_) else ''
            address_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='address', pretty_print=pretty_print)
        for table_ in self.table:
            namespaceprefix_ = self.table_nsprefix_ + ':' if (UseCapturedNS_ and self.table_nsprefix_) else ''
            table_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='table', pretty_print=pretty_print)
        for a_ in self.a:
            namespaceprefix_ = self.a_nsprefix_ + ':' if (UseCapturedNS_ and self.a_nsprefix_) else ''
            a_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='a', pretty_print=pretty_print)
        for br_ in self.br:
            namespaceprefix_ = self.br_nsprefix_ + ':' if (UseCapturedNS_ and self.br_nsprefix_) else ''
            br_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='br', pretty_print=pretty_print)
        for span_ in self.span:
            namespaceprefix_ = self.span_nsprefix_ + ':' if (UseCapturedNS_ and self.span_nsprefix_) else ''
            span_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='span', pretty_print=pretty_print)
        for bdo_ in self.bdo:
            namespaceprefix_ = self.bdo_nsprefix_ + ':' if (UseCapturedNS_ and self.bdo_nsprefix_) else ''
            bdo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bdo', pretty_print=pretty_print)
        for map_ in self.map:
            namespaceprefix_ = self.map_nsprefix_ + ':' if (UseCapturedNS_ and self.map_nsprefix_) else ''
            map_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='map', pretty_print=pretty_print)
        for img_ in self.img:
            namespaceprefix_ = self.img_nsprefix_ + ':' if (UseCapturedNS_ and self.img_nsprefix_) else ''
            img_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='img', pretty_print=pretty_print)
        for tt_ in self.tt:
            namespaceprefix_ = self.tt_nsprefix_ + ':' if (UseCapturedNS_ and self.tt_nsprefix_) else ''
            tt_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tt', pretty_print=pretty_print)
        for i_ in self.i:
            namespaceprefix_ = self.i_nsprefix_ + ':' if (UseCapturedNS_ and self.i_nsprefix_) else ''
            i_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='i', pretty_print=pretty_print)
        for b_ in self.b:
            namespaceprefix_ = self.b_nsprefix_ + ':' if (UseCapturedNS_ and self.b_nsprefix_) else ''
            b_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='b', pretty_print=pretty_print)
        for big_ in self.big:
            namespaceprefix_ = self.big_nsprefix_ + ':' if (UseCapturedNS_ and self.big_nsprefix_) else ''
            big_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='big', pretty_print=pretty_print)
        for small_ in self.small:
            namespaceprefix_ = self.small_nsprefix_ + ':' if (UseCapturedNS_ and self.small_nsprefix_) else ''
            small_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='small', pretty_print=pretty_print)
        for em_ in self.em:
            namespaceprefix_ = self.em_nsprefix_ + ':' if (UseCapturedNS_ and self.em_nsprefix_) else ''
            em_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='em', pretty_print=pretty_print)
        for strong_ in self.strong:
            namespaceprefix_ = self.strong_nsprefix_ + ':' if (UseCapturedNS_ and self.strong_nsprefix_) else ''
            strong_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='strong', pretty_print=pretty_print)
        for dfn_ in self.dfn:
            namespaceprefix_ = self.dfn_nsprefix_ + ':' if (UseCapturedNS_ and self.dfn_nsprefix_) else ''
            dfn_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dfn', pretty_print=pretty_print)
        for code_ in self.code:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            code_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for q_ in self.q:
            namespaceprefix_ = self.q_nsprefix_ + ':' if (UseCapturedNS_ and self.q_nsprefix_) else ''
            q_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='q', pretty_print=pretty_print)
        for samp_ in self.samp:
            namespaceprefix_ = self.samp_nsprefix_ + ':' if (UseCapturedNS_ and self.samp_nsprefix_) else ''
            samp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='samp', pretty_print=pretty_print)
        for kbd_ in self.kbd:
            namespaceprefix_ = self.kbd_nsprefix_ + ':' if (UseCapturedNS_ and self.kbd_nsprefix_) else ''
            kbd_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='kbd', pretty_print=pretty_print)
        for var_ in self.var:
            namespaceprefix_ = self.var_nsprefix_ + ':' if (UseCapturedNS_ and self.var_nsprefix_) else ''
            var_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='var', pretty_print=pretty_print)
        for cite_ in self.cite:
            namespaceprefix_ = self.cite_nsprefix_ + ':' if (UseCapturedNS_ and self.cite_nsprefix_) else ''
            cite_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cite', pretty_print=pretty_print)
        for abbr_ in self.abbr:
            namespaceprefix_ = self.abbr_nsprefix_ + ':' if (UseCapturedNS_ and self.abbr_nsprefix_) else ''
            abbr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abbr', pretty_print=pretty_print)
        for acronym_ in self.acronym:
            namespaceprefix_ = self.acronym_nsprefix_ + ':' if (UseCapturedNS_ and self.acronym_nsprefix_) else ''
            acronym_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acronym', pretty_print=pretty_print)
        for sub_ in self.sub:
            namespaceprefix_ = self.sub_nsprefix_ + ':' if (UseCapturedNS_ and self.sub_nsprefix_) else ''
            sub_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sub', pretty_print=pretty_print)
        for sup_ in self.sup:
            namespaceprefix_ = self.sup_nsprefix_ + ':' if (UseCapturedNS_ and self.sup_nsprefix_) else ''
            sup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sup', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.p:
            child_dict = child.exportJson(json_dict, 'p', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['p'] = child_list
        child_list = []
        for child in self.h1:
            child_dict = child.exportJson(json_dict, 'h1', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h1'] = child_list
        child_list = []
        for child in self.h2:
            child_dict = child.exportJson(json_dict, 'h2', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h2'] = child_list
        child_list = []
        for child in self.h3:
            child_dict = child.exportJson(json_dict, 'h3', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h3'] = child_list
        child_list = []
        for child in self.h4:
            child_dict = child.exportJson(json_dict, 'h4', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h4'] = child_list
        child_list = []
        for child in self.h5:
            child_dict = child.exportJson(json_dict, 'h5', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h5'] = child_list
        child_list = []
        for child in self.h6:
            child_dict = child.exportJson(json_dict, 'h6', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['h6'] = child_list
        child_list = []
        for child in self.div:
            child_dict = child.exportJson(json_dict, 'div', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['div'] = child_list
        child_list = []
        for child in self.ul:
            child_dict = child.exportJson(json_dict, 'ul', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['ul'] = child_list
        child_list = []
        for child in self.ol:
            child_dict = child.exportJson(json_dict, 'ol', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['ol'] = child_list
        child_list = []
        for child in self.dl:
            child_dict = child.exportJson(json_dict, 'dl', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dl'] = child_list
        child_list = []
        for child in self.pre:
            child_dict = child.exportJson(json_dict, 'pre', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['pre'] = child_list
        child_list = []
        for child in self.hr:
            child_dict = child.exportJson(json_dict, 'hr', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['hr'] = child_list
        child_list = []
        for child in self.blockquote:
            child_dict = child.exportJson(json_dict, 'blockquote', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['blockquote'] = child_list
        child_list = []
        for child in self.address:
            child_dict = child.exportJson(json_dict, 'address', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['address'] = child_list
        child_list = []
        for child in self.table:
            child_dict = child.exportJson(json_dict, 'table', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['table'] = child_list
        child_list = []
        for child in self.a:
            child_dict = child.exportJson(json_dict, 'a', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['a'] = child_list
        child_list = []
        for child in self.br:
            child_dict = child.exportJson(json_dict, 'br', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['br'] = child_list
        child_list = []
        for child in self.span:
            child_dict = child.exportJson(json_dict, 'span', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['span'] = child_list
        child_list = []
        for child in self.bdo:
            child_dict = child.exportJson(json_dict, 'bdo', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['bdo'] = child_list
        child_list = []
        for child in self.map:
            child_dict = child.exportJson(json_dict, 'map', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['map'] = child_list
        child_list = []
        for child in self.img:
            child_dict = child.exportJson(json_dict, 'img', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['img'] = child_list
        child_list = []
        for child in self.tt:
            child_dict = child.exportJson(json_dict, 'tt', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['tt'] = child_list
        child_list = []
        for child in self.i:
            child_dict = child.exportJson(json_dict, 'i', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['i'] = child_list
        child_list = []
        for child in self.b:
            child_dict = child.exportJson(json_dict, 'b', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['b'] = child_list
        child_list = []
        for child in self.big:
            child_dict = child.exportJson(json_dict, 'big', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['big'] = child_list
        child_list = []
        for child in self.small:
            child_dict = child.exportJson(json_dict, 'small', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['small'] = child_list
        child_list = []
        for child in self.em:
            child_dict = child.exportJson(json_dict, 'em', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['em'] = child_list
        child_list = []
        for child in self.strong:
            child_dict = child.exportJson(json_dict, 'strong', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['strong'] = child_list
        child_list = []
        for child in self.dfn:
            child_dict = child.exportJson(json_dict, 'dfn', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dfn'] = child_list
        child_list = []
        for child in self.code:
            child_dict = child.exportJson(json_dict, 'code', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['code'] = child_list
        child_list = []
        for child in self.q:
            child_dict = child.exportJson(json_dict, 'q', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['q'] = child_list
        child_list = []
        for child in self.samp:
            child_dict = child.exportJson(json_dict, 'samp', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['samp'] = child_list
        child_list = []
        for child in self.kbd:
            child_dict = child.exportJson(json_dict, 'kbd', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['kbd'] = child_list
        child_list = []
        for child in self.var:
            child_dict = child.exportJson(json_dict, 'var', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['var'] = child_list
        child_list = []
        for child in self.cite:
            child_dict = child.exportJson(json_dict, 'cite', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['cite'] = child_list
        child_list = []
        for child in self.abbr:
            child_dict = child.exportJson(json_dict, 'abbr', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['abbr'] = child_list
        child_list = []
        for child in self.acronym:
            child_dict = child.exportJson(json_dict, 'acronym', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['acronym'] = child_list
        child_list = []
        for child in self.sub:
            child_dict = child.exportJson(json_dict, 'sub', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sub'] = child_list
        child_list = []
        for child in self.sup:
            child_dict = child.exportJson(json_dict, 'sup', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sup'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'p':
            obj_ = p.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'p', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_p'):
              self.add_p(obj_.value)
            elif hasattr(self, 'set_p'):
              self.set_p(obj_.value)
        elif nodeName_ == 'h1':
            obj_ = h1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'h1', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_h1'):
              self.add_h1(obj_.value)
            elif hasattr(self, 'set_h1'):
              self.set_h1(obj_.value)
        elif nodeName_ == 'h2':
            obj_ = h2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'h2', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_h2'):
              self.add_h2(obj_.value)
            elif hasattr(self, 'set_h2'):
              self.set_h2(obj_.value)
        elif nodeName_ == 'h3':
            obj_ = h3.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'h3', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_h3'):
              self.add_h3(obj_.value)
            elif hasattr(self, 'set_h3'):
              self.set_h3(obj_.value)
        elif nodeName_ == 'h4':
            obj_ = h4.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'h4', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_h4'):
              self.add_h4(obj_.value)
            elif hasattr(self, 'set_h4'):
              self.set_h4(obj_.value)
        elif nodeName_ == 'h5':
            obj_ = h5.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'h5', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_h5'):
              self.add_h5(obj_.value)
            elif hasattr(self, 'set_h5'):
              self.set_h5(obj_.value)
        elif nodeName_ == 'h6':
            obj_ = h6.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'h6', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_h6'):
              self.add_h6(obj_.value)
            elif hasattr(self, 'set_h6'):
              self.set_h6(obj_.value)
        elif nodeName_ == 'div':
            obj_ = div.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'div', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_div'):
              self.add_div(obj_.value)
            elif hasattr(self, 'set_div'):
              self.set_div(obj_.value)
        elif nodeName_ == 'ul':
            obj_ = ul.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ul', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ul'):
              self.add_ul(obj_.value)
            elif hasattr(self, 'set_ul'):
              self.set_ul(obj_.value)
        elif nodeName_ == 'ol':
            obj_ = ol.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ol', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ol'):
              self.add_ol(obj_.value)
            elif hasattr(self, 'set_ol'):
              self.set_ol(obj_.value)
        elif nodeName_ == 'dl':
            obj_ = dl.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'dl', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_dl'):
              self.add_dl(obj_.value)
            elif hasattr(self, 'set_dl'):
              self.set_dl(obj_.value)
        elif nodeName_ == 'pre':
            obj_ = pre.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'pre', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_pre'):
              self.add_pre(obj_.value)
            elif hasattr(self, 'set_pre'):
              self.set_pre(obj_.value)
        elif nodeName_ == 'hr':
            obj_ = hr.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'hr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_hr'):
              self.add_hr(obj_.value)
            elif hasattr(self, 'set_hr'):
              self.set_hr(obj_.value)
        elif nodeName_ == 'blockquote':
            obj_ = blockquote.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'blockquote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_blockquote'):
              self.add_blockquote(obj_.value)
            elif hasattr(self, 'set_blockquote'):
              self.set_blockquote(obj_.value)
        elif nodeName_ == 'address':
            obj_ = address.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'address', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_address'):
              self.add_address(obj_.value)
            elif hasattr(self, 'set_address'):
              self.set_address(obj_.value)
        elif nodeName_ == 'table':
            obj_ = table.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'table', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_table'):
              self.add_table(obj_.value)
            elif hasattr(self, 'set_table'):
              self.set_table(obj_.value)
        elif nodeName_ == 'a':
            obj_ = a.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'a', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_a'):
              self.add_a(obj_.value)
            elif hasattr(self, 'set_a'):
              self.set_a(obj_.value)
        elif nodeName_ == 'br':
            obj_ = br.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'br', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_br'):
              self.add_br(obj_.value)
            elif hasattr(self, 'set_br'):
              self.set_br(obj_.value)
        elif nodeName_ == 'span':
            obj_ = span.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'span', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_span'):
              self.add_span(obj_.value)
            elif hasattr(self, 'set_span'):
              self.set_span(obj_.value)
        elif nodeName_ == 'bdo':
            obj_ = bdo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'bdo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_bdo'):
              self.add_bdo(obj_.value)
            elif hasattr(self, 'set_bdo'):
              self.set_bdo(obj_.value)
        elif nodeName_ == 'map':
            obj_ = map.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'map', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_map'):
              self.add_map(obj_.value)
            elif hasattr(self, 'set_map'):
              self.set_map(obj_.value)
        elif nodeName_ == 'img':
            obj_ = img.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'img', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_img'):
              self.add_img(obj_.value)
            elif hasattr(self, 'set_img'):
              self.set_img(obj_.value)
        elif nodeName_ == 'tt':
            obj_ = tt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tt', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tt'):
              self.add_tt(obj_.value)
            elif hasattr(self, 'set_tt'):
              self.set_tt(obj_.value)
        elif nodeName_ == 'i':
            obj_ = i.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'i', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_i'):
              self.add_i(obj_.value)
            elif hasattr(self, 'set_i'):
              self.set_i(obj_.value)
        elif nodeName_ == 'b':
            obj_ = b.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'b', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_b'):
              self.add_b(obj_.value)
            elif hasattr(self, 'set_b'):
              self.set_b(obj_.value)
        elif nodeName_ == 'big':
            obj_ = big.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'big', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_big'):
              self.add_big(obj_.value)
            elif hasattr(self, 'set_big'):
              self.set_big(obj_.value)
        elif nodeName_ == 'small':
            obj_ = small.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'small', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_small'):
              self.add_small(obj_.value)
            elif hasattr(self, 'set_small'):
              self.set_small(obj_.value)
        elif nodeName_ == 'em':
            obj_ = em.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'em', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_em'):
              self.add_em(obj_.value)
            elif hasattr(self, 'set_em'):
              self.set_em(obj_.value)
        elif nodeName_ == 'strong':
            obj_ = strong.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'strong', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_strong'):
              self.add_strong(obj_.value)
            elif hasattr(self, 'set_strong'):
              self.set_strong(obj_.value)
        elif nodeName_ == 'dfn':
            obj_ = dfn.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'dfn', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_dfn'):
              self.add_dfn(obj_.value)
            elif hasattr(self, 'set_dfn'):
              self.set_dfn(obj_.value)
        elif nodeName_ == 'code':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'code', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_code'):
              self.add_code(obj_.value)
            elif hasattr(self, 'set_code'):
              self.set_code(obj_.value)
        elif nodeName_ == 'q':
            obj_ = q.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'q', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_q'):
              self.add_q(obj_.value)
            elif hasattr(self, 'set_q'):
              self.set_q(obj_.value)
        elif nodeName_ == 'samp':
            obj_ = samp.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'samp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_samp'):
              self.add_samp(obj_.value)
            elif hasattr(self, 'set_samp'):
              self.set_samp(obj_.value)
        elif nodeName_ == 'kbd':
            obj_ = kbd.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'kbd', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_kbd'):
              self.add_kbd(obj_.value)
            elif hasattr(self, 'set_kbd'):
              self.set_kbd(obj_.value)
        elif nodeName_ == 'var':
            obj_ = var.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'var', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_var'):
              self.add_var(obj_.value)
            elif hasattr(self, 'set_var'):
              self.set_var(obj_.value)
        elif nodeName_ == 'cite':
            obj_ = cite.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'cite', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_cite'):
              self.add_cite(obj_.value)
            elif hasattr(self, 'set_cite'):
              self.set_cite(obj_.value)
        elif nodeName_ == 'abbr':
            obj_ = abbr.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'abbr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_abbr'):
              self.add_abbr(obj_.value)
            elif hasattr(self, 'set_abbr'):
              self.set_abbr(obj_.value)
        elif nodeName_ == 'acronym':
            obj_ = acronym.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'acronym', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_acronym'):
              self.add_acronym(obj_.value)
            elif hasattr(self, 'set_acronym'):
              self.set_acronym(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = sub.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = sup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class Flow


class a_content(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if br is None:
            self.br = []
        else:
            self.br = br
        self.br_nsprefix_ = None
        if span is None:
            self.span = []
        else:
            self.span = span
        self.span_nsprefix_ = None
        if bdo is None:
            self.bdo = []
        else:
            self.bdo = bdo
        self.bdo_nsprefix_ = None
        if map is None:
            self.map = []
        else:
            self.map = map
        self.map_nsprefix_ = None
        if img is None:
            self.img = []
        else:
            self.img = img
        self.img_nsprefix_ = None
        if tt is None:
            self.tt = []
        else:
            self.tt = tt
        self.tt_nsprefix_ = None
        if i is None:
            self.i = []
        else:
            self.i = i
        self.i_nsprefix_ = None
        if b is None:
            self.b = []
        else:
            self.b = b
        self.b_nsprefix_ = None
        if big is None:
            self.big = []
        else:
            self.big = big
        self.big_nsprefix_ = None
        if small is None:
            self.small = []
        else:
            self.small = small
        self.small_nsprefix_ = None
        if em is None:
            self.em = []
        else:
            self.em = em
        self.em_nsprefix_ = None
        if strong is None:
            self.strong = []
        else:
            self.strong = strong
        self.strong_nsprefix_ = None
        if dfn is None:
            self.dfn = []
        else:
            self.dfn = dfn
        self.dfn_nsprefix_ = None
        if code is None:
            self.code = []
        else:
            self.code = code
        self.code_nsprefix_ = None
        if q is None:
            self.q = []
        else:
            self.q = q
        self.q_nsprefix_ = None
        if samp is None:
            self.samp = []
        else:
            self.samp = samp
        self.samp_nsprefix_ = None
        if kbd is None:
            self.kbd = []
        else:
            self.kbd = kbd
        self.kbd_nsprefix_ = None
        if var is None:
            self.var = []
        else:
            self.var = var
        self.var_nsprefix_ = None
        if cite is None:
            self.cite = []
        else:
            self.cite = cite
        self.cite_nsprefix_ = None
        if abbr is None:
            self.abbr = []
        else:
            self.abbr = abbr
        self.abbr_nsprefix_ = None
        if acronym is None:
            self.acronym = []
        else:
            self.acronym = acronym
        self.acronym_nsprefix_ = None
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        self.sub_nsprefix_ = None
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        self.sup_nsprefix_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, a_content)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if a_content.subclass:
            return a_content.subclass(*args_, **kwargs_)
        else:
            return a_content(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_br(self):
        return self.br
    def set_br(self, br):
        self.br = br
    def add_br(self, value):
        self.br.append(value)
    def insert_br_at(self, index, value):
        self.br.insert(index, value)
    def replace_br_at(self, index, value):
        self.br[index] = value
    def get_span(self):
        return self.span
    def set_span(self, span):
        self.span = span
    def add_span(self, value):
        self.span.append(value)
    def insert_span_at(self, index, value):
        self.span.insert(index, value)
    def replace_span_at(self, index, value):
        self.span[index] = value
    def get_bdo(self):
        return self.bdo
    def set_bdo(self, bdo):
        self.bdo = bdo
    def add_bdo(self, value):
        self.bdo.append(value)
    def insert_bdo_at(self, index, value):
        self.bdo.insert(index, value)
    def replace_bdo_at(self, index, value):
        self.bdo[index] = value
    def get_map(self):
        return self.map
    def set_map(self, map):
        self.map = map
    def add_map(self, value):
        self.map.append(value)
    def insert_map_at(self, index, value):
        self.map.insert(index, value)
    def replace_map_at(self, index, value):
        self.map[index] = value
    def get_img(self):
        return self.img
    def set_img(self, img):
        self.img = img
    def add_img(self, value):
        self.img.append(value)
    def insert_img_at(self, index, value):
        self.img.insert(index, value)
    def replace_img_at(self, index, value):
        self.img[index] = value
    def get_tt(self):
        return self.tt
    def set_tt(self, tt):
        self.tt = tt
    def add_tt(self, value):
        self.tt.append(value)
    def insert_tt_at(self, index, value):
        self.tt.insert(index, value)
    def replace_tt_at(self, index, value):
        self.tt[index] = value
    def get_i(self):
        return self.i
    def set_i(self, i):
        self.i = i
    def add_i(self, value):
        self.i.append(value)
    def insert_i_at(self, index, value):
        self.i.insert(index, value)
    def replace_i_at(self, index, value):
        self.i[index] = value
    def get_b(self):
        return self.b
    def set_b(self, b):
        self.b = b
    def add_b(self, value):
        self.b.append(value)
    def insert_b_at(self, index, value):
        self.b.insert(index, value)
    def replace_b_at(self, index, value):
        self.b[index] = value
    def get_big(self):
        return self.big
    def set_big(self, big):
        self.big = big
    def add_big(self, value):
        self.big.append(value)
    def insert_big_at(self, index, value):
        self.big.insert(index, value)
    def replace_big_at(self, index, value):
        self.big[index] = value
    def get_small(self):
        return self.small
    def set_small(self, small):
        self.small = small
    def add_small(self, value):
        self.small.append(value)
    def insert_small_at(self, index, value):
        self.small.insert(index, value)
    def replace_small_at(self, index, value):
        self.small[index] = value
    def get_em(self):
        return self.em
    def set_em(self, em):
        self.em = em
    def add_em(self, value):
        self.em.append(value)
    def insert_em_at(self, index, value):
        self.em.insert(index, value)
    def replace_em_at(self, index, value):
        self.em[index] = value
    def get_strong(self):
        return self.strong
    def set_strong(self, strong):
        self.strong = strong
    def add_strong(self, value):
        self.strong.append(value)
    def insert_strong_at(self, index, value):
        self.strong.insert(index, value)
    def replace_strong_at(self, index, value):
        self.strong[index] = value
    def get_dfn(self):
        return self.dfn
    def set_dfn(self, dfn):
        self.dfn = dfn
    def add_dfn(self, value):
        self.dfn.append(value)
    def insert_dfn_at(self, index, value):
        self.dfn.insert(index, value)
    def replace_dfn_at(self, index, value):
        self.dfn[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def add_code(self, value):
        self.code.append(value)
    def insert_code_at(self, index, value):
        self.code.insert(index, value)
    def replace_code_at(self, index, value):
        self.code[index] = value
    def get_q(self):
        return self.q
    def set_q(self, q):
        self.q = q
    def add_q(self, value):
        self.q.append(value)
    def insert_q_at(self, index, value):
        self.q.insert(index, value)
    def replace_q_at(self, index, value):
        self.q[index] = value
    def get_samp(self):
        return self.samp
    def set_samp(self, samp):
        self.samp = samp
    def add_samp(self, value):
        self.samp.append(value)
    def insert_samp_at(self, index, value):
        self.samp.insert(index, value)
    def replace_samp_at(self, index, value):
        self.samp[index] = value
    def get_kbd(self):
        return self.kbd
    def set_kbd(self, kbd):
        self.kbd = kbd
    def add_kbd(self, value):
        self.kbd.append(value)
    def insert_kbd_at(self, index, value):
        self.kbd.insert(index, value)
    def replace_kbd_at(self, index, value):
        self.kbd[index] = value
    def get_var(self):
        return self.var
    def set_var(self, var):
        self.var = var
    def add_var(self, value):
        self.var.append(value)
    def insert_var_at(self, index, value):
        self.var.insert(index, value)
    def replace_var_at(self, index, value):
        self.var[index] = value
    def get_cite(self):
        return self.cite
    def set_cite(self, cite):
        self.cite = cite
    def add_cite(self, value):
        self.cite.append(value)
    def insert_cite_at(self, index, value):
        self.cite.insert(index, value)
    def replace_cite_at(self, index, value):
        self.cite[index] = value
    def get_abbr(self):
        return self.abbr
    def set_abbr(self, abbr):
        self.abbr = abbr
    def add_abbr(self, value):
        self.abbr.append(value)
    def insert_abbr_at(self, index, value):
        self.abbr.insert(index, value)
    def replace_abbr_at(self, index, value):
        self.abbr[index] = value
    def get_acronym(self):
        return self.acronym
    def set_acronym(self, acronym):
        self.acronym = acronym
    def add_acronym(self, value):
        self.acronym.append(value)
    def insert_acronym_at(self, index, value):
        self.acronym.insert(index, value)
    def replace_acronym_at(self, index, value):
        self.acronym[index] = value
    def get_sub(self):
        return self.sub
    def set_sub(self, sub):
        self.sub = sub
    def add_sub(self, value):
        self.sub.append(value)
    def insert_sub_at(self, index, value):
        self.sub.insert(index, value)
    def replace_sub_at(self, index, value):
        self.sub[index] = value
    def get_sup(self):
        return self.sup
    def set_sup(self, sup):
        self.sup = sup
    def add_sup(self, value):
        self.sup.append(value)
    def insert_sup_at(self, index, value):
        self.sup.insert(index, value)
    def replace_sup_at(self, index, value):
        self.sup[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.br or
            self.span or
            self.bdo or
            self.map or
            self.img or
            self.tt or
            self.i or
            self.b or
            self.big or
            self.small or
            self.em or
            self.strong or
            self.dfn or
            self.code or
            self.q or
            self.samp or
            self.kbd or
            self.var or
            self.cite or
            self.abbr or
            self.acronym or
            self.sub or
            self.sup or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='a.content', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('a.content')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'a.content':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='a.content')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='a.content'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='a.content', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for br_ in self.br:
            namespaceprefix_ = self.br_nsprefix_ + ':' if (UseCapturedNS_ and self.br_nsprefix_) else ''
            br_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='br', pretty_print=pretty_print)
        for span_ in self.span:
            namespaceprefix_ = self.span_nsprefix_ + ':' if (UseCapturedNS_ and self.span_nsprefix_) else ''
            span_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='span', pretty_print=pretty_print)
        for bdo_ in self.bdo:
            namespaceprefix_ = self.bdo_nsprefix_ + ':' if (UseCapturedNS_ and self.bdo_nsprefix_) else ''
            bdo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bdo', pretty_print=pretty_print)
        for map_ in self.map:
            namespaceprefix_ = self.map_nsprefix_ + ':' if (UseCapturedNS_ and self.map_nsprefix_) else ''
            map_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='map', pretty_print=pretty_print)
        for img_ in self.img:
            namespaceprefix_ = self.img_nsprefix_ + ':' if (UseCapturedNS_ and self.img_nsprefix_) else ''
            img_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='img', pretty_print=pretty_print)
        for tt_ in self.tt:
            namespaceprefix_ = self.tt_nsprefix_ + ':' if (UseCapturedNS_ and self.tt_nsprefix_) else ''
            tt_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tt', pretty_print=pretty_print)
        for i_ in self.i:
            namespaceprefix_ = self.i_nsprefix_ + ':' if (UseCapturedNS_ and self.i_nsprefix_) else ''
            i_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='i', pretty_print=pretty_print)
        for b_ in self.b:
            namespaceprefix_ = self.b_nsprefix_ + ':' if (UseCapturedNS_ and self.b_nsprefix_) else ''
            b_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='b', pretty_print=pretty_print)
        for big_ in self.big:
            namespaceprefix_ = self.big_nsprefix_ + ':' if (UseCapturedNS_ and self.big_nsprefix_) else ''
            big_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='big', pretty_print=pretty_print)
        for small_ in self.small:
            namespaceprefix_ = self.small_nsprefix_ + ':' if (UseCapturedNS_ and self.small_nsprefix_) else ''
            small_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='small', pretty_print=pretty_print)
        for em_ in self.em:
            namespaceprefix_ = self.em_nsprefix_ + ':' if (UseCapturedNS_ and self.em_nsprefix_) else ''
            em_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='em', pretty_print=pretty_print)
        for strong_ in self.strong:
            namespaceprefix_ = self.strong_nsprefix_ + ':' if (UseCapturedNS_ and self.strong_nsprefix_) else ''
            strong_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='strong', pretty_print=pretty_print)
        for dfn_ in self.dfn:
            namespaceprefix_ = self.dfn_nsprefix_ + ':' if (UseCapturedNS_ and self.dfn_nsprefix_) else ''
            dfn_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dfn', pretty_print=pretty_print)
        for code_ in self.code:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            code_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for q_ in self.q:
            namespaceprefix_ = self.q_nsprefix_ + ':' if (UseCapturedNS_ and self.q_nsprefix_) else ''
            q_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='q', pretty_print=pretty_print)
        for samp_ in self.samp:
            namespaceprefix_ = self.samp_nsprefix_ + ':' if (UseCapturedNS_ and self.samp_nsprefix_) else ''
            samp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='samp', pretty_print=pretty_print)
        for kbd_ in self.kbd:
            namespaceprefix_ = self.kbd_nsprefix_ + ':' if (UseCapturedNS_ and self.kbd_nsprefix_) else ''
            kbd_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='kbd', pretty_print=pretty_print)
        for var_ in self.var:
            namespaceprefix_ = self.var_nsprefix_ + ':' if (UseCapturedNS_ and self.var_nsprefix_) else ''
            var_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='var', pretty_print=pretty_print)
        for cite_ in self.cite:
            namespaceprefix_ = self.cite_nsprefix_ + ':' if (UseCapturedNS_ and self.cite_nsprefix_) else ''
            cite_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cite', pretty_print=pretty_print)
        for abbr_ in self.abbr:
            namespaceprefix_ = self.abbr_nsprefix_ + ':' if (UseCapturedNS_ and self.abbr_nsprefix_) else ''
            abbr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abbr', pretty_print=pretty_print)
        for acronym_ in self.acronym:
            namespaceprefix_ = self.acronym_nsprefix_ + ':' if (UseCapturedNS_ and self.acronym_nsprefix_) else ''
            acronym_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acronym', pretty_print=pretty_print)
        for sub_ in self.sub:
            namespaceprefix_ = self.sub_nsprefix_ + ':' if (UseCapturedNS_ and self.sub_nsprefix_) else ''
            sub_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sub', pretty_print=pretty_print)
        for sup_ in self.sup:
            namespaceprefix_ = self.sup_nsprefix_ + ':' if (UseCapturedNS_ and self.sup_nsprefix_) else ''
            sup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sup', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.br:
            child_dict = child.exportJson(json_dict, 'br', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['br'] = child_list
        child_list = []
        for child in self.span:
            child_dict = child.exportJson(json_dict, 'span', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['span'] = child_list
        child_list = []
        for child in self.bdo:
            child_dict = child.exportJson(json_dict, 'bdo', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['bdo'] = child_list
        child_list = []
        for child in self.map:
            child_dict = child.exportJson(json_dict, 'map', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['map'] = child_list
        child_list = []
        for child in self.img:
            child_dict = child.exportJson(json_dict, 'img', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['img'] = child_list
        child_list = []
        for child in self.tt:
            child_dict = child.exportJson(json_dict, 'tt', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['tt'] = child_list
        child_list = []
        for child in self.i:
            child_dict = child.exportJson(json_dict, 'i', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['i'] = child_list
        child_list = []
        for child in self.b:
            child_dict = child.exportJson(json_dict, 'b', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['b'] = child_list
        child_list = []
        for child in self.big:
            child_dict = child.exportJson(json_dict, 'big', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['big'] = child_list
        child_list = []
        for child in self.small:
            child_dict = child.exportJson(json_dict, 'small', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['small'] = child_list
        child_list = []
        for child in self.em:
            child_dict = child.exportJson(json_dict, 'em', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['em'] = child_list
        child_list = []
        for child in self.strong:
            child_dict = child.exportJson(json_dict, 'strong', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['strong'] = child_list
        child_list = []
        for child in self.dfn:
            child_dict = child.exportJson(json_dict, 'dfn', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dfn'] = child_list
        child_list = []
        for child in self.code:
            child_dict = child.exportJson(json_dict, 'code', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['code'] = child_list
        child_list = []
        for child in self.q:
            child_dict = child.exportJson(json_dict, 'q', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['q'] = child_list
        child_list = []
        for child in self.samp:
            child_dict = child.exportJson(json_dict, 'samp', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['samp'] = child_list
        child_list = []
        for child in self.kbd:
            child_dict = child.exportJson(json_dict, 'kbd', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['kbd'] = child_list
        child_list = []
        for child in self.var:
            child_dict = child.exportJson(json_dict, 'var', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['var'] = child_list
        child_list = []
        for child in self.cite:
            child_dict = child.exportJson(json_dict, 'cite', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['cite'] = child_list
        child_list = []
        for child in self.abbr:
            child_dict = child.exportJson(json_dict, 'abbr', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['abbr'] = child_list
        child_list = []
        for child in self.acronym:
            child_dict = child.exportJson(json_dict, 'acronym', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['acronym'] = child_list
        child_list = []
        for child in self.sub:
            child_dict = child.exportJson(json_dict, 'sub', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sub'] = child_list
        child_list = []
        for child in self.sup:
            child_dict = child.exportJson(json_dict, 'sup', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sup'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'br':
            obj_ = br.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'br', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_br'):
              self.add_br(obj_.value)
            elif hasattr(self, 'set_br'):
              self.set_br(obj_.value)
        elif nodeName_ == 'span':
            obj_ = span.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'span', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_span'):
              self.add_span(obj_.value)
            elif hasattr(self, 'set_span'):
              self.set_span(obj_.value)
        elif nodeName_ == 'bdo':
            obj_ = bdo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'bdo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_bdo'):
              self.add_bdo(obj_.value)
            elif hasattr(self, 'set_bdo'):
              self.set_bdo(obj_.value)
        elif nodeName_ == 'map':
            obj_ = map.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'map', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_map'):
              self.add_map(obj_.value)
            elif hasattr(self, 'set_map'):
              self.set_map(obj_.value)
        elif nodeName_ == 'img':
            obj_ = img.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'img', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_img'):
              self.add_img(obj_.value)
            elif hasattr(self, 'set_img'):
              self.set_img(obj_.value)
        elif nodeName_ == 'tt':
            obj_ = tt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tt', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tt'):
              self.add_tt(obj_.value)
            elif hasattr(self, 'set_tt'):
              self.set_tt(obj_.value)
        elif nodeName_ == 'i':
            obj_ = i.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'i', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_i'):
              self.add_i(obj_.value)
            elif hasattr(self, 'set_i'):
              self.set_i(obj_.value)
        elif nodeName_ == 'b':
            obj_ = b.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'b', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_b'):
              self.add_b(obj_.value)
            elif hasattr(self, 'set_b'):
              self.set_b(obj_.value)
        elif nodeName_ == 'big':
            obj_ = big.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'big', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_big'):
              self.add_big(obj_.value)
            elif hasattr(self, 'set_big'):
              self.set_big(obj_.value)
        elif nodeName_ == 'small':
            obj_ = small.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'small', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_small'):
              self.add_small(obj_.value)
            elif hasattr(self, 'set_small'):
              self.set_small(obj_.value)
        elif nodeName_ == 'em':
            obj_ = em.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'em', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_em'):
              self.add_em(obj_.value)
            elif hasattr(self, 'set_em'):
              self.set_em(obj_.value)
        elif nodeName_ == 'strong':
            obj_ = strong.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'strong', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_strong'):
              self.add_strong(obj_.value)
            elif hasattr(self, 'set_strong'):
              self.set_strong(obj_.value)
        elif nodeName_ == 'dfn':
            obj_ = dfn.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'dfn', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_dfn'):
              self.add_dfn(obj_.value)
            elif hasattr(self, 'set_dfn'):
              self.set_dfn(obj_.value)
        elif nodeName_ == 'code':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'code', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_code'):
              self.add_code(obj_.value)
            elif hasattr(self, 'set_code'):
              self.set_code(obj_.value)
        elif nodeName_ == 'q':
            obj_ = q.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'q', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_q'):
              self.add_q(obj_.value)
            elif hasattr(self, 'set_q'):
              self.set_q(obj_.value)
        elif nodeName_ == 'samp':
            obj_ = samp.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'samp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_samp'):
              self.add_samp(obj_.value)
            elif hasattr(self, 'set_samp'):
              self.set_samp(obj_.value)
        elif nodeName_ == 'kbd':
            obj_ = kbd.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'kbd', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_kbd'):
              self.add_kbd(obj_.value)
            elif hasattr(self, 'set_kbd'):
              self.set_kbd(obj_.value)
        elif nodeName_ == 'var':
            obj_ = var.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'var', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_var'):
              self.add_var(obj_.value)
            elif hasattr(self, 'set_var'):
              self.set_var(obj_.value)
        elif nodeName_ == 'cite':
            obj_ = cite.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'cite', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_cite'):
              self.add_cite(obj_.value)
            elif hasattr(self, 'set_cite'):
              self.set_cite(obj_.value)
        elif nodeName_ == 'abbr':
            obj_ = abbr.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'abbr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_abbr'):
              self.add_abbr(obj_.value)
            elif hasattr(self, 'set_abbr'):
              self.set_abbr(obj_.value)
        elif nodeName_ == 'acronym':
            obj_ = acronym.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'acronym', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_acronym'):
              self.add_acronym(obj_.value)
            elif hasattr(self, 'set_acronym'):
              self.set_acronym(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = sub.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = sup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class a_content


class pre_content(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, a: List_['a'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if a is None:
            self.a = []
        else:
            self.a = a
        self.a_nsprefix_ = None
        if tt is None:
            self.tt = []
        else:
            self.tt = tt
        self.tt_nsprefix_ = None
        if i is None:
            self.i = []
        else:
            self.i = i
        self.i_nsprefix_ = None
        if b is None:
            self.b = []
        else:
            self.b = b
        self.b_nsprefix_ = None
        if big is None:
            self.big = []
        else:
            self.big = big
        self.big_nsprefix_ = None
        if small is None:
            self.small = []
        else:
            self.small = small
        self.small_nsprefix_ = None
        if em is None:
            self.em = []
        else:
            self.em = em
        self.em_nsprefix_ = None
        if strong is None:
            self.strong = []
        else:
            self.strong = strong
        self.strong_nsprefix_ = None
        if dfn is None:
            self.dfn = []
        else:
            self.dfn = dfn
        self.dfn_nsprefix_ = None
        if code is None:
            self.code = []
        else:
            self.code = code
        self.code_nsprefix_ = None
        if q is None:
            self.q = []
        else:
            self.q = q
        self.q_nsprefix_ = None
        if samp is None:
            self.samp = []
        else:
            self.samp = samp
        self.samp_nsprefix_ = None
        if kbd is None:
            self.kbd = []
        else:
            self.kbd = kbd
        self.kbd_nsprefix_ = None
        if var is None:
            self.var = []
        else:
            self.var = var
        self.var_nsprefix_ = None
        if cite is None:
            self.cite = []
        else:
            self.cite = cite
        self.cite_nsprefix_ = None
        if abbr is None:
            self.abbr = []
        else:
            self.abbr = abbr
        self.abbr_nsprefix_ = None
        if acronym is None:
            self.acronym = []
        else:
            self.acronym = acronym
        self.acronym_nsprefix_ = None
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        self.sub_nsprefix_ = None
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        self.sup_nsprefix_ = None
        if br is None:
            self.br = []
        else:
            self.br = br
        self.br_nsprefix_ = None
        if span is None:
            self.span = []
        else:
            self.span = span
        self.span_nsprefix_ = None
        if bdo is None:
            self.bdo = []
        else:
            self.bdo = bdo
        self.bdo_nsprefix_ = None
        if map is None:
            self.map = []
        else:
            self.map = map
        self.map_nsprefix_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pre_content)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pre_content.subclass:
            return pre_content.subclass(*args_, **kwargs_)
        else:
            return pre_content(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_a(self):
        return self.a
    def set_a(self, a):
        self.a = a
    def add_a(self, value):
        self.a.append(value)
    def insert_a_at(self, index, value):
        self.a.insert(index, value)
    def replace_a_at(self, index, value):
        self.a[index] = value
    def get_tt(self):
        return self.tt
    def set_tt(self, tt):
        self.tt = tt
    def add_tt(self, value):
        self.tt.append(value)
    def insert_tt_at(self, index, value):
        self.tt.insert(index, value)
    def replace_tt_at(self, index, value):
        self.tt[index] = value
    def get_i(self):
        return self.i
    def set_i(self, i):
        self.i = i
    def add_i(self, value):
        self.i.append(value)
    def insert_i_at(self, index, value):
        self.i.insert(index, value)
    def replace_i_at(self, index, value):
        self.i[index] = value
    def get_b(self):
        return self.b
    def set_b(self, b):
        self.b = b
    def add_b(self, value):
        self.b.append(value)
    def insert_b_at(self, index, value):
        self.b.insert(index, value)
    def replace_b_at(self, index, value):
        self.b[index] = value
    def get_big(self):
        return self.big
    def set_big(self, big):
        self.big = big
    def add_big(self, value):
        self.big.append(value)
    def insert_big_at(self, index, value):
        self.big.insert(index, value)
    def replace_big_at(self, index, value):
        self.big[index] = value
    def get_small(self):
        return self.small
    def set_small(self, small):
        self.small = small
    def add_small(self, value):
        self.small.append(value)
    def insert_small_at(self, index, value):
        self.small.insert(index, value)
    def replace_small_at(self, index, value):
        self.small[index] = value
    def get_em(self):
        return self.em
    def set_em(self, em):
        self.em = em
    def add_em(self, value):
        self.em.append(value)
    def insert_em_at(self, index, value):
        self.em.insert(index, value)
    def replace_em_at(self, index, value):
        self.em[index] = value
    def get_strong(self):
        return self.strong
    def set_strong(self, strong):
        self.strong = strong
    def add_strong(self, value):
        self.strong.append(value)
    def insert_strong_at(self, index, value):
        self.strong.insert(index, value)
    def replace_strong_at(self, index, value):
        self.strong[index] = value
    def get_dfn(self):
        return self.dfn
    def set_dfn(self, dfn):
        self.dfn = dfn
    def add_dfn(self, value):
        self.dfn.append(value)
    def insert_dfn_at(self, index, value):
        self.dfn.insert(index, value)
    def replace_dfn_at(self, index, value):
        self.dfn[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def add_code(self, value):
        self.code.append(value)
    def insert_code_at(self, index, value):
        self.code.insert(index, value)
    def replace_code_at(self, index, value):
        self.code[index] = value
    def get_q(self):
        return self.q
    def set_q(self, q):
        self.q = q
    def add_q(self, value):
        self.q.append(value)
    def insert_q_at(self, index, value):
        self.q.insert(index, value)
    def replace_q_at(self, index, value):
        self.q[index] = value
    def get_samp(self):
        return self.samp
    def set_samp(self, samp):
        self.samp = samp
    def add_samp(self, value):
        self.samp.append(value)
    def insert_samp_at(self, index, value):
        self.samp.insert(index, value)
    def replace_samp_at(self, index, value):
        self.samp[index] = value
    def get_kbd(self):
        return self.kbd
    def set_kbd(self, kbd):
        self.kbd = kbd
    def add_kbd(self, value):
        self.kbd.append(value)
    def insert_kbd_at(self, index, value):
        self.kbd.insert(index, value)
    def replace_kbd_at(self, index, value):
        self.kbd[index] = value
    def get_var(self):
        return self.var
    def set_var(self, var):
        self.var = var
    def add_var(self, value):
        self.var.append(value)
    def insert_var_at(self, index, value):
        self.var.insert(index, value)
    def replace_var_at(self, index, value):
        self.var[index] = value
    def get_cite(self):
        return self.cite
    def set_cite(self, cite):
        self.cite = cite
    def add_cite(self, value):
        self.cite.append(value)
    def insert_cite_at(self, index, value):
        self.cite.insert(index, value)
    def replace_cite_at(self, index, value):
        self.cite[index] = value
    def get_abbr(self):
        return self.abbr
    def set_abbr(self, abbr):
        self.abbr = abbr
    def add_abbr(self, value):
        self.abbr.append(value)
    def insert_abbr_at(self, index, value):
        self.abbr.insert(index, value)
    def replace_abbr_at(self, index, value):
        self.abbr[index] = value
    def get_acronym(self):
        return self.acronym
    def set_acronym(self, acronym):
        self.acronym = acronym
    def add_acronym(self, value):
        self.acronym.append(value)
    def insert_acronym_at(self, index, value):
        self.acronym.insert(index, value)
    def replace_acronym_at(self, index, value):
        self.acronym[index] = value
    def get_sub(self):
        return self.sub
    def set_sub(self, sub):
        self.sub = sub
    def add_sub(self, value):
        self.sub.append(value)
    def insert_sub_at(self, index, value):
        self.sub.insert(index, value)
    def replace_sub_at(self, index, value):
        self.sub[index] = value
    def get_sup(self):
        return self.sup
    def set_sup(self, sup):
        self.sup = sup
    def add_sup(self, value):
        self.sup.append(value)
    def insert_sup_at(self, index, value):
        self.sup.insert(index, value)
    def replace_sup_at(self, index, value):
        self.sup[index] = value
    def get_br(self):
        return self.br
    def set_br(self, br):
        self.br = br
    def add_br(self, value):
        self.br.append(value)
    def insert_br_at(self, index, value):
        self.br.insert(index, value)
    def replace_br_at(self, index, value):
        self.br[index] = value
    def get_span(self):
        return self.span
    def set_span(self, span):
        self.span = span
    def add_span(self, value):
        self.span.append(value)
    def insert_span_at(self, index, value):
        self.span.insert(index, value)
    def replace_span_at(self, index, value):
        self.span[index] = value
    def get_bdo(self):
        return self.bdo
    def set_bdo(self, bdo):
        self.bdo = bdo
    def add_bdo(self, value):
        self.bdo.append(value)
    def insert_bdo_at(self, index, value):
        self.bdo.insert(index, value)
    def replace_bdo_at(self, index, value):
        self.bdo[index] = value
    def get_map(self):
        return self.map
    def set_map(self, map):
        self.map = map
    def add_map(self, value):
        self.map.append(value)
    def insert_map_at(self, index, value):
        self.map.insert(index, value)
    def replace_map_at(self, index, value):
        self.map[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.a or
            self.tt or
            self.i or
            self.b or
            self.big or
            self.small or
            self.em or
            self.strong or
            self.dfn or
            self.code or
            self.q or
            self.samp or
            self.kbd or
            self.var or
            self.cite or
            self.abbr or
            self.acronym or
            self.sub or
            self.sup or
            self.br or
            self.span or
            self.bdo or
            self.map or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='pre.content', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pre.content')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'pre.content':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='pre.content')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='pre.content'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='pre.content', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for a_ in self.a:
            namespaceprefix_ = self.a_nsprefix_ + ':' if (UseCapturedNS_ and self.a_nsprefix_) else ''
            a_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='a', pretty_print=pretty_print)
        for tt_ in self.tt:
            namespaceprefix_ = self.tt_nsprefix_ + ':' if (UseCapturedNS_ and self.tt_nsprefix_) else ''
            tt_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tt', pretty_print=pretty_print)
        for i_ in self.i:
            namespaceprefix_ = self.i_nsprefix_ + ':' if (UseCapturedNS_ and self.i_nsprefix_) else ''
            i_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='i', pretty_print=pretty_print)
        for b_ in self.b:
            namespaceprefix_ = self.b_nsprefix_ + ':' if (UseCapturedNS_ and self.b_nsprefix_) else ''
            b_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='b', pretty_print=pretty_print)
        for big_ in self.big:
            namespaceprefix_ = self.big_nsprefix_ + ':' if (UseCapturedNS_ and self.big_nsprefix_) else ''
            big_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='big', pretty_print=pretty_print)
        for small_ in self.small:
            namespaceprefix_ = self.small_nsprefix_ + ':' if (UseCapturedNS_ and self.small_nsprefix_) else ''
            small_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='small', pretty_print=pretty_print)
        for em_ in self.em:
            namespaceprefix_ = self.em_nsprefix_ + ':' if (UseCapturedNS_ and self.em_nsprefix_) else ''
            em_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='em', pretty_print=pretty_print)
        for strong_ in self.strong:
            namespaceprefix_ = self.strong_nsprefix_ + ':' if (UseCapturedNS_ and self.strong_nsprefix_) else ''
            strong_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='strong', pretty_print=pretty_print)
        for dfn_ in self.dfn:
            namespaceprefix_ = self.dfn_nsprefix_ + ':' if (UseCapturedNS_ and self.dfn_nsprefix_) else ''
            dfn_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dfn', pretty_print=pretty_print)
        for code_ in self.code:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            code_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for q_ in self.q:
            namespaceprefix_ = self.q_nsprefix_ + ':' if (UseCapturedNS_ and self.q_nsprefix_) else ''
            q_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='q', pretty_print=pretty_print)
        for samp_ in self.samp:
            namespaceprefix_ = self.samp_nsprefix_ + ':' if (UseCapturedNS_ and self.samp_nsprefix_) else ''
            samp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='samp', pretty_print=pretty_print)
        for kbd_ in self.kbd:
            namespaceprefix_ = self.kbd_nsprefix_ + ':' if (UseCapturedNS_ and self.kbd_nsprefix_) else ''
            kbd_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='kbd', pretty_print=pretty_print)
        for var_ in self.var:
            namespaceprefix_ = self.var_nsprefix_ + ':' if (UseCapturedNS_ and self.var_nsprefix_) else ''
            var_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='var', pretty_print=pretty_print)
        for cite_ in self.cite:
            namespaceprefix_ = self.cite_nsprefix_ + ':' if (UseCapturedNS_ and self.cite_nsprefix_) else ''
            cite_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cite', pretty_print=pretty_print)
        for abbr_ in self.abbr:
            namespaceprefix_ = self.abbr_nsprefix_ + ':' if (UseCapturedNS_ and self.abbr_nsprefix_) else ''
            abbr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='abbr', pretty_print=pretty_print)
        for acronym_ in self.acronym:
            namespaceprefix_ = self.acronym_nsprefix_ + ':' if (UseCapturedNS_ and self.acronym_nsprefix_) else ''
            acronym_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acronym', pretty_print=pretty_print)
        for sub_ in self.sub:
            namespaceprefix_ = self.sub_nsprefix_ + ':' if (UseCapturedNS_ and self.sub_nsprefix_) else ''
            sub_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sub', pretty_print=pretty_print)
        for sup_ in self.sup:
            namespaceprefix_ = self.sup_nsprefix_ + ':' if (UseCapturedNS_ and self.sup_nsprefix_) else ''
            sup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sup', pretty_print=pretty_print)
        for br_ in self.br:
            namespaceprefix_ = self.br_nsprefix_ + ':' if (UseCapturedNS_ and self.br_nsprefix_) else ''
            br_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='br', pretty_print=pretty_print)
        for span_ in self.span:
            namespaceprefix_ = self.span_nsprefix_ + ':' if (UseCapturedNS_ and self.span_nsprefix_) else ''
            span_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='span', pretty_print=pretty_print)
        for bdo_ in self.bdo:
            namespaceprefix_ = self.bdo_nsprefix_ + ':' if (UseCapturedNS_ and self.bdo_nsprefix_) else ''
            bdo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bdo', pretty_print=pretty_print)
        for map_ in self.map:
            namespaceprefix_ = self.map_nsprefix_ + ':' if (UseCapturedNS_ and self.map_nsprefix_) else ''
            map_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='map', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.a:
            child_dict = child.exportJson(json_dict, 'a', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['a'] = child_list
        child_list = []
        for child in self.tt:
            child_dict = child.exportJson(json_dict, 'tt', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['tt'] = child_list
        child_list = []
        for child in self.i:
            child_dict = child.exportJson(json_dict, 'i', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['i'] = child_list
        child_list = []
        for child in self.b:
            child_dict = child.exportJson(json_dict, 'b', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['b'] = child_list
        child_list = []
        for child in self.big:
            child_dict = child.exportJson(json_dict, 'big', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['big'] = child_list
        child_list = []
        for child in self.small:
            child_dict = child.exportJson(json_dict, 'small', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['small'] = child_list
        child_list = []
        for child in self.em:
            child_dict = child.exportJson(json_dict, 'em', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['em'] = child_list
        child_list = []
        for child in self.strong:
            child_dict = child.exportJson(json_dict, 'strong', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['strong'] = child_list
        child_list = []
        for child in self.dfn:
            child_dict = child.exportJson(json_dict, 'dfn', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dfn'] = child_list
        child_list = []
        for child in self.code:
            child_dict = child.exportJson(json_dict, 'code', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['code'] = child_list
        child_list = []
        for child in self.q:
            child_dict = child.exportJson(json_dict, 'q', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['q'] = child_list
        child_list = []
        for child in self.samp:
            child_dict = child.exportJson(json_dict, 'samp', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['samp'] = child_list
        child_list = []
        for child in self.kbd:
            child_dict = child.exportJson(json_dict, 'kbd', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['kbd'] = child_list
        child_list = []
        for child in self.var:
            child_dict = child.exportJson(json_dict, 'var', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['var'] = child_list
        child_list = []
        for child in self.cite:
            child_dict = child.exportJson(json_dict, 'cite', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['cite'] = child_list
        child_list = []
        for child in self.abbr:
            child_dict = child.exportJson(json_dict, 'abbr', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['abbr'] = child_list
        child_list = []
        for child in self.acronym:
            child_dict = child.exportJson(json_dict, 'acronym', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['acronym'] = child_list
        child_list = []
        for child in self.sub:
            child_dict = child.exportJson(json_dict, 'sub', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sub'] = child_list
        child_list = []
        for child in self.sup:
            child_dict = child.exportJson(json_dict, 'sup', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sup'] = child_list
        child_list = []
        for child in self.br:
            child_dict = child.exportJson(json_dict, 'br', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['br'] = child_list
        child_list = []
        for child in self.span:
            child_dict = child.exportJson(json_dict, 'span', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['span'] = child_list
        child_list = []
        for child in self.bdo:
            child_dict = child.exportJson(json_dict, 'bdo', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['bdo'] = child_list
        child_list = []
        for child in self.map:
            child_dict = child.exportJson(json_dict, 'map', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['map'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'a':
            obj_ = a.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'a', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_a'):
              self.add_a(obj_.value)
            elif hasattr(self, 'set_a'):
              self.set_a(obj_.value)
        elif nodeName_ == 'tt':
            obj_ = tt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tt', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tt'):
              self.add_tt(obj_.value)
            elif hasattr(self, 'set_tt'):
              self.set_tt(obj_.value)
        elif nodeName_ == 'i':
            obj_ = i.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'i', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_i'):
              self.add_i(obj_.value)
            elif hasattr(self, 'set_i'):
              self.set_i(obj_.value)
        elif nodeName_ == 'b':
            obj_ = b.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'b', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_b'):
              self.add_b(obj_.value)
            elif hasattr(self, 'set_b'):
              self.set_b(obj_.value)
        elif nodeName_ == 'big':
            obj_ = big.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'big', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_big'):
              self.add_big(obj_.value)
            elif hasattr(self, 'set_big'):
              self.set_big(obj_.value)
        elif nodeName_ == 'small':
            obj_ = small.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'small', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_small'):
              self.add_small(obj_.value)
            elif hasattr(self, 'set_small'):
              self.set_small(obj_.value)
        elif nodeName_ == 'em':
            obj_ = em.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'em', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_em'):
              self.add_em(obj_.value)
            elif hasattr(self, 'set_em'):
              self.set_em(obj_.value)
        elif nodeName_ == 'strong':
            obj_ = strong.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'strong', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_strong'):
              self.add_strong(obj_.value)
            elif hasattr(self, 'set_strong'):
              self.set_strong(obj_.value)
        elif nodeName_ == 'dfn':
            obj_ = dfn.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'dfn', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_dfn'):
              self.add_dfn(obj_.value)
            elif hasattr(self, 'set_dfn'):
              self.set_dfn(obj_.value)
        elif nodeName_ == 'code':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'code', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_code'):
              self.add_code(obj_.value)
            elif hasattr(self, 'set_code'):
              self.set_code(obj_.value)
        elif nodeName_ == 'q':
            obj_ = q.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'q', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_q'):
              self.add_q(obj_.value)
            elif hasattr(self, 'set_q'):
              self.set_q(obj_.value)
        elif nodeName_ == 'samp':
            obj_ = samp.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'samp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_samp'):
              self.add_samp(obj_.value)
            elif hasattr(self, 'set_samp'):
              self.set_samp(obj_.value)
        elif nodeName_ == 'kbd':
            obj_ = kbd.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'kbd', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_kbd'):
              self.add_kbd(obj_.value)
            elif hasattr(self, 'set_kbd'):
              self.set_kbd(obj_.value)
        elif nodeName_ == 'var':
            obj_ = var.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'var', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_var'):
              self.add_var(obj_.value)
            elif hasattr(self, 'set_var'):
              self.set_var(obj_.value)
        elif nodeName_ == 'cite':
            obj_ = cite.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'cite', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_cite'):
              self.add_cite(obj_.value)
            elif hasattr(self, 'set_cite'):
              self.set_cite(obj_.value)
        elif nodeName_ == 'abbr':
            obj_ = abbr.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'abbr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_abbr'):
              self.add_abbr(obj_.value)
            elif hasattr(self, 'set_abbr'):
              self.set_abbr(obj_.value)
        elif nodeName_ == 'acronym':
            obj_ = acronym.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'acronym', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_acronym'):
              self.add_acronym(obj_.value)
            elif hasattr(self, 'set_acronym'):
              self.set_acronym(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = sub.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = sup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br':
            obj_ = br.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'br', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_br'):
              self.add_br(obj_.value)
            elif hasattr(self, 'set_br'):
              self.set_br(obj_.value)
        elif nodeName_ == 'span':
            obj_ = span.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'span', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_span'):
              self.add_span(obj_.value)
            elif hasattr(self, 'set_span'):
              self.set_span(obj_.value)
        elif nodeName_ == 'bdo':
            obj_ = bdo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'bdo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_bdo'):
              self.add_bdo(obj_.value)
            elif hasattr(self, 'set_bdo'):
              self.set_bdo(obj_.value)
        elif nodeName_ == 'map':
            obj_ = map.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'map', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_map'):
              self.add_map(obj_.value)
            elif hasattr(self, 'set_map'):
              self.set_map(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class pre_content


class div(Flow):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Flow
    def __init__(self, p: List_['p'] = None, h1: List_['h1'] = None, h2: List_['h2'] = None, h3: List_['h3'] = None, h4: List_['h4'] = None, h5: List_['h5'] = None, h6: List_['h6'] = None, div: List_['div'] = None, ul: List_['ul'] = None, ol: List_['ol'] = None, dl: List_['dl'] = None, pre: List_['pre'] = None, hr: List_['hr'] = None, blockquote: List_['blockquote'] = None, address: List_['address'] = None, table: List_['table'] = None, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("div"), self).__init__(p, h1, h2, h3, h4, h5, h6, div, ul, ol, dl, pre, hr, blockquote, address, table, a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, div)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if div.subclass:
            return div.subclass(*args_, **kwargs_)
        else:
            return div(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(div, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='div', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('div')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'div':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='div')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='div'):
        super(div, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='div')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='div', fromsubclass_=False, pretty_print=True):
        super(div, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(div, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(div, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class div


class p(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("p"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, p)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if p.subclass:
            return p.subclass(*args_, **kwargs_)
        else:
            return p(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(p, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='p', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('p')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'p':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='p')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='p'):
        super(p, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='p')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='p', fromsubclass_=False, pretty_print=True):
        super(p, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(p, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(p, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class p


class h1(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("h1"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, h1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if h1.subclass:
            return h1.subclass(*args_, **kwargs_)
        else:
            return h1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(h1, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h1', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('h1')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'h1':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h1')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='h1'):
        super(h1, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h1')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h1', fromsubclass_=False, pretty_print=True):
        super(h1, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(h1, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(h1, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class h1


class h2(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("h2"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, h2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if h2.subclass:
            return h2.subclass(*args_, **kwargs_)
        else:
            return h2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(h2, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('h2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'h2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h2')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='h2'):
        super(h2, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h2')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h2', fromsubclass_=False, pretty_print=True):
        super(h2, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(h2, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(h2, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class h2


class h3(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("h3"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, h3)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if h3.subclass:
            return h3.subclass(*args_, **kwargs_)
        else:
            return h3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(h3, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h3', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('h3')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'h3':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h3')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='h3'):
        super(h3, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h3')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h3', fromsubclass_=False, pretty_print=True):
        super(h3, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(h3, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(h3, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class h3


class h4(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("h4"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, h4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if h4.subclass:
            return h4.subclass(*args_, **kwargs_)
        else:
            return h4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(h4, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h4', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('h4')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'h4':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h4')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='h4'):
        super(h4, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h4')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h4', fromsubclass_=False, pretty_print=True):
        super(h4, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(h4, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(h4, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class h4


class h5(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("h5"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, h5)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if h5.subclass:
            return h5.subclass(*args_, **kwargs_)
        else:
            return h5(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(h5, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h5', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('h5')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'h5':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h5')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='h5'):
        super(h5, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h5')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h5', fromsubclass_=False, pretty_print=True):
        super(h5, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(h5, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(h5, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class h5


class h6(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("h6"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, h6)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if h6.subclass:
            return h6.subclass(*args_, **kwargs_)
        else:
            return h6(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(h6, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h6', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('h6')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'h6':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h6')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='h6'):
        super(h6, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='h6')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='h6', fromsubclass_=False, pretty_print=True):
        super(h6, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(h6, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(h6, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class h6


class ul(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, li: List_['li'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        if li is None:
            self.li = []
        else:
            self.li = li
        self.li_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ul)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ul.subclass:
            return ul.subclass(*args_, **kwargs_)
        else:
            return ul(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_li(self):
        return self.li
    def set_li(self, li):
        self.li = li
    def add_li(self, value):
        self.li.append(value)
    def insert_li_at(self, index, value):
        self.li.insert(index, value)
    def replace_li_at(self, index, value):
        self.li[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            self.li
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='ul', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ul')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ul':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ul')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ul', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ul'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='ul', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for li_ in self.li:
            namespaceprefix_ = self.li_nsprefix_ + ':' if (UseCapturedNS_ and self.li_nsprefix_) else ''
            li_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='li', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.li:
            child_dict = child.exportJson(json_dict, 'li', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['li'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'li':
            obj_ = li.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.li.append(obj_)
            obj_.original_tagname_ = 'li'
# end class ul


class ol(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, li: List_['li'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        if li is None:
            self.li = []
        else:
            self.li = li
        self.li_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ol)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ol.subclass:
            return ol.subclass(*args_, **kwargs_)
        else:
            return ol(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_li(self):
        return self.li
    def set_li(self, li):
        self.li = li
    def add_li(self, value):
        self.li.append(value)
    def insert_li_at(self, index, value):
        self.li.insert(index, value)
    def replace_li_at(self, index, value):
        self.li[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            self.li
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='ol', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ol')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ol':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ol')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ol', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ol'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='ol', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for li_ in self.li:
            namespaceprefix_ = self.li_nsprefix_ + ':' if (UseCapturedNS_ and self.li_nsprefix_) else ''
            li_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='li', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.li:
            child_dict = child.exportJson(json_dict, 'li', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['li'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'li':
            obj_ = li.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.li.append(obj_)
            obj_.original_tagname_ = 'li'
# end class ol


class li(Flow):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Flow
    def __init__(self, p: List_['p'] = None, h1: List_['h1'] = None, h2: List_['h2'] = None, h3: List_['h3'] = None, h4: List_['h4'] = None, h5: List_['h5'] = None, h6: List_['h6'] = None, div: List_['div'] = None, ul: List_['ul'] = None, ol: List_['ol'] = None, dl: List_['dl'] = None, pre: List_['pre'] = None, hr: List_['hr'] = None, blockquote: List_['blockquote'] = None, address: List_['address'] = None, table: List_['table'] = None, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("li"), self).__init__(p, h1, h2, h3, h4, h5, h6, div, ul, ol, dl, pre, hr, blockquote, address, table, a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, li)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if li.subclass:
            return li.subclass(*args_, **kwargs_)
        else:
            return li(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(li, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='li', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('li')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'li':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='li')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='li'):
        super(li, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='li')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='li', fromsubclass_=False, pretty_print=True):
        super(li, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(li, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(li, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class li


class dl(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, dt: List_['dt'] = None, dd: List_['dd'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        if dt is None:
            self.dt = []
        else:
            self.dt = dt
        self.dt_nsprefix_ = None
        if dd is None:
            self.dd = []
        else:
            self.dd = dd
        self.dd_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, dl)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dl.subclass:
            return dl.subclass(*args_, **kwargs_)
        else:
            return dl(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dt(self):
        return self.dt
    def set_dt(self, dt):
        self.dt = dt
    def add_dt(self, value):
        self.dt.append(value)
    def insert_dt_at(self, index, value):
        self.dt.insert(index, value)
    def replace_dt_at(self, index, value):
        self.dt[index] = value
    def get_dd(self):
        return self.dd
    def set_dd(self, dd):
        self.dd = dd
    def add_dd(self, value):
        self.dd.append(value)
    def insert_dd_at(self, index, value):
        self.dd.insert(index, value)
    def replace_dd_at(self, index, value):
        self.dd[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            self.dt or
            self.dd
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='dl', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('dl')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'dl':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='dl')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='dl', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='dl'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:None="http://hl7.org/fhir" ', name_='dl', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for dt_ in self.dt:
            namespaceprefix_ = self.dt_nsprefix_ + ':' if (UseCapturedNS_ and self.dt_nsprefix_) else ''
            dt_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dt', pretty_print=pretty_print)
        for dd_ in self.dd:
            namespaceprefix_ = self.dd_nsprefix_ + ':' if (UseCapturedNS_ and self.dd_nsprefix_) else ''
            dd_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dd', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.dt:
            child_dict = child.exportJson(json_dict, 'dt', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dt'] = child_list
        child_list = []
        for child in self.dd:
            child_dict = child.exportJson(json_dict, 'dd', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dd'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'dt':
            obj_ = dt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dt.append(obj_)
            obj_.original_tagname_ = 'dt'
        elif nodeName_ == 'dd':
            obj_ = dd.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dd.append(obj_)
            obj_.original_tagname_ = 'dd'
# end class dl


class dt(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("dt"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, dt)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dt.subclass:
            return dt.subclass(*args_, **kwargs_)
        else:
            return dt(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(dt, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='dt', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('dt')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'dt':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='dt')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='dt'):
        super(dt, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='dt')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='dt', fromsubclass_=False, pretty_print=True):
        super(dt, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(dt, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(dt, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class dt


class dd(Flow):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Flow
    def __init__(self, p: List_['p'] = None, h1: List_['h1'] = None, h2: List_['h2'] = None, h3: List_['h3'] = None, h4: List_['h4'] = None, h5: List_['h5'] = None, h6: List_['h6'] = None, div: List_['div'] = None, ul: List_['ul'] = None, ol: List_['ol'] = None, dl: List_['dl'] = None, pre: List_['pre'] = None, hr: List_['hr'] = None, blockquote: List_['blockquote'] = None, address: List_['address'] = None, table: List_['table'] = None, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("dd"), self).__init__(p, h1, h2, h3, h4, h5, h6, div, ul, ol, dl, pre, hr, blockquote, address, table, a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, dd)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dd.subclass:
            return dd.subclass(*args_, **kwargs_)
        else:
            return dd(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(dd, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='dd', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('dd')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'dd':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='dd')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='dd'):
        super(dd, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='dd')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='dd', fromsubclass_=False, pretty_print=True):
        super(dd, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(dd, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(dd, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class dd


class address(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("address"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, address)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if address.subclass:
            return address.subclass(*args_, **kwargs_)
        else:
            return address(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(address, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='address', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('address')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'address':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='address')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='address'):
        super(address, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='address')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='address', fromsubclass_=False, pretty_print=True):
        super(address, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(address, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(address, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class address


class hr(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, hr)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if hr.subclass:
            return hr.subclass(*args_, **kwargs_)
        else:
            return hr(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='hr', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('hr')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'hr':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='hr')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='hr', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='hr'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='hr', fromsubclass_=False, pretty_print=True):
        pass
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class hr


class pre(pre_content):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = pre_content
    def __init__(self, a: List_['a'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, space: 'xs_string' = 'preserve', id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("pre"), self).__init__(a, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, br, span, bdo, map, valueOf_, mixedclass_, content_,  **kwargs_)
        self.space = _cast(None, space)
        self.space_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pre)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pre.subclass:
            return pre.subclass(*args_, **kwargs_)
        else:
            return pre(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_space(self):
        return self.space
    def set_space(self, space):
        self.space = space
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(pre, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='pre', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pre')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'pre':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='pre')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='pre'):
        super(pre, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='pre')
        if self.space != "preserve" and 'space' not in already_processed:
            already_processed.add('space')
            outfile.write(' xml:space=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.space), input_name='space')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='pre', fromsubclass_=False, pretty_print=True):
        super(pre, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['space'',''id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.space is not None:
            json_dict['space'] = self.space
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('space', node)
        if value is not None and 'space' not in already_processed:
            already_processed.add('space')
            self.space = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(pre, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(pre, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class pre


class blockquote(Block):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Block
    def __init__(self, p: List_['p'] = None, h1: List_['h1'] = None, h2: List_['h2'] = None, h3: List_['h3'] = None, h4: List_['h4'] = None, h5: List_['h5'] = None, h6: List_['h6'] = None, div: List_['div'] = None, ul: List_['ul'] = None, ol: List_['ol'] = None, dl: List_['dl'] = None, pre: List_['pre'] = None, hr: List_['hr'] = None, blockquote: List_['blockquote'] = None, address: List_['address'] = None, table: List_['table'] = None, cite: 'URI' = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("blockquote"), self).__init__(p, h1, h2, h3, h4, h5, h6, div, ul, ol, dl, pre, hr, blockquote, address, table,  **kwargs_)
        self.cite = _cast(None, cite)
        self.cite_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, blockquote)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if blockquote.subclass:
            return blockquote.subclass(*args_, **kwargs_)
        else:
            return blockquote(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_cite(self):
        return self.cite
    def set_cite(self, cite):
        self.cite = cite
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def validate_URI(self, value):
        # Validate type URI, a restriction on xs:anyURI.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            super(blockquote, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='blockquote', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('blockquote')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'blockquote':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='blockquote')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='blockquote', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='blockquote'):
        super(blockquote, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='blockquote')
        if self.cite is not None and 'cite' not in already_processed:
            already_processed.add('cite')
            outfile.write(' cite=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.cite), input_name='cite')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='blockquote', fromsubclass_=False, pretty_print=True):
        super(blockquote, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['cite'',''id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.cite is not None:
            json_dict['cite'] = self.cite
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cite', node)
        if value is not None and 'cite' not in already_processed:
            already_processed.add('cite')
            self.cite = value
            self.validate_URI(self.cite)    # validate type URI
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(blockquote, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(blockquote, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class blockquote


class a(a_content):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = a_content
    def __init__(self, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, charset: 'Charset' = None, type_: 'ContentType' = None, name: 'xs_NMTOKEN' = None, href: 'URI' = None, hreflang: 'LanguageCode' = None, rel: 'LinkTypes' = None, rev: 'LinkTypes' = None, shape: 'Shape' = 'rect', coords: 'Coords' = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, accesskey: 'Character' = None, tabindex: 'tabindexNumber' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("a"), self).__init__(br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.charset = _cast(None, charset)
        self.charset_nsprefix_ = None
        self.type_ = _cast(None, type_)
        self.type__nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.href = _cast(None, href)
        self.href_nsprefix_ = None
        self.hreflang = _cast(None, hreflang)
        self.hreflang_nsprefix_ = None
        self.rel = _cast(None, rel)
        self.rel_nsprefix_ = None
        self.rev = _cast(None, rev)
        self.rev_nsprefix_ = None
        self.shape = _cast(None, shape)
        self.shape_nsprefix_ = None
        self.coords = _cast(None, coords)
        self.coords_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.accesskey = _cast(None, accesskey)
        self.accesskey_nsprefix_ = None
        self.tabindex = _cast(int, tabindex)
        self.tabindex_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, a)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if a.subclass:
            return a.subclass(*args_, **kwargs_)
        else:
            return a(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_charset(self):
        return self.charset
    def set_charset(self, charset):
        self.charset = charset
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_href(self):
        return self.href
    def set_href(self, href):
        self.href = href
    def get_hreflang(self):
        return self.hreflang
    def set_hreflang(self, hreflang):
        self.hreflang = hreflang
    def get_rel(self):
        return self.rel
    def set_rel(self, rel):
        self.rel = rel
    def get_rev(self):
        return self.rev
    def set_rev(self, rev):
        self.rev = rev
    def get_shape(self):
        return self.shape
    def set_shape(self, shape):
        self.shape = shape
    def get_coords(self):
        return self.coords
    def set_coords(self, coords):
        self.coords = coords
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_accesskey(self):
        return self.accesskey
    def set_accesskey(self, accesskey):
        self.accesskey = accesskey
    def get_tabindex(self):
        return self.tabindex
    def set_tabindex(self, tabindex):
        self.tabindex = tabindex
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_Charset(self, value):
        # Validate type Charset, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_ContentType(self, value):
        # Validate type ContentType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_URI(self, value):
        # Validate type URI, a restriction on xs:anyURI.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_LanguageCode(self, value):
        # Validate type LanguageCode, a restriction on xs:language.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_LinkTypes(self, value):
        # Validate type LinkTypes, a restriction on xs:NMTOKENS.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            pass
    def validate_Shape(self, value):
        # Validate type Shape, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['rect', 'circle', 'poly', 'default']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Shape' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_Coords(self, value):
        # Validate type Coords, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_Coords_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_Coords_patterns_, ))
    validate_Coords_patterns_ = [['^([-+]?(\\d+|\\d+(\\.\\d+)?%)(,\\s*[-+]?(\\d+|\\d+(\\.\\d+)?%))*)$']]
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_Character(self, value):
        # Validate type Character, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on Character' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_tabindexNumber(self, value):
        # Validate type tabindexNumber, a restriction on Number.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on tabindexNumber' % {"value": value, "lineno": lineno} )
                result = False
            if value > 32767:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on tabindexNumber' % {"value": value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_tabindexNumber_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_tabindexNumber_patterns_, ))
    validate_tabindexNumber_patterns_ = [['^([0-9]+)$']]
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(a, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='a', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('a')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'a':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='a')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='a'):
        super(a, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='a')
        if self.charset is not None and 'charset' not in already_processed:
            already_processed.add('charset')
            outfile.write(' charset=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charset), input_name='charset')), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.href), input_name='href')), ))
        if self.hreflang is not None and 'hreflang' not in already_processed:
            already_processed.add('hreflang')
            outfile.write(' hreflang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.hreflang), input_name='hreflang')), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (quote_attrib(self.rel), ))
        if self.rev is not None and 'rev' not in already_processed:
            already_processed.add('rev')
            outfile.write(' rev=%s' % (quote_attrib(self.rev), ))
        if self.shape != "rect" and 'shape' not in already_processed:
            already_processed.add('shape')
            outfile.write(' shape=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.shape), input_name='shape')), ))
        if self.coords is not None and 'coords' not in already_processed:
            already_processed.add('coords')
            outfile.write(' coords=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.coords), input_name='coords')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
        if self.accesskey is not None and 'accesskey' not in already_processed:
            already_processed.add('accesskey')
            outfile.write(' accesskey=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.accesskey), input_name='accesskey')), ))
        if self.tabindex is not None and 'tabindex' not in already_processed:
            already_processed.add('tabindex')
            outfile.write(' tabindex=%s' % (quote_attrib(self.tabindex), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='a', fromsubclass_=False, pretty_print=True):
        super(a, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['charset'',''type'',''name'',''href'',''hreflang'',''rel'',''rev'',''shape'',''coords'',''id'',''class'',''style'',''title'',''lang'',''lang'',''dir'',''accesskey'',''tabindex']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.charset is not None:
            json_dict['charset'] = self.charset
        if self.type_ is not None:
            json_dict['type'] = self.type_
        if self.name is not None:
            json_dict['name'] = self.name
        if self.href is not None:
            json_dict['href'] = self.href
        if self.hreflang is not None:
            json_dict['hreflang'] = self.hreflang
        if self.rel is not None:
            json_dict['rel'] = self.rel
        if self.rev is not None:
            json_dict['rev'] = self.rev
        if self.shape is not None:
            json_dict['shape'] = self.shape
        if self.coords is not None:
            json_dict['coords'] = self.coords
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
        if self.accesskey is not None:
            json_dict['accesskey'] = self.accesskey
        if self.tabindex is not None:
            json_dict['tabindex'] = self.tabindex
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('charset', node)
        if value is not None and 'charset' not in already_processed:
            already_processed.add('charset')
            self.charset = value
            self.validate_Charset(self.charset)    # validate type Charset
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_ContentType(self.type_)    # validate type ContentType
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
            self.validate_URI(self.href)    # validate type URI
        value = find_attr_value_('hreflang', node)
        if value is not None and 'hreflang' not in already_processed:
            already_processed.add('hreflang')
            self.hreflang = value
            self.validate_LanguageCode(self.hreflang)    # validate type LanguageCode
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
            self.validate_LinkTypes(self.rel)    # validate type LinkTypes
        value = find_attr_value_('rev', node)
        if value is not None and 'rev' not in already_processed:
            already_processed.add('rev')
            self.rev = value
            self.validate_LinkTypes(self.rev)    # validate type LinkTypes
        value = find_attr_value_('shape', node)
        if value is not None and 'shape' not in already_processed:
            already_processed.add('shape')
            self.shape = value
            self.shape = ' '.join(self.shape.split())
            self.validate_Shape(self.shape)    # validate type Shape
        value = find_attr_value_('coords', node)
        if value is not None and 'coords' not in already_processed:
            already_processed.add('coords')
            self.coords = value
            self.validate_Coords(self.coords)    # validate type Coords
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        value = find_attr_value_('accesskey', node)
        if value is not None and 'accesskey' not in already_processed:
            already_processed.add('accesskey')
            self.accesskey = value
            self.validate_Character(self.accesskey)    # validate type Character
        value = find_attr_value_('tabindex', node)
        if value is not None and 'tabindex' not in already_processed:
            already_processed.add('tabindex')
            self.tabindex = self.gds_parse_integer(value, node, 'tabindex')
            if self.tabindex < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_tabindexNumber(self.tabindex)    # validate type tabindexNumber
        super(a, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(a, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class a


class span(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, lang: 'xs_string' = None, dir: 'dirType' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("span"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, span)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if span.subclass:
            return span.subclass(*args_, **kwargs_)
        else:
            return span(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_dirType(self, value):
        # Validate type dirType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(span, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='span', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('span')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'span':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='span')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='span'):
        super(span, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='span')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='span', fromsubclass_=False, pretty_print=True):
        super(span, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id'',''class'',''style'',''title'',''lang'',''lang'',''dir']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(self.title)    # validate type Text
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType(self.dir)    # validate type dirType
        super(span, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(span, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class span


class bdo(Inline):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Inline
    def __init__(self, a: List_['a'] = None, br: List_['br'] = None, span: List_['span'] = None, bdo: List_['bdo'] = None, map: List_['map'] = None, img: List_['img'] = None, tt: List_['tt'] = None, i: List_['i'] = None, b: List_['b'] = None, big: List_['big'] = None, small: List_['small'] = None, em: List_['em'] = None, strong: List_['strong'] = None, dfn: List_['dfn'] = None, code: List_['code'] = None, q: List_['q'] = None, samp: List_['samp'] = None, kbd: List_['kbd'] = None, var: List_['var'] = None, cite: List_['cite'] = None, abbr: List_['abbr'] = None, acronym: List_['acronym'] = None, sub: List_['sub'] = None, sup: List_['sup'] = None, lang: 'xs_string' = None, dir: 'dirType1' = None, id: 'xs_string' = None, class_: 'xs_NMTOKENS' = None, style: 'StyleSheet' = None, title: 'Text' = None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = "xhtml"
        super(globals().get("bdo"), self).__init__(a, br, span, bdo, map, img, tt, i, b, big, small, em, strong, dfn, code, q, samp, kbd, var, cite, abbr, acronym, sub, sup, valueOf_, mixedclass_, content_,  **kwargs_)
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.lang = _cast(None, lang)
        self.lang_nsprefix_ = None
        self.dir = _cast(None, dir)
        self.dir_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.style = _cast(None, style)
        self.style_nsprefix_ = None
        self.title = _cast(None, title)
        self.title_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, bdo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if bdo.subclass:
            return bdo.subclass(*args_, **kwargs_)
        else:
            return bdo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_lang(self):
        return self.lang
    def set_lang(self, lang):
        self.lang = lang
    def get_dir(self):
        return self.dir
    def set_dir(self, dir):
        self.dir = dir
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_style(self):
        return self.style
    def set_style(self, style):
        self.style = style
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_dirType1(self, value):
        # Validate type dirType1, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ltr', 'rtl']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on dirType1' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_StyleSheet(self, value):
        # Validate type StyleSheet, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def validate_Text(self, value):
        # Validate type Text, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_ or
            super(bdo, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='bdo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('bdo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'bdo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='bdo')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='bdo'):
        super(bdo, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='bdo')
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' xml:lang=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')), ))
        if self.dir is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            outfile.write(' dir=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dir), input_name='dir')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (quote_attrib(self.class_), ))
        if self.style is not None and 'style' not in already_processed:
            already_processed.add('style')
            outfile.write(' style=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.style), input_name='style')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='xmlns:xhtml="http://www.w3.org/1999/xhtml"', name_='bdo', fromsubclass_=False, pretty_print=True):
        super(bdo, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['lang'',''lang'',''dir'',''id'',''class'',''style'',''title']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.lang is not None:
            json_dict['lang'] = self.lang
        if self.dir is not None:
            json_dict['dir'] = self.dir
        if self.id is not None:
            json_dict['id'] = self.id
        if self.class_ is not None:
            json_dict['class'] = self.class_
        if self.style is not None:
            json_dict['style'] = self.style
        if self.title is not None:
            json_dict['title'] = self.title
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('dir', node)
        if value is not None and 'dir' not in already_processed:
            already_processed.add('dir')
            self.dir = value
            self.dir = ' '.join(self.dir.split())
            self.validate_dirType1(self.dir)    # validate type dirType1
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        value = find_attr_value_('style', node)
        if value is not None and 'style' not in already_processed:
            already_processed.add('style')
            self.style = value
            self.validate_StyleSheet(self.style)    # validate type StyleSheet
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
            self.validate_Text(se