"""Module for aggregating results

This module has methods to aggregate answers and to estimate confidence in aggregated labels.
Use it when each task is assigned to several Tolokers.  Note, that aggregation runs on the Toloka server.

If you need advanced aggregation methods or want to run aggregation algorithms locally on your computer,
try [crowd-kit library](https://toloka.ai/en/docs/crowd-kit).
"""

__all__ = [
    'AggregatedSolutionType',
    'PoolAggregatedSolutionRequest',
    'TaskAggregatedSolutionRequest',
    'WeightedDynamicOverlapTaskAggregatedSolutionRequest',
    'AggregatedSolution',
]
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class AggregatedSolutionType(toloka.util._extendable_enum.ExtendableStrEnum):
    """An enumeration.
    """

    WEIGHTED_DYNAMIC_OVERLAP = 'WEIGHTED_DYNAMIC_OVERLAP'
    DAWID_SKENE = 'DAWID_SKENE'


class PoolAggregatedSolutionRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Parameters for aggregating results in a pool using the [aggregate_solutions_by_pool](toloka.client.TolokaClient.aggregate_solutions_by_pool.md) method.

    Attributes:
        type: Aggregation model:
            * `WEIGHTED_DYNAMIC_OVERLAP` — [Aggregation](https://toloka.ai/docs/guide/concepts/result-aggregation.html#aggr__aggr-by-skill) based on Tolokers' skill in a pool with a dynamic overlap.
            * `DAWID_SKENE` — [Dawid-Skene aggregation model](https://toloka.ai/docs/guide/concepts/result-aggregation.html#aggr__dawid-skene). It is used in pools without a dynamic overlap.
        pool_id: The ID of the pool.
        answer_weight_skill_id: The ID of the skill that determines the weight of the Toloker's responses.
        fields: Output data fields to aggregate. For the best results, each of these fields should have limited number of response options.
    """

    class Field(toloka.client.primitives.base.BaseTolokaObject):
        def __init__(self, *, name: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class PoolAggregatedSolutionRequest.Field.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        name: typing.Optional[str]

    def __init__(
        self,
        *,
        type: typing.Union[AggregatedSolutionType, str, None] = None,
        pool_id: typing.Optional[str] = None,
        answer_weight_skill_id: typing.Optional[str] = None,
        fields: typing.Optional[typing.List[Field]] = None
    ) -> None:
        """Method generated by attrs for class PoolAggregatedSolutionRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    type: typing.Optional[AggregatedSolutionType]
    pool_id: typing.Optional[str]
    answer_weight_skill_id: typing.Optional[str]
    fields: typing.Optional[typing.List[Field]]


class TaskAggregatedSolutionRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Base class with parameters to run aggregation for a single task.

    Attributes:
        task_id: The ID of the task.
        pool_id: The ID of the pool containing the task.
    """

    def __init__(
        self,
        *,
        task_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None
    ) -> None:
        """Method generated by attrs for class TaskAggregatedSolutionRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    task_id: typing.Optional[str]
    pool_id: typing.Optional[str]


class WeightedDynamicOverlapTaskAggregatedSolutionRequest(TaskAggregatedSolutionRequest):
    """Parameters to run weighted aggregation for a single task with a dynamic overlap.

    Attributes:
        task_id: The ID of the task.
        pool_id: The ID of the pool containing the task.
        answer_weight_skill_id: The ID of the skill that determines the weight of the Toloker's responses.
        fields: Output data fields to aggregate. For the best results, each of these fields should have limited number of response options.
    """

    class Field(toloka.client.primitives.base.BaseTolokaObject):
        def __init__(self, *, name: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class WeightedDynamicOverlapTaskAggregatedSolutionRequest.Field.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        name: typing.Optional[str]

    def __init__(
        self,
        *,
        task_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        answer_weight_skill_id: typing.Optional[str] = None,
        fields: typing.Optional[typing.List[Field]] = None
    ) -> None:
        """Method generated by attrs for class WeightedDynamicOverlapTaskAggregatedSolutionRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    task_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    answer_weight_skill_id: typing.Optional[str]
    fields: typing.Optional[typing.List[Field]]


class AggregatedSolution(toloka.client.primitives.base.BaseTolokaObject):
    """An aggregated response to a task.

    Attributes:
        pool_id: The ID of the pool containing the task.
        task_id: The ID of the task.
        confidence: The confidence level for the aggregated response.
        output_values: Output data fields with aggregated responses.
    """

    def __init__(
        self,
        *,
        pool_id: typing.Optional[str] = None,
        task_id: typing.Optional[str] = None,
        confidence: typing.Optional[float] = None,
        output_values: typing.Optional[typing.Dict[str, typing.Any]] = None
    ) -> None:
        """Method generated by attrs for class AggregatedSolution.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    pool_id: typing.Optional[str]
    task_id: typing.Optional[str]
    confidence: typing.Optional[float]
    output_values: typing.Optional[typing.Dict[str, typing.Any]]
