__all__ = [
    'SpecClassIdentificationError',
    'ApiError',
    'ValidationApiError',
    'InternalApiError',
    'AuthenticationApiError',
    'AccessDeniedApiError',
    'RemoteServiceUnavailableApiError',
    'DoesNotExistApiError',
    'ConflictStateApiError',
    'TooManyRequestsApiError',
    'IncorrectActionsApiError',
    'raise_on_api_error',
    'FailedOperation',
]
import requests.models
import typing


class SpecClassIdentificationError(Exception):
    """Raised when cannot find spec_сlass for spec_field value.

    Attributes:
        spec_field: value that defines spec_class type
        spec_enum: enum class containing spec_class possible types
    """

    def __init__(
        self,
        *,
        spec_field: typing.Optional[str] = None,
        spec_enum: typing.Optional[str] = None
    ) -> None:
        """Method generated by attrs for class SpecClassIdentificationError.
        """
        ...

    spec_field: typing.Optional[str]
    spec_enum: typing.Optional[str]


class FailedOperation(Exception):
    """Raised when an operation failed.

    Could be raised when an inner operation failed.

    Attributes:
        operation: Instance of failed operation.
    """

    def __init__(self, *, operation: typing.Optional[typing.Any] = None) -> None:
        """Method generated by attrs for class FailedOperation.
        """
        ...

    operation: typing.Optional[typing.Any]


class ApiError(Exception):
    """Error returned from the API Call.

    Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    def __init__(
        self,
        *,
        status_code: typing.Optional[int] = None,
        request_id: typing.Optional[str] = None,
        code: typing.Optional[str] = None,
        message: typing.Optional[str] = None,
        payload: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class ApiError.
        """
        ...

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class ValidationApiError(ApiError):
    """Field validation error returned from the API Call.

    Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
        invalid_fields: the list of the invalid fields
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]
    _invalid_fields: typing.Optional[typing.List[str]]


class InternalApiError(ApiError):
    """Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class AuthenticationApiError(ApiError):
    """Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class AccessDeniedApiError(ApiError):
    """Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class RemoteServiceUnavailableApiError(ApiError):
    """Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class DoesNotExistApiError(ApiError):
    """Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class ConflictStateApiError(ApiError):
    """Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class TooManyRequestsApiError(ApiError):
    """Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class IncorrectActionsApiError(ApiError):
    """Attributes:
        status_code: response status code.
        request_id: request ID
        code: error code string
        message: error message
        payload: additional payload
    """

    status_code: typing.Optional[int]
    request_id: typing.Optional[str]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


def raise_on_api_error(response: requests.models.Response): ...
