__all__ = [
    'OperationLogItem',
]
import toloka.client.primitives.base
import typing


class OperationLogItem(toloka.client.primitives.base.BaseTolokaObject):
    """Objects of which the operation log consists

    Contains information about the validation errors and what sets of objects were created.

    Attributes:
        type: Type of action in the operation step.
        success: Result of the step (true or false).
        input: Input data at the operation step.
        output: Operation step output. Depends on the type.
    """

    def __init__(
        self,
        *,
        type: typing.Optional[str] = None,
        success: typing.Optional[bool] = None,
        input: typing.Optional[typing.Dict[str, typing.Any]] = None,
        output: typing.Optional[typing.Dict[str, typing.Any]] = None
    ) -> None:
        """Method generated by attrs for class OperationLogItem.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    type: typing.Optional[str]
    success: typing.Optional[bool]
    input: typing.Optional[typing.Dict[str, typing.Any]]
    output: typing.Optional[typing.Dict[str, typing.Any]]
